# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CasterArgs', 'Caster']

@pulumi.input_type
class CasterArgs:
    def __init__(__self__, *,
                 norm_type: pulumi.Input[_builtins.int],
                 payment_type: pulumi.Input[_builtins.str],
                 auto_switch_urgent_config: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_switch_urgent_on: Optional[pulumi.Input[_builtins.bool]] = None,
                 callback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 caster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delay: Optional[pulumi.Input[_builtins.float]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 program_effect: Optional[pulumi.Input[_builtins.int]] = None,
                 program_name: Optional[pulumi.Input[_builtins.str]] = None,
                 record_config: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 side_output_url: Optional[pulumi.Input[_builtins.str]] = None,
                 side_output_url_list: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_groups_config: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transcode_config: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_image_url: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_live_stream_url: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_material_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Caster resource.
        :param pulumi.Input[_builtins.int] norm_type: Guide station specification type. Value:
               - 0: Broadcast single type.
               - 1: General purpose.
        :param pulumi.Input[_builtins.str] payment_type: The paymen type of the resource
        :param pulumi.Input[_builtins.str] auto_switch_urgent_config: Automatic standby broadcast configuration. eofThres: indicates that the broadcast is automatically cut and prepared after the flow interruption time, in seconds.
        :param pulumi.Input[_builtins.bool] auto_switch_urgent_on: Turn on the cut-off automatic switch for broadcast preparation.
               
               true: open.
               
               false: closed.
        :param pulumi.Input[_builtins.str] callback_url: The callback address of the user. To receive Callback Notifications, enter an available address and accept the HTTP protocol. If this parameter is set to null, the callback notification from the director Station is canceled by default.
        :param pulumi.Input[_builtins.str] caster_name: Guide station name.
        :param pulumi.Input[_builtins.float] delay: Delayed playback. Time unit: seconds.
        :param pulumi.Input[_builtins.str] domain_name: Master play domain name.
        :param pulumi.Input[_builtins.int] program_effect: Carousel effective flag.
               
               0: Not in effect.
               
               1: Entry into force.
        :param pulumi.Input[_builtins.str] program_name: The carousel station name, which can be configured when using the carousel function.
        :param pulumi.Input[_builtins.str] record_config: Record configuration information. The format is JSON. The configuration element information is as follows:
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group id
        :param pulumi.Input[_builtins.str] resource_type: resource type
        :param pulumi.Input[_builtins.str] side_output_url: The user-defined stream ingest address corresponding to the bypass output address of the guide station. If this parameter is left blank, the streaming address corresponding to the output address automatically generated by Alibaba Cloud is used by default.
        :param pulumi.Input[_builtins.str] side_output_url_list: The list of multiple forwarding stream addresses, which can be the CDN forwarding stream addresses of Alibaba Cloud or a third-party vendor. A guide can add up to 20 RTMP forwarding addresses.
        :param pulumi.Input[_builtins.str] sync_groups_config: Multi-View synchronization configuration to synchronize multiple video sources. Multi-View synchronization is divided into two modes:
               - `mode 0`: (In the anchor mode, multiple video sources are synchronized according to the specified mode.)
               - `mode 1`: (Conference mode, there is no concept of anchor video, all video sources are synchronized with each other.)
               - `Anchor mode`: hostResourceId: the video source of the anchor in Anchor mode.
               - `Conference mode`: no hostRsoureId field, only the resource ids in the resourceIds to be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transcode_config: Transcoding configuration.
               
               JSON format string, Please capitalize the first letter of the internal field of the structure, hump format input. If this parameter is set to null, the transcoding configuration is cleared by default. If the transcoding template is null, an error is reported when the director starts.
        :param pulumi.Input[_builtins.str] urgent_image_id: The ID of the picture material of the media library.
        :param pulumi.Input[_builtins.str] urgent_image_url: Prepare the URL of the picture material.
        :param pulumi.Input[_builtins.str] urgent_live_stream_url: The prepared live stream URL.
        :param pulumi.Input[_builtins.str] urgent_material_id: Prepared video, media library material ID. If this parameter is set to null, the standby configuration is cleared by default.
        """
        pulumi.set(__self__, "norm_type", norm_type)
        pulumi.set(__self__, "payment_type", payment_type)
        if auto_switch_urgent_config is not None:
            pulumi.set(__self__, "auto_switch_urgent_config", auto_switch_urgent_config)
        if auto_switch_urgent_on is not None:
            pulumi.set(__self__, "auto_switch_urgent_on", auto_switch_urgent_on)
        if callback_url is not None:
            pulumi.set(__self__, "callback_url", callback_url)
        if caster_name is not None:
            pulumi.set(__self__, "caster_name", caster_name)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if program_effect is not None:
            pulumi.set(__self__, "program_effect", program_effect)
        if program_name is not None:
            pulumi.set(__self__, "program_name", program_name)
        if record_config is not None:
            pulumi.set(__self__, "record_config", record_config)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if side_output_url is not None:
            pulumi.set(__self__, "side_output_url", side_output_url)
        if side_output_url_list is not None:
            pulumi.set(__self__, "side_output_url_list", side_output_url_list)
        if sync_groups_config is not None:
            pulumi.set(__self__, "sync_groups_config", sync_groups_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transcode_config is not None:
            pulumi.set(__self__, "transcode_config", transcode_config)
        if urgent_image_id is not None:
            pulumi.set(__self__, "urgent_image_id", urgent_image_id)
        if urgent_image_url is not None:
            pulumi.set(__self__, "urgent_image_url", urgent_image_url)
        if urgent_live_stream_url is not None:
            pulumi.set(__self__, "urgent_live_stream_url", urgent_live_stream_url)
        if urgent_material_id is not None:
            pulumi.set(__self__, "urgent_material_id", urgent_material_id)

    @_builtins.property
    @pulumi.getter(name="normType")
    def norm_type(self) -> pulumi.Input[_builtins.int]:
        """
        Guide station specification type. Value:
        - 0: Broadcast single type.
        - 1: General purpose.
        """
        return pulumi.get(self, "norm_type")

    @norm_type.setter
    def norm_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "norm_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The paymen type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="autoSwitchUrgentConfig")
    def auto_switch_urgent_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic standby broadcast configuration. eofThres: indicates that the broadcast is automatically cut and prepared after the flow interruption time, in seconds.
        """
        return pulumi.get(self, "auto_switch_urgent_config")

    @auto_switch_urgent_config.setter
    def auto_switch_urgent_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_switch_urgent_config", value)

    @_builtins.property
    @pulumi.getter(name="autoSwitchUrgentOn")
    def auto_switch_urgent_on(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Turn on the cut-off automatic switch for broadcast preparation.

        true: open.

        false: closed.
        """
        return pulumi.get(self, "auto_switch_urgent_on")

    @auto_switch_urgent_on.setter
    def auto_switch_urgent_on(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_switch_urgent_on", value)

    @_builtins.property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The callback address of the user. To receive Callback Notifications, enter an available address and accept the HTTP protocol. If this parameter is set to null, the callback notification from the director Station is canceled by default.
        """
        return pulumi.get(self, "callback_url")

    @callback_url.setter
    def callback_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "callback_url", value)

    @_builtins.property
    @pulumi.getter(name="casterName")
    def caster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Guide station name.
        """
        return pulumi.get(self, "caster_name")

    @caster_name.setter
    def caster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "caster_name", value)

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Delayed playback. Time unit: seconds.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "delay", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Master play domain name.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="programEffect")
    def program_effect(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Carousel effective flag.

        0: Not in effect.

        1: Entry into force.
        """
        return pulumi.get(self, "program_effect")

    @program_effect.setter
    def program_effect(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "program_effect", value)

    @_builtins.property
    @pulumi.getter(name="programName")
    def program_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The carousel station name, which can be configured when using the carousel function.
        """
        return pulumi.get(self, "program_name")

    @program_name.setter
    def program_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "program_name", value)

    @_builtins.property
    @pulumi.getter(name="recordConfig")
    def record_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record configuration information. The format is JSON. The configuration element information is as follows:
        """
        return pulumi.get(self, "record_config")

    @record_config.setter
    def record_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_config", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Group id
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        resource type
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="sideOutputUrl")
    def side_output_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-defined stream ingest address corresponding to the bypass output address of the guide station. If this parameter is left blank, the streaming address corresponding to the output address automatically generated by Alibaba Cloud is used by default.
        """
        return pulumi.get(self, "side_output_url")

    @side_output_url.setter
    def side_output_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "side_output_url", value)

    @_builtins.property
    @pulumi.getter(name="sideOutputUrlList")
    def side_output_url_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of multiple forwarding stream addresses, which can be the CDN forwarding stream addresses of Alibaba Cloud or a third-party vendor. A guide can add up to 20 RTMP forwarding addresses.
        """
        return pulumi.get(self, "side_output_url_list")

    @side_output_url_list.setter
    def side_output_url_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "side_output_url_list", value)

    @_builtins.property
    @pulumi.getter(name="syncGroupsConfig")
    def sync_groups_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Multi-View synchronization configuration to synchronize multiple video sources. Multi-View synchronization is divided into two modes:
        - `mode 0`: (In the anchor mode, multiple video sources are synchronized according to the specified mode.)
        - `mode 1`: (Conference mode, there is no concept of anchor video, all video sources are synchronized with each other.)
        - `Anchor mode`: hostResourceId: the video source of the anchor in Anchor mode.
        - `Conference mode`: no hostRsoureId field, only the resource ids in the resourceIds to be provided.
        """
        return pulumi.get(self, "sync_groups_config")

    @sync_groups_config.setter
    def sync_groups_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_groups_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transcodeConfig")
    def transcode_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Transcoding configuration.

        JSON format string, Please capitalize the first letter of the internal field of the structure, hump format input. If this parameter is set to null, the transcoding configuration is cleared by default. If the transcoding template is null, an error is reported when the director starts.
        """
        return pulumi.get(self, "transcode_config")

    @transcode_config.setter
    def transcode_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transcode_config", value)

    @_builtins.property
    @pulumi.getter(name="urgentImageId")
    def urgent_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the picture material of the media library.
        """
        return pulumi.get(self, "urgent_image_id")

    @urgent_image_id.setter
    def urgent_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "urgent_image_id", value)

    @_builtins.property
    @pulumi.getter(name="urgentImageUrl")
    def urgent_image_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prepare the URL of the picture material.
        """
        return pulumi.get(self, "urgent_image_url")

    @urgent_image_url.setter
    def urgent_image_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "urgent_image_url", value)

    @_builtins.property
    @pulumi.getter(name="urgentLiveStreamUrl")
    def urgent_live_stream_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prepared live stream URL.
        """
        return pulumi.get(self, "urgent_live_stream_url")

    @urgent_live_stream_url.setter
    def urgent_live_stream_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "urgent_live_stream_url", value)

    @_builtins.property
    @pulumi.getter(name="urgentMaterialId")
    def urgent_material_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prepared video, media library material ID. If this parameter is set to null, the standby configuration is cleared by default.
        """
        return pulumi.get(self, "urgent_material_id")

    @urgent_material_id.setter
    def urgent_material_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "urgent_material_id", value)


@pulumi.input_type
class _CasterState:
    def __init__(__self__, *,
                 auto_switch_urgent_config: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_switch_urgent_on: Optional[pulumi.Input[_builtins.bool]] = None,
                 callback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 caster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delay: Optional[pulumi.Input[_builtins.float]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 norm_type: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 program_effect: Optional[pulumi.Input[_builtins.int]] = None,
                 program_name: Optional[pulumi.Input[_builtins.str]] = None,
                 record_config: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 side_output_url: Optional[pulumi.Input[_builtins.str]] = None,
                 side_output_url_list: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_groups_config: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transcode_config: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_image_url: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_live_stream_url: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_material_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Caster resources.
        :param pulumi.Input[_builtins.str] auto_switch_urgent_config: Automatic standby broadcast configuration. eofThres: indicates that the broadcast is automatically cut and prepared after the flow interruption time, in seconds.
        :param pulumi.Input[_builtins.bool] auto_switch_urgent_on: Turn on the cut-off automatic switch for broadcast preparation.
               
               true: open.
               
               false: closed.
        :param pulumi.Input[_builtins.str] callback_url: The callback address of the user. To receive Callback Notifications, enter an available address and accept the HTTP protocol. If this parameter is set to null, the callback notification from the director Station is canceled by default.
        :param pulumi.Input[_builtins.str] caster_name: Guide station name.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.float] delay: Delayed playback. Time unit: seconds.
        :param pulumi.Input[_builtins.str] domain_name: Master play domain name.
        :param pulumi.Input[_builtins.int] norm_type: Guide station specification type. Value:
               - 0: Broadcast single type.
               - 1: General purpose.
        :param pulumi.Input[_builtins.str] payment_type: The paymen type of the resource
        :param pulumi.Input[_builtins.int] program_effect: Carousel effective flag.
               
               0: Not in effect.
               
               1: Entry into force.
        :param pulumi.Input[_builtins.str] program_name: The carousel station name, which can be configured when using the carousel function.
        :param pulumi.Input[_builtins.str] record_config: Record configuration information. The format is JSON. The configuration element information is as follows:
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group id
        :param pulumi.Input[_builtins.str] resource_type: resource type
        :param pulumi.Input[_builtins.str] side_output_url: The user-defined stream ingest address corresponding to the bypass output address of the guide station. If this parameter is left blank, the streaming address corresponding to the output address automatically generated by Alibaba Cloud is used by default.
        :param pulumi.Input[_builtins.str] side_output_url_list: The list of multiple forwarding stream addresses, which can be the CDN forwarding stream addresses of Alibaba Cloud or a third-party vendor. A guide can add up to 20 RTMP forwarding addresses.
        :param pulumi.Input[_builtins.str] sync_groups_config: Multi-View synchronization configuration to synchronize multiple video sources. Multi-View synchronization is divided into two modes:
               - `mode 0`: (In the anchor mode, multiple video sources are synchronized according to the specified mode.)
               - `mode 1`: (Conference mode, there is no concept of anchor video, all video sources are synchronized with each other.)
               - `Anchor mode`: hostResourceId: the video source of the anchor in Anchor mode.
               - `Conference mode`: no hostRsoureId field, only the resource ids in the resourceIds to be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transcode_config: Transcoding configuration.
               
               JSON format string, Please capitalize the first letter of the internal field of the structure, hump format input. If this parameter is set to null, the transcoding configuration is cleared by default. If the transcoding template is null, an error is reported when the director starts.
        :param pulumi.Input[_builtins.str] urgent_image_id: The ID of the picture material of the media library.
        :param pulumi.Input[_builtins.str] urgent_image_url: Prepare the URL of the picture material.
        :param pulumi.Input[_builtins.str] urgent_live_stream_url: The prepared live stream URL.
        :param pulumi.Input[_builtins.str] urgent_material_id: Prepared video, media library material ID. If this parameter is set to null, the standby configuration is cleared by default.
        """
        if auto_switch_urgent_config is not None:
            pulumi.set(__self__, "auto_switch_urgent_config", auto_switch_urgent_config)
        if auto_switch_urgent_on is not None:
            pulumi.set(__self__, "auto_switch_urgent_on", auto_switch_urgent_on)
        if callback_url is not None:
            pulumi.set(__self__, "callback_url", callback_url)
        if caster_name is not None:
            pulumi.set(__self__, "caster_name", caster_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if norm_type is not None:
            pulumi.set(__self__, "norm_type", norm_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if program_effect is not None:
            pulumi.set(__self__, "program_effect", program_effect)
        if program_name is not None:
            pulumi.set(__self__, "program_name", program_name)
        if record_config is not None:
            pulumi.set(__self__, "record_config", record_config)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if side_output_url is not None:
            pulumi.set(__self__, "side_output_url", side_output_url)
        if side_output_url_list is not None:
            pulumi.set(__self__, "side_output_url_list", side_output_url_list)
        if sync_groups_config is not None:
            pulumi.set(__self__, "sync_groups_config", sync_groups_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transcode_config is not None:
            pulumi.set(__self__, "transcode_config", transcode_config)
        if urgent_image_id is not None:
            pulumi.set(__self__, "urgent_image_id", urgent_image_id)
        if urgent_image_url is not None:
            pulumi.set(__self__, "urgent_image_url", urgent_image_url)
        if urgent_live_stream_url is not None:
            pulumi.set(__self__, "urgent_live_stream_url", urgent_live_stream_url)
        if urgent_material_id is not None:
            pulumi.set(__self__, "urgent_material_id", urgent_material_id)

    @_builtins.property
    @pulumi.getter(name="autoSwitchUrgentConfig")
    def auto_switch_urgent_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic standby broadcast configuration. eofThres: indicates that the broadcast is automatically cut and prepared after the flow interruption time, in seconds.
        """
        return pulumi.get(self, "auto_switch_urgent_config")

    @auto_switch_urgent_config.setter
    def auto_switch_urgent_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_switch_urgent_config", value)

    @_builtins.property
    @pulumi.getter(name="autoSwitchUrgentOn")
    def auto_switch_urgent_on(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Turn on the cut-off automatic switch for broadcast preparation.

        true: open.

        false: closed.
        """
        return pulumi.get(self, "auto_switch_urgent_on")

    @auto_switch_urgent_on.setter
    def auto_switch_urgent_on(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_switch_urgent_on", value)

    @_builtins.property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The callback address of the user. To receive Callback Notifications, enter an available address and accept the HTTP protocol. If this parameter is set to null, the callback notification from the director Station is canceled by default.
        """
        return pulumi.get(self, "callback_url")

    @callback_url.setter
    def callback_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "callback_url", value)

    @_builtins.property
    @pulumi.getter(name="casterName")
    def caster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Guide station name.
        """
        return pulumi.get(self, "caster_name")

    @caster_name.setter
    def caster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "caster_name", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Delayed playback. Time unit: seconds.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "delay", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Master play domain name.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="normType")
    def norm_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Guide station specification type. Value:
        - 0: Broadcast single type.
        - 1: General purpose.
        """
        return pulumi.get(self, "norm_type")

    @norm_type.setter
    def norm_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "norm_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The paymen type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="programEffect")
    def program_effect(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Carousel effective flag.

        0: Not in effect.

        1: Entry into force.
        """
        return pulumi.get(self, "program_effect")

    @program_effect.setter
    def program_effect(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "program_effect", value)

    @_builtins.property
    @pulumi.getter(name="programName")
    def program_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The carousel station name, which can be configured when using the carousel function.
        """
        return pulumi.get(self, "program_name")

    @program_name.setter
    def program_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "program_name", value)

    @_builtins.property
    @pulumi.getter(name="recordConfig")
    def record_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record configuration information. The format is JSON. The configuration element information is as follows:
        """
        return pulumi.get(self, "record_config")

    @record_config.setter
    def record_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_config", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Group id
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        resource type
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="sideOutputUrl")
    def side_output_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-defined stream ingest address corresponding to the bypass output address of the guide station. If this parameter is left blank, the streaming address corresponding to the output address automatically generated by Alibaba Cloud is used by default.
        """
        return pulumi.get(self, "side_output_url")

    @side_output_url.setter
    def side_output_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "side_output_url", value)

    @_builtins.property
    @pulumi.getter(name="sideOutputUrlList")
    def side_output_url_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of multiple forwarding stream addresses, which can be the CDN forwarding stream addresses of Alibaba Cloud or a third-party vendor. A guide can add up to 20 RTMP forwarding addresses.
        """
        return pulumi.get(self, "side_output_url_list")

    @side_output_url_list.setter
    def side_output_url_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "side_output_url_list", value)

    @_builtins.property
    @pulumi.getter(name="syncGroupsConfig")
    def sync_groups_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Multi-View synchronization configuration to synchronize multiple video sources. Multi-View synchronization is divided into two modes:
        - `mode 0`: (In the anchor mode, multiple video sources are synchronized according to the specified mode.)
        - `mode 1`: (Conference mode, there is no concept of anchor video, all video sources are synchronized with each other.)
        - `Anchor mode`: hostResourceId: the video source of the anchor in Anchor mode.
        - `Conference mode`: no hostRsoureId field, only the resource ids in the resourceIds to be provided.
        """
        return pulumi.get(self, "sync_groups_config")

    @sync_groups_config.setter
    def sync_groups_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_groups_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transcodeConfig")
    def transcode_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Transcoding configuration.

        JSON format string, Please capitalize the first letter of the internal field of the structure, hump format input. If this parameter is set to null, the transcoding configuration is cleared by default. If the transcoding template is null, an error is reported when the director starts.
        """
        return pulumi.get(self, "transcode_config")

    @transcode_config.setter
    def transcode_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transcode_config", value)

    @_builtins.property
    @pulumi.getter(name="urgentImageId")
    def urgent_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the picture material of the media library.
        """
        return pulumi.get(self, "urgent_image_id")

    @urgent_image_id.setter
    def urgent_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "urgent_image_id", value)

    @_builtins.property
    @pulumi.getter(name="urgentImageUrl")
    def urgent_image_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prepare the URL of the picture material.
        """
        return pulumi.get(self, "urgent_image_url")

    @urgent_image_url.setter
    def urgent_image_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "urgent_image_url", value)

    @_builtins.property
    @pulumi.getter(name="urgentLiveStreamUrl")
    def urgent_live_stream_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prepared live stream URL.
        """
        return pulumi.get(self, "urgent_live_stream_url")

    @urgent_live_stream_url.setter
    def urgent_live_stream_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "urgent_live_stream_url", value)

    @_builtins.property
    @pulumi.getter(name="urgentMaterialId")
    def urgent_material_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prepared video, media library material ID. If this parameter is set to null, the standby configuration is cleared by default.
        """
        return pulumi.get(self, "urgent_material_id")

    @urgent_material_id.setter
    def urgent_material_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "urgent_material_id", value)


@pulumi.type_token("alicloud:live/caster:Caster")
class Caster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_switch_urgent_config: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_switch_urgent_on: Optional[pulumi.Input[_builtins.bool]] = None,
                 callback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 caster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delay: Optional[pulumi.Input[_builtins.float]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 norm_type: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 program_effect: Optional[pulumi.Input[_builtins.int]] = None,
                 program_name: Optional[pulumi.Input[_builtins.str]] = None,
                 record_config: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 side_output_url: Optional[pulumi.Input[_builtins.str]] = None,
                 side_output_url_list: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_groups_config: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transcode_config: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_image_url: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_live_stream_url: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_material_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Live Caster resource.

        Relying on Alibaba Cloud's powerful technologies such as live video broadcasting, media processing, and video AI, cloud guide integrates capabilities such as graphic packaging, real-time keying, multi-language translation, and multi-channel mixed streaming to innovate traditional guide services in the cloud. Provide easy-to-use cloud-based guide services for event performances, news reports, live events, off-site broadcasts and other scenes, without hardware, reduce user guide costs, and create a better live broadcast experience.

        For information about Live Caster and how to use it, see [What is Caster](https://www.alibabacloud.com/help/en/live/developer-reference/api-live-2016-11-01-createcaster).

        > **NOTE:** Available since v1.238.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.live.Caster("default",
            caster_name=name,
            payment_type="PayAsYouGo",
            norm_type=1)
        ```

        ## Import

        Live Caster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:live/caster:Caster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_switch_urgent_config: Automatic standby broadcast configuration. eofThres: indicates that the broadcast is automatically cut and prepared after the flow interruption time, in seconds.
        :param pulumi.Input[_builtins.bool] auto_switch_urgent_on: Turn on the cut-off automatic switch for broadcast preparation.
               
               true: open.
               
               false: closed.
        :param pulumi.Input[_builtins.str] callback_url: The callback address of the user. To receive Callback Notifications, enter an available address and accept the HTTP protocol. If this parameter is set to null, the callback notification from the director Station is canceled by default.
        :param pulumi.Input[_builtins.str] caster_name: Guide station name.
        :param pulumi.Input[_builtins.float] delay: Delayed playback. Time unit: seconds.
        :param pulumi.Input[_builtins.str] domain_name: Master play domain name.
        :param pulumi.Input[_builtins.int] norm_type: Guide station specification type. Value:
               - 0: Broadcast single type.
               - 1: General purpose.
        :param pulumi.Input[_builtins.str] payment_type: The paymen type of the resource
        :param pulumi.Input[_builtins.int] program_effect: Carousel effective flag.
               
               0: Not in effect.
               
               1: Entry into force.
        :param pulumi.Input[_builtins.str] program_name: The carousel station name, which can be configured when using the carousel function.
        :param pulumi.Input[_builtins.str] record_config: Record configuration information. The format is JSON. The configuration element information is as follows:
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group id
        :param pulumi.Input[_builtins.str] resource_type: resource type
        :param pulumi.Input[_builtins.str] side_output_url: The user-defined stream ingest address corresponding to the bypass output address of the guide station. If this parameter is left blank, the streaming address corresponding to the output address automatically generated by Alibaba Cloud is used by default.
        :param pulumi.Input[_builtins.str] side_output_url_list: The list of multiple forwarding stream addresses, which can be the CDN forwarding stream addresses of Alibaba Cloud or a third-party vendor. A guide can add up to 20 RTMP forwarding addresses.
        :param pulumi.Input[_builtins.str] sync_groups_config: Multi-View synchronization configuration to synchronize multiple video sources. Multi-View synchronization is divided into two modes:
               - `mode 0`: (In the anchor mode, multiple video sources are synchronized according to the specified mode.)
               - `mode 1`: (Conference mode, there is no concept of anchor video, all video sources are synchronized with each other.)
               - `Anchor mode`: hostResourceId: the video source of the anchor in Anchor mode.
               - `Conference mode`: no hostRsoureId field, only the resource ids in the resourceIds to be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transcode_config: Transcoding configuration.
               
               JSON format string, Please capitalize the first letter of the internal field of the structure, hump format input. If this parameter is set to null, the transcoding configuration is cleared by default. If the transcoding template is null, an error is reported when the director starts.
        :param pulumi.Input[_builtins.str] urgent_image_id: The ID of the picture material of the media library.
        :param pulumi.Input[_builtins.str] urgent_image_url: Prepare the URL of the picture material.
        :param pulumi.Input[_builtins.str] urgent_live_stream_url: The prepared live stream URL.
        :param pulumi.Input[_builtins.str] urgent_material_id: Prepared video, media library material ID. If this parameter is set to null, the standby configuration is cleared by default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CasterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Live Caster resource.

        Relying on Alibaba Cloud's powerful technologies such as live video broadcasting, media processing, and video AI, cloud guide integrates capabilities such as graphic packaging, real-time keying, multi-language translation, and multi-channel mixed streaming to innovate traditional guide services in the cloud. Provide easy-to-use cloud-based guide services for event performances, news reports, live events, off-site broadcasts and other scenes, without hardware, reduce user guide costs, and create a better live broadcast experience.

        For information about Live Caster and how to use it, see [What is Caster](https://www.alibabacloud.com/help/en/live/developer-reference/api-live-2016-11-01-createcaster).

        > **NOTE:** Available since v1.238.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.live.Caster("default",
            caster_name=name,
            payment_type="PayAsYouGo",
            norm_type=1)
        ```

        ## Import

        Live Caster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:live/caster:Caster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CasterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CasterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_switch_urgent_config: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_switch_urgent_on: Optional[pulumi.Input[_builtins.bool]] = None,
                 callback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 caster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delay: Optional[pulumi.Input[_builtins.float]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 norm_type: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 program_effect: Optional[pulumi.Input[_builtins.int]] = None,
                 program_name: Optional[pulumi.Input[_builtins.str]] = None,
                 record_config: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 side_output_url: Optional[pulumi.Input[_builtins.str]] = None,
                 side_output_url_list: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_groups_config: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transcode_config: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_image_url: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_live_stream_url: Optional[pulumi.Input[_builtins.str]] = None,
                 urgent_material_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CasterArgs.__new__(CasterArgs)

            __props__.__dict__["auto_switch_urgent_config"] = auto_switch_urgent_config
            __props__.__dict__["auto_switch_urgent_on"] = auto_switch_urgent_on
            __props__.__dict__["callback_url"] = callback_url
            __props__.__dict__["caster_name"] = caster_name
            __props__.__dict__["delay"] = delay
            __props__.__dict__["domain_name"] = domain_name
            if norm_type is None and not opts.urn:
                raise TypeError("Missing required property 'norm_type'")
            __props__.__dict__["norm_type"] = norm_type
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["program_effect"] = program_effect
            __props__.__dict__["program_name"] = program_name
            __props__.__dict__["record_config"] = record_config
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["side_output_url"] = side_output_url
            __props__.__dict__["side_output_url_list"] = side_output_url_list
            __props__.__dict__["sync_groups_config"] = sync_groups_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transcode_config"] = transcode_config
            __props__.__dict__["urgent_image_id"] = urgent_image_id
            __props__.__dict__["urgent_image_url"] = urgent_image_url
            __props__.__dict__["urgent_live_stream_url"] = urgent_live_stream_url
            __props__.__dict__["urgent_material_id"] = urgent_material_id
            __props__.__dict__["create_time"] = None
        super(Caster, __self__).__init__(
            'alicloud:live/caster:Caster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_switch_urgent_config: Optional[pulumi.Input[_builtins.str]] = None,
            auto_switch_urgent_on: Optional[pulumi.Input[_builtins.bool]] = None,
            callback_url: Optional[pulumi.Input[_builtins.str]] = None,
            caster_name: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delay: Optional[pulumi.Input[_builtins.float]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            norm_type: Optional[pulumi.Input[_builtins.int]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            program_effect: Optional[pulumi.Input[_builtins.int]] = None,
            program_name: Optional[pulumi.Input[_builtins.str]] = None,
            record_config: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            side_output_url: Optional[pulumi.Input[_builtins.str]] = None,
            side_output_url_list: Optional[pulumi.Input[_builtins.str]] = None,
            sync_groups_config: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transcode_config: Optional[pulumi.Input[_builtins.str]] = None,
            urgent_image_id: Optional[pulumi.Input[_builtins.str]] = None,
            urgent_image_url: Optional[pulumi.Input[_builtins.str]] = None,
            urgent_live_stream_url: Optional[pulumi.Input[_builtins.str]] = None,
            urgent_material_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Caster':
        """
        Get an existing Caster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_switch_urgent_config: Automatic standby broadcast configuration. eofThres: indicates that the broadcast is automatically cut and prepared after the flow interruption time, in seconds.
        :param pulumi.Input[_builtins.bool] auto_switch_urgent_on: Turn on the cut-off automatic switch for broadcast preparation.
               
               true: open.
               
               false: closed.
        :param pulumi.Input[_builtins.str] callback_url: The callback address of the user. To receive Callback Notifications, enter an available address and accept the HTTP protocol. If this parameter is set to null, the callback notification from the director Station is canceled by default.
        :param pulumi.Input[_builtins.str] caster_name: Guide station name.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.float] delay: Delayed playback. Time unit: seconds.
        :param pulumi.Input[_builtins.str] domain_name: Master play domain name.
        :param pulumi.Input[_builtins.int] norm_type: Guide station specification type. Value:
               - 0: Broadcast single type.
               - 1: General purpose.
        :param pulumi.Input[_builtins.str] payment_type: The paymen type of the resource
        :param pulumi.Input[_builtins.int] program_effect: Carousel effective flag.
               
               0: Not in effect.
               
               1: Entry into force.
        :param pulumi.Input[_builtins.str] program_name: The carousel station name, which can be configured when using the carousel function.
        :param pulumi.Input[_builtins.str] record_config: Record configuration information. The format is JSON. The configuration element information is as follows:
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group id
        :param pulumi.Input[_builtins.str] resource_type: resource type
        :param pulumi.Input[_builtins.str] side_output_url: The user-defined stream ingest address corresponding to the bypass output address of the guide station. If this parameter is left blank, the streaming address corresponding to the output address automatically generated by Alibaba Cloud is used by default.
        :param pulumi.Input[_builtins.str] side_output_url_list: The list of multiple forwarding stream addresses, which can be the CDN forwarding stream addresses of Alibaba Cloud or a third-party vendor. A guide can add up to 20 RTMP forwarding addresses.
        :param pulumi.Input[_builtins.str] sync_groups_config: Multi-View synchronization configuration to synchronize multiple video sources. Multi-View synchronization is divided into two modes:
               - `mode 0`: (In the anchor mode, multiple video sources are synchronized according to the specified mode.)
               - `mode 1`: (Conference mode, there is no concept of anchor video, all video sources are synchronized with each other.)
               - `Anchor mode`: hostResourceId: the video source of the anchor in Anchor mode.
               - `Conference mode`: no hostRsoureId field, only the resource ids in the resourceIds to be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transcode_config: Transcoding configuration.
               
               JSON format string, Please capitalize the first letter of the internal field of the structure, hump format input. If this parameter is set to null, the transcoding configuration is cleared by default. If the transcoding template is null, an error is reported when the director starts.
        :param pulumi.Input[_builtins.str] urgent_image_id: The ID of the picture material of the media library.
        :param pulumi.Input[_builtins.str] urgent_image_url: Prepare the URL of the picture material.
        :param pulumi.Input[_builtins.str] urgent_live_stream_url: The prepared live stream URL.
        :param pulumi.Input[_builtins.str] urgent_material_id: Prepared video, media library material ID. If this parameter is set to null, the standby configuration is cleared by default.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CasterState.__new__(_CasterState)

        __props__.__dict__["auto_switch_urgent_config"] = auto_switch_urgent_config
        __props__.__dict__["auto_switch_urgent_on"] = auto_switch_urgent_on
        __props__.__dict__["callback_url"] = callback_url
        __props__.__dict__["caster_name"] = caster_name
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delay"] = delay
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["norm_type"] = norm_type
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["program_effect"] = program_effect
        __props__.__dict__["program_name"] = program_name
        __props__.__dict__["record_config"] = record_config
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["side_output_url"] = side_output_url
        __props__.__dict__["side_output_url_list"] = side_output_url_list
        __props__.__dict__["sync_groups_config"] = sync_groups_config
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transcode_config"] = transcode_config
        __props__.__dict__["urgent_image_id"] = urgent_image_id
        __props__.__dict__["urgent_image_url"] = urgent_image_url
        __props__.__dict__["urgent_live_stream_url"] = urgent_live_stream_url
        __props__.__dict__["urgent_material_id"] = urgent_material_id
        return Caster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoSwitchUrgentConfig")
    def auto_switch_urgent_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Automatic standby broadcast configuration. eofThres: indicates that the broadcast is automatically cut and prepared after the flow interruption time, in seconds.
        """
        return pulumi.get(self, "auto_switch_urgent_config")

    @_builtins.property
    @pulumi.getter(name="autoSwitchUrgentOn")
    def auto_switch_urgent_on(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Turn on the cut-off automatic switch for broadcast preparation.

        true: open.

        false: closed.
        """
        return pulumi.get(self, "auto_switch_urgent_on")

    @_builtins.property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The callback address of the user. To receive Callback Notifications, enter an available address and accept the HTTP protocol. If this parameter is set to null, the callback notification from the director Station is canceled by default.
        """
        return pulumi.get(self, "callback_url")

    @_builtins.property
    @pulumi.getter(name="casterName")
    def caster_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Guide station name.
        """
        return pulumi.get(self, "caster_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def delay(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Delayed playback. Time unit: seconds.
        """
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Master play domain name.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="normType")
    def norm_type(self) -> pulumi.Output[_builtins.int]:
        """
        Guide station specification type. Value:
        - 0: Broadcast single type.
        - 1: General purpose.
        """
        return pulumi.get(self, "norm_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The paymen type of the resource
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="programEffect")
    def program_effect(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Carousel effective flag.

        0: Not in effect.

        1: Entry into force.
        """
        return pulumi.get(self, "program_effect")

    @_builtins.property
    @pulumi.getter(name="programName")
    def program_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The carousel station name, which can be configured when using the carousel function.
        """
        return pulumi.get(self, "program_name")

    @_builtins.property
    @pulumi.getter(name="recordConfig")
    def record_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Record configuration information. The format is JSON. The configuration element information is as follows:
        """
        return pulumi.get(self, "record_config")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource Group id
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        resource type
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="sideOutputUrl")
    def side_output_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user-defined stream ingest address corresponding to the bypass output address of the guide station. If this parameter is left blank, the streaming address corresponding to the output address automatically generated by Alibaba Cloud is used by default.
        """
        return pulumi.get(self, "side_output_url")

    @_builtins.property
    @pulumi.getter(name="sideOutputUrlList")
    def side_output_url_list(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The list of multiple forwarding stream addresses, which can be the CDN forwarding stream addresses of Alibaba Cloud or a third-party vendor. A guide can add up to 20 RTMP forwarding addresses.
        """
        return pulumi.get(self, "side_output_url_list")

    @_builtins.property
    @pulumi.getter(name="syncGroupsConfig")
    def sync_groups_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Multi-View synchronization configuration to synchronize multiple video sources. Multi-View synchronization is divided into two modes:
        - `mode 0`: (In the anchor mode, multiple video sources are synchronized according to the specified mode.)
        - `mode 1`: (Conference mode, there is no concept of anchor video, all video sources are synchronized with each other.)
        - `Anchor mode`: hostResourceId: the video source of the anchor in Anchor mode.
        - `Conference mode`: no hostRsoureId field, only the resource ids in the resourceIds to be provided.
        """
        return pulumi.get(self, "sync_groups_config")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transcodeConfig")
    def transcode_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Transcoding configuration.

        JSON format string, Please capitalize the first letter of the internal field of the structure, hump format input. If this parameter is set to null, the transcoding configuration is cleared by default. If the transcoding template is null, an error is reported when the director starts.
        """
        return pulumi.get(self, "transcode_config")

    @_builtins.property
    @pulumi.getter(name="urgentImageId")
    def urgent_image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the picture material of the media library.
        """
        return pulumi.get(self, "urgent_image_id")

    @_builtins.property
    @pulumi.getter(name="urgentImageUrl")
    def urgent_image_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Prepare the URL of the picture material.
        """
        return pulumi.get(self, "urgent_image_url")

    @_builtins.property
    @pulumi.getter(name="urgentLiveStreamUrl")
    def urgent_live_stream_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The prepared live stream URL.
        """
        return pulumi.get(self, "urgent_live_stream_url")

    @_builtins.property
    @pulumi.getter(name="urgentMaterialId")
    def urgent_material_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Prepared video, media library material ID. If this parameter is set to null, the standby configuration is cleared by default.
        """
        return pulumi.get(self, "urgent_material_id")

