# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QuotaArgs', 'Quota']

@pulumi.input_type
class QuotaArgs:
    def __init__(__self__, *,
                 commodity_code: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 commodity_data: Optional[pulumi.Input[_builtins.str]] = None,
                 part_nick_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_quota_info_lists: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaSubQuotaInfoListArgs']]]] = None):
        """
        The set of arguments for constructing a Quota resource.
        :param pulumi.Input[_builtins.str] commodity_code: Valid values: odps_intl/odpsplus_intl/odps/odpsplus
               - *NOTE:** --odps_intl: International Station standard post-payment -- odpsplus_intl: International Station standard pre-payment -- odps: China Station standard post-payment -- odpsplus: China Station standard pre-payment
        :param pulumi.Input[_builtins.str] payment_type: Payment type. Valid values: Subscription/PayAsYouGo
               
               > **NOTE:** -- PayAsYouGo only needs to be opened once per region
        :param pulumi.Input[_builtins.str] commodity_data: Define quota rules when creating quotas, for example:{"CU":50,"ord_time":"1:Month","autoRenew":false}.
               CU (minimum quota resource size is 50)
               ord_time 1:Month/Year (1 means quantity: Month/Year is the unit)
               autoRenew (whether to enable automatic renewal)
               If PaymentType is PayAsYouGo, you do not need to fill in
        :param pulumi.Input[_builtins.str] part_nick_name: Quota partial nickname, supports English letters and numbers, up to 24 characters
               
               > **NOTE:** If PaymentType is PayAsYouGo, you do not need to fill it in
        :param pulumi.Input[Sequence[pulumi.Input['QuotaSubQuotaInfoListArgs']]] sub_quota_info_lists: Secondary Quota list
               
               > **NOTE:** -- Add: If the configuration contains a second-level Quota that does not exist, a second-level Quota is added. -- Delete: If the configuration does not contain the existing secondary Quota, it will be deleted. -- Modify: If the configuration is inconsistent with the existing secondary Quota configuration parameters, the secondary Quota configuration will be updated. -- The default secondary Quota must be configured and cannot be deleted.
               See `sub_quota_info_list` below.
        """
        pulumi.set(__self__, "commodity_code", commodity_code)
        pulumi.set(__self__, "payment_type", payment_type)
        if commodity_data is not None:
            pulumi.set(__self__, "commodity_data", commodity_data)
        if part_nick_name is not None:
            pulumi.set(__self__, "part_nick_name", part_nick_name)
        if sub_quota_info_lists is not None:
            pulumi.set(__self__, "sub_quota_info_lists", sub_quota_info_lists)

    @_builtins.property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> pulumi.Input[_builtins.str]:
        """
        Valid values: odps_intl/odpsplus_intl/odps/odpsplus
        - *NOTE:** --odps_intl: International Station standard post-payment -- odpsplus_intl: International Station standard pre-payment -- odps: China Station standard post-payment -- odpsplus: China Station standard pre-payment
        """
        return pulumi.get(self, "commodity_code")

    @commodity_code.setter
    def commodity_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "commodity_code", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        Payment type. Valid values: Subscription/PayAsYouGo

        > **NOTE:** -- PayAsYouGo only needs to be opened once per region
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="commodityData")
    def commodity_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Define quota rules when creating quotas, for example:{"CU":50,"ord_time":"1:Month","autoRenew":false}.
        CU (minimum quota resource size is 50)
        ord_time 1:Month/Year (1 means quantity: Month/Year is the unit)
        autoRenew (whether to enable automatic renewal)
        If PaymentType is PayAsYouGo, you do not need to fill in
        """
        return pulumi.get(self, "commodity_data")

    @commodity_data.setter
    def commodity_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commodity_data", value)

    @_builtins.property
    @pulumi.getter(name="partNickName")
    def part_nick_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Quota partial nickname, supports English letters and numbers, up to 24 characters

        > **NOTE:** If PaymentType is PayAsYouGo, you do not need to fill it in
        """
        return pulumi.get(self, "part_nick_name")

    @part_nick_name.setter
    def part_nick_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "part_nick_name", value)

    @_builtins.property
    @pulumi.getter(name="subQuotaInfoLists")
    def sub_quota_info_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QuotaSubQuotaInfoListArgs']]]]:
        """
        Secondary Quota list

        > **NOTE:** -- Add: If the configuration contains a second-level Quota that does not exist, a second-level Quota is added. -- Delete: If the configuration does not contain the existing secondary Quota, it will be deleted. -- Modify: If the configuration is inconsistent with the existing secondary Quota configuration parameters, the secondary Quota configuration will be updated. -- The default secondary Quota must be configured and cannot be deleted.
        See `sub_quota_info_list` below.
        """
        return pulumi.get(self, "sub_quota_info_lists")

    @sub_quota_info_lists.setter
    def sub_quota_info_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaSubQuotaInfoListArgs']]]]):
        pulumi.set(self, "sub_quota_info_lists", value)


@pulumi.input_type
class _QuotaState:
    def __init__(__self__, *,
                 commodity_code: Optional[pulumi.Input[_builtins.str]] = None,
                 commodity_data: Optional[pulumi.Input[_builtins.str]] = None,
                 part_nick_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_quota_info_lists: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaSubQuotaInfoListArgs']]]] = None):
        """
        Input properties used for looking up and filtering Quota resources.
        :param pulumi.Input[_builtins.str] commodity_code: Valid values: odps_intl/odpsplus_intl/odps/odpsplus
               - *NOTE:** --odps_intl: International Station standard post-payment -- odpsplus_intl: International Station standard pre-payment -- odps: China Station standard post-payment -- odpsplus: China Station standard pre-payment
        :param pulumi.Input[_builtins.str] commodity_data: Define quota rules when creating quotas, for example:{"CU":50,"ord_time":"1:Month","autoRenew":false}.
               CU (minimum quota resource size is 50)
               ord_time 1:Month/Year (1 means quantity: Month/Year is the unit)
               autoRenew (whether to enable automatic renewal)
               If PaymentType is PayAsYouGo, you do not need to fill in
        :param pulumi.Input[_builtins.str] part_nick_name: Quota partial nickname, supports English letters and numbers, up to 24 characters
               
               > **NOTE:** If PaymentType is PayAsYouGo, you do not need to fill it in
        :param pulumi.Input[_builtins.str] payment_type: Payment type. Valid values: Subscription/PayAsYouGo
               
               > **NOTE:** -- PayAsYouGo only needs to be opened once per region
        :param pulumi.Input[Sequence[pulumi.Input['QuotaSubQuotaInfoListArgs']]] sub_quota_info_lists: Secondary Quota list
               
               > **NOTE:** -- Add: If the configuration contains a second-level Quota that does not exist, a second-level Quota is added. -- Delete: If the configuration does not contain the existing secondary Quota, it will be deleted. -- Modify: If the configuration is inconsistent with the existing secondary Quota configuration parameters, the secondary Quota configuration will be updated. -- The default secondary Quota must be configured and cannot be deleted.
               See `sub_quota_info_list` below.
        """
        if commodity_code is not None:
            pulumi.set(__self__, "commodity_code", commodity_code)
        if commodity_data is not None:
            pulumi.set(__self__, "commodity_data", commodity_data)
        if part_nick_name is not None:
            pulumi.set(__self__, "part_nick_name", part_nick_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if sub_quota_info_lists is not None:
            pulumi.set(__self__, "sub_quota_info_lists", sub_quota_info_lists)

    @_builtins.property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values: odps_intl/odpsplus_intl/odps/odpsplus
        - *NOTE:** --odps_intl: International Station standard post-payment -- odpsplus_intl: International Station standard pre-payment -- odps: China Station standard post-payment -- odpsplus: China Station standard pre-payment
        """
        return pulumi.get(self, "commodity_code")

    @commodity_code.setter
    def commodity_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commodity_code", value)

    @_builtins.property
    @pulumi.getter(name="commodityData")
    def commodity_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Define quota rules when creating quotas, for example:{"CU":50,"ord_time":"1:Month","autoRenew":false}.
        CU (minimum quota resource size is 50)
        ord_time 1:Month/Year (1 means quantity: Month/Year is the unit)
        autoRenew (whether to enable automatic renewal)
        If PaymentType is PayAsYouGo, you do not need to fill in
        """
        return pulumi.get(self, "commodity_data")

    @commodity_data.setter
    def commodity_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commodity_data", value)

    @_builtins.property
    @pulumi.getter(name="partNickName")
    def part_nick_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Quota partial nickname, supports English letters and numbers, up to 24 characters

        > **NOTE:** If PaymentType is PayAsYouGo, you do not need to fill it in
        """
        return pulumi.get(self, "part_nick_name")

    @part_nick_name.setter
    def part_nick_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "part_nick_name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type. Valid values: Subscription/PayAsYouGo

        > **NOTE:** -- PayAsYouGo only needs to be opened once per region
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="subQuotaInfoLists")
    def sub_quota_info_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QuotaSubQuotaInfoListArgs']]]]:
        """
        Secondary Quota list

        > **NOTE:** -- Add: If the configuration contains a second-level Quota that does not exist, a second-level Quota is added. -- Delete: If the configuration does not contain the existing secondary Quota, it will be deleted. -- Modify: If the configuration is inconsistent with the existing secondary Quota configuration parameters, the secondary Quota configuration will be updated. -- The default secondary Quota must be configured and cannot be deleted.
        See `sub_quota_info_list` below.
        """
        return pulumi.get(self, "sub_quota_info_lists")

    @sub_quota_info_lists.setter
    def sub_quota_info_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaSubQuotaInfoListArgs']]]]):
        pulumi.set(self, "sub_quota_info_lists", value)


@pulumi.type_token("alicloud:maxcompute/quota:Quota")
class Quota(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commodity_code: Optional[pulumi.Input[_builtins.str]] = None,
                 commodity_data: Optional[pulumi.Input[_builtins.str]] = None,
                 part_nick_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_quota_info_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QuotaSubQuotaInfoListArgs', 'QuotaSubQuotaInfoListArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Import

        Max Compute Quota can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:maxcompute/quota:Quota example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] commodity_code: Valid values: odps_intl/odpsplus_intl/odps/odpsplus
               - *NOTE:** --odps_intl: International Station standard post-payment -- odpsplus_intl: International Station standard pre-payment -- odps: China Station standard post-payment -- odpsplus: China Station standard pre-payment
        :param pulumi.Input[_builtins.str] commodity_data: Define quota rules when creating quotas, for example:{"CU":50,"ord_time":"1:Month","autoRenew":false}.
               CU (minimum quota resource size is 50)
               ord_time 1:Month/Year (1 means quantity: Month/Year is the unit)
               autoRenew (whether to enable automatic renewal)
               If PaymentType is PayAsYouGo, you do not need to fill in
        :param pulumi.Input[_builtins.str] part_nick_name: Quota partial nickname, supports English letters and numbers, up to 24 characters
               
               > **NOTE:** If PaymentType is PayAsYouGo, you do not need to fill it in
        :param pulumi.Input[_builtins.str] payment_type: Payment type. Valid values: Subscription/PayAsYouGo
               
               > **NOTE:** -- PayAsYouGo only needs to be opened once per region
        :param pulumi.Input[Sequence[pulumi.Input[Union['QuotaSubQuotaInfoListArgs', 'QuotaSubQuotaInfoListArgsDict']]]] sub_quota_info_lists: Secondary Quota list
               
               > **NOTE:** -- Add: If the configuration contains a second-level Quota that does not exist, a second-level Quota is added. -- Delete: If the configuration does not contain the existing secondary Quota, it will be deleted. -- Modify: If the configuration is inconsistent with the existing secondary Quota configuration parameters, the secondary Quota configuration will be updated. -- The default secondary Quota must be configured and cannot be deleted.
               See `sub_quota_info_list` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QuotaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Max Compute Quota can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:maxcompute/quota:Quota example <id>
        ```

        :param str resource_name: The name of the resource.
        :param QuotaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QuotaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commodity_code: Optional[pulumi.Input[_builtins.str]] = None,
                 commodity_data: Optional[pulumi.Input[_builtins.str]] = None,
                 part_nick_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_quota_info_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QuotaSubQuotaInfoListArgs', 'QuotaSubQuotaInfoListArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QuotaArgs.__new__(QuotaArgs)

            if commodity_code is None and not opts.urn:
                raise TypeError("Missing required property 'commodity_code'")
            __props__.__dict__["commodity_code"] = commodity_code
            __props__.__dict__["commodity_data"] = commodity_data
            __props__.__dict__["part_nick_name"] = part_nick_name
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["sub_quota_info_lists"] = sub_quota_info_lists
        super(Quota, __self__).__init__(
            'alicloud:maxcompute/quota:Quota',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            commodity_code: Optional[pulumi.Input[_builtins.str]] = None,
            commodity_data: Optional[pulumi.Input[_builtins.str]] = None,
            part_nick_name: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            sub_quota_info_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QuotaSubQuotaInfoListArgs', 'QuotaSubQuotaInfoListArgsDict']]]]] = None) -> 'Quota':
        """
        Get an existing Quota resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] commodity_code: Valid values: odps_intl/odpsplus_intl/odps/odpsplus
               - *NOTE:** --odps_intl: International Station standard post-payment -- odpsplus_intl: International Station standard pre-payment -- odps: China Station standard post-payment -- odpsplus: China Station standard pre-payment
        :param pulumi.Input[_builtins.str] commodity_data: Define quota rules when creating quotas, for example:{"CU":50,"ord_time":"1:Month","autoRenew":false}.
               CU (minimum quota resource size is 50)
               ord_time 1:Month/Year (1 means quantity: Month/Year is the unit)
               autoRenew (whether to enable automatic renewal)
               If PaymentType is PayAsYouGo, you do not need to fill in
        :param pulumi.Input[_builtins.str] part_nick_name: Quota partial nickname, supports English letters and numbers, up to 24 characters
               
               > **NOTE:** If PaymentType is PayAsYouGo, you do not need to fill it in
        :param pulumi.Input[_builtins.str] payment_type: Payment type. Valid values: Subscription/PayAsYouGo
               
               > **NOTE:** -- PayAsYouGo only needs to be opened once per region
        :param pulumi.Input[Sequence[pulumi.Input[Union['QuotaSubQuotaInfoListArgs', 'QuotaSubQuotaInfoListArgsDict']]]] sub_quota_info_lists: Secondary Quota list
               
               > **NOTE:** -- Add: If the configuration contains a second-level Quota that does not exist, a second-level Quota is added. -- Delete: If the configuration does not contain the existing secondary Quota, it will be deleted. -- Modify: If the configuration is inconsistent with the existing secondary Quota configuration parameters, the secondary Quota configuration will be updated. -- The default secondary Quota must be configured and cannot be deleted.
               See `sub_quota_info_list` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QuotaState.__new__(_QuotaState)

        __props__.__dict__["commodity_code"] = commodity_code
        __props__.__dict__["commodity_data"] = commodity_data
        __props__.__dict__["part_nick_name"] = part_nick_name
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["sub_quota_info_lists"] = sub_quota_info_lists
        return Quota(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> pulumi.Output[_builtins.str]:
        """
        Valid values: odps_intl/odpsplus_intl/odps/odpsplus
        - *NOTE:** --odps_intl: International Station standard post-payment -- odpsplus_intl: International Station standard pre-payment -- odps: China Station standard post-payment -- odpsplus: China Station standard pre-payment
        """
        return pulumi.get(self, "commodity_code")

    @_builtins.property
    @pulumi.getter(name="commodityData")
    def commodity_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Define quota rules when creating quotas, for example:{"CU":50,"ord_time":"1:Month","autoRenew":false}.
        CU (minimum quota resource size is 50)
        ord_time 1:Month/Year (1 means quantity: Month/Year is the unit)
        autoRenew (whether to enable automatic renewal)
        If PaymentType is PayAsYouGo, you do not need to fill in
        """
        return pulumi.get(self, "commodity_data")

    @_builtins.property
    @pulumi.getter(name="partNickName")
    def part_nick_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Quota partial nickname, supports English letters and numbers, up to 24 characters

        > **NOTE:** If PaymentType is PayAsYouGo, you do not need to fill it in
        """
        return pulumi.get(self, "part_nick_name")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        Payment type. Valid values: Subscription/PayAsYouGo

        > **NOTE:** -- PayAsYouGo only needs to be opened once per region
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="subQuotaInfoLists")
    def sub_quota_info_lists(self) -> pulumi.Output[Sequence['outputs.QuotaSubQuotaInfoList']]:
        """
        Secondary Quota list

        > **NOTE:** -- Add: If the configuration contains a second-level Quota that does not exist, a second-level Quota is added. -- Delete: If the configuration does not contain the existing secondary Quota, it will be deleted. -- Modify: If the configuration is inconsistent with the existing secondary Quota configuration parameters, the secondary Quota configuration will be updated. -- The default secondary Quota must be configured and cannot be deleted.
        See `sub_quota_info_list` below.
        """
        return pulumi.get(self, "sub_quota_info_lists")

