# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 account_password: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 character_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[_builtins.str] account_name: The new password.
               
               - The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `! # $ % ^ & * ( ) _ + - =`
               - The password must be 8 to 32 characters in length.
        :param pulumi.Input[_builtins.str] account_password: The password of the database account. The password must be 8 to 32 characters in length. It can contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! # $ % ^ & \\* ( ) \\_ + - =
        :param pulumi.Input[_builtins.str] instance_id: The account whose password needs to be reset. Set the value to `root`.
        :param pulumi.Input[_builtins.str] account_description: Account comment information.
               
               > **NOTE:**  Call the ModifyAccountDescription interface to set the account description information before this parameter is returned.
        :param pulumi.Input[_builtins.str] character_type: The role type of the instance. Value description
               
               - When the instance type is sharded cluster, charactertype is required. The values are db and cs.
               - When the instance type is a replica set, charactertype can be null or pass in normal.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_password", account_password)
        pulumi.set(__self__, "instance_id", instance_id)
        if account_description is not None:
            pulumi.set(__self__, "account_description", account_description)
        if character_type is not None:
            pulumi.set(__self__, "character_type", character_type)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The new password.

        - The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `! # $ % ^ & * ( ) _ + - =`
        - The password must be 8 to 32 characters in length.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Input[_builtins.str]:
        """
        The password of the database account. The password must be 8 to 32 characters in length. It can contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! # $ % ^ & \\* ( ) \\_ + - =
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_password", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The account whose password needs to be reset. Set the value to `root`.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account comment information.

        > **NOTE:**  Call the ModifyAccountDescription interface to set the account description information before this parameter is returned.
        """
        return pulumi.get(self, "account_description")

    @account_description.setter
    def account_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_description", value)

    @_builtins.property
    @pulumi.getter(name="characterType")
    def character_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role type of the instance. Value description

        - When the instance type is sharded cluster, charactertype is required. The values are db and cs.
        - When the instance type is a replica set, charactertype can be null or pass in normal.
        """
        return pulumi.get(self, "character_type")

    @character_type.setter
    def character_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "character_type", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 character_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[_builtins.str] account_description: Account comment information.
               
               > **NOTE:**  Call the ModifyAccountDescription interface to set the account description information before this parameter is returned.
        :param pulumi.Input[_builtins.str] account_name: The new password.
               
               - The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `! # $ % ^ & * ( ) _ + - =`
               - The password must be 8 to 32 characters in length.
        :param pulumi.Input[_builtins.str] account_password: The password of the database account. The password must be 8 to 32 characters in length. It can contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! # $ % ^ & \\* ( ) \\_ + - =
        :param pulumi.Input[_builtins.str] character_type: The role type of the instance. Value description
               
               - When the instance type is sharded cluster, charactertype is required. The values are db and cs.
               - When the instance type is a replica set, charactertype can be null or pass in normal.
        :param pulumi.Input[_builtins.str] instance_id: The account whose password needs to be reset. Set the value to `root`.
        :param pulumi.Input[_builtins.str] status: Account Status
        """
        if account_description is not None:
            pulumi.set(__self__, "account_description", account_description)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if character_type is not None:
            pulumi.set(__self__, "character_type", character_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account comment information.

        > **NOTE:**  Call the ModifyAccountDescription interface to set the account description information before this parameter is returned.
        """
        return pulumi.get(self, "account_description")

    @account_description.setter
    def account_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_description", value)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new password.

        - The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `! # $ % ^ & * ( ) _ + - =`
        - The password must be 8 to 32 characters in length.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the database account. The password must be 8 to 32 characters in length. It can contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! # $ % ^ & \\* ( ) \\_ + - =
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_password", value)

    @_builtins.property
    @pulumi.getter(name="characterType")
    def character_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role type of the instance. Value description

        - When the instance type is sharded cluster, charactertype is required. The values are db and cs.
        - When the instance type is a replica set, charactertype can be null or pass in normal.
        """
        return pulumi.get(self, "character_type")

    @character_type.setter
    def character_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "character_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account whose password needs to be reset. Set the value to `root`.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:mongodb/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 character_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Mongo D B Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:mongodb/account:Account example <instance_id>:<account_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_description: Account comment information.
               
               > **NOTE:**  Call the ModifyAccountDescription interface to set the account description information before this parameter is returned.
        :param pulumi.Input[_builtins.str] account_name: The new password.
               
               - The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `! # $ % ^ & * ( ) _ + - =`
               - The password must be 8 to 32 characters in length.
        :param pulumi.Input[_builtins.str] account_password: The password of the database account. The password must be 8 to 32 characters in length. It can contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! # $ % ^ & \\* ( ) \\_ + - =
        :param pulumi.Input[_builtins.str] character_type: The role type of the instance. Value description
               
               - When the instance type is sharded cluster, charactertype is required. The values are db and cs.
               - When the instance type is a replica set, charactertype can be null or pass in normal.
        :param pulumi.Input[_builtins.str] instance_id: The account whose password needs to be reset. Set the value to `root`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Mongo D B Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:mongodb/account:Account example <instance_id>:<account_name>
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 character_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            __props__.__dict__["account_description"] = account_description
            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if account_password is None and not opts.urn:
                raise TypeError("Missing required property 'account_password'")
            __props__.__dict__["account_password"] = None if account_password is None else pulumi.Output.secret(account_password)
            __props__.__dict__["character_type"] = character_type
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accountPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Account, __self__).__init__(
            'alicloud:mongodb/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_description: Optional[pulumi.Input[_builtins.str]] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            account_password: Optional[pulumi.Input[_builtins.str]] = None,
            character_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_description: Account comment information.
               
               > **NOTE:**  Call the ModifyAccountDescription interface to set the account description information before this parameter is returned.
        :param pulumi.Input[_builtins.str] account_name: The new password.
               
               - The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `! # $ % ^ & * ( ) _ + - =`
               - The password must be 8 to 32 characters in length.
        :param pulumi.Input[_builtins.str] account_password: The password of the database account. The password must be 8 to 32 characters in length. It can contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! # $ % ^ & \\* ( ) \\_ + - =
        :param pulumi.Input[_builtins.str] character_type: The role type of the instance. Value description
               
               - When the instance type is sharded cluster, charactertype is required. The values are db and cs.
               - When the instance type is a replica set, charactertype can be null or pass in normal.
        :param pulumi.Input[_builtins.str] instance_id: The account whose password needs to be reset. Set the value to `root`.
        :param pulumi.Input[_builtins.str] status: Account Status
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["account_description"] = account_description
        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["account_password"] = account_password
        __props__.__dict__["character_type"] = character_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["status"] = status
        return Account(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Account comment information.

        > **NOTE:**  Call the ModifyAccountDescription interface to set the account description information before this parameter is returned.
        """
        return pulumi.get(self, "account_description")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The new password.

        - The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `! # $ % ^ & * ( ) _ + - =`
        - The password must be 8 to 32 characters in length.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Output[_builtins.str]:
        """
        The password of the database account. The password must be 8 to 32 characters in length. It can contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! # $ % ^ & \\* ( ) \\_ + - =
        """
        return pulumi.get(self, "account_password")

    @_builtins.property
    @pulumi.getter(name="characterType")
    def character_type(self) -> pulumi.Output[_builtins.str]:
        """
        The role type of the instance. Value description

        - When the instance type is sharded cluster, charactertype is required. The values are db and cs.
        - When the instance type is a replica set, charactertype can be null or pass in normal.
        """
        return pulumi.get(self, "character_type")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The account whose password needs to be reset. Set the value to `root`.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Account Status
        """
        return pulumi.get(self, "status")

