# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SnapshotArgs', 'Snapshot']

@pulumi.input_type
class SnapshotArgs:
    def __init__(__self__, *,
                 file_system_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Snapshot resource.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] description: The description of the snapshot. It must be `2` to `256` characters in length and cannot start with `https://` or `https://`.
        :param pulumi.Input[_builtins.int] retention_days: The retention period of the snapshot. Unit: days. Valid values:
               * `-1`: The default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
        :param pulumi.Input[_builtins.str] snapshot_name: SnapshotName. It must be `2` to `128` characters in length and must start with a letter, but cannot start with `https://` or `https://`.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the snapshot. It must be `2` to `256` characters in length and cannot start with `https://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of the snapshot. Unit: days. Valid values:
        * `-1`: The default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SnapshotName. It must be `2` to `128` characters in length and must start with a letter, but cannot start with `https://` or `https://`.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_name", value)


@pulumi.input_type
class _SnapshotState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Snapshot resources.
        :param pulumi.Input[_builtins.str] description: The description of the snapshot. It must be `2` to `256` characters in length and cannot start with `https://` or `https://`.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.int] retention_days: The retention period of the snapshot. Unit: days. Valid values:
               * `-1`: The default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
        :param pulumi.Input[_builtins.str] snapshot_name: SnapshotName. It must be `2` to `128` characters in length and must start with a letter, but cannot start with `https://` or `https://`.
        :param pulumi.Input[_builtins.str] status: The status of the snapshot.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the snapshot. It must be `2` to `256` characters in length and cannot start with `https://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of the snapshot. Unit: days. Valid values:
        * `-1`: The default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SnapshotName. It must be `2` to `128` characters in length and must start with a letter, but cannot start with `https://` or `https://`.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the snapshot.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:nas/snapshot:Snapshot")
class Snapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a File Storage (NAS) Snapshot resource.

        For information about File Storage (NAS) Snapshot and how to use it, see [What is Snapshot](https://www.alibabacloud.com/help/en/doc-detail/126549.html).

        > **NOTE:** Available since v1.152.0.

        > **NOTE:** Only Extreme NAS file systems support the snapshot feature.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "testacc"
        default = alicloud.nas.get_zones(file_system_type="extreme")
        default_file_system = alicloud.nas.FileSystem("default",
            file_system_type="extreme",
            protocol_type="NFS",
            zone_id=default.zones[0].zone_id,
            storage_type="standard",
            capacity=100)
        default_snapshot = alicloud.nas.Snapshot("default",
            file_system_id=default_file_system.id,
            description=name,
            retention_days=20,
            snapshot_name=name)
        ```

        ## Import

        File Storage (NAS) Snapshot can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/snapshot:Snapshot example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the snapshot. It must be `2` to `256` characters in length and cannot start with `https://` or `https://`.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.int] retention_days: The retention period of the snapshot. Unit: days. Valid values:
               * `-1`: The default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
        :param pulumi.Input[_builtins.str] snapshot_name: SnapshotName. It must be `2` to `128` characters in length and must start with a letter, but cannot start with `https://` or `https://`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a File Storage (NAS) Snapshot resource.

        For information about File Storage (NAS) Snapshot and how to use it, see [What is Snapshot](https://www.alibabacloud.com/help/en/doc-detail/126549.html).

        > **NOTE:** Available since v1.152.0.

        > **NOTE:** Only Extreme NAS file systems support the snapshot feature.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "testacc"
        default = alicloud.nas.get_zones(file_system_type="extreme")
        default_file_system = alicloud.nas.FileSystem("default",
            file_system_type="extreme",
            protocol_type="NFS",
            zone_id=default.zones[0].zone_id,
            storage_type="standard",
            capacity=100)
        default_snapshot = alicloud.nas.Snapshot("default",
            file_system_id=default_file_system.id,
            description=name,
            retention_days=20,
            snapshot_name=name)
        ```

        ## Import

        File Storage (NAS) Snapshot can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/snapshot:Snapshot example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotArgs.__new__(SnapshotArgs)

            __props__.__dict__["description"] = description
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            __props__.__dict__["retention_days"] = retention_days
            __props__.__dict__["snapshot_name"] = snapshot_name
            __props__.__dict__["status"] = None
        super(Snapshot, __self__).__init__(
            'alicloud:nas/snapshot:Snapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Snapshot':
        """
        Get an existing Snapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the snapshot. It must be `2` to `256` characters in length and cannot start with `https://` or `https://`.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.int] retention_days: The retention period of the snapshot. Unit: days. Valid values:
               * `-1`: The default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
        :param pulumi.Input[_builtins.str] snapshot_name: SnapshotName. It must be `2` to `128` characters in length and must start with a letter, but cannot start with `https://` or `https://`.
        :param pulumi.Input[_builtins.str] status: The status of the snapshot.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotState.__new__(_SnapshotState)

        __props__.__dict__["description"] = description
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["retention_days"] = retention_days
        __props__.__dict__["snapshot_name"] = snapshot_name
        __props__.__dict__["status"] = status
        return Snapshot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the snapshot. It must be `2` to `256` characters in length and cannot start with `https://` or `https://`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The retention period of the snapshot. Unit: days. Valid values:
        * `-1`: The default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SnapshotName. It must be `2` to `128` characters in length and must start with a letter, but cannot start with `https://` or `https://`.
        """
        return pulumi.get(self, "snapshot_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the snapshot.
        """
        return pulumi.get(self, "status")

