# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LoadBalancerZoneShiftedAttachmentArgs', 'LoadBalancerZoneShiftedAttachment']

@pulumi.input_type
class LoadBalancerZoneShiftedAttachmentArgs:
    def __init__(__self__, *,
                 load_balancer_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a LoadBalancerZoneShiftedAttachment resource.
        :param pulumi.Input[_builtins.str] load_balancer_id: Network load balancer id
        :param pulumi.Input[_builtins.str] vswitch_id: The list of zones and vSwitch mappings
        :param pulumi.Input[_builtins.str] zone_id: ZoneId
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        Network load balancer id
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The list of zones and vSwitch mappings
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        ZoneId
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _LoadBalancerZoneShiftedAttachmentState:
    def __init__(__self__, *,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerZoneShiftedAttachment resources.
        :param pulumi.Input[_builtins.str] load_balancer_id: Network load balancer id
        :param pulumi.Input[_builtins.str] status: Status
        :param pulumi.Input[_builtins.str] vswitch_id: The list of zones and vSwitch mappings
        :param pulumi.Input[_builtins.str] zone_id: ZoneId
        """
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network load balancer id
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of zones and vSwitch mappings
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ZoneId
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:nlb/loadBalancerZoneShiftedAttachment:LoadBalancerZoneShiftedAttachment")
class LoadBalancerZoneShiftedAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Network Load Balancer (NLB) Load Balancer Zone Shifted Attachment resource.

        Network load balancer shift zone.

        For information about Network Load Balancer (NLB) Load Balancer Zone Shifted Attachment and how to use it, see [What is Load Balancer Zone Shifted Attachment](https://next.api.alibabacloud.com/document/Nlb/2022-04-30/StartShiftLoadBalancerZones).

        > **NOTE:** Available since v1.245.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vpc = alicloud.vpc.Network("vpc",
            description="example",
            cidr_block="10.0.0.0/8",
            enable_ipv6=True,
            vpc_name="tf-exampleacc-248")
        vsw1 = alicloud.vpc.Switch("vsw1",
            vpc_id=vpc.id,
            zone_id="cn-beijing-l",
            cidr_block="10.0.1.0/24",
            vswitch_name="tf-exampleacc-41")
        vsw2 = alicloud.vpc.Switch("vsw2",
            vpc_id=vpc.id,
            zone_id="cn-beijing-k",
            cidr_block="10.0.2.0/24",
            vswitch_name="tf-exampleacc-301",
            ipv6_cidr_block_mask=8)
        nlb = alicloud.nlb.LoadBalancer("nlb",
            zone_mappings=[
                {
                    "vswitch_id": vsw1.id,
                    "zone_id": vsw1.zone_id,
                },
                {
                    "vswitch_id": vsw2.id,
                    "zone_id": vsw2.zone_id,
                },
            ],
            vpc_id=vpc.id,
            address_type="Intranet")
        default = alicloud.nlb.LoadBalancerZoneShiftedAttachment("default",
            zone_id=vsw1.zone_id,
            vswitch_id=vsw1.id,
            load_balancer_id=nlb.id)
        ```

        ## Import

        Network Load Balancer (NLB) Load Balancer Zone Shifted Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nlb/loadBalancerZoneShiftedAttachment:LoadBalancerZoneShiftedAttachment example <load_balancer_id>:<zone_id>:<vswitch_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] load_balancer_id: Network load balancer id
        :param pulumi.Input[_builtins.str] vswitch_id: The list of zones and vSwitch mappings
        :param pulumi.Input[_builtins.str] zone_id: ZoneId
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerZoneShiftedAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Network Load Balancer (NLB) Load Balancer Zone Shifted Attachment resource.

        Network load balancer shift zone.

        For information about Network Load Balancer (NLB) Load Balancer Zone Shifted Attachment and how to use it, see [What is Load Balancer Zone Shifted Attachment](https://next.api.alibabacloud.com/document/Nlb/2022-04-30/StartShiftLoadBalancerZones).

        > **NOTE:** Available since v1.245.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vpc = alicloud.vpc.Network("vpc",
            description="example",
            cidr_block="10.0.0.0/8",
            enable_ipv6=True,
            vpc_name="tf-exampleacc-248")
        vsw1 = alicloud.vpc.Switch("vsw1",
            vpc_id=vpc.id,
            zone_id="cn-beijing-l",
            cidr_block="10.0.1.0/24",
            vswitch_name="tf-exampleacc-41")
        vsw2 = alicloud.vpc.Switch("vsw2",
            vpc_id=vpc.id,
            zone_id="cn-beijing-k",
            cidr_block="10.0.2.0/24",
            vswitch_name="tf-exampleacc-301",
            ipv6_cidr_block_mask=8)
        nlb = alicloud.nlb.LoadBalancer("nlb",
            zone_mappings=[
                {
                    "vswitch_id": vsw1.id,
                    "zone_id": vsw1.zone_id,
                },
                {
                    "vswitch_id": vsw2.id,
                    "zone_id": vsw2.zone_id,
                },
            ],
            vpc_id=vpc.id,
            address_type="Intranet")
        default = alicloud.nlb.LoadBalancerZoneShiftedAttachment("default",
            zone_id=vsw1.zone_id,
            vswitch_id=vsw1.id,
            load_balancer_id=nlb.id)
        ```

        ## Import

        Network Load Balancer (NLB) Load Balancer Zone Shifted Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nlb/loadBalancerZoneShiftedAttachment:LoadBalancerZoneShiftedAttachment example <load_balancer_id>:<zone_id>:<vswitch_id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerZoneShiftedAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerZoneShiftedAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerZoneShiftedAttachmentArgs.__new__(LoadBalancerZoneShiftedAttachmentArgs)

            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["status"] = None
        super(LoadBalancerZoneShiftedAttachment, __self__).__init__(
            'alicloud:nlb/loadBalancerZoneShiftedAttachment:LoadBalancerZoneShiftedAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoadBalancerZoneShiftedAttachment':
        """
        Get an existing LoadBalancerZoneShiftedAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] load_balancer_id: Network load balancer id
        :param pulumi.Input[_builtins.str] status: Status
        :param pulumi.Input[_builtins.str] vswitch_id: The list of zones and vSwitch mappings
        :param pulumi.Input[_builtins.str] zone_id: ZoneId
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerZoneShiftedAttachmentState.__new__(_LoadBalancerZoneShiftedAttachmentState)

        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return LoadBalancerZoneShiftedAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        Network load balancer id
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The list of zones and vSwitch mappings
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        ZoneId
        """
        return pulumi.get(self, "zone_id")

