# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BucketObjectArgs', 'BucketObject']

@pulumi.input_type
class BucketObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 key: pulumi.Input[_builtins.str],
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 expires: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BucketObject resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket to put the file in.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] acl: The [canned ACL](https://www.alibabacloud.com/help/doc-detail/52284.htm) to apply. Defaults to "private".
        :param pulumi.Input[_builtins.str] cache_control: Specifies caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content: The literal content being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] content_disposition: Specifies presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content_md5: The MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] expires: Specifies expire date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] kms_key_id: Specifies the primary key managed by KMS. This parameter is valid when the value of `server_side_encryption` is set to KMS.
               
               Either `source` or `content` must be provided to specify the bucket content.
               These two arguments are mutually-exclusive.
        :param pulumi.Input[_builtins.str] server_side_encryption: Specifies server-side encryption of the object in OSS. Valid values are `AES256`, `KMS`. Default value is `AES256`.
        :param pulumi.Input[_builtins.str] source: The path to the source file being uploaded to the bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the bucket to put the file in.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [canned ACL](https://www.alibabacloud.com/help/doc-detail/52284.htm) to apply. Defaults to "private".
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_control", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The literal content being uploaded to the bucket.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_disposition", value)

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_encoding", value)

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
        """
        return pulumi.get(self, "content_md5")

    @content_md5.setter
    def content_md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_md5", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def expires(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies expire date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "expires")

    @expires.setter
    def expires(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the primary key managed by KMS. This parameter is valid when the value of `server_side_encryption` is set to KMS.

        Either `source` or `content` must be provided to specify the bucket content.
        These two arguments are mutually-exclusive.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies server-side encryption of the object in OSS. Valid values are `AES256`, `KMS`. Default value is `AES256`.
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_side_encryption", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the source file being uploaded to the bucket.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _BucketObjectState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 content_length: Optional[pulumi.Input[_builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 expires: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketObject resources.
        :param pulumi.Input[_builtins.str] acl: The [canned ACL](https://www.alibabacloud.com/help/doc-detail/52284.htm) to apply. Defaults to "private".
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket to put the file in.
        :param pulumi.Input[_builtins.str] cache_control: Specifies caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content: The literal content being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] content_disposition: Specifies presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content_length: the content length of request.
        :param pulumi.Input[_builtins.str] content_md5: The MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] etag: the ETag generated for the object (an MD5 sum of the object content).
        :param pulumi.Input[_builtins.str] expires: Specifies expire date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] kms_key_id: Specifies the primary key managed by KMS. This parameter is valid when the value of `server_side_encryption` is set to KMS.
               
               Either `source` or `content` must be provided to specify the bucket content.
               These two arguments are mutually-exclusive.
        :param pulumi.Input[_builtins.str] server_side_encryption: Specifies server-side encryption of the object in OSS. Valid values are `AES256`, `KMS`. Default value is `AES256`.
        :param pulumi.Input[_builtins.str] source: The path to the source file being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] version_id: A unique version ID value for the object, if bucket versioning is enabled.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_length is not None:
            pulumi.set(__self__, "content_length", content_length)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [canned ACL](https://www.alibabacloud.com/help/doc-detail/52284.htm) to apply. Defaults to "private".
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket to put the file in.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_control", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The literal content being uploaded to the bucket.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_disposition", value)

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_encoding", value)

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the content length of request.
        """
        return pulumi.get(self, "content_length")

    @content_length.setter
    def content_length(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_length", value)

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
        """
        return pulumi.get(self, "content_md5")

    @content_md5.setter
    def content_md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_md5", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the ETag generated for the object (an MD5 sum of the object content).
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def expires(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies expire date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "expires")

    @expires.setter
    def expires(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the primary key managed by KMS. This parameter is valid when the value of `server_side_encryption` is set to KMS.

        Either `source` or `content` must be provided to specify the bucket content.
        These two arguments are mutually-exclusive.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies server-side encryption of the object in OSS. Valid values are `AES256`, `KMS`. Default value is `AES256`.
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_side_encryption", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the source file being uploaded to the bucket.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique version ID value for the object, if bucket versioning is enabled.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_id", value)


@pulumi.type_token("alicloud:oss/bucketObject:BucketObject")
class BucketObject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 expires: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to put a object(content or file) to a oss bucket.

        ## Example Usage

        ### Uploading a file to a bucket

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default['result']}")
        default_bucket_acl = alicloud.oss.BucketAcl("default",
            bucket=default_bucket.bucket,
            acl="private")
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.bucket,
            key="example_key",
            source="./main.tf")
        ```

        ### Uploading a content to a bucket

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default['result']}")
        default_bucket_acl = alicloud.oss.BucketAcl("default",
            bucket=default_bucket.bucket,
            acl="private")
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.bucket,
            key="example_key",
            content="the content that you want to upload.")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: The [canned ACL](https://www.alibabacloud.com/help/doc-detail/52284.htm) to apply. Defaults to "private".
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket to put the file in.
        :param pulumi.Input[_builtins.str] cache_control: Specifies caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content: The literal content being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] content_disposition: Specifies presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content_md5: The MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] expires: Specifies expire date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] kms_key_id: Specifies the primary key managed by KMS. This parameter is valid when the value of `server_side_encryption` is set to KMS.
               
               Either `source` or `content` must be provided to specify the bucket content.
               These two arguments are mutually-exclusive.
        :param pulumi.Input[_builtins.str] server_side_encryption: Specifies server-side encryption of the object in OSS. Valid values are `AES256`, `KMS`. Default value is `AES256`.
        :param pulumi.Input[_builtins.str] source: The path to the source file being uploaded to the bucket.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketObjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to put a object(content or file) to a oss bucket.

        ## Example Usage

        ### Uploading a file to a bucket

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default['result']}")
        default_bucket_acl = alicloud.oss.BucketAcl("default",
            bucket=default_bucket.bucket,
            acl="private")
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.bucket,
            key="example_key",
            source="./main.tf")
        ```

        ### Uploading a content to a bucket

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default['result']}")
        default_bucket_acl = alicloud.oss.BucketAcl("default",
            bucket=default_bucket.bucket,
            acl="private")
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.bucket,
            key="example_key",
            content="the content that you want to upload.")
        ```

        :param str resource_name: The name of the resource.
        :param BucketObjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketObjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 expires: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketObjectArgs.__new__(BucketObjectArgs)

            __props__.__dict__["acl"] = acl
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["cache_control"] = cache_control
            __props__.__dict__["content"] = content
            __props__.__dict__["content_disposition"] = content_disposition
            __props__.__dict__["content_encoding"] = content_encoding
            __props__.__dict__["content_md5"] = content_md5
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["expires"] = expires
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["server_side_encryption"] = server_side_encryption
            __props__.__dict__["source"] = source
            __props__.__dict__["content_length"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["version_id"] = None
        super(BucketObject, __self__).__init__(
            'alicloud:oss/bucketObject:BucketObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            cache_control: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
            content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
            content_length: Optional[pulumi.Input[_builtins.str]] = None,
            content_md5: Optional[pulumi.Input[_builtins.str]] = None,
            content_type: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            expires: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_side_encryption: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            version_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketObject':
        """
        Get an existing BucketObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: The [canned ACL](https://www.alibabacloud.com/help/doc-detail/52284.htm) to apply. Defaults to "private".
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket to put the file in.
        :param pulumi.Input[_builtins.str] cache_control: Specifies caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content: The literal content being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] content_disposition: Specifies presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] content_length: the content length of request.
        :param pulumi.Input[_builtins.str] content_md5: The MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] etag: the ETag generated for the object (an MD5 sum of the object content).
        :param pulumi.Input[_builtins.str] expires: Specifies expire date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] kms_key_id: Specifies the primary key managed by KMS. This parameter is valid when the value of `server_side_encryption` is set to KMS.
               
               Either `source` or `content` must be provided to specify the bucket content.
               These two arguments are mutually-exclusive.
        :param pulumi.Input[_builtins.str] server_side_encryption: Specifies server-side encryption of the object in OSS. Valid values are `AES256`, `KMS`. Default value is `AES256`.
        :param pulumi.Input[_builtins.str] source: The path to the source file being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] version_id: A unique version ID value for the object, if bucket versioning is enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketObjectState.__new__(_BucketObjectState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["cache_control"] = cache_control
        __props__.__dict__["content"] = content
        __props__.__dict__["content_disposition"] = content_disposition
        __props__.__dict__["content_encoding"] = content_encoding
        __props__.__dict__["content_length"] = content_length
        __props__.__dict__["content_md5"] = content_md5
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["etag"] = etag
        __props__.__dict__["expires"] = expires
        __props__.__dict__["key"] = key
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["server_side_encryption"] = server_side_encryption
        __props__.__dict__["source"] = source
        __props__.__dict__["version_id"] = version_id
        return BucketObject(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The [canned ACL](https://www.alibabacloud.com/help/doc-detail/52284.htm) to apply. Defaults to "private".
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket to put the file in.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "cache_control")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The literal content being uploaded to the bucket.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "content_disposition")

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "content_encoding")

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> pulumi.Output[_builtins.str]:
        """
        the content length of request.
        """
        return pulumi.get(self, "content_length")

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
        """
        return pulumi.get(self, "content_md5")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[_builtins.str]:
        """
        A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        the ETag generated for the object (an MD5 sum of the object content).
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def expires(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies expire date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "expires")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the primary key managed by KMS. This parameter is valid when the value of `server_side_encryption` is set to KMS.

        Either `source` or `content` must be provided to specify the bucket content.
        These two arguments are mutually-exclusive.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies server-side encryption of the object in OSS. Valid values are `AES256`, `KMS`. Default value is `AES256`.
        """
        return pulumi.get(self, "server_side_encryption")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path to the source file being uploaded to the bucket.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[_builtins.str]:
        """
        A unique version ID value for the object, if bucket versioning is enabled.
        """
        return pulumi.get(self, "version_id")

