# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceDatasetversionArgs', 'WorkspaceDatasetversion']

@pulumi.input_type
class WorkspaceDatasetversionArgs:
    def __init__(__self__, *,
                 data_source_type: pulumi.Input[_builtins.str],
                 dataset_id: pulumi.Input[_builtins.str],
                 property: pulumi.Input[_builtins.str],
                 uri: pulumi.Input[_builtins.str],
                 data_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_size: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetversionLabelArgs']]]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceDatasetversion resource.
        :param pulumi.Input[_builtins.str] data_source_type: The data source type. The following values are supported:
               - OSS: Alibaba Cloud Object Storage (OSS).
               - NAS: Alibaba cloud file storage (NAS).
        :param pulumi.Input[_builtins.str] dataset_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] property: The properties of the dataset. The following values are supported:
               - FILE: FILE.
               - DIRECTORY: folder.
        :param pulumi.Input[_builtins.str] uri: The Uri configuration sample is as follows:
               - The data source type is OSS:'oss:// bucket.endpoint/object'
               - The data source type is NAS:
               
               The general NAS format is: 'nas://.region/subpath/to/dir/';
               
               CPFS1.0:'nas://.region/subpath/to/dir /';
               
               CPFS2.0:'nas://.region//'.
               
               CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        :param pulumi.Input[_builtins.int] data_count: Data count.
        :param pulumi.Input[_builtins.int] data_size: Data size.
        :param pulumi.Input[_builtins.str] description: Description of dataset version.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetversionLabelArgs']]] labels: The tag of the resource See `labels` below.
        :param pulumi.Input[_builtins.str] options: The extended field, which is of the JsonString type.
               
               When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        :param pulumi.Input[_builtins.str] source_id: The data source ID.
        :param pulumi.Input[_builtins.str] source_type: The data source type. The default value is USER.
        """
        pulumi.set(__self__, "data_source_type", data_source_type)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "uri", uri)
        if data_count is not None:
            pulumi.set(__self__, "data_count", data_count)
        if data_size is not None:
            pulumi.set(__self__, "data_size", data_size)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The data source type. The following values are supported:
        - OSS: Alibaba Cloud Object Storage (OSS).
        - NAS: Alibaba cloud file storage (NAS).
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[_builtins.str]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter
    def property(self) -> pulumi.Input[_builtins.str]:
        """
        The properties of the dataset. The following values are supported:
        - FILE: FILE.
        - DIRECTORY: folder.
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "property", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Input[_builtins.str]:
        """
        The Uri configuration sample is as follows:
        - The data source type is OSS:'oss:// bucket.endpoint/object'
        - The data source type is NAS:

        The general NAS format is: 'nas://.region/subpath/to/dir/';

        CPFS1.0:'nas://.region/subpath/to/dir /';

        CPFS2.0:'nas://.region//'.

        CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter(name="dataCount")
    def data_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Data count.
        """
        return pulumi.get(self, "data_count")

    @data_count.setter
    def data_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_count", value)

    @_builtins.property
    @pulumi.getter(name="dataSize")
    def data_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Data size.
        """
        return pulumi.get(self, "data_size")

    @data_size.setter
    def data_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_size", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of dataset version.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetversionLabelArgs']]]]:
        """
        The tag of the resource See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetversionLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended field, which is of the JsonString type.

        When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source ID.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source type. The default value is USER.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)


@pulumi.input_type
class _WorkspaceDatasetversionState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_size: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetversionLabelArgs']]]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 property: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 version_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceDatasetversion resources.
        :param pulumi.Input[_builtins.str] create_time: Update time.
        :param pulumi.Input[_builtins.int] data_count: Data count.
        :param pulumi.Input[_builtins.int] data_size: Data size.
        :param pulumi.Input[_builtins.str] data_source_type: The data source type. The following values are supported:
               - OSS: Alibaba Cloud Object Storage (OSS).
               - NAS: Alibaba cloud file storage (NAS).
        :param pulumi.Input[_builtins.str] dataset_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] description: Description of dataset version.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetversionLabelArgs']]] labels: The tag of the resource See `labels` below.
        :param pulumi.Input[_builtins.str] options: The extended field, which is of the JsonString type.
               
               When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        :param pulumi.Input[_builtins.str] property: The properties of the dataset. The following values are supported:
               - FILE: FILE.
               - DIRECTORY: folder.
        :param pulumi.Input[_builtins.str] source_id: The data source ID.
        :param pulumi.Input[_builtins.str] source_type: The data source type. The default value is USER.
        :param pulumi.Input[_builtins.str] uri: The Uri configuration sample is as follows:
               - The data source type is OSS:'oss:// bucket.endpoint/object'
               - The data source type is NAS:
               
               The general NAS format is: 'nas://.region/subpath/to/dir/';
               
               CPFS1.0:'nas://.region/subpath/to/dir /';
               
               CPFS2.0:'nas://.region//'.
               
               CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        :param pulumi.Input[_builtins.str] version_name: The name of the resource
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_count is not None:
            pulumi.set(__self__, "data_count", data_count)
        if data_size is not None:
            pulumi.set(__self__, "data_size", data_size)
        if data_source_type is not None:
            pulumi.set(__self__, "data_source_type", data_source_type)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Update time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataCount")
    def data_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Data count.
        """
        return pulumi.get(self, "data_count")

    @data_count.setter
    def data_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_count", value)

    @_builtins.property
    @pulumi.getter(name="dataSize")
    def data_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Data size.
        """
        return pulumi.get(self, "data_size")

    @data_size.setter
    def data_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_size", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source type. The following values are supported:
        - OSS: Alibaba Cloud Object Storage (OSS).
        - NAS: Alibaba cloud file storage (NAS).
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of dataset version.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetversionLabelArgs']]]]:
        """
        The tag of the resource See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetversionLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended field, which is of the JsonString type.

        When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def property(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The properties of the dataset. The following values are supported:
        - FILE: FILE.
        - DIRECTORY: folder.
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "property", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source ID.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source type. The default value is USER.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Uri configuration sample is as follows:
        - The data source type is OSS:'oss:// bucket.endpoint/object'
        - The data source type is NAS:

        The general NAS format is: 'nas://.region/subpath/to/dir/';

        CPFS1.0:'nas://.region/subpath/to/dir /';

        CPFS2.0:'nas://.region//'.

        CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_name", value)


@pulumi.type_token("alicloud:pai/workspaceDatasetversion:WorkspaceDatasetversion")
class WorkspaceDatasetversion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_size: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceDatasetversionLabelArgs', 'WorkspaceDatasetversionLabelArgsDict']]]]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 property: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PAI Workspace Datasetversion resource.

        For information about PAI Workspace Dataset Version and how to use it, see [What is Dataset Version](https://next.api.alibabacloud.com/document/AIWorkSpace/2021-02-04/CreateDatasetVersion).
        > **NOTE:** Available since v1.236.0.

        ## Import

        PAI Workspace Datasetversion can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceDatasetversion:WorkspaceDatasetversion example <dataset_id>:<version_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] data_count: Data count.
        :param pulumi.Input[_builtins.int] data_size: Data size.
        :param pulumi.Input[_builtins.str] data_source_type: The data source type. The following values are supported:
               - OSS: Alibaba Cloud Object Storage (OSS).
               - NAS: Alibaba cloud file storage (NAS).
        :param pulumi.Input[_builtins.str] dataset_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] description: Description of dataset version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceDatasetversionLabelArgs', 'WorkspaceDatasetversionLabelArgsDict']]]] labels: The tag of the resource See `labels` below.
        :param pulumi.Input[_builtins.str] options: The extended field, which is of the JsonString type.
               
               When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        :param pulumi.Input[_builtins.str] property: The properties of the dataset. The following values are supported:
               - FILE: FILE.
               - DIRECTORY: folder.
        :param pulumi.Input[_builtins.str] source_id: The data source ID.
        :param pulumi.Input[_builtins.str] source_type: The data source type. The default value is USER.
        :param pulumi.Input[_builtins.str] uri: The Uri configuration sample is as follows:
               - The data source type is OSS:'oss:// bucket.endpoint/object'
               - The data source type is NAS:
               
               The general NAS format is: 'nas://.region/subpath/to/dir/';
               
               CPFS1.0:'nas://.region/subpath/to/dir /';
               
               CPFS2.0:'nas://.region//'.
               
               CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceDatasetversionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PAI Workspace Datasetversion resource.

        For information about PAI Workspace Dataset Version and how to use it, see [What is Dataset Version](https://next.api.alibabacloud.com/document/AIWorkSpace/2021-02-04/CreateDatasetVersion).
        > **NOTE:** Available since v1.236.0.

        ## Import

        PAI Workspace Datasetversion can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceDatasetversion:WorkspaceDatasetversion example <dataset_id>:<version_name>
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceDatasetversionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceDatasetversionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_size: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceDatasetversionLabelArgs', 'WorkspaceDatasetversionLabelArgsDict']]]]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 property: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceDatasetversionArgs.__new__(WorkspaceDatasetversionArgs)

            __props__.__dict__["data_count"] = data_count
            __props__.__dict__["data_size"] = data_size
            if data_source_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_type'")
            __props__.__dict__["data_source_type"] = data_source_type
            if dataset_id is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_id'")
            __props__.__dict__["dataset_id"] = dataset_id
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["options"] = options
            if property is None and not opts.urn:
                raise TypeError("Missing required property 'property'")
            __props__.__dict__["property"] = property
            __props__.__dict__["source_id"] = source_id
            __props__.__dict__["source_type"] = source_type
            if uri is None and not opts.urn:
                raise TypeError("Missing required property 'uri'")
            __props__.__dict__["uri"] = uri
            __props__.__dict__["create_time"] = None
            __props__.__dict__["version_name"] = None
        super(WorkspaceDatasetversion, __self__).__init__(
            'alicloud:pai/workspaceDatasetversion:WorkspaceDatasetversion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_count: Optional[pulumi.Input[_builtins.int]] = None,
            data_size: Optional[pulumi.Input[_builtins.int]] = None,
            data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
            dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceDatasetversionLabelArgs', 'WorkspaceDatasetversionLabelArgsDict']]]]] = None,
            options: Optional[pulumi.Input[_builtins.str]] = None,
            property: Optional[pulumi.Input[_builtins.str]] = None,
            source_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None,
            uri: Optional[pulumi.Input[_builtins.str]] = None,
            version_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceDatasetversion':
        """
        Get an existing WorkspaceDatasetversion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Update time.
        :param pulumi.Input[_builtins.int] data_count: Data count.
        :param pulumi.Input[_builtins.int] data_size: Data size.
        :param pulumi.Input[_builtins.str] data_source_type: The data source type. The following values are supported:
               - OSS: Alibaba Cloud Object Storage (OSS).
               - NAS: Alibaba cloud file storage (NAS).
        :param pulumi.Input[_builtins.str] dataset_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] description: Description of dataset version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceDatasetversionLabelArgs', 'WorkspaceDatasetversionLabelArgsDict']]]] labels: The tag of the resource See `labels` below.
        :param pulumi.Input[_builtins.str] options: The extended field, which is of the JsonString type.
               
               When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        :param pulumi.Input[_builtins.str] property: The properties of the dataset. The following values are supported:
               - FILE: FILE.
               - DIRECTORY: folder.
        :param pulumi.Input[_builtins.str] source_id: The data source ID.
        :param pulumi.Input[_builtins.str] source_type: The data source type. The default value is USER.
        :param pulumi.Input[_builtins.str] uri: The Uri configuration sample is as follows:
               - The data source type is OSS:'oss:// bucket.endpoint/object'
               - The data source type is NAS:
               
               The general NAS format is: 'nas://.region/subpath/to/dir/';
               
               CPFS1.0:'nas://.region/subpath/to/dir /';
               
               CPFS2.0:'nas://.region//'.
               
               CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        :param pulumi.Input[_builtins.str] version_name: The name of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceDatasetversionState.__new__(_WorkspaceDatasetversionState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_count"] = data_count
        __props__.__dict__["data_size"] = data_size
        __props__.__dict__["data_source_type"] = data_source_type
        __props__.__dict__["dataset_id"] = dataset_id
        __props__.__dict__["description"] = description
        __props__.__dict__["labels"] = labels
        __props__.__dict__["options"] = options
        __props__.__dict__["property"] = property
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["uri"] = uri
        __props__.__dict__["version_name"] = version_name
        return WorkspaceDatasetversion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Update time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataCount")
    def data_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Data count.
        """
        return pulumi.get(self, "data_count")

    @_builtins.property
    @pulumi.getter(name="dataSize")
    def data_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Data size.
        """
        return pulumi.get(self, "data_size")

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> pulumi.Output[_builtins.str]:
        """
        The data source type. The following values are supported:
        - OSS: Alibaba Cloud Object Storage (OSS).
        - NAS: Alibaba cloud file storage (NAS).
        """
        return pulumi.get(self, "data_source_type")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of dataset version.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceDatasetversionLabel']]]:
        """
        The tag of the resource See `labels` below.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The extended field, which is of the JsonString type.

        When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def property(self) -> pulumi.Output[_builtins.str]:
        """
        The properties of the dataset. The following values are supported:
        - FILE: FILE.
        - DIRECTORY: folder.
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The data source ID.
        """
        return pulumi.get(self, "source_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The data source type. The default value is USER.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Output[_builtins.str]:
        """
        The Uri configuration sample is as follows:
        - The data source type is OSS:'oss:// bucket.endpoint/object'
        - The data source type is NAS:

        The general NAS format is: 'nas://.region/subpath/to/dir/';

        CPFS1.0:'nas://.region/subpath/to/dir /';

        CPFS2.0:'nas://.region//'.

        CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "version_name")

