# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceMemberArgs', 'WorkspaceMember']

@pulumi.input_type
class WorkspaceMemberArgs:
    def __init__(__self__, *,
                 roles: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 user_id: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a WorkspaceMember resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The list of roles. see [how to use it](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-createmember).
        :param pulumi.Input[_builtins.str] user_id: The ID of the User.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the Workspace.
        """
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of roles. see [how to use it](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-createmember).
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the User.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _WorkspaceMemberState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 member_id: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceMember resources.
        :param pulumi.Input[_builtins.str] create_time: The time when the workspace is created, in UTC. The time follows the ISO 8601 standard.
        :param pulumi.Input[_builtins.str] member_id: The member ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The list of roles. see [how to use it](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-createmember).
        :param pulumi.Input[_builtins.str] user_id: The ID of the User.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the Workspace.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if member_id is not None:
            pulumi.set(__self__, "member_id", member_id)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the workspace is created, in UTC. The time follows the ISO 8601 standard.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="memberId")
    def member_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The member ID.
        """
        return pulumi.get(self, "member_id")

    @member_id.setter
    def member_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_id", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of roles. see [how to use it](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-createmember).
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the User.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("alicloud:pai/workspaceMember:WorkspaceMember")
class WorkspaceMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PAI Workspace Member resource.

        For information about PAI Workspace Member and how to use it, see [What is Member](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-createmember).

        > **NOTE:** Available since v1.249.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        workspace = alicloud.pai.WorkspaceWorkspace("Workspace",
            description="156",
            display_name=name,
            workspace_name=f"{name}_{default['result']}",
            env_types=["prod"])
        default_user = alicloud.ram.User("default", name=f"{name}-{default['result']}")
        default_workspace_member = alicloud.pai.WorkspaceMember("default",
            user_id=default_user.id,
            workspace_id=workspace.id,
            roles=[
                "PAI.AlgoDeveloper",
                "PAI.AlgoOperator",
                "PAI.LabelManager",
            ])
        ```

        ## Import

        PAI Workspace Member can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceMember:WorkspaceMember example <workspace_id>:<member_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The list of roles. see [how to use it](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-createmember).
        :param pulumi.Input[_builtins.str] user_id: The ID of the User.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the Workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PAI Workspace Member resource.

        For information about PAI Workspace Member and how to use it, see [What is Member](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-createmember).

        > **NOTE:** Available since v1.249.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        workspace = alicloud.pai.WorkspaceWorkspace("Workspace",
            description="156",
            display_name=name,
            workspace_name=f"{name}_{default['result']}",
            env_types=["prod"])
        default_user = alicloud.ram.User("default", name=f"{name}-{default['result']}")
        default_workspace_member = alicloud.pai.WorkspaceMember("default",
            user_id=default_user.id,
            workspace_id=workspace.id,
            roles=[
                "PAI.AlgoDeveloper",
                "PAI.AlgoOperator",
                "PAI.LabelManager",
            ])
        ```

        ## Import

        PAI Workspace Member can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceMember:WorkspaceMember example <workspace_id>:<member_id>
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceMemberArgs.__new__(WorkspaceMemberArgs)

            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["member_id"] = None
        super(WorkspaceMember, __self__).__init__(
            'alicloud:pai/workspaceMember:WorkspaceMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            member_id: Optional[pulumi.Input[_builtins.str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceMember':
        """
        Get an existing WorkspaceMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The time when the workspace is created, in UTC. The time follows the ISO 8601 standard.
        :param pulumi.Input[_builtins.str] member_id: The member ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The list of roles. see [how to use it](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-createmember).
        :param pulumi.Input[_builtins.str] user_id: The ID of the User.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the Workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceMemberState.__new__(_WorkspaceMemberState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["member_id"] = member_id
        __props__.__dict__["roles"] = roles
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceMember(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the workspace is created, in UTC. The time follows the ISO 8601 standard.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="memberId")
    def member_id(self) -> pulumi.Output[_builtins.str]:
        """
        The member ID.
        """
        return pulumi.get(self, "member_id")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of roles. see [how to use it](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-createmember).
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the User.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Workspace.
        """
        return pulumi.get(self, "workspace_id")

