# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceModelArgs', 'WorkspaceModel']

@pulumi.input_type
class WorkspaceModelArgs:
    def __init__(__self__, *,
                 model_name: pulumi.Input[_builtins.str],
                 accessibility: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelLabelArgs']]]] = None,
                 model_description: Optional[pulumi.Input[_builtins.str]] = None,
                 model_doc: Optional[pulumi.Input[_builtins.str]] = None,
                 model_type: Optional[pulumi.Input[_builtins.str]] = None,
                 order_number: Optional[pulumi.Input[_builtins.int]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 task: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceModel resource.
        :param pulumi.Input[_builtins.str] model_name: The name of the model. The name must be 1 to 127 characters in length.
        :param pulumi.Input[_builtins.str] accessibility: The visibility of the model in the workspace. Default value: `PRIVATE`. Valid values:
               - `PRIVATE`: In this workspace, it is only visible to you and the administrator.
               - `PUBLIC`: In this workspace, it is visible to everyone.
        :param pulumi.Input[_builtins.str] domain: The domain of the model. Describe the domain in which the model solves the problem. For example: nlp (natural language processing), cv (computer vision), etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_info: Other information about the model.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceModelLabelArgs']]] labels: A list of tags. See `labels` below.
        :param pulumi.Input[_builtins.str] model_description: The model description, used to distinguish different models.
        :param pulumi.Input[_builtins.str] model_doc: The documentation of the model.
        :param pulumi.Input[_builtins.str] model_type: The model type. Example: Checkpoint or LoRA.
        :param pulumi.Input[_builtins.int] order_number: The sequence number of the model. Can be used for custom sorting.
        :param pulumi.Input[_builtins.str] origin: The source of the model. The community or organization to which the source model belongs, such as ModelScope or HuggingFace.
        :param pulumi.Input[_builtins.str] task: The task of the model. Describes the specific problem that the model solves. Example: text-classification.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        pulumi.set(__self__, "model_name", model_name)
        if accessibility is not None:
            pulumi.set(__self__, "accessibility", accessibility)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if extra_info is not None:
            pulumi.set(__self__, "extra_info", extra_info)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if model_description is not None:
            pulumi.set(__self__, "model_description", model_description)
        if model_doc is not None:
            pulumi.set(__self__, "model_doc", model_doc)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if order_number is not None:
            pulumi.set(__self__, "order_number", order_number)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if task is not None:
            pulumi.set(__self__, "task", task)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="modelName")
    def model_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the model. The name must be 1 to 127 characters in length.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "model_name", value)

    @_builtins.property
    @pulumi.getter
    def accessibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The visibility of the model in the workspace. Default value: `PRIVATE`. Valid values:
        - `PRIVATE`: In this workspace, it is only visible to you and the administrator.
        - `PUBLIC`: In this workspace, it is visible to everyone.
        """
        return pulumi.get(self, "accessibility")

    @accessibility.setter
    def accessibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain of the model. Describe the domain in which the model solves the problem. For example: nlp (natural language processing), cv (computer vision), etc.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="extraInfo")
    def extra_info(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Other information about the model.
        """
        return pulumi.get(self, "extra_info")

    @extra_info.setter
    def extra_info(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extra_info", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelLabelArgs']]]]:
        """
        A list of tags. See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="modelDescription")
    def model_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model description, used to distinguish different models.
        """
        return pulumi.get(self, "model_description")

    @model_description.setter
    def model_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_description", value)

    @_builtins.property
    @pulumi.getter(name="modelDoc")
    def model_doc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The documentation of the model.
        """
        return pulumi.get(self, "model_doc")

    @model_doc.setter
    def model_doc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_doc", value)

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model type. Example: Checkpoint or LoRA.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_type", value)

    @_builtins.property
    @pulumi.getter(name="orderNumber")
    def order_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sequence number of the model. Can be used for custom sorting.
        """
        return pulumi.get(self, "order_number")

    @order_number.setter
    def order_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "order_number", value)

    @_builtins.property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source of the model. The community or organization to which the source model belongs, such as ModelScope or HuggingFace.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin", value)

    @_builtins.property
    @pulumi.getter
    def task(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The task of the model. Describes the specific problem that the model solves. Example: text-classification.
        """
        return pulumi.get(self, "task")

    @task.setter
    def task(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _WorkspaceModelState:
    def __init__(__self__, *,
                 accessibility: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelLabelArgs']]]] = None,
                 model_description: Optional[pulumi.Input[_builtins.str]] = None,
                 model_doc: Optional[pulumi.Input[_builtins.str]] = None,
                 model_name: Optional[pulumi.Input[_builtins.str]] = None,
                 model_type: Optional[pulumi.Input[_builtins.str]] = None,
                 order_number: Optional[pulumi.Input[_builtins.int]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 task: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceModel resources.
        :param pulumi.Input[_builtins.str] accessibility: The visibility of the model in the workspace. Default value: `PRIVATE`. Valid values:
               - `PRIVATE`: In this workspace, it is only visible to you and the administrator.
               - `PUBLIC`: In this workspace, it is visible to everyone.
        :param pulumi.Input[_builtins.str] domain: The domain of the model. Describe the domain in which the model solves the problem. For example: nlp (natural language processing), cv (computer vision), etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_info: Other information about the model.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceModelLabelArgs']]] labels: A list of tags. See `labels` below.
        :param pulumi.Input[_builtins.str] model_description: The model description, used to distinguish different models.
        :param pulumi.Input[_builtins.str] model_doc: The documentation of the model.
        :param pulumi.Input[_builtins.str] model_name: The name of the model. The name must be 1 to 127 characters in length.
        :param pulumi.Input[_builtins.str] model_type: The model type. Example: Checkpoint or LoRA.
        :param pulumi.Input[_builtins.int] order_number: The sequence number of the model. Can be used for custom sorting.
        :param pulumi.Input[_builtins.str] origin: The source of the model. The community or organization to which the source model belongs, such as ModelScope or HuggingFace.
        :param pulumi.Input[_builtins.str] task: The task of the model. Describes the specific problem that the model solves. Example: text-classification.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        if accessibility is not None:
            pulumi.set(__self__, "accessibility", accessibility)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if extra_info is not None:
            pulumi.set(__self__, "extra_info", extra_info)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if model_description is not None:
            pulumi.set(__self__, "model_description", model_description)
        if model_doc is not None:
            pulumi.set(__self__, "model_doc", model_doc)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if order_number is not None:
            pulumi.set(__self__, "order_number", order_number)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if task is not None:
            pulumi.set(__self__, "task", task)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def accessibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The visibility of the model in the workspace. Default value: `PRIVATE`. Valid values:
        - `PRIVATE`: In this workspace, it is only visible to you and the administrator.
        - `PUBLIC`: In this workspace, it is visible to everyone.
        """
        return pulumi.get(self, "accessibility")

    @accessibility.setter
    def accessibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain of the model. Describe the domain in which the model solves the problem. For example: nlp (natural language processing), cv (computer vision), etc.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="extraInfo")
    def extra_info(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Other information about the model.
        """
        return pulumi.get(self, "extra_info")

    @extra_info.setter
    def extra_info(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extra_info", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelLabelArgs']]]]:
        """
        A list of tags. See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceModelLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="modelDescription")
    def model_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model description, used to distinguish different models.
        """
        return pulumi.get(self, "model_description")

    @model_description.setter
    def model_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_description", value)

    @_builtins.property
    @pulumi.getter(name="modelDoc")
    def model_doc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The documentation of the model.
        """
        return pulumi.get(self, "model_doc")

    @model_doc.setter
    def model_doc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_doc", value)

    @_builtins.property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the model. The name must be 1 to 127 characters in length.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_name", value)

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model type. Example: Checkpoint or LoRA.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_type", value)

    @_builtins.property
    @pulumi.getter(name="orderNumber")
    def order_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sequence number of the model. Can be used for custom sorting.
        """
        return pulumi.get(self, "order_number")

    @order_number.setter
    def order_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "order_number", value)

    @_builtins.property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source of the model. The community or organization to which the source model belongs, such as ModelScope or HuggingFace.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin", value)

    @_builtins.property
    @pulumi.getter
    def task(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The task of the model. Describes the specific problem that the model solves. Example: text-classification.
        """
        return pulumi.get(self, "task")

    @task.setter
    def task(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("alicloud:pai/workspaceModel:WorkspaceModel")
class WorkspaceModel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceModelLabelArgs', 'WorkspaceModelLabelArgsDict']]]]] = None,
                 model_description: Optional[pulumi.Input[_builtins.str]] = None,
                 model_doc: Optional[pulumi.Input[_builtins.str]] = None,
                 model_name: Optional[pulumi.Input[_builtins.str]] = None,
                 model_type: Optional[pulumi.Input[_builtins.str]] = None,
                 order_number: Optional[pulumi.Input[_builtins.int]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 task: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PAI Workspace Model resource.

        For information about PAI Workspace Model and how to use it, see [What is Model](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-createmodel).

        > **NOTE:** Available since v1.249.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_e_nu_c6u = alicloud.pai.WorkspaceWorkspace("defaultENuC6u",
            description="156",
            display_name=name,
            workspace_name=f"{name}_{default['result']}",
            env_types=["prod"])
        default_workspace_model = alicloud.pai.WorkspaceModel("default",
            origin="Civitai",
            task="text-to-image-synthesis",
            model_name=name,
            accessibility="PRIVATE",
            workspace_id=default_e_nu_c6u.id,
            model_type="Checkpoint",
            labels=[{
                "key": "base_model",
                "value": "SD 1.5",
            }],
            order_number=1,
            extra_info={
                "test": "15",
            },
            model_description="ModelDescription.",
            model_doc="https://eas-***.oss-cn-hangzhou.aliyuncs.com/s**.safetensors",
            domain="aigc")
        ```

        ## Import

        PAI Workspace Model can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceModel:WorkspaceModel example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility: The visibility of the model in the workspace. Default value: `PRIVATE`. Valid values:
               - `PRIVATE`: In this workspace, it is only visible to you and the administrator.
               - `PUBLIC`: In this workspace, it is visible to everyone.
        :param pulumi.Input[_builtins.str] domain: The domain of the model. Describe the domain in which the model solves the problem. For example: nlp (natural language processing), cv (computer vision), etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_info: Other information about the model.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceModelLabelArgs', 'WorkspaceModelLabelArgsDict']]]] labels: A list of tags. See `labels` below.
        :param pulumi.Input[_builtins.str] model_description: The model description, used to distinguish different models.
        :param pulumi.Input[_builtins.str] model_doc: The documentation of the model.
        :param pulumi.Input[_builtins.str] model_name: The name of the model. The name must be 1 to 127 characters in length.
        :param pulumi.Input[_builtins.str] model_type: The model type. Example: Checkpoint or LoRA.
        :param pulumi.Input[_builtins.int] order_number: The sequence number of the model. Can be used for custom sorting.
        :param pulumi.Input[_builtins.str] origin: The source of the model. The community or organization to which the source model belongs, such as ModelScope or HuggingFace.
        :param pulumi.Input[_builtins.str] task: The task of the model. Describes the specific problem that the model solves. Example: text-classification.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PAI Workspace Model resource.

        For information about PAI Workspace Model and how to use it, see [What is Model](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-createmodel).

        > **NOTE:** Available since v1.249.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_e_nu_c6u = alicloud.pai.WorkspaceWorkspace("defaultENuC6u",
            description="156",
            display_name=name,
            workspace_name=f"{name}_{default['result']}",
            env_types=["prod"])
        default_workspace_model = alicloud.pai.WorkspaceModel("default",
            origin="Civitai",
            task="text-to-image-synthesis",
            model_name=name,
            accessibility="PRIVATE",
            workspace_id=default_e_nu_c6u.id,
            model_type="Checkpoint",
            labels=[{
                "key": "base_model",
                "value": "SD 1.5",
            }],
            order_number=1,
            extra_info={
                "test": "15",
            },
            model_description="ModelDescription.",
            model_doc="https://eas-***.oss-cn-hangzhou.aliyuncs.com/s**.safetensors",
            domain="aigc")
        ```

        ## Import

        PAI Workspace Model can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceModel:WorkspaceModel example <id>
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceModelLabelArgs', 'WorkspaceModelLabelArgsDict']]]]] = None,
                 model_description: Optional[pulumi.Input[_builtins.str]] = None,
                 model_doc: Optional[pulumi.Input[_builtins.str]] = None,
                 model_name: Optional[pulumi.Input[_builtins.str]] = None,
                 model_type: Optional[pulumi.Input[_builtins.str]] = None,
                 order_number: Optional[pulumi.Input[_builtins.int]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 task: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceModelArgs.__new__(WorkspaceModelArgs)

            __props__.__dict__["accessibility"] = accessibility
            __props__.__dict__["domain"] = domain
            __props__.__dict__["extra_info"] = extra_info
            __props__.__dict__["labels"] = labels
            __props__.__dict__["model_description"] = model_description
            __props__.__dict__["model_doc"] = model_doc
            if model_name is None and not opts.urn:
                raise TypeError("Missing required property 'model_name'")
            __props__.__dict__["model_name"] = model_name
            __props__.__dict__["model_type"] = model_type
            __props__.__dict__["order_number"] = order_number
            __props__.__dict__["origin"] = origin
            __props__.__dict__["task"] = task
            __props__.__dict__["workspace_id"] = workspace_id
        super(WorkspaceModel, __self__).__init__(
            'alicloud:pai/workspaceModel:WorkspaceModel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessibility: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            extra_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceModelLabelArgs', 'WorkspaceModelLabelArgsDict']]]]] = None,
            model_description: Optional[pulumi.Input[_builtins.str]] = None,
            model_doc: Optional[pulumi.Input[_builtins.str]] = None,
            model_name: Optional[pulumi.Input[_builtins.str]] = None,
            model_type: Optional[pulumi.Input[_builtins.str]] = None,
            order_number: Optional[pulumi.Input[_builtins.int]] = None,
            origin: Optional[pulumi.Input[_builtins.str]] = None,
            task: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceModel':
        """
        Get an existing WorkspaceModel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility: The visibility of the model in the workspace. Default value: `PRIVATE`. Valid values:
               - `PRIVATE`: In this workspace, it is only visible to you and the administrator.
               - `PUBLIC`: In this workspace, it is visible to everyone.
        :param pulumi.Input[_builtins.str] domain: The domain of the model. Describe the domain in which the model solves the problem. For example: nlp (natural language processing), cv (computer vision), etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_info: Other information about the model.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceModelLabelArgs', 'WorkspaceModelLabelArgsDict']]]] labels: A list of tags. See `labels` below.
        :param pulumi.Input[_builtins.str] model_description: The model description, used to distinguish different models.
        :param pulumi.Input[_builtins.str] model_doc: The documentation of the model.
        :param pulumi.Input[_builtins.str] model_name: The name of the model. The name must be 1 to 127 characters in length.
        :param pulumi.Input[_builtins.str] model_type: The model type. Example: Checkpoint or LoRA.
        :param pulumi.Input[_builtins.int] order_number: The sequence number of the model. Can be used for custom sorting.
        :param pulumi.Input[_builtins.str] origin: The source of the model. The community or organization to which the source model belongs, such as ModelScope or HuggingFace.
        :param pulumi.Input[_builtins.str] task: The task of the model. Describes the specific problem that the model solves. Example: text-classification.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceModelState.__new__(_WorkspaceModelState)

        __props__.__dict__["accessibility"] = accessibility
        __props__.__dict__["domain"] = domain
        __props__.__dict__["extra_info"] = extra_info
        __props__.__dict__["labels"] = labels
        __props__.__dict__["model_description"] = model_description
        __props__.__dict__["model_doc"] = model_doc
        __props__.__dict__["model_name"] = model_name
        __props__.__dict__["model_type"] = model_type
        __props__.__dict__["order_number"] = order_number
        __props__.__dict__["origin"] = origin
        __props__.__dict__["task"] = task
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceModel(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessibility(self) -> pulumi.Output[_builtins.str]:
        """
        The visibility of the model in the workspace. Default value: `PRIVATE`. Valid values:
        - `PRIVATE`: In this workspace, it is only visible to you and the administrator.
        - `PUBLIC`: In this workspace, it is visible to everyone.
        """
        return pulumi.get(self, "accessibility")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The domain of the model. Describe the domain in which the model solves the problem. For example: nlp (natural language processing), cv (computer vision), etc.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="extraInfo")
    def extra_info(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Other information about the model.
        """
        return pulumi.get(self, "extra_info")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceModelLabel']]]:
        """
        A list of tags. See `labels` below.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="modelDescription")
    def model_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The model description, used to distinguish different models.
        """
        return pulumi.get(self, "model_description")

    @_builtins.property
    @pulumi.getter(name="modelDoc")
    def model_doc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The documentation of the model.
        """
        return pulumi.get(self, "model_doc")

    @_builtins.property
    @pulumi.getter(name="modelName")
    def model_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the model. The name must be 1 to 127 characters in length.
        """
        return pulumi.get(self, "model_name")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The model type. Example: Checkpoint or LoRA.
        """
        return pulumi.get(self, "model_type")

    @_builtins.property
    @pulumi.getter(name="orderNumber")
    def order_number(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The sequence number of the model. Can be used for custom sorting.
        """
        return pulumi.get(self, "order_number")

    @_builtins.property
    @pulumi.getter
    def origin(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source of the model. The community or organization to which the source model belongs, such as ModelScope or HuggingFace.
        """
        return pulumi.get(self, "origin")

    @_builtins.property
    @pulumi.getter
    def task(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The task of the model. Describes the specific problem that the model solves. Example: text-classification.
        """
        return pulumi.get(self, "task")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

