# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DbProxyPublicArgs', 'DbProxyPublic']

@pulumi.input_type
class DbProxyPublicArgs:
    def __init__(__self__, *,
                 connection_string_prefix: pulumi.Input[_builtins.str],
                 db_instance_id: pulumi.Input[_builtins.str],
                 db_proxy_connection_string_net_type: pulumi.Input[_builtins.str],
                 db_proxy_endpoint_id: pulumi.Input[_builtins.str],
                 db_proxy_new_connect_string_port: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DbProxyPublic resource.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The prefix for the new database proxy connection address can be customized.
        :param pulumi.Input[_builtins.str] db_instance_id: Instance ID.
        :param pulumi.Input[_builtins.str] db_proxy_connection_string_net_type: The network type of the new database proxy connection address,This resource defaults to Public.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_id: Database proxy connection address ID.
        :param pulumi.Input[_builtins.str] db_proxy_new_connect_string_port: The port for the new database proxy connection address is 3306 by default for MySQL and 5432 by default for PostgreSQL, which can be customized.
        """
        pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "db_proxy_connection_string_net_type", db_proxy_connection_string_net_type)
        pulumi.set(__self__, "db_proxy_endpoint_id", db_proxy_endpoint_id)
        if db_proxy_new_connect_string_port is not None:
            pulumi.set(__self__, "db_proxy_new_connect_string_port", db_proxy_new_connect_string_port)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The prefix for the new database proxy connection address can be customized.
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyConnectionStringNetType")
    def db_proxy_connection_string_net_type(self) -> pulumi.Input[_builtins.str]:
        """
        The network type of the new database proxy connection address,This resource defaults to Public.
        """
        return pulumi.get(self, "db_proxy_connection_string_net_type")

    @db_proxy_connection_string_net_type.setter
    def db_proxy_connection_string_net_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_proxy_connection_string_net_type", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyEndpointId")
    def db_proxy_endpoint_id(self) -> pulumi.Input[_builtins.str]:
        """
        Database proxy connection address ID.
        """
        return pulumi.get(self, "db_proxy_endpoint_id")

    @db_proxy_endpoint_id.setter
    def db_proxy_endpoint_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_proxy_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyNewConnectStringPort")
    def db_proxy_new_connect_string_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port for the new database proxy connection address is 3306 by default for MySQL and 5432 by default for PostgreSQL, which can be customized.
        """
        return pulumi.get(self, "db_proxy_new_connect_string_port")

    @db_proxy_new_connect_string_port.setter
    def db_proxy_new_connect_string_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_new_connect_string_port", value)


@pulumi.input_type
class _DbProxyPublicState:
    def __init__(__self__, *,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_connection_string_net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_new_connect_string_port: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbProxyPublic resources.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The prefix for the new database proxy connection address can be customized.
        :param pulumi.Input[_builtins.str] db_instance_id: Instance ID.
        :param pulumi.Input[_builtins.str] db_proxy_connection_string_net_type: The network type of the new database proxy connection address,This resource defaults to Public.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_id: Database proxy connection address ID.
        :param pulumi.Input[_builtins.str] db_proxy_new_connect_string_port: The port for the new database proxy connection address is 3306 by default for MySQL and 5432 by default for PostgreSQL, which can be customized.
        """
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if db_proxy_connection_string_net_type is not None:
            pulumi.set(__self__, "db_proxy_connection_string_net_type", db_proxy_connection_string_net_type)
        if db_proxy_endpoint_id is not None:
            pulumi.set(__self__, "db_proxy_endpoint_id", db_proxy_endpoint_id)
        if db_proxy_new_connect_string_port is not None:
            pulumi.set(__self__, "db_proxy_new_connect_string_port", db_proxy_new_connect_string_port)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix for the new database proxy connection address can be customized.
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyConnectionStringNetType")
    def db_proxy_connection_string_net_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the new database proxy connection address,This resource defaults to Public.
        """
        return pulumi.get(self, "db_proxy_connection_string_net_type")

    @db_proxy_connection_string_net_type.setter
    def db_proxy_connection_string_net_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_connection_string_net_type", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyEndpointId")
    def db_proxy_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database proxy connection address ID.
        """
        return pulumi.get(self, "db_proxy_endpoint_id")

    @db_proxy_endpoint_id.setter
    def db_proxy_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyNewConnectStringPort")
    def db_proxy_new_connect_string_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port for the new database proxy connection address is 3306 by default for MySQL and 5432 by default for PostgreSQL, which can be customized.
        """
        return pulumi.get(self, "db_proxy_new_connect_string_port")

    @db_proxy_new_connect_string_port.setter
    def db_proxy_new_connect_string_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_new_connect_string_port", value)


@pulumi.type_token("alicloud:rds/dbProxyPublic:DbProxyPublic")
class DbProxyPublic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_connection_string_net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_new_connect_string_port: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RDS database proxy public network address resource.

        For information about Resource AlicloudRdsDBProxyPublic and how to use it, see [What is proxy](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-createdbproxyendpointaddress).

        > **NOTE:** Available since v1.250.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.rds.get_zones(engine="MySQL",
            engine_version="5.6")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.rds.Instance("default",
            engine="MySQL",
            engine_version="5.7",
            instance_type="rds.mysql.c1.large",
            instance_storage=20,
            instance_charge_type="Postpaid",
            instance_name=name,
            vswitch_id=default_switch.id,
            db_instance_storage_type="local_ssd")
        default_read_only_instance = alicloud.rds.ReadOnlyInstance("default",
            zone_id=default_instance.zone_id,
            master_db_instance_id=default_instance.id,
            engine_version=default_instance.engine_version,
            instance_storage=default_instance.instance_storage,
            instance_type=default_instance.instance_type,
            instance_name=f"{name}readonly",
            vswitch_id=default_switch.id)
        default_rds_db_proxy = alicloud.rds.RdsDbProxy("default",
            instance_id=default_instance.id,
            instance_network_type="VPC",
            vpc_id=default_instance.vpc_id,
            vswitch_id=default_instance.vswitch_id,
            db_proxy_instance_num=2,
            db_proxy_connection_prefix="example",
            db_proxy_connect_string_port=3306,
            db_proxy_endpoint_read_write_mode="ReadWrite",
            read_only_instance_max_delay_time=90,
            db_proxy_features="TransactionReadSqlRouteOptimizeStatus:1;ConnectionPersist:1;ReadWriteSpliting:1",
            read_only_instance_distribution_type="Custom",
            read_only_instance_weights=[
                {
                    "instance_id": default_instance.id,
                    "weight": "100",
                },
                {
                    "instance_id": default_read_only_instance.id,
                    "weight": "500",
                },
            ])
        default_db_proxy_public = alicloud.rds.DbProxyPublic("default",
            db_instance_id=default_instance.id,
            db_proxy_endpoint_id=default_rds_db_proxy.db_proxy_endpoint_id,
            connection_string_prefix="exampleabc",
            db_proxy_connection_string_net_type="Public",
            db_proxy_new_connect_string_port="3306")
        ```

        > **NOTE:** Resource `rds.DbProxyPublic` should be created after `rds.RdsDbProxy`, so the `depends_on` statement is necessary.

        ## Import

        RDS Database Proxy Public Network Address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/dbProxyPublic:DbProxyPublic example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The prefix for the new database proxy connection address can be customized.
        :param pulumi.Input[_builtins.str] db_instance_id: Instance ID.
        :param pulumi.Input[_builtins.str] db_proxy_connection_string_net_type: The network type of the new database proxy connection address,This resource defaults to Public.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_id: Database proxy connection address ID.
        :param pulumi.Input[_builtins.str] db_proxy_new_connect_string_port: The port for the new database proxy connection address is 3306 by default for MySQL and 5432 by default for PostgreSQL, which can be customized.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbProxyPublicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RDS database proxy public network address resource.

        For information about Resource AlicloudRdsDBProxyPublic and how to use it, see [What is proxy](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-createdbproxyendpointaddress).

        > **NOTE:** Available since v1.250.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.rds.get_zones(engine="MySQL",
            engine_version="5.6")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.rds.Instance("default",
            engine="MySQL",
            engine_version="5.7",
            instance_type="rds.mysql.c1.large",
            instance_storage=20,
            instance_charge_type="Postpaid",
            instance_name=name,
            vswitch_id=default_switch.id,
            db_instance_storage_type="local_ssd")
        default_read_only_instance = alicloud.rds.ReadOnlyInstance("default",
            zone_id=default_instance.zone_id,
            master_db_instance_id=default_instance.id,
            engine_version=default_instance.engine_version,
            instance_storage=default_instance.instance_storage,
            instance_type=default_instance.instance_type,
            instance_name=f"{name}readonly",
            vswitch_id=default_switch.id)
        default_rds_db_proxy = alicloud.rds.RdsDbProxy("default",
            instance_id=default_instance.id,
            instance_network_type="VPC",
            vpc_id=default_instance.vpc_id,
            vswitch_id=default_instance.vswitch_id,
            db_proxy_instance_num=2,
            db_proxy_connection_prefix="example",
            db_proxy_connect_string_port=3306,
            db_proxy_endpoint_read_write_mode="ReadWrite",
            read_only_instance_max_delay_time=90,
            db_proxy_features="TransactionReadSqlRouteOptimizeStatus:1;ConnectionPersist:1;ReadWriteSpliting:1",
            read_only_instance_distribution_type="Custom",
            read_only_instance_weights=[
                {
                    "instance_id": default_instance.id,
                    "weight": "100",
                },
                {
                    "instance_id": default_read_only_instance.id,
                    "weight": "500",
                },
            ])
        default_db_proxy_public = alicloud.rds.DbProxyPublic("default",
            db_instance_id=default_instance.id,
            db_proxy_endpoint_id=default_rds_db_proxy.db_proxy_endpoint_id,
            connection_string_prefix="exampleabc",
            db_proxy_connection_string_net_type="Public",
            db_proxy_new_connect_string_port="3306")
        ```

        > **NOTE:** Resource `rds.DbProxyPublic` should be created after `rds.RdsDbProxy`, so the `depends_on` statement is necessary.

        ## Import

        RDS Database Proxy Public Network Address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/dbProxyPublic:DbProxyPublic example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DbProxyPublicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbProxyPublicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_connection_string_net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_new_connect_string_port: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbProxyPublicArgs.__new__(DbProxyPublicArgs)

            if connection_string_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'connection_string_prefix'")
            __props__.__dict__["connection_string_prefix"] = connection_string_prefix
            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            if db_proxy_connection_string_net_type is None and not opts.urn:
                raise TypeError("Missing required property 'db_proxy_connection_string_net_type'")
            __props__.__dict__["db_proxy_connection_string_net_type"] = db_proxy_connection_string_net_type
            if db_proxy_endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_proxy_endpoint_id'")
            __props__.__dict__["db_proxy_endpoint_id"] = db_proxy_endpoint_id
            __props__.__dict__["db_proxy_new_connect_string_port"] = db_proxy_new_connect_string_port
        super(DbProxyPublic, __self__).__init__(
            'alicloud:rds/dbProxyPublic:DbProxyPublic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_proxy_connection_string_net_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_proxy_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_proxy_new_connect_string_port: Optional[pulumi.Input[_builtins.str]] = None) -> 'DbProxyPublic':
        """
        Get an existing DbProxyPublic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The prefix for the new database proxy connection address can be customized.
        :param pulumi.Input[_builtins.str] db_instance_id: Instance ID.
        :param pulumi.Input[_builtins.str] db_proxy_connection_string_net_type: The network type of the new database proxy connection address,This resource defaults to Public.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_id: Database proxy connection address ID.
        :param pulumi.Input[_builtins.str] db_proxy_new_connect_string_port: The port for the new database proxy connection address is 3306 by default for MySQL and 5432 by default for PostgreSQL, which can be customized.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbProxyPublicState.__new__(_DbProxyPublicState)

        __props__.__dict__["connection_string_prefix"] = connection_string_prefix
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["db_proxy_connection_string_net_type"] = db_proxy_connection_string_net_type
        __props__.__dict__["db_proxy_endpoint_id"] = db_proxy_endpoint_id
        __props__.__dict__["db_proxy_new_connect_string_port"] = db_proxy_new_connect_string_port
        return DbProxyPublic(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The prefix for the new database proxy connection address can be customized.
        """
        return pulumi.get(self, "connection_string_prefix")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="dbProxyConnectionStringNetType")
    def db_proxy_connection_string_net_type(self) -> pulumi.Output[_builtins.str]:
        """
        The network type of the new database proxy connection address,This resource defaults to Public.
        """
        return pulumi.get(self, "db_proxy_connection_string_net_type")

    @_builtins.property
    @pulumi.getter(name="dbProxyEndpointId")
    def db_proxy_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        Database proxy connection address ID.
        """
        return pulumi.get(self, "db_proxy_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="dbProxyNewConnectStringPort")
    def db_proxy_new_connect_string_port(self) -> pulumi.Output[_builtins.str]:
        """
        The port for the new database proxy connection address is 3306 by default for MySQL and 5432 by default for PostgreSQL, which can be customized.
        """
        return pulumi.get(self, "db_proxy_new_connect_string_port")

