# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCharacterSetNamesResult',
    'AwaitableGetCharacterSetNamesResult',
    'get_character_set_names',
    'get_character_set_names_output',
]

@pulumi.output_type
class GetCharacterSetNamesResult:
    """
    A collection of values returned by getCharacterSetNames.
    """
    def __init__(__self__, engine=None, id=None, names=None, output_file=None):
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetCharacterSetNamesResult(GetCharacterSetNamesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCharacterSetNamesResult(
            engine=self.engine,
            id=self.id,
            names=self.names,
            output_file=self.output_file)


def get_character_set_names(engine: Optional[_builtins.str] = None,
                            output_file: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCharacterSetNamesResult:
    """
    This data source is the character set supported by querying RDS instances.

    > **NOTE:** Available in v1.198.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    names = alicloud.rds.get_character_set_names(engine="MySQL")
    pulumi.export("firstRdsCharacterSetNames", names.names[0])
    ```


    :param _builtins.str engine: Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`.
    """
    __args__ = dict()
    __args__['engine'] = engine
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:rds/getCharacterSetNames:getCharacterSetNames', __args__, opts=opts, typ=GetCharacterSetNamesResult).value

    return AwaitableGetCharacterSetNamesResult(
        engine=pulumi.get(__ret__, 'engine'),
        id=pulumi.get(__ret__, 'id'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_character_set_names_output(engine: Optional[pulumi.Input[_builtins.str]] = None,
                                   output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCharacterSetNamesResult]:
    """
    This data source is the character set supported by querying RDS instances.

    > **NOTE:** Available in v1.198.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    names = alicloud.rds.get_character_set_names(engine="MySQL")
    pulumi.export("firstRdsCharacterSetNames", names.names[0])
    ```


    :param _builtins.str engine: Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`.
    """
    __args__ = dict()
    __args__['engine'] = engine
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:rds/getCharacterSetNames:getCharacterSetNames', __args__, opts=opts, typ=GetCharacterSetNamesResult)
    return __ret__.apply(lambda __response__: GetCharacterSetNamesResult(
        engine=pulumi.get(__response__, 'engine'),
        id=pulumi.get(__response__, 'id'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file')))
