# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SavedQueryArgs', 'SavedQuery']

@pulumi.input_type
class SavedQueryArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 saved_query_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SavedQuery resource.
        :param pulumi.Input[_builtins.str] expression: Query Expression.
        :param pulumi.Input[_builtins.str] saved_query_name: The name of the resource.
        :param pulumi.Input[_builtins.str] description: Query Description.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "saved_query_name", saved_query_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        Query Expression.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter(name="savedQueryName")
    def saved_query_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "saved_query_name")

    @saved_query_name.setter
    def saved_query_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "saved_query_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _SavedQueryState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expression: Optional[pulumi.Input[_builtins.str]] = None,
                 saved_query_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SavedQuery resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] description: Query Description.
        :param pulumi.Input[_builtins.str] expression: Query Expression.
        :param pulumi.Input[_builtins.str] saved_query_name: The name of the resource.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if saved_query_name is not None:
            pulumi.set(__self__, "saved_query_name", saved_query_name)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query Expression.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter(name="savedQueryName")
    def saved_query_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "saved_query_name")

    @saved_query_name.setter
    def saved_query_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saved_query_name", value)


@pulumi.type_token("alicloud:resourcemanager/savedQuery:SavedQuery")
class SavedQuery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expression: Optional[pulumi.Input[_builtins.str]] = None,
                 saved_query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Resource Manager Saved Query resource. ResourceCenter Saved Query.

        For information about Resource Manager Saved Query and how to use it, see [What is Saved Query](https://www.alibabacloud.com/help/zh/resource-management/developer-reference/api-resourcecenter-2022-12-01-createsavedquery).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.SavedQuery("default",
            description=name,
            expression="select * from resources limit 1;",
            saved_query_name=name)
        ```

        ## Import

        Resource Manager Saved Query can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/savedQuery:SavedQuery example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Query Description.
        :param pulumi.Input[_builtins.str] expression: Query Expression.
        :param pulumi.Input[_builtins.str] saved_query_name: The name of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SavedQueryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Resource Manager Saved Query resource. ResourceCenter Saved Query.

        For information about Resource Manager Saved Query and how to use it, see [What is Saved Query](https://www.alibabacloud.com/help/zh/resource-management/developer-reference/api-resourcecenter-2022-12-01-createsavedquery).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.SavedQuery("default",
            description=name,
            expression="select * from resources limit 1;",
            saved_query_name=name)
        ```

        ## Import

        Resource Manager Saved Query can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/savedQuery:SavedQuery example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SavedQueryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SavedQueryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expression: Optional[pulumi.Input[_builtins.str]] = None,
                 saved_query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SavedQueryArgs.__new__(SavedQueryArgs)

            __props__.__dict__["description"] = description
            if expression is None and not opts.urn:
                raise TypeError("Missing required property 'expression'")
            __props__.__dict__["expression"] = expression
            if saved_query_name is None and not opts.urn:
                raise TypeError("Missing required property 'saved_query_name'")
            __props__.__dict__["saved_query_name"] = saved_query_name
            __props__.__dict__["create_time"] = None
        super(SavedQuery, __self__).__init__(
            'alicloud:resourcemanager/savedQuery:SavedQuery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            expression: Optional[pulumi.Input[_builtins.str]] = None,
            saved_query_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'SavedQuery':
        """
        Get an existing SavedQuery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] description: Query Description.
        :param pulumi.Input[_builtins.str] expression: Query Expression.
        :param pulumi.Input[_builtins.str] saved_query_name: The name of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SavedQueryState.__new__(_SavedQueryState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["expression"] = expression
        __props__.__dict__["saved_query_name"] = saved_query_name
        return SavedQuery(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Query Description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Output[_builtins.str]:
        """
        Query Expression.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter(name="savedQueryName")
    def saved_query_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "saved_query_name")

