# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DomainCertInfo',
    'DomainConfigFunctionArg',
    'DomainSource',
    'GetDomainsDomainResult',
    'GetDomainsDomainCertInfoResult',
    'GetDomainsDomainSourceResult',
]

@pulumi.output_type
class DomainCertInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certName":
            suggest = "cert_name"
        elif key == "certType":
            suggest = "cert_type"
        elif key == "sslPri":
            suggest = "ssl_pri"
        elif key == "sslProtocol":
            suggest = "ssl_protocol"
        elif key == "sslPub":
            suggest = "ssl_pub"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainCertInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainCertInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainCertInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_name: Optional[_builtins.str] = None,
                 cert_type: Optional[_builtins.str] = None,
                 ssl_pri: Optional[_builtins.str] = None,
                 ssl_protocol: Optional[_builtins.str] = None,
                 ssl_pub: Optional[_builtins.str] = None):
        """
        :param _builtins.str cert_name: If You Enable HTTPS Here Certificate Name.
        :param _builtins.str cert_type: Certificate Type. Value Range: 
               * upload: Certificate
               * cas: Certificate Authority Certificate.
               * free: Free Certificate.
        :param _builtins.str ssl_pri: Private Key. Do Not Enable Certificate without Entering a User Name and Configure Certificates Enter Private Key.
        :param _builtins.str ssl_protocol: Whether to Enable SSL Certificate. Valid Values: on, off. Valid values: `on`, `off`.
        :param _builtins.str ssl_pub: If You Enable HTTPS Here Key.
        """
        if cert_name is not None:
            pulumi.set(__self__, "cert_name", cert_name)
        if cert_type is not None:
            pulumi.set(__self__, "cert_type", cert_type)
        if ssl_pri is not None:
            pulumi.set(__self__, "ssl_pri", ssl_pri)
        if ssl_protocol is not None:
            pulumi.set(__self__, "ssl_protocol", ssl_protocol)
        if ssl_pub is not None:
            pulumi.set(__self__, "ssl_pub", ssl_pub)

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> Optional[_builtins.str]:
        """
        If You Enable HTTPS Here Certificate Name.
        """
        return pulumi.get(self, "cert_name")

    @_builtins.property
    @pulumi.getter(name="certType")
    def cert_type(self) -> Optional[_builtins.str]:
        """
        Certificate Type. Value Range: 
        * upload: Certificate
        * cas: Certificate Authority Certificate.
        * free: Free Certificate.
        """
        return pulumi.get(self, "cert_type")

    @_builtins.property
    @pulumi.getter(name="sslPri")
    def ssl_pri(self) -> Optional[_builtins.str]:
        """
        Private Key. Do Not Enable Certificate without Entering a User Name and Configure Certificates Enter Private Key.
        """
        return pulumi.get(self, "ssl_pri")

    @_builtins.property
    @pulumi.getter(name="sslProtocol")
    def ssl_protocol(self) -> Optional[_builtins.str]:
        """
        Whether to Enable SSL Certificate. Valid Values: on, off. Valid values: `on`, `off`.
        """
        return pulumi.get(self, "ssl_protocol")

    @_builtins.property
    @pulumi.getter(name="sslPub")
    def ssl_pub(self) -> Optional[_builtins.str]:
        """
        If You Enable HTTPS Here Key.
        """
        return pulumi.get(self, "ssl_pub")


@pulumi.output_type
class DomainConfigFunctionArg(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "argName":
            suggest = "arg_name"
        elif key == "argValue":
            suggest = "arg_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainConfigFunctionArg. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainConfigFunctionArg.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainConfigFunctionArg.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arg_name: _builtins.str,
                 arg_value: _builtins.str):
        """
        :param _builtins.str arg_name: The name of arg.
        :param _builtins.str arg_value: The value of arg.
        """
        pulumi.set(__self__, "arg_name", arg_name)
        pulumi.set(__self__, "arg_value", arg_value)

    @_builtins.property
    @pulumi.getter(name="argName")
    def arg_name(self) -> _builtins.str:
        """
        The name of arg.
        """
        return pulumi.get(self, "arg_name")

    @_builtins.property
    @pulumi.getter(name="argValue")
    def arg_value(self) -> _builtins.str:
        """
        The value of arg.
        """
        return pulumi.get(self, "arg_value")


@pulumi.output_type
class DomainSource(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 port: _builtins.int,
                 priority: _builtins.str,
                 type: _builtins.str,
                 enabled: Optional[_builtins.str] = None):
        """
        :param _builtins.str content: The Back-to-Source Address.
        :param _builtins.int port: Port.
        :param _builtins.str priority: Priority.
        :param _builtins.str type: The Origin Server Type. Valid Values: 
               * ipaddr: IP Source Station
               * domain: the Domain Name
               * oss: OSS Bucket as a Source Station.
        :param _builtins.str enabled: The source status. Valid values: online, offline.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "type", type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The Back-to-Source Address.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.str:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Origin Server Type. Valid Values: 
        * ipaddr: IP Source Station
        * domain: the Domain Name
        * oss: OSS Bucket as a Source Station.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.str]:
        """
        The source status. Valid values: online, offline.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetDomainsDomainResult(dict):
    def __init__(__self__, *,
                 cert_infos: Sequence['outputs.GetDomainsDomainCertInfoResult'],
                 cname: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 domain_name: _builtins.str,
                 gmt_modified: _builtins.str,
                 id: _builtins.str,
                 resource_group_id: _builtins.str,
                 sources: Sequence['outputs.GetDomainsDomainSourceResult'],
                 status: _builtins.str):
        """
        :param Sequence['GetDomainsDomainCertInfoArgs'] cert_infos: Certificate Information.
        :param _builtins.str cname: In Order to Link the CDN Domain Name to Generate a CNAME Domain Name, in the Domain Name Resolution Service Provider at the Acceleration Domain Name CNAME Resolution to the Domain.
        :param _builtins.str create_time: Creation Time.
        :param _builtins.str description: Review the Reason for the Failure Is Displayed.
        :param _builtins.str domain_name: Your Domain Name.
        :param _builtins.str gmt_modified: Last Modified Date.
        :param _builtins.str id: The ID of the Domain. Its value is same as Queue Name.
        :param _builtins.str resource_group_id: The Resource Group ID.
        :param Sequence['GetDomainsDomainSourceArgs'] sources: the Origin Server Information.
        :param _builtins.str status: The status of the resource.
        """
        pulumi.set(__self__, "cert_infos", cert_infos)
        pulumi.set(__self__, "cname", cname)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "gmt_modified", gmt_modified)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="certInfos")
    def cert_infos(self) -> Sequence['outputs.GetDomainsDomainCertInfoResult']:
        """
        Certificate Information.
        """
        return pulumi.get(self, "cert_infos")

    @_builtins.property
    @pulumi.getter
    def cname(self) -> _builtins.str:
        """
        In Order to Link the CDN Domain Name to Generate a CNAME Domain Name, in the Domain Name Resolution Service Provider at the Acceleration Domain Name CNAME Resolution to the Domain.
        """
        return pulumi.get(self, "cname")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Creation Time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Review the Reason for the Failure Is Displayed.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        Your Domain Name.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> _builtins.str:
        """
        Last Modified Date.
        """
        return pulumi.get(self, "gmt_modified")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Domain. Its value is same as Queue Name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetDomainsDomainSourceResult']:
        """
        the Origin Server Information.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDomainsDomainCertInfoResult(dict):
    def __init__(__self__, *,
                 cert_name: _builtins.str,
                 cert_type: _builtins.str,
                 ssl_protocol: _builtins.str,
                 ssl_pub: _builtins.str):
        """
        :param _builtins.str cert_name: If You Enable HTTPS Here Certificate Name.
        :param _builtins.str cert_type: Certificate Type. Value Range: Upload: Certificate. CAS: Certificate Authority Certificate. Free: Free Certificate.
        :param _builtins.str ssl_protocol: Whether to Enable SSL Certificate. Valid Values: on, off.
        :param _builtins.str ssl_pub: If You Enable HTTPS Here Key.
        """
        pulumi.set(__self__, "cert_name", cert_name)
        pulumi.set(__self__, "cert_type", cert_type)
        pulumi.set(__self__, "ssl_protocol", ssl_protocol)
        pulumi.set(__self__, "ssl_pub", ssl_pub)

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> _builtins.str:
        """
        If You Enable HTTPS Here Certificate Name.
        """
        return pulumi.get(self, "cert_name")

    @_builtins.property
    @pulumi.getter(name="certType")
    def cert_type(self) -> _builtins.str:
        """
        Certificate Type. Value Range: Upload: Certificate. CAS: Certificate Authority Certificate. Free: Free Certificate.
        """
        return pulumi.get(self, "cert_type")

    @_builtins.property
    @pulumi.getter(name="sslProtocol")
    def ssl_protocol(self) -> _builtins.str:
        """
        Whether to Enable SSL Certificate. Valid Values: on, off.
        """
        return pulumi.get(self, "ssl_protocol")

    @_builtins.property
    @pulumi.getter(name="sslPub")
    def ssl_pub(self) -> _builtins.str:
        """
        If You Enable HTTPS Here Key.
        """
        return pulumi.get(self, "ssl_pub")


@pulumi.output_type
class GetDomainsDomainSourceResult(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 enabled: _builtins.str,
                 port: _builtins.int,
                 priority: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str content: The Back-to-Source Address.
        :param _builtins.str enabled: State.
        :param _builtins.int port: Port.
        :param _builtins.str priority: Priority.
        :param _builtins.str type: the Origin Server Type. Valid Values: Ipaddr: IP Source Station Domain: the Domain Name, See Extra Domain Quota OSS: OSS Bucket as a Source Station.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The Back-to-Source Address.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.str:
        """
        State.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.str:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        the Origin Server Type. Valid Values: Ipaddr: IP Source Station Domain: the Domain Name, See Extra Domain Quota OSS: OSS Bucket as a Source Station.
        """
        return pulumi.get(self, "type")


