# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetForwardEntriesResult',
    'AwaitableGetForwardEntriesResult',
    'get_forward_entries',
    'get_forward_entries_output',
]

@pulumi.output_type
class GetForwardEntriesResult:
    """
    A collection of values returned by getForwardEntries.
    """
    def __init__(__self__, entries=None, external_ip=None, external_port=None, forward_entry_name=None, forward_table_id=None, id=None, ids=None, internal_ip=None, internal_port=None, ip_protocol=None, name_regex=None, names=None, output_file=None, status=None):
        if entries and not isinstance(entries, list):
            raise TypeError("Expected argument 'entries' to be a list")
        pulumi.set(__self__, "entries", entries)
        if external_ip and not isinstance(external_ip, str):
            raise TypeError("Expected argument 'external_ip' to be a str")
        pulumi.set(__self__, "external_ip", external_ip)
        if external_port and not isinstance(external_port, str):
            raise TypeError("Expected argument 'external_port' to be a str")
        pulumi.set(__self__, "external_port", external_port)
        if forward_entry_name and not isinstance(forward_entry_name, str):
            raise TypeError("Expected argument 'forward_entry_name' to be a str")
        pulumi.set(__self__, "forward_entry_name", forward_entry_name)
        if forward_table_id and not isinstance(forward_table_id, str):
            raise TypeError("Expected argument 'forward_table_id' to be a str")
        pulumi.set(__self__, "forward_table_id", forward_table_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if internal_ip and not isinstance(internal_ip, str):
            raise TypeError("Expected argument 'internal_ip' to be a str")
        pulumi.set(__self__, "internal_ip", internal_ip)
        if internal_port and not isinstance(internal_port, str):
            raise TypeError("Expected argument 'internal_port' to be a str")
        pulumi.set(__self__, "internal_port", internal_port)
        if ip_protocol and not isinstance(ip_protocol, str):
            raise TypeError("Expected argument 'ip_protocol' to be a str")
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.GetForwardEntriesEntryResult']:
        """
        A list of Forward Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> Optional[_builtins.str]:
        """
        The public IP address.
        """
        return pulumi.get(self, "external_ip")

    @_builtins.property
    @pulumi.getter(name="externalPort")
    def external_port(self) -> Optional[_builtins.str]:
        """
        The public port.
        """
        return pulumi.get(self, "external_port")

    @_builtins.property
    @pulumi.getter(name="forwardEntryName")
    def forward_entry_name(self) -> Optional[_builtins.str]:
        """
        The name of forward entry.
        """
        return pulumi.get(self, "forward_entry_name")

    @_builtins.property
    @pulumi.getter(name="forwardTableId")
    def forward_table_id(self) -> _builtins.str:
        return pulumi.get(self, "forward_table_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Forward Entries IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> Optional[_builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "internal_ip")

    @_builtins.property
    @pulumi.getter(name="internalPort")
    def internal_port(self) -> Optional[_builtins.str]:
        """
        The private port.
        """
        return pulumi.get(self, "internal_port")

    @_builtins.property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[_builtins.str]:
        """
        The protocol type.
        """
        return pulumi.get(self, "ip_protocol")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Forward Entries names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of forward entry.
        """
        return pulumi.get(self, "status")


class AwaitableGetForwardEntriesResult(GetForwardEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetForwardEntriesResult(
            entries=self.entries,
            external_ip=self.external_ip,
            external_port=self.external_port,
            forward_entry_name=self.forward_entry_name,
            forward_table_id=self.forward_table_id,
            id=self.id,
            ids=self.ids,
            internal_ip=self.internal_ip,
            internal_port=self.internal_port,
            ip_protocol=self.ip_protocol,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status)


def get_forward_entries(external_ip: Optional[_builtins.str] = None,
                        external_port: Optional[_builtins.str] = None,
                        forward_entry_name: Optional[_builtins.str] = None,
                        forward_table_id: Optional[_builtins.str] = None,
                        ids: Optional[Sequence[_builtins.str]] = None,
                        internal_ip: Optional[_builtins.str] = None,
                        internal_port: Optional[_builtins.str] = None,
                        ip_protocol: Optional[_builtins.str] = None,
                        name_regex: Optional[_builtins.str] = None,
                        output_file: Optional[_builtins.str] = None,
                        status: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetForwardEntriesResult:
    """
    This data source provides a list of Forward Entries owned by an Alibaba Cloud account.

    > **NOTE:** Available since v1.37.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "forward-entry-config-example-name"
    default = alicloud.get_zones(available_resource_creation="VSwitch")
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="172.16.0.0/12")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/21",
        zone_id=default.zones[0].id,
        vswitch_name=name)
    default_nat_gateway = alicloud.vpc.NatGateway("default",
        vpc_id=default_network.id,
        internet_charge_type="PayByLcu",
        nat_gateway_name=name,
        nat_type="Enhanced",
        vswitch_id=default_switch.id)
    default_eip_address = alicloud.ecs.EipAddress("default", address_name=name)
    default_eip_association = alicloud.ecs.EipAssociation("default",
        allocation_id=default_eip_address.id,
        instance_id=default_nat_gateway.id)
    default_forward_entry = alicloud.vpc.ForwardEntry("default",
        forward_table_id=default_nat_gateway.forward_table_ids,
        external_ip=default_eip_address.ip_address,
        external_port="80",
        ip_protocol="tcp",
        internal_ip="172.16.0.3",
        internal_port="8080")
    default_get_forward_entries = alicloud.vpc.get_forward_entries_output(forward_table_id=default_forward_entry.forward_table_id)
    ```


    :param _builtins.str external_ip: The public IP address.
    :param _builtins.str external_port: The public port.
    :param _builtins.str forward_entry_name: The name of forward entry.
    :param _builtins.str forward_table_id: The ID of the Forward table.
    :param Sequence[_builtins.str] ids: A list of Forward Entries IDs.
    :param _builtins.str internal_ip: The private IP address.
    :param _builtins.str internal_port: The internal port.
    :param _builtins.str ip_protocol: The ip protocol. Valid values: `any`,`tcp` and `udp`.
    :param _builtins.str name_regex: A regex string to filter results by forward entry name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of farward entry. Valid value `Available`, `Deleting` and `Pending`.
    """
    __args__ = dict()
    __args__['externalIp'] = external_ip
    __args__['externalPort'] = external_port
    __args__['forwardEntryName'] = forward_entry_name
    __args__['forwardTableId'] = forward_table_id
    __args__['ids'] = ids
    __args__['internalIp'] = internal_ip
    __args__['internalPort'] = internal_port
    __args__['ipProtocol'] = ip_protocol
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getForwardEntries:getForwardEntries', __args__, opts=opts, typ=GetForwardEntriesResult).value

    return AwaitableGetForwardEntriesResult(
        entries=pulumi.get(__ret__, 'entries'),
        external_ip=pulumi.get(__ret__, 'external_ip'),
        external_port=pulumi.get(__ret__, 'external_port'),
        forward_entry_name=pulumi.get(__ret__, 'forward_entry_name'),
        forward_table_id=pulumi.get(__ret__, 'forward_table_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        internal_ip=pulumi.get(__ret__, 'internal_ip'),
        internal_port=pulumi.get(__ret__, 'internal_port'),
        ip_protocol=pulumi.get(__ret__, 'ip_protocol'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))
def get_forward_entries_output(external_ip: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               external_port: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               forward_entry_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               forward_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                               ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               internal_ip: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               internal_port: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               ip_protocol: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetForwardEntriesResult]:
    """
    This data source provides a list of Forward Entries owned by an Alibaba Cloud account.

    > **NOTE:** Available since v1.37.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "forward-entry-config-example-name"
    default = alicloud.get_zones(available_resource_creation="VSwitch")
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="172.16.0.0/12")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/21",
        zone_id=default.zones[0].id,
        vswitch_name=name)
    default_nat_gateway = alicloud.vpc.NatGateway("default",
        vpc_id=default_network.id,
        internet_charge_type="PayByLcu",
        nat_gateway_name=name,
        nat_type="Enhanced",
        vswitch_id=default_switch.id)
    default_eip_address = alicloud.ecs.EipAddress("default", address_name=name)
    default_eip_association = alicloud.ecs.EipAssociation("default",
        allocation_id=default_eip_address.id,
        instance_id=default_nat_gateway.id)
    default_forward_entry = alicloud.vpc.ForwardEntry("default",
        forward_table_id=default_nat_gateway.forward_table_ids,
        external_ip=default_eip_address.ip_address,
        external_port="80",
        ip_protocol="tcp",
        internal_ip="172.16.0.3",
        internal_port="8080")
    default_get_forward_entries = alicloud.vpc.get_forward_entries_output(forward_table_id=default_forward_entry.forward_table_id)
    ```


    :param _builtins.str external_ip: The public IP address.
    :param _builtins.str external_port: The public port.
    :param _builtins.str forward_entry_name: The name of forward entry.
    :param _builtins.str forward_table_id: The ID of the Forward table.
    :param Sequence[_builtins.str] ids: A list of Forward Entries IDs.
    :param _builtins.str internal_ip: The private IP address.
    :param _builtins.str internal_port: The internal port.
    :param _builtins.str ip_protocol: The ip protocol. Valid values: `any`,`tcp` and `udp`.
    :param _builtins.str name_regex: A regex string to filter results by forward entry name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of farward entry. Valid value `Available`, `Deleting` and `Pending`.
    """
    __args__ = dict()
    __args__['externalIp'] = external_ip
    __args__['externalPort'] = external_port
    __args__['forwardEntryName'] = forward_entry_name
    __args__['forwardTableId'] = forward_table_id
    __args__['ids'] = ids
    __args__['internalIp'] = internal_ip
    __args__['internalPort'] = internal_port
    __args__['ipProtocol'] = ip_protocol
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getForwardEntries:getForwardEntries', __args__, opts=opts, typ=GetForwardEntriesResult)
    return __ret__.apply(lambda __response__: GetForwardEntriesResult(
        entries=pulumi.get(__response__, 'entries'),
        external_ip=pulumi.get(__response__, 'external_ip'),
        external_port=pulumi.get(__response__, 'external_port'),
        forward_entry_name=pulumi.get(__response__, 'forward_entry_name'),
        forward_table_id=pulumi.get(__response__, 'forward_table_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        internal_ip=pulumi.get(__response__, 'internal_ip'),
        internal_port=pulumi.get(__response__, 'internal_port'),
        ip_protocol=pulumi.get(__response__, 'ip_protocol'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status')))
