# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpamIpamPoolsResult',
    'AwaitableGetIpamIpamPoolsResult',
    'get_ipam_ipam_pools',
    'get_ipam_ipam_pools_output',
]

@pulumi.output_type
class GetIpamIpamPoolsResult:
    """
    A collection of values returned by getIpamIpamPools.
    """
    def __init__(__self__, id=None, ids=None, ipam_pool_id=None, ipam_pool_name=None, ipam_scope_id=None, name_regex=None, names=None, output_file=None, pool_region_id=None, pools=None, resource_group_id=None, source_ipam_pool_id=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if ipam_pool_id and not isinstance(ipam_pool_id, str):
            raise TypeError("Expected argument 'ipam_pool_id' to be a str")
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if ipam_pool_name and not isinstance(ipam_pool_name, str):
            raise TypeError("Expected argument 'ipam_pool_name' to be a str")
        pulumi.set(__self__, "ipam_pool_name", ipam_pool_name)
        if ipam_scope_id and not isinstance(ipam_scope_id, str):
            raise TypeError("Expected argument 'ipam_scope_id' to be a str")
        pulumi.set(__self__, "ipam_scope_id", ipam_scope_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if pool_region_id and not isinstance(pool_region_id, str):
            raise TypeError("Expected argument 'pool_region_id' to be a str")
        pulumi.set(__self__, "pool_region_id", pool_region_id)
        if pools and not isinstance(pools, list):
            raise TypeError("Expected argument 'pools' to be a list")
        pulumi.set(__self__, "pools", pools)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if source_ipam_pool_id and not isinstance(source_ipam_pool_id, str):
            raise TypeError("Expected argument 'source_ipam_pool_id' to be a str")
        pulumi.set(__self__, "source_ipam_pool_id", source_ipam_pool_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Ipam Pool IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> Optional[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ipam_pool_id")

    @_builtins.property
    @pulumi.getter(name="ipamPoolName")
    def ipam_pool_name(self) -> Optional[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_pool_name")

    @_builtins.property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> Optional[_builtins.str]:
        """
        Ipam scope id.
        """
        return pulumi.get(self, "ipam_scope_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Ipam Pools.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="poolRegionId")
    def pool_region_id(self) -> Optional[_builtins.str]:
        """
        The effective region of the IPAM address pool.
        """
        return pulumi.get(self, "pool_region_id")

    @_builtins.property
    @pulumi.getter
    def pools(self) -> Sequence['outputs.GetIpamIpamPoolsPoolResult']:
        """
        A list of Ipam Pool Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "pools")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="sourceIpamPoolId")
    def source_ipam_pool_id(self) -> Optional[_builtins.str]:
        """
        The instance ID of the source IPAM address pool.> If this parameter is not entered, the created address pool is the parent address pool.
        """
        return pulumi.get(self, "source_ipam_pool_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetIpamIpamPoolsResult(GetIpamIpamPoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpamIpamPoolsResult(
            id=self.id,
            ids=self.ids,
            ipam_pool_id=self.ipam_pool_id,
            ipam_pool_name=self.ipam_pool_name,
            ipam_scope_id=self.ipam_scope_id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            pool_region_id=self.pool_region_id,
            pools=self.pools,
            resource_group_id=self.resource_group_id,
            source_ipam_pool_id=self.source_ipam_pool_id,
            tags=self.tags)


def get_ipam_ipam_pools(ids: Optional[Sequence[_builtins.str]] = None,
                        ipam_pool_id: Optional[_builtins.str] = None,
                        ipam_pool_name: Optional[_builtins.str] = None,
                        ipam_scope_id: Optional[_builtins.str] = None,
                        name_regex: Optional[_builtins.str] = None,
                        output_file: Optional[_builtins.str] = None,
                        pool_region_id: Optional[_builtins.str] = None,
                        resource_group_id: Optional[_builtins.str] = None,
                        source_ipam_pool_id: Optional[_builtins.str] = None,
                        tags: Optional[Mapping[str, _builtins.str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpamIpamPoolsResult:
    """
    This data source provides Vpc Ipam Ipam Pool available to the user.[What is Ipam Pool](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpamPool)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups()
    default_ipam = alicloud.vpc.IpamIpam("defaultIpam", operating_region_lists=["cn-hangzhou"])
    parent_ipam_pool = alicloud.vpc.IpamIpamPool("parentIpamPool",
        ipam_scope_id=default_ipam.private_default_scope_id,
        pool_region_id="cn-hangzhou")
    default_ipam_ipam_pool = alicloud.vpc.IpamIpamPool("default",
        ipam_scope_id=default_ipam.private_default_scope_id,
        pool_region_id=parent_ipam_pool.pool_region_id,
        ipam_pool_name=name,
        source_ipam_pool_id=parent_ipam_pool.id,
        ip_version="IPv4",
        ipam_pool_description=name)
    default_get_ipam_ipam_pools = alicloud.vpc.get_ipam_ipam_pools(name_regex=default_ipam_ipam_pool.name)
    pulumi.export("alicloudVpcIpamIpamPoolExampleId", default_get_ipam_ipam_pools.pools[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Ipam Pool IDs.
    :param _builtins.str ipam_pool_id: The first ID of the resource.
    :param _builtins.str ipam_pool_name: The name of the resource.
    :param _builtins.str ipam_scope_id: Ipam scope id.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str pool_region_id: The effective region of the IPAM address pool.
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param _builtins.str source_ipam_pool_id: The instance ID of the source IPAM address pool.> If this parameter is not entered, the created address pool is the parent address pool.
    :param Mapping[str, _builtins.str] tags: The tag of the resource.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['ipamPoolId'] = ipam_pool_id
    __args__['ipamPoolName'] = ipam_pool_name
    __args__['ipamScopeId'] = ipam_scope_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['poolRegionId'] = pool_region_id
    __args__['resourceGroupId'] = resource_group_id
    __args__['sourceIpamPoolId'] = source_ipam_pool_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getIpamIpamPools:getIpamIpamPools', __args__, opts=opts, typ=GetIpamIpamPoolsResult).value

    return AwaitableGetIpamIpamPoolsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        ipam_pool_id=pulumi.get(__ret__, 'ipam_pool_id'),
        ipam_pool_name=pulumi.get(__ret__, 'ipam_pool_name'),
        ipam_scope_id=pulumi.get(__ret__, 'ipam_scope_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        pool_region_id=pulumi.get(__ret__, 'pool_region_id'),
        pools=pulumi.get(__ret__, 'pools'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        source_ipam_pool_id=pulumi.get(__ret__, 'source_ipam_pool_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_ipam_ipam_pools_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               ipam_pool_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               ipam_pool_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               ipam_scope_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               pool_region_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               source_ipam_pool_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpamIpamPoolsResult]:
    """
    This data source provides Vpc Ipam Ipam Pool available to the user.[What is Ipam Pool](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpamPool)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups()
    default_ipam = alicloud.vpc.IpamIpam("defaultIpam", operating_region_lists=["cn-hangzhou"])
    parent_ipam_pool = alicloud.vpc.IpamIpamPool("parentIpamPool",
        ipam_scope_id=default_ipam.private_default_scope_id,
        pool_region_id="cn-hangzhou")
    default_ipam_ipam_pool = alicloud.vpc.IpamIpamPool("default",
        ipam_scope_id=default_ipam.private_default_scope_id,
        pool_region_id=parent_ipam_pool.pool_region_id,
        ipam_pool_name=name,
        source_ipam_pool_id=parent_ipam_pool.id,
        ip_version="IPv4",
        ipam_pool_description=name)
    default_get_ipam_ipam_pools = alicloud.vpc.get_ipam_ipam_pools(name_regex=default_ipam_ipam_pool.name)
    pulumi.export("alicloudVpcIpamIpamPoolExampleId", default_get_ipam_ipam_pools.pools[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Ipam Pool IDs.
    :param _builtins.str ipam_pool_id: The first ID of the resource.
    :param _builtins.str ipam_pool_name: The name of the resource.
    :param _builtins.str ipam_scope_id: Ipam scope id.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str pool_region_id: The effective region of the IPAM address pool.
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param _builtins.str source_ipam_pool_id: The instance ID of the source IPAM address pool.> If this parameter is not entered, the created address pool is the parent address pool.
    :param Mapping[str, _builtins.str] tags: The tag of the resource.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['ipamPoolId'] = ipam_pool_id
    __args__['ipamPoolName'] = ipam_pool_name
    __args__['ipamScopeId'] = ipam_scope_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['poolRegionId'] = pool_region_id
    __args__['resourceGroupId'] = resource_group_id
    __args__['sourceIpamPoolId'] = source_ipam_pool_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getIpamIpamPools:getIpamIpamPools', __args__, opts=opts, typ=GetIpamIpamPoolsResult)
    return __ret__.apply(lambda __response__: GetIpamIpamPoolsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        ipam_pool_id=pulumi.get(__response__, 'ipam_pool_id'),
        ipam_pool_name=pulumi.get(__response__, 'ipam_pool_name'),
        ipam_scope_id=pulumi.get(__response__, 'ipam_scope_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        pool_region_id=pulumi.get(__response__, 'pool_region_id'),
        pools=pulumi.get(__response__, 'pools'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        source_ipam_pool_id=pulumi.get(__response__, 'source_ipam_pool_id'),
        tags=pulumi.get(__response__, 'tags')))
