# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpamIpamScopesResult',
    'AwaitableGetIpamIpamScopesResult',
    'get_ipam_ipam_scopes',
    'get_ipam_ipam_scopes_output',
]

@pulumi.output_type
class GetIpamIpamScopesResult:
    """
    A collection of values returned by getIpamIpamScopes.
    """
    def __init__(__self__, id=None, ids=None, ipam_id=None, ipam_scope_id=None, ipam_scope_name=None, ipam_scope_type=None, name_regex=None, names=None, output_file=None, resource_group_id=None, scopes=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if ipam_id and not isinstance(ipam_id, str):
            raise TypeError("Expected argument 'ipam_id' to be a str")
        pulumi.set(__self__, "ipam_id", ipam_id)
        if ipam_scope_id and not isinstance(ipam_scope_id, str):
            raise TypeError("Expected argument 'ipam_scope_id' to be a str")
        pulumi.set(__self__, "ipam_scope_id", ipam_scope_id)
        if ipam_scope_name and not isinstance(ipam_scope_name, str):
            raise TypeError("Expected argument 'ipam_scope_name' to be a str")
        pulumi.set(__self__, "ipam_scope_name", ipam_scope_name)
        if ipam_scope_type and not isinstance(ipam_scope_type, str):
            raise TypeError("Expected argument 'ipam_scope_type' to be a str")
        pulumi.set(__self__, "ipam_scope_type", ipam_scope_type)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Ipam Scope IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="ipamId")
    def ipam_id(self) -> Optional[_builtins.str]:
        """
        The id of the Ipam instance.
        """
        return pulumi.get(self, "ipam_id")

    @_builtins.property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> Optional[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ipam_scope_id")

    @_builtins.property
    @pulumi.getter(name="ipamScopeName")
    def ipam_scope_name(self) -> Optional[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_scope_name")

    @_builtins.property
    @pulumi.getter(name="ipamScopeType")
    def ipam_scope_type(self) -> Optional[_builtins.str]:
        """
        IPAM scope of action type:**private**.> Currently, only the role scope of the private network is supported.
        """
        return pulumi.get(self, "ipam_scope_type")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Ipam Scopes.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Sequence['outputs.GetIpamIpamScopesScopeResult']:
        """
        A list of Ipam Scope Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetIpamIpamScopesResult(GetIpamIpamScopesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpamIpamScopesResult(
            id=self.id,
            ids=self.ids,
            ipam_id=self.ipam_id,
            ipam_scope_id=self.ipam_scope_id,
            ipam_scope_name=self.ipam_scope_name,
            ipam_scope_type=self.ipam_scope_type,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            scopes=self.scopes,
            tags=self.tags)


def get_ipam_ipam_scopes(ids: Optional[Sequence[_builtins.str]] = None,
                         ipam_id: Optional[_builtins.str] = None,
                         ipam_scope_id: Optional[_builtins.str] = None,
                         ipam_scope_name: Optional[_builtins.str] = None,
                         ipam_scope_type: Optional[_builtins.str] = None,
                         name_regex: Optional[_builtins.str] = None,
                         output_file: Optional[_builtins.str] = None,
                         resource_group_id: Optional[_builtins.str] = None,
                         tags: Optional[Mapping[str, _builtins.str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpamIpamScopesResult:
    """
    This data source provides Vpc Ipam Ipam Scope available to the user.[What is Ipam Scope](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpamScope)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups()
    default_ipam = alicloud.vpc.IpamIpam("defaultIpam",
        operating_region_lists=["cn-hangzhou"],
        ipam_name=name)
    default_ipam_ipam_scope = alicloud.vpc.IpamIpamScope("default",
        ipam_scope_name=name,
        ipam_id=default_ipam.id,
        ipam_scope_description="This is a ipam scope.",
        ipam_scope_type="private",
        tags={
            "k1": "v1",
        })
    default_get_ipam_ipam_scopes = default_ipam_ipam_scope.ipam_scope_name.apply(lambda ipam_scope_name: alicloud.vpc.get_ipam_ipam_scopes_output(ipam_scope_name=ipam_scope_name))
    pulumi.export("alicloudVpcIpamIpamScopeExampleId", default_get_ipam_ipam_scopes.scopes[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Ipam Scope IDs.
    :param _builtins.str ipam_id: The id of the Ipam instance.
    :param _builtins.str ipam_scope_id: The first ID of the resource.
    :param _builtins.str ipam_scope_name: The name of the resource.
    :param _builtins.str ipam_scope_type: IPAM scope of action type:**private**.> Currently, only the role scope of the private network is supported.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param Mapping[str, _builtins.str] tags: The tag of the resource.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['ipamId'] = ipam_id
    __args__['ipamScopeId'] = ipam_scope_id
    __args__['ipamScopeName'] = ipam_scope_name
    __args__['ipamScopeType'] = ipam_scope_type
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getIpamIpamScopes:getIpamIpamScopes', __args__, opts=opts, typ=GetIpamIpamScopesResult).value

    return AwaitableGetIpamIpamScopesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        ipam_id=pulumi.get(__ret__, 'ipam_id'),
        ipam_scope_id=pulumi.get(__ret__, 'ipam_scope_id'),
        ipam_scope_name=pulumi.get(__ret__, 'ipam_scope_name'),
        ipam_scope_type=pulumi.get(__ret__, 'ipam_scope_type'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        scopes=pulumi.get(__ret__, 'scopes'),
        tags=pulumi.get(__ret__, 'tags'))
def get_ipam_ipam_scopes_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                ipam_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                ipam_scope_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                ipam_scope_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                ipam_scope_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpamIpamScopesResult]:
    """
    This data source provides Vpc Ipam Ipam Scope available to the user.[What is Ipam Scope](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpamScope)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups()
    default_ipam = alicloud.vpc.IpamIpam("defaultIpam",
        operating_region_lists=["cn-hangzhou"],
        ipam_name=name)
    default_ipam_ipam_scope = alicloud.vpc.IpamIpamScope("default",
        ipam_scope_name=name,
        ipam_id=default_ipam.id,
        ipam_scope_description="This is a ipam scope.",
        ipam_scope_type="private",
        tags={
            "k1": "v1",
        })
    default_get_ipam_ipam_scopes = default_ipam_ipam_scope.ipam_scope_name.apply(lambda ipam_scope_name: alicloud.vpc.get_ipam_ipam_scopes_output(ipam_scope_name=ipam_scope_name))
    pulumi.export("alicloudVpcIpamIpamScopeExampleId", default_get_ipam_ipam_scopes.scopes[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Ipam Scope IDs.
    :param _builtins.str ipam_id: The id of the Ipam instance.
    :param _builtins.str ipam_scope_id: The first ID of the resource.
    :param _builtins.str ipam_scope_name: The name of the resource.
    :param _builtins.str ipam_scope_type: IPAM scope of action type:**private**.> Currently, only the role scope of the private network is supported.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param Mapping[str, _builtins.str] tags: The tag of the resource.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['ipamId'] = ipam_id
    __args__['ipamScopeId'] = ipam_scope_id
    __args__['ipamScopeName'] = ipam_scope_name
    __args__['ipamScopeType'] = ipam_scope_type
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getIpamIpamScopes:getIpamIpamScopes', __args__, opts=opts, typ=GetIpamIpamScopesResult)
    return __ret__.apply(lambda __response__: GetIpamIpamScopesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        ipam_id=pulumi.get(__response__, 'ipam_id'),
        ipam_scope_id=pulumi.get(__response__, 'ipam_scope_id'),
        ipam_scope_name=pulumi.get(__response__, 'ipam_scope_name'),
        ipam_scope_type=pulumi.get(__response__, 'ipam_scope_type'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        scopes=pulumi.get(__response__, 'scopes'),
        tags=pulumi.get(__response__, 'tags')))
