# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['Ipv4CidrBlockArgs', 'Ipv4CidrBlock']

@pulumi.input_type
class Ipv4CidrBlockArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Ipv4CidrBlock resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] ipv4_ipam_pool_id: The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        :param pulumi.Input[_builtins.str] secondary_cidr_block: Additional network segment information.
        :param pulumi.Input[_builtins.int] secondary_cidr_mask: Add an additional CIDR block from the IPAM address pool to the VPC by entering a mask.
               
               > **NOTE:**  Specify the IPAM address pool to add an additional CIDR block to the VPC. Enter at least one of the SecondaryCidrBlock or SecondaryCidrMask parameters.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if ipv4_ipam_pool_id is not None:
            pulumi.set(__self__, "ipv4_ipam_pool_id", ipv4_ipam_pool_id)
        if secondary_cidr_block is not None:
            pulumi.set(__self__, "secondary_cidr_block", secondary_cidr_block)
        if secondary_cidr_mask is not None:
            pulumi.set(__self__, "secondary_cidr_mask", secondary_cidr_mask)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv4IpamPoolId")
    def ipv4_ipam_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        """
        return pulumi.get(self, "ipv4_ipam_pool_id")

    @ipv4_ipam_pool_id.setter
    def ipv4_ipam_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_ipam_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidrBlock")
    def secondary_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional network segment information.
        """
        return pulumi.get(self, "secondary_cidr_block")

    @secondary_cidr_block.setter
    def secondary_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidrMask")
    def secondary_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Add an additional CIDR block from the IPAM address pool to the VPC by entering a mask.

        > **NOTE:**  Specify the IPAM address pool to add an additional CIDR block to the VPC. Enter at least one of the SecondaryCidrBlock or SecondaryCidrMask parameters.
        """
        return pulumi.get(self, "secondary_cidr_mask")

    @secondary_cidr_mask.setter
    def secondary_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secondary_cidr_mask", value)


@pulumi.input_type
class _Ipv4CidrBlockState:
    def __init__(__self__, *,
                 ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ipv4CidrBlock resources.
        :param pulumi.Input[_builtins.str] ipv4_ipam_pool_id: The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the VPC resides.
        :param pulumi.Input[_builtins.str] secondary_cidr_block: Additional network segment information.
        :param pulumi.Input[_builtins.int] secondary_cidr_mask: Add an additional CIDR block from the IPAM address pool to the VPC by entering a mask.
               
               > **NOTE:**  Specify the IPAM address pool to add an additional CIDR block to the VPC. Enter at least one of the SecondaryCidrBlock or SecondaryCidrMask parameters.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        """
        if ipv4_ipam_pool_id is not None:
            pulumi.set(__self__, "ipv4_ipam_pool_id", ipv4_ipam_pool_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if secondary_cidr_block is not None:
            pulumi.set(__self__, "secondary_cidr_block", secondary_cidr_block)
        if secondary_cidr_mask is not None:
            pulumi.set(__self__, "secondary_cidr_mask", secondary_cidr_mask)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="ipv4IpamPoolId")
    def ipv4_ipam_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        """
        return pulumi.get(self, "ipv4_ipam_pool_id")

    @ipv4_ipam_pool_id.setter
    def ipv4_ipam_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_ipam_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the VPC resides.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidrBlock")
    def secondary_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional network segment information.
        """
        return pulumi.get(self, "secondary_cidr_block")

    @secondary_cidr_block.setter
    def secondary_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidrMask")
    def secondary_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Add an additional CIDR block from the IPAM address pool to the VPC by entering a mask.

        > **NOTE:**  Specify the IPAM address pool to add an additional CIDR block to the VPC. Enter at least one of the SecondaryCidrBlock or SecondaryCidrMask parameters.
        """
        return pulumi.get(self, "secondary_cidr_mask")

    @secondary_cidr_mask.setter
    def secondary_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secondary_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:vpc/ipv4CidrBlock:Ipv4CidrBlock")
class Ipv4CidrBlock(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC Ipv4 Cidr Block resource.

        VPC IPv4 additional network segment.

        For information about VPC Ipv4 Cidr Block and how to use it, see [What is Ipv4 Cidr Block](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/associatevpccidrblock).

        > **NOTE:** Available since v1.185.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultvpc = alicloud.vpc.Network("defaultvpc", description=name)
        default = alicloud.vpc.Ipv4CidrBlock("default",
            secondary_cidr_block="192.168.0.0/16",
            vpc_id=defaultvpc.id)
        ```

        ## Import

        VPC Ipv4 Cidr Block can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipv4CidrBlock:Ipv4CidrBlock example <vpc_id>:<secondary_cidr_block>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ipv4_ipam_pool_id: The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        :param pulumi.Input[_builtins.str] secondary_cidr_block: Additional network segment information.
        :param pulumi.Input[_builtins.int] secondary_cidr_mask: Add an additional CIDR block from the IPAM address pool to the VPC by entering a mask.
               
               > **NOTE:**  Specify the IPAM address pool to add an additional CIDR block to the VPC. Enter at least one of the SecondaryCidrBlock or SecondaryCidrMask parameters.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Ipv4CidrBlockArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Ipv4 Cidr Block resource.

        VPC IPv4 additional network segment.

        For information about VPC Ipv4 Cidr Block and how to use it, see [What is Ipv4 Cidr Block](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/associatevpccidrblock).

        > **NOTE:** Available since v1.185.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultvpc = alicloud.vpc.Network("defaultvpc", description=name)
        default = alicloud.vpc.Ipv4CidrBlock("default",
            secondary_cidr_block="192.168.0.0/16",
            vpc_id=defaultvpc.id)
        ```

        ## Import

        VPC Ipv4 Cidr Block can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipv4CidrBlock:Ipv4CidrBlock example <vpc_id>:<secondary_cidr_block>
        ```

        :param str resource_name: The name of the resource.
        :param Ipv4CidrBlockArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Ipv4CidrBlockArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Ipv4CidrBlockArgs.__new__(Ipv4CidrBlockArgs)

            __props__.__dict__["ipv4_ipam_pool_id"] = ipv4_ipam_pool_id
            __props__.__dict__["secondary_cidr_block"] = secondary_cidr_block
            __props__.__dict__["secondary_cidr_mask"] = secondary_cidr_mask
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["region_id"] = None
        super(Ipv4CidrBlock, __self__).__init__(
            'alicloud:vpc/ipv4CidrBlock:Ipv4CidrBlock',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Ipv4CidrBlock':
        """
        Get an existing Ipv4CidrBlock resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ipv4_ipam_pool_id: The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the VPC resides.
        :param pulumi.Input[_builtins.str] secondary_cidr_block: Additional network segment information.
        :param pulumi.Input[_builtins.int] secondary_cidr_mask: Add an additional CIDR block from the IPAM address pool to the VPC by entering a mask.
               
               > **NOTE:**  Specify the IPAM address pool to add an additional CIDR block to the VPC. Enter at least one of the SecondaryCidrBlock or SecondaryCidrMask parameters.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Ipv4CidrBlockState.__new__(_Ipv4CidrBlockState)

        __props__.__dict__["ipv4_ipam_pool_id"] = ipv4_ipam_pool_id
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["secondary_cidr_block"] = secondary_cidr_block
        __props__.__dict__["secondary_cidr_mask"] = secondary_cidr_mask
        __props__.__dict__["vpc_id"] = vpc_id
        return Ipv4CidrBlock(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ipv4IpamPoolId")
    def ipv4_ipam_pool_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        """
        return pulumi.get(self, "ipv4_ipam_pool_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where the VPC resides.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="secondaryCidrBlock")
    def secondary_cidr_block(self) -> pulumi.Output[_builtins.str]:
        """
        Additional network segment information.
        """
        return pulumi.get(self, "secondary_cidr_block")

    @_builtins.property
    @pulumi.getter(name="secondaryCidrMask")
    def secondary_cidr_mask(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Add an additional CIDR block from the IPAM address pool to the VPC by entering a mask.

        > **NOTE:**  Specify the IPAM address pool to add an additional CIDR block to the VPC. Enter at least one of the SecondaryCidrBlock or SecondaryCidrMask parameters.
        """
        return pulumi.get(self, "secondary_cidr_mask")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

