# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteTableArgs', 'RouteTable']

@pulumi.input_type
class RouteTableArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 associate_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 route_propagation_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RouteTable resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] associate_type: The type of cloud resource that is bound to the routing table. Value:
               - `VSwitch`: switch.
               - `Gateway`:IPv4 Gateway.
        :param pulumi.Input[_builtins.str] description: Description of the routing table.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name' instead.
        :param pulumi.Input[_builtins.bool] route_propagation_enable: Route Table Receive Propagate Route State
        :param pulumi.Input[_builtins.str] route_table_name: The name of the routing table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if associate_type is not None:
            pulumi.set(__self__, "associate_type", associate_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.119.1. New field 'route_table_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.119.1. New field 'route_table_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route_propagation_enable is not None:
            pulumi.set(__self__, "route_propagation_enable", route_propagation_enable)
        if route_table_name is not None:
            pulumi.set(__self__, "route_table_name", route_table_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of VPC.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="associateType")
    def associate_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of cloud resource that is bound to the routing table. Value:
        - `VSwitch`: switch.
        - `Gateway`:IPv4 Gateway.
        """
        return pulumi.get(self, "associate_type")

    @associate_type.setter
    def associate_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associate_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the routing table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.119.1. New field 'route_table_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="routePropagationEnable")
    def route_propagation_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Route Table Receive Propagate Route State
        """
        return pulumi.get(self, "route_propagation_enable")

    @route_propagation_enable.setter
    def route_propagation_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_propagation_enable", value)

    @_builtins.property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the routing table.
        """
        return pulumi.get(self, "route_table_name")

    @route_table_name.setter
    def route_table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RouteTableState:
    def __init__(__self__, *,
                 associate_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_propagation_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouteTable resources.
        :param pulumi.Input[_builtins.str] associate_type: The type of cloud resource that is bound to the routing table. Value:
               - `VSwitch`: switch.
               - `Gateway`:IPv4 Gateway.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the routing table
        :param pulumi.Input[_builtins.str] description: Description of the routing table.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name' instead.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource group ID.
        :param pulumi.Input[_builtins.bool] route_propagation_enable: Route Table Receive Propagate Route State
        :param pulumi.Input[_builtins.str] route_table_name: The name of the routing table.
        :param pulumi.Input[_builtins.str] status: Routing table state
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if associate_type is not None:
            pulumi.set(__self__, "associate_type", associate_type)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.119.1. New field 'route_table_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.119.1. New field 'route_table_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if route_propagation_enable is not None:
            pulumi.set(__self__, "route_propagation_enable", route_propagation_enable)
        if route_table_name is not None:
            pulumi.set(__self__, "route_table_name", route_table_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="associateType")
    def associate_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of cloud resource that is bound to the routing table. Value:
        - `VSwitch`: switch.
        - `Gateway`:IPv4 Gateway.
        """
        return pulumi.get(self, "associate_type")

    @associate_type.setter
    def associate_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associate_type", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the routing table
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the routing table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.119.1. New field 'route_table_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="routePropagationEnable")
    def route_propagation_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Route Table Receive Propagate Route State
        """
        return pulumi.get(self, "route_propagation_enable")

    @route_propagation_enable.setter
    def route_propagation_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_propagation_enable", value)

    @_builtins.property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the routing table.
        """
        return pulumi.get(self, "route_table_name")

    @route_table_name.setter
    def route_table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Routing table state
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of VPC.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:vpc/routeTable:RouteTable")
class RouteTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 route_propagation_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC Route Table resource.

        Currently, customized route tables are available in most regions apart from China (Beijing), China (Hangzhou), and China (Shenzhen) regions.

        For information about VPC Route Table and how to use it, see [What is Route Table](https://www.alibabacloud.com/help/doc-detail/87057.htm).

        > **NOTE:** Available since v1.0.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_vpc = alicloud.vpc.Network("defaultVpc", vpc_name=name)
        default = alicloud.vpc.RouteTable("default",
            description="test-description",
            vpc_id=default_vpc.id,
            route_table_name=name,
            associate_type="VSwitch")
        ```

        ## Import

        VPC Route Table can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/routeTable:RouteTable example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] associate_type: The type of cloud resource that is bound to the routing table. Value:
               - `VSwitch`: switch.
               - `Gateway`:IPv4 Gateway.
        :param pulumi.Input[_builtins.str] description: Description of the routing table.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name' instead.
        :param pulumi.Input[_builtins.bool] route_propagation_enable: Route Table Receive Propagate Route State
        :param pulumi.Input[_builtins.str] route_table_name: The name of the routing table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Route Table resource.

        Currently, customized route tables are available in most regions apart from China (Beijing), China (Hangzhou), and China (Shenzhen) regions.

        For information about VPC Route Table and how to use it, see [What is Route Table](https://www.alibabacloud.com/help/doc-detail/87057.htm).

        > **NOTE:** Available since v1.0.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_vpc = alicloud.vpc.Network("defaultVpc", vpc_name=name)
        default = alicloud.vpc.RouteTable("default",
            description="test-description",
            vpc_id=default_vpc.id,
            route_table_name=name,
            associate_type="VSwitch")
        ```

        ## Import

        VPC Route Table can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/routeTable:RouteTable example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RouteTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 route_propagation_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteTableArgs.__new__(RouteTableArgs)

            __props__.__dict__["associate_type"] = associate_type
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["route_propagation_enable"] = route_propagation_enable
            __props__.__dict__["route_table_name"] = route_table_name
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["resource_group_id"] = None
            __props__.__dict__["status"] = None
        super(RouteTable, __self__).__init__(
            'alicloud:vpc/routeTable:RouteTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associate_type: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            route_propagation_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouteTable':
        """
        Get an existing RouteTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] associate_type: The type of cloud resource that is bound to the routing table. Value:
               - `VSwitch`: switch.
               - `Gateway`:IPv4 Gateway.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the routing table
        :param pulumi.Input[_builtins.str] description: Description of the routing table.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name' instead.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource group ID.
        :param pulumi.Input[_builtins.bool] route_propagation_enable: Route Table Receive Propagate Route State
        :param pulumi.Input[_builtins.str] route_table_name: The name of the routing table.
        :param pulumi.Input[_builtins.str] status: Routing table state
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteTableState.__new__(_RouteTableState)

        __props__.__dict__["associate_type"] = associate_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["route_propagation_enable"] = route_propagation_enable
        __props__.__dict__["route_table_name"] = route_table_name
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return RouteTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associateType")
    def associate_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of cloud resource that is bound to the routing table. Value:
        - `VSwitch`: switch.
        - `Gateway`:IPv4 Gateway.
        """
        return pulumi.get(self, "associate_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the routing table
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the routing table.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.119.1. New field 'route_table_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'name' has been deprecated from provider version 1.119.1. New field 'route_table_name' instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="routePropagationEnable")
    def route_propagation_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Route Table Receive Propagate Route State
        """
        return pulumi.get(self, "route_propagation_enable")

    @_builtins.property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the routing table.
        """
        return pulumi.get(self, "route_table_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Routing table state
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of VPC.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "vpc_id")

