"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cloudfront = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudfront-custom');
new cloudfront.CloudFrontWebDistribution(stack, 'AnAmazingWebsiteProbably', {
    originConfigs: [
        {
            originHeaders: {
                "X-Custom-Header": "somevalue",
            },
            customOriginSource: {
                domainName: "brelandm.a2z.com",
            },
            behaviors: [
                {
                    isDefaultBehavior: true,
                }
            ]
        }
    ]
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY2xvdWRmcm9udC1jdXN0b20uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5jbG91ZGZyb250LWN1c3RvbS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUNBLHFDQUFzQztBQUN0QyxxQ0FBc0M7QUFFdEMsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFFMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSwyQkFBMkIsQ0FBQyxDQUFDO0FBRTlELElBQUksVUFBVSxDQUFDLHlCQUF5QixDQUFDLEtBQUssRUFBRSwwQkFBMEIsRUFBRTtJQUMxRSxhQUFhLEVBQUU7UUFDYjtZQUNFLGFBQWEsRUFBRTtnQkFDYixpQkFBaUIsRUFBRSxXQUFXO2FBQy9CO1lBQ0Qsa0JBQWtCLEVBQUU7Z0JBQ2xCLFVBQVUsRUFBRSxrQkFBa0I7YUFDL0I7WUFDRCxTQUFTLEVBQUU7Z0JBQ1Q7b0JBQ0EsaUJBQWlCLEVBQUUsSUFBSTtpQkFDdEI7YUFDRjtTQUNGO0tBQ0Y7Q0FDRixDQUFDLENBQUM7QUFFSCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJcbmltcG9ydCBjZGsgPSByZXF1aXJlKCdAYXdzLWNkay9jb3JlJyk7XG5pbXBvcnQgY2xvdWRmcm9udCA9IHJlcXVpcmUoJy4uL2xpYicpO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWNkay1jbG91ZGZyb250LWN1c3RvbScpO1xuXG5uZXcgY2xvdWRmcm9udC5DbG91ZEZyb250V2ViRGlzdHJpYnV0aW9uKHN0YWNrLCAnQW5BbWF6aW5nV2Vic2l0ZVByb2JhYmx5Jywge1xuICBvcmlnaW5Db25maWdzOiBbXG4gICAge1xuICAgICAgb3JpZ2luSGVhZGVyczoge1xuICAgICAgICBcIlgtQ3VzdG9tLUhlYWRlclwiOiBcInNvbWV2YWx1ZVwiLFxuICAgICAgfSxcbiAgICAgIGN1c3RvbU9yaWdpblNvdXJjZToge1xuICAgICAgICBkb21haW5OYW1lOiBcImJyZWxhbmRtLmEyei5jb21cIixcbiAgICAgIH0sXG4gICAgICBiZWhhdmlvcnM6IFtcbiAgICAgICAge1xuICAgICAgICBpc0RlZmF1bHRCZWhhdmlvcjogdHJ1ZSxcbiAgICAgICAgfVxuICAgICAgXVxuICAgIH1cbiAgXVxufSk7XG5cbmFwcC5zeW50aCgpO1xuIl19