"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cloudfront = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudfront-custom');
new cloudfront.CloudFrontWebDistribution(stack, 'AnAmazingWebsiteProbably', {
    originConfigs: [
        {
            originHeaders: {
                "X-Custom-Header": "somevalue",
            },
            customOriginSource: {
                domainName: "brelandm.a2z.com",
            },
            behaviors: [
                {
                    isDefaultBehavior: true,
                }
            ],
        }
    ],
    defaultRootObject: ''
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY2xvdWRmcm9udC1lbXB0eS1yb290LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuY2xvdWRmcm9udC1lbXB0eS1yb290LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQ0EscUNBQXNDO0FBQ3RDLHFDQUFzQztBQUV0QyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLDJCQUEyQixDQUFDLENBQUM7QUFFOUQsSUFBSSxVQUFVLENBQUMseUJBQXlCLENBQUMsS0FBSyxFQUFFLDBCQUEwQixFQUFFO0lBQzFFLGFBQWEsRUFBRTtRQUNiO1lBQ0UsYUFBYSxFQUFFO2dCQUNiLGlCQUFpQixFQUFFLFdBQVc7YUFDL0I7WUFDRCxrQkFBa0IsRUFBRTtnQkFDbEIsVUFBVSxFQUFFLGtCQUFrQjthQUMvQjtZQUNELFNBQVMsRUFBRTtnQkFDVDtvQkFDQSxpQkFBaUIsRUFBRSxJQUFJO2lCQUN0QjthQUNGO1NBQ0Y7S0FDRjtJQUNELGlCQUFpQixFQUFFLEVBQUU7Q0FDdEIsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiXG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY29yZScpO1xuaW1wb3J0IGNsb3VkZnJvbnQgPSByZXF1aXJlKCcuLi9saWInKTtcblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcblxuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2F3cy1jZGstY2xvdWRmcm9udC1jdXN0b20nKTtcblxubmV3IGNsb3VkZnJvbnQuQ2xvdWRGcm9udFdlYkRpc3RyaWJ1dGlvbihzdGFjaywgJ0FuQW1hemluZ1dlYnNpdGVQcm9iYWJseScsIHtcbiAgb3JpZ2luQ29uZmlnczogW1xuICAgIHtcbiAgICAgIG9yaWdpbkhlYWRlcnM6IHtcbiAgICAgICAgXCJYLUN1c3RvbS1IZWFkZXJcIjogXCJzb21ldmFsdWVcIixcbiAgICAgIH0sXG4gICAgICBjdXN0b21PcmlnaW5Tb3VyY2U6IHtcbiAgICAgICAgZG9tYWluTmFtZTogXCJicmVsYW5kbS5hMnouY29tXCIsXG4gICAgICB9LFxuICAgICAgYmVoYXZpb3JzOiBbXG4gICAgICAgIHtcbiAgICAgICAgaXNEZWZhdWx0QmVoYXZpb3I6IHRydWUsXG4gICAgICAgIH1cbiAgICAgIF0sXG4gICAgfVxuICBdLFxuICBkZWZhdWx0Um9vdE9iamVjdDogJydcbn0pO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==