"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const cloudfront = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'integ-cloudfront-s3');
const bucket = new s3.Bucket(stack, 'Bucket', { removalPolicy: cdk.RemovalPolicy.DESTROY });
const oai = new cloudfront.CfnCloudFrontOriginAccessIdentity(stack, 'OAI', {
    cloudFrontOriginAccessIdentityConfig: {
        comment: 'Allows CloudFront to reach to the bucket!',
    }
});
const dist = new cloudfront.CloudFrontWebDistribution(stack, 'Distribution', {
    originConfigs: [{
            behaviors: [{ isDefaultBehavior: true }],
            s3OriginSource: {
                s3BucketSource: bucket,
                originAccessIdentityId: oai.ref,
            },
        }]
});
bucket.addToResourcePolicy(new iam.PolicyStatement({
    actions: ['s3:Get*', 's3:List*'],
    resources: [bucket.bucketArn, bucket.arnForObjects('*')],
    principals: [new iam.CanonicalUserPrincipal(oai.attrS3CanonicalUserId)],
}));
new cdk.CfnOutput(stack, 'DistributionDomainName', { value: dist.domainName });
//# sourceMappingURL=data:application/json;base64,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