"""add Uniswap V4

Revision ID: 756fba1f75f4
Revises: 9347bbfcd47a
Create Date: 2025-08-04 20:56:04.525682

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

from degenbot.database.models import IntMappedToString

# revision identifiers, used by Alembic.
revision: str = "756fba1f75f4"
down_revision: str | Sequence[str] | None = "9347bbfcd47a"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "pool_managers",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("address", sa.String(length=42), nullable=False),
        sa.Column("chain", sa.Integer(), nullable=False),
        sa.Column("kind", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_pool_managers_address"), "pool_managers", ["address"], unique=False)
    op.create_table(
        "managed_pools",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("manager_id", sa.Integer(), nullable=False),
        sa.Column("kind", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["manager_id"],
            ["pool_managers.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "managed_pool_initialization_maps",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("managed_pool_id", sa.Integer(), nullable=False),
        sa.Column("word", sa.Integer(), nullable=False),
        sa.Column("bitmap", IntMappedToString(length=78), nullable=False),
        sa.ForeignKeyConstraint(
            ["managed_pool_id"],
            ["managed_pools.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        "ix_managed_pool_initialization_maps_pool_id_word",
        "managed_pool_initialization_maps",
        ["managed_pool_id", "word"],
        unique=True,
    )
    op.create_table(
        "managed_pool_liquidity_positions",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("managed_pool_id", sa.Integer(), nullable=False),
        sa.Column("tick", sa.Integer(), nullable=False),
        sa.Column("liquidity_net", IntMappedToString(length=78), nullable=False),
        sa.Column("liquidity_gross", IntMappedToString(length=78), nullable=False),
        sa.ForeignKeyConstraint(
            ["managed_pool_id"],
            ["managed_pools.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        "ix_managed_pool_liquidity_positions_pool_id_tick",
        "managed_pool_liquidity_positions",
        ["managed_pool_id", "tick"],
        unique=True,
    )
    op.create_table(
        "uniswap_v4_pools",
        sa.Column("managed_pool_id", sa.Integer(), nullable=False),
        sa.Column("pool_hash", sa.LargeBinary(), nullable=False),
        sa.Column("hooks", sa.String(length=42), nullable=False),
        sa.Column("currency0", sa.String(length=42), nullable=False),
        sa.Column("currency1", sa.String(length=42), nullable=False),
        sa.Column("fee_currency0", sa.Integer(), nullable=False),
        sa.Column("fee_currency1", sa.Integer(), nullable=False),
        sa.Column("fee_denominator", sa.Integer(), nullable=False),
        sa.Column("tick_spacing", sa.Integer(), nullable=False),
        sa.Column("has_liquidity", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ["managed_pool_id"],
            ["managed_pools.id"],
        ),
        sa.PrimaryKeyConstraint("managed_pool_id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("uniswap_v4_pools")
    op.drop_index(
        "ix_managed_pool_liquidity_positions_pool_id_tick",
        table_name="managed_pool_liquidity_positions",
    )
    op.drop_table("managed_pool_liquidity_positions")
    op.drop_index(
        "ix_managed_pool_initialization_maps_pool_id_word",
        table_name="managed_pool_initialization_maps",
    )
    op.drop_table("managed_pool_initialization_maps")
    op.drop_table("managed_pools")
    op.drop_index(op.f("ix_pool_managers_address"), table_name="pool_managers")
    op.drop_table("pool_managers")
    # ### end Alembic commands ###
