"""Uniswap V4: add liquidity update stamps

Revision ID: 8c69198e6a21
Revises: 39e331854eb2
Create Date: 2025-10-20 11:41:21.009564

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "8c69198e6a21"
down_revision: str | Sequence[str] | None = "39e331854eb2"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("uniswap_v4_pools", schema=None) as batch_op:
        batch_op.add_column(sa.Column("liquidity_update_block", sa.Integer(), nullable=True))
        batch_op.add_column(sa.Column("liquidity_update_log_index", sa.Integer(), nullable=True))

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    msg = "Downgrade is not supported for this migration."
    raise NotImplementedError(msg)
