"""initial

Revision ID: 9347bbfcd47a
Revises:
Create Date: 2025-07-30 12:39:17.554222

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

from degenbot.database.models import IntMappedToString

# revision identifiers, used by Alembic.
revision: str = "9347bbfcd47a"
down_revision: str | Sequence[str] | None = None
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "erc20_tokens",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("address", sa.String(length=42), nullable=False),
        sa.Column("chain", sa.Integer(), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.Column("symbol", sa.Text(), nullable=False),
        sa.Column("decimals", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        "ix_erc20_tokens_address_chain", "erc20_tokens", ["address", "chain"], unique=True
    )
    op.create_table(
        "metadata",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("key", sa.Text(), nullable=False),
        sa.Column("value", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "pools",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("address", sa.String(length=42), nullable=False),
        sa.Column("chain", sa.Integer(), nullable=False),
        sa.Column("kind", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_pools_address"), "pools", ["address"], unique=False)
    op.create_table(
        "aerodrome_v2_pools",
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("token0", sa.String(length=42), nullable=False),
        sa.Column("token1", sa.String(length=42), nullable=False),
        sa.Column("factory", sa.String(length=42), nullable=True),
        sa.Column("deployer", sa.String(length=42), nullable=True),
        sa.Column("fee_token0", sa.Integer(), nullable=False),
        sa.Column("fee_token1", sa.Integer(), nullable=False),
        sa.Column("fee_denominator", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("pool_id"),
    )
    op.create_table(
        "aerodrome_v3_pools",
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("tick_spacing", sa.Integer(), nullable=False),
        sa.Column("has_liquidity", sa.Boolean(), nullable=False),
        sa.Column("token0", sa.String(length=42), nullable=False),
        sa.Column("token1", sa.String(length=42), nullable=False),
        sa.Column("factory", sa.String(length=42), nullable=True),
        sa.Column("deployer", sa.String(length=42), nullable=True),
        sa.Column("fee_token0", sa.Integer(), nullable=False),
        sa.Column("fee_token1", sa.Integer(), nullable=False),
        sa.Column("fee_denominator", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("pool_id"),
    )
    op.create_table(
        "camelot_v2_pools",
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("token0", sa.String(length=42), nullable=False),
        sa.Column("token1", sa.String(length=42), nullable=False),
        sa.Column("factory", sa.String(length=42), nullable=True),
        sa.Column("deployer", sa.String(length=42), nullable=True),
        sa.Column("fee_token0", sa.Integer(), nullable=False),
        sa.Column("fee_token1", sa.Integer(), nullable=False),
        sa.Column("fee_denominator", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("pool_id"),
    )
    op.create_table(
        "initialization_maps",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("word", sa.Integer(), nullable=False),
        sa.Column("bitmap", IntMappedToString(length=78), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        "ix_initialization_maps_pool_id_word",
        "initialization_maps",
        ["pool_id", "word"],
        unique=True,
    )
    op.create_table(
        "liquidity_positions",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("tick", sa.Integer(), nullable=False),
        sa.Column("liquidity_net", IntMappedToString(length=78), nullable=False),
        sa.Column("liquidity_gross", IntMappedToString(length=78), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        "ix_liquidity_positions_pool_id_tick",
        "liquidity_positions",
        ["pool_id", "tick"],
        unique=True,
    )
    op.create_table(
        "pancakeswap_v2_pools",
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("token0", sa.String(length=42), nullable=False),
        sa.Column("token1", sa.String(length=42), nullable=False),
        sa.Column("factory", sa.String(length=42), nullable=True),
        sa.Column("deployer", sa.String(length=42), nullable=True),
        sa.Column("fee_token0", sa.Integer(), nullable=False),
        sa.Column("fee_token1", sa.Integer(), nullable=False),
        sa.Column("fee_denominator", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("pool_id"),
    )
    op.create_table(
        "pancakeswap_v3_pools",
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("tick_spacing", sa.Integer(), nullable=False),
        sa.Column("has_liquidity", sa.Boolean(), nullable=False),
        sa.Column("token0", sa.String(length=42), nullable=False),
        sa.Column("token1", sa.String(length=42), nullable=False),
        sa.Column("factory", sa.String(length=42), nullable=True),
        sa.Column("deployer", sa.String(length=42), nullable=True),
        sa.Column("fee_token0", sa.Integer(), nullable=False),
        sa.Column("fee_token1", sa.Integer(), nullable=False),
        sa.Column("fee_denominator", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("pool_id"),
    )
    op.create_table(
        "sushiswap_v2_pools",
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("token0", sa.String(length=42), nullable=False),
        sa.Column("token1", sa.String(length=42), nullable=False),
        sa.Column("factory", sa.String(length=42), nullable=True),
        sa.Column("deployer", sa.String(length=42), nullable=True),
        sa.Column("fee_token0", sa.Integer(), nullable=False),
        sa.Column("fee_token1", sa.Integer(), nullable=False),
        sa.Column("fee_denominator", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("pool_id"),
    )
    op.create_table(
        "sushiswap_v3_pools",
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("tick_spacing", sa.Integer(), nullable=False),
        sa.Column("has_liquidity", sa.Boolean(), nullable=False),
        sa.Column("token0", sa.String(length=42), nullable=False),
        sa.Column("token1", sa.String(length=42), nullable=False),
        sa.Column("factory", sa.String(length=42), nullable=True),
        sa.Column("deployer", sa.String(length=42), nullable=True),
        sa.Column("fee_token0", sa.Integer(), nullable=False),
        sa.Column("fee_token1", sa.Integer(), nullable=False),
        sa.Column("fee_denominator", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("pool_id"),
    )
    op.create_table(
        "swapbased_v2_pools",
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("token0", sa.String(length=42), nullable=False),
        sa.Column("token1", sa.String(length=42), nullable=False),
        sa.Column("factory", sa.String(length=42), nullable=True),
        sa.Column("deployer", sa.String(length=42), nullable=True),
        sa.Column("fee_token0", sa.Integer(), nullable=False),
        sa.Column("fee_token1", sa.Integer(), nullable=False),
        sa.Column("fee_denominator", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("pool_id"),
    )
    op.create_table(
        "uniswap_v2_pools",
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("token0", sa.String(length=42), nullable=False),
        sa.Column("token1", sa.String(length=42), nullable=False),
        sa.Column("factory", sa.String(length=42), nullable=True),
        sa.Column("deployer", sa.String(length=42), nullable=True),
        sa.Column("fee_token0", sa.Integer(), nullable=False),
        sa.Column("fee_token1", sa.Integer(), nullable=False),
        sa.Column("fee_denominator", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("pool_id"),
    )
    op.create_table(
        "uniswap_v3_pools",
        sa.Column("pool_id", sa.Integer(), nullable=False),
        sa.Column("tick_spacing", sa.Integer(), nullable=False),
        sa.Column("has_liquidity", sa.Boolean(), nullable=False),
        sa.Column("token0", sa.String(length=42), nullable=False),
        sa.Column("token1", sa.String(length=42), nullable=False),
        sa.Column("factory", sa.String(length=42), nullable=True),
        sa.Column("deployer", sa.String(length=42), nullable=True),
        sa.Column("fee_token0", sa.Integer(), nullable=False),
        sa.Column("fee_token1", sa.Integer(), nullable=False),
        sa.Column("fee_denominator", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pool_id"],
            ["pools.id"],
        ),
        sa.PrimaryKeyConstraint("pool_id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("uniswap_v3_pools")
    op.drop_table("uniswap_v2_pools")
    op.drop_table("swapbased_v2_pools")
    op.drop_table("sushiswap_v3_pools")
    op.drop_table("sushiswap_v2_pools")
    op.drop_table("pancakeswap_v3_pools")
    op.drop_table("pancakeswap_v2_pools")
    op.drop_index("ix_liquidity_positions_pool_id_tick", table_name="liquidity_positions")
    op.drop_table("liquidity_positions")
    op.drop_index("ix_initialization_maps_pool_id_word", table_name="initialization_maps")
    op.drop_table("initialization_maps")
    op.drop_table("camelot_v2_pools")
    op.drop_table("aerodrome_v3_pools")
    op.drop_table("aerodrome_v2_pools")
    op.drop_index(op.f("ix_pools_address"), table_name="pools")
    op.drop_table("pools")
    op.drop_table("metadata")
    op.drop_index("ix_erc20_tokens_address_chain", table_name="erc20_tokens")
    op.drop_table("erc20_tokens")
    # ### end Alembic commands ###
