# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppGroupAssignmentsArgs', 'AppGroupAssignments']

@pulumi.input_type
class AppGroupAssignmentsArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 groups: pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]):
        """
        The set of arguments for constructing a AppGroupAssignments resource.
        :param pulumi.Input[str] app_id: The ID of the application to assign a group to.
        :param pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]] groups: A group to assign the app to.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "groups", groups)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        The ID of the application to assign a group to.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]:
        """
        A group to assign the app to.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]):
        pulumi.set(self, "groups", value)


@pulumi.input_type
class _AppGroupAssignmentsState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]] = None):
        """
        Input properties used for looking up and filtering AppGroupAssignments resources.
        :param pulumi.Input[str] app_id: The ID of the application to assign a group to.
        :param pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]] groups: A group to assign the app to.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the application to assign a group to.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]]:
        """
        A group to assign the app to.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]]):
        pulumi.set(self, "groups", value)


class AppGroupAssignments(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppGroupAssignmentsGroupArgs']]]]] = None,
                 __props__=None):
        """
        Assigns groups to an application.

        This resource allows you to create multiple App Group assignments.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        example = okta.AppGroupAssignments("example",
            app_id="<app id>",
            groups=[
                okta.AppGroupAssignmentsGroupArgs(
                    id="<group id>",
                    priority=1,
                ),
                okta.AppGroupAssignmentsGroupArgs(
                    id="<another group id>",
                    priority=2,
                    profile=json.dumps({
                        "application profile field": "application profile value",
                    }),
                ),
            ])
        ```

        ## Import

        An application's group assignments can be imported via `app_id`.

        ```sh
         $ pulumi import okta:index/appGroupAssignments:AppGroupAssignments example &#60;app_id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The ID of the application to assign a group to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppGroupAssignmentsGroupArgs']]]] groups: A group to assign the app to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppGroupAssignmentsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Assigns groups to an application.

        This resource allows you to create multiple App Group assignments.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        example = okta.AppGroupAssignments("example",
            app_id="<app id>",
            groups=[
                okta.AppGroupAssignmentsGroupArgs(
                    id="<group id>",
                    priority=1,
                ),
                okta.AppGroupAssignmentsGroupArgs(
                    id="<another group id>",
                    priority=2,
                    profile=json.dumps({
                        "application profile field": "application profile value",
                    }),
                ),
            ])
        ```

        ## Import

        An application's group assignments can be imported via `app_id`.

        ```sh
         $ pulumi import okta:index/appGroupAssignments:AppGroupAssignments example &#60;app_id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param AppGroupAssignmentsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppGroupAssignmentsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppGroupAssignmentsGroupArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppGroupAssignmentsArgs.__new__(AppGroupAssignmentsArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            if groups is None and not opts.urn:
                raise TypeError("Missing required property 'groups'")
            __props__.__dict__["groups"] = groups
        super(AppGroupAssignments, __self__).__init__(
            'okta:index/appGroupAssignments:AppGroupAssignments',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppGroupAssignmentsGroupArgs']]]]] = None) -> 'AppGroupAssignments':
        """
        Get an existing AppGroupAssignments resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The ID of the application to assign a group to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppGroupAssignmentsGroupArgs']]]] groups: A group to assign the app to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppGroupAssignmentsState.__new__(_AppGroupAssignmentsState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["groups"] = groups
        return AppGroupAssignments(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        The ID of the application to assign a group to.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Sequence['outputs.AppGroupAssignmentsGroup']]:
        """
        A group to assign the app to.
        """
        return pulumi.get(self, "groups")

