# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppSignonPolicyRuleArgs', 'AppSignonPolicyRule']

@pulumi.input_type
class AppSignonPolicyRuleArgs:
    def __init__(__self__, *,
                 policy_id: pulumi.Input[str],
                 access: Optional[pulumi.Input[str]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_expression: Optional[pulumi.Input[str]] = None,
                 device_assurances_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 device_is_managed: Optional[pulumi.Input[bool]] = None,
                 device_is_registered: Optional[pulumi.Input[bool]] = None,
                 factor_mode: Optional[pulumi.Input[str]] = None,
                 groups_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 inactivity_period: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 re_authentication_frequency: Optional[pulumi.Input[str]] = None,
                 risk_score: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_types_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_types_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AppSignonPolicyRule resource.
        :param pulumi.Input[str] policy_id: ID of the app sign-on policy.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions. It can be set to `"ALLOW"` or `"DENY"`. Default is `"ALLOW"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] constraints: An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class. Each element should be in JSON format.
        :param pulumi.Input[str] custom_expression: This is an advanced optional setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_assurances_includeds: List of device assurances IDs to be included.
        :param pulumi.Input[bool] device_is_managed: If the device is managed. A device is managed if it's managed by a device management
               system. When managed is passed, `device_is_registered` must also be included and must be set to `true`.
        :param pulumi.Input[bool] device_is_registered: If the device is registered. A device is registered if the User enrolls with Okta
               Verify that is installed on the device. Can only be set to `true`.
        :param pulumi.Input[str] factor_mode: The number of factors required to satisfy this assurance level. It can be set to `"1FA"` or `"2FA"`. Default is `"2FA"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_excludeds: List of groups IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_includeds: List of groups IDs to be included.
        :param pulumi.Input[str] inactivity_period: The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals. Default is `"PT1H"`.
        :param pulumi.Input[str] name: Name of the policy rule.
        :param pulumi.Input[str] network_connection: Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: List of network zones IDs to exclude. Conflicts with `network_includes`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: List of network zones IDs to include. Conflicts with `network_excludes`.
        :param pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]] platform_includes: List of particular platforms or devices to match on.
        :param pulumi.Input[int] priority: Priority of the rule.
        :param pulumi.Input[str] re_authentication_frequency: The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. `"PT0S"` - every sign-in attempt, `"PT43800H"` - once per session. Default is `"PT2H"`.
        :param pulumi.Input[str] risk_score: The risk score specifies a particular level of risk to match on. Valid values are: `"ANY"`, `"LOW"`, `"MEDIUM"`, `"HIGH"`. Default is `"ANY"`.
        :param pulumi.Input[str] status: Status of the rule
        :param pulumi.Input[str] type: The Verification Method type. It can be set to `"ASSURANCE"`. Default is `"ASSURANCE"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_types_excludeds: List of user types IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_types_includeds: List of user types IDs to be included.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: List of users IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_includeds: List of users IDs to be included.
        """
        pulumi.set(__self__, "policy_id", policy_id)
        if access is not None:
            pulumi.set(__self__, "access", access)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if custom_expression is not None:
            pulumi.set(__self__, "custom_expression", custom_expression)
        if device_assurances_includeds is not None:
            pulumi.set(__self__, "device_assurances_includeds", device_assurances_includeds)
        if device_is_managed is not None:
            pulumi.set(__self__, "device_is_managed", device_is_managed)
        if device_is_registered is not None:
            pulumi.set(__self__, "device_is_registered", device_is_registered)
        if factor_mode is not None:
            pulumi.set(__self__, "factor_mode", factor_mode)
        if groups_excludeds is not None:
            pulumi.set(__self__, "groups_excludeds", groups_excludeds)
        if groups_includeds is not None:
            pulumi.set(__self__, "groups_includeds", groups_includeds)
        if inactivity_period is not None:
            pulumi.set(__self__, "inactivity_period", inactivity_period)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connection is not None:
            pulumi.set(__self__, "network_connection", network_connection)
        if network_excludes is not None:
            pulumi.set(__self__, "network_excludes", network_excludes)
        if network_includes is not None:
            pulumi.set(__self__, "network_includes", network_includes)
        if platform_includes is not None:
            pulumi.set(__self__, "platform_includes", platform_includes)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if re_authentication_frequency is not None:
            pulumi.set(__self__, "re_authentication_frequency", re_authentication_frequency)
        if risk_score is not None:
            pulumi.set(__self__, "risk_score", risk_score)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_types_excludeds is not None:
            pulumi.set(__self__, "user_types_excludeds", user_types_excludeds)
        if user_types_includeds is not None:
            pulumi.set(__self__, "user_types_includeds", user_types_includeds)
        if users_excludeds is not None:
            pulumi.set(__self__, "users_excludeds", users_excludeds)
        if users_includeds is not None:
            pulumi.set(__self__, "users_includeds", users_includeds)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[str]:
        """
        ID of the app sign-on policy.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        Allow or deny access based on the rule conditions. It can be set to `"ALLOW"` or `"DENY"`. Default is `"ALLOW"`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class. Each element should be in JSON format.
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "constraints", value)

    @property
    @pulumi.getter(name="customExpression")
    def custom_expression(self) -> Optional[pulumi.Input[str]]:
        """
        This is an advanced optional setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        """
        return pulumi.get(self, "custom_expression")

    @custom_expression.setter
    def custom_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_expression", value)

    @property
    @pulumi.getter(name="deviceAssurancesIncludeds")
    def device_assurances_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of device assurances IDs to be included.
        """
        return pulumi.get(self, "device_assurances_includeds")

    @device_assurances_includeds.setter
    def device_assurances_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_assurances_includeds", value)

    @property
    @pulumi.getter(name="deviceIsManaged")
    def device_is_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        If the device is managed. A device is managed if it's managed by a device management
        system. When managed is passed, `device_is_registered` must also be included and must be set to `true`.
        """
        return pulumi.get(self, "device_is_managed")

    @device_is_managed.setter
    def device_is_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "device_is_managed", value)

    @property
    @pulumi.getter(name="deviceIsRegistered")
    def device_is_registered(self) -> Optional[pulumi.Input[bool]]:
        """
        If the device is registered. A device is registered if the User enrolls with Okta
        Verify that is installed on the device. Can only be set to `true`.
        """
        return pulumi.get(self, "device_is_registered")

    @device_is_registered.setter
    def device_is_registered(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "device_is_registered", value)

    @property
    @pulumi.getter(name="factorMode")
    def factor_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The number of factors required to satisfy this assurance level. It can be set to `"1FA"` or `"2FA"`. Default is `"2FA"`.
        """
        return pulumi.get(self, "factor_mode")

    @factor_mode.setter
    def factor_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "factor_mode", value)

    @property
    @pulumi.getter(name="groupsExcludeds")
    def groups_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of groups IDs to be excluded.
        """
        return pulumi.get(self, "groups_excludeds")

    @groups_excludeds.setter
    def groups_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_excludeds", value)

    @property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of groups IDs to be included.
        """
        return pulumi.get(self, "groups_includeds")

    @groups_includeds.setter
    def groups_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_includeds", value)

    @property
    @pulumi.getter(name="inactivityPeriod")
    def inactivity_period(self) -> Optional[pulumi.Input[str]]:
        """
        The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals. Default is `"PT1H"`.
        """
        return pulumi.get(self, "inactivity_period")

    @inactivity_period.setter
    def inactivity_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inactivity_period", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the policy rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> Optional[pulumi.Input[str]]:
        """
        Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        """
        return pulumi.get(self, "network_connection")

    @network_connection.setter
    def network_connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_connection", value)

    @property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of network zones IDs to exclude. Conflicts with `network_includes`.
        """
        return pulumi.get(self, "network_excludes")

    @network_excludes.setter
    def network_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_excludes", value)

    @property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of network zones IDs to include. Conflicts with `network_excludes`.
        """
        return pulumi.get(self, "network_includes")

    @network_includes.setter
    def network_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_includes", value)

    @property
    @pulumi.getter(name="platformIncludes")
    def platform_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]]:
        """
        List of particular platforms or devices to match on.
        """
        return pulumi.get(self, "platform_includes")

    @platform_includes.setter
    def platform_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]]):
        pulumi.set(self, "platform_includes", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="reAuthenticationFrequency")
    def re_authentication_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. `"PT0S"` - every sign-in attempt, `"PT43800H"` - once per session. Default is `"PT2H"`.
        """
        return pulumi.get(self, "re_authentication_frequency")

    @re_authentication_frequency.setter
    def re_authentication_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "re_authentication_frequency", value)

    @property
    @pulumi.getter(name="riskScore")
    def risk_score(self) -> Optional[pulumi.Input[str]]:
        """
        The risk score specifies a particular level of risk to match on. Valid values are: `"ANY"`, `"LOW"`, `"MEDIUM"`, `"HIGH"`. Default is `"ANY"`.
        """
        return pulumi.get(self, "risk_score")

    @risk_score.setter
    def risk_score(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "risk_score", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the rule
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The Verification Method type. It can be set to `"ASSURANCE"`. Default is `"ASSURANCE"`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userTypesExcludeds")
    def user_types_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user types IDs to be excluded.
        """
        return pulumi.get(self, "user_types_excludeds")

    @user_types_excludeds.setter
    def user_types_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_types_excludeds", value)

    @property
    @pulumi.getter(name="userTypesIncludeds")
    def user_types_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user types IDs to be included.
        """
        return pulumi.get(self, "user_types_includeds")

    @user_types_includeds.setter
    def user_types_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_types_includeds", value)

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of users IDs to be excluded.
        """
        return pulumi.get(self, "users_excludeds")

    @users_excludeds.setter
    def users_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users_excludeds", value)

    @property
    @pulumi.getter(name="usersIncludeds")
    def users_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of users IDs to be included.
        """
        return pulumi.get(self, "users_includeds")

    @users_includeds.setter
    def users_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users_includeds", value)


@pulumi.input_type
class _AppSignonPolicyRuleState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[str]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_expression: Optional[pulumi.Input[str]] = None,
                 device_assurances_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 device_is_managed: Optional[pulumi.Input[bool]] = None,
                 device_is_registered: Optional[pulumi.Input[bool]] = None,
                 factor_mode: Optional[pulumi.Input[str]] = None,
                 groups_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 inactivity_period: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 re_authentication_frequency: Optional[pulumi.Input[str]] = None,
                 risk_score: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_types_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_types_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AppSignonPolicyRule resources.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions. It can be set to `"ALLOW"` or `"DENY"`. Default is `"ALLOW"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] constraints: An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class. Each element should be in JSON format.
        :param pulumi.Input[str] custom_expression: This is an advanced optional setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_assurances_includeds: List of device assurances IDs to be included.
        :param pulumi.Input[bool] device_is_managed: If the device is managed. A device is managed if it's managed by a device management
               system. When managed is passed, `device_is_registered` must also be included and must be set to `true`.
        :param pulumi.Input[bool] device_is_registered: If the device is registered. A device is registered if the User enrolls with Okta
               Verify that is installed on the device. Can only be set to `true`.
        :param pulumi.Input[str] factor_mode: The number of factors required to satisfy this assurance level. It can be set to `"1FA"` or `"2FA"`. Default is `"2FA"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_excludeds: List of groups IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_includeds: List of groups IDs to be included.
        :param pulumi.Input[str] inactivity_period: The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals. Default is `"PT1H"`.
        :param pulumi.Input[str] name: Name of the policy rule.
        :param pulumi.Input[str] network_connection: Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: List of network zones IDs to exclude. Conflicts with `network_includes`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: List of network zones IDs to include. Conflicts with `network_excludes`.
        :param pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]] platform_includes: List of particular platforms or devices to match on.
        :param pulumi.Input[str] policy_id: ID of the app sign-on policy.
        :param pulumi.Input[int] priority: Priority of the rule.
        :param pulumi.Input[str] re_authentication_frequency: The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. `"PT0S"` - every sign-in attempt, `"PT43800H"` - once per session. Default is `"PT2H"`.
        :param pulumi.Input[str] risk_score: The risk score specifies a particular level of risk to match on. Valid values are: `"ANY"`, `"LOW"`, `"MEDIUM"`, `"HIGH"`. Default is `"ANY"`.
        :param pulumi.Input[str] status: Status of the rule
        :param pulumi.Input[bool] system: Often the "Catch-all Rule" this rule is the system (default) rule for its associated policy.
        :param pulumi.Input[str] type: The Verification Method type. It can be set to `"ASSURANCE"`. Default is `"ASSURANCE"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_types_excludeds: List of user types IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_types_includeds: List of user types IDs to be included.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: List of users IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_includeds: List of users IDs to be included.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if custom_expression is not None:
            pulumi.set(__self__, "custom_expression", custom_expression)
        if device_assurances_includeds is not None:
            pulumi.set(__self__, "device_assurances_includeds", device_assurances_includeds)
        if device_is_managed is not None:
            pulumi.set(__self__, "device_is_managed", device_is_managed)
        if device_is_registered is not None:
            pulumi.set(__self__, "device_is_registered", device_is_registered)
        if factor_mode is not None:
            pulumi.set(__self__, "factor_mode", factor_mode)
        if groups_excludeds is not None:
            pulumi.set(__self__, "groups_excludeds", groups_excludeds)
        if groups_includeds is not None:
            pulumi.set(__self__, "groups_includeds", groups_includeds)
        if inactivity_period is not None:
            pulumi.set(__self__, "inactivity_period", inactivity_period)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connection is not None:
            pulumi.set(__self__, "network_connection", network_connection)
        if network_excludes is not None:
            pulumi.set(__self__, "network_excludes", network_excludes)
        if network_includes is not None:
            pulumi.set(__self__, "network_includes", network_includes)
        if platform_includes is not None:
            pulumi.set(__self__, "platform_includes", platform_includes)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if re_authentication_frequency is not None:
            pulumi.set(__self__, "re_authentication_frequency", re_authentication_frequency)
        if risk_score is not None:
            pulumi.set(__self__, "risk_score", risk_score)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system is not None:
            pulumi.set(__self__, "system", system)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_types_excludeds is not None:
            pulumi.set(__self__, "user_types_excludeds", user_types_excludeds)
        if user_types_includeds is not None:
            pulumi.set(__self__, "user_types_includeds", user_types_includeds)
        if users_excludeds is not None:
            pulumi.set(__self__, "users_excludeds", users_excludeds)
        if users_includeds is not None:
            pulumi.set(__self__, "users_includeds", users_includeds)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        Allow or deny access based on the rule conditions. It can be set to `"ALLOW"` or `"DENY"`. Default is `"ALLOW"`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class. Each element should be in JSON format.
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "constraints", value)

    @property
    @pulumi.getter(name="customExpression")
    def custom_expression(self) -> Optional[pulumi.Input[str]]:
        """
        This is an advanced optional setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        """
        return pulumi.get(self, "custom_expression")

    @custom_expression.setter
    def custom_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_expression", value)

    @property
    @pulumi.getter(name="deviceAssurancesIncludeds")
    def device_assurances_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of device assurances IDs to be included.
        """
        return pulumi.get(self, "device_assurances_includeds")

    @device_assurances_includeds.setter
    def device_assurances_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_assurances_includeds", value)

    @property
    @pulumi.getter(name="deviceIsManaged")
    def device_is_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        If the device is managed. A device is managed if it's managed by a device management
        system. When managed is passed, `device_is_registered` must also be included and must be set to `true`.
        """
        return pulumi.get(self, "device_is_managed")

    @device_is_managed.setter
    def device_is_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "device_is_managed", value)

    @property
    @pulumi.getter(name="deviceIsRegistered")
    def device_is_registered(self) -> Optional[pulumi.Input[bool]]:
        """
        If the device is registered. A device is registered if the User enrolls with Okta
        Verify that is installed on the device. Can only be set to `true`.
        """
        return pulumi.get(self, "device_is_registered")

    @device_is_registered.setter
    def device_is_registered(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "device_is_registered", value)

    @property
    @pulumi.getter(name="factorMode")
    def factor_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The number of factors required to satisfy this assurance level. It can be set to `"1FA"` or `"2FA"`. Default is `"2FA"`.
        """
        return pulumi.get(self, "factor_mode")

    @factor_mode.setter
    def factor_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "factor_mode", value)

    @property
    @pulumi.getter(name="groupsExcludeds")
    def groups_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of groups IDs to be excluded.
        """
        return pulumi.get(self, "groups_excludeds")

    @groups_excludeds.setter
    def groups_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_excludeds", value)

    @property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of groups IDs to be included.
        """
        return pulumi.get(self, "groups_includeds")

    @groups_includeds.setter
    def groups_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_includeds", value)

    @property
    @pulumi.getter(name="inactivityPeriod")
    def inactivity_period(self) -> Optional[pulumi.Input[str]]:
        """
        The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals. Default is `"PT1H"`.
        """
        return pulumi.get(self, "inactivity_period")

    @inactivity_period.setter
    def inactivity_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inactivity_period", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the policy rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> Optional[pulumi.Input[str]]:
        """
        Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        """
        return pulumi.get(self, "network_connection")

    @network_connection.setter
    def network_connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_connection", value)

    @property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of network zones IDs to exclude. Conflicts with `network_includes`.
        """
        return pulumi.get(self, "network_excludes")

    @network_excludes.setter
    def network_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_excludes", value)

    @property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of network zones IDs to include. Conflicts with `network_excludes`.
        """
        return pulumi.get(self, "network_includes")

    @network_includes.setter
    def network_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_includes", value)

    @property
    @pulumi.getter(name="platformIncludes")
    def platform_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]]:
        """
        List of particular platforms or devices to match on.
        """
        return pulumi.get(self, "platform_includes")

    @platform_includes.setter
    def platform_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]]):
        pulumi.set(self, "platform_includes", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the app sign-on policy.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="reAuthenticationFrequency")
    def re_authentication_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. `"PT0S"` - every sign-in attempt, `"PT43800H"` - once per session. Default is `"PT2H"`.
        """
        return pulumi.get(self, "re_authentication_frequency")

    @re_authentication_frequency.setter
    def re_authentication_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "re_authentication_frequency", value)

    @property
    @pulumi.getter(name="riskScore")
    def risk_score(self) -> Optional[pulumi.Input[str]]:
        """
        The risk score specifies a particular level of risk to match on. Valid values are: `"ANY"`, `"LOW"`, `"MEDIUM"`, `"HIGH"`. Default is `"ANY"`.
        """
        return pulumi.get(self, "risk_score")

    @risk_score.setter
    def risk_score(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "risk_score", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the rule
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def system(self) -> Optional[pulumi.Input[bool]]:
        """
        Often the "Catch-all Rule" this rule is the system (default) rule for its associated policy.
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "system", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The Verification Method type. It can be set to `"ASSURANCE"`. Default is `"ASSURANCE"`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userTypesExcludeds")
    def user_types_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user types IDs to be excluded.
        """
        return pulumi.get(self, "user_types_excludeds")

    @user_types_excludeds.setter
    def user_types_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_types_excludeds", value)

    @property
    @pulumi.getter(name="userTypesIncludeds")
    def user_types_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user types IDs to be included.
        """
        return pulumi.get(self, "user_types_includeds")

    @user_types_includeds.setter
    def user_types_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_types_includeds", value)

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of users IDs to be excluded.
        """
        return pulumi.get(self, "users_excludeds")

    @users_excludeds.setter
    def users_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users_excludeds", value)

    @property
    @pulumi.getter(name="usersIncludeds")
    def users_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of users IDs to be included.
        """
        return pulumi.get(self, "users_includeds")

    @users_includeds.setter
    def users_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users_includeds", value)


class AppSignonPolicyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_expression: Optional[pulumi.Input[str]] = None,
                 device_assurances_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 device_is_managed: Optional[pulumi.Input[bool]] = None,
                 device_is_registered: Optional[pulumi.Input[bool]] = None,
                 factor_mode: Optional[pulumi.Input[str]] = None,
                 groups_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 inactivity_period: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppSignonPolicyRulePlatformIncludeArgs']]]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 re_authentication_frequency: Optional[pulumi.Input[str]] = None,
                 risk_score: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_types_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_types_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.

        This resource allows you to create and configure a sign-on policy rule for the application.

        A default or `Catch-all Rule` sign-on policy rule can be imported and managed as a custom rule.
        The only difference is that these fields are immutable and can not be managed: `network_connection`, `network_excludes`,
        `network_includes`, `platform_include`, `custom_expression`, `device_is_registered`, `device_is_managed`, `users_excluded`,
        `users_included`, `groups_excluded`, `groups_included`, `user_types_excluded` and `user_types_included`.

        ## Example Usage

        ### Rule with Constraints
        ### Example 1:

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test = okta.AppSignonPolicyRule("test",
            policy_id=data["okta_app_signon_policy"]["test"]["id"],
            constraints=[json.dumps({
                "knowledge": {
                    "types": ["password"],
                },
            })])
        ```

        This will create an app sign-on policy rule with the following `THEN` block:

        ```python
        import pulumi
        ```
        ### Example 2:

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test = okta.AppSignonPolicyRule("test",
            policy_id=data["okta_app_signon_policy"]["test"]["id"],
            constraints=[json.dumps({
                "knowledge": {
                    "reauthenticateIn": "PT2H",
                    "types": ["password"],
                },
                "possession": {
                    "deviceBound": "REQUIRED",
                    "hardwareProtection": "REQUIRED",
                },
            })])
        ```

        This will create an app sign-on policy rule with the following `THEN` block:

        ```python
        import pulumi
        ```

        More examples can be
        found [here](https://developer.okta.com/docs/reference/api/policy/#verification-method-json-examples).
        ### Complex example

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test_saml = okta.app.Saml("testSaml",
            label="testAcc_replace_with_uuid",
            sso_url="https://google.com",
            recipient="https://here.com",
            destination="https://its-about-the-journey.com",
            audience="https://audience.com",
            subject_name_id_template="${user.userName}",
            subject_name_id_format="urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress",
            response_signed=True,
            signature_algorithm="RSA_SHA256",
            digest_algorithm="SHA256",
            honor_force_authn=False,
            authn_context_class_ref="urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport",
            single_logout_issuer="https://dunshire.okta.com",
            single_logout_url="https://dunshire.okta.com/logout",
            single_logout_certificate=\"\"\"MIIFnDCCA4QCCQDBSLbiON2T1zANBgkqhkiG9w0BAQsFADCBjzELMAkGA1UEBhMCVVMxDjAMBgNV
        BAgMBU1haW5lMRAwDgYDVQQHDAdDYXJpYm91MRcwFQYDVQQKDA5Tbm93bWFrZXJzIEluYzEUMBIG
        A1UECwwLRW5naW5lZXJpbmcxDTALBgNVBAMMBFNub3cxIDAeBgkqhkiG9w0BCQEWEWVtYWlsQGV4
        YW1wbGUuY29tMB4XDTIwMTIwMzIyNDY0M1oXDTMwMTIwMTIyNDY0M1owgY8xCzAJBgNVBAYTAlVT
        MQ4wDAYDVQQIDAVNYWluZTEQMA4GA1UEBwwHQ2FyaWJvdTEXMBUGA1UECgwOU25vd21ha2VycyBJ
        bmMxFDASBgNVBAsMC0VuZ2luZWVyaW5nMQ0wCwYDVQQDDARTbm93MSAwHgYJKoZIhvcNAQkBFhFl
        bWFpbEBleGFtcGxlLmNvbTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBANMmWDjXPdoa
        PyzIENqeY9njLan2FqCbQPSestWUUcb6NhDsJVGSQ7XR+ozQA5TaJzbP7cAJUj8vCcbqMZsgOQAu
        O/pzYyQEKptLmrGvPn7xkJ1A1xLkp2NY18cpDTeUPueJUoidZ9EJwEuyUZIktzxNNU1pA1lGijiu
        2XNxs9d9JR/hm3tCu9Im8qLVB4JtX80YUa6QtlRjWR/H8a373AYCOASdoB3c57fIPD8ATDNy2w/c
        fCVGiyKDMFB+GA/WTsZpOP3iohRp8ltAncSuzypcztb2iE+jijtTsiC9kUA2abAJqqpoCJubNShi
        Vff4822czpziS44MV2guC9wANi8u3Uyl5MKsU95j01jzadKRP5S+2f0K+n8n4UoV9fnqZFyuGAKd
        CJi9K6NlSAP+TgPe/JP9FOSuxQOHWJfmdLHdJD+evoKi9E55sr5lRFK0xU1Fj5Ld7zjC0pXPhtJf
        sgjEZzD433AsHnRzvRT1KSNCPkLYomznZo5n9rWYgCQ8HcytlQDTesmKE+s05E/VSWNtH84XdDrt
        ieXwfwhHfaABSu+WjZYxi9CXdFCSvXhsgufUcK4FbYAHl/ga/cJxZc52yFC7Pcq0u9O2BSCjYPdQ
        DAHs9dhT1RhwVLM8RmoAzgxyyzau0gxnAlgSBD9FMW6dXqIHIp8yAAg9cRXhYRTNAgMBAAEwDQYJ
        KoZIhvcNAQELBQADggIBADofEC1SvG8qa7pmKCjB/E9Sxhk3mvUO9Gq43xzwVb721Ng3VYf4vGU3
        wLUwJeLt0wggnj26NJweN5T3q9T8UMxZhHSWvttEU3+S1nArRB0beti716HSlOCDx4wTmBu/D1MG
        t/kZYFJw+zuzvAcbYct2pK69AQhD8xAIbQvqADJI7cCK3yRry+aWtppc58P81KYabUlCfFXfhJ9E
        P72ffN4jVHpX3lxxYh7FKAdiKbY2FYzjsc7RdgKI1R3iAAZUCGBTvezNzaetGzTUjjl/g1tcVYij
        ltH9ZOQBPlUMI88lxUxqgRTerpPmAJH00CACx4JFiZrweLM1trZyy06wNDQgLrqHr3EOagBF/O2h
        hfTehNdVr6iq3YhKWBo4/+RL0RCzHMh4u86VbDDnDn4Y6HzLuyIAtBFoikoKM6UHTOa0Pqv2bBr5
        wbkRkVUxl9yJJw/HmTCdfnsM9dTOJUKzEglnGF2184Gg+qJDZB6fSf0EAO1F6sTqiSswl+uHQZiy
        DaZzyU7Gg5seKOZ20zTRaX3Ihj9Zij/ORnrARE7eM/usKMECp+7syUwAUKxDCZkGiUdskmOhhBGL
        JtbyK3F2UvoJoLsm3pIcvMak9KwMjSTGJB47ABUP1+w+zGcNk0D5Co3IJ6QekiLfWJyQ+kKsWLKt
        zOYQQatrnBagM7MI2/T4
        \"\"\",
            attribute_statements=[okta.app.SamlAttributeStatementArgs(
                type="GROUP",
                name="groups",
                filter_type="REGEX",
                filter_value=".*",
            )])
        test_app_signon_policy = okta.get_app_signon_policy_output(app_id=test_saml.id)
        test_user = []
        for range in [{"value": i} for i in range(0, 5)]:
            test_user.append(okta.user.User(f"testUser-{range['value']}",
                first_name="TestAcc",
                last_name="Smith",
                login=f"testAcc_{range['value']}@example.com",
                email=f"testAcc_{range['value']}@example.com"))
        this = []
        for range in [{"value": i} for i in range(0, 5)]:
            this.append(okta.group.Group(f"this-{range['value']}", description=f"testAcc_{range['value']}"))
        test_user_type = okta.user.UserType("testUserType",
            display_name="Terraform Acceptance Test User Type Updated",
            description="Terraform Acceptance Test User Type Updated")
        test_zone = okta.network.Zone("testZone",
            type="IP",
            gateways=[
                "1.2.3.4/24",
                "2.3.4.5-2.3.4.15",
            ],
            proxies=[
                "2.2.3.4/24",
                "3.3.4.5-3.3.4.15",
            ])
        default = okta.user.get_user_type(name="user")
        test_device_assurance_android = okta.policy.DeviceAssuranceAndroid("testDeviceAssuranceAndroid",
            os_version="12",
            jailbreak=False)
        test_app_signon_policy_rule = okta.AppSignonPolicyRule("testAppSignonPolicyRule",
            policy_id=test_app_signon_policy.id,
            access="ALLOW",
            custom_expression="user.status == \\"ACTIVE\\"",
            device_is_managed=False,
            device_is_registered=True,
            factor_mode="2FA",
            groups_excludeds=[
                this[2].id,
                this[3].id,
                this[4].id,
            ],
            groups_includeds=[
                this[0].id,
                this[1].id,
            ],
            device_assurances_includeds=[test_device_assurance_android.id],
            network_connection="ZONE",
            network_includes=[test_zone.id],
            platform_includes=[
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="ANDROID",
                    type="MOBILE",
                ),
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="IOS",
                    type="MOBILE",
                ),
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="MACOS",
                    type="DESKTOP",
                ),
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="OTHER",
                    type="DESKTOP",
                ),
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="OTHER",
                    type="MOBILE",
                ),
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="WINDOWS",
                    type="DESKTOP",
                ),
            ],
            priority=98,
            re_authentication_frequency="PT43800H",
            type="ASSURANCE",
            user_types_excludeds=[test_user_type.id],
            user_types_includeds=[default.id],
            users_excludeds=[
                test_user[2].id,
                test_user[3].id,
                test_user[4].id,
            ],
            users_includeds=[
                test_user[0].id,
                test_user[1].id,
            ],
            constraints=[
                json.dumps({
                    "knowledge": {
                        "reauthenticateIn": "PT2H",
                        "types": ["password"],
                    },
                    "possession": {
                        "deviceBound": "REQUIRED",
                    },
                }),
                json.dumps({
                    "possession": {
                        "deviceBound": "REQUIRED",
                        "hardwareProtection": "REQUIRED",
                        "userPresence": "OPTIONAL",
                    },
                }),
            ])
        ```

        ## Import

        Okta app sign-on policy rule can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/appSignonPolicyRule:AppSignonPolicyRule example &#60;policy_id&#62;/&#60;rule_id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions. It can be set to `"ALLOW"` or `"DENY"`. Default is `"ALLOW"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] constraints: An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class. Each element should be in JSON format.
        :param pulumi.Input[str] custom_expression: This is an advanced optional setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_assurances_includeds: List of device assurances IDs to be included.
        :param pulumi.Input[bool] device_is_managed: If the device is managed. A device is managed if it's managed by a device management
               system. When managed is passed, `device_is_registered` must also be included and must be set to `true`.
        :param pulumi.Input[bool] device_is_registered: If the device is registered. A device is registered if the User enrolls with Okta
               Verify that is installed on the device. Can only be set to `true`.
        :param pulumi.Input[str] factor_mode: The number of factors required to satisfy this assurance level. It can be set to `"1FA"` or `"2FA"`. Default is `"2FA"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_excludeds: List of groups IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_includeds: List of groups IDs to be included.
        :param pulumi.Input[str] inactivity_period: The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals. Default is `"PT1H"`.
        :param pulumi.Input[str] name: Name of the policy rule.
        :param pulumi.Input[str] network_connection: Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: List of network zones IDs to exclude. Conflicts with `network_includes`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: List of network zones IDs to include. Conflicts with `network_excludes`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppSignonPolicyRulePlatformIncludeArgs']]]] platform_includes: List of particular platforms or devices to match on.
        :param pulumi.Input[str] policy_id: ID of the app sign-on policy.
        :param pulumi.Input[int] priority: Priority of the rule.
        :param pulumi.Input[str] re_authentication_frequency: The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. `"PT0S"` - every sign-in attempt, `"PT43800H"` - once per session. Default is `"PT2H"`.
        :param pulumi.Input[str] risk_score: The risk score specifies a particular level of risk to match on. Valid values are: `"ANY"`, `"LOW"`, `"MEDIUM"`, `"HIGH"`. Default is `"ANY"`.
        :param pulumi.Input[str] status: Status of the rule
        :param pulumi.Input[str] type: The Verification Method type. It can be set to `"ASSURANCE"`. Default is `"ASSURANCE"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_types_excludeds: List of user types IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_types_includeds: List of user types IDs to be included.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: List of users IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_includeds: List of users IDs to be included.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSignonPolicyRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.

        This resource allows you to create and configure a sign-on policy rule for the application.

        A default or `Catch-all Rule` sign-on policy rule can be imported and managed as a custom rule.
        The only difference is that these fields are immutable and can not be managed: `network_connection`, `network_excludes`,
        `network_includes`, `platform_include`, `custom_expression`, `device_is_registered`, `device_is_managed`, `users_excluded`,
        `users_included`, `groups_excluded`, `groups_included`, `user_types_excluded` and `user_types_included`.

        ## Example Usage

        ### Rule with Constraints
        ### Example 1:

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test = okta.AppSignonPolicyRule("test",
            policy_id=data["okta_app_signon_policy"]["test"]["id"],
            constraints=[json.dumps({
                "knowledge": {
                    "types": ["password"],
                },
            })])
        ```

        This will create an app sign-on policy rule with the following `THEN` block:

        ```python
        import pulumi
        ```
        ### Example 2:

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test = okta.AppSignonPolicyRule("test",
            policy_id=data["okta_app_signon_policy"]["test"]["id"],
            constraints=[json.dumps({
                "knowledge": {
                    "reauthenticateIn": "PT2H",
                    "types": ["password"],
                },
                "possession": {
                    "deviceBound": "REQUIRED",
                    "hardwareProtection": "REQUIRED",
                },
            })])
        ```

        This will create an app sign-on policy rule with the following `THEN` block:

        ```python
        import pulumi
        ```

        More examples can be
        found [here](https://developer.okta.com/docs/reference/api/policy/#verification-method-json-examples).
        ### Complex example

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test_saml = okta.app.Saml("testSaml",
            label="testAcc_replace_with_uuid",
            sso_url="https://google.com",
            recipient="https://here.com",
            destination="https://its-about-the-journey.com",
            audience="https://audience.com",
            subject_name_id_template="${user.userName}",
            subject_name_id_format="urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress",
            response_signed=True,
            signature_algorithm="RSA_SHA256",
            digest_algorithm="SHA256",
            honor_force_authn=False,
            authn_context_class_ref="urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport",
            single_logout_issuer="https://dunshire.okta.com",
            single_logout_url="https://dunshire.okta.com/logout",
            single_logout_certificate=\"\"\"MIIFnDCCA4QCCQDBSLbiON2T1zANBgkqhkiG9w0BAQsFADCBjzELMAkGA1UEBhMCVVMxDjAMBgNV
        BAgMBU1haW5lMRAwDgYDVQQHDAdDYXJpYm91MRcwFQYDVQQKDA5Tbm93bWFrZXJzIEluYzEUMBIG
        A1UECwwLRW5naW5lZXJpbmcxDTALBgNVBAMMBFNub3cxIDAeBgkqhkiG9w0BCQEWEWVtYWlsQGV4
        YW1wbGUuY29tMB4XDTIwMTIwMzIyNDY0M1oXDTMwMTIwMTIyNDY0M1owgY8xCzAJBgNVBAYTAlVT
        MQ4wDAYDVQQIDAVNYWluZTEQMA4GA1UEBwwHQ2FyaWJvdTEXMBUGA1UECgwOU25vd21ha2VycyBJ
        bmMxFDASBgNVBAsMC0VuZ2luZWVyaW5nMQ0wCwYDVQQDDARTbm93MSAwHgYJKoZIhvcNAQkBFhFl
        bWFpbEBleGFtcGxlLmNvbTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBANMmWDjXPdoa
        PyzIENqeY9njLan2FqCbQPSestWUUcb6NhDsJVGSQ7XR+ozQA5TaJzbP7cAJUj8vCcbqMZsgOQAu
        O/pzYyQEKptLmrGvPn7xkJ1A1xLkp2NY18cpDTeUPueJUoidZ9EJwEuyUZIktzxNNU1pA1lGijiu
        2XNxs9d9JR/hm3tCu9Im8qLVB4JtX80YUa6QtlRjWR/H8a373AYCOASdoB3c57fIPD8ATDNy2w/c
        fCVGiyKDMFB+GA/WTsZpOP3iohRp8ltAncSuzypcztb2iE+jijtTsiC9kUA2abAJqqpoCJubNShi
        Vff4822czpziS44MV2guC9wANi8u3Uyl5MKsU95j01jzadKRP5S+2f0K+n8n4UoV9fnqZFyuGAKd
        CJi9K6NlSAP+TgPe/JP9FOSuxQOHWJfmdLHdJD+evoKi9E55sr5lRFK0xU1Fj5Ld7zjC0pXPhtJf
        sgjEZzD433AsHnRzvRT1KSNCPkLYomznZo5n9rWYgCQ8HcytlQDTesmKE+s05E/VSWNtH84XdDrt
        ieXwfwhHfaABSu+WjZYxi9CXdFCSvXhsgufUcK4FbYAHl/ga/cJxZc52yFC7Pcq0u9O2BSCjYPdQ
        DAHs9dhT1RhwVLM8RmoAzgxyyzau0gxnAlgSBD9FMW6dXqIHIp8yAAg9cRXhYRTNAgMBAAEwDQYJ
        KoZIhvcNAQELBQADggIBADofEC1SvG8qa7pmKCjB/E9Sxhk3mvUO9Gq43xzwVb721Ng3VYf4vGU3
        wLUwJeLt0wggnj26NJweN5T3q9T8UMxZhHSWvttEU3+S1nArRB0beti716HSlOCDx4wTmBu/D1MG
        t/kZYFJw+zuzvAcbYct2pK69AQhD8xAIbQvqADJI7cCK3yRry+aWtppc58P81KYabUlCfFXfhJ9E
        P72ffN4jVHpX3lxxYh7FKAdiKbY2FYzjsc7RdgKI1R3iAAZUCGBTvezNzaetGzTUjjl/g1tcVYij
        ltH9ZOQBPlUMI88lxUxqgRTerpPmAJH00CACx4JFiZrweLM1trZyy06wNDQgLrqHr3EOagBF/O2h
        hfTehNdVr6iq3YhKWBo4/+RL0RCzHMh4u86VbDDnDn4Y6HzLuyIAtBFoikoKM6UHTOa0Pqv2bBr5
        wbkRkVUxl9yJJw/HmTCdfnsM9dTOJUKzEglnGF2184Gg+qJDZB6fSf0EAO1F6sTqiSswl+uHQZiy
        DaZzyU7Gg5seKOZ20zTRaX3Ihj9Zij/ORnrARE7eM/usKMECp+7syUwAUKxDCZkGiUdskmOhhBGL
        JtbyK3F2UvoJoLsm3pIcvMak9KwMjSTGJB47ABUP1+w+zGcNk0D5Co3IJ6QekiLfWJyQ+kKsWLKt
        zOYQQatrnBagM7MI2/T4
        \"\"\",
            attribute_statements=[okta.app.SamlAttributeStatementArgs(
                type="GROUP",
                name="groups",
                filter_type="REGEX",
                filter_value=".*",
            )])
        test_app_signon_policy = okta.get_app_signon_policy_output(app_id=test_saml.id)
        test_user = []
        for range in [{"value": i} for i in range(0, 5)]:
            test_user.append(okta.user.User(f"testUser-{range['value']}",
                first_name="TestAcc",
                last_name="Smith",
                login=f"testAcc_{range['value']}@example.com",
                email=f"testAcc_{range['value']}@example.com"))
        this = []
        for range in [{"value": i} for i in range(0, 5)]:
            this.append(okta.group.Group(f"this-{range['value']}", description=f"testAcc_{range['value']}"))
        test_user_type = okta.user.UserType("testUserType",
            display_name="Terraform Acceptance Test User Type Updated",
            description="Terraform Acceptance Test User Type Updated")
        test_zone = okta.network.Zone("testZone",
            type="IP",
            gateways=[
                "1.2.3.4/24",
                "2.3.4.5-2.3.4.15",
            ],
            proxies=[
                "2.2.3.4/24",
                "3.3.4.5-3.3.4.15",
            ])
        default = okta.user.get_user_type(name="user")
        test_device_assurance_android = okta.policy.DeviceAssuranceAndroid("testDeviceAssuranceAndroid",
            os_version="12",
            jailbreak=False)
        test_app_signon_policy_rule = okta.AppSignonPolicyRule("testAppSignonPolicyRule",
            policy_id=test_app_signon_policy.id,
            access="ALLOW",
            custom_expression="user.status == \\"ACTIVE\\"",
            device_is_managed=False,
            device_is_registered=True,
            factor_mode="2FA",
            groups_excludeds=[
                this[2].id,
                this[3].id,
                this[4].id,
            ],
            groups_includeds=[
                this[0].id,
                this[1].id,
            ],
            device_assurances_includeds=[test_device_assurance_android.id],
            network_connection="ZONE",
            network_includes=[test_zone.id],
            platform_includes=[
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="ANDROID",
                    type="MOBILE",
                ),
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="IOS",
                    type="MOBILE",
                ),
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="MACOS",
                    type="DESKTOP",
                ),
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="OTHER",
                    type="DESKTOP",
                ),
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="OTHER",
                    type="MOBILE",
                ),
                okta.AppSignonPolicyRulePlatformIncludeArgs(
                    os_type="WINDOWS",
                    type="DESKTOP",
                ),
            ],
            priority=98,
            re_authentication_frequency="PT43800H",
            type="ASSURANCE",
            user_types_excludeds=[test_user_type.id],
            user_types_includeds=[default.id],
            users_excludeds=[
                test_user[2].id,
                test_user[3].id,
                test_user[4].id,
            ],
            users_includeds=[
                test_user[0].id,
                test_user[1].id,
            ],
            constraints=[
                json.dumps({
                    "knowledge": {
                        "reauthenticateIn": "PT2H",
                        "types": ["password"],
                    },
                    "possession": {
                        "deviceBound": "REQUIRED",
                    },
                }),
                json.dumps({
                    "possession": {
                        "deviceBound": "REQUIRED",
                        "hardwareProtection": "REQUIRED",
                        "userPresence": "OPTIONAL",
                    },
                }),
            ])
        ```

        ## Import

        Okta app sign-on policy rule can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/appSignonPolicyRule:AppSignonPolicyRule example &#60;policy_id&#62;/&#60;rule_id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param AppSignonPolicyRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSignonPolicyRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_expression: Optional[pulumi.Input[str]] = None,
                 device_assurances_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 device_is_managed: Optional[pulumi.Input[bool]] = None,
                 device_is_registered: Optional[pulumi.Input[bool]] = None,
                 factor_mode: Optional[pulumi.Input[str]] = None,
                 groups_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 inactivity_period: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppSignonPolicyRulePlatformIncludeArgs']]]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 re_authentication_frequency: Optional[pulumi.Input[str]] = None,
                 risk_score: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_types_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_types_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSignonPolicyRuleArgs.__new__(AppSignonPolicyRuleArgs)

            __props__.__dict__["access"] = access
            __props__.__dict__["constraints"] = constraints
            __props__.__dict__["custom_expression"] = custom_expression
            __props__.__dict__["device_assurances_includeds"] = device_assurances_includeds
            __props__.__dict__["device_is_managed"] = device_is_managed
            __props__.__dict__["device_is_registered"] = device_is_registered
            __props__.__dict__["factor_mode"] = factor_mode
            __props__.__dict__["groups_excludeds"] = groups_excludeds
            __props__.__dict__["groups_includeds"] = groups_includeds
            __props__.__dict__["inactivity_period"] = inactivity_period
            __props__.__dict__["name"] = name
            __props__.__dict__["network_connection"] = network_connection
            __props__.__dict__["network_excludes"] = network_excludes
            __props__.__dict__["network_includes"] = network_includes
            __props__.__dict__["platform_includes"] = platform_includes
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["priority"] = priority
            __props__.__dict__["re_authentication_frequency"] = re_authentication_frequency
            __props__.__dict__["risk_score"] = risk_score
            __props__.__dict__["status"] = status
            __props__.__dict__["type"] = type
            __props__.__dict__["user_types_excludeds"] = user_types_excludeds
            __props__.__dict__["user_types_includeds"] = user_types_includeds
            __props__.__dict__["users_excludeds"] = users_excludeds
            __props__.__dict__["users_includeds"] = users_includeds
            __props__.__dict__["system"] = None
        super(AppSignonPolicyRule, __self__).__init__(
            'okta:index/appSignonPolicyRule:AppSignonPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[str]] = None,
            constraints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            custom_expression: Optional[pulumi.Input[str]] = None,
            device_assurances_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            device_is_managed: Optional[pulumi.Input[bool]] = None,
            device_is_registered: Optional[pulumi.Input[bool]] = None,
            factor_mode: Optional[pulumi.Input[str]] = None,
            groups_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            inactivity_period: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_connection: Optional[pulumi.Input[str]] = None,
            network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppSignonPolicyRulePlatformIncludeArgs']]]]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            re_authentication_frequency: Optional[pulumi.Input[str]] = None,
            risk_score: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            system: Optional[pulumi.Input[bool]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_types_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_types_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            users_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AppSignonPolicyRule':
        """
        Get an existing AppSignonPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions. It can be set to `"ALLOW"` or `"DENY"`. Default is `"ALLOW"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] constraints: An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class. Each element should be in JSON format.
        :param pulumi.Input[str] custom_expression: This is an advanced optional setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_assurances_includeds: List of device assurances IDs to be included.
        :param pulumi.Input[bool] device_is_managed: If the device is managed. A device is managed if it's managed by a device management
               system. When managed is passed, `device_is_registered` must also be included and must be set to `true`.
        :param pulumi.Input[bool] device_is_registered: If the device is registered. A device is registered if the User enrolls with Okta
               Verify that is installed on the device. Can only be set to `true`.
        :param pulumi.Input[str] factor_mode: The number of factors required to satisfy this assurance level. It can be set to `"1FA"` or `"2FA"`. Default is `"2FA"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_excludeds: List of groups IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_includeds: List of groups IDs to be included.
        :param pulumi.Input[str] inactivity_period: The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals. Default is `"PT1H"`.
        :param pulumi.Input[str] name: Name of the policy rule.
        :param pulumi.Input[str] network_connection: Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: List of network zones IDs to exclude. Conflicts with `network_includes`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: List of network zones IDs to include. Conflicts with `network_excludes`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppSignonPolicyRulePlatformIncludeArgs']]]] platform_includes: List of particular platforms or devices to match on.
        :param pulumi.Input[str] policy_id: ID of the app sign-on policy.
        :param pulumi.Input[int] priority: Priority of the rule.
        :param pulumi.Input[str] re_authentication_frequency: The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. `"PT0S"` - every sign-in attempt, `"PT43800H"` - once per session. Default is `"PT2H"`.
        :param pulumi.Input[str] risk_score: The risk score specifies a particular level of risk to match on. Valid values are: `"ANY"`, `"LOW"`, `"MEDIUM"`, `"HIGH"`. Default is `"ANY"`.
        :param pulumi.Input[str] status: Status of the rule
        :param pulumi.Input[bool] system: Often the "Catch-all Rule" this rule is the system (default) rule for its associated policy.
        :param pulumi.Input[str] type: The Verification Method type. It can be set to `"ASSURANCE"`. Default is `"ASSURANCE"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_types_excludeds: List of user types IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_types_includeds: List of user types IDs to be included.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: List of users IDs to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_includeds: List of users IDs to be included.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSignonPolicyRuleState.__new__(_AppSignonPolicyRuleState)

        __props__.__dict__["access"] = access
        __props__.__dict__["constraints"] = constraints
        __props__.__dict__["custom_expression"] = custom_expression
        __props__.__dict__["device_assurances_includeds"] = device_assurances_includeds
        __props__.__dict__["device_is_managed"] = device_is_managed
        __props__.__dict__["device_is_registered"] = device_is_registered
        __props__.__dict__["factor_mode"] = factor_mode
        __props__.__dict__["groups_excludeds"] = groups_excludeds
        __props__.__dict__["groups_includeds"] = groups_includeds
        __props__.__dict__["inactivity_period"] = inactivity_period
        __props__.__dict__["name"] = name
        __props__.__dict__["network_connection"] = network_connection
        __props__.__dict__["network_excludes"] = network_excludes
        __props__.__dict__["network_includes"] = network_includes
        __props__.__dict__["platform_includes"] = platform_includes
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["priority"] = priority
        __props__.__dict__["re_authentication_frequency"] = re_authentication_frequency
        __props__.__dict__["risk_score"] = risk_score
        __props__.__dict__["status"] = status
        __props__.__dict__["system"] = system
        __props__.__dict__["type"] = type
        __props__.__dict__["user_types_excludeds"] = user_types_excludeds
        __props__.__dict__["user_types_includeds"] = user_types_includeds
        __props__.__dict__["users_excludeds"] = users_excludeds
        __props__.__dict__["users_includeds"] = users_includeds
        return AppSignonPolicyRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Output[Optional[str]]:
        """
        Allow or deny access based on the rule conditions. It can be set to `"ALLOW"` or `"DENY"`. Default is `"ALLOW"`.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def constraints(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class. Each element should be in JSON format.
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter(name="customExpression")
    def custom_expression(self) -> pulumi.Output[Optional[str]]:
        """
        This is an advanced optional setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        """
        return pulumi.get(self, "custom_expression")

    @property
    @pulumi.getter(name="deviceAssurancesIncludeds")
    def device_assurances_includeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of device assurances IDs to be included.
        """
        return pulumi.get(self, "device_assurances_includeds")

    @property
    @pulumi.getter(name="deviceIsManaged")
    def device_is_managed(self) -> pulumi.Output[Optional[bool]]:
        """
        If the device is managed. A device is managed if it's managed by a device management
        system. When managed is passed, `device_is_registered` must also be included and must be set to `true`.
        """
        return pulumi.get(self, "device_is_managed")

    @property
    @pulumi.getter(name="deviceIsRegistered")
    def device_is_registered(self) -> pulumi.Output[Optional[bool]]:
        """
        If the device is registered. A device is registered if the User enrolls with Okta
        Verify that is installed on the device. Can only be set to `true`.
        """
        return pulumi.get(self, "device_is_registered")

    @property
    @pulumi.getter(name="factorMode")
    def factor_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The number of factors required to satisfy this assurance level. It can be set to `"1FA"` or `"2FA"`. Default is `"2FA"`.
        """
        return pulumi.get(self, "factor_mode")

    @property
    @pulumi.getter(name="groupsExcludeds")
    def groups_excludeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of groups IDs to be excluded.
        """
        return pulumi.get(self, "groups_excludeds")

    @property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of groups IDs to be included.
        """
        return pulumi.get(self, "groups_includeds")

    @property
    @pulumi.getter(name="inactivityPeriod")
    def inactivity_period(self) -> pulumi.Output[Optional[str]]:
        """
        The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals. Default is `"PT1H"`.
        """
        return pulumi.get(self, "inactivity_period")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the policy rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> pulumi.Output[Optional[str]]:
        """
        Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        """
        return pulumi.get(self, "network_connection")

    @property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of network zones IDs to exclude. Conflicts with `network_includes`.
        """
        return pulumi.get(self, "network_excludes")

    @property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of network zones IDs to include. Conflicts with `network_excludes`.
        """
        return pulumi.get(self, "network_includes")

    @property
    @pulumi.getter(name="platformIncludes")
    def platform_includes(self) -> pulumi.Output[Optional[Sequence['outputs.AppSignonPolicyRulePlatformInclude']]]:
        """
        List of particular platforms or devices to match on.
        """
        return pulumi.get(self, "platform_includes")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        ID of the app sign-on policy.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        Priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="reAuthenticationFrequency")
    def re_authentication_frequency(self) -> pulumi.Output[Optional[str]]:
        """
        The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. `"PT0S"` - every sign-in attempt, `"PT43800H"` - once per session. Default is `"PT2H"`.
        """
        return pulumi.get(self, "re_authentication_frequency")

    @property
    @pulumi.getter(name="riskScore")
    def risk_score(self) -> pulumi.Output[str]:
        """
        The risk score specifies a particular level of risk to match on. Valid values are: `"ANY"`, `"LOW"`, `"MEDIUM"`, `"HIGH"`. Default is `"ANY"`.
        """
        return pulumi.get(self, "risk_score")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        Status of the rule
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def system(self) -> pulumi.Output[bool]:
        """
        Often the "Catch-all Rule" this rule is the system (default) rule for its associated policy.
        """
        return pulumi.get(self, "system")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The Verification Method type. It can be set to `"ASSURANCE"`. Default is `"ASSURANCE"`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userTypesExcludeds")
    def user_types_excludeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of user types IDs to be excluded.
        """
        return pulumi.get(self, "user_types_excludeds")

    @property
    @pulumi.getter(name="userTypesIncludeds")
    def user_types_includeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of user types IDs to be included.
        """
        return pulumi.get(self, "user_types_includeds")

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of users IDs to be excluded.
        """
        return pulumi.get(self, "users_excludeds")

    @property
    @pulumi.getter(name="usersIncludeds")
    def users_includeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of users IDs to be included.
        """
        return pulumi.get(self, "users_includeds")

