# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetBehaviourResult',
    'AwaitableGetBehaviourResult',
    'get_behaviour',
    'get_behaviour_output',
]

@pulumi.output_type
class GetBehaviourResult:
    """
    A collection of values returned by getBehaviour.
    """
    def __init__(__self__, id=None, name=None, settings=None, status=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Behavior ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Behavior name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def settings(self) -> Mapping[str, str]:
        """
        Map of behavior settings.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Behavior status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Behavior type.
        """
        return pulumi.get(self, "type")


class AwaitableGetBehaviourResult(GetBehaviourResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBehaviourResult(
            id=self.id,
            name=self.name,
            settings=self.settings,
            status=self.status,
            type=self.type)


def get_behaviour(id: Optional[str] = None,
                  name: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBehaviourResult:
    """
    Use this data source to retrieve a behavior from Okta.


    :param str id: `id` of behavior to retrieve, conflicts with `name`.
    :param str name: The name of the behavior to retrieve. Name uses the `?q=<name>` query parameter exposed by 
           Okta's API.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getBehaviour:getBehaviour', __args__, opts=opts, typ=GetBehaviourResult).value

    return AwaitableGetBehaviourResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        settings=pulumi.get(__ret__, 'settings'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_behaviour)
def get_behaviour_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                         name: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBehaviourResult]:
    """
    Use this data source to retrieve a behavior from Okta.


    :param str id: `id` of behavior to retrieve, conflicts with `name`.
    :param str name: The name of the behavior to retrieve. Name uses the `?q=<name>` query parameter exposed by 
           Okta's API.
    """
    ...
