# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLogStreamResult',
    'AwaitableGetLogStreamResult',
    'get_log_stream',
    'get_log_stream_output',
]

@pulumi.output_type
class GetLogStreamResult:
    """
    A collection of values returned by getLogStream.
    """
    def __init__(__self__, id=None, name=None, settings=None, status=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the log stream.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the log stream.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def settings(self) -> Optional['outputs.GetLogStreamSettingsResult']:
        """
        Provider specific configuration.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Log Stream Status - can either be ACTIVE or INACTIVE only.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the Log Stream.
        """
        return pulumi.get(self, "type")


class AwaitableGetLogStreamResult(GetLogStreamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogStreamResult(
            id=self.id,
            name=self.name,
            settings=self.settings,
            status=self.status,
            type=self.type)


def get_log_stream(id: Optional[str] = None,
                   name: Optional[str] = None,
                   settings: Optional[pulumi.InputType['GetLogStreamSettingsArgs']] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogStreamResult:
    """
    Use this data source to retrieve a log stream from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.Index.get_log_stream(name="Example Stream")
    ```


    :param str id: ID of the log stream to retrieve, conflicts with `name`.
    :param str name: Name of the log stream to retrieve, conflicts with `id`.
    :param pulumi.InputType['GetLogStreamSettingsArgs'] settings: Provider specific configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['settings'] = settings
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:Index/getLogStream:getLogStream', __args__, opts=opts, typ=GetLogStreamResult).value

    return AwaitableGetLogStreamResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        settings=pulumi.get(__ret__, 'settings'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_log_stream)
def get_log_stream_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                          name: Optional[pulumi.Input[Optional[str]]] = None,
                          settings: Optional[pulumi.Input[Optional[pulumi.InputType['GetLogStreamSettingsArgs']]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLogStreamResult]:
    """
    Use this data source to retrieve a log stream from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.Index.get_log_stream(name="Example Stream")
    ```


    :param str id: ID of the log stream to retrieve, conflicts with `name`.
    :param str name: Name of the log stream to retrieve, conflicts with `id`.
    :param pulumi.InputType['GetLogStreamSettingsArgs'] settings: Provider specific configuration.
    """
    ...
