# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, admin_roles=None, city=None, compound_search_operator=None, cost_center=None, country_code=None, custom_profile_attributes=None, delay_read_seconds=None, department=None, display_name=None, division=None, email=None, employee_number=None, first_name=None, group_memberships=None, honorific_prefix=None, honorific_suffix=None, id=None, last_name=None, locale=None, login=None, manager=None, manager_id=None, middle_name=None, mobile_phone=None, nick_name=None, organization=None, postal_address=None, preferred_language=None, primary_phone=None, profile_url=None, roles=None, searches=None, second_email=None, skip_groups=None, skip_roles=None, state=None, status=None, street_address=None, timezone=None, title=None, user_id=None, user_type=None, zip_code=None):
        if admin_roles and not isinstance(admin_roles, list):
            raise TypeError("Expected argument 'admin_roles' to be a list")
        pulumi.set(__self__, "admin_roles", admin_roles)
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if compound_search_operator and not isinstance(compound_search_operator, str):
            raise TypeError("Expected argument 'compound_search_operator' to be a str")
        pulumi.set(__self__, "compound_search_operator", compound_search_operator)
        if cost_center and not isinstance(cost_center, str):
            raise TypeError("Expected argument 'cost_center' to be a str")
        pulumi.set(__self__, "cost_center", cost_center)
        if country_code and not isinstance(country_code, str):
            raise TypeError("Expected argument 'country_code' to be a str")
        pulumi.set(__self__, "country_code", country_code)
        if custom_profile_attributes and not isinstance(custom_profile_attributes, str):
            raise TypeError("Expected argument 'custom_profile_attributes' to be a str")
        pulumi.set(__self__, "custom_profile_attributes", custom_profile_attributes)
        if delay_read_seconds and not isinstance(delay_read_seconds, str):
            raise TypeError("Expected argument 'delay_read_seconds' to be a str")
        pulumi.set(__self__, "delay_read_seconds", delay_read_seconds)
        if department and not isinstance(department, str):
            raise TypeError("Expected argument 'department' to be a str")
        pulumi.set(__self__, "department", department)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if division and not isinstance(division, str):
            raise TypeError("Expected argument 'division' to be a str")
        pulumi.set(__self__, "division", division)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if employee_number and not isinstance(employee_number, str):
            raise TypeError("Expected argument 'employee_number' to be a str")
        pulumi.set(__self__, "employee_number", employee_number)
        if first_name and not isinstance(first_name, str):
            raise TypeError("Expected argument 'first_name' to be a str")
        pulumi.set(__self__, "first_name", first_name)
        if group_memberships and not isinstance(group_memberships, list):
            raise TypeError("Expected argument 'group_memberships' to be a list")
        pulumi.set(__self__, "group_memberships", group_memberships)
        if honorific_prefix and not isinstance(honorific_prefix, str):
            raise TypeError("Expected argument 'honorific_prefix' to be a str")
        pulumi.set(__self__, "honorific_prefix", honorific_prefix)
        if honorific_suffix and not isinstance(honorific_suffix, str):
            raise TypeError("Expected argument 'honorific_suffix' to be a str")
        pulumi.set(__self__, "honorific_suffix", honorific_suffix)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_name and not isinstance(last_name, str):
            raise TypeError("Expected argument 'last_name' to be a str")
        pulumi.set(__self__, "last_name", last_name)
        if locale and not isinstance(locale, str):
            raise TypeError("Expected argument 'locale' to be a str")
        pulumi.set(__self__, "locale", locale)
        if login and not isinstance(login, str):
            raise TypeError("Expected argument 'login' to be a str")
        pulumi.set(__self__, "login", login)
        if manager and not isinstance(manager, str):
            raise TypeError("Expected argument 'manager' to be a str")
        pulumi.set(__self__, "manager", manager)
        if manager_id and not isinstance(manager_id, str):
            raise TypeError("Expected argument 'manager_id' to be a str")
        pulumi.set(__self__, "manager_id", manager_id)
        if middle_name and not isinstance(middle_name, str):
            raise TypeError("Expected argument 'middle_name' to be a str")
        pulumi.set(__self__, "middle_name", middle_name)
        if mobile_phone and not isinstance(mobile_phone, str):
            raise TypeError("Expected argument 'mobile_phone' to be a str")
        pulumi.set(__self__, "mobile_phone", mobile_phone)
        if nick_name and not isinstance(nick_name, str):
            raise TypeError("Expected argument 'nick_name' to be a str")
        pulumi.set(__self__, "nick_name", nick_name)
        if organization and not isinstance(organization, str):
            raise TypeError("Expected argument 'organization' to be a str")
        pulumi.set(__self__, "organization", organization)
        if postal_address and not isinstance(postal_address, str):
            raise TypeError("Expected argument 'postal_address' to be a str")
        pulumi.set(__self__, "postal_address", postal_address)
        if preferred_language and not isinstance(preferred_language, str):
            raise TypeError("Expected argument 'preferred_language' to be a str")
        pulumi.set(__self__, "preferred_language", preferred_language)
        if primary_phone and not isinstance(primary_phone, str):
            raise TypeError("Expected argument 'primary_phone' to be a str")
        pulumi.set(__self__, "primary_phone", primary_phone)
        if profile_url and not isinstance(profile_url, str):
            raise TypeError("Expected argument 'profile_url' to be a str")
        pulumi.set(__self__, "profile_url", profile_url)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if searches and not isinstance(searches, list):
            raise TypeError("Expected argument 'searches' to be a list")
        pulumi.set(__self__, "searches", searches)
        if second_email and not isinstance(second_email, str):
            raise TypeError("Expected argument 'second_email' to be a str")
        pulumi.set(__self__, "second_email", second_email)
        if skip_groups and not isinstance(skip_groups, bool):
            raise TypeError("Expected argument 'skip_groups' to be a bool")
        pulumi.set(__self__, "skip_groups", skip_groups)
        if skip_roles and not isinstance(skip_roles, bool):
            raise TypeError("Expected argument 'skip_roles' to be a bool")
        pulumi.set(__self__, "skip_roles", skip_roles)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if street_address and not isinstance(street_address, str):
            raise TypeError("Expected argument 'street_address' to be a str")
        pulumi.set(__self__, "street_address", street_address)
        if timezone and not isinstance(timezone, str):
            raise TypeError("Expected argument 'timezone' to be a str")
        pulumi.set(__self__, "timezone", timezone)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)
        if user_type and not isinstance(user_type, str):
            raise TypeError("Expected argument 'user_type' to be a str")
        pulumi.set(__self__, "user_type", user_type)
        if zip_code and not isinstance(zip_code, str):
            raise TypeError("Expected argument 'zip_code' to be a str")
        pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="adminRoles")
    def admin_roles(self) -> Sequence[str]:
        return pulumi.get(self, "admin_roles")

    @property
    @pulumi.getter
    def city(self) -> str:
        """
        City or locality component of user's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="compoundSearchOperator")
    def compound_search_operator(self) -> Optional[str]:
        return pulumi.get(self, "compound_search_operator")

    @property
    @pulumi.getter(name="costCenter")
    def cost_center(self) -> str:
        """
        Name of a cost center assigned to user.
        """
        return pulumi.get(self, "cost_center")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        """
        Country name component of user's address.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="customProfileAttributes")
    def custom_profile_attributes(self) -> str:
        """
        Raw JSON containing all custom profile attributes.
        """
        return pulumi.get(self, "custom_profile_attributes")

    @property
    @pulumi.getter(name="delayReadSeconds")
    def delay_read_seconds(self) -> Optional[str]:
        return pulumi.get(self, "delay_read_seconds")

    @property
    @pulumi.getter
    def department(self) -> str:
        """
        Name of user's department.
        """
        return pulumi.get(self, "department")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of the user, suitable for display to end users.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def division(self) -> str:
        """
        Name of user's division.
        """
        return pulumi.get(self, "division")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        Primary email address of user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="employeeNumber")
    def employee_number(self) -> str:
        """
        Organization or company assigned unique identifier for the user.
        """
        return pulumi.get(self, "employee_number")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        Given name of the user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="groupMemberships")
    def group_memberships(self) -> Sequence[str]:
        return pulumi.get(self, "group_memberships")

    @property
    @pulumi.getter(name="honorificPrefix")
    def honorific_prefix(self) -> str:
        """
        Honorific prefix(es) of the user, or title in most Western languages.
        """
        return pulumi.get(self, "honorific_prefix")

    @property
    @pulumi.getter(name="honorificSuffix")
    def honorific_suffix(self) -> str:
        """
        Honorific suffix(es) of the user.
        """
        return pulumi.get(self, "honorific_suffix")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        Family name of the user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def locale(self) -> str:
        """
        User's default location for purposes of localizing items such as currency, date time format, numerical representations, etc.
        """
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter
    def login(self) -> str:
        """
        Unique identifier for the user.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def manager(self) -> str:
        """
        Display name of the user's manager.
        """
        return pulumi.get(self, "manager")

    @property
    @pulumi.getter(name="managerId")
    def manager_id(self) -> str:
        """
        `id` of a user's manager.
        """
        return pulumi.get(self, "manager_id")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> str:
        """
        Middle name(s) of the user.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> str:
        """
        Mobile phone number of user.
        """
        return pulumi.get(self, "mobile_phone")

    @property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> str:
        """
        Casual way to address the user in real life.
        """
        return pulumi.get(self, "nick_name")

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        Name of user's organization.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="postalAddress")
    def postal_address(self) -> str:
        """
        Mailing address component of user's address.
        """
        return pulumi.get(self, "postal_address")

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> str:
        """
        User's preferred written or spoken languages.
        """
        return pulumi.get(self, "preferred_language")

    @property
    @pulumi.getter(name="primaryPhone")
    def primary_phone(self) -> str:
        """
        Primary phone number of user such as home number.
        """
        return pulumi.get(self, "primary_phone")

    @property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> str:
        """
        URL of user's online profile (e.g. a web page).
        """
        return pulumi.get(self, "profile_url")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        """
        All roles assigned to user.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def searches(self) -> Optional[Sequence['outputs.GetUserSearchResult']]:
        return pulumi.get(self, "searches")

    @property
    @pulumi.getter(name="secondEmail")
    def second_email(self) -> str:
        """
        Secondary email address of user typically used for account recovery.
        """
        return pulumi.get(self, "second_email")

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> Optional[bool]:
        return pulumi.get(self, "skip_groups")

    @property
    @pulumi.getter(name="skipRoles")
    def skip_roles(self) -> Optional[bool]:
        return pulumi.get(self, "skip_roles")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State or region component of user's address (region).
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of user.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> str:
        """
        Full street address component of user's address.
        """
        return pulumi.get(self, "street_address")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        User's time zone.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        User's title, such as "Vice President".
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[str]:
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> str:
        """
        Used to describe the organization to user relationship such as "Employee" or "Contractor".
        """
        return pulumi.get(self, "user_type")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> str:
        """
        Zipcode or postal code component of user's address (postalCode)
        """
        return pulumi.get(self, "zip_code")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            admin_roles=self.admin_roles,
            city=self.city,
            compound_search_operator=self.compound_search_operator,
            cost_center=self.cost_center,
            country_code=self.country_code,
            custom_profile_attributes=self.custom_profile_attributes,
            delay_read_seconds=self.delay_read_seconds,
            department=self.department,
            display_name=self.display_name,
            division=self.division,
            email=self.email,
            employee_number=self.employee_number,
            first_name=self.first_name,
            group_memberships=self.group_memberships,
            honorific_prefix=self.honorific_prefix,
            honorific_suffix=self.honorific_suffix,
            id=self.id,
            last_name=self.last_name,
            locale=self.locale,
            login=self.login,
            manager=self.manager,
            manager_id=self.manager_id,
            middle_name=self.middle_name,
            mobile_phone=self.mobile_phone,
            nick_name=self.nick_name,
            organization=self.organization,
            postal_address=self.postal_address,
            preferred_language=self.preferred_language,
            primary_phone=self.primary_phone,
            profile_url=self.profile_url,
            roles=self.roles,
            searches=self.searches,
            second_email=self.second_email,
            skip_groups=self.skip_groups,
            skip_roles=self.skip_roles,
            state=self.state,
            status=self.status,
            street_address=self.street_address,
            timezone=self.timezone,
            title=self.title,
            user_id=self.user_id,
            user_type=self.user_type,
            zip_code=self.zip_code)


def get_user(compound_search_operator: Optional[str] = None,
             delay_read_seconds: Optional[str] = None,
             searches: Optional[Sequence[pulumi.InputType['GetUserSearchArgs']]] = None,
             skip_groups: Optional[bool] = None,
             skip_roles: Optional[bool] = None,
             user_id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Use this data source to retrieve a users from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.user.get_user(searches=[okta.user.GetUserSearchArgs(
        expression="profile.firstName eq \\"John\\"",
    )])
    ```


    :param str compound_search_operator: Given multiple search elements they will be compounded together with the op. Default is `and`, `or` is also valid.
    :param str delay_read_seconds: Force delay of the user read by N seconds. Useful when eventual consistency of user information needs to be allowed for.
    :param Sequence[pulumi.InputType['GetUserSearchArgs']] searches: Map of search criteria. It supports the following properties.
    :param str user_id: String representing a specific user's id value
    """
    __args__ = dict()
    __args__['compoundSearchOperator'] = compound_search_operator
    __args__['delayReadSeconds'] = delay_read_seconds
    __args__['searches'] = searches
    __args__['skipGroups'] = skip_groups
    __args__['skipRoles'] = skip_roles
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:user/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        admin_roles=pulumi.get(__ret__, 'admin_roles'),
        city=pulumi.get(__ret__, 'city'),
        compound_search_operator=pulumi.get(__ret__, 'compound_search_operator'),
        cost_center=pulumi.get(__ret__, 'cost_center'),
        country_code=pulumi.get(__ret__, 'country_code'),
        custom_profile_attributes=pulumi.get(__ret__, 'custom_profile_attributes'),
        delay_read_seconds=pulumi.get(__ret__, 'delay_read_seconds'),
        department=pulumi.get(__ret__, 'department'),
        display_name=pulumi.get(__ret__, 'display_name'),
        division=pulumi.get(__ret__, 'division'),
        email=pulumi.get(__ret__, 'email'),
        employee_number=pulumi.get(__ret__, 'employee_number'),
        first_name=pulumi.get(__ret__, 'first_name'),
        group_memberships=pulumi.get(__ret__, 'group_memberships'),
        honorific_prefix=pulumi.get(__ret__, 'honorific_prefix'),
        honorific_suffix=pulumi.get(__ret__, 'honorific_suffix'),
        id=pulumi.get(__ret__, 'id'),
        last_name=pulumi.get(__ret__, 'last_name'),
        locale=pulumi.get(__ret__, 'locale'),
        login=pulumi.get(__ret__, 'login'),
        manager=pulumi.get(__ret__, 'manager'),
        manager_id=pulumi.get(__ret__, 'manager_id'),
        middle_name=pulumi.get(__ret__, 'middle_name'),
        mobile_phone=pulumi.get(__ret__, 'mobile_phone'),
        nick_name=pulumi.get(__ret__, 'nick_name'),
        organization=pulumi.get(__ret__, 'organization'),
        postal_address=pulumi.get(__ret__, 'postal_address'),
        preferred_language=pulumi.get(__ret__, 'preferred_language'),
        primary_phone=pulumi.get(__ret__, 'primary_phone'),
        profile_url=pulumi.get(__ret__, 'profile_url'),
        roles=pulumi.get(__ret__, 'roles'),
        searches=pulumi.get(__ret__, 'searches'),
        second_email=pulumi.get(__ret__, 'second_email'),
        skip_groups=pulumi.get(__ret__, 'skip_groups'),
        skip_roles=pulumi.get(__ret__, 'skip_roles'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        street_address=pulumi.get(__ret__, 'street_address'),
        timezone=pulumi.get(__ret__, 'timezone'),
        title=pulumi.get(__ret__, 'title'),
        user_id=pulumi.get(__ret__, 'user_id'),
        user_type=pulumi.get(__ret__, 'user_type'),
        zip_code=pulumi.get(__ret__, 'zip_code'))


@_utilities.lift_output_func(get_user)
def get_user_output(compound_search_operator: Optional[pulumi.Input[Optional[str]]] = None,
                    delay_read_seconds: Optional[pulumi.Input[Optional[str]]] = None,
                    searches: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetUserSearchArgs']]]]] = None,
                    skip_groups: Optional[pulumi.Input[Optional[bool]]] = None,
                    skip_roles: Optional[pulumi.Input[Optional[bool]]] = None,
                    user_id: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    Use this data source to retrieve a users from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.user.get_user(searches=[okta.user.GetUserSearchArgs(
        expression="profile.firstName eq \\"John\\"",
    )])
    ```


    :param str compound_search_operator: Given multiple search elements they will be compounded together with the op. Default is `and`, `or` is also valid.
    :param str delay_read_seconds: Force delay of the user read by N seconds. Useful when eventual consistency of user information needs to be allowed for.
    :param Sequence[pulumi.InputType['GetUserSearchArgs']] searches: Map of search criteria. It supports the following properties.
    :param str user_id: String representing a specific user's id value
    """
    ...
