from sapiopylib.rest.pojo.datatype.FieldDefinition import FieldType
from sapiopylib.rest.utils.recordmodel.RecordModelWrapper import WrappedRecordModel, WrapperField
from sapiopylib.rest.pojo.DateRange import DateRange
from typing import Optional, Final


class ABI2700ResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ABI2700Result
    Data Type Display Name: ABI2700 Result (ABI2700 Results)
    Fields: CtSD, CreatedBy, Well, DateCreated, Ct, OtherSampleId, Detector, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, SampleId
    """
    DATA_TYPE_NAME: Final[str] = 'ABI2700Result'
    DISPLAY_NAME: Final[str] = "ABI2700 Result"
    PLURAL_DISPLAY_NAME: Final[str] = "ABI2700 Results"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    CT__FIELD_NAME: Final[WrapperField] = WrapperField("Ct", FieldType.DOUBLE, display_name="Ct")
    CTSD__FIELD_NAME: Final[WrapperField] = WrapperField("CtSD", FieldType.DOUBLE, display_name="Ct SD")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DETECTOR__FIELD_NAME: Final[WrapperField] = WrapperField("Detector", FieldType.STRING, display_name="Detector")
    OTHERSAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("OtherSampleId", FieldType.STRING, display_name="Sample Name")
    SAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("SampleId", FieldType.STRING, display_name="Sample ID")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    WELL__FIELD_NAME: Final[WrapperField] = WrapperField("Well", FieldType.STRING, display_name="Well")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_Ct_field(self, value: Optional[float]):
        """
        Set data field with field name 'Ct' on this record model
        """
        self.set_field_value(self.CT__FIELD_NAME.field_name, value)

    def get_Ct_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Ct' from this record model
        """
        return self.get_field_value(self.CT__FIELD_NAME.field_name)

    def set_CtSD_field(self, value: Optional[float]):
        """
        Set data field with field name 'CtSD' on this record model
        """
        self.set_field_value(self.CTSD__FIELD_NAME.field_name, value)

    def get_CtSD_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CtSD' from this record model
        """
        return self.get_field_value(self.CTSD__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Detector_field(self, value: Optional[str]):
        """
        Set data field with field name 'Detector' on this record model
        """
        self.set_field_value(self.DETECTOR__FIELD_NAME.field_name, value)

    def get_Detector_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Detector' from this record model
        """
        return self.get_field_value(self.DETECTOR__FIELD_NAME.field_name)

    def set_OtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'OtherSampleId' on this record model
        """
        self.set_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_OtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OtherSampleId' from this record model
        """
        return self.get_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Well_field(self, value: Optional[str]):
        """
        Set data field with field name 'Well' on this record model
        """
        self.set_field_value(self.WELL__FIELD_NAME.field_name, value)

    def get_Well_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Well' from this record model
        """
        return self.get_field_value(self.WELL__FIELD_NAME.field_name)


class AccessionConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AccessionConfig
    Data Type Display Name: Accession Configuration (Accession Configurations)
    Fields: CreatedBy, DataTypeField, CustomPluginClassPath, DateCreated, PrefixField, AccessionOnCreate, DataFieldName, DataRecordName, NumberOfDigits, VeloxLastModifiedDate, VeloxLastModifiedBy, StartNumber, SuffixField, IsGlobal
    Accession configuration can be used to modify default accessioning behaviors for out-of-box plugins from Sapio Sciences. Convenient methods can be found in AccessioningWithConfigManager class to accession according to the configuration. All Sapio plugins who accession samples should use this util for accessioning.
    """
    DATA_TYPE_NAME: Final[str] = 'AccessionConfig'
    DISPLAY_NAME: Final[str] = "Accession Configuration"
    PLURAL_DISPLAY_NAME: Final[str] = "Accession Configurations"
    ACCESSIONONCREATE__FIELD_NAME: Final[WrapperField] = WrapperField("AccessionOnCreate", FieldType.BOOLEAN, display_name="Accession On Create?")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    CUSTOMPLUGINCLASSPATH__FIELD_NAME: Final[WrapperField] = WrapperField("CustomPluginClassPath", FieldType.STRING, display_name="Custom Plugin Class Path")
    DATAFIELDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataFieldName", FieldType.SELECTION, display_name="Data Field")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATATYPEFIELD__FIELD_NAME: Final[WrapperField] = WrapperField("DataTypeField", FieldType.SELECTION, display_name="Data Type")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    ISGLOBAL__FIELD_NAME: Final[WrapperField] = WrapperField("IsGlobal", FieldType.BOOLEAN, display_name="Is Global?")
    NUMBEROFDIGITS__FIELD_NAME: Final[WrapperField] = WrapperField("NumberOfDigits", FieldType.INTEGER, display_name="Number Of Digits")
    PREFIXFIELD__FIELD_NAME: Final[WrapperField] = WrapperField("PrefixField", FieldType.STRING, display_name="Prefix Field")
    STARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("StartNumber", FieldType.INTEGER, display_name="Start Number")
    SUFFIXFIELD__FIELD_NAME: Final[WrapperField] = WrapperField("SuffixField", FieldType.STRING, display_name="Suffix Field")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AccessionOnCreate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AccessionOnCreate' on this record model
        """
        self.set_field_value(self.ACCESSIONONCREATE__FIELD_NAME.field_name, value)

    def get_AccessionOnCreate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AccessionOnCreate' from this record model
        """
        return self.get_field_value(self.ACCESSIONONCREATE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CustomPluginClassPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'CustomPluginClassPath' on this record model
        """
        self.set_field_value(self.CUSTOMPLUGINCLASSPATH__FIELD_NAME.field_name, value)

    def get_CustomPluginClassPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CustomPluginClassPath' from this record model
        """
        return self.get_field_value(self.CUSTOMPLUGINCLASSPATH__FIELD_NAME.field_name)

    def set_DataFieldName_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataFieldName' on this record model
        """
        self.set_field_value(self.DATAFIELDNAME__FIELD_NAME.field_name, value)

    def get_DataFieldName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataFieldName' from this record model
        """
        return self.get_field_value(self.DATAFIELDNAME__FIELD_NAME.field_name)

    def set_DataTypeField_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataTypeField' on this record model
        """
        self.set_field_value(self.DATATYPEFIELD__FIELD_NAME.field_name, value)

    def get_DataTypeField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataTypeField' from this record model
        """
        return self.get_field_value(self.DATATYPEFIELD__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_IsGlobal_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGlobal' on this record model
        """
        self.set_field_value(self.ISGLOBAL__FIELD_NAME.field_name, value)

    def get_IsGlobal_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGlobal' from this record model
        """
        return self.get_field_value(self.ISGLOBAL__FIELD_NAME.field_name)

    def set_NumberOfDigits_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumberOfDigits' on this record model
        """
        self.set_field_value(self.NUMBEROFDIGITS__FIELD_NAME.field_name, value)

    def get_NumberOfDigits_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumberOfDigits' from this record model
        """
        return self.get_field_value(self.NUMBEROFDIGITS__FIELD_NAME.field_name)

    def set_PrefixField_field(self, value: Optional[str]):
        """
        Set data field with field name 'PrefixField' on this record model
        """
        self.set_field_value(self.PREFIXFIELD__FIELD_NAME.field_name, value)

    def get_PrefixField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PrefixField' from this record model
        """
        return self.get_field_value(self.PREFIXFIELD__FIELD_NAME.field_name)

    def set_StartNumber_field(self, value: Optional[int]):
        """
        Set data field with field name 'StartNumber' on this record model
        """
        self.set_field_value(self.STARTNUMBER__FIELD_NAME.field_name, value)

    def get_StartNumber_field(self) -> Optional[int]:
        """
        Get data field value with field name 'StartNumber' from this record model
        """
        return self.get_field_value(self.STARTNUMBER__FIELD_NAME.field_name)

    def set_SuffixField_field(self, value: Optional[str]):
        """
        Set data field with field name 'SuffixField' on this record model
        """
        self.set_field_value(self.SUFFIXFIELD__FIELD_NAME.field_name, value)

    def get_SuffixField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SuffixField' from this record model
        """
        return self.get_field_value(self.SUFFIXFIELD__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AgentModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Agent
    Data Type Display Name: Agent (Agents)
    Fields: AgentType, CreatedBy, DataRecordName, MultiParentLink649, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, AgentName
    """
    DATA_TYPE_NAME: Final[str] = 'Agent'
    DISPLAY_NAME: Final[str] = "Agent"
    PLURAL_DISPLAY_NAME: Final[str] = "Agents"
    AGENTNAME__FIELD_NAME: Final[WrapperField] = WrapperField("AgentName", FieldType.SELECTION, display_name="Agent Name")
    AGENTTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("AgentType", FieldType.SELECTION, display_name="Agent Type")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    MULTIPARENTLINK649__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink649", FieldType.MULTIPARENTLINK, display_name="Linked Treatment")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AgentName_field(self, value: Optional[str]):
        """
        Set data field with field name 'AgentName' on this record model
        """
        self.set_field_value(self.AGENTNAME__FIELD_NAME.field_name, value)

    def get_AgentName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AgentName' from this record model
        """
        return self.get_field_value(self.AGENTNAME__FIELD_NAME.field_name)

    def set_AgentType_field(self, value: Optional[str]):
        """
        Set data field with field name 'AgentType' on this record model
        """
        self.set_field_value(self.AGENTTYPE__FIELD_NAME.field_name, value)

    def get_AgentType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AgentType' from this record model
        """
        return self.get_field_value(self.AGENTTYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AnalysisStatusModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AnalysisStatus
    Data Type Display Name: Analysis Status (Analysis Statuses)
    Fields: Status, Script, CreatedBy, DataRecordName, Invocation, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated
    """
    DATA_TYPE_NAME: Final[str] = 'AnalysisStatus'
    DISPLAY_NAME: Final[str] = "Analysis Status"
    PLURAL_DISPLAY_NAME: Final[str] = "Analysis Statuses"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    INVOCATION__FIELD_NAME: Final[WrapperField] = WrapperField("Invocation", FieldType.PICKLIST, display_name="Invocation")
    SCRIPT__FIELD_NAME: Final[WrapperField] = WrapperField("Script", FieldType.STRING, display_name="Script")
    STATUS__FIELD_NAME: Final[WrapperField] = WrapperField("Status", FieldType.PICKLIST, display_name="Status")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Invocation_field(self, value: Optional[str]):
        """
        Set data field with field name 'Invocation' on this record model
        """
        self.set_field_value(self.INVOCATION__FIELD_NAME.field_name, value)

    def get_Invocation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Invocation' from this record model
        """
        return self.get_field_value(self.INVOCATION__FIELD_NAME.field_name)

    def set_Script_field(self, value: Optional[str]):
        """
        Set data field with field name 'Script' on this record model
        """
        self.set_field_value(self.SCRIPT__FIELD_NAME.field_name, value)

    def get_Script_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Script' from this record model
        """
        return self.get_field_value(self.SCRIPT__FIELD_NAME.field_name)

    def set_Status_field(self, value: Optional[str]):
        """
        Set data field with field name 'Status' on this record model
        """
        self.set_field_value(self.STATUS__FIELD_NAME.field_name, value)

    def get_Status_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Status' from this record model
        """
        return self.get_field_value(self.STATUS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AnalyticsWizardChartDataModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AnalyticsWizardChartData
    Data Type Display Name: Analytics Wizard Chart Datum (Analytics Wizard Chart Data)
    Fields: FilePath, CreatedBy, VeloxCurrentVersion, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated
    Holds a single chart data for a jarvis analytic run result. A run result can have more than one chart.
    """
    DATA_TYPE_NAME: Final[str] = 'AnalyticsWizardChartData'
    DISPLAY_NAME: Final[str] = "Analytics Wizard Chart Datum"
    PLURAL_DISPLAY_NAME: Final[str] = "Analytics Wizard Chart Data"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AnalyticsWizardRunModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AnalyticsWizardRun
    Data Type Display Name: Analytics Wizard Run (Analytics Wizard Runs)
    Fields: FilePath, OperatorName, VeloxCurrentVersion, CreatedBy, ParametersJSON, DateCreated, Name, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, RunId
    Stored a single run of particular run settings within a top level result of data frame.
    """
    DATA_TYPE_NAME: Final[str] = 'AnalyticsWizardRun'
    DISPLAY_NAME: Final[str] = "Analytics Wizard Run"
    PLURAL_DISPLAY_NAME: Final[str] = "Analytics Wizard Runs"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    NAME__FIELD_NAME: Final[WrapperField] = WrapperField("Name", FieldType.STRING, display_name="Name")
    OPERATORNAME__FIELD_NAME: Final[WrapperField] = WrapperField("OperatorName", FieldType.STRING, display_name="Operator Name")
    PARAMETERSJSON__FIELD_NAME: Final[WrapperField] = WrapperField("ParametersJSON", FieldType.STRING, display_name="Parameters JSON")
    RUNID__FIELD_NAME: Final[WrapperField] = WrapperField("RunId", FieldType.INTEGER, display_name="Run ID")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_OperatorName_field(self, value: Optional[str]):
        """
        Set data field with field name 'OperatorName' on this record model
        """
        self.set_field_value(self.OPERATORNAME__FIELD_NAME.field_name, value)

    def get_OperatorName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OperatorName' from this record model
        """
        return self.get_field_value(self.OPERATORNAME__FIELD_NAME.field_name)

    def set_ParametersJSON_field(self, value: Optional[str]):
        """
        Set data field with field name 'ParametersJSON' on this record model
        """
        self.set_field_value(self.PARAMETERSJSON__FIELD_NAME.field_name, value)

    def get_ParametersJSON_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ParametersJSON' from this record model
        """
        return self.get_field_value(self.PARAMETERSJSON__FIELD_NAME.field_name)

    def set_RunId_field(self, value: Optional[int]):
        """
        Set data field with field name 'RunId' on this record model
        """
        self.set_field_value(self.RUNID__FIELD_NAME.field_name, value)

    def get_RunId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RunId' from this record model
        """
        return self.get_field_value(self.RUNID__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AnalyticsWizardSavedSettingModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AnalyticsWizardSavedSetting
    Data Type Display Name: Analytics Wizard Saved Setting (Analytics Wizard Saved Settings)
    Fields: OpName, CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, SettingsContent, SettingsName
    Saves the settings for Jarvis Analytic data and parameter mappings.

Saving is only allowed if the exact settings has not been repeated.
    """
    DATA_TYPE_NAME: Final[str] = 'AnalyticsWizardSavedSetting'
    DISPLAY_NAME: Final[str] = "Analytics Wizard Saved Setting"
    PLURAL_DISPLAY_NAME: Final[str] = "Analytics Wizard Saved Settings"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    OPNAME__FIELD_NAME: Final[WrapperField] = WrapperField("OpName", FieldType.STRING, display_name="Operator Name")
    SETTINGSCONTENT__FIELD_NAME: Final[WrapperField] = WrapperField("SettingsContent", FieldType.STRING, display_name="Settings Content")
    SETTINGSNAME__FIELD_NAME: Final[WrapperField] = WrapperField("SettingsName", FieldType.STRING, display_name="Settings Name")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_OpName_field(self, value: Optional[str]):
        """
        Set data field with field name 'OpName' on this record model
        """
        self.set_field_value(self.OPNAME__FIELD_NAME.field_name, value)

    def get_OpName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OpName' from this record model
        """
        return self.get_field_value(self.OPNAME__FIELD_NAME.field_name)

    def set_SettingsContent_field(self, value: Optional[str]):
        """
        Set data field with field name 'SettingsContent' on this record model
        """
        self.set_field_value(self.SETTINGSCONTENT__FIELD_NAME.field_name, value)

    def get_SettingsContent_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SettingsContent' from this record model
        """
        return self.get_field_value(self.SETTINGSCONTENT__FIELD_NAME.field_name)

    def set_SettingsName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SettingsName' on this record model
        """
        self.set_field_value(self.SETTINGSNAME__FIELD_NAME.field_name, value)

    def get_SettingsName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SettingsName' from this record model
        """
        return self.get_field_value(self.SETTINGSNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AnalyticsWizardTopLevelResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AnalyticsWizardTopLevelResult
    Data Type Display Name: Analytics Wizard Top Level Result (Analytics Wizard Top Level Results)
    Fields: FilePath, VeloxCurrentVersion, CreatedBy, CspFieldDefinitionJson, DateCreated, Name, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy
    Stores the top level results of a single jarvis analytics saved run.
    """
    DATA_TYPE_NAME: Final[str] = 'AnalyticsWizardTopLevelResult'
    DISPLAY_NAME: Final[str] = "Analytics Wizard Top Level Result"
    PLURAL_DISPLAY_NAME: Final[str] = "Analytics Wizard Top Level Results"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    CSPFIELDDEFINITIONJSON__FIELD_NAME: Final[WrapperField] = WrapperField("CspFieldDefinitionJson", FieldType.STRING, display_name="Field Definition Data")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    NAME__FIELD_NAME: Final[WrapperField] = WrapperField("Name", FieldType.STRING, display_name="Name")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CspFieldDefinitionJson_field(self, value: Optional[str]):
        """
        Set data field with field name 'CspFieldDefinitionJson' on this record model
        """
        self.set_field_value(self.CSPFIELDDEFINITIONJSON__FIELD_NAME.field_name, value)

    def get_CspFieldDefinitionJson_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CspFieldDefinitionJson' from this record model
        """
        return self.get_field_value(self.CSPFIELDDEFINITIONJSON__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AntibodyModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Antibody
    Data Type Display Name: Antibody (Antibodies)
    Fields: CreatedBy, PartNumber, ConsumableType, DateCreated, Vendor, DataRecordName, ExpirationDate, VeloxLastModifiedDate, VeloxLastModifiedBy, RegistryId, ConsumableName, LotNumber, HELM
    """
    DATA_TYPE_NAME: Final[str] = 'Antibody'
    DISPLAY_NAME: Final[str] = "Antibody"
    PLURAL_DISPLAY_NAME: Final[str] = "Antibodies"
    CONSUMABLENAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableName", FieldType.STRING, display_name="Antibody Name")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Antibody Subtype")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EXPIRATIONDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ExpirationDate", FieldType.DATE, display_name="Expiration Date")
    HELM__FIELD_NAME: Final[WrapperField] = WrapperField("HELM", FieldType.STRING, display_name="HELM")
    LOTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("LotNumber", FieldType.STRING, display_name="Lot Number")
    PARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("PartNumber", FieldType.STRING, display_name="Part Number")
    REGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryId", FieldType.STRING, display_name="Registry ID")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VENDOR__FIELD_NAME: Final[WrapperField] = WrapperField("Vendor", FieldType.SELECTION, display_name="Vendor")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_HELM_field(self, value: Optional[str]):
        """
        Set data field with field name 'HELM' on this record model
        """
        self.set_field_value(self.HELM__FIELD_NAME.field_name, value)

    def get_HELM_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HELM' from this record model
        """
        return self.get_field_value(self.HELM__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class AntibodyPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AntibodyPart
    Data Type Display Name: Antibody Part (Antibody Parts)
    Fields: CreatedBy, ConsumableType, DateCreated, Vendor, QuantityOnHand, Units, QuantityPerItem, MultiParentLink201, ReorderLevelQuantity, ChemicalProperties, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, RegistryId, ConsumableName, HELMHash, HELM
    """
    DATA_TYPE_NAME: Final[str] = 'AntibodyPart'
    DISPLAY_NAME: Final[str] = "Antibody Part"
    PLURAL_DISPLAY_NAME: Final[str] = "Antibody Parts"
    CHEMICALPROPERTIES__FIELD_NAME: Final[WrapperField] = WrapperField("ChemicalProperties", FieldType.SIDE_LINK, display_name="Chemical Properties")
    CONSUMABLENAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableName", FieldType.STRING, display_name="Name")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.PICKLIST, display_name="Type")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    HELM__FIELD_NAME: Final[WrapperField] = WrapperField("HELM", FieldType.STRING, display_name="HELM")
    HELMHASH__FIELD_NAME: Final[WrapperField] = WrapperField("HELMHash", FieldType.STRING, display_name="HELM Hash")
    MULTIPARENTLINK201__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink201", FieldType.MULTIPARENTLINK, display_name="Linked ProteinParts")
    QUANTITYONHAND__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityOnHand", FieldType.DOUBLE, display_name="Quantity / Volume On Hand")
    QUANTITYPERITEM__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityPerItem", FieldType.DOUBLE, display_name="Quantity / Volume Per Item")
    REGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryId", FieldType.STRING, display_name="Registry ID")
    REORDERLEVELQUANTITY__FIELD_NAME: Final[WrapperField] = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE, display_name="Reorder Level Quantity")
    UNITS__FIELD_NAME: Final[WrapperField] = WrapperField("Units", FieldType.PICKLIST, display_name="Units")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VENDOR__FIELD_NAME: Final[WrapperField] = WrapperField("Vendor", FieldType.SELECTION, display_name="Vendor")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ChemicalProperties_field(self, value: Optional[int]):
        """
        Set data field with field name 'ChemicalProperties' on this record model
        """
        self.set_field_value(self.CHEMICALPROPERTIES__FIELD_NAME.field_name, value)

    def get_ChemicalProperties_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ChemicalProperties' from this record model
        """
        return self.get_field_value(self.CHEMICALPROPERTIES__FIELD_NAME.field_name)

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_HELM_field(self, value: Optional[str]):
        """
        Set data field with field name 'HELM' on this record model
        """
        self.set_field_value(self.HELM__FIELD_NAME.field_name, value)

    def get_HELM_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HELM' from this record model
        """
        return self.get_field_value(self.HELM__FIELD_NAME.field_name)

    def set_HELMHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'HELMHash' on this record model
        """
        self.set_field_value(self.HELMHASH__FIELD_NAME.field_name, value)

    def get_HELMHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HELMHash' from this record model
        """
        return self.get_field_value(self.HELMHASH__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class AssignedProcessModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AssignedProcess
    Data Type Display Name: Assigned Process (Assigned Processes)
    Fields: ProcessName, SampleRecordId, TurnAroundHours, SourceAssignedProcessIds, DateCreated, ScheduledDate, OtherSampleId, DoNotProceed, VeloxLastModifiedBy, RequestRecordId, SampleId, Status, ProcessTAT, CreatedBy, BranchLongId, TurnAroundMinutes, ProcessStepNumber, HasBeenReprocessed, Reprocessing, CompletedDate, DataRecordName, PauseTracking, VeloxLastModifiedDate, AwaitingRequestApproval
    """
    DATA_TYPE_NAME: Final[str] = 'AssignedProcess'
    DISPLAY_NAME: Final[str] = "Assigned Process"
    PLURAL_DISPLAY_NAME: Final[str] = "Assigned Processes"
    AWAITINGREQUESTAPPROVAL__FIELD_NAME: Final[WrapperField] = WrapperField("AwaitingRequestApproval", FieldType.BOOLEAN, display_name="Awaiting Request Approval")
    BRANCHLONGID__FIELD_NAME: Final[WrapperField] = WrapperField("BranchLongId", FieldType.LONG, display_name="Branch ID")
    COMPLETEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("CompletedDate", FieldType.DATE, display_name="Completed Date")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DONOTPROCEED__FIELD_NAME: Final[WrapperField] = WrapperField("DoNotProceed", FieldType.BOOLEAN, display_name="Do Not Proceed")
    HASBEENREPROCESSED__FIELD_NAME: Final[WrapperField] = WrapperField("HasBeenReprocessed", FieldType.BOOLEAN, display_name="Has Been Reprocessed")
    OTHERSAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("OtherSampleId", FieldType.STRING, display_name="Sample Name")
    PAUSETRACKING__FIELD_NAME: Final[WrapperField] = WrapperField("PauseTracking", FieldType.BOOLEAN, display_name="Pause Tracking")
    PROCESSNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ProcessName", FieldType.SELECTION, display_name="Process Name")
    PROCESSSTEPNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("ProcessStepNumber", FieldType.LONG, display_name="Process Step Number")
    PROCESSTAT__FIELD_NAME: Final[WrapperField] = WrapperField("ProcessTAT", FieldType.DOUBLE, display_name="Turn Around Time")
    REPROCESSING__FIELD_NAME: Final[WrapperField] = WrapperField("Reprocessing", FieldType.BOOLEAN, display_name="Awaiting Reprocessing")
    REQUESTRECORDID__FIELD_NAME: Final[WrapperField] = WrapperField("RequestRecordId", FieldType.LONG, display_name="Request Record ID")
    SAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("SampleId", FieldType.STRING, display_name="Sample ID")
    SAMPLERECORDID__FIELD_NAME: Final[WrapperField] = WrapperField("SampleRecordId", FieldType.LONG, display_name="Sample Record ID")
    SCHEDULEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ScheduledDate", FieldType.DATE, display_name="Scheduled Date")
    SOURCEASSIGNEDPROCESSIDS__FIELD_NAME: Final[WrapperField] = WrapperField("SourceAssignedProcessIds", FieldType.STRING, display_name="Source Assigned Process Record IDs")
    STATUS__FIELD_NAME: Final[WrapperField] = WrapperField("Status", FieldType.SELECTION, display_name="Status")
    TURNAROUNDHOURS__FIELD_NAME: Final[WrapperField] = WrapperField("TurnAroundHours", FieldType.LONG, display_name="Turn Around Hours")
    TURNAROUNDMINUTES__FIELD_NAME: Final[WrapperField] = WrapperField("TurnAroundMinutes", FieldType.LONG, display_name="Turn Around Minutes")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AwaitingRequestApproval_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AwaitingRequestApproval' on this record model
        """
        self.set_field_value(self.AWAITINGREQUESTAPPROVAL__FIELD_NAME.field_name, value)

    def get_AwaitingRequestApproval_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AwaitingRequestApproval' from this record model
        """
        return self.get_field_value(self.AWAITINGREQUESTAPPROVAL__FIELD_NAME.field_name)

    def set_BranchLongId_field(self, value: Optional[int]):
        """
        Set data field with field name 'BranchLongId' on this record model
        """
        self.set_field_value(self.BRANCHLONGID__FIELD_NAME.field_name, value)

    def get_BranchLongId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'BranchLongId' from this record model
        """
        return self.get_field_value(self.BRANCHLONGID__FIELD_NAME.field_name)

    def set_CompletedDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'CompletedDate' on this record model
        """
        self.set_field_value(self.COMPLETEDDATE__FIELD_NAME.field_name, value)

    def get_CompletedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'CompletedDate' from this record model
        """
        return self.get_field_value(self.COMPLETEDDATE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DoNotProceed_field(self, value: Optional[bool]):
        """
        Set data field with field name 'DoNotProceed' on this record model
        """
        self.set_field_value(self.DONOTPROCEED__FIELD_NAME.field_name, value)

    def get_DoNotProceed_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'DoNotProceed' from this record model
        """
        return self.get_field_value(self.DONOTPROCEED__FIELD_NAME.field_name)

    def set_HasBeenReprocessed_field(self, value: Optional[bool]):
        """
        Set data field with field name 'HasBeenReprocessed' on this record model
        """
        self.set_field_value(self.HASBEENREPROCESSED__FIELD_NAME.field_name, value)

    def get_HasBeenReprocessed_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'HasBeenReprocessed' from this record model
        """
        return self.get_field_value(self.HASBEENREPROCESSED__FIELD_NAME.field_name)

    def set_OtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'OtherSampleId' on this record model
        """
        self.set_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_OtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OtherSampleId' from this record model
        """
        return self.get_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name)

    def set_PauseTracking_field(self, value: Optional[bool]):
        """
        Set data field with field name 'PauseTracking' on this record model
        """
        self.set_field_value(self.PAUSETRACKING__FIELD_NAME.field_name, value)

    def get_PauseTracking_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'PauseTracking' from this record model
        """
        return self.get_field_value(self.PAUSETRACKING__FIELD_NAME.field_name)

    def set_ProcessName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ProcessName' on this record model
        """
        self.set_field_value(self.PROCESSNAME__FIELD_NAME.field_name, value)

    def get_ProcessName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ProcessName' from this record model
        """
        return self.get_field_value(self.PROCESSNAME__FIELD_NAME.field_name)

    def set_ProcessStepNumber_field(self, value: Optional[int]):
        """
        Set data field with field name 'ProcessStepNumber' on this record model
        """
        self.set_field_value(self.PROCESSSTEPNUMBER__FIELD_NAME.field_name, value)

    def get_ProcessStepNumber_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ProcessStepNumber' from this record model
        """
        return self.get_field_value(self.PROCESSSTEPNUMBER__FIELD_NAME.field_name)

    def set_ProcessTAT_field(self, value: Optional[float]):
        """
        Set data field with field name 'ProcessTAT' on this record model
        """
        self.set_field_value(self.PROCESSTAT__FIELD_NAME.field_name, value)

    def get_ProcessTAT_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ProcessTAT' from this record model
        """
        return self.get_field_value(self.PROCESSTAT__FIELD_NAME.field_name)

    def set_Reprocessing_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Reprocessing' on this record model
        """
        self.set_field_value(self.REPROCESSING__FIELD_NAME.field_name, value)

    def get_Reprocessing_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Reprocessing' from this record model
        """
        return self.get_field_value(self.REPROCESSING__FIELD_NAME.field_name)

    def set_RequestRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'RequestRecordId' on this record model
        """
        self.set_field_value(self.REQUESTRECORDID__FIELD_NAME.field_name, value)

    def get_RequestRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RequestRecordId' from this record model
        """
        return self.get_field_value(self.REQUESTRECORDID__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def set_SampleRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'SampleRecordId' on this record model
        """
        self.set_field_value(self.SAMPLERECORDID__FIELD_NAME.field_name, value)

    def get_SampleRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SampleRecordId' from this record model
        """
        return self.get_field_value(self.SAMPLERECORDID__FIELD_NAME.field_name)

    def set_ScheduledDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ScheduledDate' on this record model
        """
        self.set_field_value(self.SCHEDULEDDATE__FIELD_NAME.field_name, value)

    def get_ScheduledDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ScheduledDate' from this record model
        """
        return self.get_field_value(self.SCHEDULEDDATE__FIELD_NAME.field_name)

    def set_SourceAssignedProcessIds_field(self, value: Optional[str]):
        """
        Set data field with field name 'SourceAssignedProcessIds' on this record model
        """
        self.set_field_value(self.SOURCEASSIGNEDPROCESSIDS__FIELD_NAME.field_name, value)

    def get_SourceAssignedProcessIds_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SourceAssignedProcessIds' from this record model
        """
        return self.get_field_value(self.SOURCEASSIGNEDPROCESSIDS__FIELD_NAME.field_name)

    def set_Status_field(self, value: Optional[str]):
        """
        Set data field with field name 'Status' on this record model
        """
        self.set_field_value(self.STATUS__FIELD_NAME.field_name, value)

    def get_Status_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Status' from this record model
        """
        return self.get_field_value(self.STATUS__FIELD_NAME.field_name)

    def set_TurnAroundHours_field(self, value: Optional[int]):
        """
        Set data field with field name 'TurnAroundHours' on this record model
        """
        self.set_field_value(self.TURNAROUNDHOURS__FIELD_NAME.field_name, value)

    def get_TurnAroundHours_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TurnAroundHours' from this record model
        """
        return self.get_field_value(self.TURNAROUNDHOURS__FIELD_NAME.field_name)

    def set_TurnAroundMinutes_field(self, value: Optional[int]):
        """
        Set data field with field name 'TurnAroundMinutes' on this record model
        """
        self.set_field_value(self.TURNAROUNDMINUTES__FIELD_NAME.field_name, value)

    def get_TurnAroundMinutes_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TurnAroundMinutes' from this record model
        """
        return self.get_field_value(self.TURNAROUNDMINUTES__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AttachmentModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Attachment
    Data Type Display Name: Attachment (Attachments)
    Fields: IsGeneratedByReportBuilder, MultiParentLink230, CreatedBy, MultiParentLink308, V_VersionNumber, DataRecordName, Volume, MultiParentLink215, Description, TestBoolean, DateCreated, MultiParentLink175, MultiParentLink179, VeloxLastModifiedBy, V_Comments, FilePath, VeloxCurrentVersion, Comments, VersionNumber, AttachmentId, V_AttachmentId, VeloxLastModifiedDate
    Data type for document attachments
    """
    DATA_TYPE_NAME: Final[str] = 'Attachment'
    DISPLAY_NAME: Final[str] = "Attachment"
    PLURAL_DISPLAY_NAME: Final[str] = "Attachments"
    ATTACHMENTID__FIELD_NAME: Final[WrapperField] = WrapperField("AttachmentId", FieldType.STRING, display_name="Attachment ID")
    COMMENTS__FIELD_NAME: Final[WrapperField] = WrapperField("Comments", FieldType.STRING, display_name="Comments")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DESCRIPTION__FIELD_NAME: Final[WrapperField] = WrapperField("Description", FieldType.STRING, display_name="Description")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    ISGENERATEDBYREPORTBUILDER__FIELD_NAME: Final[WrapperField] = WrapperField("IsGeneratedByReportBuilder", FieldType.BOOLEAN, display_name="Is Generated By Report Builder")
    MULTIPARENTLINK175__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink175", FieldType.MULTIPARENTLINK, display_name="Linked Project")
    MULTIPARENTLINK179__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink179", FieldType.MULTIPARENTLINK, display_name="Related InstrumentMaintenanceReceipts")
    MULTIPARENTLINK215__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK, display_name="Linked Sample")
    MULTIPARENTLINK230__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink230", FieldType.MULTIPARENTLINK, display_name="Linked Study")
    MULTIPARENTLINK308__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink308", FieldType.MULTIPARENTLINK, display_name="Linked Instrument")
    TESTBOOLEAN__FIELD_NAME: Final[WrapperField] = WrapperField("TestBoolean", FieldType.BOOLEAN, display_name="Are experimental procedures for the exact target compound available?")
    V_ATTACHMENTID__FIELD_NAME: Final[WrapperField] = WrapperField("V_AttachmentId", FieldType.STRING, display_name="Attachment ID")
    V_COMMENTS__FIELD_NAME: Final[WrapperField] = WrapperField("V_Comments", FieldType.STRING, display_name="Comments")
    V_VERSIONNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("V_VersionNumber", FieldType.STRING, display_name="Version Number")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VERSIONNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("VersionNumber", FieldType.STRING, display_name="Version Number")
    VOLUME__FIELD_NAME: Final[WrapperField] = WrapperField("Volume", FieldType.INTEGER, display_name="Volume")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AttachmentId_field(self, value: Optional[str]):
        """
        Set data field with field name 'AttachmentId' on this record model
        """
        self.set_field_value(self.ATTACHMENTID__FIELD_NAME.field_name, value)

    def get_AttachmentId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AttachmentId' from this record model
        """
        return self.get_field_value(self.ATTACHMENTID__FIELD_NAME.field_name)

    def set_Comments_field(self, value: Optional[str]):
        """
        Set data field with field name 'Comments' on this record model
        """
        self.set_field_value(self.COMMENTS__FIELD_NAME.field_name, value)

    def get_Comments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Comments' from this record model
        """
        return self.get_field_value(self.COMMENTS__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Description_field(self, value: Optional[str]):
        """
        Set data field with field name 'Description' on this record model
        """
        self.set_field_value(self.DESCRIPTION__FIELD_NAME.field_name, value)

    def get_Description_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Description' from this record model
        """
        return self.get_field_value(self.DESCRIPTION__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_IsGeneratedByReportBuilder_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGeneratedByReportBuilder' on this record model
        """
        self.set_field_value(self.ISGENERATEDBYREPORTBUILDER__FIELD_NAME.field_name, value)

    def get_IsGeneratedByReportBuilder_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGeneratedByReportBuilder' from this record model
        """
        return self.get_field_value(self.ISGENERATEDBYREPORTBUILDER__FIELD_NAME.field_name)

    def set_TestBoolean_field(self, value: Optional[bool]):
        """
        Set data field with field name 'TestBoolean' on this record model
        """
        self.set_field_value(self.TESTBOOLEAN__FIELD_NAME.field_name, value)

    def get_TestBoolean_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'TestBoolean' from this record model
        """
        return self.get_field_value(self.TESTBOOLEAN__FIELD_NAME.field_name)

    def set_V_AttachmentId_field(self, value: Optional[str]):
        """
        Set data field with field name 'V_AttachmentId' on this record model
        """
        self.set_field_value(self.V_ATTACHMENTID__FIELD_NAME.field_name, value)

    def get_V_AttachmentId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'V_AttachmentId' from this record model
        """
        return self.get_field_value(self.V_ATTACHMENTID__FIELD_NAME.field_name)

    def set_V_Comments_field(self, value: Optional[str]):
        """
        Set data field with field name 'V_Comments' on this record model
        """
        self.set_field_value(self.V_COMMENTS__FIELD_NAME.field_name, value)

    def get_V_Comments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'V_Comments' from this record model
        """
        return self.get_field_value(self.V_COMMENTS__FIELD_NAME.field_name)

    def set_V_VersionNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'V_VersionNumber' on this record model
        """
        self.set_field_value(self.V_VERSIONNUMBER__FIELD_NAME.field_name, value)

    def get_V_VersionNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'V_VersionNumber' from this record model
        """
        return self.get_field_value(self.V_VERSIONNUMBER__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_VersionNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'VersionNumber' on this record model
        """
        self.set_field_value(self.VERSIONNUMBER__FIELD_NAME.field_name, value)

    def get_VersionNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VersionNumber' from this record model
        """
        return self.get_field_value(self.VERSIONNUMBER__FIELD_NAME.field_name)

    def set_Volume_field(self, value: Optional[int]):
        """
        Set data field with field name 'Volume' on this record model
        """
        self.set_field_value(self.VOLUME__FIELD_NAME.field_name, value)

    def get_Volume_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Volume' from this record model
        """
        return self.get_field_value(self.VOLUME__FIELD_NAME.field_name)


class AW_ANOVASummaryTableModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AW_ANOVASummaryTable
    Data Type Display Name: ANOVA Summary (ANOVA Summary)
    Fields: GroupName, CreatedBy, Statement, CritF, DateCreated, PrGreaterThanF, DegreeOfFreedom, DataRecordName, FValue, VeloxLastModifiedDate, VeloxLastModifiedBy
    """
    DATA_TYPE_NAME: Final[str] = 'AW_ANOVASummaryTable'
    DISPLAY_NAME: Final[str] = "ANOVA Summary"
    PLURAL_DISPLAY_NAME: Final[str] = "ANOVA Summary"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    CRITF__FIELD_NAME: Final[WrapperField] = WrapperField("CritF", FieldType.DOUBLE, display_name="Critical F")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DEGREEOFFREEDOM__FIELD_NAME: Final[WrapperField] = WrapperField("DegreeOfFreedom", FieldType.DOUBLE, display_name="Degree of Freedom")
    FVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("FValue", FieldType.DOUBLE, display_name="F Value")
    GROUPNAME__FIELD_NAME: Final[WrapperField] = WrapperField("GroupName", FieldType.STRING, display_name="Group")
    PRGREATERTHANF__FIELD_NAME: Final[WrapperField] = WrapperField("PrGreaterThanF", FieldType.DOUBLE, display_name="Null Hypothesis Likelihood")
    STATEMENT__FIELD_NAME: Final[WrapperField] = WrapperField("Statement", FieldType.STRING, display_name="Conclusion")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CritF_field(self, value: Optional[float]):
        """
        Set data field with field name 'CritF' on this record model
        """
        self.set_field_value(self.CRITF__FIELD_NAME.field_name, value)

    def get_CritF_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CritF' from this record model
        """
        return self.get_field_value(self.CRITF__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DegreeOfFreedom_field(self, value: Optional[float]):
        """
        Set data field with field name 'DegreeOfFreedom' on this record model
        """
        self.set_field_value(self.DEGREEOFFREEDOM__FIELD_NAME.field_name, value)

    def get_DegreeOfFreedom_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DegreeOfFreedom' from this record model
        """
        return self.get_field_value(self.DEGREEOFFREEDOM__FIELD_NAME.field_name)

    def set_FValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'FValue' on this record model
        """
        self.set_field_value(self.FVALUE__FIELD_NAME.field_name, value)

    def get_FValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'FValue' from this record model
        """
        return self.get_field_value(self.FVALUE__FIELD_NAME.field_name)

    def set_GroupName_field(self, value: Optional[str]):
        """
        Set data field with field name 'GroupName' on this record model
        """
        self.set_field_value(self.GROUPNAME__FIELD_NAME.field_name, value)

    def get_GroupName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GroupName' from this record model
        """
        return self.get_field_value(self.GROUPNAME__FIELD_NAME.field_name)

    def set_PrGreaterThanF_field(self, value: Optional[float]):
        """
        Set data field with field name 'PrGreaterThanF' on this record model
        """
        self.set_field_value(self.PRGREATERTHANF__FIELD_NAME.field_name, value)

    def get_PrGreaterThanF_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PrGreaterThanF' from this record model
        """
        return self.get_field_value(self.PRGREATERTHANF__FIELD_NAME.field_name)

    def set_Statement_field(self, value: Optional[str]):
        """
        Set data field with field name 'Statement' on this record model
        """
        self.set_field_value(self.STATEMENT__FIELD_NAME.field_name, value)

    def get_Statement_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Statement' from this record model
        """
        return self.get_field_value(self.STATEMENT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AW_CoefficientsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AW_Coefficients
    Data Type Display Name: Coefficients (Coefficients)
    Fields: Estimate, CreatedBy, DateCreated, PValue, StdErr, DataRecordName, SeriesName, VeloxLastModifiedDate, VeloxLastModifiedBy, TValue, SummaryName
    """
    DATA_TYPE_NAME: Final[str] = 'AW_Coefficients'
    DISPLAY_NAME: Final[str] = "Coefficients"
    PLURAL_DISPLAY_NAME: Final[str] = "Coefficients"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    ESTIMATE__FIELD_NAME: Final[WrapperField] = WrapperField("Estimate", FieldType.DOUBLE, display_name="Estimate")
    PVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("PValue", FieldType.DOUBLE, display_name="P-Value")
    SERIESNAME__FIELD_NAME: Final[WrapperField] = WrapperField("SeriesName", FieldType.STRING, display_name="Series Name")
    STDERR__FIELD_NAME: Final[WrapperField] = WrapperField("StdErr", FieldType.DOUBLE, display_name="Standard Error")
    SUMMARYNAME__FIELD_NAME: Final[WrapperField] = WrapperField("SummaryName", FieldType.STRING, display_name="Name")
    TVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("TValue", FieldType.DOUBLE, display_name="T-Value")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Estimate_field(self, value: Optional[float]):
        """
        Set data field with field name 'Estimate' on this record model
        """
        self.set_field_value(self.ESTIMATE__FIELD_NAME.field_name, value)

    def get_Estimate_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Estimate' from this record model
        """
        return self.get_field_value(self.ESTIMATE__FIELD_NAME.field_name)

    def set_PValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'PValue' on this record model
        """
        self.set_field_value(self.PVALUE__FIELD_NAME.field_name, value)

    def get_PValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PValue' from this record model
        """
        return self.get_field_value(self.PVALUE__FIELD_NAME.field_name)

    def set_SeriesName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SeriesName' on this record model
        """
        self.set_field_value(self.SERIESNAME__FIELD_NAME.field_name, value)

    def get_SeriesName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SeriesName' from this record model
        """
        return self.get_field_value(self.SERIESNAME__FIELD_NAME.field_name)

    def set_StdErr_field(self, value: Optional[float]):
        """
        Set data field with field name 'StdErr' on this record model
        """
        self.set_field_value(self.STDERR__FIELD_NAME.field_name, value)

    def get_StdErr_field(self) -> Optional[float]:
        """
        Get data field value with field name 'StdErr' from this record model
        """
        return self.get_field_value(self.STDERR__FIELD_NAME.field_name)

    def set_SummaryName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SummaryName' on this record model
        """
        self.set_field_value(self.SUMMARYNAME__FIELD_NAME.field_name, value)

    def get_SummaryName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SummaryName' from this record model
        """
        return self.get_field_value(self.SUMMARYNAME__FIELD_NAME.field_name)

    def set_TValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'TValue' on this record model
        """
        self.set_field_value(self.TVALUE__FIELD_NAME.field_name, value)

    def get_TValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TValue' from this record model
        """
        return self.get_field_value(self.TVALUE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AW_EDValueModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AW_EDValue
    Data Type Display Name: ED-Value (ED-Values)
    Fields: EDValue, CreatedBy, DataRecordName, SeriesName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, SummaryName, EDStdErr
    """
    DATA_TYPE_NAME: Final[str] = 'AW_EDValue'
    DISPLAY_NAME: Final[str] = "ED-Value"
    PLURAL_DISPLAY_NAME: Final[str] = "ED-Values"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EDSTDERR__FIELD_NAME: Final[WrapperField] = WrapperField("EDStdErr", FieldType.DOUBLE, display_name="Error")
    EDVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("EDValue", FieldType.DOUBLE, display_name="ED Value")
    SERIESNAME__FIELD_NAME: Final[WrapperField] = WrapperField("SeriesName", FieldType.STRING, display_name="Series Name")
    SUMMARYNAME__FIELD_NAME: Final[WrapperField] = WrapperField("SummaryName", FieldType.STRING, display_name="Name")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EDStdErr_field(self, value: Optional[float]):
        """
        Set data field with field name 'EDStdErr' on this record model
        """
        self.set_field_value(self.EDSTDERR__FIELD_NAME.field_name, value)

    def get_EDStdErr_field(self) -> Optional[float]:
        """
        Get data field value with field name 'EDStdErr' from this record model
        """
        return self.get_field_value(self.EDSTDERR__FIELD_NAME.field_name)

    def set_EDValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'EDValue' on this record model
        """
        self.set_field_value(self.EDVALUE__FIELD_NAME.field_name, value)

    def get_EDValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'EDValue' from this record model
        """
        return self.get_field_value(self.EDVALUE__FIELD_NAME.field_name)

    def set_SeriesName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SeriesName' on this record model
        """
        self.set_field_value(self.SERIESNAME__FIELD_NAME.field_name, value)

    def get_SeriesName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SeriesName' from this record model
        """
        return self.get_field_value(self.SERIESNAME__FIELD_NAME.field_name)

    def set_SummaryName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SummaryName' on this record model
        """
        self.set_field_value(self.SUMMARYNAME__FIELD_NAME.field_name, value)

    def get_SummaryName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SummaryName' from this record model
        """
        return self.get_field_value(self.SUMMARYNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AW_GenericSummaryTableModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AW_GenericSummaryTable
    Data Type Display Name: Summary (Summary)
    Fields: CreatedBy, DataRecordName, SummaryValue, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, SummaryName
    """
    DATA_TYPE_NAME: Final[str] = 'AW_GenericSummaryTable'
    DISPLAY_NAME: Final[str] = "Summary"
    PLURAL_DISPLAY_NAME: Final[str] = "Summary"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    SUMMARYNAME__FIELD_NAME: Final[WrapperField] = WrapperField("SummaryName", FieldType.STRING, display_name="Name")
    SUMMARYVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("SummaryValue", FieldType.STRING, display_name="Value")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_SummaryName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SummaryName' on this record model
        """
        self.set_field_value(self.SUMMARYNAME__FIELD_NAME.field_name, value)

    def get_SummaryName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SummaryName' from this record model
        """
        return self.get_field_value(self.SUMMARYNAME__FIELD_NAME.field_name)

    def set_SummaryValue_field(self, value: Optional[str]):
        """
        Set data field with field name 'SummaryValue' on this record model
        """
        self.set_field_value(self.SUMMARYVALUE__FIELD_NAME.field_name, value)

    def get_SummaryValue_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SummaryValue' from this record model
        """
        return self.get_field_value(self.SUMMARYVALUE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class AW_ProphetPredictionDFModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AW_ProphetPredictionDF
    Data Type Display Name: Prophet Prediction Frame (Prophet Prediction Frames)
    Fields: multiplicative_terms_upper, additive_terms, trend, trend_upper, DateCreated, additive_terms_lower, weekly, ds, yhat_upper, weekly_upper, daily_lower, trend_lower, VeloxLastModifiedBy, CreatedBy, multiplicative_terms_lower, additive_terms_upper, yhat_lower, multiplicative_terms, daily_upper, DataRecordName, weekly_lower, daily, VeloxLastModifiedDate, yhat
    """
    DATA_TYPE_NAME: Final[str] = 'AW_ProphetPredictionDF'
    DISPLAY_NAME: Final[str] = "Prophet Prediction Frame"
    PLURAL_DISPLAY_NAME: Final[str] = "Prophet Prediction Frames"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    ADDITIVE_TERMS__FIELD_NAME: Final[WrapperField] = WrapperField("additive_terms", FieldType.DOUBLE, display_name="Additive Terms")
    ADDITIVE_TERMS_LOWER__FIELD_NAME: Final[WrapperField] = WrapperField("additive_terms_lower", FieldType.DOUBLE, display_name="Additive Terms Lower Bound")
    ADDITIVE_TERMS_UPPER__FIELD_NAME: Final[WrapperField] = WrapperField("additive_terms_upper", FieldType.DOUBLE, display_name="Additive Terms Upper Bound")
    DAILY__FIELD_NAME: Final[WrapperField] = WrapperField("daily", FieldType.DOUBLE, display_name="Daily")
    DAILY_LOWER__FIELD_NAME: Final[WrapperField] = WrapperField("daily_lower", FieldType.DOUBLE, display_name="Daily Lower Bound")
    DAILY_UPPER__FIELD_NAME: Final[WrapperField] = WrapperField("daily_upper", FieldType.DOUBLE, display_name="Daily Upper Bound")
    DS__FIELD_NAME: Final[WrapperField] = WrapperField("ds", FieldType.STRING, display_name="Date/Time")
    MULTIPLICATIVE_TERMS__FIELD_NAME: Final[WrapperField] = WrapperField("multiplicative_terms", FieldType.DOUBLE, display_name="Multiplicative Terms")
    MULTIPLICATIVE_TERMS_LOWER__FIELD_NAME: Final[WrapperField] = WrapperField("multiplicative_terms_lower", FieldType.DOUBLE, display_name="Multiplicative Terms Lower Bound")
    MULTIPLICATIVE_TERMS_UPPER__FIELD_NAME: Final[WrapperField] = WrapperField("multiplicative_terms_upper", FieldType.DOUBLE, display_name="Multiplicative Terms Upper Bound")
    TREND__FIELD_NAME: Final[WrapperField] = WrapperField("trend", FieldType.DOUBLE, display_name="trend")
    TREND_LOWER__FIELD_NAME: Final[WrapperField] = WrapperField("trend_lower", FieldType.DOUBLE, display_name="Trend Lower Bound")
    TREND_UPPER__FIELD_NAME: Final[WrapperField] = WrapperField("trend_upper", FieldType.DOUBLE, display_name="Trend Upper Bound")
    WEEKLY__FIELD_NAME: Final[WrapperField] = WrapperField("weekly", FieldType.DOUBLE, display_name="Weekly")
    WEEKLY_LOWER__FIELD_NAME: Final[WrapperField] = WrapperField("weekly_lower", FieldType.DOUBLE, display_name="Weekly Lower Bound")
    WEEKLY_UPPER__FIELD_NAME: Final[WrapperField] = WrapperField("weekly_upper", FieldType.DOUBLE, display_name="Weekly Upper Bound")
    YHAT__FIELD_NAME: Final[WrapperField] = WrapperField("yhat", FieldType.DOUBLE, display_name="Y^")
    YHAT_LOWER__FIELD_NAME: Final[WrapperField] = WrapperField("yhat_lower", FieldType.DOUBLE, display_name="y^_lower")
    YHAT_UPPER__FIELD_NAME: Final[WrapperField] = WrapperField("yhat_upper", FieldType.DOUBLE, display_name="y^_upper")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_additive_terms_field(self, value: Optional[float]):
        """
        Set data field with field name 'additive_terms' on this record model
        """
        self.set_field_value(self.ADDITIVE_TERMS__FIELD_NAME.field_name, value)

    def get_additive_terms_field(self) -> Optional[float]:
        """
        Get data field value with field name 'additive_terms' from this record model
        """
        return self.get_field_value(self.ADDITIVE_TERMS__FIELD_NAME.field_name)

    def set_additive_terms_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'additive_terms_lower' on this record model
        """
        self.set_field_value(self.ADDITIVE_TERMS_LOWER__FIELD_NAME.field_name, value)

    def get_additive_terms_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'additive_terms_lower' from this record model
        """
        return self.get_field_value(self.ADDITIVE_TERMS_LOWER__FIELD_NAME.field_name)

    def set_additive_terms_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'additive_terms_upper' on this record model
        """
        self.set_field_value(self.ADDITIVE_TERMS_UPPER__FIELD_NAME.field_name, value)

    def get_additive_terms_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'additive_terms_upper' from this record model
        """
        return self.get_field_value(self.ADDITIVE_TERMS_UPPER__FIELD_NAME.field_name)

    def set_daily_field(self, value: Optional[float]):
        """
        Set data field with field name 'daily' on this record model
        """
        self.set_field_value(self.DAILY__FIELD_NAME.field_name, value)

    def get_daily_field(self) -> Optional[float]:
        """
        Get data field value with field name 'daily' from this record model
        """
        return self.get_field_value(self.DAILY__FIELD_NAME.field_name)

    def set_daily_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'daily_lower' on this record model
        """
        self.set_field_value(self.DAILY_LOWER__FIELD_NAME.field_name, value)

    def get_daily_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'daily_lower' from this record model
        """
        return self.get_field_value(self.DAILY_LOWER__FIELD_NAME.field_name)

    def set_daily_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'daily_upper' on this record model
        """
        self.set_field_value(self.DAILY_UPPER__FIELD_NAME.field_name, value)

    def get_daily_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'daily_upper' from this record model
        """
        return self.get_field_value(self.DAILY_UPPER__FIELD_NAME.field_name)

    def set_ds_field(self, value: Optional[str]):
        """
        Set data field with field name 'ds' on this record model
        """
        self.set_field_value(self.DS__FIELD_NAME.field_name, value)

    def get_ds_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ds' from this record model
        """
        return self.get_field_value(self.DS__FIELD_NAME.field_name)

    def set_multiplicative_terms_field(self, value: Optional[float]):
        """
        Set data field with field name 'multiplicative_terms' on this record model
        """
        self.set_field_value(self.MULTIPLICATIVE_TERMS__FIELD_NAME.field_name, value)

    def get_multiplicative_terms_field(self) -> Optional[float]:
        """
        Get data field value with field name 'multiplicative_terms' from this record model
        """
        return self.get_field_value(self.MULTIPLICATIVE_TERMS__FIELD_NAME.field_name)

    def set_multiplicative_terms_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'multiplicative_terms_lower' on this record model
        """
        self.set_field_value(self.MULTIPLICATIVE_TERMS_LOWER__FIELD_NAME.field_name, value)

    def get_multiplicative_terms_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'multiplicative_terms_lower' from this record model
        """
        return self.get_field_value(self.MULTIPLICATIVE_TERMS_LOWER__FIELD_NAME.field_name)

    def set_multiplicative_terms_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'multiplicative_terms_upper' on this record model
        """
        self.set_field_value(self.MULTIPLICATIVE_TERMS_UPPER__FIELD_NAME.field_name, value)

    def get_multiplicative_terms_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'multiplicative_terms_upper' from this record model
        """
        return self.get_field_value(self.MULTIPLICATIVE_TERMS_UPPER__FIELD_NAME.field_name)

    def set_trend_field(self, value: Optional[float]):
        """
        Set data field with field name 'trend' on this record model
        """
        self.set_field_value(self.TREND__FIELD_NAME.field_name, value)

    def get_trend_field(self) -> Optional[float]:
        """
        Get data field value with field name 'trend' from this record model
        """
        return self.get_field_value(self.TREND__FIELD_NAME.field_name)

    def set_trend_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'trend_lower' on this record model
        """
        self.set_field_value(self.TREND_LOWER__FIELD_NAME.field_name, value)

    def get_trend_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'trend_lower' from this record model
        """
        return self.get_field_value(self.TREND_LOWER__FIELD_NAME.field_name)

    def set_trend_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'trend_upper' on this record model
        """
        self.set_field_value(self.TREND_UPPER__FIELD_NAME.field_name, value)

    def get_trend_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'trend_upper' from this record model
        """
        return self.get_field_value(self.TREND_UPPER__FIELD_NAME.field_name)

    def set_weekly_field(self, value: Optional[float]):
        """
        Set data field with field name 'weekly' on this record model
        """
        self.set_field_value(self.WEEKLY__FIELD_NAME.field_name, value)

    def get_weekly_field(self) -> Optional[float]:
        """
        Get data field value with field name 'weekly' from this record model
        """
        return self.get_field_value(self.WEEKLY__FIELD_NAME.field_name)

    def set_weekly_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'weekly_lower' on this record model
        """
        self.set_field_value(self.WEEKLY_LOWER__FIELD_NAME.field_name, value)

    def get_weekly_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'weekly_lower' from this record model
        """
        return self.get_field_value(self.WEEKLY_LOWER__FIELD_NAME.field_name)

    def set_weekly_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'weekly_upper' on this record model
        """
        self.set_field_value(self.WEEKLY_UPPER__FIELD_NAME.field_name, value)

    def get_weekly_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'weekly_upper' from this record model
        """
        return self.get_field_value(self.WEEKLY_UPPER__FIELD_NAME.field_name)

    def set_yhat_field(self, value: Optional[float]):
        """
        Set data field with field name 'yhat' on this record model
        """
        self.set_field_value(self.YHAT__FIELD_NAME.field_name, value)

    def get_yhat_field(self) -> Optional[float]:
        """
        Get data field value with field name 'yhat' from this record model
        """
        return self.get_field_value(self.YHAT__FIELD_NAME.field_name)

    def set_yhat_lower_field(self, value: Optional[float]):
        """
        Set data field with field name 'yhat_lower' on this record model
        """
        self.set_field_value(self.YHAT_LOWER__FIELD_NAME.field_name, value)

    def get_yhat_lower_field(self) -> Optional[float]:
        """
        Get data field value with field name 'yhat_lower' from this record model
        """
        return self.get_field_value(self.YHAT_LOWER__FIELD_NAME.field_name)

    def set_yhat_upper_field(self, value: Optional[float]):
        """
        Set data field with field name 'yhat_upper' on this record model
        """
        self.set_field_value(self.YHAT_UPPER__FIELD_NAME.field_name, value)

    def get_yhat_upper_field(self) -> Optional[float]:
        """
        Get data field value with field name 'yhat_upper' from this record model
        """
        return self.get_field_value(self.YHAT_UPPER__FIELD_NAME.field_name)


class AWSSageMakerClientConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type AWSSageMakerClientConfig
    Data Type Display Name: AWS SageMaker Client Configuration (AWS SageMaker Client Configurations)
    Fields: SecretKey, CreatedBy, DataRecordName, AccessKeyId, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, Region
    """
    DATA_TYPE_NAME: Final[str] = 'AWSSageMakerClientConfig'
    DISPLAY_NAME: Final[str] = "AWS SageMaker Client Configuration"
    PLURAL_DISPLAY_NAME: Final[str] = "AWS SageMaker Client Configurations"
    ACCESSKEYID__FIELD_NAME: Final[WrapperField] = WrapperField("AccessKeyId", FieldType.STRING, display_name="Access Key ID")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    REGION__FIELD_NAME: Final[WrapperField] = WrapperField("Region", FieldType.STRING, display_name="Region")
    SECRETKEY__FIELD_NAME: Final[WrapperField] = WrapperField("SecretKey", FieldType.STRING, display_name="Secret Key")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AccessKeyId_field(self, value: Optional[str]):
        """
        Set data field with field name 'AccessKeyId' on this record model
        """
        self.set_field_value(self.ACCESSKEYID__FIELD_NAME.field_name, value)

    def get_AccessKeyId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AccessKeyId' from this record model
        """
        return self.get_field_value(self.ACCESSKEYID__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Region_field(self, value: Optional[str]):
        """
        Set data field with field name 'Region' on this record model
        """
        self.set_field_value(self.REGION__FIELD_NAME.field_name, value)

    def get_Region_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Region' from this record model
        """
        return self.get_field_value(self.REGION__FIELD_NAME.field_name)

    def set_SecretKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'SecretKey' on this record model
        """
        self.set_field_value(self.SECRETKEY__FIELD_NAME.field_name, value)

    def get_SecretKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SecretKey' from this record model
        """
        return self.get_field_value(self.SECRETKEY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BarcodeConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BarcodeConfig
    Data Type Display Name: Barcode Configuration (Barcode Configurations)
    Fields: DefaultPrinter, CreatedBy, CustomPluginClassPath, DateCreated, Field4, Field5, Field2, Field3, Field8, DataRecordName, Field9, BarcodeConfigName, Field6, Field7, VeloxLastModifiedDate, VeloxLastModifiedBy, DataType, Field10, Field1
    The Barcode Configurations Data Type
    """
    DATA_TYPE_NAME: Final[str] = 'BarcodeConfig'
    DISPLAY_NAME: Final[str] = "Barcode Configuration"
    PLURAL_DISPLAY_NAME: Final[str] = "Barcode Configurations"
    BARCODECONFIGNAME__FIELD_NAME: Final[WrapperField] = WrapperField("BarcodeConfigName", FieldType.STRING, display_name="Barcode Config Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    CUSTOMPLUGINCLASSPATH__FIELD_NAME: Final[WrapperField] = WrapperField("CustomPluginClassPath", FieldType.STRING, display_name="Custom Plugin Path")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATATYPE__FIELD_NAME: Final[WrapperField] = WrapperField("DataType", FieldType.SELECTION, display_name="DataType")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DEFAULTPRINTER__FIELD_NAME: Final[WrapperField] = WrapperField("DefaultPrinter", FieldType.SELECTION, display_name="Default Printer")
    FIELD1__FIELD_NAME: Final[WrapperField] = WrapperField("Field1", FieldType.SELECTION, display_name="Field 1")
    FIELD10__FIELD_NAME: Final[WrapperField] = WrapperField("Field10", FieldType.SELECTION, display_name="Field 10")
    FIELD2__FIELD_NAME: Final[WrapperField] = WrapperField("Field2", FieldType.SELECTION, display_name="Field 2")
    FIELD3__FIELD_NAME: Final[WrapperField] = WrapperField("Field3", FieldType.SELECTION, display_name="Field 3")
    FIELD4__FIELD_NAME: Final[WrapperField] = WrapperField("Field4", FieldType.SELECTION, display_name="Field 4")
    FIELD5__FIELD_NAME: Final[WrapperField] = WrapperField("Field5", FieldType.SELECTION, display_name="Field 5")
    FIELD6__FIELD_NAME: Final[WrapperField] = WrapperField("Field6", FieldType.SELECTION, display_name="Field 6")
    FIELD7__FIELD_NAME: Final[WrapperField] = WrapperField("Field7", FieldType.SELECTION, display_name="Field 7")
    FIELD8__FIELD_NAME: Final[WrapperField] = WrapperField("Field8", FieldType.SELECTION, display_name="Field 8")
    FIELD9__FIELD_NAME: Final[WrapperField] = WrapperField("Field9", FieldType.SELECTION, display_name="Field 9")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_BarcodeConfigName_field(self, value: Optional[str]):
        """
        Set data field with field name 'BarcodeConfigName' on this record model
        """
        self.set_field_value(self.BARCODECONFIGNAME__FIELD_NAME.field_name, value)

    def get_BarcodeConfigName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BarcodeConfigName' from this record model
        """
        return self.get_field_value(self.BARCODECONFIGNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CustomPluginClassPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'CustomPluginClassPath' on this record model
        """
        self.set_field_value(self.CUSTOMPLUGINCLASSPATH__FIELD_NAME.field_name, value)

    def get_CustomPluginClassPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CustomPluginClassPath' from this record model
        """
        return self.get_field_value(self.CUSTOMPLUGINCLASSPATH__FIELD_NAME.field_name)

    def set_DataType_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataType' on this record model
        """
        self.set_field_value(self.DATATYPE__FIELD_NAME.field_name, value)

    def get_DataType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataType' from this record model
        """
        return self.get_field_value(self.DATATYPE__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DefaultPrinter_field(self, value: Optional[str]):
        """
        Set data field with field name 'DefaultPrinter' on this record model
        """
        self.set_field_value(self.DEFAULTPRINTER__FIELD_NAME.field_name, value)

    def get_DefaultPrinter_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DefaultPrinter' from this record model
        """
        return self.get_field_value(self.DEFAULTPRINTER__FIELD_NAME.field_name)

    def set_Field1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field1' on this record model
        """
        self.set_field_value(self.FIELD1__FIELD_NAME.field_name, value)

    def get_Field1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field1' from this record model
        """
        return self.get_field_value(self.FIELD1__FIELD_NAME.field_name)

    def set_Field10_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field10' on this record model
        """
        self.set_field_value(self.FIELD10__FIELD_NAME.field_name, value)

    def get_Field10_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field10' from this record model
        """
        return self.get_field_value(self.FIELD10__FIELD_NAME.field_name)

    def set_Field2_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field2' on this record model
        """
        self.set_field_value(self.FIELD2__FIELD_NAME.field_name, value)

    def get_Field2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field2' from this record model
        """
        return self.get_field_value(self.FIELD2__FIELD_NAME.field_name)

    def set_Field3_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field3' on this record model
        """
        self.set_field_value(self.FIELD3__FIELD_NAME.field_name, value)

    def get_Field3_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field3' from this record model
        """
        return self.get_field_value(self.FIELD3__FIELD_NAME.field_name)

    def set_Field4_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field4' on this record model
        """
        self.set_field_value(self.FIELD4__FIELD_NAME.field_name, value)

    def get_Field4_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field4' from this record model
        """
        return self.get_field_value(self.FIELD4__FIELD_NAME.field_name)

    def set_Field5_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field5' on this record model
        """
        self.set_field_value(self.FIELD5__FIELD_NAME.field_name, value)

    def get_Field5_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field5' from this record model
        """
        return self.get_field_value(self.FIELD5__FIELD_NAME.field_name)

    def set_Field6_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field6' on this record model
        """
        self.set_field_value(self.FIELD6__FIELD_NAME.field_name, value)

    def get_Field6_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field6' from this record model
        """
        return self.get_field_value(self.FIELD6__FIELD_NAME.field_name)

    def set_Field7_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field7' on this record model
        """
        self.set_field_value(self.FIELD7__FIELD_NAME.field_name, value)

    def get_Field7_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field7' from this record model
        """
        return self.get_field_value(self.FIELD7__FIELD_NAME.field_name)

    def set_Field8_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field8' on this record model
        """
        self.set_field_value(self.FIELD8__FIELD_NAME.field_name, value)

    def get_Field8_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field8' from this record model
        """
        return self.get_field_value(self.FIELD8__FIELD_NAME.field_name)

    def set_Field9_field(self, value: Optional[str]):
        """
        Set data field with field name 'Field9' on this record model
        """
        self.set_field_value(self.FIELD9__FIELD_NAME.field_name, value)

    def get_Field9_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Field9' from this record model
        """
        return self.get_field_value(self.FIELD9__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class Basic3DScatterDataModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Basic3DScatterData
    Data Type Display Name: Basic 3D Scatter Datum (Basic 3D Scatter Data)
    Fields: CreatedBy, DataRecordName, VeloxLastModifiedDate, x, y, VeloxLastModifiedBy, DateCreated, z
    """
    DATA_TYPE_NAME: Final[str] = 'Basic3DScatterData'
    DISPLAY_NAME: Final[str] = "Basic 3D Scatter Datum"
    PLURAL_DISPLAY_NAME: Final[str] = "Basic 3D Scatter Data"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    X__FIELD_NAME: Final[WrapperField] = WrapperField("x", FieldType.DOUBLE, display_name="x")
    Y__FIELD_NAME: Final[WrapperField] = WrapperField("y", FieldType.DOUBLE, display_name="y")
    Z__FIELD_NAME: Final[WrapperField] = WrapperField("z", FieldType.DOUBLE, display_name="z")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_x_field(self, value: Optional[float]):
        """
        Set data field with field name 'x' on this record model
        """
        self.set_field_value(self.X__FIELD_NAME.field_name, value)

    def get_x_field(self) -> Optional[float]:
        """
        Get data field value with field name 'x' from this record model
        """
        return self.get_field_value(self.X__FIELD_NAME.field_name)

    def set_y_field(self, value: Optional[float]):
        """
        Set data field with field name 'y' on this record model
        """
        self.set_field_value(self.Y__FIELD_NAME.field_name, value)

    def get_y_field(self) -> Optional[float]:
        """
        Get data field value with field name 'y' from this record model
        """
        return self.get_field_value(self.Y__FIELD_NAME.field_name)

    def set_z_field(self, value: Optional[float]):
        """
        Set data field with field name 'z' on this record model
        """
        self.set_field_value(self.Z__FIELD_NAME.field_name, value)

    def get_z_field(self) -> Optional[float]:
        """
        Get data field value with field name 'z' from this record model
        """
        return self.get_field_value(self.Z__FIELD_NAME.field_name)


class BasicIsoSurfacePlotExampleModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BasicIsoSurfacePlotExample
    Data Type Display Name: Basic Iso Surface Plot Example (Basic Iso Surface Plot Examples)
    Fields: Svalue, CreatedBy, DataRecordName, VeloxLastModifiedDate, x, VeloxLastModifiedBy, y, DateCreated, z
    """
    DATA_TYPE_NAME: Final[str] = 'BasicIsoSurfacePlotExample'
    DISPLAY_NAME: Final[str] = "Basic Iso Surface Plot Example"
    PLURAL_DISPLAY_NAME: Final[str] = "Basic Iso Surface Plot Examples"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    SVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("Svalue", FieldType.DOUBLE, display_name="Svalue")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    X__FIELD_NAME: Final[WrapperField] = WrapperField("x", FieldType.DOUBLE, display_name="x")
    Y__FIELD_NAME: Final[WrapperField] = WrapperField("y", FieldType.DOUBLE, display_name="y")
    Z__FIELD_NAME: Final[WrapperField] = WrapperField("z", FieldType.DOUBLE, display_name="z")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Svalue_field(self, value: Optional[float]):
        """
        Set data field with field name 'Svalue' on this record model
        """
        self.set_field_value(self.SVALUE__FIELD_NAME.field_name, value)

    def get_Svalue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Svalue' from this record model
        """
        return self.get_field_value(self.SVALUE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_x_field(self, value: Optional[float]):
        """
        Set data field with field name 'x' on this record model
        """
        self.set_field_value(self.X__FIELD_NAME.field_name, value)

    def get_x_field(self) -> Optional[float]:
        """
        Get data field value with field name 'x' from this record model
        """
        return self.get_field_value(self.X__FIELD_NAME.field_name)

    def set_y_field(self, value: Optional[float]):
        """
        Set data field with field name 'y' on this record model
        """
        self.set_field_value(self.Y__FIELD_NAME.field_name, value)

    def get_y_field(self) -> Optional[float]:
        """
        Get data field value with field name 'y' from this record model
        """
        return self.get_field_value(self.Y__FIELD_NAME.field_name)

    def set_z_field(self, value: Optional[float]):
        """
        Set data field with field name 'z' on this record model
        """
        self.set_field_value(self.Z__FIELD_NAME.field_name, value)

    def get_z_field(self) -> Optional[float]:
        """
        Get data field value with field name 'z' from this record model
        """
        return self.get_field_value(self.Z__FIELD_NAME.field_name)


class BatchModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Batch
    Data Type Display Name: Batch (Batches)
    Fields: CreatedBy, WorkflowName, BatchId, DateCreated, NumberOfSamples, StartDate, AssignedTo, BatchName, PriorityLevel, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, ExemplarBatchStatus
    """
    DATA_TYPE_NAME: Final[str] = 'Batch'
    DISPLAY_NAME: Final[str] = "Batch"
    PLURAL_DISPLAY_NAME: Final[str] = "Batches"
    ASSIGNEDTO__FIELD_NAME: Final[WrapperField] = WrapperField("AssignedTo", FieldType.SELECTION, display_name="Assigned to")
    BATCHID__FIELD_NAME: Final[WrapperField] = WrapperField("BatchId", FieldType.STRING, display_name="Batch ID")
    BATCHNAME__FIELD_NAME: Final[WrapperField] = WrapperField("BatchName", FieldType.STRING, display_name="Batch Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EXEMPLARBATCHSTATUS__FIELD_NAME: Final[WrapperField] = WrapperField("ExemplarBatchStatus", FieldType.SELECTION, display_name="Batch Status")
    NUMBEROFSAMPLES__FIELD_NAME: Final[WrapperField] = WrapperField("NumberOfSamples", FieldType.LONG, display_name="Number of Samples")
    PRIORITYLEVEL__FIELD_NAME: Final[WrapperField] = WrapperField("PriorityLevel", FieldType.PICKLIST, display_name="Priority Level")
    STARTDATE__FIELD_NAME: Final[WrapperField] = WrapperField("StartDate", FieldType.DATE, display_name="Expected Start Date")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    WORKFLOWNAME__FIELD_NAME: Final[WrapperField] = WrapperField("WorkflowName", FieldType.SELECTION, display_name="Batch Workflow")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AssignedTo_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssignedTo' on this record model
        """
        self.set_field_value(self.ASSIGNEDTO__FIELD_NAME.field_name, value)

    def get_AssignedTo_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssignedTo' from this record model
        """
        return self.get_field_value(self.ASSIGNEDTO__FIELD_NAME.field_name)

    def set_BatchId_field(self, value: Optional[str]):
        """
        Set data field with field name 'BatchId' on this record model
        """
        self.set_field_value(self.BATCHID__FIELD_NAME.field_name, value)

    def get_BatchId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BatchId' from this record model
        """
        return self.get_field_value(self.BATCHID__FIELD_NAME.field_name)

    def set_BatchName_field(self, value: Optional[str]):
        """
        Set data field with field name 'BatchName' on this record model
        """
        self.set_field_value(self.BATCHNAME__FIELD_NAME.field_name, value)

    def get_BatchName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BatchName' from this record model
        """
        return self.get_field_value(self.BATCHNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExemplarBatchStatus_field(self, value: Optional[str]):
        """
        Set data field with field name 'ExemplarBatchStatus' on this record model
        """
        self.set_field_value(self.EXEMPLARBATCHSTATUS__FIELD_NAME.field_name, value)

    def get_ExemplarBatchStatus_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ExemplarBatchStatus' from this record model
        """
        return self.get_field_value(self.EXEMPLARBATCHSTATUS__FIELD_NAME.field_name)

    def set_NumberOfSamples_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumberOfSamples' on this record model
        """
        self.set_field_value(self.NUMBEROFSAMPLES__FIELD_NAME.field_name, value)

    def get_NumberOfSamples_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumberOfSamples' from this record model
        """
        return self.get_field_value(self.NUMBEROFSAMPLES__FIELD_NAME.field_name)

    def set_PriorityLevel_field(self, value: Optional[str]):
        """
        Set data field with field name 'PriorityLevel' on this record model
        """
        self.set_field_value(self.PRIORITYLEVEL__FIELD_NAME.field_name, value)

    def get_PriorityLevel_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PriorityLevel' from this record model
        """
        return self.get_field_value(self.PRIORITYLEVEL__FIELD_NAME.field_name)

    def set_StartDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'StartDate' on this record model
        """
        self.set_field_value(self.STARTDATE__FIELD_NAME.field_name, value)

    def get_StartDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'StartDate' from this record model
        """
        return self.get_field_value(self.STARTDATE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_WorkflowName_field(self, value: Optional[str]):
        """
        Set data field with field name 'WorkflowName' on this record model
        """
        self.set_field_value(self.WORKFLOWNAME__FIELD_NAME.field_name, value)

    def get_WorkflowName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'WorkflowName' from this record model
        """
        return self.get_field_value(self.WORKFLOWNAME__FIELD_NAME.field_name)


class BioAnalyzerResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioAnalyzerResult
    Data Type Display Name: BioAnalyzer Result (BioAnalyzer Results)
    Fields: CreatedBy, PeakValue, PeakRegionIdentifier, DateCreated, Area, DataRecordName, Molarity, VeloxLastModifiedDate, VeloxLastModifiedBy, AvgBPSize, MolarityUnits
    """
    DATA_TYPE_NAME: Final[str] = 'BioAnalyzerResult'
    DISPLAY_NAME: Final[str] = "BioAnalyzer Result"
    PLURAL_DISPLAY_NAME: Final[str] = "BioAnalyzer Results"
    AREA__FIELD_NAME: Final[WrapperField] = WrapperField("Area", FieldType.DOUBLE, display_name="Area")
    AVGBPSIZE__FIELD_NAME: Final[WrapperField] = WrapperField("AvgBPSize", FieldType.DOUBLE, display_name="Avg BP Size")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    MOLARITY__FIELD_NAME: Final[WrapperField] = WrapperField("Molarity", FieldType.DOUBLE, display_name="Molarity")
    MOLARITYUNITS__FIELD_NAME: Final[WrapperField] = WrapperField("MolarityUnits", FieldType.STRING, display_name="Molarity Units")
    PEAKREGIONIDENTIFIER__FIELD_NAME: Final[WrapperField] = WrapperField("PeakRegionIdentifier", FieldType.STRING, display_name="Peak/Region Identifier")
    PEAKVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("PeakValue", FieldType.DOUBLE, display_name="Peak Value")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Area_field(self, value: Optional[float]):
        """
        Set data field with field name 'Area' on this record model
        """
        self.set_field_value(self.AREA__FIELD_NAME.field_name, value)

    def get_Area_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Area' from this record model
        """
        return self.get_field_value(self.AREA__FIELD_NAME.field_name)

    def set_AvgBPSize_field(self, value: Optional[float]):
        """
        Set data field with field name 'AvgBPSize' on this record model
        """
        self.set_field_value(self.AVGBPSIZE__FIELD_NAME.field_name, value)

    def get_AvgBPSize_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AvgBPSize' from this record model
        """
        return self.get_field_value(self.AVGBPSIZE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Molarity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Molarity' on this record model
        """
        self.set_field_value(self.MOLARITY__FIELD_NAME.field_name, value)

    def get_Molarity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Molarity' from this record model
        """
        return self.get_field_value(self.MOLARITY__FIELD_NAME.field_name)

    def set_MolarityUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'MolarityUnits' on this record model
        """
        self.set_field_value(self.MOLARITYUNITS__FIELD_NAME.field_name, value)

    def get_MolarityUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MolarityUnits' from this record model
        """
        return self.get_field_value(self.MOLARITYUNITS__FIELD_NAME.field_name)

    def set_PeakRegionIdentifier_field(self, value: Optional[str]):
        """
        Set data field with field name 'PeakRegionIdentifier' on this record model
        """
        self.set_field_value(self.PEAKREGIONIDENTIFIER__FIELD_NAME.field_name, value)

    def get_PeakRegionIdentifier_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PeakRegionIdentifier' from this record model
        """
        return self.get_field_value(self.PEAKREGIONIDENTIFIER__FIELD_NAME.field_name)

    def set_PeakValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'PeakValue' on this record model
        """
        self.set_field_value(self.PEAKVALUE__FIELD_NAME.field_name, value)

    def get_PeakValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PeakValue' from this record model
        """
        return self.get_field_value(self.PEAKVALUE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BioConjugateModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioConjugate
    Data Type Display Name: Bio Conjugate (Bio Conjugates)
    Fields: CreatedBy, ConsumableType, DateCreated, Vendor, DataRecordName, ExpirationDate, VeloxLastModifiedDate, VeloxLastModifiedBy, RegistryId, ConsumableName, LotNumber
    """
    DATA_TYPE_NAME: Final[str] = 'BioConjugate'
    DISPLAY_NAME: Final[str] = "Bio Conjugate"
    PLURAL_DISPLAY_NAME: Final[str] = "Bio Conjugates"
    CONSUMABLENAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableName", FieldType.STRING, display_name="Conjugate Name")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Conjugate Subtype")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EXPIRATIONDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ExpirationDate", FieldType.DATE, display_name="Expiration Date")
    LOTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("LotNumber", FieldType.STRING, display_name="Lot Number")
    REGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryId", FieldType.STRING, display_name="Registry ID")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VENDOR__FIELD_NAME: Final[WrapperField] = WrapperField("Vendor", FieldType.SELECTION, display_name="Vendor")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class BioConjugatePartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioConjugatePart
    Data Type Display Name: Bio Conjugate Part (Bio Conjugate Parts)
    Fields: CreatedBy, SequenceHash, ConsumableType, MultiParentLink152, DateCreated, Sequence, Vendor, QuantityOnHand, MultiParentLink276, Units, QuantityPerItem, MultiParentLink201, ReorderLevelQuantity, ChemicalProperties, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, RegistryId, ConsumableName, HELMHash, HELM
    """
    DATA_TYPE_NAME: Final[str] = 'BioConjugatePart'
    DISPLAY_NAME: Final[str] = "Bio Conjugate Part"
    PLURAL_DISPLAY_NAME: Final[str] = "Bio Conjugate Parts"
    CHEMICALPROPERTIES__FIELD_NAME: Final[WrapperField] = WrapperField("ChemicalProperties", FieldType.SIDE_LINK, display_name="Chemical Properties")
    CONSUMABLENAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableName", FieldType.STRING, display_name="Name")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Type")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    HELM__FIELD_NAME: Final[WrapperField] = WrapperField("HELM", FieldType.STRING, display_name="HELM")
    HELMHASH__FIELD_NAME: Final[WrapperField] = WrapperField("HELMHash", FieldType.STRING, display_name="HELM Hash")
    MULTIPARENTLINK152__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink152", FieldType.MULTIPARENTLINK, display_name="Linked RNA Part")
    MULTIPARENTLINK201__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink201", FieldType.MULTIPARENTLINK, display_name="Linked Protein Part")
    MULTIPARENTLINK276__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink276", FieldType.MULTIPARENTLINK, display_name="Linked Chemical Reagent Part")
    QUANTITYONHAND__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityOnHand", FieldType.DOUBLE, display_name="Quantity / Volume On Hand")
    QUANTITYPERITEM__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityPerItem", FieldType.DOUBLE, display_name="Quantity / Volume Per Item")
    REGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryId", FieldType.STRING, display_name="Registry ID")
    REORDERLEVELQUANTITY__FIELD_NAME: Final[WrapperField] = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE, display_name="Reorder Level Quantity")
    SEQUENCE__FIELD_NAME: Final[WrapperField] = WrapperField("Sequence", FieldType.STRING, display_name="Sequence")
    SEQUENCEHASH__FIELD_NAME: Final[WrapperField] = WrapperField("SequenceHash", FieldType.STRING, display_name="Sequence Hash")
    UNITS__FIELD_NAME: Final[WrapperField] = WrapperField("Units", FieldType.PICKLIST, display_name="Units")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VENDOR__FIELD_NAME: Final[WrapperField] = WrapperField("Vendor", FieldType.SELECTION, display_name="Vendor")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ChemicalProperties_field(self, value: Optional[int]):
        """
        Set data field with field name 'ChemicalProperties' on this record model
        """
        self.set_field_value(self.CHEMICALPROPERTIES__FIELD_NAME.field_name, value)

    def get_ChemicalProperties_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ChemicalProperties' from this record model
        """
        return self.get_field_value(self.CHEMICALPROPERTIES__FIELD_NAME.field_name)

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_HELM_field(self, value: Optional[str]):
        """
        Set data field with field name 'HELM' on this record model
        """
        self.set_field_value(self.HELM__FIELD_NAME.field_name, value)

    def get_HELM_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HELM' from this record model
        """
        return self.get_field_value(self.HELM__FIELD_NAME.field_name)

    def set_HELMHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'HELMHash' on this record model
        """
        self.set_field_value(self.HELMHASH__FIELD_NAME.field_name, value)

    def get_HELMHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HELMHash' from this record model
        """
        return self.get_field_value(self.HELMHASH__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_Sequence_field(self, value: Optional[str]):
        """
        Set data field with field name 'Sequence' on this record model
        """
        self.set_field_value(self.SEQUENCE__FIELD_NAME.field_name, value)

    def get_Sequence_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Sequence' from this record model
        """
        return self.get_field_value(self.SEQUENCE__FIELD_NAME.field_name)

    def set_SequenceHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceHash' on this record model
        """
        self.set_field_value(self.SEQUENCEHASH__FIELD_NAME.field_name, value)

    def get_SequenceHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceHash' from this record model
        """
        return self.get_field_value(self.SEQUENCEHASH__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class BioRadResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioRadResult
    Data Type Display Name: Bio-Rad qPCR Result (Bio-Rad qPCR Results)
    Fields: LogStartingQuantity, CqStdDev, CqMean, CreatedBy, BiologicalSetName, DateCreated, SetPoint, Cq, Target, DataRecordName, Content, VeloxLastModifiedDate, VeloxLastModifiedBy, SQStdDev, WellNote, Fluor, SQMean
    """
    DATA_TYPE_NAME: Final[str] = 'BioRadResult'
    DISPLAY_NAME: Final[str] = "Bio-Rad qPCR Result"
    PLURAL_DISPLAY_NAME: Final[str] = "Bio-Rad qPCR Results"
    BIOLOGICALSETNAME__FIELD_NAME: Final[WrapperField] = WrapperField("BiologicalSetName", FieldType.STRING, display_name="Biological Set Name")
    CONTENT__FIELD_NAME: Final[WrapperField] = WrapperField("Content", FieldType.STRING, display_name="Content")
    CQ__FIELD_NAME: Final[WrapperField] = WrapperField("Cq", FieldType.DOUBLE, display_name="Cq")
    CQMEAN__FIELD_NAME: Final[WrapperField] = WrapperField("CqMean", FieldType.DOUBLE, display_name="Cq Mean")
    CQSTDDEV__FIELD_NAME: Final[WrapperField] = WrapperField("CqStdDev", FieldType.DOUBLE, display_name="Cq Std Dev")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FLUOR__FIELD_NAME: Final[WrapperField] = WrapperField("Fluor", FieldType.STRING, display_name="Fluor")
    LOGSTARTINGQUANTITY__FIELD_NAME: Final[WrapperField] = WrapperField("LogStartingQuantity", FieldType.DOUBLE, display_name="Log Starting Quantity")
    SQMEAN__FIELD_NAME: Final[WrapperField] = WrapperField("SQMean", FieldType.DOUBLE, display_name="SQ Mean")
    SQSTDDEV__FIELD_NAME: Final[WrapperField] = WrapperField("SQStdDev", FieldType.DOUBLE, display_name="SQ Std. Dev")
    SETPOINT__FIELD_NAME: Final[WrapperField] = WrapperField("SetPoint", FieldType.DOUBLE, display_name="Set Point")
    TARGET__FIELD_NAME: Final[WrapperField] = WrapperField("Target", FieldType.STRING, display_name="Target")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    WELLNOTE__FIELD_NAME: Final[WrapperField] = WrapperField("WellNote", FieldType.STRING, display_name="Well Note")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_BiologicalSetName_field(self, value: Optional[str]):
        """
        Set data field with field name 'BiologicalSetName' on this record model
        """
        self.set_field_value(self.BIOLOGICALSETNAME__FIELD_NAME.field_name, value)

    def get_BiologicalSetName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BiologicalSetName' from this record model
        """
        return self.get_field_value(self.BIOLOGICALSETNAME__FIELD_NAME.field_name)

    def set_Content_field(self, value: Optional[str]):
        """
        Set data field with field name 'Content' on this record model
        """
        self.set_field_value(self.CONTENT__FIELD_NAME.field_name, value)

    def get_Content_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Content' from this record model
        """
        return self.get_field_value(self.CONTENT__FIELD_NAME.field_name)

    def set_Cq_field(self, value: Optional[float]):
        """
        Set data field with field name 'Cq' on this record model
        """
        self.set_field_value(self.CQ__FIELD_NAME.field_name, value)

    def get_Cq_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Cq' from this record model
        """
        return self.get_field_value(self.CQ__FIELD_NAME.field_name)

    def set_CqMean_field(self, value: Optional[float]):
        """
        Set data field with field name 'CqMean' on this record model
        """
        self.set_field_value(self.CQMEAN__FIELD_NAME.field_name, value)

    def get_CqMean_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CqMean' from this record model
        """
        return self.get_field_value(self.CQMEAN__FIELD_NAME.field_name)

    def set_CqStdDev_field(self, value: Optional[float]):
        """
        Set data field with field name 'CqStdDev' on this record model
        """
        self.set_field_value(self.CQSTDDEV__FIELD_NAME.field_name, value)

    def get_CqStdDev_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CqStdDev' from this record model
        """
        return self.get_field_value(self.CQSTDDEV__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Fluor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Fluor' on this record model
        """
        self.set_field_value(self.FLUOR__FIELD_NAME.field_name, value)

    def get_Fluor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Fluor' from this record model
        """
        return self.get_field_value(self.FLUOR__FIELD_NAME.field_name)

    def set_LogStartingQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'LogStartingQuantity' on this record model
        """
        self.set_field_value(self.LOGSTARTINGQUANTITY__FIELD_NAME.field_name, value)

    def get_LogStartingQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'LogStartingQuantity' from this record model
        """
        return self.get_field_value(self.LOGSTARTINGQUANTITY__FIELD_NAME.field_name)

    def set_SQMean_field(self, value: Optional[float]):
        """
        Set data field with field name 'SQMean' on this record model
        """
        self.set_field_value(self.SQMEAN__FIELD_NAME.field_name, value)

    def get_SQMean_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SQMean' from this record model
        """
        return self.get_field_value(self.SQMEAN__FIELD_NAME.field_name)

    def set_SQStdDev_field(self, value: Optional[float]):
        """
        Set data field with field name 'SQStdDev' on this record model
        """
        self.set_field_value(self.SQSTDDEV__FIELD_NAME.field_name, value)

    def get_SQStdDev_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SQStdDev' from this record model
        """
        return self.get_field_value(self.SQSTDDEV__FIELD_NAME.field_name)

    def set_SetPoint_field(self, value: Optional[float]):
        """
        Set data field with field name 'SetPoint' on this record model
        """
        self.set_field_value(self.SETPOINT__FIELD_NAME.field_name, value)

    def get_SetPoint_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SetPoint' from this record model
        """
        return self.get_field_value(self.SETPOINT__FIELD_NAME.field_name)

    def set_Target_field(self, value: Optional[str]):
        """
        Set data field with field name 'Target' on this record model
        """
        self.set_field_value(self.TARGET__FIELD_NAME.field_name, value)

    def get_Target_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Target' from this record model
        """
        return self.get_field_value(self.TARGET__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_WellNote_field(self, value: Optional[str]):
        """
        Set data field with field name 'WellNote' on this record model
        """
        self.set_field_value(self.WELLNOTE__FIELD_NAME.field_name, value)

    def get_WellNote_field(self) -> Optional[str]:
        """
        Get data field value with field name 'WellNote' from this record model
        """
        return self.get_field_value(self.WELLNOTE__FIELD_NAME.field_name)


class BioRegSeqAnnotationModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioRegSeqAnnotation
    Data Type Display Name: Bio Reg Seq Annotation (Bio Reg Seq Annotations)
    Fields: Label, Product, DateCreated, AnnotationType, StartPosition, Gene, VeloxLastModifiedBy, StandardName, EndPosition, db_xref, NegativeStrand, Organism, CreatedBy, NCBIFunction, Operon, Experiment, Chromosome, ProteinId, DataRecordName, Note, VeloxLastModifiedDate, LocusTag
    Includes useful annotations imported via NCBI Genbank file feature format.
https://www.insdc.org/submitting-standards/feature-table/
    """
    DATA_TYPE_NAME: Final[str] = 'BioRegSeqAnnotation'
    DISPLAY_NAME: Final[str] = "Bio Reg Seq Annotation"
    PLURAL_DISPLAY_NAME: Final[str] = "Bio Reg Seq Annotations"
    ANNOTATIONTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("AnnotationType", FieldType.STRING, display_name="Annotation Type")
    CHROMOSOME__FIELD_NAME: Final[WrapperField] = WrapperField("Chromosome", FieldType.STRING, display_name="Chromosome")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    ENDPOSITION__FIELD_NAME: Final[WrapperField] = WrapperField("EndPosition", FieldType.LONG, display_name="End Position (1-based)")
    EXPERIMENT__FIELD_NAME: Final[WrapperField] = WrapperField("Experiment", FieldType.STRING, display_name="Experiment")
    GENE__FIELD_NAME: Final[WrapperField] = WrapperField("Gene", FieldType.STRING, display_name="Gene")
    LABEL__FIELD_NAME: Final[WrapperField] = WrapperField("Label", FieldType.STRING, display_name="Label")
    LOCUSTAG__FIELD_NAME: Final[WrapperField] = WrapperField("LocusTag", FieldType.STRING, display_name="Locus Tag")
    NCBIFUNCTION__FIELD_NAME: Final[WrapperField] = WrapperField("NCBIFunction", FieldType.STRING, display_name="Function")
    NEGATIVESTRAND__FIELD_NAME: Final[WrapperField] = WrapperField("NegativeStrand", FieldType.BOOLEAN, display_name="Negative Strand (Reverse Reading)")
    NOTE__FIELD_NAME: Final[WrapperField] = WrapperField("Note", FieldType.STRING, display_name="Note")
    OPERON__FIELD_NAME: Final[WrapperField] = WrapperField("Operon", FieldType.STRING, display_name="Operon")
    ORGANISM__FIELD_NAME: Final[WrapperField] = WrapperField("Organism", FieldType.STRING, display_name="Organism")
    PRODUCT__FIELD_NAME: Final[WrapperField] = WrapperField("Product", FieldType.STRING, display_name="Product")
    PROTEINID__FIELD_NAME: Final[WrapperField] = WrapperField("ProteinId", FieldType.STRING, display_name="Protein ID")
    STANDARDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("StandardName", FieldType.STRING, display_name="Standard Name")
    STARTPOSITION__FIELD_NAME: Final[WrapperField] = WrapperField("StartPosition", FieldType.LONG, display_name="Start Position (1-based)")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    DB_XREF__FIELD_NAME: Final[WrapperField] = WrapperField("db_xref", FieldType.STRING, display_name="db_xref")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AnnotationType_field(self, value: Optional[str]):
        """
        Set data field with field name 'AnnotationType' on this record model
        """
        self.set_field_value(self.ANNOTATIONTYPE__FIELD_NAME.field_name, value)

    def get_AnnotationType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AnnotationType' from this record model
        """
        return self.get_field_value(self.ANNOTATIONTYPE__FIELD_NAME.field_name)

    def set_Chromosome_field(self, value: Optional[str]):
        """
        Set data field with field name 'Chromosome' on this record model
        """
        self.set_field_value(self.CHROMOSOME__FIELD_NAME.field_name, value)

    def get_Chromosome_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Chromosome' from this record model
        """
        return self.get_field_value(self.CHROMOSOME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EndPosition_field(self, value: Optional[int]):
        """
        Set data field with field name 'EndPosition' on this record model
        """
        self.set_field_value(self.ENDPOSITION__FIELD_NAME.field_name, value)

    def get_EndPosition_field(self) -> Optional[int]:
        """
        Get data field value with field name 'EndPosition' from this record model
        """
        return self.get_field_value(self.ENDPOSITION__FIELD_NAME.field_name)

    def set_Experiment_field(self, value: Optional[str]):
        """
        Set data field with field name 'Experiment' on this record model
        """
        self.set_field_value(self.EXPERIMENT__FIELD_NAME.field_name, value)

    def get_Experiment_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Experiment' from this record model
        """
        return self.get_field_value(self.EXPERIMENT__FIELD_NAME.field_name)

    def set_Gene_field(self, value: Optional[str]):
        """
        Set data field with field name 'Gene' on this record model
        """
        self.set_field_value(self.GENE__FIELD_NAME.field_name, value)

    def get_Gene_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Gene' from this record model
        """
        return self.get_field_value(self.GENE__FIELD_NAME.field_name)

    def set_Label_field(self, value: Optional[str]):
        """
        Set data field with field name 'Label' on this record model
        """
        self.set_field_value(self.LABEL__FIELD_NAME.field_name, value)

    def get_Label_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Label' from this record model
        """
        return self.get_field_value(self.LABEL__FIELD_NAME.field_name)

    def set_LocusTag_field(self, value: Optional[str]):
        """
        Set data field with field name 'LocusTag' on this record model
        """
        self.set_field_value(self.LOCUSTAG__FIELD_NAME.field_name, value)

    def get_LocusTag_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LocusTag' from this record model
        """
        return self.get_field_value(self.LOCUSTAG__FIELD_NAME.field_name)

    def set_NCBIFunction_field(self, value: Optional[str]):
        """
        Set data field with field name 'NCBIFunction' on this record model
        """
        self.set_field_value(self.NCBIFUNCTION__FIELD_NAME.field_name, value)

    def get_NCBIFunction_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NCBIFunction' from this record model
        """
        return self.get_field_value(self.NCBIFUNCTION__FIELD_NAME.field_name)

    def set_NegativeStrand_field(self, value: Optional[bool]):
        """
        Set data field with field name 'NegativeStrand' on this record model
        """
        self.set_field_value(self.NEGATIVESTRAND__FIELD_NAME.field_name, value)

    def get_NegativeStrand_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'NegativeStrand' from this record model
        """
        return self.get_field_value(self.NEGATIVESTRAND__FIELD_NAME.field_name)

    def set_Note_field(self, value: Optional[str]):
        """
        Set data field with field name 'Note' on this record model
        """
        self.set_field_value(self.NOTE__FIELD_NAME.field_name, value)

    def get_Note_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Note' from this record model
        """
        return self.get_field_value(self.NOTE__FIELD_NAME.field_name)

    def set_Operon_field(self, value: Optional[str]):
        """
        Set data field with field name 'Operon' on this record model
        """
        self.set_field_value(self.OPERON__FIELD_NAME.field_name, value)

    def get_Operon_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Operon' from this record model
        """
        return self.get_field_value(self.OPERON__FIELD_NAME.field_name)

    def set_Organism_field(self, value: Optional[str]):
        """
        Set data field with field name 'Organism' on this record model
        """
        self.set_field_value(self.ORGANISM__FIELD_NAME.field_name, value)

    def get_Organism_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Organism' from this record model
        """
        return self.get_field_value(self.ORGANISM__FIELD_NAME.field_name)

    def set_Product_field(self, value: Optional[str]):
        """
        Set data field with field name 'Product' on this record model
        """
        self.set_field_value(self.PRODUCT__FIELD_NAME.field_name, value)

    def get_Product_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Product' from this record model
        """
        return self.get_field_value(self.PRODUCT__FIELD_NAME.field_name)

    def set_ProteinId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ProteinId' on this record model
        """
        self.set_field_value(self.PROTEINID__FIELD_NAME.field_name, value)

    def get_ProteinId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ProteinId' from this record model
        """
        return self.get_field_value(self.PROTEINID__FIELD_NAME.field_name)

    def set_StandardName_field(self, value: Optional[str]):
        """
        Set data field with field name 'StandardName' on this record model
        """
        self.set_field_value(self.STANDARDNAME__FIELD_NAME.field_name, value)

    def get_StandardName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StandardName' from this record model
        """
        return self.get_field_value(self.STANDARDNAME__FIELD_NAME.field_name)

    def set_StartPosition_field(self, value: Optional[int]):
        """
        Set data field with field name 'StartPosition' on this record model
        """
        self.set_field_value(self.STARTPOSITION__FIELD_NAME.field_name, value)

    def get_StartPosition_field(self) -> Optional[int]:
        """
        Get data field value with field name 'StartPosition' from this record model
        """
        return self.get_field_value(self.STARTPOSITION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_db_xref_field(self, value: Optional[str]):
        """
        Set data field with field name 'db_xref' on this record model
        """
        self.set_field_value(self.DB_XREF__FIELD_NAME.field_name, value)

    def get_db_xref_field(self) -> Optional[str]:
        """
        Get data field value with field name 'db_xref' from this record model
        """
        return self.get_field_value(self.DB_XREF__FIELD_NAME.field_name)


class BioRegSequenceTypeSettingModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioRegSequenceTypeSetting
    Data Type Display Name: Bio Reg Sequence Type Setting (Bio Reg Sequence Type Settings)
    Fields: RegistryIdPaddingDigits, SequenceDataField, AutoRegisterChildType, CreatedBy, DateCreated, RegistrationIDPrefix, SequenceType, DisableDuplicateCheck, InheritParentRegistryID, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, UniqueDataFields, DisableSequenceValiation, RegistryDataType
    """
    DATA_TYPE_NAME: Final[str] = 'BioRegSequenceTypeSetting'
    DISPLAY_NAME: Final[str] = "Bio Reg Sequence Type Setting"
    PLURAL_DISPLAY_NAME: Final[str] = "Bio Reg Sequence Type Settings"
    AUTOREGISTERCHILDTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("AutoRegisterChildType", FieldType.SELECTION, display_name="Auto Register Child Type")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DISABLEDUPLICATECHECK__FIELD_NAME: Final[WrapperField] = WrapperField("DisableDuplicateCheck", FieldType.BOOLEAN, display_name="Disable Duplicate Check")
    DISABLESEQUENCEVALIATION__FIELD_NAME: Final[WrapperField] = WrapperField("DisableSequenceValiation", FieldType.BOOLEAN, display_name="Disable Sequence Valiation")
    INHERITPARENTREGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("InheritParentRegistryID", FieldType.BOOLEAN, display_name="Inherit Parent Registry ID")
    REGISTRATIONIDPREFIX__FIELD_NAME: Final[WrapperField] = WrapperField("RegistrationIDPrefix", FieldType.STRING, display_name="Registration ID Prefix")
    REGISTRYDATATYPE__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryDataType", FieldType.SELECTION, display_name="Registry Data Type")
    REGISTRYIDPADDINGDIGITS__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryIdPaddingDigits", FieldType.INTEGER, display_name="Registry Id Padding Digits")
    SEQUENCEDATAFIELD__FIELD_NAME: Final[WrapperField] = WrapperField("SequenceDataField", FieldType.SELECTION, display_name="Sequence Data Field")
    SEQUENCETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("SequenceType", FieldType.PICKLIST, display_name="Sequence Type")
    UNIQUEDATAFIELDS__FIELD_NAME: Final[WrapperField] = WrapperField("UniqueDataFields", FieldType.SELECTION, display_name="Unique Data Fields")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AutoRegisterChildType_field(self, value: Optional[str]):
        """
        Set data field with field name 'AutoRegisterChildType' on this record model
        """
        self.set_field_value(self.AUTOREGISTERCHILDTYPE__FIELD_NAME.field_name, value)

    def get_AutoRegisterChildType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AutoRegisterChildType' from this record model
        """
        return self.get_field_value(self.AUTOREGISTERCHILDTYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DisableDuplicateCheck_field(self, value: Optional[bool]):
        """
        Set data field with field name 'DisableDuplicateCheck' on this record model
        """
        self.set_field_value(self.DISABLEDUPLICATECHECK__FIELD_NAME.field_name, value)

    def get_DisableDuplicateCheck_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'DisableDuplicateCheck' from this record model
        """
        return self.get_field_value(self.DISABLEDUPLICATECHECK__FIELD_NAME.field_name)

    def set_DisableSequenceValiation_field(self, value: Optional[bool]):
        """
        Set data field with field name 'DisableSequenceValiation' on this record model
        """
        self.set_field_value(self.DISABLESEQUENCEVALIATION__FIELD_NAME.field_name, value)

    def get_DisableSequenceValiation_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'DisableSequenceValiation' from this record model
        """
        return self.get_field_value(self.DISABLESEQUENCEVALIATION__FIELD_NAME.field_name)

    def set_InheritParentRegistryID_field(self, value: Optional[bool]):
        """
        Set data field with field name 'InheritParentRegistryID' on this record model
        """
        self.set_field_value(self.INHERITPARENTREGISTRYID__FIELD_NAME.field_name, value)

    def get_InheritParentRegistryID_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'InheritParentRegistryID' from this record model
        """
        return self.get_field_value(self.INHERITPARENTREGISTRYID__FIELD_NAME.field_name)

    def set_RegistrationIDPrefix_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistrationIDPrefix' on this record model
        """
        self.set_field_value(self.REGISTRATIONIDPREFIX__FIELD_NAME.field_name, value)

    def get_RegistrationIDPrefix_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistrationIDPrefix' from this record model
        """
        return self.get_field_value(self.REGISTRATIONIDPREFIX__FIELD_NAME.field_name)

    def set_RegistryDataType_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryDataType' on this record model
        """
        self.set_field_value(self.REGISTRYDATATYPE__FIELD_NAME.field_name, value)

    def get_RegistryDataType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryDataType' from this record model
        """
        return self.get_field_value(self.REGISTRYDATATYPE__FIELD_NAME.field_name)

    def set_RegistryIdPaddingDigits_field(self, value: Optional[int]):
        """
        Set data field with field name 'RegistryIdPaddingDigits' on this record model
        """
        self.set_field_value(self.REGISTRYIDPADDINGDIGITS__FIELD_NAME.field_name, value)

    def get_RegistryIdPaddingDigits_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RegistryIdPaddingDigits' from this record model
        """
        return self.get_field_value(self.REGISTRYIDPADDINGDIGITS__FIELD_NAME.field_name)

    def set_SequenceDataField_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceDataField' on this record model
        """
        self.set_field_value(self.SEQUENCEDATAFIELD__FIELD_NAME.field_name, value)

    def get_SequenceDataField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceDataField' from this record model
        """
        return self.get_field_value(self.SEQUENCEDATAFIELD__FIELD_NAME.field_name)

    def set_SequenceType_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceType' on this record model
        """
        self.set_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name, value)

    def get_SequenceType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceType' from this record model
        """
        return self.get_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name)

    def set_UniqueDataFields_field(self, value: Optional[str]):
        """
        Set data field with field name 'UniqueDataFields' on this record model
        """
        self.set_field_value(self.UNIQUEDATAFIELDS__FIELD_NAME.field_name, value)

    def get_UniqueDataFields_field(self) -> Optional[str]:
        """
        Get data field value with field name 'UniqueDataFields' from this record model
        """
        return self.get_field_value(self.UNIQUEDATAFIELDS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BioSpecResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BioSpecResult
    Data Type Display Name: BioSpec Result (BioSpec Results)
    Fields: A260230, CreatedBy, DataRecordName, VeloxLastModifiedDate, A260280, VeloxLastModifiedBy, DateCreated
    """
    DATA_TYPE_NAME: Final[str] = 'BioSpecResult'
    DISPLAY_NAME: Final[str] = "BioSpec Result"
    PLURAL_DISPLAY_NAME: Final[str] = "BioSpec Results"
    A260230__FIELD_NAME: Final[WrapperField] = WrapperField("A260230", FieldType.DOUBLE, display_name="A260/230")
    A260280__FIELD_NAME: Final[WrapperField] = WrapperField("A260280", FieldType.DOUBLE, display_name="A260/280")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_A260230_field(self, value: Optional[float]):
        """
        Set data field with field name 'A260230' on this record model
        """
        self.set_field_value(self.A260230__FIELD_NAME.field_name, value)

    def get_A260230_field(self) -> Optional[float]:
        """
        Get data field value with field name 'A260230' from this record model
        """
        return self.get_field_value(self.A260230__FIELD_NAME.field_name)

    def set_A260280_field(self, value: Optional[float]):
        """
        Set data field with field name 'A260280' on this record model
        """
        self.set_field_value(self.A260280__FIELD_NAME.field_name, value)

    def get_A260280_field(self) -> Optional[float]:
        """
        Get data field value with field name 'A260280' from this record model
        """
        return self.get_field_value(self.A260280__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BloodModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Blood
    Data Type Display Name: Blood (Bloods)
    Fields: CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, DrawSite
    """
    DATA_TYPE_NAME: Final[str] = 'Blood'
    DISPLAY_NAME: Final[str] = "Blood"
    PLURAL_DISPLAY_NAME: Final[str] = "Bloods"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DRAWSITE__FIELD_NAME: Final[WrapperField] = WrapperField("DrawSite", FieldType.PICKLIST, display_name="Draw Site")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DrawSite_field(self, value: Optional[str]):
        """
        Set data field with field name 'DrawSite' on this record model
        """
        self.set_field_value(self.DRAWSITE__FIELD_NAME.field_name, value)

    def get_DrawSite_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DrawSite' from this record model
        """
        return self.get_field_value(self.DRAWSITE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BodyMassModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BodyMass
    Data Type Display Name: Body Mass (Body Masses)
    Fields: Mass, CreatedBy, DataRecordName, VeloxLastModifiedDate, MassUnits, VeloxLastModifiedBy, DateCreated, ObservationInstrument
    """
    DATA_TYPE_NAME: Final[str] = 'BodyMass'
    DISPLAY_NAME: Final[str] = "Body Mass"
    PLURAL_DISPLAY_NAME: Final[str] = "Body Masses"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    MASS__FIELD_NAME: Final[WrapperField] = WrapperField("Mass", FieldType.DOUBLE, display_name="Mass")
    MASSUNITS__FIELD_NAME: Final[WrapperField] = WrapperField("MassUnits", FieldType.PICKLIST, display_name="Mass Units")
    OBSERVATIONINSTRUMENT__FIELD_NAME: Final[WrapperField] = WrapperField("ObservationInstrument", FieldType.SELECTION, display_name="Body Mass Scale")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Mass_field(self, value: Optional[float]):
        """
        Set data field with field name 'Mass' on this record model
        """
        self.set_field_value(self.MASS__FIELD_NAME.field_name, value)

    def get_Mass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Mass' from this record model
        """
        return self.get_field_value(self.MASS__FIELD_NAME.field_name)

    def set_MassUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'MassUnits' on this record model
        """
        self.set_field_value(self.MASSUNITS__FIELD_NAME.field_name, value)

    def get_MassUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MassUnits' from this record model
        """
        return self.get_field_value(self.MASSUNITS__FIELD_NAME.field_name)

    def set_ObservationInstrument_field(self, value: Optional[str]):
        """
        Set data field with field name 'ObservationInstrument' on this record model
        """
        self.set_field_value(self.OBSERVATIONINSTRUMENT__FIELD_NAME.field_name, value)

    def get_ObservationInstrument_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ObservationInstrument' from this record model
        """
        return self.get_field_value(self.OBSERVATIONINSTRUMENT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class BrainTissueModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type BrainTissue
    Data Type Display Name: Brain Tissue (Brain Tissues)
    Fields: CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, BrainTissueType
    """
    DATA_TYPE_NAME: Final[str] = 'BrainTissue'
    DISPLAY_NAME: Final[str] = "Brain Tissue"
    PLURAL_DISPLAY_NAME: Final[str] = "Brain Tissues"
    BRAINTISSUETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("BrainTissueType", FieldType.SELECTION, display_name="Brain Tissue Type")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_BrainTissueType_field(self, value: Optional[str]):
        """
        Set data field with field name 'BrainTissueType' on this record model
        """
        self.set_field_value(self.BRAINTISSUETYPE__FIELD_NAME.field_name, value)

    def get_BrainTissueType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BrainTissueType' from this record model
        """
        return self.get_field_value(self.BRAINTISSUETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class C_SapioCon23Model(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type C_SapioCon23
    Data Type Display Name: SAPIOCON 23 (SAPIOCON 23)
    Fields: C_ExampleSelectionList, CreatedBy, DataRecordName, C_SapioConComments, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, C_HomeWorld, C_DisplayName
    """
    DATA_TYPE_NAME: Final[str] = 'C_SapioCon23'
    DISPLAY_NAME: Final[str] = "SAPIOCON 23"
    PLURAL_DISPLAY_NAME: Final[str] = "SAPIOCON 23"
    C_DISPLAYNAME__FIELD_NAME: Final[WrapperField] = WrapperField("C_DisplayName", FieldType.STRING, display_name="Display Name")
    C_EXAMPLESELECTIONLIST__FIELD_NAME: Final[WrapperField] = WrapperField("C_ExampleSelectionList", FieldType.SELECTION, display_name="Example Selection List")
    C_HOMEWORLD__FIELD_NAME: Final[WrapperField] = WrapperField("C_HomeWorld", FieldType.SELECTION, display_name="Home World")
    C_SAPIOCONCOMMENTS__FIELD_NAME: Final[WrapperField] = WrapperField("C_SapioConComments", FieldType.STRING, display_name="SAPIOCON 23 Comments")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_C_DisplayName_field(self, value: Optional[str]):
        """
        Set data field with field name 'C_DisplayName' on this record model
        """
        self.set_field_value(self.C_DISPLAYNAME__FIELD_NAME.field_name, value)

    def get_C_DisplayName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'C_DisplayName' from this record model
        """
        return self.get_field_value(self.C_DISPLAYNAME__FIELD_NAME.field_name)

    def set_C_ExampleSelectionList_field(self, value: Optional[str]):
        """
        Set data field with field name 'C_ExampleSelectionList' on this record model
        """
        self.set_field_value(self.C_EXAMPLESELECTIONLIST__FIELD_NAME.field_name, value)

    def get_C_ExampleSelectionList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'C_ExampleSelectionList' from this record model
        """
        return self.get_field_value(self.C_EXAMPLESELECTIONLIST__FIELD_NAME.field_name)

    def set_C_HomeWorld_field(self, value: Optional[str]):
        """
        Set data field with field name 'C_HomeWorld' on this record model
        """
        self.set_field_value(self.C_HOMEWORLD__FIELD_NAME.field_name, value)

    def get_C_HomeWorld_field(self) -> Optional[str]:
        """
        Get data field value with field name 'C_HomeWorld' from this record model
        """
        return self.get_field_value(self.C_HOMEWORLD__FIELD_NAME.field_name)

    def set_C_SapioConComments_field(self, value: Optional[str]):
        """
        Set data field with field name 'C_SapioConComments' on this record model
        """
        self.set_field_value(self.C_SAPIOCONCOMMENTS__FIELD_NAME.field_name, value)

    def get_C_SapioConComments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'C_SapioConComments' from this record model
        """
        return self.get_field_value(self.C_SAPIOCONCOMMENTS__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class C_SapioConTestModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type C_SapioConTest
    Data Type Display Name: Sapio Con Test (Sapio Con Tests)
    Fields: Description, CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, Name
    """
    DATA_TYPE_NAME: Final[str] = 'C_SapioConTest'
    DISPLAY_NAME: Final[str] = "Sapio Con Test"
    PLURAL_DISPLAY_NAME: Final[str] = "Sapio Con Tests"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DESCRIPTION__FIELD_NAME: Final[WrapperField] = WrapperField("Description", FieldType.STRING, display_name="Description")
    NAME__FIELD_NAME: Final[WrapperField] = WrapperField("Name", FieldType.STRING, display_name="Name")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Description_field(self, value: Optional[str]):
        """
        Set data field with field name 'Description' on this record model
        """
        self.set_field_value(self.DESCRIPTION__FIELD_NAME.field_name, value)

    def get_Description_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Description' from this record model
        """
        return self.get_field_value(self.DESCRIPTION__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CDLConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CDLConfig
    Data Type Display Name: Complex Data Loader Config (Complex Data Loader Configs)
    Fields: Options, CreatedBy, DateCreated, ConfigurationName, IdentifierType, DataTypeRules2, Options2, DataTypeRules, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DataTypeName, ExplicitlyMapped
    <!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: Final[str] = 'CDLConfig'
    DISPLAY_NAME: Final[str] = "Complex Data Loader Config"
    PLURAL_DISPLAY_NAME: Final[str] = "Complex Data Loader Configs"
    CONFIGURATIONNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConfigurationName", FieldType.STRING, display_name="Configuration Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATATYPENAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataTypeName", FieldType.SELECTION, display_name="Data Type Name")
    DATATYPERULES__FIELD_NAME: Final[WrapperField] = WrapperField("DataTypeRules", FieldType.SELECTION, display_name="Rule #1                   ")
    DATATYPERULES2__FIELD_NAME: Final[WrapperField] = WrapperField("DataTypeRules2", FieldType.SELECTION, display_name="Rule #2                   ")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EXPLICITLYMAPPED__FIELD_NAME: Final[WrapperField] = WrapperField("ExplicitlyMapped", FieldType.BOOLEAN, display_name="Defined Related Mappings")
    IDENTIFIERTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("IdentifierType", FieldType.SELECTION, display_name="Identifier Type")
    OPTIONS__FIELD_NAME: Final[WrapperField] = WrapperField("Options", FieldType.SELECTION, display_name="Options for Rule #1")
    OPTIONS2__FIELD_NAME: Final[WrapperField] = WrapperField("Options2", FieldType.SELECTION, display_name="Options for Rule #2")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConfigurationName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConfigurationName' on this record model
        """
        self.set_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name, value)

    def get_ConfigurationName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConfigurationName' from this record model
        """
        return self.get_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataTypeName_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataTypeName' on this record model
        """
        self.set_field_value(self.DATATYPENAME__FIELD_NAME.field_name, value)

    def get_DataTypeName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataTypeName' from this record model
        """
        return self.get_field_value(self.DATATYPENAME__FIELD_NAME.field_name)

    def set_DataTypeRules_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataTypeRules' on this record model
        """
        self.set_field_value(self.DATATYPERULES__FIELD_NAME.field_name, value)

    def get_DataTypeRules_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataTypeRules' from this record model
        """
        return self.get_field_value(self.DATATYPERULES__FIELD_NAME.field_name)

    def set_DataTypeRules2_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataTypeRules2' on this record model
        """
        self.set_field_value(self.DATATYPERULES2__FIELD_NAME.field_name, value)

    def get_DataTypeRules2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataTypeRules2' from this record model
        """
        return self.get_field_value(self.DATATYPERULES2__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExplicitlyMapped_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ExplicitlyMapped' on this record model
        """
        self.set_field_value(self.EXPLICITLYMAPPED__FIELD_NAME.field_name, value)

    def get_ExplicitlyMapped_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ExplicitlyMapped' from this record model
        """
        return self.get_field_value(self.EXPLICITLYMAPPED__FIELD_NAME.field_name)

    def set_IdentifierType_field(self, value: Optional[str]):
        """
        Set data field with field name 'IdentifierType' on this record model
        """
        self.set_field_value(self.IDENTIFIERTYPE__FIELD_NAME.field_name, value)

    def get_IdentifierType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IdentifierType' from this record model
        """
        return self.get_field_value(self.IDENTIFIERTYPE__FIELD_NAME.field_name)

    def set_Options_field(self, value: Optional[str]):
        """
        Set data field with field name 'Options' on this record model
        """
        self.set_field_value(self.OPTIONS__FIELD_NAME.field_name, value)

    def get_Options_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Options' from this record model
        """
        return self.get_field_value(self.OPTIONS__FIELD_NAME.field_name)

    def set_Options2_field(self, value: Optional[str]):
        """
        Set data field with field name 'Options2' on this record model
        """
        self.set_field_value(self.OPTIONS2__FIELD_NAME.field_name, value)

    def get_Options2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Options2' from this record model
        """
        return self.get_field_value(self.OPTIONS2__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CDLFieldMapModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CDLFieldMap
    Data Type Display Name: Complex Data Loader Field Mapping (Complex Data Loader Field Mappings)
    Fields: FieldRules, Options, CreatedBy, FromHeader, IdentifiedBy, DateCreated, ConfigurationName, FieldType, Options2, HeaderNameAliasList, FieldRules2, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, IsListField, DataTypeName, IsIdentifierField, ToField
    <!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: Final[str] = 'CDLFieldMap'
    DISPLAY_NAME: Final[str] = "Complex Data Loader Field Mapping"
    PLURAL_DISPLAY_NAME: Final[str] = "Complex Data Loader Field Mappings"
    CONFIGURATIONNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConfigurationName", FieldType.STRING, display_name="Configuration Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATATYPENAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataTypeName", FieldType.SELECTION, display_name="Data Type Name")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FIELDRULES__FIELD_NAME: Final[WrapperField] = WrapperField("FieldRules", FieldType.SELECTION, display_name="Rule #1                                 ")
    FIELDRULES2__FIELD_NAME: Final[WrapperField] = WrapperField("FieldRules2", FieldType.SELECTION, display_name="Rule #2                                 ")
    FIELDTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("FieldType", FieldType.SELECTION, display_name="Field Type")
    FROMHEADER__FIELD_NAME: Final[WrapperField] = WrapperField("FromHeader", FieldType.SELECTION, display_name="From Header")
    HEADERNAMEALIASLIST__FIELD_NAME: Final[WrapperField] = WrapperField("HeaderNameAliasList", FieldType.SELECTION, display_name="Alternate Header Name(s)")
    IDENTIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("IdentifiedBy", FieldType.STRING, display_name="Identified By")
    ISIDENTIFIERFIELD__FIELD_NAME: Final[WrapperField] = WrapperField("IsIdentifierField", FieldType.BOOLEAN, display_name="Is Identifier?")
    ISLISTFIELD__FIELD_NAME: Final[WrapperField] = WrapperField("IsListField", FieldType.BOOLEAN, display_name="Is List Field")
    OPTIONS__FIELD_NAME: Final[WrapperField] = WrapperField("Options", FieldType.SELECTION, display_name="Options for Rule #1             ")
    OPTIONS2__FIELD_NAME: Final[WrapperField] = WrapperField("Options2", FieldType.SELECTION, display_name="Options for Rule #2             ")
    TOFIELD__FIELD_NAME: Final[WrapperField] = WrapperField("ToField", FieldType.SELECTION, display_name="To Field")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConfigurationName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConfigurationName' on this record model
        """
        self.set_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name, value)

    def get_ConfigurationName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConfigurationName' from this record model
        """
        return self.get_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataTypeName_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataTypeName' on this record model
        """
        self.set_field_value(self.DATATYPENAME__FIELD_NAME.field_name, value)

    def get_DataTypeName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataTypeName' from this record model
        """
        return self.get_field_value(self.DATATYPENAME__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FieldRules_field(self, value: Optional[str]):
        """
        Set data field with field name 'FieldRules' on this record model
        """
        self.set_field_value(self.FIELDRULES__FIELD_NAME.field_name, value)

    def get_FieldRules_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FieldRules' from this record model
        """
        return self.get_field_value(self.FIELDRULES__FIELD_NAME.field_name)

    def set_FieldRules2_field(self, value: Optional[str]):
        """
        Set data field with field name 'FieldRules2' on this record model
        """
        self.set_field_value(self.FIELDRULES2__FIELD_NAME.field_name, value)

    def get_FieldRules2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FieldRules2' from this record model
        """
        return self.get_field_value(self.FIELDRULES2__FIELD_NAME.field_name)

    def set_FieldType_field(self, value: Optional[str]):
        """
        Set data field with field name 'FieldType' on this record model
        """
        self.set_field_value(self.FIELDTYPE__FIELD_NAME.field_name, value)

    def get_FieldType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FieldType' from this record model
        """
        return self.get_field_value(self.FIELDTYPE__FIELD_NAME.field_name)

    def set_FromHeader_field(self, value: Optional[str]):
        """
        Set data field with field name 'FromHeader' on this record model
        """
        self.set_field_value(self.FROMHEADER__FIELD_NAME.field_name, value)

    def get_FromHeader_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FromHeader' from this record model
        """
        return self.get_field_value(self.FROMHEADER__FIELD_NAME.field_name)

    def set_HeaderNameAliasList_field(self, value: Optional[str]):
        """
        Set data field with field name 'HeaderNameAliasList' on this record model
        """
        self.set_field_value(self.HEADERNAMEALIASLIST__FIELD_NAME.field_name, value)

    def get_HeaderNameAliasList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HeaderNameAliasList' from this record model
        """
        return self.get_field_value(self.HEADERNAMEALIASLIST__FIELD_NAME.field_name)

    def set_IdentifiedBy_field(self, value: Optional[str]):
        """
        Set data field with field name 'IdentifiedBy' on this record model
        """
        self.set_field_value(self.IDENTIFIEDBY__FIELD_NAME.field_name, value)

    def get_IdentifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IdentifiedBy' from this record model
        """
        return self.get_field_value(self.IDENTIFIEDBY__FIELD_NAME.field_name)

    def set_IsIdentifierField_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsIdentifierField' on this record model
        """
        self.set_field_value(self.ISIDENTIFIERFIELD__FIELD_NAME.field_name, value)

    def get_IsIdentifierField_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsIdentifierField' from this record model
        """
        return self.get_field_value(self.ISIDENTIFIERFIELD__FIELD_NAME.field_name)

    def set_IsListField_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsListField' on this record model
        """
        self.set_field_value(self.ISLISTFIELD__FIELD_NAME.field_name, value)

    def get_IsListField_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsListField' from this record model
        """
        return self.get_field_value(self.ISLISTFIELD__FIELD_NAME.field_name)

    def set_Options_field(self, value: Optional[str]):
        """
        Set data field with field name 'Options' on this record model
        """
        self.set_field_value(self.OPTIONS__FIELD_NAME.field_name, value)

    def get_Options_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Options' from this record model
        """
        return self.get_field_value(self.OPTIONS__FIELD_NAME.field_name)

    def set_Options2_field(self, value: Optional[str]):
        """
        Set data field with field name 'Options2' on this record model
        """
        self.set_field_value(self.OPTIONS2__FIELD_NAME.field_name, value)

    def get_Options2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Options2' from this record model
        """
        return self.get_field_value(self.OPTIONS2__FIELD_NAME.field_name)

    def set_ToField_field(self, value: Optional[str]):
        """
        Set data field with field name 'ToField' on this record model
        """
        self.set_field_value(self.TOFIELD__FIELD_NAME.field_name, value)

    def get_ToField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ToField' from this record model
        """
        return self.get_field_value(self.TOFIELD__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CDLFileFieldModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CDLFileField
    Data Type Display Name: Complex Data Loader File Field Header (Complex Data Loader File Field Headers)
    Fields: CreatedBy, DataRecordName, FileFieldHeader, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, ConfigurationName
    These records represent the field headers that were found in the example file.  These records are used by the plugin backing the selection list to the header field on the Complex Data Loader Field Mapping records. 
<!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: Final[str] = 'CDLFileField'
    DISPLAY_NAME: Final[str] = "Complex Data Loader File Field Header"
    PLURAL_DISPLAY_NAME: Final[str] = "Complex Data Loader File Field Headers"
    CONFIGURATIONNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConfigurationName", FieldType.STRING, display_name="Configuration Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILEFIELDHEADER__FIELD_NAME: Final[WrapperField] = WrapperField("FileFieldHeader", FieldType.STRING, display_name="From Header")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConfigurationName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConfigurationName' on this record model
        """
        self.set_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name, value)

    def get_ConfigurationName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConfigurationName' from this record model
        """
        return self.get_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FileFieldHeader_field(self, value: Optional[str]):
        """
        Set data field with field name 'FileFieldHeader' on this record model
        """
        self.set_field_value(self.FILEFIELDHEADER__FIELD_NAME.field_name, value)

    def get_FileFieldHeader_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FileFieldHeader' from this record model
        """
        return self.get_field_value(self.FILEFIELDHEADER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CDLGroupingConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CDLGroupingConfig
    Data Type Display Name: Complex Data Loader Grouping Config (Complex Data Loader Grouping Configs)
    Fields: FileParser, CreatedBy, AllowDynamicHeaders, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, ConfigurationName, RestrictToGroups
    <!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: Final[str] = 'CDLGroupingConfig'
    DISPLAY_NAME: Final[str] = "Complex Data Loader Grouping Config"
    PLURAL_DISPLAY_NAME: Final[str] = "Complex Data Loader Grouping Configs"
    ALLOWDYNAMICHEADERS__FIELD_NAME: Final[WrapperField] = WrapperField("AllowDynamicHeaders", FieldType.BOOLEAN, display_name="Allow Alternative Headers")
    CONFIGURATIONNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConfigurationName", FieldType.STRING, display_name="Configuration Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILEPARSER__FIELD_NAME: Final[WrapperField] = WrapperField("FileParser", FieldType.SELECTION, display_name="File Parser                ")
    RESTRICTTOGROUPS__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictToGroups", FieldType.SELECTION, display_name="Restrict To Groups")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AllowDynamicHeaders_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AllowDynamicHeaders' on this record model
        """
        self.set_field_value(self.ALLOWDYNAMICHEADERS__FIELD_NAME.field_name, value)

    def get_AllowDynamicHeaders_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AllowDynamicHeaders' from this record model
        """
        return self.get_field_value(self.ALLOWDYNAMICHEADERS__FIELD_NAME.field_name)

    def set_ConfigurationName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConfigurationName' on this record model
        """
        self.set_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name, value)

    def get_ConfigurationName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConfigurationName' from this record model
        """
        return self.get_field_value(self.CONFIGURATIONNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FileParser_field(self, value: Optional[str]):
        """
        Set data field with field name 'FileParser' on this record model
        """
        self.set_field_value(self.FILEPARSER__FIELD_NAME.field_name, value)

    def get_FileParser_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FileParser' from this record model
        """
        return self.get_field_value(self.FILEPARSER__FIELD_NAME.field_name)

    def set_RestrictToGroups_field(self, value: Optional[str]):
        """
        Set data field with field name 'RestrictToGroups' on this record model
        """
        self.set_field_value(self.RESTRICTTOGROUPS__FIELD_NAME.field_name, value)

    def get_RestrictToGroups_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RestrictToGroups' from this record model
        """
        return self.get_field_value(self.RESTRICTTOGROUPS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CellExperimentReferenceModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CellExperimentReference
    Data Type Display Name: Cell Ontology Reference (Cell Ontology References)
    Fields: Subclass1_1_1_1, CreatedBy, DataRecordName, Subclass1_1, Subclass1_1_1, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, Class1
    """
    DATA_TYPE_NAME: Final[str] = 'CellExperimentReference'
    DISPLAY_NAME: Final[str] = "Cell Ontology Reference"
    PLURAL_DISPLAY_NAME: Final[str] = "Cell Ontology References"
    CLASS1__FIELD_NAME: Final[WrapperField] = WrapperField("Class1", FieldType.SELECTION, display_name="1. Class")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    SUBCLASS1_1__FIELD_NAME: Final[WrapperField] = WrapperField("Subclass1_1", FieldType.SELECTION, display_name="1.1 Subclass")
    SUBCLASS1_1_1__FIELD_NAME: Final[WrapperField] = WrapperField("Subclass1_1_1", FieldType.SELECTION, display_name="1.1.1 Subclass")
    SUBCLASS1_1_1_1__FIELD_NAME: Final[WrapperField] = WrapperField("Subclass1_1_1_1", FieldType.SELECTION, display_name="1.1.1.1 Subclass")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Class1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Class1' on this record model
        """
        self.set_field_value(self.CLASS1__FIELD_NAME.field_name, value)

    def get_Class1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Class1' from this record model
        """
        return self.get_field_value(self.CLASS1__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Subclass1_1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subclass1_1' on this record model
        """
        self.set_field_value(self.SUBCLASS1_1__FIELD_NAME.field_name, value)

    def get_Subclass1_1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subclass1_1' from this record model
        """
        return self.get_field_value(self.SUBCLASS1_1__FIELD_NAME.field_name)

    def set_Subclass1_1_1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subclass1_1_1' on this record model
        """
        self.set_field_value(self.SUBCLASS1_1_1__FIELD_NAME.field_name, value)

    def get_Subclass1_1_1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subclass1_1_1' from this record model
        """
        return self.get_field_value(self.SUBCLASS1_1_1__FIELD_NAME.field_name)

    def set_Subclass1_1_1_1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subclass1_1_1_1' on this record model
        """
        self.set_field_value(self.SUBCLASS1_1_1_1__FIELD_NAME.field_name, value)

    def get_Subclass1_1_1_1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subclass1_1_1_1' from this record model
        """
        return self.get_field_value(self.SUBCLASS1_1_1_1__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CellLineModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CellLine
    Data Type Display Name: Cell Line (Cell Lines)
    Fields: MultiParentLink215, ViableCellNumbers, CreatedBy, DataRecordName, Subclass1_1, Subclass1_1_1, TotalCellNumbers, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, Class1
    The CellLine Data Type
    """
    DATA_TYPE_NAME: Final[str] = 'CellLine'
    DISPLAY_NAME: Final[str] = "Cell Line"
    PLURAL_DISPLAY_NAME: Final[str] = "Cell Lines"
    CLASS1__FIELD_NAME: Final[WrapperField] = WrapperField("Class1", FieldType.SELECTION, display_name="1. Class")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    MULTIPARENTLINK215__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK, display_name="Linked Sample")
    SUBCLASS1_1__FIELD_NAME: Final[WrapperField] = WrapperField("Subclass1_1", FieldType.SELECTION, display_name="1.1 Subclass")
    SUBCLASS1_1_1__FIELD_NAME: Final[WrapperField] = WrapperField("Subclass1_1_1", FieldType.SELECTION, display_name="1.1.1 Subclass")
    TOTALCELLNUMBERS__FIELD_NAME: Final[WrapperField] = WrapperField("TotalCellNumbers", FieldType.LONG, display_name="Total Cell Numbers")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VIABLECELLNUMBERS__FIELD_NAME: Final[WrapperField] = WrapperField("ViableCellNumbers", FieldType.LONG, display_name="Viable Cell Numbers")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Class1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Class1' on this record model
        """
        self.set_field_value(self.CLASS1__FIELD_NAME.field_name, value)

    def get_Class1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Class1' from this record model
        """
        return self.get_field_value(self.CLASS1__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Subclass1_1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subclass1_1' on this record model
        """
        self.set_field_value(self.SUBCLASS1_1__FIELD_NAME.field_name, value)

    def get_Subclass1_1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subclass1_1' from this record model
        """
        return self.get_field_value(self.SUBCLASS1_1__FIELD_NAME.field_name)

    def set_Subclass1_1_1_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subclass1_1_1' on this record model
        """
        self.set_field_value(self.SUBCLASS1_1_1__FIELD_NAME.field_name, value)

    def get_Subclass1_1_1_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subclass1_1_1' from this record model
        """
        return self.get_field_value(self.SUBCLASS1_1_1__FIELD_NAME.field_name)

    def set_TotalCellNumbers_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalCellNumbers' on this record model
        """
        self.set_field_value(self.TOTALCELLNUMBERS__FIELD_NAME.field_name, value)

    def get_TotalCellNumbers_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalCellNumbers' from this record model
        """
        return self.get_field_value(self.TOTALCELLNUMBERS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_ViableCellNumbers_field(self, value: Optional[int]):
        """
        Set data field with field name 'ViableCellNumbers' on this record model
        """
        self.set_field_value(self.VIABLECELLNUMBERS__FIELD_NAME.field_name, value)

    def get_ViableCellNumbers_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ViableCellNumbers' from this record model
        """
        return self.get_field_value(self.VIABLECELLNUMBERS__FIELD_NAME.field_name)


class CellOntologyModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CellOntology
    Data Type Display Name: Cell Ontology (Cell Ontologies)
    Fields: Synonyms, CreatedBy, DataRecordName, Definitions, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, ClassID, MultiParentLink695, PreferredLabel
    """
    DATA_TYPE_NAME: Final[str] = 'CellOntology'
    DISPLAY_NAME: Final[str] = "Cell Ontology"
    PLURAL_DISPLAY_NAME: Final[str] = "Cell Ontologies"
    CLASSID__FIELD_NAME: Final[WrapperField] = WrapperField("ClassID", FieldType.STRING, display_name="Class ID")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DEFINITIONS__FIELD_NAME: Final[WrapperField] = WrapperField("Definitions", FieldType.STRING, display_name="Definitions")
    MULTIPARENTLINK695__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink695", FieldType.MULTIPARENTLINK, display_name="Linked Cell Ontology")
    PREFERREDLABEL__FIELD_NAME: Final[WrapperField] = WrapperField("PreferredLabel", FieldType.STRING, display_name="Preferred Label")
    SYNONYMS__FIELD_NAME: Final[WrapperField] = WrapperField("Synonyms", FieldType.STRING, display_name="Synonyms")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ClassID_field(self, value: Optional[str]):
        """
        Set data field with field name 'ClassID' on this record model
        """
        self.set_field_value(self.CLASSID__FIELD_NAME.field_name, value)

    def get_ClassID_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ClassID' from this record model
        """
        return self.get_field_value(self.CLASSID__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Definitions_field(self, value: Optional[str]):
        """
        Set data field with field name 'Definitions' on this record model
        """
        self.set_field_value(self.DEFINITIONS__FIELD_NAME.field_name, value)

    def get_Definitions_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Definitions' from this record model
        """
        return self.get_field_value(self.DEFINITIONS__FIELD_NAME.field_name)

    def set_PreferredLabel_field(self, value: Optional[str]):
        """
        Set data field with field name 'PreferredLabel' on this record model
        """
        self.set_field_value(self.PREFERREDLABEL__FIELD_NAME.field_name, value)

    def get_PreferredLabel_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PreferredLabel' from this record model
        """
        return self.get_field_value(self.PREFERREDLABEL__FIELD_NAME.field_name)

    def set_Synonyms_field(self, value: Optional[str]):
        """
        Set data field with field name 'Synonyms' on this record model
        """
        self.set_field_value(self.SYNONYMS__FIELD_NAME.field_name, value)

    def get_Synonyms_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Synonyms' from this record model
        """
        return self.get_field_value(self.SYNONYMS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CentrifugeRunParametersModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CentrifugeRunParameters
    Data Type Display Name: Centrifuge Run Parameters (Centrifuge Run Parameters)
    Fields: MultiParentLink215, Temperature, TargetVolume, CreatedBy, TargetConcentration, DateCreated, Duration, RPM, GForce, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy
    """
    DATA_TYPE_NAME: Final[str] = 'CentrifugeRunParameters'
    DISPLAY_NAME: Final[str] = "Centrifuge Run Parameters"
    PLURAL_DISPLAY_NAME: Final[str] = "Centrifuge Run Parameters"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DURATION__FIELD_NAME: Final[WrapperField] = WrapperField("Duration", FieldType.DOUBLE, display_name="Duration (min)")
    GFORCE__FIELD_NAME: Final[WrapperField] = WrapperField("GForce", FieldType.DOUBLE, display_name="G-force (g)")
    MULTIPARENTLINK215__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK, display_name="Linked Sample")
    RPM__FIELD_NAME: Final[WrapperField] = WrapperField("RPM", FieldType.DOUBLE, display_name="RPM")
    TARGETCONCENTRATION__FIELD_NAME: Final[WrapperField] = WrapperField("TargetConcentration", FieldType.DOUBLE, display_name="Target Concentration (g/L)")
    TARGETVOLUME__FIELD_NAME: Final[WrapperField] = WrapperField("TargetVolume", FieldType.DOUBLE, display_name="Target Volume (L)")
    TEMPERATURE__FIELD_NAME: Final[WrapperField] = WrapperField("Temperature", FieldType.DOUBLE, display_name="Temperature (C)")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Duration_field(self, value: Optional[float]):
        """
        Set data field with field name 'Duration' on this record model
        """
        self.set_field_value(self.DURATION__FIELD_NAME.field_name, value)

    def get_Duration_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Duration' from this record model
        """
        return self.get_field_value(self.DURATION__FIELD_NAME.field_name)

    def set_GForce_field(self, value: Optional[float]):
        """
        Set data field with field name 'GForce' on this record model
        """
        self.set_field_value(self.GFORCE__FIELD_NAME.field_name, value)

    def get_GForce_field(self) -> Optional[float]:
        """
        Get data field value with field name 'GForce' from this record model
        """
        return self.get_field_value(self.GFORCE__FIELD_NAME.field_name)

    def set_RPM_field(self, value: Optional[float]):
        """
        Set data field with field name 'RPM' on this record model
        """
        self.set_field_value(self.RPM__FIELD_NAME.field_name, value)

    def get_RPM_field(self) -> Optional[float]:
        """
        Get data field value with field name 'RPM' from this record model
        """
        return self.get_field_value(self.RPM__FIELD_NAME.field_name)

    def set_TargetConcentration_field(self, value: Optional[float]):
        """
        Set data field with field name 'TargetConcentration' on this record model
        """
        self.set_field_value(self.TARGETCONCENTRATION__FIELD_NAME.field_name, value)

    def get_TargetConcentration_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TargetConcentration' from this record model
        """
        return self.get_field_value(self.TARGETCONCENTRATION__FIELD_NAME.field_name)

    def set_TargetVolume_field(self, value: Optional[float]):
        """
        Set data field with field name 'TargetVolume' on this record model
        """
        self.set_field_value(self.TARGETVOLUME__FIELD_NAME.field_name, value)

    def get_TargetVolume_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TargetVolume' from this record model
        """
        return self.get_field_value(self.TARGETVOLUME__FIELD_NAME.field_name)

    def set_Temperature_field(self, value: Optional[float]):
        """
        Set data field with field name 'Temperature' on this record model
        """
        self.set_field_value(self.TEMPERATURE__FIELD_NAME.field_name, value)

    def get_Temperature_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Temperature' from this record model
        """
        return self.get_field_value(self.TEMPERATURE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ChemCuratorQueueModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemCuratorQueue
    Data Type Display Name: Chem Curator Queue (Chem Curator Queues)
    Fields: CreatedBy, inchi, PayloadData, DateCreated, HeaderNameListJSON, SMILES, MOL, ErrorDetails, OriginalDataType, PartDataTypeName, DataRecordName, ImportConfigLink, ProblemType, VeloxLastModifiedDate, VeloxLastModifiedBy
    Describes data in the chem curator queue when automatic identity fails to completely determine which material a registered part or lot would have.
    """
    DATA_TYPE_NAME: Final[str] = 'ChemCuratorQueue'
    DISPLAY_NAME: Final[str] = "Chem Curator Queue"
    PLURAL_DISPLAY_NAME: Final[str] = "Chem Curator Queues"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    ERRORDETAILS__FIELD_NAME: Final[WrapperField] = WrapperField("ErrorDetails", FieldType.STRING, display_name="Error Details")
    HEADERNAMELISTJSON__FIELD_NAME: Final[WrapperField] = WrapperField("HeaderNameListJSON", FieldType.STRING, display_name="Header Name List JSON")
    IMPORTCONFIGLINK__FIELD_NAME: Final[WrapperField] = WrapperField("ImportConfigLink", FieldType.SIDE_LINK, display_name="Import Config Side L Ink")
    MOL__FIELD_NAME: Final[WrapperField] = WrapperField("MOL", FieldType.STRING, display_name="MOL data")
    ORIGINALDATATYPE__FIELD_NAME: Final[WrapperField] = WrapperField("OriginalDataType", FieldType.STRING, display_name="Original Data Type")
    PARTDATATYPENAME__FIELD_NAME: Final[WrapperField] = WrapperField("PartDataTypeName", FieldType.STRING, display_name="Part Data Type Name")
    PAYLOADDATA__FIELD_NAME: Final[WrapperField] = WrapperField("PayloadData", FieldType.STRING, display_name="Payload Data")
    PROBLEMTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ProblemType", FieldType.STRING, display_name="Problem Type")
    SMILES__FIELD_NAME: Final[WrapperField] = WrapperField("SMILES", FieldType.STRING, display_name="SMILES Data")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    INCHI__FIELD_NAME: Final[WrapperField] = WrapperField("inchi", FieldType.STRING, display_name="INCHI data")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ErrorDetails_field(self, value: Optional[str]):
        """
        Set data field with field name 'ErrorDetails' on this record model
        """
        self.set_field_value(self.ERRORDETAILS__FIELD_NAME.field_name, value)

    def get_ErrorDetails_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ErrorDetails' from this record model
        """
        return self.get_field_value(self.ERRORDETAILS__FIELD_NAME.field_name)

    def set_HeaderNameListJSON_field(self, value: Optional[str]):
        """
        Set data field with field name 'HeaderNameListJSON' on this record model
        """
        self.set_field_value(self.HEADERNAMELISTJSON__FIELD_NAME.field_name, value)

    def get_HeaderNameListJSON_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HeaderNameListJSON' from this record model
        """
        return self.get_field_value(self.HEADERNAMELISTJSON__FIELD_NAME.field_name)

    def set_ImportConfigLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'ImportConfigLink' on this record model
        """
        self.set_field_value(self.IMPORTCONFIGLINK__FIELD_NAME.field_name, value)

    def get_ImportConfigLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ImportConfigLink' from this record model
        """
        return self.get_field_value(self.IMPORTCONFIGLINK__FIELD_NAME.field_name)

    def set_MOL_field(self, value: Optional[str]):
        """
        Set data field with field name 'MOL' on this record model
        """
        self.set_field_value(self.MOL__FIELD_NAME.field_name, value)

    def get_MOL_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MOL' from this record model
        """
        return self.get_field_value(self.MOL__FIELD_NAME.field_name)

    def set_OriginalDataType_field(self, value: Optional[str]):
        """
        Set data field with field name 'OriginalDataType' on this record model
        """
        self.set_field_value(self.ORIGINALDATATYPE__FIELD_NAME.field_name, value)

    def get_OriginalDataType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OriginalDataType' from this record model
        """
        return self.get_field_value(self.ORIGINALDATATYPE__FIELD_NAME.field_name)

    def set_PartDataTypeName_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartDataTypeName' on this record model
        """
        self.set_field_value(self.PARTDATATYPENAME__FIELD_NAME.field_name, value)

    def get_PartDataTypeName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartDataTypeName' from this record model
        """
        return self.get_field_value(self.PARTDATATYPENAME__FIELD_NAME.field_name)

    def set_PayloadData_field(self, value: Optional[str]):
        """
        Set data field with field name 'PayloadData' on this record model
        """
        self.set_field_value(self.PAYLOADDATA__FIELD_NAME.field_name, value)

    def get_PayloadData_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PayloadData' from this record model
        """
        return self.get_field_value(self.PAYLOADDATA__FIELD_NAME.field_name)

    def set_ProblemType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ProblemType' on this record model
        """
        self.set_field_value(self.PROBLEMTYPE__FIELD_NAME.field_name, value)

    def get_ProblemType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ProblemType' from this record model
        """
        return self.get_field_value(self.PROBLEMTYPE__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)


class ChemicalReagentModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemicalReagent
    Data Type Display Name: Chemical Reagent (Chemical Reagents)
    Fields: ExactMass, PubchemCid, ConsumableType, Purity, DateCreated, IsGHSClassified, HasOrStereoGroup, CXSMILESHash, Formula, PolarSurfaceArea, GHSSignal, cLogP, VeloxLastModifiedBy, MolecularWeight, InchiKey, LotNumber, CreatedBy, inchi, Charge, IUPAC, SMILES, GHSHazardCode, TotalHBondCount, TotalHBondAcceptors, DataRecordName, ExpirationDate, CAS, VeloxLastModifiedDate, RegistryId, Yield, StereoRegHash, GHSPictoCode, GHSCautionCode
    """
    DATA_TYPE_NAME: Final[str] = 'ChemicalReagent'
    DISPLAY_NAME: Final[str] = "Chemical Reagent"
    PLURAL_DISPLAY_NAME: Final[str] = "Chemical Reagents"
    CAS__FIELD_NAME: Final[WrapperField] = WrapperField("CAS", FieldType.STRING, display_name="CAS")
    CXSMILESHASH__FIELD_NAME: Final[WrapperField] = WrapperField("CXSMILESHash", FieldType.STRING, display_name="CXSMILES Hash")
    CHARGE__FIELD_NAME: Final[WrapperField] = WrapperField("Charge", FieldType.INTEGER, display_name="Charge")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EXACTMASS__FIELD_NAME: Final[WrapperField] = WrapperField("ExactMass", FieldType.DOUBLE, display_name="Exact Mass")
    EXPIRATIONDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ExpirationDate", FieldType.DATE, display_name="Expiration Date")
    FORMULA__FIELD_NAME: Final[WrapperField] = WrapperField("Formula", FieldType.STRING, display_name="Formula")
    GHSCAUTIONCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSCautionCode", FieldType.STRING, display_name="GHS Caution Code")
    GHSHAZARDCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSHazardCode", FieldType.STRING, display_name="GHS Hazard Code")
    GHSPICTOCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSPictoCode", FieldType.STRING, display_name="GHS Pictogram Codes")
    GHSSIGNAL__FIELD_NAME: Final[WrapperField] = WrapperField("GHSSignal", FieldType.STRING, display_name="GHS Signal")
    HASORSTEREOGROUP__FIELD_NAME: Final[WrapperField] = WrapperField("HasOrStereoGroup", FieldType.BOOLEAN, display_name="Contains OR Stereo")
    IUPAC__FIELD_NAME: Final[WrapperField] = WrapperField("IUPAC", FieldType.STRING, display_name="IUPAC")
    INCHIKEY__FIELD_NAME: Final[WrapperField] = WrapperField("InchiKey", FieldType.STRING, display_name="INCHI Key")
    ISGHSCLASSIFIED__FIELD_NAME: Final[WrapperField] = WrapperField("IsGHSClassified", FieldType.BOOLEAN, display_name="Is GHS Classified")
    LOTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("LotNumber", FieldType.STRING, display_name="Lot Number")
    MOLECULARWEIGHT__FIELD_NAME: Final[WrapperField] = WrapperField("MolecularWeight", FieldType.DOUBLE, display_name="Molecular Weight")
    POLARSURFACEAREA__FIELD_NAME: Final[WrapperField] = WrapperField("PolarSurfaceArea", FieldType.DOUBLE, display_name="Polar Surface Area")
    PUBCHEMCID__FIELD_NAME: Final[WrapperField] = WrapperField("PubchemCid", FieldType.INTEGER, display_name="Pubchem CID")
    PURITY__FIELD_NAME: Final[WrapperField] = WrapperField("Purity", FieldType.DOUBLE, display_name="Purity")
    REGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryId", FieldType.STRING, display_name="Registry ID")
    SMILES__FIELD_NAME: Final[WrapperField] = WrapperField("SMILES", FieldType.STRING, display_name="Canonical SMILES")
    STEREOREGHASH__FIELD_NAME: Final[WrapperField] = WrapperField("StereoRegHash", FieldType.STRING, display_name="Stereo Registration Hash")
    TOTALHBONDACCEPTORS__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondAcceptors", FieldType.INTEGER, display_name="#Hydrogen Bond Acceptors")
    TOTALHBONDCOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondCount", FieldType.INTEGER, display_name="#Hydrogen Bond Donors")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    YIELD__FIELD_NAME: Final[WrapperField] = WrapperField("Yield", FieldType.DOUBLE, display_name="Yield")
    CLOGP__FIELD_NAME: Final[WrapperField] = WrapperField("cLogP", FieldType.DOUBLE, display_name="Calculated cLogP")
    INCHI__FIELD_NAME: Final[WrapperField] = WrapperField("inchi", FieldType.STRING, display_name="INCHI")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_CXSMILESHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'CXSMILESHash' on this record model
        """
        self.set_field_value(self.CXSMILESHASH__FIELD_NAME.field_name, value)

    def get_CXSMILESHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CXSMILESHash' from this record model
        """
        return self.get_field_value(self.CXSMILESHASH__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_HasOrStereoGroup_field(self, value: Optional[bool]):
        """
        Set data field with field name 'HasOrStereoGroup' on this record model
        """
        self.set_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name, value)

    def get_HasOrStereoGroup_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'HasOrStereoGroup' from this record model
        """
        return self.get_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_Purity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Purity' on this record model
        """
        self.set_field_value(self.PURITY__FIELD_NAME.field_name, value)

    def get_Purity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Purity' from this record model
        """
        return self.get_field_value(self.PURITY__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_StereoRegHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'StereoRegHash' on this record model
        """
        self.set_field_value(self.STEREOREGHASH__FIELD_NAME.field_name, value)

    def get_StereoRegHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StereoRegHash' from this record model
        """
        return self.get_field_value(self.STEREOREGHASH__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Yield_field(self, value: Optional[float]):
        """
        Set data field with field name 'Yield' on this record model
        """
        self.set_field_value(self.YIELD__FIELD_NAME.field_name, value)

    def get_Yield_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Yield' from this record model
        """
        return self.get_field_value(self.YIELD__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)


class ChemicalReagentPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemicalReagentPart
    Data Type Display Name: Chemical Reagent Part (Chemical Reagent Parts)
    Fields: ExactMass, PubchemCid, ConsumableType, DateCreated, IsGHSClassified, HasOrStereoGroup, CXSMILESHash, Density, QuantityPerItem, Formula, PolarSurfaceArea, ReorderLevelQuantity, GHSSignal, RegisteredToCartridge, RequestImageUpdate, cLogP, VeloxLastModifiedBy, MolecularWeight, InchiKey, CreatedBy, inchi, EditLock, Charge, IUPAC, SMILES, MOL, Vendor, QuantityOnHand, Units, GHSHazardCode, SMILESShadow, TotalHBondCount, TotalHBondAcceptors, DataRecordName, CAS, VeloxLastModifiedDate, RegistryId, INCHIShadow, StereoRegHash, GHSPictoCode, GHSCautionCode
    """
    DATA_TYPE_NAME: Final[str] = 'ChemicalReagentPart'
    DISPLAY_NAME: Final[str] = "Chemical Reagent Part"
    PLURAL_DISPLAY_NAME: Final[str] = "Chemical Reagent Parts"
    CAS__FIELD_NAME: Final[WrapperField] = WrapperField("CAS", FieldType.STRING, display_name="CAS")
    CXSMILESHASH__FIELD_NAME: Final[WrapperField] = WrapperField("CXSMILESHash", FieldType.STRING, display_name="CXSMILES Hash")
    CHARGE__FIELD_NAME: Final[WrapperField] = WrapperField("Charge", FieldType.INTEGER, display_name="Charge")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DENSITY__FIELD_NAME: Final[WrapperField] = WrapperField("Density", FieldType.DOUBLE, display_name="Density")
    EDITLOCK__FIELD_NAME: Final[WrapperField] = WrapperField("EditLock", FieldType.BOOLEAN, display_name="Edit Lock")
    EXACTMASS__FIELD_NAME: Final[WrapperField] = WrapperField("ExactMass", FieldType.DOUBLE, display_name="Exact Mass")
    FORMULA__FIELD_NAME: Final[WrapperField] = WrapperField("Formula", FieldType.STRING, display_name="Formula")
    GHSCAUTIONCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSCautionCode", FieldType.STRING, display_name="GHS Caution Code")
    GHSHAZARDCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSHazardCode", FieldType.STRING, display_name="GHS Hazard Code")
    GHSPICTOCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSPictoCode", FieldType.STRING, display_name="GHS Pictogram Codes")
    GHSSIGNAL__FIELD_NAME: Final[WrapperField] = WrapperField("GHSSignal", FieldType.STRING, display_name="GHS Signal")
    HASORSTEREOGROUP__FIELD_NAME: Final[WrapperField] = WrapperField("HasOrStereoGroup", FieldType.BOOLEAN, display_name="Contains OR Stereo")
    INCHISHADOW__FIELD_NAME: Final[WrapperField] = WrapperField("INCHIShadow", FieldType.STRING, display_name="INCHI Shadow")
    IUPAC__FIELD_NAME: Final[WrapperField] = WrapperField("IUPAC", FieldType.STRING, display_name="IUPAC")
    INCHIKEY__FIELD_NAME: Final[WrapperField] = WrapperField("InchiKey", FieldType.STRING, display_name="INCHI Key")
    ISGHSCLASSIFIED__FIELD_NAME: Final[WrapperField] = WrapperField("IsGHSClassified", FieldType.BOOLEAN, display_name="Is GHS Classified")
    MOL__FIELD_NAME: Final[WrapperField] = WrapperField("MOL", FieldType.STRING, display_name="MOL")
    MOLECULARWEIGHT__FIELD_NAME: Final[WrapperField] = WrapperField("MolecularWeight", FieldType.DOUBLE, display_name="Molecular Weight")
    POLARSURFACEAREA__FIELD_NAME: Final[WrapperField] = WrapperField("PolarSurfaceArea", FieldType.DOUBLE, display_name="Polar Surface Area")
    PUBCHEMCID__FIELD_NAME: Final[WrapperField] = WrapperField("PubchemCid", FieldType.INTEGER, display_name="Pubchem CID")
    QUANTITYONHAND__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityOnHand", FieldType.DOUBLE, display_name="Quantity / Volume On Hand")
    QUANTITYPERITEM__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityPerItem", FieldType.DOUBLE, display_name="Quantity / Volume Per Item")
    REGISTEREDTOCARTRIDGE__FIELD_NAME: Final[WrapperField] = WrapperField("RegisteredToCartridge", FieldType.BOOLEAN, display_name="Registered To Cartridge")
    REGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryId", FieldType.STRING, display_name="Registry ID")
    REORDERLEVELQUANTITY__FIELD_NAME: Final[WrapperField] = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE, display_name="Reorder Level Quantity")
    REQUESTIMAGEUPDATE__FIELD_NAME: Final[WrapperField] = WrapperField("RequestImageUpdate", FieldType.BOOLEAN, display_name="Request Image Update")
    SMILES__FIELD_NAME: Final[WrapperField] = WrapperField("SMILES", FieldType.STRING, display_name="Canonical SMILES")
    SMILESSHADOW__FIELD_NAME: Final[WrapperField] = WrapperField("SMILESShadow", FieldType.STRING, display_name="SMILES Shadow")
    STEREOREGHASH__FIELD_NAME: Final[WrapperField] = WrapperField("StereoRegHash", FieldType.STRING, display_name="Stereo Registration Hash")
    TOTALHBONDACCEPTORS__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondAcceptors", FieldType.INTEGER, display_name="#Hydrogen Bond Acceptors")
    TOTALHBONDCOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondCount", FieldType.INTEGER, display_name="#Hydrogen Bond Donors")
    UNITS__FIELD_NAME: Final[WrapperField] = WrapperField("Units", FieldType.PICKLIST, display_name="Units")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VENDOR__FIELD_NAME: Final[WrapperField] = WrapperField("Vendor", FieldType.SELECTION, display_name="Vendor")
    CLOGP__FIELD_NAME: Final[WrapperField] = WrapperField("cLogP", FieldType.DOUBLE, display_name="Calculated cLogP")
    INCHI__FIELD_NAME: Final[WrapperField] = WrapperField("inchi", FieldType.STRING, display_name="INCHI")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_CXSMILESHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'CXSMILESHash' on this record model
        """
        self.set_field_value(self.CXSMILESHASH__FIELD_NAME.field_name, value)

    def get_CXSMILESHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CXSMILESHash' from this record model
        """
        return self.get_field_value(self.CXSMILESHASH__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Density_field(self, value: Optional[float]):
        """
        Set data field with field name 'Density' on this record model
        """
        self.set_field_value(self.DENSITY__FIELD_NAME.field_name, value)

    def get_Density_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Density' from this record model
        """
        return self.get_field_value(self.DENSITY__FIELD_NAME.field_name)

    def set_EditLock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EditLock' on this record model
        """
        self.set_field_value(self.EDITLOCK__FIELD_NAME.field_name, value)

    def get_EditLock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EditLock' from this record model
        """
        return self.get_field_value(self.EDITLOCK__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_HasOrStereoGroup_field(self, value: Optional[bool]):
        """
        Set data field with field name 'HasOrStereoGroup' on this record model
        """
        self.set_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name, value)

    def get_HasOrStereoGroup_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'HasOrStereoGroup' from this record model
        """
        return self.get_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name)

    def set_INCHIShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'INCHIShadow' on this record model
        """
        self.set_field_value(self.INCHISHADOW__FIELD_NAME.field_name, value)

    def get_INCHIShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'INCHIShadow' from this record model
        """
        return self.get_field_value(self.INCHISHADOW__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_MOL_field(self, value: Optional[str]):
        """
        Set data field with field name 'MOL' on this record model
        """
        self.set_field_value(self.MOL__FIELD_NAME.field_name, value)

    def get_MOL_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MOL' from this record model
        """
        return self.get_field_value(self.MOL__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_RegisteredToCartridge_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RegisteredToCartridge' on this record model
        """
        self.set_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name, value)

    def get_RegisteredToCartridge_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RegisteredToCartridge' from this record model
        """
        return self.get_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_RequestImageUpdate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RequestImageUpdate' on this record model
        """
        self.set_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name, value)

    def get_RequestImageUpdate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RequestImageUpdate' from this record model
        """
        return self.get_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_SMILESShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILESShadow' on this record model
        """
        self.set_field_value(self.SMILESSHADOW__FIELD_NAME.field_name, value)

    def get_SMILESShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILESShadow' from this record model
        """
        return self.get_field_value(self.SMILESSHADOW__FIELD_NAME.field_name)

    def set_StereoRegHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'StereoRegHash' on this record model
        """
        self.set_field_value(self.STEREOREGHASH__FIELD_NAME.field_name, value)

    def get_StereoRegHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StereoRegHash' from this record model
        """
        return self.get_field_value(self.STEREOREGHASH__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)


class ChemistryMaterialTypeSettingsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemistryMaterialTypeSettings
    Data Type Display Name: Chemistry Material Type Settings (Chemistry Material Type Settingses)
    Fields: ManualStereoResolution, ReactionReactant, EnableEnhancedStereochemistry, LockedFieldsOverride, CreatedBy, ThreeTier, SaltPaddings, SaltMode, DateCreated, AccessionPaddings, ReactionProduct, DataRecordName, ResolveCanonicalTautomer, ManagerGroups, VeloxLastModifiedDate, VeloxLastModifiedBy, AccessionCode, RegistryDataType, SystemDefined, AccessionStartingValue
    """
    DATA_TYPE_NAME: Final[str] = 'ChemistryMaterialTypeSettings'
    DISPLAY_NAME: Final[str] = "Chemistry Material Type Settings"
    PLURAL_DISPLAY_NAME: Final[str] = "Chemistry Material Type Settingses"
    ACCESSIONCODE__FIELD_NAME: Final[WrapperField] = WrapperField("AccessionCode", FieldType.STRING, display_name="Accession Code")
    ACCESSIONPADDINGS__FIELD_NAME: Final[WrapperField] = WrapperField("AccessionPaddings", FieldType.INTEGER, display_name="Accession Paddings")
    ACCESSIONSTARTINGVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("AccessionStartingValue", FieldType.INTEGER, display_name="Accession Starting Value")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    ENABLEENHANCEDSTEREOCHEMISTRY__FIELD_NAME: Final[WrapperField] = WrapperField("EnableEnhancedStereochemistry", FieldType.BOOLEAN, display_name="Enable Enhanced Stereochemistry")
    LOCKEDFIELDSOVERRIDE__FIELD_NAME: Final[WrapperField] = WrapperField("LockedFieldsOverride", FieldType.SELECTION, display_name="Locked Fields Override")
    MANAGERGROUPS__FIELD_NAME: Final[WrapperField] = WrapperField("ManagerGroups", FieldType.SELECTION, display_name="Manager Groups")
    MANUALSTEREORESOLUTION__FIELD_NAME: Final[WrapperField] = WrapperField("ManualStereoResolution", FieldType.BOOLEAN, display_name="Manual Stereo Resolution")
    REACTIONPRODUCT__FIELD_NAME: Final[WrapperField] = WrapperField("ReactionProduct", FieldType.BOOLEAN, display_name="Reaction Product")
    REACTIONREACTANT__FIELD_NAME: Final[WrapperField] = WrapperField("ReactionReactant", FieldType.BOOLEAN, display_name="Reaction Reactant")
    REGISTRYDATATYPE__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryDataType", FieldType.SELECTION, display_name="Registry Data Type")
    RESOLVECANONICALTAUTOMER__FIELD_NAME: Final[WrapperField] = WrapperField("ResolveCanonicalTautomer", FieldType.BOOLEAN, display_name="Resolve Canonical Tautomer")
    SALTMODE__FIELD_NAME: Final[WrapperField] = WrapperField("SaltMode", FieldType.PICKLIST, display_name="Salt Mode")
    SALTPADDINGS__FIELD_NAME: Final[WrapperField] = WrapperField("SaltPaddings", FieldType.INTEGER, display_name="Salt Paddings")
    SYSTEMDEFINED__FIELD_NAME: Final[WrapperField] = WrapperField("SystemDefined", FieldType.BOOLEAN, display_name="System Defined")
    THREETIER__FIELD_NAME: Final[WrapperField] = WrapperField("ThreeTier", FieldType.BOOLEAN, display_name="Three Tier")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AccessionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'AccessionCode' on this record model
        """
        self.set_field_value(self.ACCESSIONCODE__FIELD_NAME.field_name, value)

    def get_AccessionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AccessionCode' from this record model
        """
        return self.get_field_value(self.ACCESSIONCODE__FIELD_NAME.field_name)

    def set_AccessionPaddings_field(self, value: Optional[int]):
        """
        Set data field with field name 'AccessionPaddings' on this record model
        """
        self.set_field_value(self.ACCESSIONPADDINGS__FIELD_NAME.field_name, value)

    def get_AccessionPaddings_field(self) -> Optional[int]:
        """
        Get data field value with field name 'AccessionPaddings' from this record model
        """
        return self.get_field_value(self.ACCESSIONPADDINGS__FIELD_NAME.field_name)

    def set_AccessionStartingValue_field(self, value: Optional[int]):
        """
        Set data field with field name 'AccessionStartingValue' on this record model
        """
        self.set_field_value(self.ACCESSIONSTARTINGVALUE__FIELD_NAME.field_name, value)

    def get_AccessionStartingValue_field(self) -> Optional[int]:
        """
        Get data field value with field name 'AccessionStartingValue' from this record model
        """
        return self.get_field_value(self.ACCESSIONSTARTINGVALUE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EnableEnhancedStereochemistry_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableEnhancedStereochemistry' on this record model
        """
        self.set_field_value(self.ENABLEENHANCEDSTEREOCHEMISTRY__FIELD_NAME.field_name, value)

    def get_EnableEnhancedStereochemistry_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableEnhancedStereochemistry' from this record model
        """
        return self.get_field_value(self.ENABLEENHANCEDSTEREOCHEMISTRY__FIELD_NAME.field_name)

    def set_LockedFieldsOverride_field(self, value: Optional[str]):
        """
        Set data field with field name 'LockedFieldsOverride' on this record model
        """
        self.set_field_value(self.LOCKEDFIELDSOVERRIDE__FIELD_NAME.field_name, value)

    def get_LockedFieldsOverride_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LockedFieldsOverride' from this record model
        """
        return self.get_field_value(self.LOCKEDFIELDSOVERRIDE__FIELD_NAME.field_name)

    def set_ManagerGroups_field(self, value: Optional[str]):
        """
        Set data field with field name 'ManagerGroups' on this record model
        """
        self.set_field_value(self.MANAGERGROUPS__FIELD_NAME.field_name, value)

    def get_ManagerGroups_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ManagerGroups' from this record model
        """
        return self.get_field_value(self.MANAGERGROUPS__FIELD_NAME.field_name)

    def set_ManualStereoResolution_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ManualStereoResolution' on this record model
        """
        self.set_field_value(self.MANUALSTEREORESOLUTION__FIELD_NAME.field_name, value)

    def get_ManualStereoResolution_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ManualStereoResolution' from this record model
        """
        return self.get_field_value(self.MANUALSTEREORESOLUTION__FIELD_NAME.field_name)

    def set_ReactionProduct_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ReactionProduct' on this record model
        """
        self.set_field_value(self.REACTIONPRODUCT__FIELD_NAME.field_name, value)

    def get_ReactionProduct_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ReactionProduct' from this record model
        """
        return self.get_field_value(self.REACTIONPRODUCT__FIELD_NAME.field_name)

    def set_ReactionReactant_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ReactionReactant' on this record model
        """
        self.set_field_value(self.REACTIONREACTANT__FIELD_NAME.field_name, value)

    def get_ReactionReactant_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ReactionReactant' from this record model
        """
        return self.get_field_value(self.REACTIONREACTANT__FIELD_NAME.field_name)

    def set_RegistryDataType_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryDataType' on this record model
        """
        self.set_field_value(self.REGISTRYDATATYPE__FIELD_NAME.field_name, value)

    def get_RegistryDataType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryDataType' from this record model
        """
        return self.get_field_value(self.REGISTRYDATATYPE__FIELD_NAME.field_name)

    def set_ResolveCanonicalTautomer_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ResolveCanonicalTautomer' on this record model
        """
        self.set_field_value(self.RESOLVECANONICALTAUTOMER__FIELD_NAME.field_name, value)

    def get_ResolveCanonicalTautomer_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ResolveCanonicalTautomer' from this record model
        """
        return self.get_field_value(self.RESOLVECANONICALTAUTOMER__FIELD_NAME.field_name)

    def set_SaltMode_field(self, value: Optional[str]):
        """
        Set data field with field name 'SaltMode' on this record model
        """
        self.set_field_value(self.SALTMODE__FIELD_NAME.field_name, value)

    def get_SaltMode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SaltMode' from this record model
        """
        return self.get_field_value(self.SALTMODE__FIELD_NAME.field_name)

    def set_SaltPaddings_field(self, value: Optional[int]):
        """
        Set data field with field name 'SaltPaddings' on this record model
        """
        self.set_field_value(self.SALTPADDINGS__FIELD_NAME.field_name, value)

    def get_SaltPaddings_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SaltPaddings' from this record model
        """
        return self.get_field_value(self.SALTPADDINGS__FIELD_NAME.field_name)

    def set_SystemDefined_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SystemDefined' on this record model
        """
        self.set_field_value(self.SYSTEMDEFINED__FIELD_NAME.field_name, value)

    def get_SystemDefined_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SystemDefined' from this record model
        """
        return self.get_field_value(self.SYSTEMDEFINED__FIELD_NAME.field_name)

    def set_ThreeTier_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ThreeTier' on this record model
        """
        self.set_field_value(self.THREETIER__FIELD_NAME.field_name, value)

    def get_ThreeTier_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ThreeTier' from this record model
        """
        return self.get_field_value(self.THREETIER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ChemReactionDataFileModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemReactionDataFile
    Data Type Display Name: Chem Reaction Data File (Chem Reaction Data Files)
    Fields: FilePath, CreatedBy, VeloxCurrentVersion, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated
    Describes raw chemical reaction data of the parent reaction data type.
    """
    DATA_TYPE_NAME: Final[str] = 'ChemReactionDataFile'
    DISPLAY_NAME: Final[str] = "Chem Reaction Data File"
    PLURAL_DISPLAY_NAME: Final[str] = "Chem Reaction Data Files"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ChemRegistrySavedFieldMapModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemRegistrySavedFieldMap
    Data Type Display Name: Chem Registry Saved Field Map (Chem Registry Saved Field Maps)
    Fields: FilePath, VeloxCurrentVersion, CreatedBy, FieldMapDataTypeName, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, Name
    Saved field maps for people to use in importing CSV and SDF files.
    """
    DATA_TYPE_NAME: Final[str] = 'ChemRegistrySavedFieldMap'
    DISPLAY_NAME: Final[str] = "Chem Registry Saved Field Map"
    PLURAL_DISPLAY_NAME: Final[str] = "Chem Registry Saved Field Maps"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FIELDMAPDATATYPENAME__FIELD_NAME: Final[WrapperField] = WrapperField("FieldMapDataTypeName", FieldType.STRING, display_name="Data Type Name")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    NAME__FIELD_NAME: Final[WrapperField] = WrapperField("Name", FieldType.STRING, display_name="Name")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FieldMapDataTypeName_field(self, value: Optional[str]):
        """
        Set data field with field name 'FieldMapDataTypeName' on this record model
        """
        self.set_field_value(self.FIELDMAPDATATYPENAME__FIELD_NAME.field_name, value)

    def get_FieldMapDataTypeName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FieldMapDataTypeName' from this record model
        """
        return self.get_field_value(self.FIELDMAPDATATYPENAME__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ChemRegPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemRegPart
    Data Type Display Name: Company X Reagent Part (Company X Reagent Parts)
    Fields: ExactMass, PubchemCid, ConsumableType, Purity, DateCreated, IsGHSClassified, Formula, PolarSurfaceArea, GHSSignal, cLogP, VeloxLastModifiedBy, MolecularWeight, InchiKey, LotNumber, CreatedBy, inchi, Charge, IUPAC, SMILES, GHSHazardCode, TotalHBondCount, TotalHBondAcceptors, DataRecordName, CAS, VeloxLastModifiedDate, RegistryId, Yield, GHSPictoCode, GHSCautionCode
    The ChemRegPart Data Type
    """
    DATA_TYPE_NAME: Final[str] = 'ChemRegPart'
    DISPLAY_NAME: Final[str] = "Company X Reagent Part"
    PLURAL_DISPLAY_NAME: Final[str] = "Company X Reagent Parts"
    CAS__FIELD_NAME: Final[WrapperField] = WrapperField("CAS", FieldType.STRING, display_name="CAS")
    CHARGE__FIELD_NAME: Final[WrapperField] = WrapperField("Charge", FieldType.INTEGER, display_name="Charge")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EXACTMASS__FIELD_NAME: Final[WrapperField] = WrapperField("ExactMass", FieldType.DOUBLE, display_name="Exact Mass")
    FORMULA__FIELD_NAME: Final[WrapperField] = WrapperField("Formula", FieldType.STRING, display_name="Formula")
    GHSCAUTIONCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSCautionCode", FieldType.STRING, display_name="GHS Caution Code")
    GHSHAZARDCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSHazardCode", FieldType.STRING, display_name="GHS Hazard Code")
    GHSPICTOCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSPictoCode", FieldType.STRING, display_name="GHS Pictogram Codes")
    GHSSIGNAL__FIELD_NAME: Final[WrapperField] = WrapperField("GHSSignal", FieldType.STRING, display_name="GHS Signal")
    IUPAC__FIELD_NAME: Final[WrapperField] = WrapperField("IUPAC", FieldType.STRING, display_name="IUPAC")
    INCHIKEY__FIELD_NAME: Final[WrapperField] = WrapperField("InchiKey", FieldType.STRING, display_name="InChI Key")
    ISGHSCLASSIFIED__FIELD_NAME: Final[WrapperField] = WrapperField("IsGHSClassified", FieldType.BOOLEAN, display_name="Is GHS Classified")
    LOTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("LotNumber", FieldType.STRING, display_name="Lot Number")
    MOLECULARWEIGHT__FIELD_NAME: Final[WrapperField] = WrapperField("MolecularWeight", FieldType.DOUBLE, display_name="Molecular Weight")
    POLARSURFACEAREA__FIELD_NAME: Final[WrapperField] = WrapperField("PolarSurfaceArea", FieldType.DOUBLE, display_name="Polar Surface Area")
    PUBCHEMCID__FIELD_NAME: Final[WrapperField] = WrapperField("PubchemCid", FieldType.INTEGER, display_name="PubChem CID")
    PURITY__FIELD_NAME: Final[WrapperField] = WrapperField("Purity", FieldType.DOUBLE, display_name="Purity")
    REGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryId", FieldType.STRING, display_name="Registry ID")
    SMILES__FIELD_NAME: Final[WrapperField] = WrapperField("SMILES", FieldType.STRING, display_name="Canonical SMILES")
    TOTALHBONDACCEPTORS__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondAcceptors", FieldType.INTEGER, display_name="#Hydrogen Bond Acceptors")
    TOTALHBONDCOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondCount", FieldType.INTEGER, display_name="#Hydrogen Bond Donors")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    YIELD__FIELD_NAME: Final[WrapperField] = WrapperField("Yield", FieldType.DOUBLE, display_name="Yield")
    CLOGP__FIELD_NAME: Final[WrapperField] = WrapperField("cLogP", FieldType.DOUBLE, display_name="Calculated cLogP")
    INCHI__FIELD_NAME: Final[WrapperField] = WrapperField("inchi", FieldType.STRING, display_name="InChI")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_Purity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Purity' on this record model
        """
        self.set_field_value(self.PURITY__FIELD_NAME.field_name, value)

    def get_Purity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Purity' from this record model
        """
        return self.get_field_value(self.PURITY__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Yield_field(self, value: Optional[float]):
        """
        Set data field with field name 'Yield' on this record model
        """
        self.set_field_value(self.YIELD__FIELD_NAME.field_name, value)

    def get_Yield_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Yield' from this record model
        """
        return self.get_field_value(self.YIELD__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)


class ChemRegPartPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ChemRegPartPart
    Data Type Display Name: Company X Reagent (Company X Reagents)
    Fields: ExactMass, PubchemCid, ConsumableType, DateCreated, IsGHSClassified, QuantityPerItem, Formula, PolarSurfaceArea, ReorderLevelQuantity, GHSSignal, RegisteredToCartridge, RequestImageUpdate, cLogP, VeloxLastModifiedBy, MolecularWeight, InchiKey, CreatedBy, inchi, EditLock, Charge, IUPAC, SMILES, MOL, QuantityOnHand, Units, GHSHazardCode, SMILESShadow, TotalHBondCount, TotalHBondAcceptors, DataRecordName, CAS, VeloxLastModifiedDate, RegistryId, INCHIShadow, GHSPictoCode, GHSCautionCode
    The ChemRegPartPart Data Type
    """
    DATA_TYPE_NAME: Final[str] = 'ChemRegPartPart'
    DISPLAY_NAME: Final[str] = "Company X Reagent"
    PLURAL_DISPLAY_NAME: Final[str] = "Company X Reagents"
    CAS__FIELD_NAME: Final[WrapperField] = WrapperField("CAS", FieldType.STRING, display_name="CAS")
    CHARGE__FIELD_NAME: Final[WrapperField] = WrapperField("Charge", FieldType.INTEGER, display_name="Charge")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EDITLOCK__FIELD_NAME: Final[WrapperField] = WrapperField("EditLock", FieldType.BOOLEAN, display_name="Edit Lock")
    EXACTMASS__FIELD_NAME: Final[WrapperField] = WrapperField("ExactMass", FieldType.DOUBLE, display_name="Exact Mass")
    FORMULA__FIELD_NAME: Final[WrapperField] = WrapperField("Formula", FieldType.STRING, display_name="Formula")
    GHSCAUTIONCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSCautionCode", FieldType.STRING, display_name="GHS Caution Code")
    GHSHAZARDCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSHazardCode", FieldType.STRING, display_name="GHS Hazard Code")
    GHSPICTOCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSPictoCode", FieldType.STRING, display_name="GHS Pictogram Codes")
    GHSSIGNAL__FIELD_NAME: Final[WrapperField] = WrapperField("GHSSignal", FieldType.STRING, display_name="GHS Signal")
    INCHISHADOW__FIELD_NAME: Final[WrapperField] = WrapperField("INCHIShadow", FieldType.STRING, display_name="InChI Shadow")
    IUPAC__FIELD_NAME: Final[WrapperField] = WrapperField("IUPAC", FieldType.STRING, display_name="IUPAC")
    INCHIKEY__FIELD_NAME: Final[WrapperField] = WrapperField("InchiKey", FieldType.STRING, display_name="InChI Key")
    ISGHSCLASSIFIED__FIELD_NAME: Final[WrapperField] = WrapperField("IsGHSClassified", FieldType.BOOLEAN, display_name="Is GHS Classified")
    MOL__FIELD_NAME: Final[WrapperField] = WrapperField("MOL", FieldType.STRING, display_name="MOL")
    MOLECULARWEIGHT__FIELD_NAME: Final[WrapperField] = WrapperField("MolecularWeight", FieldType.DOUBLE, display_name="Molecular Weight")
    POLARSURFACEAREA__FIELD_NAME: Final[WrapperField] = WrapperField("PolarSurfaceArea", FieldType.DOUBLE, display_name="Polar Surface Area")
    PUBCHEMCID__FIELD_NAME: Final[WrapperField] = WrapperField("PubchemCid", FieldType.INTEGER, display_name="PubChem CID")
    QUANTITYONHAND__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityOnHand", FieldType.DOUBLE, display_name="Quantity / Volume On Hand")
    QUANTITYPERITEM__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityPerItem", FieldType.DOUBLE, display_name="Quantity / Volume Per Item")
    REGISTEREDTOCARTRIDGE__FIELD_NAME: Final[WrapperField] = WrapperField("RegisteredToCartridge", FieldType.BOOLEAN, display_name="Registered To Cartridge")
    REGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryId", FieldType.STRING, display_name="Registry ID")
    REORDERLEVELQUANTITY__FIELD_NAME: Final[WrapperField] = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE, display_name="Reorder Level Quantity")
    REQUESTIMAGEUPDATE__FIELD_NAME: Final[WrapperField] = WrapperField("RequestImageUpdate", FieldType.BOOLEAN, display_name="Request Image Update")
    SMILES__FIELD_NAME: Final[WrapperField] = WrapperField("SMILES", FieldType.STRING, display_name="Canonical SMILES")
    SMILESSHADOW__FIELD_NAME: Final[WrapperField] = WrapperField("SMILESShadow", FieldType.STRING, display_name="SMILES Shadow")
    TOTALHBONDACCEPTORS__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondAcceptors", FieldType.INTEGER, display_name="#Hydrogen Bond Acceptors")
    TOTALHBONDCOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondCount", FieldType.INTEGER, display_name="#Hydrogen Bond Donors")
    UNITS__FIELD_NAME: Final[WrapperField] = WrapperField("Units", FieldType.PICKLIST, display_name="Units")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    CLOGP__FIELD_NAME: Final[WrapperField] = WrapperField("cLogP", FieldType.DOUBLE, display_name="Calculated cLogP")
    INCHI__FIELD_NAME: Final[WrapperField] = WrapperField("inchi", FieldType.STRING, display_name="InChI")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EditLock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EditLock' on this record model
        """
        self.set_field_value(self.EDITLOCK__FIELD_NAME.field_name, value)

    def get_EditLock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EditLock' from this record model
        """
        return self.get_field_value(self.EDITLOCK__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_INCHIShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'INCHIShadow' on this record model
        """
        self.set_field_value(self.INCHISHADOW__FIELD_NAME.field_name, value)

    def get_INCHIShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'INCHIShadow' from this record model
        """
        return self.get_field_value(self.INCHISHADOW__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_MOL_field(self, value: Optional[str]):
        """
        Set data field with field name 'MOL' on this record model
        """
        self.set_field_value(self.MOL__FIELD_NAME.field_name, value)

    def get_MOL_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MOL' from this record model
        """
        return self.get_field_value(self.MOL__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_RegisteredToCartridge_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RegisteredToCartridge' on this record model
        """
        self.set_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name, value)

    def get_RegisteredToCartridge_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RegisteredToCartridge' from this record model
        """
        return self.get_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_RequestImageUpdate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RequestImageUpdate' on this record model
        """
        self.set_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name, value)

    def get_RequestImageUpdate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RequestImageUpdate' from this record model
        """
        return self.get_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_SMILESShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILESShadow' on this record model
        """
        self.set_field_value(self.SMILESSHADOW__FIELD_NAME.field_name, value)

    def get_SMILESShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILESShadow' from this record model
        """
        return self.get_field_value(self.SMILESSHADOW__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)


class ClientConfigurationsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ClientConfigurations
    Data Type Display Name: Client Configurations (Client Configurations)
    Fields: CreatedBy, COMWebServiceApiKey, ReportingUserPassword, ReportingWebServiceHost, DateCreated, COMWebServiceUrl, COMWebServiceAccountName, ReportingWebServicePort, DataRecordName, SampleSheetPathForPacBio, COMWebServiceGuid, VeloxLastModifiedDate, VeloxLastModifiedBy, ReportingWebServiceName, ReportingWebServiceUserName, SampleSheetPath
    Client specific configurations.
    """
    DATA_TYPE_NAME: Final[str] = 'ClientConfigurations'
    DISPLAY_NAME: Final[str] = "Client Configurations"
    PLURAL_DISPLAY_NAME: Final[str] = "Client Configurations"
    COMWEBSERVICEACCOUNTNAME__FIELD_NAME: Final[WrapperField] = WrapperField("COMWebServiceAccountName", FieldType.STRING, display_name="COM Web Service Account Name")
    COMWEBSERVICEAPIKEY__FIELD_NAME: Final[WrapperField] = WrapperField("COMWebServiceApiKey", FieldType.STRING, display_name="COM Web Service Api Key")
    COMWEBSERVICEGUID__FIELD_NAME: Final[WrapperField] = WrapperField("COMWebServiceGuid", FieldType.STRING, display_name="COM Web Service Guid")
    COMWEBSERVICEURL__FIELD_NAME: Final[WrapperField] = WrapperField("COMWebServiceUrl", FieldType.STRING, display_name="COM Web Service Url")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    REPORTINGUSERPASSWORD__FIELD_NAME: Final[WrapperField] = WrapperField("ReportingUserPassword", FieldType.STRING, display_name="Reporting Web Service User Password")
    REPORTINGWEBSERVICEHOST__FIELD_NAME: Final[WrapperField] = WrapperField("ReportingWebServiceHost", FieldType.STRING, display_name="Reporting Web Service Host")
    REPORTINGWEBSERVICENAME__FIELD_NAME: Final[WrapperField] = WrapperField("ReportingWebServiceName", FieldType.STRING, display_name="Reporting Web Service Name")
    REPORTINGWEBSERVICEPORT__FIELD_NAME: Final[WrapperField] = WrapperField("ReportingWebServicePort", FieldType.INTEGER, display_name="Reporting Web Service Port")
    REPORTINGWEBSERVICEUSERNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ReportingWebServiceUserName", FieldType.STRING, display_name="Reporting Web Service User Name")
    SAMPLESHEETPATH__FIELD_NAME: Final[WrapperField] = WrapperField("SampleSheetPath", FieldType.STRING, display_name="Sample Sheet Path")
    SAMPLESHEETPATHFORPACBIO__FIELD_NAME: Final[WrapperField] = WrapperField("SampleSheetPathForPacBio", FieldType.STRING, display_name="Sample Sheet Path for PacBio")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_COMWebServiceAccountName_field(self, value: Optional[str]):
        """
        Set data field with field name 'COMWebServiceAccountName' on this record model
        """
        self.set_field_value(self.COMWEBSERVICEACCOUNTNAME__FIELD_NAME.field_name, value)

    def get_COMWebServiceAccountName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'COMWebServiceAccountName' from this record model
        """
        return self.get_field_value(self.COMWEBSERVICEACCOUNTNAME__FIELD_NAME.field_name)

    def set_COMWebServiceApiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'COMWebServiceApiKey' on this record model
        """
        self.set_field_value(self.COMWEBSERVICEAPIKEY__FIELD_NAME.field_name, value)

    def get_COMWebServiceApiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'COMWebServiceApiKey' from this record model
        """
        return self.get_field_value(self.COMWEBSERVICEAPIKEY__FIELD_NAME.field_name)

    def set_COMWebServiceGuid_field(self, value: Optional[str]):
        """
        Set data field with field name 'COMWebServiceGuid' on this record model
        """
        self.set_field_value(self.COMWEBSERVICEGUID__FIELD_NAME.field_name, value)

    def get_COMWebServiceGuid_field(self) -> Optional[str]:
        """
        Get data field value with field name 'COMWebServiceGuid' from this record model
        """
        return self.get_field_value(self.COMWEBSERVICEGUID__FIELD_NAME.field_name)

    def set_COMWebServiceUrl_field(self, value: Optional[str]):
        """
        Set data field with field name 'COMWebServiceUrl' on this record model
        """
        self.set_field_value(self.COMWEBSERVICEURL__FIELD_NAME.field_name, value)

    def get_COMWebServiceUrl_field(self) -> Optional[str]:
        """
        Get data field value with field name 'COMWebServiceUrl' from this record model
        """
        return self.get_field_value(self.COMWEBSERVICEURL__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ReportingUserPassword_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReportingUserPassword' on this record model
        """
        self.set_field_value(self.REPORTINGUSERPASSWORD__FIELD_NAME.field_name, value)

    def get_ReportingUserPassword_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReportingUserPassword' from this record model
        """
        return self.get_field_value(self.REPORTINGUSERPASSWORD__FIELD_NAME.field_name)

    def set_ReportingWebServiceHost_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReportingWebServiceHost' on this record model
        """
        self.set_field_value(self.REPORTINGWEBSERVICEHOST__FIELD_NAME.field_name, value)

    def get_ReportingWebServiceHost_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReportingWebServiceHost' from this record model
        """
        return self.get_field_value(self.REPORTINGWEBSERVICEHOST__FIELD_NAME.field_name)

    def set_ReportingWebServiceName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReportingWebServiceName' on this record model
        """
        self.set_field_value(self.REPORTINGWEBSERVICENAME__FIELD_NAME.field_name, value)

    def get_ReportingWebServiceName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReportingWebServiceName' from this record model
        """
        return self.get_field_value(self.REPORTINGWEBSERVICENAME__FIELD_NAME.field_name)

    def set_ReportingWebServicePort_field(self, value: Optional[int]):
        """
        Set data field with field name 'ReportingWebServicePort' on this record model
        """
        self.set_field_value(self.REPORTINGWEBSERVICEPORT__FIELD_NAME.field_name, value)

    def get_ReportingWebServicePort_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ReportingWebServicePort' from this record model
        """
        return self.get_field_value(self.REPORTINGWEBSERVICEPORT__FIELD_NAME.field_name)

    def set_ReportingWebServiceUserName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReportingWebServiceUserName' on this record model
        """
        self.set_field_value(self.REPORTINGWEBSERVICEUSERNAME__FIELD_NAME.field_name, value)

    def get_ReportingWebServiceUserName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReportingWebServiceUserName' from this record model
        """
        return self.get_field_value(self.REPORTINGWEBSERVICEUSERNAME__FIELD_NAME.field_name)

    def set_SampleSheetPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleSheetPath' on this record model
        """
        self.set_field_value(self.SAMPLESHEETPATH__FIELD_NAME.field_name, value)

    def get_SampleSheetPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleSheetPath' from this record model
        """
        return self.get_field_value(self.SAMPLESHEETPATH__FIELD_NAME.field_name)

    def set_SampleSheetPathForPacBio_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleSheetPathForPacBio' on this record model
        """
        self.set_field_value(self.SAMPLESHEETPATHFORPACBIO__FIELD_NAME.field_name, value)

    def get_SampleSheetPathForPacBio_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleSheetPathForPacBio' from this record model
        """
        return self.get_field_value(self.SAMPLESHEETPATHFORPACBIO__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ClinicalObservationModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ClinicalObservation
    Data Type Display Name: Clinical Observation (Clinical Observations)
    Fields: Site, Status, CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, Severity, Symptom
    """
    DATA_TYPE_NAME: Final[str] = 'ClinicalObservation'
    DISPLAY_NAME: Final[str] = "Clinical Observation"
    PLURAL_DISPLAY_NAME: Final[str] = "Clinical Observations"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    SEVERITY__FIELD_NAME: Final[WrapperField] = WrapperField("Severity", FieldType.PICKLIST, display_name="Severity")
    SITE__FIELD_NAME: Final[WrapperField] = WrapperField("Site", FieldType.PICKLIST, display_name="Site")
    STATUS__FIELD_NAME: Final[WrapperField] = WrapperField("Status", FieldType.PICKLIST, display_name="Status")
    SYMPTOM__FIELD_NAME: Final[WrapperField] = WrapperField("Symptom", FieldType.PICKLIST, display_name="Symptom")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Severity_field(self, value: Optional[str]):
        """
        Set data field with field name 'Severity' on this record model
        """
        self.set_field_value(self.SEVERITY__FIELD_NAME.field_name, value)

    def get_Severity_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Severity' from this record model
        """
        return self.get_field_value(self.SEVERITY__FIELD_NAME.field_name)

    def set_Site_field(self, value: Optional[str]):
        """
        Set data field with field name 'Site' on this record model
        """
        self.set_field_value(self.SITE__FIELD_NAME.field_name, value)

    def get_Site_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Site' from this record model
        """
        return self.get_field_value(self.SITE__FIELD_NAME.field_name)

    def set_Status_field(self, value: Optional[str]):
        """
        Set data field with field name 'Status' on this record model
        """
        self.set_field_value(self.STATUS__FIELD_NAME.field_name, value)

    def get_Status_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Status' from this record model
        """
        return self.get_field_value(self.STATUS__FIELD_NAME.field_name)

    def set_Symptom_field(self, value: Optional[str]):
        """
        Set data field with field name 'Symptom' on this record model
        """
        self.set_field_value(self.SYMPTOM__FIELD_NAME.field_name, value)

    def get_Symptom_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Symptom' from this record model
        """
        return self.get_field_value(self.SYMPTOM__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ClusterDetailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ClusterDetail
    Data Type Display Name: Tile Details (Tile Details)
    Fields: CreatedBy, PassedClustersInAllTiles, TotalClustersInAllTiles, LaneCol, Lane, DateCreated, ClusterPassingFilter, ClusterPercentFilter, AlignedPM, PassingPlusMinus, ColRead, PFPercentPM, Tiles, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, Aligned, DensityPlusMinus, ClusterDensity
     <!-- DISPLAY IN INSTRUMENT RUN MONITOR -->
    """
    DATA_TYPE_NAME: Final[str] = 'ClusterDetail'
    DISPLAY_NAME: Final[str] = "Tile Details"
    PLURAL_DISPLAY_NAME: Final[str] = "Tile Details"
    ALIGNED__FIELD_NAME: Final[WrapperField] = WrapperField("Aligned", FieldType.DOUBLE, display_name="Aligned (%)")
    ALIGNEDPM__FIELD_NAME: Final[WrapperField] = WrapperField("AlignedPM", FieldType.DOUBLE, display_name="Aligned +/- (%)")
    CLUSTERDENSITY__FIELD_NAME: Final[WrapperField] = WrapperField("ClusterDensity", FieldType.DOUBLE, display_name="Cluster Density (K/mm2)")
    CLUSTERPASSINGFILTER__FIELD_NAME: Final[WrapperField] = WrapperField("ClusterPassingFilter", FieldType.DOUBLE, display_name="Cluster Passing Filter (K)")
    CLUSTERPERCENTFILTER__FIELD_NAME: Final[WrapperField] = WrapperField("ClusterPercentFilter", FieldType.DOUBLE, display_name="% Clusters Passed Filter")
    COLREAD__FIELD_NAME: Final[WrapperField] = WrapperField("ColRead", FieldType.STRING, display_name="Read")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DENSITYPLUSMINUS__FIELD_NAME: Final[WrapperField] = WrapperField("DensityPlusMinus", FieldType.DOUBLE, display_name="Density +/-")
    LANE__FIELD_NAME: Final[WrapperField] = WrapperField("Lane", FieldType.LONG, display_name="Lane (Long Integer)")
    LANECOL__FIELD_NAME: Final[WrapperField] = WrapperField("LaneCol", FieldType.STRING, display_name="Lane")
    PFPERCENTPM__FIELD_NAME: Final[WrapperField] = WrapperField("PFPercentPM", FieldType.DOUBLE, display_name="PF% +/-")
    PASSEDCLUSTERSINALLTILES__FIELD_NAME: Final[WrapperField] = WrapperField("PassedClustersInAllTiles", FieldType.DOUBLE, display_name="Reads PF (M)")
    PASSINGPLUSMINUS__FIELD_NAME: Final[WrapperField] = WrapperField("PassingPlusMinus", FieldType.DOUBLE, display_name="PF +/-")
    TILES__FIELD_NAME: Final[WrapperField] = WrapperField("Tiles", FieldType.INTEGER, display_name="Tiles")
    TOTALCLUSTERSINALLTILES__FIELD_NAME: Final[WrapperField] = WrapperField("TotalClustersInAllTiles", FieldType.DOUBLE, display_name="Reads (M)")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Aligned_field(self, value: Optional[float]):
        """
        Set data field with field name 'Aligned' on this record model
        """
        self.set_field_value(self.ALIGNED__FIELD_NAME.field_name, value)

    def get_Aligned_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Aligned' from this record model
        """
        return self.get_field_value(self.ALIGNED__FIELD_NAME.field_name)

    def set_AlignedPM_field(self, value: Optional[float]):
        """
        Set data field with field name 'AlignedPM' on this record model
        """
        self.set_field_value(self.ALIGNEDPM__FIELD_NAME.field_name, value)

    def get_AlignedPM_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AlignedPM' from this record model
        """
        return self.get_field_value(self.ALIGNEDPM__FIELD_NAME.field_name)

    def set_ClusterDensity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ClusterDensity' on this record model
        """
        self.set_field_value(self.CLUSTERDENSITY__FIELD_NAME.field_name, value)

    def get_ClusterDensity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ClusterDensity' from this record model
        """
        return self.get_field_value(self.CLUSTERDENSITY__FIELD_NAME.field_name)

    def set_ClusterPassingFilter_field(self, value: Optional[float]):
        """
        Set data field with field name 'ClusterPassingFilter' on this record model
        """
        self.set_field_value(self.CLUSTERPASSINGFILTER__FIELD_NAME.field_name, value)

    def get_ClusterPassingFilter_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ClusterPassingFilter' from this record model
        """
        return self.get_field_value(self.CLUSTERPASSINGFILTER__FIELD_NAME.field_name)

    def set_ClusterPercentFilter_field(self, value: Optional[float]):
        """
        Set data field with field name 'ClusterPercentFilter' on this record model
        """
        self.set_field_value(self.CLUSTERPERCENTFILTER__FIELD_NAME.field_name, value)

    def get_ClusterPercentFilter_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ClusterPercentFilter' from this record model
        """
        return self.get_field_value(self.CLUSTERPERCENTFILTER__FIELD_NAME.field_name)

    def set_ColRead_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColRead' on this record model
        """
        self.set_field_value(self.COLREAD__FIELD_NAME.field_name, value)

    def get_ColRead_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColRead' from this record model
        """
        return self.get_field_value(self.COLREAD__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DensityPlusMinus_field(self, value: Optional[float]):
        """
        Set data field with field name 'DensityPlusMinus' on this record model
        """
        self.set_field_value(self.DENSITYPLUSMINUS__FIELD_NAME.field_name, value)

    def get_DensityPlusMinus_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DensityPlusMinus' from this record model
        """
        return self.get_field_value(self.DENSITYPLUSMINUS__FIELD_NAME.field_name)

    def set_Lane_field(self, value: Optional[int]):
        """
        Set data field with field name 'Lane' on this record model
        """
        self.set_field_value(self.LANE__FIELD_NAME.field_name, value)

    def get_Lane_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Lane' from this record model
        """
        return self.get_field_value(self.LANE__FIELD_NAME.field_name)

    def set_LaneCol_field(self, value: Optional[str]):
        """
        Set data field with field name 'LaneCol' on this record model
        """
        self.set_field_value(self.LANECOL__FIELD_NAME.field_name, value)

    def get_LaneCol_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LaneCol' from this record model
        """
        return self.get_field_value(self.LANECOL__FIELD_NAME.field_name)

    def set_PFPercentPM_field(self, value: Optional[float]):
        """
        Set data field with field name 'PFPercentPM' on this record model
        """
        self.set_field_value(self.PFPERCENTPM__FIELD_NAME.field_name, value)

    def get_PFPercentPM_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PFPercentPM' from this record model
        """
        return self.get_field_value(self.PFPERCENTPM__FIELD_NAME.field_name)

    def set_PassedClustersInAllTiles_field(self, value: Optional[float]):
        """
        Set data field with field name 'PassedClustersInAllTiles' on this record model
        """
        self.set_field_value(self.PASSEDCLUSTERSINALLTILES__FIELD_NAME.field_name, value)

    def get_PassedClustersInAllTiles_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PassedClustersInAllTiles' from this record model
        """
        return self.get_field_value(self.PASSEDCLUSTERSINALLTILES__FIELD_NAME.field_name)

    def set_PassingPlusMinus_field(self, value: Optional[float]):
        """
        Set data field with field name 'PassingPlusMinus' on this record model
        """
        self.set_field_value(self.PASSINGPLUSMINUS__FIELD_NAME.field_name, value)

    def get_PassingPlusMinus_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PassingPlusMinus' from this record model
        """
        return self.get_field_value(self.PASSINGPLUSMINUS__FIELD_NAME.field_name)

    def set_Tiles_field(self, value: Optional[int]):
        """
        Set data field with field name 'Tiles' on this record model
        """
        self.set_field_value(self.TILES__FIELD_NAME.field_name, value)

    def get_Tiles_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Tiles' from this record model
        """
        return self.get_field_value(self.TILES__FIELD_NAME.field_name)

    def set_TotalClustersInAllTiles_field(self, value: Optional[float]):
        """
        Set data field with field name 'TotalClustersInAllTiles' on this record model
        """
        self.set_field_value(self.TOTALCLUSTERSINALLTILES__FIELD_NAME.field_name, value)

    def get_TotalClustersInAllTiles_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TotalClustersInAllTiles' from this record model
        """
        return self.get_field_value(self.TOTALCLUSTERSINALLTILES__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class CompoundModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Compound
    Data Type Display Name: Compound (Compounds)
    Fields: ExactMass, Temperature, PubchemCid, ConsumableType, Purity, DateCreated, IsGHSClassified, HasOrStereoGroup, CXSMILESHash, Density, Formula, PolarSurfaceArea, GHSSignal, ZoBioonly, cLogP, VeloxLastModifiedBy, MolecularWeight, InchiKey, LotNumber, CreatedBy, inchi, Charge, IUPAC, SMILES, Pressure, GHSHazardCode, TotalHBondCount, TotalHBondAcceptors, DataRecordName, ExpirationDate, CAS, VeloxLastModifiedDate, RegistryId, Yield, StereoRegHash, GHSPictoCode, GHSCautionCode
    """
    DATA_TYPE_NAME: Final[str] = 'Compound'
    DISPLAY_NAME: Final[str] = "Compound"
    PLURAL_DISPLAY_NAME: Final[str] = "Compounds"
    CAS__FIELD_NAME: Final[WrapperField] = WrapperField("CAS", FieldType.STRING, display_name="CAS")
    CXSMILESHASH__FIELD_NAME: Final[WrapperField] = WrapperField("CXSMILESHash", FieldType.STRING, display_name="CXSMILES Hash")
    CHARGE__FIELD_NAME: Final[WrapperField] = WrapperField("Charge", FieldType.INTEGER, display_name="Charge")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DENSITY__FIELD_NAME: Final[WrapperField] = WrapperField("Density", FieldType.STRING, display_name="Density")
    EXACTMASS__FIELD_NAME: Final[WrapperField] = WrapperField("ExactMass", FieldType.DOUBLE, display_name="Exact Mass")
    EXPIRATIONDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ExpirationDate", FieldType.DATE, display_name="Expiration Date")
    FORMULA__FIELD_NAME: Final[WrapperField] = WrapperField("Formula", FieldType.STRING, display_name="Formula")
    GHSCAUTIONCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSCautionCode", FieldType.STRING, display_name="GHS Caution Code")
    GHSHAZARDCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSHazardCode", FieldType.STRING, display_name="GHS Hazard Code")
    GHSPICTOCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSPictoCode", FieldType.STRING, display_name="GHS Pictogram Codes")
    GHSSIGNAL__FIELD_NAME: Final[WrapperField] = WrapperField("GHSSignal", FieldType.STRING, display_name="GHS Signal")
    HASORSTEREOGROUP__FIELD_NAME: Final[WrapperField] = WrapperField("HasOrStereoGroup", FieldType.BOOLEAN, display_name="Contains OR Stereo")
    IUPAC__FIELD_NAME: Final[WrapperField] = WrapperField("IUPAC", FieldType.STRING, display_name="IUPAC")
    INCHIKEY__FIELD_NAME: Final[WrapperField] = WrapperField("InchiKey", FieldType.STRING, display_name="INCHI Key")
    ISGHSCLASSIFIED__FIELD_NAME: Final[WrapperField] = WrapperField("IsGHSClassified", FieldType.BOOLEAN, display_name="Is GHS Classified")
    LOTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("LotNumber", FieldType.STRING, display_name="Lot Number")
    MOLECULARWEIGHT__FIELD_NAME: Final[WrapperField] = WrapperField("MolecularWeight", FieldType.DOUBLE, display_name="Molecular Weight")
    POLARSURFACEAREA__FIELD_NAME: Final[WrapperField] = WrapperField("PolarSurfaceArea", FieldType.DOUBLE, display_name="Polar Surface Area")
    PRESSURE__FIELD_NAME: Final[WrapperField] = WrapperField("Pressure", FieldType.DOUBLE, display_name="Pressure")
    PUBCHEMCID__FIELD_NAME: Final[WrapperField] = WrapperField("PubchemCid", FieldType.INTEGER, display_name="Pubchem CID")
    PURITY__FIELD_NAME: Final[WrapperField] = WrapperField("Purity", FieldType.DOUBLE, display_name="Purity")
    REGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryId", FieldType.STRING, display_name="Registry ID")
    SMILES__FIELD_NAME: Final[WrapperField] = WrapperField("SMILES", FieldType.STRING, display_name="SMILES")
    STEREOREGHASH__FIELD_NAME: Final[WrapperField] = WrapperField("StereoRegHash", FieldType.STRING, display_name="Stereo Registration Hash")
    TEMPERATURE__FIELD_NAME: Final[WrapperField] = WrapperField("Temperature", FieldType.DOUBLE, display_name="Temperature")
    TOTALHBONDACCEPTORS__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondAcceptors", FieldType.INTEGER, display_name="#Hydrogen Bond Acceptors")
    TOTALHBONDCOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondCount", FieldType.INTEGER, display_name="#Hydrogen Bond Donors")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    YIELD__FIELD_NAME: Final[WrapperField] = WrapperField("Yield", FieldType.DOUBLE, display_name="Yield")
    ZOBIOONLY__FIELD_NAME: Final[WrapperField] = WrapperField("ZoBioonly", FieldType.BOOLEAN, display_name="Zo Bio only")
    CLOGP__FIELD_NAME: Final[WrapperField] = WrapperField("cLogP", FieldType.DOUBLE, display_name="Calculated cLogP")
    INCHI__FIELD_NAME: Final[WrapperField] = WrapperField("inchi", FieldType.STRING, display_name="INCHI")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_CXSMILESHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'CXSMILESHash' on this record model
        """
        self.set_field_value(self.CXSMILESHASH__FIELD_NAME.field_name, value)

    def get_CXSMILESHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CXSMILESHash' from this record model
        """
        return self.get_field_value(self.CXSMILESHASH__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Density_field(self, value: Optional[str]):
        """
        Set data field with field name 'Density' on this record model
        """
        self.set_field_value(self.DENSITY__FIELD_NAME.field_name, value)

    def get_Density_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Density' from this record model
        """
        return self.get_field_value(self.DENSITY__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_HasOrStereoGroup_field(self, value: Optional[bool]):
        """
        Set data field with field name 'HasOrStereoGroup' on this record model
        """
        self.set_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name, value)

    def get_HasOrStereoGroup_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'HasOrStereoGroup' from this record model
        """
        return self.get_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_Pressure_field(self, value: Optional[float]):
        """
        Set data field with field name 'Pressure' on this record model
        """
        self.set_field_value(self.PRESSURE__FIELD_NAME.field_name, value)

    def get_Pressure_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Pressure' from this record model
        """
        return self.get_field_value(self.PRESSURE__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_Purity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Purity' on this record model
        """
        self.set_field_value(self.PURITY__FIELD_NAME.field_name, value)

    def get_Purity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Purity' from this record model
        """
        return self.get_field_value(self.PURITY__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_StereoRegHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'StereoRegHash' on this record model
        """
        self.set_field_value(self.STEREOREGHASH__FIELD_NAME.field_name, value)

    def get_StereoRegHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StereoRegHash' from this record model
        """
        return self.get_field_value(self.STEREOREGHASH__FIELD_NAME.field_name)

    def set_Temperature_field(self, value: Optional[float]):
        """
        Set data field with field name 'Temperature' on this record model
        """
        self.set_field_value(self.TEMPERATURE__FIELD_NAME.field_name, value)

    def get_Temperature_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Temperature' from this record model
        """
        return self.get_field_value(self.TEMPERATURE__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Yield_field(self, value: Optional[float]):
        """
        Set data field with field name 'Yield' on this record model
        """
        self.set_field_value(self.YIELD__FIELD_NAME.field_name, value)

    def get_Yield_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Yield' from this record model
        """
        return self.get_field_value(self.YIELD__FIELD_NAME.field_name)

    def set_ZoBioonly_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ZoBioonly' on this record model
        """
        self.set_field_value(self.ZOBIOONLY__FIELD_NAME.field_name, value)

    def get_ZoBioonly_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ZoBioonly' from this record model
        """
        return self.get_field_value(self.ZOBIOONLY__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)


class CompoundPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CompoundPart
    Data Type Display Name: Compound Part (Compound Parts)
    Fields: Salts, PubchemCid, IsNormalized, IsGHSClassified, QuantityPerItem, Formula, PolarSurfaceArea, RequestImageUpdate, cLogP, CreatedBy, inchi, MultiParentLink229, EditLock, QuantityOnHand, Units, CAS, DataRecordName, INCHIShadow, RegistryId, ExactMass, ConsumableType, DateCreated, SubstanceClass, CXSMILESHash, HasOrStereoGroup, ReorderLevelQuantity, GHSSignal, RegisteredToCartridge, VeloxLastModifiedBy, MolecularWeight, InchiKey, RobTest, Charge, IUPAC, SMILES, MOL, GHSHazardCode, SMILESShadow, TotalHBondCount, TotalHBondAcceptors, VeloxLastModifiedDate, StereoRegHash, GHSPictoCode, GHSCautionCode
    """
    DATA_TYPE_NAME: Final[str] = 'CompoundPart'
    DISPLAY_NAME: Final[str] = "Compound Part"
    PLURAL_DISPLAY_NAME: Final[str] = "Compound Parts"
    CAS__FIELD_NAME: Final[WrapperField] = WrapperField("CAS", FieldType.STRING, display_name="CAS")
    CXSMILESHASH__FIELD_NAME: Final[WrapperField] = WrapperField("CXSMILESHash", FieldType.STRING, display_name="CXSMILES Hash")
    CHARGE__FIELD_NAME: Final[WrapperField] = WrapperField("Charge", FieldType.INTEGER, display_name="Charge")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EDITLOCK__FIELD_NAME: Final[WrapperField] = WrapperField("EditLock", FieldType.BOOLEAN, display_name="Edit Lock")
    EXACTMASS__FIELD_NAME: Final[WrapperField] = WrapperField("ExactMass", FieldType.DOUBLE, display_name="Exact Mass")
    FORMULA__FIELD_NAME: Final[WrapperField] = WrapperField("Formula", FieldType.STRING, display_name="Formula")
    GHSCAUTIONCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSCautionCode", FieldType.STRING, display_name="GHS Caution Code")
    GHSHAZARDCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSHazardCode", FieldType.STRING, display_name="GHS Hazard Code")
    GHSPICTOCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSPictoCode", FieldType.STRING, display_name="GHS Pictogram Codes")
    GHSSIGNAL__FIELD_NAME: Final[WrapperField] = WrapperField("GHSSignal", FieldType.STRING, display_name="GHS Signal")
    HASORSTEREOGROUP__FIELD_NAME: Final[WrapperField] = WrapperField("HasOrStereoGroup", FieldType.BOOLEAN, display_name="Contains OR Stereo")
    INCHISHADOW__FIELD_NAME: Final[WrapperField] = WrapperField("INCHIShadow", FieldType.STRING, display_name="INCHI Shadow")
    IUPAC__FIELD_NAME: Final[WrapperField] = WrapperField("IUPAC", FieldType.STRING, display_name="IUPAC")
    INCHIKEY__FIELD_NAME: Final[WrapperField] = WrapperField("InchiKey", FieldType.STRING, display_name="INCHI Key")
    ISGHSCLASSIFIED__FIELD_NAME: Final[WrapperField] = WrapperField("IsGHSClassified", FieldType.BOOLEAN, display_name="Is GHS Classified")
    ISNORMALIZED__FIELD_NAME: Final[WrapperField] = WrapperField("IsNormalized", FieldType.BOOLEAN, display_name="Is Normalized")
    MOL__FIELD_NAME: Final[WrapperField] = WrapperField("MOL", FieldType.STRING, display_name="MOL")
    MOLECULARWEIGHT__FIELD_NAME: Final[WrapperField] = WrapperField("MolecularWeight", FieldType.DOUBLE, display_name="Molecular Weight")
    MULTIPARENTLINK229__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink229", FieldType.MULTIPARENTLINK, display_name="Linked BioConjugateParts")
    POLARSURFACEAREA__FIELD_NAME: Final[WrapperField] = WrapperField("PolarSurfaceArea", FieldType.DOUBLE, display_name="Polar Surface Area")
    PUBCHEMCID__FIELD_NAME: Final[WrapperField] = WrapperField("PubchemCid", FieldType.INTEGER, display_name="Pubchem CID")
    QUANTITYONHAND__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityOnHand", FieldType.DOUBLE, display_name="Quantity / Volume On Hand")
    QUANTITYPERITEM__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityPerItem", FieldType.DOUBLE, display_name="Quantity / Volume Per Item")
    REGISTEREDTOCARTRIDGE__FIELD_NAME: Final[WrapperField] = WrapperField("RegisteredToCartridge", FieldType.BOOLEAN, display_name="Registered To Cartridge")
    REGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryId", FieldType.STRING, display_name="Registry ID")
    REORDERLEVELQUANTITY__FIELD_NAME: Final[WrapperField] = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE, display_name="Reorder Level Quantity")
    REQUESTIMAGEUPDATE__FIELD_NAME: Final[WrapperField] = WrapperField("RequestImageUpdate", FieldType.BOOLEAN, display_name="Request Image Update")
    ROBTEST__FIELD_NAME: Final[WrapperField] = WrapperField("RobTest", FieldType.STRING, display_name="Rob Test")
    SMILES__FIELD_NAME: Final[WrapperField] = WrapperField("SMILES", FieldType.STRING, display_name="Canonical SMILES")
    SMILESSHADOW__FIELD_NAME: Final[WrapperField] = WrapperField("SMILESShadow", FieldType.STRING, display_name="SMILES Shadow")
    SALTS__FIELD_NAME: Final[WrapperField] = WrapperField("Salts", FieldType.STRING, display_name="Salts")
    STEREOREGHASH__FIELD_NAME: Final[WrapperField] = WrapperField("StereoRegHash", FieldType.STRING, display_name="Stereo Registration Hash")
    SUBSTANCECLASS__FIELD_NAME: Final[WrapperField] = WrapperField("SubstanceClass", FieldType.STRING, display_name="Substance Class")
    TOTALHBONDACCEPTORS__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondAcceptors", FieldType.INTEGER, display_name="#Hydrogen Bond Acceptors")
    TOTALHBONDCOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("TotalHBondCount", FieldType.INTEGER, display_name="#Hydrogen Bond Donors")
    UNITS__FIELD_NAME: Final[WrapperField] = WrapperField("Units", FieldType.PICKLIST, display_name="Units")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    CLOGP__FIELD_NAME: Final[WrapperField] = WrapperField("cLogP", FieldType.DOUBLE, display_name="Calculated cLogP")
    INCHI__FIELD_NAME: Final[WrapperField] = WrapperField("inchi", FieldType.STRING, display_name="INCHI")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CAS_field(self, value: Optional[str]):
        """
        Set data field with field name 'CAS' on this record model
        """
        self.set_field_value(self.CAS__FIELD_NAME.field_name, value)

    def get_CAS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CAS' from this record model
        """
        return self.get_field_value(self.CAS__FIELD_NAME.field_name)

    def set_CXSMILESHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'CXSMILESHash' on this record model
        """
        self.set_field_value(self.CXSMILESHASH__FIELD_NAME.field_name, value)

    def get_CXSMILESHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CXSMILESHash' from this record model
        """
        return self.get_field_value(self.CXSMILESHASH__FIELD_NAME.field_name)

    def set_Charge_field(self, value: Optional[int]):
        """
        Set data field with field name 'Charge' on this record model
        """
        self.set_field_value(self.CHARGE__FIELD_NAME.field_name, value)

    def get_Charge_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Charge' from this record model
        """
        return self.get_field_value(self.CHARGE__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EditLock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EditLock' on this record model
        """
        self.set_field_value(self.EDITLOCK__FIELD_NAME.field_name, value)

    def get_EditLock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EditLock' from this record model
        """
        return self.get_field_value(self.EDITLOCK__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSCautionCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSCautionCode' on this record model
        """
        self.set_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name, value)

    def get_GHSCautionCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSCautionCode' from this record model
        """
        return self.get_field_value(self.GHSCAUTIONCODE__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_GHSPictoCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSPictoCode' on this record model
        """
        self.set_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name, value)

    def get_GHSPictoCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSPictoCode' from this record model
        """
        return self.get_field_value(self.GHSPICTOCODE__FIELD_NAME.field_name)

    def set_GHSSignal_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSSignal' on this record model
        """
        self.set_field_value(self.GHSSIGNAL__FIELD_NAME.field_name, value)

    def get_GHSSignal_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSSignal' from this record model
        """
        return self.get_field_value(self.GHSSIGNAL__FIELD_NAME.field_name)

    def set_HasOrStereoGroup_field(self, value: Optional[bool]):
        """
        Set data field with field name 'HasOrStereoGroup' on this record model
        """
        self.set_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name, value)

    def get_HasOrStereoGroup_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'HasOrStereoGroup' from this record model
        """
        return self.get_field_value(self.HASORSTEREOGROUP__FIELD_NAME.field_name)

    def set_INCHIShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'INCHIShadow' on this record model
        """
        self.set_field_value(self.INCHISHADOW__FIELD_NAME.field_name, value)

    def get_INCHIShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'INCHIShadow' from this record model
        """
        return self.get_field_value(self.INCHISHADOW__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_InchiKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'InchiKey' on this record model
        """
        self.set_field_value(self.INCHIKEY__FIELD_NAME.field_name, value)

    def get_InchiKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InchiKey' from this record model
        """
        return self.get_field_value(self.INCHIKEY__FIELD_NAME.field_name)

    def set_IsGHSClassified_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGHSClassified' on this record model
        """
        self.set_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name, value)

    def get_IsGHSClassified_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGHSClassified' from this record model
        """
        return self.get_field_value(self.ISGHSCLASSIFIED__FIELD_NAME.field_name)

    def set_IsNormalized_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsNormalized' on this record model
        """
        self.set_field_value(self.ISNORMALIZED__FIELD_NAME.field_name, value)

    def get_IsNormalized_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsNormalized' from this record model
        """
        return self.get_field_value(self.ISNORMALIZED__FIELD_NAME.field_name)

    def set_MOL_field(self, value: Optional[str]):
        """
        Set data field with field name 'MOL' on this record model
        """
        self.set_field_value(self.MOL__FIELD_NAME.field_name, value)

    def get_MOL_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MOL' from this record model
        """
        return self.get_field_value(self.MOL__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_PolarSurfaceArea_field(self, value: Optional[float]):
        """
        Set data field with field name 'PolarSurfaceArea' on this record model
        """
        self.set_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name, value)

    def get_PolarSurfaceArea_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PolarSurfaceArea' from this record model
        """
        return self.get_field_value(self.POLARSURFACEAREA__FIELD_NAME.field_name)

    def set_PubchemCid_field(self, value: Optional[int]):
        """
        Set data field with field name 'PubchemCid' on this record model
        """
        self.set_field_value(self.PUBCHEMCID__FIELD_NAME.field_name, value)

    def get_PubchemCid_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PubchemCid' from this record model
        """
        return self.get_field_value(self.PUBCHEMCID__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_RegisteredToCartridge_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RegisteredToCartridge' on this record model
        """
        self.set_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name, value)

    def get_RegisteredToCartridge_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RegisteredToCartridge' from this record model
        """
        return self.get_field_value(self.REGISTEREDTOCARTRIDGE__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_RequestImageUpdate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RequestImageUpdate' on this record model
        """
        self.set_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name, value)

    def get_RequestImageUpdate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RequestImageUpdate' from this record model
        """
        return self.get_field_value(self.REQUESTIMAGEUPDATE__FIELD_NAME.field_name)

    def set_RobTest_field(self, value: Optional[str]):
        """
        Set data field with field name 'RobTest' on this record model
        """
        self.set_field_value(self.ROBTEST__FIELD_NAME.field_name, value)

    def get_RobTest_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RobTest' from this record model
        """
        return self.get_field_value(self.ROBTEST__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_SMILESShadow_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILESShadow' on this record model
        """
        self.set_field_value(self.SMILESSHADOW__FIELD_NAME.field_name, value)

    def get_SMILESShadow_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILESShadow' from this record model
        """
        return self.get_field_value(self.SMILESSHADOW__FIELD_NAME.field_name)

    def set_Salts_field(self, value: Optional[str]):
        """
        Set data field with field name 'Salts' on this record model
        """
        self.set_field_value(self.SALTS__FIELD_NAME.field_name, value)

    def get_Salts_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Salts' from this record model
        """
        return self.get_field_value(self.SALTS__FIELD_NAME.field_name)

    def set_StereoRegHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'StereoRegHash' on this record model
        """
        self.set_field_value(self.STEREOREGHASH__FIELD_NAME.field_name, value)

    def get_StereoRegHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StereoRegHash' from this record model
        """
        return self.get_field_value(self.STEREOREGHASH__FIELD_NAME.field_name)

    def set_SubstanceClass_field(self, value: Optional[str]):
        """
        Set data field with field name 'SubstanceClass' on this record model
        """
        self.set_field_value(self.SUBSTANCECLASS__FIELD_NAME.field_name, value)

    def get_SubstanceClass_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SubstanceClass' from this record model
        """
        return self.get_field_value(self.SUBSTANCECLASS__FIELD_NAME.field_name)

    def set_TotalHBondAcceptors_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondAcceptors' on this record model
        """
        self.set_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name, value)

    def get_TotalHBondAcceptors_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondAcceptors' from this record model
        """
        return self.get_field_value(self.TOTALHBONDACCEPTORS__FIELD_NAME.field_name)

    def set_TotalHBondCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalHBondCount' on this record model
        """
        self.set_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name, value)

    def get_TotalHBondCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalHBondCount' from this record model
        """
        return self.get_field_value(self.TOTALHBONDCOUNT__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_cLogP_field(self, value: Optional[float]):
        """
        Set data field with field name 'cLogP' on this record model
        """
        self.set_field_value(self.CLOGP__FIELD_NAME.field_name, value)

    def get_cLogP_field(self) -> Optional[float]:
        """
        Get data field value with field name 'cLogP' from this record model
        """
        return self.get_field_value(self.CLOGP__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)


class CompoundSaltConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type CompoundSaltConfig
    Data Type Display Name: Compound Salt Config (Compound Salt Configs)
    Fields: CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, SaltId, SaltSMARTS
    The corporate compound salt database. This will be a list of SMARTS expressions that will be used for desalting when importing a compound part.
    """
    DATA_TYPE_NAME: Final[str] = 'CompoundSaltConfig'
    DISPLAY_NAME: Final[str] = "Compound Salt Config"
    PLURAL_DISPLAY_NAME: Final[str] = "Compound Salt Configs"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    SALTID__FIELD_NAME: Final[WrapperField] = WrapperField("SaltId", FieldType.STRING, display_name="Salt Code")
    SALTSMARTS__FIELD_NAME: Final[WrapperField] = WrapperField("SaltSMARTS", FieldType.STRING, display_name="Salt SMARTS")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_SaltId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SaltId' on this record model
        """
        self.set_field_value(self.SALTID__FIELD_NAME.field_name, value)

    def get_SaltId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SaltId' from this record model
        """
        return self.get_field_value(self.SALTID__FIELD_NAME.field_name)

    def set_SaltSMARTS_field(self, value: Optional[str]):
        """
        Set data field with field name 'SaltSMARTS' on this record model
        """
        self.set_field_value(self.SALTSMARTS__FIELD_NAME.field_name, value)

    def get_SaltSMARTS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SaltSMARTS' from this record model
        """
        return self.get_field_value(self.SALTSMARTS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ComputedAssayResultsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ComputedAssayResults
    Data Type Display Name: Computed Assay Result (Computed Assay Results)
    Fields: NoCanTauPartSideLink, CreatedBy, NewChem1PartSideLink, CompoundPartLink, DateCreated, ChemReagentPartLink, Name, ChemRegPartPartSideLink, DataRecordName, AssayUnits, TextValue, AssayType, VeloxLastModifiedDate, VeloxLastModifiedBy, SampleSideLink, NumericValue, Robs3rdRegPartSideLink
    Stores the computed assay results from a fixed formula for program that operates on data.
    """
    DATA_TYPE_NAME: Final[str] = 'ComputedAssayResults'
    DISPLAY_NAME: Final[str] = "Computed Assay Result"
    PLURAL_DISPLAY_NAME: Final[str] = "Computed Assay Results"
    ASSAYTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("AssayType", FieldType.STRING, display_name="Assay Type")
    ASSAYUNITS__FIELD_NAME: Final[WrapperField] = WrapperField("AssayUnits", FieldType.SELECTION, display_name="Units")
    CHEMREAGENTPARTLINK__FIELD_NAME: Final[WrapperField] = WrapperField("ChemReagentPartLink", FieldType.SIDE_LINK, display_name="Chem Reagent Part Link")
    CHEMREGPARTPARTSIDELINK__FIELD_NAME: Final[WrapperField] = WrapperField("ChemRegPartPartSideLink", FieldType.SIDE_LINK, display_name="Company X Reagent Part Part Link")
    COMPOUNDPARTLINK__FIELD_NAME: Final[WrapperField] = WrapperField("CompoundPartLink", FieldType.SIDE_LINK, display_name="Compound Part Link")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    NAME__FIELD_NAME: Final[WrapperField] = WrapperField("Name", FieldType.STRING, display_name="Name")
    NEWCHEM1PARTSIDELINK__FIELD_NAME: Final[WrapperField] = WrapperField("NewChem1PartSideLink", FieldType.SIDE_LINK, display_name="New Chem 1 Part Link")
    NOCANTAUPARTSIDELINK__FIELD_NAME: Final[WrapperField] = WrapperField("NoCanTauPartSideLink", FieldType.SIDE_LINK, display_name="No Canonical Tautomer Part Link")
    NUMERICVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("NumericValue", FieldType.DOUBLE, display_name="Numeric Value")
    ROBS3RDREGPARTSIDELINK__FIELD_NAME: Final[WrapperField] = WrapperField("Robs3rdRegPartSideLink", FieldType.SIDE_LINK, display_name="Regie McReg Face Part Part Link")
    SAMPLESIDELINK__FIELD_NAME: Final[WrapperField] = WrapperField("SampleSideLink", FieldType.SIDE_LINK, display_name="Sample Side Link")
    TEXTVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("TextValue", FieldType.STRING, display_name="Text Value")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AssayType_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssayType' on this record model
        """
        self.set_field_value(self.ASSAYTYPE__FIELD_NAME.field_name, value)

    def get_AssayType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssayType' from this record model
        """
        return self.get_field_value(self.ASSAYTYPE__FIELD_NAME.field_name)

    def set_AssayUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssayUnits' on this record model
        """
        self.set_field_value(self.ASSAYUNITS__FIELD_NAME.field_name, value)

    def get_AssayUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssayUnits' from this record model
        """
        return self.get_field_value(self.ASSAYUNITS__FIELD_NAME.field_name)

    def set_ChemReagentPartLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'ChemReagentPartLink' on this record model
        """
        self.set_field_value(self.CHEMREAGENTPARTLINK__FIELD_NAME.field_name, value)

    def get_ChemReagentPartLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ChemReagentPartLink' from this record model
        """
        return self.get_field_value(self.CHEMREAGENTPARTLINK__FIELD_NAME.field_name)

    def set_ChemRegPartPartSideLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'ChemRegPartPartSideLink' on this record model
        """
        self.set_field_value(self.CHEMREGPARTPARTSIDELINK__FIELD_NAME.field_name, value)

    def get_ChemRegPartPartSideLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ChemRegPartPartSideLink' from this record model
        """
        return self.get_field_value(self.CHEMREGPARTPARTSIDELINK__FIELD_NAME.field_name)

    def set_CompoundPartLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'CompoundPartLink' on this record model
        """
        self.set_field_value(self.COMPOUNDPARTLINK__FIELD_NAME.field_name, value)

    def get_CompoundPartLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'CompoundPartLink' from this record model
        """
        return self.get_field_value(self.COMPOUNDPARTLINK__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_NewChem1PartSideLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'NewChem1PartSideLink' on this record model
        """
        self.set_field_value(self.NEWCHEM1PARTSIDELINK__FIELD_NAME.field_name, value)

    def get_NewChem1PartSideLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NewChem1PartSideLink' from this record model
        """
        return self.get_field_value(self.NEWCHEM1PARTSIDELINK__FIELD_NAME.field_name)

    def set_NoCanTauPartSideLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'NoCanTauPartSideLink' on this record model
        """
        self.set_field_value(self.NOCANTAUPARTSIDELINK__FIELD_NAME.field_name, value)

    def get_NoCanTauPartSideLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NoCanTauPartSideLink' from this record model
        """
        return self.get_field_value(self.NOCANTAUPARTSIDELINK__FIELD_NAME.field_name)

    def set_NumericValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'NumericValue' on this record model
        """
        self.set_field_value(self.NUMERICVALUE__FIELD_NAME.field_name, value)

    def get_NumericValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'NumericValue' from this record model
        """
        return self.get_field_value(self.NUMERICVALUE__FIELD_NAME.field_name)

    def set_Robs3rdRegPartSideLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'Robs3rdRegPartSideLink' on this record model
        """
        self.set_field_value(self.ROBS3RDREGPARTSIDELINK__FIELD_NAME.field_name, value)

    def get_Robs3rdRegPartSideLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Robs3rdRegPartSideLink' from this record model
        """
        return self.get_field_value(self.ROBS3RDREGPARTSIDELINK__FIELD_NAME.field_name)

    def set_SampleSideLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'SampleSideLink' on this record model
        """
        self.set_field_value(self.SAMPLESIDELINK__FIELD_NAME.field_name, value)

    def get_SampleSideLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SampleSideLink' from this record model
        """
        return self.get_field_value(self.SAMPLESIDELINK__FIELD_NAME.field_name)

    def set_TextValue_field(self, value: Optional[str]):
        """
        Set data field with field name 'TextValue' on this record model
        """
        self.set_field_value(self.TEXTVALUE__FIELD_NAME.field_name, value)

    def get_TextValue_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TextValue' from this record model
        """
        return self.get_field_value(self.TEXTVALUE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ConditionsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Conditions
    Data Type Display Name: Conditions (Conditions)
    Fields: Temperature, CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, Pressure
    """
    DATA_TYPE_NAME: Final[str] = 'Conditions'
    DISPLAY_NAME: Final[str] = "Conditions"
    PLURAL_DISPLAY_NAME: Final[str] = "Conditions"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    PRESSURE__FIELD_NAME: Final[WrapperField] = WrapperField("Pressure", FieldType.DOUBLE, display_name="Pressure")
    TEMPERATURE__FIELD_NAME: Final[WrapperField] = WrapperField("Temperature", FieldType.DOUBLE, display_name="Temperature")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Pressure_field(self, value: Optional[float]):
        """
        Set data field with field name 'Pressure' on this record model
        """
        self.set_field_value(self.PRESSURE__FIELD_NAME.field_name, value)

    def get_Pressure_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Pressure' from this record model
        """
        return self.get_field_value(self.PRESSURE__FIELD_NAME.field_name)

    def set_Temperature_field(self, value: Optional[float]):
        """
        Set data field with field name 'Temperature' on this record model
        """
        self.set_field_value(self.TEMPERATURE__FIELD_NAME.field_name, value)

    def get_Temperature_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Temperature' from this record model
        """
        return self.get_field_value(self.TEMPERATURE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ConsumableModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Consumable
    Data Type Display Name: Reagent Part (Reagent Parts)
    Fields: EditConsumableType, Description, CreatedBy, PartNumber, ConsumableType, DateCreated, Vendor, QuantityOnHand, AspenField, Units, QuantityPerItem, ReorderLevelQuantity, DataRecordName, VeloxLastModifiedDate, CASNo, VeloxLastModifiedBy, ConsumableName, ConsumableClassification
    General definition of a consumable object.
    """
    DATA_TYPE_NAME: Final[str] = 'Consumable'
    DISPLAY_NAME: Final[str] = "Reagent Part"
    PLURAL_DISPLAY_NAME: Final[str] = "Reagent Parts"
    ASPENFIELD__FIELD_NAME: Final[WrapperField] = WrapperField("AspenField", FieldType.STRING, display_name="Aspen Field")
    CASNO__FIELD_NAME: Final[WrapperField] = WrapperField("CASNo", FieldType.STRING, display_name="CAS-No")
    CONSUMABLECLASSIFICATION__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableClassification", FieldType.SELECTION, display_name="Consumable Classification")
    CONSUMABLENAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableName", FieldType.STRING, display_name="Reagent Name                           ")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Consumable Type")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DESCRIPTION__FIELD_NAME: Final[WrapperField] = WrapperField("Description", FieldType.STRING, display_name="Description")
    EDITCONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("EditConsumableType", FieldType.BOOLEAN, display_name="Edit Consumable Type")
    PARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("PartNumber", FieldType.STRING, display_name="Part Number                       ")
    QUANTITYONHAND__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityOnHand", FieldType.DOUBLE, display_name="Quantity / Volume On Hand")
    QUANTITYPERITEM__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityPerItem", FieldType.DOUBLE, display_name="Quantity / Volume Per Item")
    REORDERLEVELQUANTITY__FIELD_NAME: Final[WrapperField] = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE, display_name="Reorder Level Quantity")
    UNITS__FIELD_NAME: Final[WrapperField] = WrapperField("Units", FieldType.PICKLIST, display_name="Units")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VENDOR__FIELD_NAME: Final[WrapperField] = WrapperField("Vendor", FieldType.SELECTION, display_name="Vendor")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AspenField_field(self, value: Optional[str]):
        """
        Set data field with field name 'AspenField' on this record model
        """
        self.set_field_value(self.ASPENFIELD__FIELD_NAME.field_name, value)

    def get_AspenField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AspenField' from this record model
        """
        return self.get_field_value(self.ASPENFIELD__FIELD_NAME.field_name)

    def set_CASNo_field(self, value: Optional[str]):
        """
        Set data field with field name 'CASNo' on this record model
        """
        self.set_field_value(self.CASNO__FIELD_NAME.field_name, value)

    def get_CASNo_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CASNo' from this record model
        """
        return self.get_field_value(self.CASNO__FIELD_NAME.field_name)

    def set_ConsumableClassification_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableClassification' on this record model
        """
        self.set_field_value(self.CONSUMABLECLASSIFICATION__FIELD_NAME.field_name, value)

    def get_ConsumableClassification_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableClassification' from this record model
        """
        return self.get_field_value(self.CONSUMABLECLASSIFICATION__FIELD_NAME.field_name)

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Description_field(self, value: Optional[str]):
        """
        Set data field with field name 'Description' on this record model
        """
        self.set_field_value(self.DESCRIPTION__FIELD_NAME.field_name, value)

    def get_Description_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Description' from this record model
        """
        return self.get_field_value(self.DESCRIPTION__FIELD_NAME.field_name)

    def set_EditConsumableType_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EditConsumableType' on this record model
        """
        self.set_field_value(self.EDITCONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_EditConsumableType_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EditConsumableType' from this record model
        """
        return self.get_field_value(self.EDITCONSUMABLETYPE__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class ConsumableImporterMappingModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ConsumableImporterMapping
    Data Type Display Name: Consumable Importer Mapping (Consumable Importer Mappings)
    Fields: MappingGroup, MappingOrder, CreatedBy, DateCreated, DataRecordName, DataField, DisplayName, VeloxLastModifiedDate, VeloxLastModifiedBy, DataType, MappingName
    <!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: Final[str] = 'ConsumableImporterMapping'
    DISPLAY_NAME: Final[str] = "Consumable Importer Mapping"
    PLURAL_DISPLAY_NAME: Final[str] = "Consumable Importer Mappings"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATAFIELD__FIELD_NAME: Final[WrapperField] = WrapperField("DataField", FieldType.SELECTION, display_name="Data Field")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATATYPE__FIELD_NAME: Final[WrapperField] = WrapperField("DataType", FieldType.PICKLIST, display_name="Data Type")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DISPLAYNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DisplayName", FieldType.STRING, display_name="Data Field Display Name")
    MAPPINGGROUP__FIELD_NAME: Final[WrapperField] = WrapperField("MappingGroup", FieldType.STRING, display_name="Mapping Group")
    MAPPINGNAME__FIELD_NAME: Final[WrapperField] = WrapperField("MappingName", FieldType.STRING, display_name="Mapping Name")
    MAPPINGORDER__FIELD_NAME: Final[WrapperField] = WrapperField("MappingOrder", FieldType.SHORT, display_name="Mapping Group Order")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataField_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataField' on this record model
        """
        self.set_field_value(self.DATAFIELD__FIELD_NAME.field_name, value)

    def get_DataField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataField' from this record model
        """
        return self.get_field_value(self.DATAFIELD__FIELD_NAME.field_name)

    def set_DataType_field(self, value: Optional[str]):
        """
        Set data field with field name 'DataType' on this record model
        """
        self.set_field_value(self.DATATYPE__FIELD_NAME.field_name, value)

    def get_DataType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DataType' from this record model
        """
        return self.get_field_value(self.DATATYPE__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DisplayName_field(self, value: Optional[str]):
        """
        Set data field with field name 'DisplayName' on this record model
        """
        self.set_field_value(self.DISPLAYNAME__FIELD_NAME.field_name, value)

    def get_DisplayName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DisplayName' from this record model
        """
        return self.get_field_value(self.DISPLAYNAME__FIELD_NAME.field_name)

    def set_MappingGroup_field(self, value: Optional[str]):
        """
        Set data field with field name 'MappingGroup' on this record model
        """
        self.set_field_value(self.MAPPINGGROUP__FIELD_NAME.field_name, value)

    def get_MappingGroup_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MappingGroup' from this record model
        """
        return self.get_field_value(self.MAPPINGGROUP__FIELD_NAME.field_name)

    def set_MappingName_field(self, value: Optional[str]):
        """
        Set data field with field name 'MappingName' on this record model
        """
        self.set_field_value(self.MAPPINGNAME__FIELD_NAME.field_name, value)

    def get_MappingName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MappingName' from this record model
        """
        return self.get_field_value(self.MAPPINGNAME__FIELD_NAME.field_name)

    def set_MappingOrder_field(self, value: Optional[int]):
        """
        Set data field with field name 'MappingOrder' on this record model
        """
        self.set_field_value(self.MAPPINGORDER__FIELD_NAME.field_name, value)

    def get_MappingOrder_field(self) -> Optional[int]:
        """
        Get data field value with field name 'MappingOrder' from this record model
        """
        return self.get_field_value(self.MAPPINGORDER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ConsumableImportingMapConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ConsumableImportingMapConfig
    Data Type Display Name: Consumable Importing Mapping Configuration (Consumable Importing Mapping Configurations)
    Fields: MappingGroup, MappingOrder, CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated
    <!-- CONFIG: Static --><!-- CONFIG: REPLACEABLE -->
    """
    DATA_TYPE_NAME: Final[str] = 'ConsumableImportingMapConfig'
    DISPLAY_NAME: Final[str] = "Consumable Importing Mapping Configuration"
    PLURAL_DISPLAY_NAME: Final[str] = "Consumable Importing Mapping Configurations"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    MAPPINGGROUP__FIELD_NAME: Final[WrapperField] = WrapperField("MappingGroup", FieldType.STRING, display_name="Mapping Group")
    MAPPINGORDER__FIELD_NAME: Final[WrapperField] = WrapperField("MappingOrder", FieldType.SHORT, display_name="Mapping Group Order")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_MappingGroup_field(self, value: Optional[str]):
        """
        Set data field with field name 'MappingGroup' on this record model
        """
        self.set_field_value(self.MAPPINGGROUP__FIELD_NAME.field_name, value)

    def get_MappingGroup_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MappingGroup' from this record model
        """
        return self.get_field_value(self.MAPPINGGROUP__FIELD_NAME.field_name)

    def set_MappingOrder_field(self, value: Optional[int]):
        """
        Set data field with field name 'MappingOrder' on this record model
        """
        self.set_field_value(self.MAPPINGORDER__FIELD_NAME.field_name, value)

    def get_MappingOrder_field(self) -> Optional[int]:
        """
        Get data field value with field name 'MappingOrder' from this record model
        """
        return self.get_field_value(self.MAPPINGORDER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ConsumableItemModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ConsumableItem
    Data Type Display Name: Reagent (Reagents)
    Fields: PartNumber, ConsumableType, DateCreated, ConsumableBarcode, ValidationExperimentId, KitLotNumbers, BarcodeDefined, RowPosition, ColPosition, CASNo, VeloxLastModifiedBy, UnknownExpiration, LotNumber, StorageLocationBarcode, Validated, CreatedBy, MultiParentLink705, CostPerUnit, Expired, StorageUnitPath, Units, LotNumberDefined, ValidationDate, DataRecordName, ExpirationDate, VeloxLastModifiedDate, ValidationTechician, ConsumableName, QuantityRemaining
    Detailed representation of a more specific consumable object.
    """
    DATA_TYPE_NAME: Final[str] = 'ConsumableItem'
    DISPLAY_NAME: Final[str] = "Reagent"
    PLURAL_DISPLAY_NAME: Final[str] = "Reagents"
    BARCODEDEFINED__FIELD_NAME: Final[WrapperField] = WrapperField("BarcodeDefined", FieldType.BOOLEAN, display_name="Barcode Defined")
    CASNO__FIELD_NAME: Final[WrapperField] = WrapperField("CASNo", FieldType.STRING, display_name="CAS-No")
    COLPOSITION__FIELD_NAME: Final[WrapperField] = WrapperField("ColPosition", FieldType.SELECTION, display_name="Col Position")
    CONSUMABLEBARCODE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableBarcode", FieldType.STRING, display_name="Barcode      ")
    CONSUMABLENAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableName", FieldType.STRING, display_name="Consumable Name")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Consumable Type")
    COSTPERUNIT__FIELD_NAME: Final[WrapperField] = WrapperField("CostPerUnit", FieldType.DOUBLE, display_name="Cost Per Unit")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EXPIRATIONDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ExpirationDate", FieldType.DATE, display_name="Expiration Date")
    EXPIRED__FIELD_NAME: Final[WrapperField] = WrapperField("Expired", FieldType.BOOLEAN, display_name="Expired")
    KITLOTNUMBERS__FIELD_NAME: Final[WrapperField] = WrapperField("KitLotNumbers", FieldType.STRING, display_name="Kit Lot Numbers")
    LOTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("LotNumber", FieldType.STRING, display_name="Lot Number    ")
    LOTNUMBERDEFINED__FIELD_NAME: Final[WrapperField] = WrapperField("LotNumberDefined", FieldType.BOOLEAN, display_name="Lot Number Defined")
    MULTIPARENTLINK705__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink705", FieldType.MULTIPARENTLINK, display_name="Linked IlluminaSeqExperiments")
    PARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("PartNumber", FieldType.STRING, display_name="Part Number                       ")
    QUANTITYREMAINING__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityRemaining", FieldType.DOUBLE, display_name="Quantity")
    ROWPOSITION__FIELD_NAME: Final[WrapperField] = WrapperField("RowPosition", FieldType.SELECTION, display_name="Row Position")
    STORAGELOCATIONBARCODE__FIELD_NAME: Final[WrapperField] = WrapperField("StorageLocationBarcode", FieldType.SELECTION, display_name="Storage Location Barcode")
    STORAGEUNITPATH__FIELD_NAME: Final[WrapperField] = WrapperField("StorageUnitPath", FieldType.STRING, display_name="Storage Location Path")
    UNITS__FIELD_NAME: Final[WrapperField] = WrapperField("Units", FieldType.PICKLIST, display_name="Units")
    UNKNOWNEXPIRATION__FIELD_NAME: Final[WrapperField] = WrapperField("UnknownExpiration", FieldType.BOOLEAN, display_name="Unknown Expiration?")
    VALIDATED__FIELD_NAME: Final[WrapperField] = WrapperField("Validated", FieldType.BOOLEAN, display_name="Validated")
    VALIDATIONDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ValidationDate", FieldType.DATE, display_name="Validation Date")
    VALIDATIONEXPERIMENTID__FIELD_NAME: Final[WrapperField] = WrapperField("ValidationExperimentId", FieldType.STRING, display_name="Validation Experiment Id")
    VALIDATIONTECHICIAN__FIELD_NAME: Final[WrapperField] = WrapperField("ValidationTechician", FieldType.SELECTION, display_name="Validation Technician")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_BarcodeDefined_field(self, value: Optional[bool]):
        """
        Set data field with field name 'BarcodeDefined' on this record model
        """
        self.set_field_value(self.BARCODEDEFINED__FIELD_NAME.field_name, value)

    def get_BarcodeDefined_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'BarcodeDefined' from this record model
        """
        return self.get_field_value(self.BARCODEDEFINED__FIELD_NAME.field_name)

    def set_CASNo_field(self, value: Optional[str]):
        """
        Set data field with field name 'CASNo' on this record model
        """
        self.set_field_value(self.CASNO__FIELD_NAME.field_name, value)

    def get_CASNo_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CASNo' from this record model
        """
        return self.get_field_value(self.CASNO__FIELD_NAME.field_name)

    def set_ColPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColPosition' on this record model
        """
        self.set_field_value(self.COLPOSITION__FIELD_NAME.field_name, value)

    def get_ColPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColPosition' from this record model
        """
        return self.get_field_value(self.COLPOSITION__FIELD_NAME.field_name)

    def set_ConsumableBarcode_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableBarcode' on this record model
        """
        self.set_field_value(self.CONSUMABLEBARCODE__FIELD_NAME.field_name, value)

    def get_ConsumableBarcode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableBarcode' from this record model
        """
        return self.get_field_value(self.CONSUMABLEBARCODE__FIELD_NAME.field_name)

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def set_CostPerUnit_field(self, value: Optional[float]):
        """
        Set data field with field name 'CostPerUnit' on this record model
        """
        self.set_field_value(self.COSTPERUNIT__FIELD_NAME.field_name, value)

    def get_CostPerUnit_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CostPerUnit' from this record model
        """
        return self.get_field_value(self.COSTPERUNIT__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_Expired_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Expired' on this record model
        """
        self.set_field_value(self.EXPIRED__FIELD_NAME.field_name, value)

    def get_Expired_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Expired' from this record model
        """
        return self.get_field_value(self.EXPIRED__FIELD_NAME.field_name)

    def set_KitLotNumbers_field(self, value: Optional[str]):
        """
        Set data field with field name 'KitLotNumbers' on this record model
        """
        self.set_field_value(self.KITLOTNUMBERS__FIELD_NAME.field_name, value)

    def get_KitLotNumbers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'KitLotNumbers' from this record model
        """
        return self.get_field_value(self.KITLOTNUMBERS__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_LotNumberDefined_field(self, value: Optional[bool]):
        """
        Set data field with field name 'LotNumberDefined' on this record model
        """
        self.set_field_value(self.LOTNUMBERDEFINED__FIELD_NAME.field_name, value)

    def get_LotNumberDefined_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'LotNumberDefined' from this record model
        """
        return self.get_field_value(self.LOTNUMBERDEFINED__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_QuantityRemaining_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityRemaining' on this record model
        """
        self.set_field_value(self.QUANTITYREMAINING__FIELD_NAME.field_name, value)

    def get_QuantityRemaining_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityRemaining' from this record model
        """
        return self.get_field_value(self.QUANTITYREMAINING__FIELD_NAME.field_name)

    def set_RowPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'RowPosition' on this record model
        """
        self.set_field_value(self.ROWPOSITION__FIELD_NAME.field_name, value)

    def get_RowPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RowPosition' from this record model
        """
        return self.get_field_value(self.ROWPOSITION__FIELD_NAME.field_name)

    def set_StorageLocationBarcode_field(self, value: Optional[str]):
        """
        Set data field with field name 'StorageLocationBarcode' on this record model
        """
        self.set_field_value(self.STORAGELOCATIONBARCODE__FIELD_NAME.field_name, value)

    def get_StorageLocationBarcode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StorageLocationBarcode' from this record model
        """
        return self.get_field_value(self.STORAGELOCATIONBARCODE__FIELD_NAME.field_name)

    def set_StorageUnitPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'StorageUnitPath' on this record model
        """
        self.set_field_value(self.STORAGEUNITPATH__FIELD_NAME.field_name, value)

    def get_StorageUnitPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StorageUnitPath' from this record model
        """
        return self.get_field_value(self.STORAGEUNITPATH__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def set_UnknownExpiration_field(self, value: Optional[bool]):
        """
        Set data field with field name 'UnknownExpiration' on this record model
        """
        self.set_field_value(self.UNKNOWNEXPIRATION__FIELD_NAME.field_name, value)

    def get_UnknownExpiration_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'UnknownExpiration' from this record model
        """
        return self.get_field_value(self.UNKNOWNEXPIRATION__FIELD_NAME.field_name)

    def set_Validated_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Validated' on this record model
        """
        self.set_field_value(self.VALIDATED__FIELD_NAME.field_name, value)

    def get_Validated_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Validated' from this record model
        """
        return self.get_field_value(self.VALIDATED__FIELD_NAME.field_name)

    def set_ValidationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ValidationDate' on this record model
        """
        self.set_field_value(self.VALIDATIONDATE__FIELD_NAME.field_name, value)

    def get_ValidationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ValidationDate' from this record model
        """
        return self.get_field_value(self.VALIDATIONDATE__FIELD_NAME.field_name)

    def set_ValidationExperimentId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ValidationExperimentId' on this record model
        """
        self.set_field_value(self.VALIDATIONEXPERIMENTID__FIELD_NAME.field_name, value)

    def get_ValidationExperimentId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ValidationExperimentId' from this record model
        """
        return self.get_field_value(self.VALIDATIONEXPERIMENTID__FIELD_NAME.field_name)

    def set_ValidationTechician_field(self, value: Optional[str]):
        """
        Set data field with field name 'ValidationTechician' on this record model
        """
        self.set_field_value(self.VALIDATIONTECHICIAN__FIELD_NAME.field_name, value)

    def get_ValidationTechician_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ValidationTechician' from this record model
        """
        return self.get_field_value(self.VALIDATIONTECHICIAN__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ConsumableLotUsageModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ConsumableLotUsage
    Data Type Display Name: Consumable Lot Usage (Consumable Lot Usages)
    Fields: CreatedBy, DateCreated, LotRecordId, ConsumableBarcode, ActiveTaskId, ExpRecordId, LotNumberFieldName, DataRecordName, VeloxLastModifiedDate, QuantityUsed, VeloxLastModifiedBy, BarcodeFieldName, ElnId, LotNumber
    Data type used in workflows to allow memory of what is used.
    """
    DATA_TYPE_NAME: Final[str] = 'ConsumableLotUsage'
    DISPLAY_NAME: Final[str] = "Consumable Lot Usage"
    PLURAL_DISPLAY_NAME: Final[str] = "Consumable Lot Usages"
    ACTIVETASKID__FIELD_NAME: Final[WrapperField] = WrapperField("ActiveTaskId", FieldType.LONG, display_name="Unique ID (Numeric)")
    BARCODEFIELDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("BarcodeFieldName", FieldType.STRING, display_name="Barcode Field Name")
    CONSUMABLEBARCODE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableBarcode", FieldType.STRING, display_name="Barcode                                  ")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    ELNID__FIELD_NAME: Final[WrapperField] = WrapperField("ElnId", FieldType.STRING, display_name="Unique ID (Text)")
    EXPRECORDID__FIELD_NAME: Final[WrapperField] = WrapperField("ExpRecordId", FieldType.LONG, display_name="Experiment Record ID")
    LOTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("LotNumber", FieldType.STRING, display_name="Lot Number                           ")
    LOTNUMBERFIELDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("LotNumberFieldName", FieldType.STRING, display_name="Lot Number Field Name")
    LOTRECORDID__FIELD_NAME: Final[WrapperField] = WrapperField("LotRecordId", FieldType.LONG, display_name="Reagent Lot Record ID")
    QUANTITYUSED__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityUsed", FieldType.DOUBLE, display_name="Quantity Used")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ActiveTaskId_field(self, value: Optional[int]):
        """
        Set data field with field name 'ActiveTaskId' on this record model
        """
        self.set_field_value(self.ACTIVETASKID__FIELD_NAME.field_name, value)

    def get_ActiveTaskId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ActiveTaskId' from this record model
        """
        return self.get_field_value(self.ACTIVETASKID__FIELD_NAME.field_name)

    def set_BarcodeFieldName_field(self, value: Optional[str]):
        """
        Set data field with field name 'BarcodeFieldName' on this record model
        """
        self.set_field_value(self.BARCODEFIELDNAME__FIELD_NAME.field_name, value)

    def get_BarcodeFieldName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BarcodeFieldName' from this record model
        """
        return self.get_field_value(self.BARCODEFIELDNAME__FIELD_NAME.field_name)

    def set_ConsumableBarcode_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableBarcode' on this record model
        """
        self.set_field_value(self.CONSUMABLEBARCODE__FIELD_NAME.field_name, value)

    def get_ConsumableBarcode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableBarcode' from this record model
        """
        return self.get_field_value(self.CONSUMABLEBARCODE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ElnId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ElnId' on this record model
        """
        self.set_field_value(self.ELNID__FIELD_NAME.field_name, value)

    def get_ElnId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ElnId' from this record model
        """
        return self.get_field_value(self.ELNID__FIELD_NAME.field_name)

    def set_ExpRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpRecordId' on this record model
        """
        self.set_field_value(self.EXPRECORDID__FIELD_NAME.field_name, value)

    def get_ExpRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpRecordId' from this record model
        """
        return self.get_field_value(self.EXPRECORDID__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_LotNumberFieldName_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumberFieldName' on this record model
        """
        self.set_field_value(self.LOTNUMBERFIELDNAME__FIELD_NAME.field_name, value)

    def get_LotNumberFieldName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumberFieldName' from this record model
        """
        return self.get_field_value(self.LOTNUMBERFIELDNAME__FIELD_NAME.field_name)

    def set_LotRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'LotRecordId' on this record model
        """
        self.set_field_value(self.LOTRECORDID__FIELD_NAME.field_name, value)

    def get_LotRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'LotRecordId' from this record model
        """
        return self.get_field_value(self.LOTRECORDID__FIELD_NAME.field_name)

    def set_QuantityUsed_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityUsed' on this record model
        """
        self.set_field_value(self.QUANTITYUSED__FIELD_NAME.field_name, value)

    def get_QuantityUsed_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityUsed' from this record model
        """
        return self.get_field_value(self.QUANTITYUSED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DataLinkConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DataLinkConfig
    Data Type Display Name: Data Link Configuration (Data Link Configuration)
    Fields: CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated
    """
    DATA_TYPE_NAME: Final[str] = 'DataLinkConfig'
    DISPLAY_NAME: Final[str] = "Data Link Configuration"
    PLURAL_DISPLAY_NAME: Final[str] = "Data Link Configuration"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DataWarehouseRScriptModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DataWarehouseRScript
    Data Type Display Name: Data Warehouse R Script (Data Warehouse R Scripts)
    Fields: ScriptContent, CreatedBy, DataRecordName, VeloxLastModifiedDate, ScriptDescription, ScriptId, VeloxLastModifiedBy, DateCreated
    """
    DATA_TYPE_NAME: Final[str] = 'DataWarehouseRScript'
    DISPLAY_NAME: Final[str] = "Data Warehouse R Script"
    PLURAL_DISPLAY_NAME: Final[str] = "Data Warehouse R Scripts"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    SCRIPTCONTENT__FIELD_NAME: Final[WrapperField] = WrapperField("ScriptContent", FieldType.STRING, display_name="Script Content")
    SCRIPTDESCRIPTION__FIELD_NAME: Final[WrapperField] = WrapperField("ScriptDescription", FieldType.STRING, display_name="Script Description")
    SCRIPTID__FIELD_NAME: Final[WrapperField] = WrapperField("ScriptId", FieldType.STRING, display_name="Script ID")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ScriptContent_field(self, value: Optional[str]):
        """
        Set data field with field name 'ScriptContent' on this record model
        """
        self.set_field_value(self.SCRIPTCONTENT__FIELD_NAME.field_name, value)

    def get_ScriptContent_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ScriptContent' from this record model
        """
        return self.get_field_value(self.SCRIPTCONTENT__FIELD_NAME.field_name)

    def set_ScriptDescription_field(self, value: Optional[str]):
        """
        Set data field with field name 'ScriptDescription' on this record model
        """
        self.set_field_value(self.SCRIPTDESCRIPTION__FIELD_NAME.field_name, value)

    def get_ScriptDescription_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ScriptDescription' from this record model
        """
        return self.get_field_value(self.SCRIPTDESCRIPTION__FIELD_NAME.field_name)

    def set_ScriptId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ScriptId' on this record model
        """
        self.set_field_value(self.SCRIPTID__FIELD_NAME.field_name, value)

    def get_ScriptId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ScriptId' from this record model
        """
        return self.get_field_value(self.SCRIPTID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DirectoryModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Directory
    Data Type Display Name: Directory (Directories)
    Fields: CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, DirectoryName
    """
    DATA_TYPE_NAME: Final[str] = 'Directory'
    DISPLAY_NAME: Final[str] = "Directory"
    PLURAL_DISPLAY_NAME: Final[str] = "Directories"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DIRECTORYNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DirectoryName", FieldType.STRING, display_name="Directory Name")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DirectoryName_field(self, value: Optional[str]):
        """
        Set data field with field name 'DirectoryName' on this record model
        """
        self.set_field_value(self.DIRECTORYNAME__FIELD_NAME.field_name, value)

    def get_DirectoryName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DirectoryName' from this record model
        """
        return self.get_field_value(self.DIRECTORYNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DNAModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DNA
    Data Type Display Name: DNA (DNAs)
    Fields: CreatedBy, DataRecordName, ExpirationDate, PartNumber, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, SequenceType, ItemId, Name
    """
    DATA_TYPE_NAME: Final[str] = 'DNA'
    DISPLAY_NAME: Final[str] = "DNA"
    PLURAL_DISPLAY_NAME: Final[str] = "DNAs"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EXPIRATIONDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ExpirationDate", FieldType.DATE, display_name="Expiration Date")
    ITEMID__FIELD_NAME: Final[WrapperField] = WrapperField("ItemId", FieldType.STRING, display_name="Lot Number")
    NAME__FIELD_NAME: Final[WrapperField] = WrapperField("Name", FieldType.STRING, display_name="Name")
    PARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("PartNumber", FieldType.STRING, display_name="Registry ID")
    SEQUENCETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("SequenceType", FieldType.PICKLIST, display_name="Sequence Type")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_ItemId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ItemId' on this record model
        """
        self.set_field_value(self.ITEMID__FIELD_NAME.field_name, value)

    def get_ItemId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ItemId' from this record model
        """
        return self.get_field_value(self.ITEMID__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_SequenceType_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceType' on this record model
        """
        self.set_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name, value)

    def get_SequenceType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceType' from this record model
        """
        return self.get_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DNAPartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DNAPart
    Data Type Display Name: DNA Part (DNA Parts)
    Fields: Description, CreatedBy, PartNumber, SequenceHash, EditLock, DateCreated, SequenceType, Sequence, QuantityOnHand, GenebankAttachment, Name, DataRecordName, IsCircular, VeloxLastModifiedDate, VeloxLastModifiedBy, GenbankAttachment, SourcePart
    <-- VIRTUAL ENTITY DATA TYPE -->
    """
    DATA_TYPE_NAME: Final[str] = 'DNAPart'
    DISPLAY_NAME: Final[str] = "DNA Part"
    PLURAL_DISPLAY_NAME: Final[str] = "DNA Parts"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DESCRIPTION__FIELD_NAME: Final[WrapperField] = WrapperField("Description", FieldType.STRING, display_name="Description")
    EDITLOCK__FIELD_NAME: Final[WrapperField] = WrapperField("EditLock", FieldType.BOOLEAN, display_name="Edit Lock")
    GENBANKATTACHMENT__FIELD_NAME: Final[WrapperField] = WrapperField("GenbankAttachment", FieldType.SIDE_LINK, display_name="Genbank Attachment")
    GENEBANKATTACHMENT__FIELD_NAME: Final[WrapperField] = WrapperField("GenebankAttachment", FieldType.STRING, display_name="Related Genbank File (OLD)")
    ISCIRCULAR__FIELD_NAME: Final[WrapperField] = WrapperField("IsCircular", FieldType.BOOLEAN, display_name="Is Circular")
    NAME__FIELD_NAME: Final[WrapperField] = WrapperField("Name", FieldType.STRING, display_name="Name")
    PARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("PartNumber", FieldType.STRING, display_name="Registry ID")
    QUANTITYONHAND__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityOnHand", FieldType.DOUBLE, display_name="Quantity On Hand")
    SEQUENCE__FIELD_NAME: Final[WrapperField] = WrapperField("Sequence", FieldType.STRING, display_name="Sequence")
    SEQUENCEHASH__FIELD_NAME: Final[WrapperField] = WrapperField("SequenceHash", FieldType.STRING, display_name="Sequence Hash")
    SEQUENCETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("SequenceType", FieldType.PICKLIST, display_name="Sequence Type")
    SOURCEPART__FIELD_NAME: Final[WrapperField] = WrapperField("SourcePart", FieldType.SIDE_LINK, display_name="Source Part")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Description_field(self, value: Optional[str]):
        """
        Set data field with field name 'Description' on this record model
        """
        self.set_field_value(self.DESCRIPTION__FIELD_NAME.field_name, value)

    def get_Description_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Description' from this record model
        """
        return self.get_field_value(self.DESCRIPTION__FIELD_NAME.field_name)

    def set_EditLock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EditLock' on this record model
        """
        self.set_field_value(self.EDITLOCK__FIELD_NAME.field_name, value)

    def get_EditLock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EditLock' from this record model
        """
        return self.get_field_value(self.EDITLOCK__FIELD_NAME.field_name)

    def set_GenbankAttachment_field(self, value: Optional[int]):
        """
        Set data field with field name 'GenbankAttachment' on this record model
        """
        self.set_field_value(self.GENBANKATTACHMENT__FIELD_NAME.field_name, value)

    def get_GenbankAttachment_field(self) -> Optional[int]:
        """
        Get data field value with field name 'GenbankAttachment' from this record model
        """
        return self.get_field_value(self.GENBANKATTACHMENT__FIELD_NAME.field_name)

    def set_GenebankAttachment_field(self, value: Optional[str]):
        """
        Set data field with field name 'GenebankAttachment' on this record model
        """
        self.set_field_value(self.GENEBANKATTACHMENT__FIELD_NAME.field_name, value)

    def get_GenebankAttachment_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GenebankAttachment' from this record model
        """
        return self.get_field_value(self.GENEBANKATTACHMENT__FIELD_NAME.field_name)

    def set_IsCircular_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsCircular' on this record model
        """
        self.set_field_value(self.ISCIRCULAR__FIELD_NAME.field_name, value)

    def get_IsCircular_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsCircular' from this record model
        """
        return self.get_field_value(self.ISCIRCULAR__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_Sequence_field(self, value: Optional[str]):
        """
        Set data field with field name 'Sequence' on this record model
        """
        self.set_field_value(self.SEQUENCE__FIELD_NAME.field_name, value)

    def get_Sequence_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Sequence' from this record model
        """
        return self.get_field_value(self.SEQUENCE__FIELD_NAME.field_name)

    def set_SequenceHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceHash' on this record model
        """
        self.set_field_value(self.SEQUENCEHASH__FIELD_NAME.field_name, value)

    def get_SequenceHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceHash' from this record model
        """
        return self.get_field_value(self.SEQUENCEHASH__FIELD_NAME.field_name)

    def set_SequenceType_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequenceType' on this record model
        """
        self.set_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name, value)

    def get_SequenceType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequenceType' from this record model
        """
        return self.get_field_value(self.SEQUENCETYPE__FIELD_NAME.field_name)

    def set_SourcePart_field(self, value: Optional[int]):
        """
        Set data field with field name 'SourcePart' on this record model
        """
        self.set_field_value(self.SOURCEPART__FIELD_NAME.field_name, value)

    def get_SourcePart_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SourcePart' from this record model
        """
        return self.get_field_value(self.SOURCEPART__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DNAPartFragmentModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DNAPartFragment
    Data Type Display Name: DNA Part Fragment (DNA Part Fragments)
    Fields: FragmentEnd, CreatedBy, FragOH5, DateCreated, FragOH3, SourcePartSideLink, Problems, DataRecordName, FragmentStart, VeloxLastModifiedDate, VeloxLastModifiedBy, IsBackwardDirection
    """
    DATA_TYPE_NAME: Final[str] = 'DNAPartFragment'
    DISPLAY_NAME: Final[str] = "DNA Part Fragment"
    PLURAL_DISPLAY_NAME: Final[str] = "DNA Part Fragments"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FRAGOH3__FIELD_NAME: Final[WrapperField] = WrapperField("FragOH3", FieldType.STRING, display_name="Fragment 3' Overhang")
    FRAGOH5__FIELD_NAME: Final[WrapperField] = WrapperField("FragOH5", FieldType.STRING, display_name="Fragment 5' Overhang")
    FRAGMENTEND__FIELD_NAME: Final[WrapperField] = WrapperField("FragmentEnd", FieldType.INTEGER, display_name="Fragment End")
    FRAGMENTSTART__FIELD_NAME: Final[WrapperField] = WrapperField("FragmentStart", FieldType.INTEGER, display_name="Fragment Start")
    ISBACKWARDDIRECTION__FIELD_NAME: Final[WrapperField] = WrapperField("IsBackwardDirection", FieldType.BOOLEAN, display_name="Is Backward Direction")
    PROBLEMS__FIELD_NAME: Final[WrapperField] = WrapperField("Problems", FieldType.STRING, display_name="Problems")
    SOURCEPARTSIDELINK__FIELD_NAME: Final[WrapperField] = WrapperField("SourcePartSideLink", FieldType.SIDE_LINK, display_name="Source Part Side Link")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FragOH3_field(self, value: Optional[str]):
        """
        Set data field with field name 'FragOH3' on this record model
        """
        self.set_field_value(self.FRAGOH3__FIELD_NAME.field_name, value)

    def get_FragOH3_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FragOH3' from this record model
        """
        return self.get_field_value(self.FRAGOH3__FIELD_NAME.field_name)

    def set_FragOH5_field(self, value: Optional[str]):
        """
        Set data field with field name 'FragOH5' on this record model
        """
        self.set_field_value(self.FRAGOH5__FIELD_NAME.field_name, value)

    def get_FragOH5_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FragOH5' from this record model
        """
        return self.get_field_value(self.FRAGOH5__FIELD_NAME.field_name)

    def set_FragmentEnd_field(self, value: Optional[int]):
        """
        Set data field with field name 'FragmentEnd' on this record model
        """
        self.set_field_value(self.FRAGMENTEND__FIELD_NAME.field_name, value)

    def get_FragmentEnd_field(self) -> Optional[int]:
        """
        Get data field value with field name 'FragmentEnd' from this record model
        """
        return self.get_field_value(self.FRAGMENTEND__FIELD_NAME.field_name)

    def set_FragmentStart_field(self, value: Optional[int]):
        """
        Set data field with field name 'FragmentStart' on this record model
        """
        self.set_field_value(self.FRAGMENTSTART__FIELD_NAME.field_name, value)

    def get_FragmentStart_field(self) -> Optional[int]:
        """
        Get data field value with field name 'FragmentStart' from this record model
        """
        return self.get_field_value(self.FRAGMENTSTART__FIELD_NAME.field_name)

    def set_IsBackwardDirection_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsBackwardDirection' on this record model
        """
        self.set_field_value(self.ISBACKWARDDIRECTION__FIELD_NAME.field_name, value)

    def get_IsBackwardDirection_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsBackwardDirection' from this record model
        """
        return self.get_field_value(self.ISBACKWARDDIRECTION__FIELD_NAME.field_name)

    def set_Problems_field(self, value: Optional[str]):
        """
        Set data field with field name 'Problems' on this record model
        """
        self.set_field_value(self.PROBLEMS__FIELD_NAME.field_name, value)

    def get_Problems_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Problems' from this record model
        """
        return self.get_field_value(self.PROBLEMS__FIELD_NAME.field_name)

    def set_SourcePartSideLink_field(self, value: Optional[int]):
        """
        Set data field with field name 'SourcePartSideLink' on this record model
        """
        self.set_field_value(self.SOURCEPARTSIDELINK__FIELD_NAME.field_name, value)

    def get_SourcePartSideLink_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SourcePartSideLink' from this record model
        """
        return self.get_field_value(self.SOURCEPARTSIDELINK__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DoseResponseModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DoseResponse
    Data Type Display Name: Dose Response (Dose Responses)
    Fields: Response, CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, Dose
    """
    DATA_TYPE_NAME: Final[str] = 'DoseResponse'
    DISPLAY_NAME: Final[str] = "Dose Response"
    PLURAL_DISPLAY_NAME: Final[str] = "Dose Responses"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DOSE__FIELD_NAME: Final[WrapperField] = WrapperField("Dose", FieldType.DOUBLE, display_name="Dose")
    RESPONSE__FIELD_NAME: Final[WrapperField] = WrapperField("Response", FieldType.DOUBLE, display_name="Response")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_Dose_field(self, value: Optional[float]):
        """
        Set data field with field name 'Dose' on this record model
        """
        self.set_field_value(self.DOSE__FIELD_NAME.field_name, value)

    def get_Dose_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Dose' from this record model
        """
        return self.get_field_value(self.DOSE__FIELD_NAME.field_name)

    def set_Response_field(self, value: Optional[float]):
        """
        Set data field with field name 'Response' on this record model
        """
        self.set_field_value(self.RESPONSE__FIELD_NAME.field_name, value)

    def get_Response_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Response' from this record model
        """
        return self.get_field_value(self.RESPONSE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DosingResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DosingResult
    Data Type Display Name: Dosing Result (Dosing Results)
    Fields: CreatedBy, DoseResult, RouteOfAdministration, DateCreated, ExpectedDose, DoseType, DataRecordName, TreatmentRecordId, TreatmentId, DateCompleted, Formulation, DoseComments, VeloxLastModifiedDate, VeloxLastModifiedBy, DoseUnit, AgentName, BaseDosage, ActualDose
    """
    DATA_TYPE_NAME: Final[str] = 'DosingResult'
    DISPLAY_NAME: Final[str] = "Dosing Result"
    PLURAL_DISPLAY_NAME: Final[str] = "Dosing Results"
    ACTUALDOSE__FIELD_NAME: Final[WrapperField] = WrapperField("ActualDose", FieldType.DOUBLE, display_name="Actual Dose")
    AGENTNAME__FIELD_NAME: Final[WrapperField] = WrapperField("AgentName", FieldType.SELECTION, display_name="Agent")
    BASEDOSAGE__FIELD_NAME: Final[WrapperField] = WrapperField("BaseDosage", FieldType.DOUBLE, display_name="Base Dose")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECOMPLETED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCompleted", FieldType.DATE, display_name="Date Completed")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DOSECOMMENTS__FIELD_NAME: Final[WrapperField] = WrapperField("DoseComments", FieldType.STRING, display_name="Comments")
    DOSERESULT__FIELD_NAME: Final[WrapperField] = WrapperField("DoseResult", FieldType.PICKLIST, display_name="Dose Result")
    DOSETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("DoseType", FieldType.PICKLIST, display_name="Dose Type")
    DOSEUNIT__FIELD_NAME: Final[WrapperField] = WrapperField("DoseUnit", FieldType.SELECTION, display_name="Dose Unit")
    EXPECTEDDOSE__FIELD_NAME: Final[WrapperField] = WrapperField("ExpectedDose", FieldType.DOUBLE, display_name="Expected Dose")
    FORMULATION__FIELD_NAME: Final[WrapperField] = WrapperField("Formulation", FieldType.SELECTION, display_name="Formulation")
    ROUTEOFADMINISTRATION__FIELD_NAME: Final[WrapperField] = WrapperField("RouteOfAdministration", FieldType.SELECTION, display_name="Administration Route")
    TREATMENTID__FIELD_NAME: Final[WrapperField] = WrapperField("TreatmentId", FieldType.STRING, display_name="Treatment Id")
    TREATMENTRECORDID__FIELD_NAME: Final[WrapperField] = WrapperField("TreatmentRecordId", FieldType.LONG, display_name="Treatment Record ID")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ActualDose_field(self, value: Optional[float]):
        """
        Set data field with field name 'ActualDose' on this record model
        """
        self.set_field_value(self.ACTUALDOSE__FIELD_NAME.field_name, value)

    def get_ActualDose_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ActualDose' from this record model
        """
        return self.get_field_value(self.ACTUALDOSE__FIELD_NAME.field_name)

    def set_AgentName_field(self, value: Optional[str]):
        """
        Set data field with field name 'AgentName' on this record model
        """
        self.set_field_value(self.AGENTNAME__FIELD_NAME.field_name, value)

    def get_AgentName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AgentName' from this record model
        """
        return self.get_field_value(self.AGENTNAME__FIELD_NAME.field_name)

    def set_BaseDosage_field(self, value: Optional[float]):
        """
        Set data field with field name 'BaseDosage' on this record model
        """
        self.set_field_value(self.BASEDOSAGE__FIELD_NAME.field_name, value)

    def get_BaseDosage_field(self) -> Optional[float]:
        """
        Get data field value with field name 'BaseDosage' from this record model
        """
        return self.get_field_value(self.BASEDOSAGE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DateCompleted_field(self, value: Optional[int]):
        """
        Set data field with field name 'DateCompleted' on this record model
        """
        self.set_field_value(self.DATECOMPLETED__FIELD_NAME.field_name, value)

    def get_DateCompleted_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCompleted' from this record model
        """
        return self.get_field_value(self.DATECOMPLETED__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DoseComments_field(self, value: Optional[str]):
        """
        Set data field with field name 'DoseComments' on this record model
        """
        self.set_field_value(self.DOSECOMMENTS__FIELD_NAME.field_name, value)

    def get_DoseComments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DoseComments' from this record model
        """
        return self.get_field_value(self.DOSECOMMENTS__FIELD_NAME.field_name)

    def set_DoseResult_field(self, value: Optional[str]):
        """
        Set data field with field name 'DoseResult' on this record model
        """
        self.set_field_value(self.DOSERESULT__FIELD_NAME.field_name, value)

    def get_DoseResult_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DoseResult' from this record model
        """
        return self.get_field_value(self.DOSERESULT__FIELD_NAME.field_name)

    def set_DoseType_field(self, value: Optional[str]):
        """
        Set data field with field name 'DoseType' on this record model
        """
        self.set_field_value(self.DOSETYPE__FIELD_NAME.field_name, value)

    def get_DoseType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DoseType' from this record model
        """
        return self.get_field_value(self.DOSETYPE__FIELD_NAME.field_name)

    def set_DoseUnit_field(self, value: Optional[str]):
        """
        Set data field with field name 'DoseUnit' on this record model
        """
        self.set_field_value(self.DOSEUNIT__FIELD_NAME.field_name, value)

    def get_DoseUnit_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DoseUnit' from this record model
        """
        return self.get_field_value(self.DOSEUNIT__FIELD_NAME.field_name)

    def set_ExpectedDose_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExpectedDose' on this record model
        """
        self.set_field_value(self.EXPECTEDDOSE__FIELD_NAME.field_name, value)

    def get_ExpectedDose_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExpectedDose' from this record model
        """
        return self.get_field_value(self.EXPECTEDDOSE__FIELD_NAME.field_name)

    def set_Formulation_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formulation' on this record model
        """
        self.set_field_value(self.FORMULATION__FIELD_NAME.field_name, value)

    def get_Formulation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formulation' from this record model
        """
        return self.get_field_value(self.FORMULATION__FIELD_NAME.field_name)

    def set_RouteOfAdministration_field(self, value: Optional[str]):
        """
        Set data field with field name 'RouteOfAdministration' on this record model
        """
        self.set_field_value(self.ROUTEOFADMINISTRATION__FIELD_NAME.field_name, value)

    def get_RouteOfAdministration_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RouteOfAdministration' from this record model
        """
        return self.get_field_value(self.ROUTEOFADMINISTRATION__FIELD_NAME.field_name)

    def set_TreatmentId_field(self, value: Optional[str]):
        """
        Set data field with field name 'TreatmentId' on this record model
        """
        self.set_field_value(self.TREATMENTID__FIELD_NAME.field_name, value)

    def get_TreatmentId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TreatmentId' from this record model
        """
        return self.get_field_value(self.TREATMENTID__FIELD_NAME.field_name)

    def set_TreatmentRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'TreatmentRecordId' on this record model
        """
        self.set_field_value(self.TREATMENTRECORDID__FIELD_NAME.field_name, value)

    def get_TreatmentRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TreatmentRecordId' from this record model
        """
        return self.get_field_value(self.TREATMENTRECORDID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DownstreamProcessingYieldModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DownstreamProcessingYield
    Data Type Display Name: Downstream Processing Yield (Downstream Processing Yields)
    Fields: MultiParentLink215, OtherSampleId, CentrifugationYield, CreatedBy, DataRecordName, DiafiltrationYield, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, SampleId
    """
    DATA_TYPE_NAME: Final[str] = 'DownstreamProcessingYield'
    DISPLAY_NAME: Final[str] = "Downstream Processing Yield"
    PLURAL_DISPLAY_NAME: Final[str] = "Downstream Processing Yields"
    CENTRIFUGATIONYIELD__FIELD_NAME: Final[WrapperField] = WrapperField("CentrifugationYield", FieldType.DOUBLE, display_name="Centrifugation % Yield")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DIAFILTRATIONYIELD__FIELD_NAME: Final[WrapperField] = WrapperField("DiafiltrationYield", FieldType.DOUBLE, display_name="Diafiltration % Yield")
    MULTIPARENTLINK215__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK, display_name="Linked Sample")
    OTHERSAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("OtherSampleId", FieldType.STRING, display_name="Sample Name")
    SAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("SampleId", FieldType.STRING, display_name="Sample ID")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CentrifugationYield_field(self, value: Optional[float]):
        """
        Set data field with field name 'CentrifugationYield' on this record model
        """
        self.set_field_value(self.CENTRIFUGATIONYIELD__FIELD_NAME.field_name, value)

    def get_CentrifugationYield_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CentrifugationYield' from this record model
        """
        return self.get_field_value(self.CENTRIFUGATIONYIELD__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DiafiltrationYield_field(self, value: Optional[float]):
        """
        Set data field with field name 'DiafiltrationYield' on this record model
        """
        self.set_field_value(self.DIAFILTRATIONYIELD__FIELD_NAME.field_name, value)

    def get_DiafiltrationYield_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DiafiltrationYield' from this record model
        """
        return self.get_field_value(self.DIAFILTRATIONYIELD__FIELD_NAME.field_name)

    def set_OtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'OtherSampleId' on this record model
        """
        self.set_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_OtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OtherSampleId' from this record model
        """
        return self.get_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DropSenseA260ResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DropSenseA260Result
    Data Type Display Name: DropSense A260 Result (DropSense A260 Results)
    Fields: DilutionFactor, A260230, CreatedBy, DataRecordName, VeloxLastModifiedDate, A260280, VeloxLastModifiedBy, DateCreated
    """
    DATA_TYPE_NAME: Final[str] = 'DropSenseA260Result'
    DISPLAY_NAME: Final[str] = "DropSense A260 Result"
    PLURAL_DISPLAY_NAME: Final[str] = "DropSense A260 Results"
    A260230__FIELD_NAME: Final[WrapperField] = WrapperField("A260230", FieldType.DOUBLE, display_name="A260/230")
    A260280__FIELD_NAME: Final[WrapperField] = WrapperField("A260280", FieldType.DOUBLE, display_name="A260/280")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DILUTIONFACTOR__FIELD_NAME: Final[WrapperField] = WrapperField("DilutionFactor", FieldType.DOUBLE, display_name="Dilution Factor")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_A260230_field(self, value: Optional[float]):
        """
        Set data field with field name 'A260230' on this record model
        """
        self.set_field_value(self.A260230__FIELD_NAME.field_name, value)

    def get_A260230_field(self) -> Optional[float]:
        """
        Get data field value with field name 'A260230' from this record model
        """
        return self.get_field_value(self.A260230__FIELD_NAME.field_name)

    def set_A260280_field(self, value: Optional[float]):
        """
        Set data field with field name 'A260280' on this record model
        """
        self.set_field_value(self.A260280__FIELD_NAME.field_name, value)

    def get_A260280_field(self) -> Optional[float]:
        """
        Get data field value with field name 'A260280' from this record model
        """
        return self.get_field_value(self.A260280__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DilutionFactor_field(self, value: Optional[float]):
        """
        Set data field with field name 'DilutionFactor' on this record model
        """
        self.set_field_value(self.DILUTIONFACTOR__FIELD_NAME.field_name, value)

    def get_DilutionFactor_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DilutionFactor' from this record model
        """
        return self.get_field_value(self.DILUTIONFACTOR__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class DropSenseA280ResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type DropSenseA280Result
    Data Type Display Name: DropSense A280 Result (DropSense A280 Results)
    Fields: ExtinctionCoefficient, CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated
    """
    DATA_TYPE_NAME: Final[str] = 'DropSenseA280Result'
    DISPLAY_NAME: Final[str] = "DropSense A280 Result"
    PLURAL_DISPLAY_NAME: Final[str] = "DropSense A280 Results"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EXTINCTIONCOEFFICIENT__FIELD_NAME: Final[WrapperField] = WrapperField("ExtinctionCoefficient", FieldType.DOUBLE, display_name="E1%")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExtinctionCoefficient_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExtinctionCoefficient' on this record model
        """
        self.set_field_value(self.EXTINCTIONCOEFFICIENT__FIELD_NAME.field_name, value)

    def get_ExtinctionCoefficient_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExtinctionCoefficient' from this record model
        """
        return self.get_field_value(self.EXTINCTIONCOEFFICIENT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ELNExperimentModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ELNExperiment
    Data Type Display Name: Experiment (Experiments)
    Fields: VELOXOWNER, VeloxCompletedBy, VeloxExperimentStatus, VeloxDateCompleted, CreatedBy, TemplateVersion, DateCreated, DataRecordName, DataTypeId, VeloxLastModifiedDate, VeloxLastModifiedBy, TemplateExperimentName
    Data type to represent the base E-Notebook data type.
    """
    DATA_TYPE_NAME: Final[str] = 'ELNExperiment'
    DISPLAY_NAME: Final[str] = "Experiment"
    PLURAL_DISPLAY_NAME: Final[str] = "Experiments"
    CHECKSTUDYINFO__FIELD_NAME: Final[WrapperField] = WrapperField("CheckStudyInfo", FieldType.BOOLEAN, display_name="Check Study Design Info?")
    CLUSTERWITHCBOT__FIELD_NAME: Final[WrapperField] = WrapperField("ClusterWithCBot", FieldType.BOOLEAN, display_name="Cluster With CBot")
    COMMENTS__FIELD_NAME: Final[WrapperField] = WrapperField("Comments", FieldType.STRING, display_name="Comments")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATATYPEID__FIELD_NAME: Final[WrapperField] = WrapperField("DataTypeId", FieldType.LONG, display_name="Data Type ID")
    DATECOMPLETED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCompleted", FieldType.DATE, display_name="Date Completed")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EXPERIMENTDESCRIPTION__FIELD_NAME: Final[WrapperField] = WrapperField("ExperimentDescription", FieldType.STRING, display_name="Experiment Description")
    FLOWCELLID__FIELD_NAME: Final[WrapperField] = WrapperField("FlowcellId", FieldType.STRING, display_name="Flow Cell ID")
    ILLUMINASEQTEMPLATEDESCRIPTION__FIELD_NAME: Final[WrapperField] = WrapperField("IlluminaSeqTemplateDescription", FieldType.STRING, display_name="Description")
    PTCAUTONAMEID__FIELD_NAME: Final[WrapperField] = WrapperField("PTCAutoNameID", FieldType.STRING, display_name="Autoname")
    PTCGROUP__FIELD_NAME: Final[WrapperField] = WrapperField("PTCGroup", FieldType.STRING, display_name="Group")
    PTCNOTES__FIELD_NAME: Final[WrapperField] = WrapperField("PTCNotes", FieldType.STRING, display_name="Notes")
    PTCSCIENTISTUSER__FIELD_NAME: Final[WrapperField] = WrapperField("PTCScientistUser", FieldType.STRING, display_name="Scientist")
    RECEIVEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ReceivedDate", FieldType.DATE, display_name="Received Date")
    RUNCOMPLETED__FIELD_NAME: Final[WrapperField] = WrapperField("RunCompleted", FieldType.BOOLEAN, display_name="Run Completed")
    RUNID__FIELD_NAME: Final[WrapperField] = WrapperField("RunId", FieldType.STRING, display_name="Run ID")
    SAMPLERECEIVER__FIELD_NAME: Final[WrapperField] = WrapperField("SampleReceiver", FieldType.SELECTION, display_name="Sample Receiver")
    SEQUENCERINSTRUMENT__FIELD_NAME: Final[WrapperField] = WrapperField("SequencerInstrument", FieldType.SELECTION, display_name="Sequencer Used")
    SEQUENCERRUNDATE__FIELD_NAME: Final[WrapperField] = WrapperField("SequencerRunDate", FieldType.DATE, display_name="Sequencer Run Date")
    SEQUENCERRUNFOLDER__FIELD_NAME: Final[WrapperField] = WrapperField("SequencerRunFolder", FieldType.STRING, display_name="Sequencer Run Folder")
    SEQUENCINGRUNMODE__FIELD_NAME: Final[WrapperField] = WrapperField("SequencingRunMode", FieldType.PICKLIST, display_name="Sequencing Run Mode")
    SHIPDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ShipDate", FieldType.DATE, display_name="Ship Date")
    SHIPPEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("ShippedBy", FieldType.STRING, display_name="Shipped By")
    SHIPPINGCOURIER__FIELD_NAME: Final[WrapperField] = WrapperField("ShippingCourier", FieldType.PICKLIST, display_name="Shipping Courier")
    SIDE__FIELD_NAME: Final[WrapperField] = WrapperField("Side", FieldType.STRING, display_name="Side")
    TEMPLATEEXPERIMENTNAME__FIELD_NAME: Final[WrapperField] = WrapperField("TemplateExperimentName", FieldType.STRING, display_name="Template Experiment")
    TEMPLATEVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("TemplateVersion", FieldType.LONG, display_name="Template Version")
    TIMECOMPLETED__FIELD_NAME: Final[WrapperField] = WrapperField("TimeCompleted", FieldType.STRING, display_name="Time Completed")
    TRACKINGNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("TrackingNumber", FieldType.STRING, display_name="Tracking #")
    VELOXOWNER__FIELD_NAME: Final[WrapperField] = WrapperField("VELOXOWNER", FieldType.STRING, display_name="Owner")
    VELOXCOMPLETEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCompletedBy", FieldType.STRING, display_name="Completed By")
    VELOXDATECOMPLETED__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxDateCompleted", FieldType.DATE, display_name="Date Completed")
    VELOXEXPERIMENTSTATUS__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxExperimentStatus", FieldType.STRING, display_name="Experiment Status")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_CheckStudyInfo_field(self, value: Optional[bool]):
        """
        Set data field with field name 'CheckStudyInfo' on this record model
        """
        self.set_field_value(self.CHECKSTUDYINFO__FIELD_NAME.field_name, value)

    def get_CheckStudyInfo_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'CheckStudyInfo' from this record model
        """
        return self.get_field_value(self.CHECKSTUDYINFO__FIELD_NAME.field_name)

    def set_ClusterWithCBot_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ClusterWithCBot' on this record model
        """
        self.set_field_value(self.CLUSTERWITHCBOT__FIELD_NAME.field_name, value)

    def get_ClusterWithCBot_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ClusterWithCBot' from this record model
        """
        return self.get_field_value(self.CLUSTERWITHCBOT__FIELD_NAME.field_name)

    def set_Comments_field(self, value: Optional[str]):
        """
        Set data field with field name 'Comments' on this record model
        """
        self.set_field_value(self.COMMENTS__FIELD_NAME.field_name, value)

    def get_Comments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Comments' from this record model
        """
        return self.get_field_value(self.COMMENTS__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DataTypeId_field(self, value: Optional[int]):
        """
        Set data field with field name 'DataTypeId' on this record model
        """
        self.set_field_value(self.DATATYPEID__FIELD_NAME.field_name, value)

    def get_DataTypeId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DataTypeId' from this record model
        """
        return self.get_field_value(self.DATATYPEID__FIELD_NAME.field_name)

    def set_DateCompleted_field(self, value: Optional[int]):
        """
        Set data field with field name 'DateCompleted' on this record model
        """
        self.set_field_value(self.DATECOMPLETED__FIELD_NAME.field_name, value)

    def get_DateCompleted_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCompleted' from this record model
        """
        return self.get_field_value(self.DATECOMPLETED__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExperimentDescription_field(self, value: Optional[str]):
        """
        Set data field with field name 'ExperimentDescription' on this record model
        """
        self.set_field_value(self.EXPERIMENTDESCRIPTION__FIELD_NAME.field_name, value)

    def get_ExperimentDescription_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ExperimentDescription' from this record model
        """
        return self.get_field_value(self.EXPERIMENTDESCRIPTION__FIELD_NAME.field_name)

    def set_FlowcellId_field(self, value: Optional[str]):
        """
        Set data field with field name 'FlowcellId' on this record model
        """
        self.set_field_value(self.FLOWCELLID__FIELD_NAME.field_name, value)

    def get_FlowcellId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FlowcellId' from this record model
        """
        return self.get_field_value(self.FLOWCELLID__FIELD_NAME.field_name)

    def set_IlluminaSeqTemplateDescription_field(self, value: Optional[str]):
        """
        Set data field with field name 'IlluminaSeqTemplateDescription' on this record model
        """
        self.set_field_value(self.ILLUMINASEQTEMPLATEDESCRIPTION__FIELD_NAME.field_name, value)

    def get_IlluminaSeqTemplateDescription_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IlluminaSeqTemplateDescription' from this record model
        """
        return self.get_field_value(self.ILLUMINASEQTEMPLATEDESCRIPTION__FIELD_NAME.field_name)

    def set_PTCAutoNameID_field(self, value: Optional[str]):
        """
        Set data field with field name 'PTCAutoNameID' on this record model
        """
        self.set_field_value(self.PTCAUTONAMEID__FIELD_NAME.field_name, value)

    def get_PTCAutoNameID_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PTCAutoNameID' from this record model
        """
        return self.get_field_value(self.PTCAUTONAMEID__FIELD_NAME.field_name)

    def set_PTCGroup_field(self, value: Optional[str]):
        """
        Set data field with field name 'PTCGroup' on this record model
        """
        self.set_field_value(self.PTCGROUP__FIELD_NAME.field_name, value)

    def get_PTCGroup_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PTCGroup' from this record model
        """
        return self.get_field_value(self.PTCGROUP__FIELD_NAME.field_name)

    def set_PTCNotes_field(self, value: Optional[str]):
        """
        Set data field with field name 'PTCNotes' on this record model
        """
        self.set_field_value(self.PTCNOTES__FIELD_NAME.field_name, value)

    def get_PTCNotes_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PTCNotes' from this record model
        """
        return self.get_field_value(self.PTCNOTES__FIELD_NAME.field_name)

    def set_PTCScientistUser_field(self, value: Optional[str]):
        """
        Set data field with field name 'PTCScientistUser' on this record model
        """
        self.set_field_value(self.PTCSCIENTISTUSER__FIELD_NAME.field_name, value)

    def get_PTCScientistUser_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PTCScientistUser' from this record model
        """
        return self.get_field_value(self.PTCSCIENTISTUSER__FIELD_NAME.field_name)

    def set_ReceivedDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ReceivedDate' on this record model
        """
        self.set_field_value(self.RECEIVEDDATE__FIELD_NAME.field_name, value)

    def get_ReceivedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ReceivedDate' from this record model
        """
        return self.get_field_value(self.RECEIVEDDATE__FIELD_NAME.field_name)

    def set_RunCompleted_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RunCompleted' on this record model
        """
        self.set_field_value(self.RUNCOMPLETED__FIELD_NAME.field_name, value)

    def get_RunCompleted_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RunCompleted' from this record model
        """
        return self.get_field_value(self.RUNCOMPLETED__FIELD_NAME.field_name)

    def set_RunId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RunId' on this record model
        """
        self.set_field_value(self.RUNID__FIELD_NAME.field_name, value)

    def get_RunId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RunId' from this record model
        """
        return self.get_field_value(self.RUNID__FIELD_NAME.field_name)

    def set_SampleReceiver_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleReceiver' on this record model
        """
        self.set_field_value(self.SAMPLERECEIVER__FIELD_NAME.field_name, value)

    def get_SampleReceiver_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleReceiver' from this record model
        """
        return self.get_field_value(self.SAMPLERECEIVER__FIELD_NAME.field_name)

    def set_SequencerInstrument_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequencerInstrument' on this record model
        """
        self.set_field_value(self.SEQUENCERINSTRUMENT__FIELD_NAME.field_name, value)

    def get_SequencerInstrument_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequencerInstrument' from this record model
        """
        return self.get_field_value(self.SEQUENCERINSTRUMENT__FIELD_NAME.field_name)

    def set_SequencerRunDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'SequencerRunDate' on this record model
        """
        self.set_field_value(self.SEQUENCERRUNDATE__FIELD_NAME.field_name, value)

    def get_SequencerRunDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SequencerRunDate' from this record model
        """
        return self.get_field_value(self.SEQUENCERRUNDATE__FIELD_NAME.field_name)

    def set_SequencerRunFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequencerRunFolder' on this record model
        """
        self.set_field_value(self.SEQUENCERRUNFOLDER__FIELD_NAME.field_name, value)

    def get_SequencerRunFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequencerRunFolder' from this record model
        """
        return self.get_field_value(self.SEQUENCERRUNFOLDER__FIELD_NAME.field_name)

    def set_SequencingRunMode_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequencingRunMode' on this record model
        """
        self.set_field_value(self.SEQUENCINGRUNMODE__FIELD_NAME.field_name, value)

    def get_SequencingRunMode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequencingRunMode' from this record model
        """
        return self.get_field_value(self.SEQUENCINGRUNMODE__FIELD_NAME.field_name)

    def set_ShipDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ShipDate' on this record model
        """
        self.set_field_value(self.SHIPDATE__FIELD_NAME.field_name, value)

    def get_ShipDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ShipDate' from this record model
        """
        return self.get_field_value(self.SHIPDATE__FIELD_NAME.field_name)

    def set_ShippedBy_field(self, value: Optional[str]):
        """
        Set data field with field name 'ShippedBy' on this record model
        """
        self.set_field_value(self.SHIPPEDBY__FIELD_NAME.field_name, value)

    def get_ShippedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ShippedBy' from this record model
        """
        return self.get_field_value(self.SHIPPEDBY__FIELD_NAME.field_name)

    def set_ShippingCourier_field(self, value: Optional[str]):
        """
        Set data field with field name 'ShippingCourier' on this record model
        """
        self.set_field_value(self.SHIPPINGCOURIER__FIELD_NAME.field_name, value)

    def get_ShippingCourier_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ShippingCourier' from this record model
        """
        return self.get_field_value(self.SHIPPINGCOURIER__FIELD_NAME.field_name)

    def set_Side_field(self, value: Optional[str]):
        """
        Set data field with field name 'Side' on this record model
        """
        self.set_field_value(self.SIDE__FIELD_NAME.field_name, value)

    def get_Side_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Side' from this record model
        """
        return self.get_field_value(self.SIDE__FIELD_NAME.field_name)

    def set_TemplateExperimentName_field(self, value: Optional[str]):
        """
        Set data field with field name 'TemplateExperimentName' on this record model
        """
        self.set_field_value(self.TEMPLATEEXPERIMENTNAME__FIELD_NAME.field_name, value)

    def get_TemplateExperimentName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TemplateExperimentName' from this record model
        """
        return self.get_field_value(self.TEMPLATEEXPERIMENTNAME__FIELD_NAME.field_name)

    def set_TemplateVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'TemplateVersion' on this record model
        """
        self.set_field_value(self.TEMPLATEVERSION__FIELD_NAME.field_name, value)

    def get_TemplateVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TemplateVersion' from this record model
        """
        return self.get_field_value(self.TEMPLATEVERSION__FIELD_NAME.field_name)

    def set_TimeCompleted_field(self, value: Optional[str]):
        """
        Set data field with field name 'TimeCompleted' on this record model
        """
        self.set_field_value(self.TIMECOMPLETED__FIELD_NAME.field_name, value)

    def get_TimeCompleted_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TimeCompleted' from this record model
        """
        return self.get_field_value(self.TIMECOMPLETED__FIELD_NAME.field_name)

    def set_TrackingNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'TrackingNumber' on this record model
        """
        self.set_field_value(self.TRACKINGNUMBER__FIELD_NAME.field_name, value)

    def get_TrackingNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TrackingNumber' from this record model
        """
        return self.get_field_value(self.TRACKINGNUMBER__FIELD_NAME.field_name)

    def set_VELOXOWNER_field(self, value: Optional[str]):
        """
        Set data field with field name 'VELOXOWNER' on this record model
        """
        self.set_field_value(self.VELOXOWNER__FIELD_NAME.field_name, value)

    def get_VELOXOWNER_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VELOXOWNER' from this record model
        """
        return self.get_field_value(self.VELOXOWNER__FIELD_NAME.field_name)

    def set_VeloxCompletedBy_field(self, value: Optional[str]):
        """
        Set data field with field name 'VeloxCompletedBy' on this record model
        """
        self.set_field_value(self.VELOXCOMPLETEDBY__FIELD_NAME.field_name, value)

    def get_VeloxCompletedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxCompletedBy' from this record model
        """
        return self.get_field_value(self.VELOXCOMPLETEDBY__FIELD_NAME.field_name)

    def set_VeloxDateCompleted_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxDateCompleted' on this record model
        """
        self.set_field_value(self.VELOXDATECOMPLETED__FIELD_NAME.field_name, value)

    def get_VeloxDateCompleted_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxDateCompleted' from this record model
        """
        return self.get_field_value(self.VELOXDATECOMPLETED__FIELD_NAME.field_name)

    def set_VeloxExperimentStatus_field(self, value: Optional[str]):
        """
        Set data field with field name 'VeloxExperimentStatus' on this record model
        """
        self.set_field_value(self.VELOXEXPERIMENTSTATUS__FIELD_NAME.field_name, value)

    def get_VeloxExperimentStatus_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxExperimentStatus' from this record model
        """
        return self.get_field_value(self.VELOXEXPERIMENTSTATUS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ELNExperimentDetailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ELNExperimentDetail
    Data Type Display Name: Experiment Detail (Experiment Details)
    Fields: CreatedBy, DataRecordName, DataTypeId, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated
    Data type to represent the base E-Notebook data type to represent the experiment details.
    """
    DATA_TYPE_NAME: Final[str] = 'ELNExperimentDetail'
    DISPLAY_NAME: Final[str] = "Experiment Detail"
    PLURAL_DISPLAY_NAME: Final[str] = "Experiment Details"
    ACTUALAMOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("ActualAmount", FieldType.DOUBLE, display_name="Amount")
    ACTUALMOLES__FIELD_NAME: Final[WrapperField] = WrapperField("ActualMoles", FieldType.DOUBLE, display_name="Actual Moles")
    ACTUALUNITS__FIELD_NAME: Final[WrapperField] = WrapperField("ActualUnits", FieldType.PICKLIST, display_name="Amount Units")
    ALLOWOVERRIDE__FIELD_NAME: Final[WrapperField] = WrapperField("AllowOverride", FieldType.BOOLEAN, display_name="Allow Override")
    ANALYSIS__FIELD_NAME: Final[WrapperField] = WrapperField("Analysis", FieldType.STRING, display_name="Analysis")
    ANIMALID__FIELD_NAME: Final[WrapperField] = WrapperField("AnimalId", FieldType.STRING, display_name="Animal ID")
    ARM1A__FIELD_NAME: Final[WrapperField] = WrapperField("Arm1A", FieldType.DOUBLE, display_name="Arm 1A")
    ARM1B__FIELD_NAME: Final[WrapperField] = WrapperField("Arm1B", FieldType.DOUBLE, display_name="Arm 1B")
    ARM2A__FIELD_NAME: Final[WrapperField] = WrapperField("Arm2A", FieldType.DOUBLE, display_name="Arm 2A")
    ARM2B__FIELD_NAME: Final[WrapperField] = WrapperField("Arm2B", FieldType.DOUBLE, display_name="Arm 2B")
    ASSAYTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("AssayType", FieldType.STRING, display_name="Assay Type")
    BUFFERPARTCONSUMABLELOT__FIELD_NAME: Final[WrapperField] = WrapperField("BufferPartConsumableLot", FieldType.SELECTION, display_name="Lot Number")
    BUFFERPARTCONSUMABLEQTY__FIELD_NAME: Final[WrapperField] = WrapperField("BufferPartConsumableQty", FieldType.DOUBLE, display_name="Quantity Used")
    BUFFERPARTCONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("BufferPartConsumableType", FieldType.SELECTION, display_name="Buffer Subtype")
    CASNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("CASNumber", FieldType.STRING, display_name="CAS Number")
    CANEDITRUNMODE__FIELD_NAME: Final[WrapperField] = WrapperField("CanEditRunMode", FieldType.BOOLEAN, display_name="Can Edit Run Mode")
    CELLLINE2PARTCONSUMABLELOT__FIELD_NAME: Final[WrapperField] = WrapperField("CellLine2PartConsumableLot", FieldType.SELECTION, display_name="Lot Number")
    CELLLINE2PARTCONSUMABLEQTY__FIELD_NAME: Final[WrapperField] = WrapperField("CellLine2PartConsumableQty", FieldType.DOUBLE, display_name="Quantity Used")
    CELLLINE2PARTCONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("CellLine2PartConsumableType", FieldType.SELECTION, display_name="Cell Line Subtype")
    CHEMCONCENTRATION__FIELD_NAME: Final[WrapperField] = WrapperField("ChemConcentration", FieldType.STRING, display_name="Purity/Conc")
    CI95BOUNDS__FIELD_NAME: Final[WrapperField] = WrapperField("Ci95Bounds", FieldType.DOUBLE, display_name="CI 95% Bounds")
    CI95BOUNDSTHRESHOLD__FIELD_NAME: Final[WrapperField] = WrapperField("Ci95BoundsThreshold", FieldType.DOUBLE, display_name="CI 95% Bounds Threshold (%)")
    CLUSTERWITHCBOT__FIELD_NAME: Final[WrapperField] = WrapperField("ClusterWithCBot", FieldType.BOOLEAN, display_name="Cluster With CBot")
    COMMENTS__FIELD_NAME: Final[WrapperField] = WrapperField("Comments", FieldType.STRING, display_name="Comments")
    CONCENTRATIONUNITS__FIELD_NAME: Final[WrapperField] = WrapperField("ConcentrationUnits", FieldType.PICKLIST, display_name="Units")
    CONSUMABLEBARCODE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableBarcode", FieldType.STRING, display_name="Barcode      ")
    CONSUMABLECLASSIFICATION__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableClassification", FieldType.SELECTION, display_name="Consumable Classification")
    CONSUMABLECONSUMABLELOT__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableConsumableLot", FieldType.SELECTION, display_name="Lot Number    ")
    CONSUMABLECONSUMABLEQTY__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableConsumableQty", FieldType.DOUBLE, display_name="Quantity Used")
    CONSUMABLECONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableConsumableType", FieldType.SELECTION, display_name="Consumable Type")
    CONSUMABLEDATATYPENAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableDataTypeName", FieldType.SELECTION, display_name="Consumable Data Type Name")
    CONSUMABLEEXPIRATIONDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableExpirationDate", FieldType.DATE, display_name="Expiration Date")
    CONSUMABLELOT__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableLot", FieldType.SELECTION, display_name="Lot Number                                ")
    CONSUMABLENAMEFORMULATIONDETAILS__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableNameFormulationDetails", FieldType.STRING, display_name="Consumable Name                           ")
    CONSUMABLEPARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumablePartNumber", FieldType.STRING, display_name="Part Number                       ")
    CONSUMABLEQTY__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableQty", FieldType.DOUBLE, display_name="Quantity Used")
    CONSUMABLEQUANTITYREMAINING__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableQuantityRemaining", FieldType.DOUBLE, display_name="Quantity")
    CONSUMABLERECORDID__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableRecordId", FieldType.LONG, display_name="Consumable Record ID")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Consumable Type                       ")
    CONSUMABLETYPEFORRECIPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableTypeForRecipe", FieldType.SELECTION, display_name="Material Type")
    CONSUMABLEUNITS__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableUnits", FieldType.STRING, display_name="Units")
    CONTAINERID__FIELD_NAME: Final[WrapperField] = WrapperField("ContainerId", FieldType.STRING, display_name="Container ID")
    COVARISCYCLESPERBURST__FIELD_NAME: Final[WrapperField] = WrapperField("CovarisCyclesPerBurst", FieldType.LONG, display_name="Covaris Cycles Per Burst")
    COVARISDUTYFACTOR__FIELD_NAME: Final[WrapperField] = WrapperField("CovarisDutyFactor", FieldType.LONG, display_name="Covaris Duty Factor %")
    COVARISINSTRUMENT__FIELD_NAME: Final[WrapperField] = WrapperField("CovarisInstrument", FieldType.SELECTION, display_name="Covaris Instrument")
    COVARISPEAKINCIDENTPOWER__FIELD_NAME: Final[WrapperField] = WrapperField("CovarisPeakIncidentPower", FieldType.LONG, display_name="Covaris Peak Incident Power")
    COVARISTARGETPEAK__FIELD_NAME: Final[WrapperField] = WrapperField("CovarisTargetPeak", FieldType.STRING, display_name="Covaris Target Peak")
    COVARISTIMES__FIELD_NAME: Final[WrapperField] = WrapperField("CovarisTimes", FieldType.LONG, display_name="Covaris Time (s)")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    CRISPRDAY__FIELD_NAME: Final[WrapperField] = WrapperField("CrisprDay", FieldType.DOUBLE, display_name="Days")
    CUSTOMER__FIELD_NAME: Final[WrapperField] = WrapperField("Customer", FieldType.STRING, display_name="Customer")
    CUSTOMERCATEGORY__FIELD_NAME: Final[WrapperField] = WrapperField("CustomerCategory", FieldType.PICKLIST, display_name="Customer Category")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATATYPEID__FIELD_NAME: Final[WrapperField] = WrapperField("DataTypeId", FieldType.LONG, display_name="Data Type ID")
    DATE__FIELD_NAME: Final[WrapperField] = WrapperField("Date", FieldType.DATE, display_name="Date")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DATEPURCHASED__FIELD_NAME: Final[WrapperField] = WrapperField("DatePurchased", FieldType.DATE, display_name="Date Purchased")
    DENSITY__FIELD_NAME: Final[WrapperField] = WrapperField("Density", FieldType.DOUBLE, display_name="Density (g/mL)")
    DESCRIPTION__FIELD_NAME: Final[WrapperField] = WrapperField("Description", FieldType.STRING, display_name="Description")
    DESCRIPTION2__FIELD_NAME: Final[WrapperField] = WrapperField("Description2", FieldType.STRING, display_name="Description")
    DISCREPANCY__FIELD_NAME: Final[WrapperField] = WrapperField("Discrepancy", FieldType.STRING, display_name="Discrepancy")
    EXACTMASS__FIELD_NAME: Final[WrapperField] = WrapperField("ExactMass", FieldType.DOUBLE, display_name="Exact Mass")
    EXPIRATIONDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ExpirationDate", FieldType.DATE, display_name="Expiration Date")
    FLOWCELLID__FIELD_NAME: Final[WrapperField] = WrapperField("FlowcellId", FieldType.STRING, display_name="Flow Cell ID")
    FORMULA__FIELD_NAME: Final[WrapperField] = WrapperField("Formula", FieldType.STRING, display_name="MF")
    GHSHAZARDCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GHSHazardCode", FieldType.STRING, display_name="Hazard Code")
    GENDER__FIELD_NAME: Final[WrapperField] = WrapperField("Gender", FieldType.STRING, display_name="Gender")
    HTECONDITIONTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("HTEConditionType", FieldType.PICKLIST, display_name="Condition Type")
    HTECONDITIONVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("HTEConditionValue", FieldType.STRING, display_name="Condition Value")
    HTECONDITIONS__FIELD_NAME: Final[WrapperField] = WrapperField("HTEConditions", FieldType.SELECTION, display_name="HTE Conditions")
    HTEEXPECTEDPRODUCTS__FIELD_NAME: Final[WrapperField] = WrapperField("HTEExpectedProducts", FieldType.SELECTION, display_name="Expected Products")
    HTELIMITINGREACTANTPERWELL__FIELD_NAME: Final[WrapperField] = WrapperField("HTELimitingReactantPerWell", FieldType.LONG, display_name="HTE Limiting Reactant Per Well (uL)")
    HTEMATERIAL__FIELD_NAME: Final[WrapperField] = WrapperField("HTEMaterial", FieldType.PICKLIST, display_name="Material Type")
    HTEMATERIALCOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("HTEMaterialCount", FieldType.LONG, display_name="Material Count")
    HTEMATERIALLAYOUT__FIELD_NAME: Final[WrapperField] = WrapperField("HTEMaterialLayout", FieldType.PICKLIST, display_name="Material Layout")
    HTEMATERIALS__FIELD_NAME: Final[WrapperField] = WrapperField("HTEMaterials", FieldType.SELECTION, display_name="Materials")
    HTEPLATESIZE__FIELD_NAME: Final[WrapperField] = WrapperField("HTEPlateSize", FieldType.PICKLIST, display_name="HTE Plate Size")
    HTEREACTIONCOMPONENTS__FIELD_NAME: Final[WrapperField] = WrapperField("HTEReactionComponents", FieldType.SELECTION, display_name="Reaction Components")
    HTEREACTIONCONCENTRATION__FIELD_NAME: Final[WrapperField] = WrapperField("HTEReactionConcentration", FieldType.DOUBLE, display_name="HTE Reaction Concentration (M)")
    HTERUNVOLUME__FIELD_NAME: Final[WrapperField] = WrapperField("HTERunVolume", FieldType.LONG, display_name="HTE Run Volume (uL)")
    HAZARDCODES__FIELD_NAME: Final[WrapperField] = WrapperField("HazardCodes", FieldType.STRING, display_name="Hazard Codes")
    IUPAC__FIELD_NAME: Final[WrapperField] = WrapperField("IUPAC", FieldType.STRING, display_name="IUPAC")
    INFORMATICSADJUSTEDRSQUARED__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsAdjustedRSquared", FieldType.DOUBLE, display_name="Adjusted R Squared")
    INFORMATICSESTIMATE__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsEstimate", FieldType.DOUBLE, display_name="Estimate")
    INFORMATICSFCTNAME__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsFctName", FieldType.STRING, display_name="Fct Name")
    INFORMATICSFCTTEXT__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsFctText", FieldType.STRING, display_name="Text")
    INFORMATICSNAME__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsName", FieldType.STRING, display_name="Name")
    INFORMATICSPVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsPValue", FieldType.DOUBLE, display_name="p-value")
    INFORMATICSPRGREATERTHANT__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsPrGreaterThant", FieldType.DOUBLE, display_name="Pr(>|t|)")
    INFORMATICSRSQUARED__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsRSquared", FieldType.DOUBLE, display_name="R Squared")
    INFORMATICSRESIDUALSTANDARDERROR__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsResidualStandardError", FieldType.DOUBLE, display_name="Residual Standard Error")
    INFORMATICSRESIDUALSTANDARDERRORDOF__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsResidualStandardErrorDoF", FieldType.DOUBLE, display_name="RSE DoF")
    INFORMATICSSTDERROR__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsStdError", FieldType.DOUBLE, display_name="Standard Error")
    INFORMATICSTVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("InformaticsTValue", FieldType.DOUBLE, display_name="t-value")
    INSTRUMENTSTATUS__FIELD_NAME: Final[WrapperField] = WrapperField("InstrumentStatus", FieldType.STRING, display_name="Status")
    INSTRUMENTTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("InstrumentType", FieldType.SELECTION, display_name="Instrument Type")
    INSTRUMENTUSED__FIELD_NAME: Final[WrapperField] = WrapperField("InstrumentUsed", FieldType.SELECTION, display_name="Instrument Used")
    ITEMID__FIELD_NAME: Final[WrapperField] = WrapperField("ItemId", FieldType.STRING, display_name="Na Sequence Item ID")
    LASTMAINTENANCEDATE__FIELD_NAME: Final[WrapperField] = WrapperField("LastMaintenanceDate", FieldType.STRING, display_name="Last Maintenance Date")
    LIMITINGREACTANT__FIELD_NAME: Final[WrapperField] = WrapperField("LimitingReactant", FieldType.BOOLEAN, display_name="LR")
    LOTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("LotNumber", FieldType.STRING, display_name="Lot Number")
    MEASURED__FIELD_NAME: Final[WrapperField] = WrapperField("Measured", FieldType.DOUBLE, display_name="Measured")
    MODELNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("ModelNumber", FieldType.STRING, display_name="Model Number")
    MOLECULARWEIGHT__FIELD_NAME: Final[WrapperField] = WrapperField("MolecularWeight", FieldType.DOUBLE, display_name="MW (g/mol)")
    MOLES__FIELD_NAME: Final[WrapperField] = WrapperField("Moles", FieldType.DOUBLE, display_name="Moles")
    NAME__FIELD_NAME: Final[WrapperField] = WrapperField("Name", FieldType.STRING, display_name="Name")
    NANODROPAVERAGE1__FIELD_NAME: Final[WrapperField] = WrapperField("NanodropAverage1", FieldType.DOUBLE, display_name="Nanodrop Average 1")
    NANODROPAVERAGE2__FIELD_NAME: Final[WrapperField] = WrapperField("NanodropAverage2", FieldType.DOUBLE, display_name="Nanodrop Average 2")
    NEXTMAINTENANCEDATE__FIELD_NAME: Final[WrapperField] = WrapperField("NextMaintenanceDate", FieldType.STRING, display_name="Next Maintenance Date")
    NORMALIZATIONMETHOD__FIELD_NAME: Final[WrapperField] = WrapperField("NormalizationMethod", FieldType.SELECTION, display_name="Normalization Method")
    NUMBEROFREPLICATESNOTEDITABLE__FIELD_NAME: Final[WrapperField] = WrapperField("NumberOfReplicatesNotEditable", FieldType.LONG, display_name="Number of Replicates")
    OLIGONAME__FIELD_NAME: Final[WrapperField] = WrapperField("OligoName", FieldType.SELECTION, display_name="Oligo Name")
    OLIGOSEQUENCE__FIELD_NAME: Final[WrapperField] = WrapperField("OligoSequence", FieldType.STRING, display_name="Sequence")
    OTHERSAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("OtherSampleId", FieldType.STRING, display_name="Sample Name")
    PARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("PartNumber", FieldType.STRING, display_name="Part Number")
    PASSORFAIL__FIELD_NAME: Final[WrapperField] = WrapperField("PassorFail", FieldType.SELECTION, display_name="Pass or Fail")
    PEPTIDE2PARTCONSUMABLELOT__FIELD_NAME: Final[WrapperField] = WrapperField("Peptide2PartConsumableLot", FieldType.SELECTION, display_name="Lot Number")
    PEPTIDE2PARTCONSUMABLEQTY__FIELD_NAME: Final[WrapperField] = WrapperField("Peptide2PartConsumableQty", FieldType.DOUBLE, display_name="Quantity Used")
    PEPTIDE2PARTCONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("Peptide2PartConsumableType", FieldType.SELECTION, display_name="Peptide Subtype")
    PEPTIDE2PARTPARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("Peptide2PartPartNumber", FieldType.STRING, display_name="Peptide ID")
    PLANAMOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("PlanAmount", FieldType.DOUBLE, display_name="Theoretical Amount")
    PLASMIDCONSUMABLELOT__FIELD_NAME: Final[WrapperField] = WrapperField("PlasmidConsumableLot", FieldType.SELECTION, display_name="Lot Number")
    PLASMIDCONSUMABLEQTY__FIELD_NAME: Final[WrapperField] = WrapperField("PlasmidConsumableQty", FieldType.DOUBLE, display_name="Quantity Used")
    PLASMIDCONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("PlasmidConsumableType", FieldType.SELECTION, display_name="Plasmid Name")
    PLASMIDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("PlasmidName", FieldType.STRING, display_name="Plasmid Name")
    PLASMIDPARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("PlasmidPartNumber", FieldType.STRING, display_name="Sequence")
    PLASMIDUNITS__FIELD_NAME: Final[WrapperField] = WrapperField("PlasmidUnits", FieldType.STRING, display_name="Units")
    POSITION__FIELD_NAME: Final[WrapperField] = WrapperField("Position", FieldType.STRING, display_name="Position")
    PRESSURE__FIELD_NAME: Final[WrapperField] = WrapperField("Pressure", FieldType.DOUBLE, display_name="Pressure")
    PRESSUREUNITS__FIELD_NAME: Final[WrapperField] = WrapperField("PressureUnits", FieldType.SELECTION, display_name="Pressure Units")
    PURITY__FIELD_NAME: Final[WrapperField] = WrapperField("Purity", FieldType.DOUBLE, display_name="Purity")
    QUANTITY__FIELD_NAME: Final[WrapperField] = WrapperField("Quantity", FieldType.DOUBLE, display_name="Quantity")
    QUANTITYPERITEM__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityPerItem", FieldType.DOUBLE, display_name="Quantity / Volume Per Item")
    QUANTITYREMAINING__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityRemaining", FieldType.DOUBLE, display_name="Quantity Remaining")
    RATERPM__FIELD_NAME: Final[WrapperField] = WrapperField("Raterpm", FieldType.DOUBLE, display_name="Rate (rpm)")
    RATIO__FIELD_NAME: Final[WrapperField] = WrapperField("Ratio", FieldType.DOUBLE, display_name="Ratio")
    REACTION__FIELD_NAME: Final[WrapperField] = WrapperField("Reaction", FieldType.STRING, display_name="Reaction")
    REACTIONCOEFFICIENT__FIELD_NAME: Final[WrapperField] = WrapperField("ReactionCoefficient", FieldType.DOUBLE, display_name="Equivalents")
    REACTIONPLANUNITS__FIELD_NAME: Final[WrapperField] = WrapperField("ReactionPlanUnits", FieldType.PICKLIST, display_name="Theoretical Units")
    REAGENTS__FIELD_NAME: Final[WrapperField] = WrapperField("Reagents", FieldType.STRING, display_name="Reagents")
    REGISTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("RegistryId", FieldType.STRING, display_name="Registry Id")
    REORDERLEVELQUANTITY__FIELD_NAME: Final[WrapperField] = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE, display_name="Reorder Level Quantity")
    RESINNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ResinName", FieldType.STRING, display_name="Resin Name")
    ROLE__FIELD_NAME: Final[WrapperField] = WrapperField("Role", FieldType.SELECTION, display_name="Role")
    RUNID__FIELD_NAME: Final[WrapperField] = WrapperField("RunId", FieldType.STRING, display_name="Run ID")
    SMILES__FIELD_NAME: Final[WrapperField] = WrapperField("SMILES", FieldType.STRING, display_name="SMILES")
    SAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("SampleId", FieldType.STRING, display_name="Sample Barcode")
    SAMPLEMEAN__FIELD_NAME: Final[WrapperField] = WrapperField("SampleMean", FieldType.DOUBLE, display_name="Mean")
    SAMPLEMEANTHRESHOLD__FIELD_NAME: Final[WrapperField] = WrapperField("SampleMeanThreshold", FieldType.DOUBLE, display_name="Mean Threshold (%)")
    SAMPLENORMALIZEDMEAN__FIELD_NAME: Final[WrapperField] = WrapperField("SampleNormalizedMean", FieldType.DOUBLE, display_name="Normalized Mean")
    SAMPLENORMALIZEDMEANTHRESHOLD__FIELD_NAME: Final[WrapperField] = WrapperField("SampleNormalizedMeanThreshold", FieldType.DOUBLE, display_name="Normalized Mean Threshold")
    SAMPLESTD__FIELD_NAME: Final[WrapperField] = WrapperField("SampleStd", FieldType.DOUBLE, display_name="Standard Deviation")
    SAMPLESTDTHRESHOLD__FIELD_NAME: Final[WrapperField] = WrapperField("SampleStdThreshold", FieldType.DOUBLE, display_name="Standard Deviation Threshold (%)")
    SAMPLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("SampleType", FieldType.STRING, display_name="Sample Type")
    SAMPLINGDAY__FIELD_NAME: Final[WrapperField] = WrapperField("SamplingDay", FieldType.LONG, display_name="Sampling Day")
    SAMPLINGHOUR__FIELD_NAME: Final[WrapperField] = WrapperField("SamplingHour", FieldType.DOUBLE, display_name="Sampling Hour")
    SARFIELDNAMELIST__FIELD_NAME: Final[WrapperField] = WrapperField("SarFieldNameList", FieldType.SELECTION, display_name="Fields to Show")
    SARSCAFFOLD__FIELD_NAME: Final[WrapperField] = WrapperField("SarScaffold", FieldType.STRING, display_name="Scaffold")
    SARTHRESHOLD__FIELD_NAME: Final[WrapperField] = WrapperField("SarThreshold", FieldType.LONG, display_name="Threshold")
    SEARCHME__FIELD_NAME: Final[WrapperField] = WrapperField("SearchMe", FieldType.STRING, display_name="Search Me")
    SEQUENCERINSTRUMENT__FIELD_NAME: Final[WrapperField] = WrapperField("SequencerInstrument", FieldType.SELECTION, display_name="Sequencer Used")
    SEQUENCERRUNFOLDER__FIELD_NAME: Final[WrapperField] = WrapperField("SequencerRunFolder", FieldType.STRING, display_name="Sequencer Run Folder")
    SEQUENCINGRUNMODE__FIELD_NAME: Final[WrapperField] = WrapperField("SequencingRunMode", FieldType.PICKLIST, display_name="Sequencing Run Mode")
    SEQUENCINGRUNTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("SequencingRunType", FieldType.STRING, display_name="Sequencing Run Type")
    SERIALNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("SerialNumber", FieldType.STRING, display_name="Serial Number")
    SKIPDISCREPANCY__FIELD_NAME: Final[WrapperField] = WrapperField("SkipDiscrepancy", FieldType.BOOLEAN, display_name="Override Discrepancy")
    STAINPARTCONSUMABLELOT__FIELD_NAME: Final[WrapperField] = WrapperField("StainPartConsumableLot", FieldType.SELECTION, display_name="Lot Number")
    STAINPARTCONSUMABLEQTY__FIELD_NAME: Final[WrapperField] = WrapperField("StainPartConsumableQty", FieldType.DOUBLE, display_name="Quantity Used")
    STAINPARTCONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("StainPartConsumableType", FieldType.SELECTION, display_name="Assay Name")
    STANDARDERROR__FIELD_NAME: Final[WrapperField] = WrapperField("StandardError", FieldType.DOUBLE, display_name="Standard Error")
    STANDARDERRORTHRESHOLD__FIELD_NAME: Final[WrapperField] = WrapperField("StandardErrorThreshold", FieldType.DOUBLE, display_name="Standard Error Threshold (%)")
    STORAGEUNITPATH__FIELD_NAME: Final[WrapperField] = WrapperField("StorageUnitPath", FieldType.STRING, display_name="Storage Location Path")
    STRAINNAME__FIELD_NAME: Final[WrapperField] = WrapperField("StrainName", FieldType.STRING, display_name="Strain Name")
    STRAINPARTCONSUMABLELOT__FIELD_NAME: Final[WrapperField] = WrapperField("StrainPartConsumableLot", FieldType.SELECTION, display_name="Lot Number")
    STRAINPARTCONSUMABLEQTY__FIELD_NAME: Final[WrapperField] = WrapperField("StrainPartConsumableQty", FieldType.DOUBLE, display_name="Quantity Used")
    STRAINPARTCONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("StrainPartConsumableType", FieldType.SELECTION, display_name="Strain Subtype")
    STUDYID__FIELD_NAME: Final[WrapperField] = WrapperField("StudyId", FieldType.STRING, display_name="Study ID")
    TARGET__FIELD_NAME: Final[WrapperField] = WrapperField("Target", FieldType.DOUBLE, display_name="Target")
    TECHASSIGNED__FIELD_NAME: Final[WrapperField] = WrapperField("TechAssigned", FieldType.SELECTION, display_name="Tech Assigned")
    TECHNICIAN__FIELD_NAME: Final[WrapperField] = WrapperField("Technician", FieldType.SELECTION, display_name="Technician")
    TECHNICIANASSIGNED__FIELD_NAME: Final[WrapperField] = WrapperField("TechnicianAssigned", FieldType.SELECTION, display_name="Technician Assigned")
    TEMPERATURE__FIELD_NAME: Final[WrapperField] = WrapperField("Temperature", FieldType.LONG, display_name="Temperature")
    TEMPERATUREUNITS__FIELD_NAME: Final[WrapperField] = WrapperField("TemperatureUnits", FieldType.SELECTION, display_name="Temperature Units")
    THEORYMOLES__FIELD_NAME: Final[WrapperField] = WrapperField("TheoryMoles", FieldType.DOUBLE, display_name="Theoretical Moles")
    TREATMENTGROUPID__FIELD_NAME: Final[WrapperField] = WrapperField("TreatmentGroupId", FieldType.STRING, display_name="Treatment Group")
    TRIAL__FIELD_NAME: Final[WrapperField] = WrapperField("Trial", FieldType.DOUBLE, display_name="Trial #")
    UNITS__FIELD_NAME: Final[WrapperField] = WrapperField("Units", FieldType.PICKLIST, display_name="Units")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VENDOR__FIELD_NAME: Final[WrapperField] = WrapperField("Vendor", FieldType.STRING, display_name="Vendor")
    VIRALVECTORPARTCONSUMABLELOT__FIELD_NAME: Final[WrapperField] = WrapperField("ViralVectorPartConsumableLot", FieldType.SELECTION, display_name="Lot Number")
    VIRALVECTORPARTCONSUMABLEQTY__FIELD_NAME: Final[WrapperField] = WrapperField("ViralVectorPartConsumableQty", FieldType.DOUBLE, display_name="Quantity Used")
    VIRALVECTORPARTCONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ViralVectorPartConsumableType", FieldType.SELECTION, display_name="Viral Vector Subtype")
    VIRALVECTORPARTPARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("ViralVectorPartPartNumber", FieldType.STRING, display_name="Vector ID")
    VOLUME__FIELD_NAME: Final[WrapperField] = WrapperField("Volume", FieldType.DOUBLE, display_name="Volume")
    VOLUMEUNITS__FIELD_NAME: Final[WrapperField] = WrapperField("VolumeUnits", FieldType.SELECTION, display_name="Volume Units")
    WELLID__FIELD_NAME: Final[WrapperField] = WrapperField("WellId", FieldType.STRING, display_name="Well ID")
    WORKSTATIONID__FIELD_NAME: Final[WrapperField] = WrapperField("WorkstationId", FieldType.STRING, display_name="Workstation ID")
    YIELD__FIELD_NAME: Final[WrapperField] = WrapperField("Yield", FieldType.DOUBLE, display_name="% Yield")
    YIELD2__FIELD_NAME: Final[WrapperField] = WrapperField("Yield2", FieldType.DOUBLE, display_name="Yield")
    INCHI__FIELD_NAME: Final[WrapperField] = WrapperField("inchi", FieldType.STRING, display_name="Inchi")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ActualAmount_field(self, value: Optional[float]):
        """
        Set data field with field name 'ActualAmount' on this record model
        """
        self.set_field_value(self.ACTUALAMOUNT__FIELD_NAME.field_name, value)

    def get_ActualAmount_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ActualAmount' from this record model
        """
        return self.get_field_value(self.ACTUALAMOUNT__FIELD_NAME.field_name)

    def set_ActualMoles_field(self, value: Optional[float]):
        """
        Set data field with field name 'ActualMoles' on this record model
        """
        self.set_field_value(self.ACTUALMOLES__FIELD_NAME.field_name, value)

    def get_ActualMoles_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ActualMoles' from this record model
        """
        return self.get_field_value(self.ACTUALMOLES__FIELD_NAME.field_name)

    def set_ActualUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'ActualUnits' on this record model
        """
        self.set_field_value(self.ACTUALUNITS__FIELD_NAME.field_name, value)

    def get_ActualUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ActualUnits' from this record model
        """
        return self.get_field_value(self.ACTUALUNITS__FIELD_NAME.field_name)

    def set_AllowOverride_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AllowOverride' on this record model
        """
        self.set_field_value(self.ALLOWOVERRIDE__FIELD_NAME.field_name, value)

    def get_AllowOverride_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AllowOverride' from this record model
        """
        return self.get_field_value(self.ALLOWOVERRIDE__FIELD_NAME.field_name)

    def set_Analysis_field(self, value: Optional[str]):
        """
        Set data field with field name 'Analysis' on this record model
        """
        self.set_field_value(self.ANALYSIS__FIELD_NAME.field_name, value)

    def get_Analysis_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Analysis' from this record model
        """
        return self.get_field_value(self.ANALYSIS__FIELD_NAME.field_name)

    def set_AnimalId_field(self, value: Optional[str]):
        """
        Set data field with field name 'AnimalId' on this record model
        """
        self.set_field_value(self.ANIMALID__FIELD_NAME.field_name, value)

    def get_AnimalId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AnimalId' from this record model
        """
        return self.get_field_value(self.ANIMALID__FIELD_NAME.field_name)

    def set_Arm1A_field(self, value: Optional[float]):
        """
        Set data field with field name 'Arm1A' on this record model
        """
        self.set_field_value(self.ARM1A__FIELD_NAME.field_name, value)

    def get_Arm1A_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Arm1A' from this record model
        """
        return self.get_field_value(self.ARM1A__FIELD_NAME.field_name)

    def set_Arm1B_field(self, value: Optional[float]):
        """
        Set data field with field name 'Arm1B' on this record model
        """
        self.set_field_value(self.ARM1B__FIELD_NAME.field_name, value)

    def get_Arm1B_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Arm1B' from this record model
        """
        return self.get_field_value(self.ARM1B__FIELD_NAME.field_name)

    def set_Arm2A_field(self, value: Optional[float]):
        """
        Set data field with field name 'Arm2A' on this record model
        """
        self.set_field_value(self.ARM2A__FIELD_NAME.field_name, value)

    def get_Arm2A_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Arm2A' from this record model
        """
        return self.get_field_value(self.ARM2A__FIELD_NAME.field_name)

    def set_Arm2B_field(self, value: Optional[float]):
        """
        Set data field with field name 'Arm2B' on this record model
        """
        self.set_field_value(self.ARM2B__FIELD_NAME.field_name, value)

    def get_Arm2B_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Arm2B' from this record model
        """
        return self.get_field_value(self.ARM2B__FIELD_NAME.field_name)

    def set_AssayType_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssayType' on this record model
        """
        self.set_field_value(self.ASSAYTYPE__FIELD_NAME.field_name, value)

    def get_AssayType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssayType' from this record model
        """
        return self.get_field_value(self.ASSAYTYPE__FIELD_NAME.field_name)

    def set_BufferPartConsumableLot_field(self, value: Optional[str]):
        """
        Set data field with field name 'BufferPartConsumableLot' on this record model
        """
        self.set_field_value(self.BUFFERPARTCONSUMABLELOT__FIELD_NAME.field_name, value)

    def get_BufferPartConsumableLot_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BufferPartConsumableLot' from this record model
        """
        return self.get_field_value(self.BUFFERPARTCONSUMABLELOT__FIELD_NAME.field_name)

    def set_BufferPartConsumableQty_field(self, value: Optional[float]):
        """
        Set data field with field name 'BufferPartConsumableQty' on this record model
        """
        self.set_field_value(self.BUFFERPARTCONSUMABLEQTY__FIELD_NAME.field_name, value)

    def get_BufferPartConsumableQty_field(self) -> Optional[float]:
        """
        Get data field value with field name 'BufferPartConsumableQty' from this record model
        """
        return self.get_field_value(self.BUFFERPARTCONSUMABLEQTY__FIELD_NAME.field_name)

    def set_BufferPartConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'BufferPartConsumableType' on this record model
        """
        self.set_field_value(self.BUFFERPARTCONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_BufferPartConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BufferPartConsumableType' from this record model
        """
        return self.get_field_value(self.BUFFERPARTCONSUMABLETYPE__FIELD_NAME.field_name)

    def set_CASNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'CASNumber' on this record model
        """
        self.set_field_value(self.CASNUMBER__FIELD_NAME.field_name, value)

    def get_CASNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CASNumber' from this record model
        """
        return self.get_field_value(self.CASNUMBER__FIELD_NAME.field_name)

    def set_CanEditRunMode_field(self, value: Optional[bool]):
        """
        Set data field with field name 'CanEditRunMode' on this record model
        """
        self.set_field_value(self.CANEDITRUNMODE__FIELD_NAME.field_name, value)

    def get_CanEditRunMode_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'CanEditRunMode' from this record model
        """
        return self.get_field_value(self.CANEDITRUNMODE__FIELD_NAME.field_name)

    def set_CellLine2PartConsumableLot_field(self, value: Optional[str]):
        """
        Set data field with field name 'CellLine2PartConsumableLot' on this record model
        """
        self.set_field_value(self.CELLLINE2PARTCONSUMABLELOT__FIELD_NAME.field_name, value)

    def get_CellLine2PartConsumableLot_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CellLine2PartConsumableLot' from this record model
        """
        return self.get_field_value(self.CELLLINE2PARTCONSUMABLELOT__FIELD_NAME.field_name)

    def set_CellLine2PartConsumableQty_field(self, value: Optional[float]):
        """
        Set data field with field name 'CellLine2PartConsumableQty' on this record model
        """
        self.set_field_value(self.CELLLINE2PARTCONSUMABLEQTY__FIELD_NAME.field_name, value)

    def get_CellLine2PartConsumableQty_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CellLine2PartConsumableQty' from this record model
        """
        return self.get_field_value(self.CELLLINE2PARTCONSUMABLEQTY__FIELD_NAME.field_name)

    def set_CellLine2PartConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'CellLine2PartConsumableType' on this record model
        """
        self.set_field_value(self.CELLLINE2PARTCONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_CellLine2PartConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CellLine2PartConsumableType' from this record model
        """
        return self.get_field_value(self.CELLLINE2PARTCONSUMABLETYPE__FIELD_NAME.field_name)

    def set_ChemConcentration_field(self, value: Optional[str]):
        """
        Set data field with field name 'ChemConcentration' on this record model
        """
        self.set_field_value(self.CHEMCONCENTRATION__FIELD_NAME.field_name, value)

    def get_ChemConcentration_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ChemConcentration' from this record model
        """
        return self.get_field_value(self.CHEMCONCENTRATION__FIELD_NAME.field_name)

    def set_Ci95Bounds_field(self, value: Optional[float]):
        """
        Set data field with field name 'Ci95Bounds' on this record model
        """
        self.set_field_value(self.CI95BOUNDS__FIELD_NAME.field_name, value)

    def get_Ci95Bounds_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Ci95Bounds' from this record model
        """
        return self.get_field_value(self.CI95BOUNDS__FIELD_NAME.field_name)

    def set_Ci95BoundsThreshold_field(self, value: Optional[float]):
        """
        Set data field with field name 'Ci95BoundsThreshold' on this record model
        """
        self.set_field_value(self.CI95BOUNDSTHRESHOLD__FIELD_NAME.field_name, value)

    def get_Ci95BoundsThreshold_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Ci95BoundsThreshold' from this record model
        """
        return self.get_field_value(self.CI95BOUNDSTHRESHOLD__FIELD_NAME.field_name)

    def set_ClusterWithCBot_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ClusterWithCBot' on this record model
        """
        self.set_field_value(self.CLUSTERWITHCBOT__FIELD_NAME.field_name, value)

    def get_ClusterWithCBot_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ClusterWithCBot' from this record model
        """
        return self.get_field_value(self.CLUSTERWITHCBOT__FIELD_NAME.field_name)

    def set_Comments_field(self, value: Optional[str]):
        """
        Set data field with field name 'Comments' on this record model
        """
        self.set_field_value(self.COMMENTS__FIELD_NAME.field_name, value)

    def get_Comments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Comments' from this record model
        """
        return self.get_field_value(self.COMMENTS__FIELD_NAME.field_name)

    def set_ConcentrationUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConcentrationUnits' on this record model
        """
        self.set_field_value(self.CONCENTRATIONUNITS__FIELD_NAME.field_name, value)

    def get_ConcentrationUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConcentrationUnits' from this record model
        """
        return self.get_field_value(self.CONCENTRATIONUNITS__FIELD_NAME.field_name)

    def set_ConsumableBarcode_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableBarcode' on this record model
        """
        self.set_field_value(self.CONSUMABLEBARCODE__FIELD_NAME.field_name, value)

    def get_ConsumableBarcode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableBarcode' from this record model
        """
        return self.get_field_value(self.CONSUMABLEBARCODE__FIELD_NAME.field_name)

    def set_ConsumableClassification_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableClassification' on this record model
        """
        self.set_field_value(self.CONSUMABLECLASSIFICATION__FIELD_NAME.field_name, value)

    def get_ConsumableClassification_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableClassification' from this record model
        """
        return self.get_field_value(self.CONSUMABLECLASSIFICATION__FIELD_NAME.field_name)

    def set_ConsumableConsumableLot_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableConsumableLot' on this record model
        """
        self.set_field_value(self.CONSUMABLECONSUMABLELOT__FIELD_NAME.field_name, value)

    def get_ConsumableConsumableLot_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableConsumableLot' from this record model
        """
        return self.get_field_value(self.CONSUMABLECONSUMABLELOT__FIELD_NAME.field_name)

    def set_ConsumableConsumableQty_field(self, value: Optional[float]):
        """
        Set data field with field name 'ConsumableConsumableQty' on this record model
        """
        self.set_field_value(self.CONSUMABLECONSUMABLEQTY__FIELD_NAME.field_name, value)

    def get_ConsumableConsumableQty_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ConsumableConsumableQty' from this record model
        """
        return self.get_field_value(self.CONSUMABLECONSUMABLEQTY__FIELD_NAME.field_name)

    def set_ConsumableConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLECONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLECONSUMABLETYPE__FIELD_NAME.field_name)

    def set_ConsumableDataTypeName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableDataTypeName' on this record model
        """
        self.set_field_value(self.CONSUMABLEDATATYPENAME__FIELD_NAME.field_name, value)

    def get_ConsumableDataTypeName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableDataTypeName' from this record model
        """
        return self.get_field_value(self.CONSUMABLEDATATYPENAME__FIELD_NAME.field_name)

    def set_ConsumableExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ConsumableExpirationDate' on this record model
        """
        self.set_field_value(self.CONSUMABLEEXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ConsumableExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ConsumableExpirationDate' from this record model
        """
        return self.get_field_value(self.CONSUMABLEEXPIRATIONDATE__FIELD_NAME.field_name)

    def set_ConsumableLot_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableLot' on this record model
        """
        self.set_field_value(self.CONSUMABLELOT__FIELD_NAME.field_name, value)

    def get_ConsumableLot_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableLot' from this record model
        """
        return self.get_field_value(self.CONSUMABLELOT__FIELD_NAME.field_name)

    def set_ConsumableNameFormulationDetails_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableNameFormulationDetails' on this record model
        """
        self.set_field_value(self.CONSUMABLENAMEFORMULATIONDETAILS__FIELD_NAME.field_name, value)

    def get_ConsumableNameFormulationDetails_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableNameFormulationDetails' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAMEFORMULATIONDETAILS__FIELD_NAME.field_name)

    def set_ConsumablePartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumablePartNumber' on this record model
        """
        self.set_field_value(self.CONSUMABLEPARTNUMBER__FIELD_NAME.field_name, value)

    def get_ConsumablePartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumablePartNumber' from this record model
        """
        return self.get_field_value(self.CONSUMABLEPARTNUMBER__FIELD_NAME.field_name)

    def set_ConsumableQty_field(self, value: Optional[float]):
        """
        Set data field with field name 'ConsumableQty' on this record model
        """
        self.set_field_value(self.CONSUMABLEQTY__FIELD_NAME.field_name, value)

    def get_ConsumableQty_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ConsumableQty' from this record model
        """
        return self.get_field_value(self.CONSUMABLEQTY__FIELD_NAME.field_name)

    def set_ConsumableQuantityRemaining_field(self, value: Optional[float]):
        """
        Set data field with field name 'ConsumableQuantityRemaining' on this record model
        """
        self.set_field_value(self.CONSUMABLEQUANTITYREMAINING__FIELD_NAME.field_name, value)

    def get_ConsumableQuantityRemaining_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ConsumableQuantityRemaining' from this record model
        """
        return self.get_field_value(self.CONSUMABLEQUANTITYREMAINING__FIELD_NAME.field_name)

    def set_ConsumableRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'ConsumableRecordId' on this record model
        """
        self.set_field_value(self.CONSUMABLERECORDID__FIELD_NAME.field_name, value)

    def get_ConsumableRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ConsumableRecordId' from this record model
        """
        return self.get_field_value(self.CONSUMABLERECORDID__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def set_ConsumableTypeForRecipe_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableTypeForRecipe' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPEFORRECIPE__FIELD_NAME.field_name, value)

    def get_ConsumableTypeForRecipe_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableTypeForRecipe' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPEFORRECIPE__FIELD_NAME.field_name)

    def set_ConsumableUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableUnits' on this record model
        """
        self.set_field_value(self.CONSUMABLEUNITS__FIELD_NAME.field_name, value)

    def get_ConsumableUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableUnits' from this record model
        """
        return self.get_field_value(self.CONSUMABLEUNITS__FIELD_NAME.field_name)

    def set_ContainerId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ContainerId' on this record model
        """
        self.set_field_value(self.CONTAINERID__FIELD_NAME.field_name, value)

    def get_ContainerId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ContainerId' from this record model
        """
        return self.get_field_value(self.CONTAINERID__FIELD_NAME.field_name)

    def set_CovarisCyclesPerBurst_field(self, value: Optional[int]):
        """
        Set data field with field name 'CovarisCyclesPerBurst' on this record model
        """
        self.set_field_value(self.COVARISCYCLESPERBURST__FIELD_NAME.field_name, value)

    def get_CovarisCyclesPerBurst_field(self) -> Optional[int]:
        """
        Get data field value with field name 'CovarisCyclesPerBurst' from this record model
        """
        return self.get_field_value(self.COVARISCYCLESPERBURST__FIELD_NAME.field_name)

    def set_CovarisDutyFactor_field(self, value: Optional[int]):
        """
        Set data field with field name 'CovarisDutyFactor' on this record model
        """
        self.set_field_value(self.COVARISDUTYFACTOR__FIELD_NAME.field_name, value)

    def get_CovarisDutyFactor_field(self) -> Optional[int]:
        """
        Get data field value with field name 'CovarisDutyFactor' from this record model
        """
        return self.get_field_value(self.COVARISDUTYFACTOR__FIELD_NAME.field_name)

    def set_CovarisInstrument_field(self, value: Optional[str]):
        """
        Set data field with field name 'CovarisInstrument' on this record model
        """
        self.set_field_value(self.COVARISINSTRUMENT__FIELD_NAME.field_name, value)

    def get_CovarisInstrument_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CovarisInstrument' from this record model
        """
        return self.get_field_value(self.COVARISINSTRUMENT__FIELD_NAME.field_name)

    def set_CovarisPeakIncidentPower_field(self, value: Optional[int]):
        """
        Set data field with field name 'CovarisPeakIncidentPower' on this record model
        """
        self.set_field_value(self.COVARISPEAKINCIDENTPOWER__FIELD_NAME.field_name, value)

    def get_CovarisPeakIncidentPower_field(self) -> Optional[int]:
        """
        Get data field value with field name 'CovarisPeakIncidentPower' from this record model
        """
        return self.get_field_value(self.COVARISPEAKINCIDENTPOWER__FIELD_NAME.field_name)

    def set_CovarisTargetPeak_field(self, value: Optional[str]):
        """
        Set data field with field name 'CovarisTargetPeak' on this record model
        """
        self.set_field_value(self.COVARISTARGETPEAK__FIELD_NAME.field_name, value)

    def get_CovarisTargetPeak_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CovarisTargetPeak' from this record model
        """
        return self.get_field_value(self.COVARISTARGETPEAK__FIELD_NAME.field_name)

    def set_CovarisTimes_field(self, value: Optional[int]):
        """
        Set data field with field name 'CovarisTimes' on this record model
        """
        self.set_field_value(self.COVARISTIMES__FIELD_NAME.field_name, value)

    def get_CovarisTimes_field(self) -> Optional[int]:
        """
        Get data field value with field name 'CovarisTimes' from this record model
        """
        return self.get_field_value(self.COVARISTIMES__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CrisprDay_field(self, value: Optional[float]):
        """
        Set data field with field name 'CrisprDay' on this record model
        """
        self.set_field_value(self.CRISPRDAY__FIELD_NAME.field_name, value)

    def get_CrisprDay_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CrisprDay' from this record model
        """
        return self.get_field_value(self.CRISPRDAY__FIELD_NAME.field_name)

    def set_Customer_field(self, value: Optional[str]):
        """
        Set data field with field name 'Customer' on this record model
        """
        self.set_field_value(self.CUSTOMER__FIELD_NAME.field_name, value)

    def get_Customer_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Customer' from this record model
        """
        return self.get_field_value(self.CUSTOMER__FIELD_NAME.field_name)

    def set_CustomerCategory_field(self, value: Optional[str]):
        """
        Set data field with field name 'CustomerCategory' on this record model
        """
        self.set_field_value(self.CUSTOMERCATEGORY__FIELD_NAME.field_name, value)

    def get_CustomerCategory_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CustomerCategory' from this record model
        """
        return self.get_field_value(self.CUSTOMERCATEGORY__FIELD_NAME.field_name)

    def set_DataTypeId_field(self, value: Optional[int]):
        """
        Set data field with field name 'DataTypeId' on this record model
        """
        self.set_field_value(self.DATATYPEID__FIELD_NAME.field_name, value)

    def get_DataTypeId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DataTypeId' from this record model
        """
        return self.get_field_value(self.DATATYPEID__FIELD_NAME.field_name)

    def set_Date_field(self, value: Optional[int]):
        """
        Set data field with field name 'Date' on this record model
        """
        self.set_field_value(self.DATE__FIELD_NAME.field_name, value)

    def get_Date_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Date' from this record model
        """
        return self.get_field_value(self.DATE__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DatePurchased_field(self, value: Optional[int]):
        """
        Set data field with field name 'DatePurchased' on this record model
        """
        self.set_field_value(self.DATEPURCHASED__FIELD_NAME.field_name, value)

    def get_DatePurchased_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DatePurchased' from this record model
        """
        return self.get_field_value(self.DATEPURCHASED__FIELD_NAME.field_name)

    def set_Density_field(self, value: Optional[float]):
        """
        Set data field with field name 'Density' on this record model
        """
        self.set_field_value(self.DENSITY__FIELD_NAME.field_name, value)

    def get_Density_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Density' from this record model
        """
        return self.get_field_value(self.DENSITY__FIELD_NAME.field_name)

    def set_Description_field(self, value: Optional[str]):
        """
        Set data field with field name 'Description' on this record model
        """
        self.set_field_value(self.DESCRIPTION__FIELD_NAME.field_name, value)

    def get_Description_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Description' from this record model
        """
        return self.get_field_value(self.DESCRIPTION__FIELD_NAME.field_name)

    def set_Description2_field(self, value: Optional[str]):
        """
        Set data field with field name 'Description2' on this record model
        """
        self.set_field_value(self.DESCRIPTION2__FIELD_NAME.field_name, value)

    def get_Description2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Description2' from this record model
        """
        return self.get_field_value(self.DESCRIPTION2__FIELD_NAME.field_name)

    def set_Discrepancy_field(self, value: Optional[str]):
        """
        Set data field with field name 'Discrepancy' on this record model
        """
        self.set_field_value(self.DISCREPANCY__FIELD_NAME.field_name, value)

    def get_Discrepancy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Discrepancy' from this record model
        """
        return self.get_field_value(self.DISCREPANCY__FIELD_NAME.field_name)

    def set_ExactMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'ExactMass' on this record model
        """
        self.set_field_value(self.EXACTMASS__FIELD_NAME.field_name, value)

    def get_ExactMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ExactMass' from this record model
        """
        return self.get_field_value(self.EXACTMASS__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_FlowcellId_field(self, value: Optional[str]):
        """
        Set data field with field name 'FlowcellId' on this record model
        """
        self.set_field_value(self.FLOWCELLID__FIELD_NAME.field_name, value)

    def get_FlowcellId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FlowcellId' from this record model
        """
        return self.get_field_value(self.FLOWCELLID__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_GHSHazardCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'GHSHazardCode' on this record model
        """
        self.set_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name, value)

    def get_GHSHazardCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GHSHazardCode' from this record model
        """
        return self.get_field_value(self.GHSHAZARDCODE__FIELD_NAME.field_name)

    def set_Gender_field(self, value: Optional[str]):
        """
        Set data field with field name 'Gender' on this record model
        """
        self.set_field_value(self.GENDER__FIELD_NAME.field_name, value)

    def get_Gender_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Gender' from this record model
        """
        return self.get_field_value(self.GENDER__FIELD_NAME.field_name)

    def set_HTEConditionType_field(self, value: Optional[str]):
        """
        Set data field with field name 'HTEConditionType' on this record model
        """
        self.set_field_value(self.HTECONDITIONTYPE__FIELD_NAME.field_name, value)

    def get_HTEConditionType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HTEConditionType' from this record model
        """
        return self.get_field_value(self.HTECONDITIONTYPE__FIELD_NAME.field_name)

    def set_HTEConditionValue_field(self, value: Optional[str]):
        """
        Set data field with field name 'HTEConditionValue' on this record model
        """
        self.set_field_value(self.HTECONDITIONVALUE__FIELD_NAME.field_name, value)

    def get_HTEConditionValue_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HTEConditionValue' from this record model
        """
        return self.get_field_value(self.HTECONDITIONVALUE__FIELD_NAME.field_name)

    def set_HTEConditions_field(self, value: Optional[str]):
        """
        Set data field with field name 'HTEConditions' on this record model
        """
        self.set_field_value(self.HTECONDITIONS__FIELD_NAME.field_name, value)

    def get_HTEConditions_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HTEConditions' from this record model
        """
        return self.get_field_value(self.HTECONDITIONS__FIELD_NAME.field_name)

    def set_HTEExpectedProducts_field(self, value: Optional[str]):
        """
        Set data field with field name 'HTEExpectedProducts' on this record model
        """
        self.set_field_value(self.HTEEXPECTEDPRODUCTS__FIELD_NAME.field_name, value)

    def get_HTEExpectedProducts_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HTEExpectedProducts' from this record model
        """
        return self.get_field_value(self.HTEEXPECTEDPRODUCTS__FIELD_NAME.field_name)

    def set_HTELimitingReactantPerWell_field(self, value: Optional[int]):
        """
        Set data field with field name 'HTELimitingReactantPerWell' on this record model
        """
        self.set_field_value(self.HTELIMITINGREACTANTPERWELL__FIELD_NAME.field_name, value)

    def get_HTELimitingReactantPerWell_field(self) -> Optional[int]:
        """
        Get data field value with field name 'HTELimitingReactantPerWell' from this record model
        """
        return self.get_field_value(self.HTELIMITINGREACTANTPERWELL__FIELD_NAME.field_name)

    def set_HTEMaterial_field(self, value: Optional[str]):
        """
        Set data field with field name 'HTEMaterial' on this record model
        """
        self.set_field_value(self.HTEMATERIAL__FIELD_NAME.field_name, value)

    def get_HTEMaterial_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HTEMaterial' from this record model
        """
        return self.get_field_value(self.HTEMATERIAL__FIELD_NAME.field_name)

    def set_HTEMaterialCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'HTEMaterialCount' on this record model
        """
        self.set_field_value(self.HTEMATERIALCOUNT__FIELD_NAME.field_name, value)

    def get_HTEMaterialCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'HTEMaterialCount' from this record model
        """
        return self.get_field_value(self.HTEMATERIALCOUNT__FIELD_NAME.field_name)

    def set_HTEMaterialLayout_field(self, value: Optional[str]):
        """
        Set data field with field name 'HTEMaterialLayout' on this record model
        """
        self.set_field_value(self.HTEMATERIALLAYOUT__FIELD_NAME.field_name, value)

    def get_HTEMaterialLayout_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HTEMaterialLayout' from this record model
        """
        return self.get_field_value(self.HTEMATERIALLAYOUT__FIELD_NAME.field_name)

    def set_HTEMaterials_field(self, value: Optional[str]):
        """
        Set data field with field name 'HTEMaterials' on this record model
        """
        self.set_field_value(self.HTEMATERIALS__FIELD_NAME.field_name, value)

    def get_HTEMaterials_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HTEMaterials' from this record model
        """
        return self.get_field_value(self.HTEMATERIALS__FIELD_NAME.field_name)

    def set_HTEPlateSize_field(self, value: Optional[str]):
        """
        Set data field with field name 'HTEPlateSize' on this record model
        """
        self.set_field_value(self.HTEPLATESIZE__FIELD_NAME.field_name, value)

    def get_HTEPlateSize_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HTEPlateSize' from this record model
        """
        return self.get_field_value(self.HTEPLATESIZE__FIELD_NAME.field_name)

    def set_HTEReactionComponents_field(self, value: Optional[str]):
        """
        Set data field with field name 'HTEReactionComponents' on this record model
        """
        self.set_field_value(self.HTEREACTIONCOMPONENTS__FIELD_NAME.field_name, value)

    def get_HTEReactionComponents_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HTEReactionComponents' from this record model
        """
        return self.get_field_value(self.HTEREACTIONCOMPONENTS__FIELD_NAME.field_name)

    def set_HTEReactionConcentration_field(self, value: Optional[float]):
        """
        Set data field with field name 'HTEReactionConcentration' on this record model
        """
        self.set_field_value(self.HTEREACTIONCONCENTRATION__FIELD_NAME.field_name, value)

    def get_HTEReactionConcentration_field(self) -> Optional[float]:
        """
        Get data field value with field name 'HTEReactionConcentration' from this record model
        """
        return self.get_field_value(self.HTEREACTIONCONCENTRATION__FIELD_NAME.field_name)

    def set_HTERunVolume_field(self, value: Optional[int]):
        """
        Set data field with field name 'HTERunVolume' on this record model
        """
        self.set_field_value(self.HTERUNVOLUME__FIELD_NAME.field_name, value)

    def get_HTERunVolume_field(self) -> Optional[int]:
        """
        Get data field value with field name 'HTERunVolume' from this record model
        """
        return self.get_field_value(self.HTERUNVOLUME__FIELD_NAME.field_name)

    def set_HazardCodes_field(self, value: Optional[str]):
        """
        Set data field with field name 'HazardCodes' on this record model
        """
        self.set_field_value(self.HAZARDCODES__FIELD_NAME.field_name, value)

    def get_HazardCodes_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HazardCodes' from this record model
        """
        return self.get_field_value(self.HAZARDCODES__FIELD_NAME.field_name)

    def set_IUPAC_field(self, value: Optional[str]):
        """
        Set data field with field name 'IUPAC' on this record model
        """
        self.set_field_value(self.IUPAC__FIELD_NAME.field_name, value)

    def get_IUPAC_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IUPAC' from this record model
        """
        return self.get_field_value(self.IUPAC__FIELD_NAME.field_name)

    def set_InformaticsAdjustedRSquared_field(self, value: Optional[float]):
        """
        Set data field with field name 'InformaticsAdjustedRSquared' on this record model
        """
        self.set_field_value(self.INFORMATICSADJUSTEDRSQUARED__FIELD_NAME.field_name, value)

    def get_InformaticsAdjustedRSquared_field(self) -> Optional[float]:
        """
        Get data field value with field name 'InformaticsAdjustedRSquared' from this record model
        """
        return self.get_field_value(self.INFORMATICSADJUSTEDRSQUARED__FIELD_NAME.field_name)

    def set_InformaticsEstimate_field(self, value: Optional[float]):
        """
        Set data field with field name 'InformaticsEstimate' on this record model
        """
        self.set_field_value(self.INFORMATICSESTIMATE__FIELD_NAME.field_name, value)

    def get_InformaticsEstimate_field(self) -> Optional[float]:
        """
        Get data field value with field name 'InformaticsEstimate' from this record model
        """
        return self.get_field_value(self.INFORMATICSESTIMATE__FIELD_NAME.field_name)

    def set_InformaticsFctName_field(self, value: Optional[str]):
        """
        Set data field with field name 'InformaticsFctName' on this record model
        """
        self.set_field_value(self.INFORMATICSFCTNAME__FIELD_NAME.field_name, value)

    def get_InformaticsFctName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InformaticsFctName' from this record model
        """
        return self.get_field_value(self.INFORMATICSFCTNAME__FIELD_NAME.field_name)

    def set_InformaticsFctText_field(self, value: Optional[str]):
        """
        Set data field with field name 'InformaticsFctText' on this record model
        """
        self.set_field_value(self.INFORMATICSFCTTEXT__FIELD_NAME.field_name, value)

    def get_InformaticsFctText_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InformaticsFctText' from this record model
        """
        return self.get_field_value(self.INFORMATICSFCTTEXT__FIELD_NAME.field_name)

    def set_InformaticsName_field(self, value: Optional[str]):
        """
        Set data field with field name 'InformaticsName' on this record model
        """
        self.set_field_value(self.INFORMATICSNAME__FIELD_NAME.field_name, value)

    def get_InformaticsName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InformaticsName' from this record model
        """
        return self.get_field_value(self.INFORMATICSNAME__FIELD_NAME.field_name)

    def set_InformaticsPValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'InformaticsPValue' on this record model
        """
        self.set_field_value(self.INFORMATICSPVALUE__FIELD_NAME.field_name, value)

    def get_InformaticsPValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'InformaticsPValue' from this record model
        """
        return self.get_field_value(self.INFORMATICSPVALUE__FIELD_NAME.field_name)

    def set_InformaticsPrGreaterThant_field(self, value: Optional[float]):
        """
        Set data field with field name 'InformaticsPrGreaterThant' on this record model
        """
        self.set_field_value(self.INFORMATICSPRGREATERTHANT__FIELD_NAME.field_name, value)

    def get_InformaticsPrGreaterThant_field(self) -> Optional[float]:
        """
        Get data field value with field name 'InformaticsPrGreaterThant' from this record model
        """
        return self.get_field_value(self.INFORMATICSPRGREATERTHANT__FIELD_NAME.field_name)

    def set_InformaticsRSquared_field(self, value: Optional[float]):
        """
        Set data field with field name 'InformaticsRSquared' on this record model
        """
        self.set_field_value(self.INFORMATICSRSQUARED__FIELD_NAME.field_name, value)

    def get_InformaticsRSquared_field(self) -> Optional[float]:
        """
        Get data field value with field name 'InformaticsRSquared' from this record model
        """
        return self.get_field_value(self.INFORMATICSRSQUARED__FIELD_NAME.field_name)

    def set_InformaticsResidualStandardError_field(self, value: Optional[float]):
        """
        Set data field with field name 'InformaticsResidualStandardError' on this record model
        """
        self.set_field_value(self.INFORMATICSRESIDUALSTANDARDERROR__FIELD_NAME.field_name, value)

    def get_InformaticsResidualStandardError_field(self) -> Optional[float]:
        """
        Get data field value with field name 'InformaticsResidualStandardError' from this record model
        """
        return self.get_field_value(self.INFORMATICSRESIDUALSTANDARDERROR__FIELD_NAME.field_name)

    def set_InformaticsResidualStandardErrorDoF_field(self, value: Optional[float]):
        """
        Set data field with field name 'InformaticsResidualStandardErrorDoF' on this record model
        """
        self.set_field_value(self.INFORMATICSRESIDUALSTANDARDERRORDOF__FIELD_NAME.field_name, value)

    def get_InformaticsResidualStandardErrorDoF_field(self) -> Optional[float]:
        """
        Get data field value with field name 'InformaticsResidualStandardErrorDoF' from this record model
        """
        return self.get_field_value(self.INFORMATICSRESIDUALSTANDARDERRORDOF__FIELD_NAME.field_name)

    def set_InformaticsStdError_field(self, value: Optional[float]):
        """
        Set data field with field name 'InformaticsStdError' on this record model
        """
        self.set_field_value(self.INFORMATICSSTDERROR__FIELD_NAME.field_name, value)

    def get_InformaticsStdError_field(self) -> Optional[float]:
        """
        Get data field value with field name 'InformaticsStdError' from this record model
        """
        return self.get_field_value(self.INFORMATICSSTDERROR__FIELD_NAME.field_name)

    def set_InformaticsTValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'InformaticsTValue' on this record model
        """
        self.set_field_value(self.INFORMATICSTVALUE__FIELD_NAME.field_name, value)

    def get_InformaticsTValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'InformaticsTValue' from this record model
        """
        return self.get_field_value(self.INFORMATICSTVALUE__FIELD_NAME.field_name)

    def set_InstrumentStatus_field(self, value: Optional[str]):
        """
        Set data field with field name 'InstrumentStatus' on this record model
        """
        self.set_field_value(self.INSTRUMENTSTATUS__FIELD_NAME.field_name, value)

    def get_InstrumentStatus_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InstrumentStatus' from this record model
        """
        return self.get_field_value(self.INSTRUMENTSTATUS__FIELD_NAME.field_name)

    def set_InstrumentType_field(self, value: Optional[str]):
        """
        Set data field with field name 'InstrumentType' on this record model
        """
        self.set_field_value(self.INSTRUMENTTYPE__FIELD_NAME.field_name, value)

    def get_InstrumentType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InstrumentType' from this record model
        """
        return self.get_field_value(self.INSTRUMENTTYPE__FIELD_NAME.field_name)

    def set_InstrumentUsed_field(self, value: Optional[str]):
        """
        Set data field with field name 'InstrumentUsed' on this record model
        """
        self.set_field_value(self.INSTRUMENTUSED__FIELD_NAME.field_name, value)

    def get_InstrumentUsed_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InstrumentUsed' from this record model
        """
        return self.get_field_value(self.INSTRUMENTUSED__FIELD_NAME.field_name)

    def set_ItemId_field(self, value: Optional[str]):
        """
        Set data field with field name 'ItemId' on this record model
        """
        self.set_field_value(self.ITEMID__FIELD_NAME.field_name, value)

    def get_ItemId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ItemId' from this record model
        """
        return self.get_field_value(self.ITEMID__FIELD_NAME.field_name)

    def set_LastMaintenanceDate_field(self, value: Optional[str]):
        """
        Set data field with field name 'LastMaintenanceDate' on this record model
        """
        self.set_field_value(self.LASTMAINTENANCEDATE__FIELD_NAME.field_name, value)

    def get_LastMaintenanceDate_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LastMaintenanceDate' from this record model
        """
        return self.get_field_value(self.LASTMAINTENANCEDATE__FIELD_NAME.field_name)

    def set_LimitingReactant_field(self, value: Optional[bool]):
        """
        Set data field with field name 'LimitingReactant' on this record model
        """
        self.set_field_value(self.LIMITINGREACTANT__FIELD_NAME.field_name, value)

    def get_LimitingReactant_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'LimitingReactant' from this record model
        """
        return self.get_field_value(self.LIMITINGREACTANT__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_Measured_field(self, value: Optional[float]):
        """
        Set data field with field name 'Measured' on this record model
        """
        self.set_field_value(self.MEASURED__FIELD_NAME.field_name, value)

    def get_Measured_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Measured' from this record model
        """
        return self.get_field_value(self.MEASURED__FIELD_NAME.field_name)

    def set_ModelNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'ModelNumber' on this record model
        """
        self.set_field_value(self.MODELNUMBER__FIELD_NAME.field_name, value)

    def get_ModelNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ModelNumber' from this record model
        """
        return self.get_field_value(self.MODELNUMBER__FIELD_NAME.field_name)

    def set_MolecularWeight_field(self, value: Optional[float]):
        """
        Set data field with field name 'MolecularWeight' on this record model
        """
        self.set_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name, value)

    def get_MolecularWeight_field(self) -> Optional[float]:
        """
        Get data field value with field name 'MolecularWeight' from this record model
        """
        return self.get_field_value(self.MOLECULARWEIGHT__FIELD_NAME.field_name)

    def set_Moles_field(self, value: Optional[float]):
        """
        Set data field with field name 'Moles' on this record model
        """
        self.set_field_value(self.MOLES__FIELD_NAME.field_name, value)

    def get_Moles_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Moles' from this record model
        """
        return self.get_field_value(self.MOLES__FIELD_NAME.field_name)

    def set_Name_field(self, value: Optional[str]):
        """
        Set data field with field name 'Name' on this record model
        """
        self.set_field_value(self.NAME__FIELD_NAME.field_name, value)

    def get_Name_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Name' from this record model
        """
        return self.get_field_value(self.NAME__FIELD_NAME.field_name)

    def set_NanodropAverage1_field(self, value: Optional[float]):
        """
        Set data field with field name 'NanodropAverage1' on this record model
        """
        self.set_field_value(self.NANODROPAVERAGE1__FIELD_NAME.field_name, value)

    def get_NanodropAverage1_field(self) -> Optional[float]:
        """
        Get data field value with field name 'NanodropAverage1' from this record model
        """
        return self.get_field_value(self.NANODROPAVERAGE1__FIELD_NAME.field_name)

    def set_NanodropAverage2_field(self, value: Optional[float]):
        """
        Set data field with field name 'NanodropAverage2' on this record model
        """
        self.set_field_value(self.NANODROPAVERAGE2__FIELD_NAME.field_name, value)

    def get_NanodropAverage2_field(self) -> Optional[float]:
        """
        Get data field value with field name 'NanodropAverage2' from this record model
        """
        return self.get_field_value(self.NANODROPAVERAGE2__FIELD_NAME.field_name)

    def set_NextMaintenanceDate_field(self, value: Optional[str]):
        """
        Set data field with field name 'NextMaintenanceDate' on this record model
        """
        self.set_field_value(self.NEXTMAINTENANCEDATE__FIELD_NAME.field_name, value)

    def get_NextMaintenanceDate_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NextMaintenanceDate' from this record model
        """
        return self.get_field_value(self.NEXTMAINTENANCEDATE__FIELD_NAME.field_name)

    def set_NormalizationMethod_field(self, value: Optional[str]):
        """
        Set data field with field name 'NormalizationMethod' on this record model
        """
        self.set_field_value(self.NORMALIZATIONMETHOD__FIELD_NAME.field_name, value)

    def get_NormalizationMethod_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NormalizationMethod' from this record model
        """
        return self.get_field_value(self.NORMALIZATIONMETHOD__FIELD_NAME.field_name)

    def set_NumberOfReplicatesNotEditable_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumberOfReplicatesNotEditable' on this record model
        """
        self.set_field_value(self.NUMBEROFREPLICATESNOTEDITABLE__FIELD_NAME.field_name, value)

    def get_NumberOfReplicatesNotEditable_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumberOfReplicatesNotEditable' from this record model
        """
        return self.get_field_value(self.NUMBEROFREPLICATESNOTEDITABLE__FIELD_NAME.field_name)

    def set_OligoName_field(self, value: Optional[str]):
        """
        Set data field with field name 'OligoName' on this record model
        """
        self.set_field_value(self.OLIGONAME__FIELD_NAME.field_name, value)

    def get_OligoName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OligoName' from this record model
        """
        return self.get_field_value(self.OLIGONAME__FIELD_NAME.field_name)

    def set_OligoSequence_field(self, value: Optional[str]):
        """
        Set data field with field name 'OligoSequence' on this record model
        """
        self.set_field_value(self.OLIGOSEQUENCE__FIELD_NAME.field_name, value)

    def get_OligoSequence_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OligoSequence' from this record model
        """
        return self.get_field_value(self.OLIGOSEQUENCE__FIELD_NAME.field_name)

    def set_OtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'OtherSampleId' on this record model
        """
        self.set_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_OtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OtherSampleId' from this record model
        """
        return self.get_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_PassorFail_field(self, value: Optional[str]):
        """
        Set data field with field name 'PassorFail' on this record model
        """
        self.set_field_value(self.PASSORFAIL__FIELD_NAME.field_name, value)

    def get_PassorFail_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PassorFail' from this record model
        """
        return self.get_field_value(self.PASSORFAIL__FIELD_NAME.field_name)

    def set_Peptide2PartConsumableLot_field(self, value: Optional[str]):
        """
        Set data field with field name 'Peptide2PartConsumableLot' on this record model
        """
        self.set_field_value(self.PEPTIDE2PARTCONSUMABLELOT__FIELD_NAME.field_name, value)

    def get_Peptide2PartConsumableLot_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Peptide2PartConsumableLot' from this record model
        """
        return self.get_field_value(self.PEPTIDE2PARTCONSUMABLELOT__FIELD_NAME.field_name)

    def set_Peptide2PartConsumableQty_field(self, value: Optional[float]):
        """
        Set data field with field name 'Peptide2PartConsumableQty' on this record model
        """
        self.set_field_value(self.PEPTIDE2PARTCONSUMABLEQTY__FIELD_NAME.field_name, value)

    def get_Peptide2PartConsumableQty_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Peptide2PartConsumableQty' from this record model
        """
        return self.get_field_value(self.PEPTIDE2PARTCONSUMABLEQTY__FIELD_NAME.field_name)

    def set_Peptide2PartConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'Peptide2PartConsumableType' on this record model
        """
        self.set_field_value(self.PEPTIDE2PARTCONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_Peptide2PartConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Peptide2PartConsumableType' from this record model
        """
        return self.get_field_value(self.PEPTIDE2PARTCONSUMABLETYPE__FIELD_NAME.field_name)

    def set_Peptide2PartPartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'Peptide2PartPartNumber' on this record model
        """
        self.set_field_value(self.PEPTIDE2PARTPARTNUMBER__FIELD_NAME.field_name, value)

    def get_Peptide2PartPartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Peptide2PartPartNumber' from this record model
        """
        return self.get_field_value(self.PEPTIDE2PARTPARTNUMBER__FIELD_NAME.field_name)

    def set_PlanAmount_field(self, value: Optional[float]):
        """
        Set data field with field name 'PlanAmount' on this record model
        """
        self.set_field_value(self.PLANAMOUNT__FIELD_NAME.field_name, value)

    def get_PlanAmount_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PlanAmount' from this record model
        """
        return self.get_field_value(self.PLANAMOUNT__FIELD_NAME.field_name)

    def set_PlasmidConsumableLot_field(self, value: Optional[str]):
        """
        Set data field with field name 'PlasmidConsumableLot' on this record model
        """
        self.set_field_value(self.PLASMIDCONSUMABLELOT__FIELD_NAME.field_name, value)

    def get_PlasmidConsumableLot_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PlasmidConsumableLot' from this record model
        """
        return self.get_field_value(self.PLASMIDCONSUMABLELOT__FIELD_NAME.field_name)

    def set_PlasmidConsumableQty_field(self, value: Optional[float]):
        """
        Set data field with field name 'PlasmidConsumableQty' on this record model
        """
        self.set_field_value(self.PLASMIDCONSUMABLEQTY__FIELD_NAME.field_name, value)

    def get_PlasmidConsumableQty_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PlasmidConsumableQty' from this record model
        """
        return self.get_field_value(self.PLASMIDCONSUMABLEQTY__FIELD_NAME.field_name)

    def set_PlasmidConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'PlasmidConsumableType' on this record model
        """
        self.set_field_value(self.PLASMIDCONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_PlasmidConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PlasmidConsumableType' from this record model
        """
        return self.get_field_value(self.PLASMIDCONSUMABLETYPE__FIELD_NAME.field_name)

    def set_PlasmidName_field(self, value: Optional[str]):
        """
        Set data field with field name 'PlasmidName' on this record model
        """
        self.set_field_value(self.PLASMIDNAME__FIELD_NAME.field_name, value)

    def get_PlasmidName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PlasmidName' from this record model
        """
        return self.get_field_value(self.PLASMIDNAME__FIELD_NAME.field_name)

    def set_PlasmidPartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PlasmidPartNumber' on this record model
        """
        self.set_field_value(self.PLASMIDPARTNUMBER__FIELD_NAME.field_name, value)

    def get_PlasmidPartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PlasmidPartNumber' from this record model
        """
        return self.get_field_value(self.PLASMIDPARTNUMBER__FIELD_NAME.field_name)

    def set_PlasmidUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'PlasmidUnits' on this record model
        """
        self.set_field_value(self.PLASMIDUNITS__FIELD_NAME.field_name, value)

    def get_PlasmidUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PlasmidUnits' from this record model
        """
        return self.get_field_value(self.PLASMIDUNITS__FIELD_NAME.field_name)

    def set_Position_field(self, value: Optional[str]):
        """
        Set data field with field name 'Position' on this record model
        """
        self.set_field_value(self.POSITION__FIELD_NAME.field_name, value)

    def get_Position_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Position' from this record model
        """
        return self.get_field_value(self.POSITION__FIELD_NAME.field_name)

    def set_Pressure_field(self, value: Optional[float]):
        """
        Set data field with field name 'Pressure' on this record model
        """
        self.set_field_value(self.PRESSURE__FIELD_NAME.field_name, value)

    def get_Pressure_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Pressure' from this record model
        """
        return self.get_field_value(self.PRESSURE__FIELD_NAME.field_name)

    def set_PressureUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'PressureUnits' on this record model
        """
        self.set_field_value(self.PRESSUREUNITS__FIELD_NAME.field_name, value)

    def get_PressureUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PressureUnits' from this record model
        """
        return self.get_field_value(self.PRESSUREUNITS__FIELD_NAME.field_name)

    def set_Purity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Purity' on this record model
        """
        self.set_field_value(self.PURITY__FIELD_NAME.field_name, value)

    def get_Purity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Purity' from this record model
        """
        return self.get_field_value(self.PURITY__FIELD_NAME.field_name)

    def set_Quantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'Quantity' on this record model
        """
        self.set_field_value(self.QUANTITY__FIELD_NAME.field_name, value)

    def get_Quantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Quantity' from this record model
        """
        return self.get_field_value(self.QUANTITY__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_QuantityRemaining_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityRemaining' on this record model
        """
        self.set_field_value(self.QUANTITYREMAINING__FIELD_NAME.field_name, value)

    def get_QuantityRemaining_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityRemaining' from this record model
        """
        return self.get_field_value(self.QUANTITYREMAINING__FIELD_NAME.field_name)

    def set_Raterpm_field(self, value: Optional[float]):
        """
        Set data field with field name 'Raterpm' on this record model
        """
        self.set_field_value(self.RATERPM__FIELD_NAME.field_name, value)

    def get_Raterpm_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Raterpm' from this record model
        """
        return self.get_field_value(self.RATERPM__FIELD_NAME.field_name)

    def set_Ratio_field(self, value: Optional[float]):
        """
        Set data field with field name 'Ratio' on this record model
        """
        self.set_field_value(self.RATIO__FIELD_NAME.field_name, value)

    def get_Ratio_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Ratio' from this record model
        """
        return self.get_field_value(self.RATIO__FIELD_NAME.field_name)

    def set_Reaction_field(self, value: Optional[str]):
        """
        Set data field with field name 'Reaction' on this record model
        """
        self.set_field_value(self.REACTION__FIELD_NAME.field_name, value)

    def get_Reaction_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Reaction' from this record model
        """
        return self.get_field_value(self.REACTION__FIELD_NAME.field_name)

    def set_ReactionCoefficient_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReactionCoefficient' on this record model
        """
        self.set_field_value(self.REACTIONCOEFFICIENT__FIELD_NAME.field_name, value)

    def get_ReactionCoefficient_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReactionCoefficient' from this record model
        """
        return self.get_field_value(self.REACTIONCOEFFICIENT__FIELD_NAME.field_name)

    def set_ReactionPlanUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReactionPlanUnits' on this record model
        """
        self.set_field_value(self.REACTIONPLANUNITS__FIELD_NAME.field_name, value)

    def get_ReactionPlanUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReactionPlanUnits' from this record model
        """
        return self.get_field_value(self.REACTIONPLANUNITS__FIELD_NAME.field_name)

    def set_Reagents_field(self, value: Optional[str]):
        """
        Set data field with field name 'Reagents' on this record model
        """
        self.set_field_value(self.REAGENTS__FIELD_NAME.field_name, value)

    def get_Reagents_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Reagents' from this record model
        """
        return self.get_field_value(self.REAGENTS__FIELD_NAME.field_name)

    def set_RegistryId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RegistryId' on this record model
        """
        self.set_field_value(self.REGISTRYID__FIELD_NAME.field_name, value)

    def get_RegistryId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RegistryId' from this record model
        """
        return self.get_field_value(self.REGISTRYID__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_ResinName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ResinName' on this record model
        """
        self.set_field_value(self.RESINNAME__FIELD_NAME.field_name, value)

    def get_ResinName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ResinName' from this record model
        """
        return self.get_field_value(self.RESINNAME__FIELD_NAME.field_name)

    def set_Role_field(self, value: Optional[str]):
        """
        Set data field with field name 'Role' on this record model
        """
        self.set_field_value(self.ROLE__FIELD_NAME.field_name, value)

    def get_Role_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Role' from this record model
        """
        return self.get_field_value(self.ROLE__FIELD_NAME.field_name)

    def set_RunId_field(self, value: Optional[str]):
        """
        Set data field with field name 'RunId' on this record model
        """
        self.set_field_value(self.RUNID__FIELD_NAME.field_name, value)

    def get_RunId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RunId' from this record model
        """
        return self.get_field_value(self.RUNID__FIELD_NAME.field_name)

    def set_SMILES_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMILES' on this record model
        """
        self.set_field_value(self.SMILES__FIELD_NAME.field_name, value)

    def get_SMILES_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMILES' from this record model
        """
        return self.get_field_value(self.SMILES__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def set_SampleMean_field(self, value: Optional[float]):
        """
        Set data field with field name 'SampleMean' on this record model
        """
        self.set_field_value(self.SAMPLEMEAN__FIELD_NAME.field_name, value)

    def get_SampleMean_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SampleMean' from this record model
        """
        return self.get_field_value(self.SAMPLEMEAN__FIELD_NAME.field_name)

    def set_SampleMeanThreshold_field(self, value: Optional[float]):
        """
        Set data field with field name 'SampleMeanThreshold' on this record model
        """
        self.set_field_value(self.SAMPLEMEANTHRESHOLD__FIELD_NAME.field_name, value)

    def get_SampleMeanThreshold_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SampleMeanThreshold' from this record model
        """
        return self.get_field_value(self.SAMPLEMEANTHRESHOLD__FIELD_NAME.field_name)

    def set_SampleNormalizedMean_field(self, value: Optional[float]):
        """
        Set data field with field name 'SampleNormalizedMean' on this record model
        """
        self.set_field_value(self.SAMPLENORMALIZEDMEAN__FIELD_NAME.field_name, value)

    def get_SampleNormalizedMean_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SampleNormalizedMean' from this record model
        """
        return self.get_field_value(self.SAMPLENORMALIZEDMEAN__FIELD_NAME.field_name)

    def set_SampleNormalizedMeanThreshold_field(self, value: Optional[float]):
        """
        Set data field with field name 'SampleNormalizedMeanThreshold' on this record model
        """
        self.set_field_value(self.SAMPLENORMALIZEDMEANTHRESHOLD__FIELD_NAME.field_name, value)

    def get_SampleNormalizedMeanThreshold_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SampleNormalizedMeanThreshold' from this record model
        """
        return self.get_field_value(self.SAMPLENORMALIZEDMEANTHRESHOLD__FIELD_NAME.field_name)

    def set_SampleStd_field(self, value: Optional[float]):
        """
        Set data field with field name 'SampleStd' on this record model
        """
        self.set_field_value(self.SAMPLESTD__FIELD_NAME.field_name, value)

    def get_SampleStd_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SampleStd' from this record model
        """
        return self.get_field_value(self.SAMPLESTD__FIELD_NAME.field_name)

    def set_SampleStdThreshold_field(self, value: Optional[float]):
        """
        Set data field with field name 'SampleStdThreshold' on this record model
        """
        self.set_field_value(self.SAMPLESTDTHRESHOLD__FIELD_NAME.field_name, value)

    def get_SampleStdThreshold_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SampleStdThreshold' from this record model
        """
        return self.get_field_value(self.SAMPLESTDTHRESHOLD__FIELD_NAME.field_name)

    def set_SampleType_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleType' on this record model
        """
        self.set_field_value(self.SAMPLETYPE__FIELD_NAME.field_name, value)

    def get_SampleType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleType' from this record model
        """
        return self.get_field_value(self.SAMPLETYPE__FIELD_NAME.field_name)

    def set_SamplingDay_field(self, value: Optional[int]):
        """
        Set data field with field name 'SamplingDay' on this record model
        """
        self.set_field_value(self.SAMPLINGDAY__FIELD_NAME.field_name, value)

    def get_SamplingDay_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SamplingDay' from this record model
        """
        return self.get_field_value(self.SAMPLINGDAY__FIELD_NAME.field_name)

    def set_SamplingHour_field(self, value: Optional[float]):
        """
        Set data field with field name 'SamplingHour' on this record model
        """
        self.set_field_value(self.SAMPLINGHOUR__FIELD_NAME.field_name, value)

    def get_SamplingHour_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SamplingHour' from this record model
        """
        return self.get_field_value(self.SAMPLINGHOUR__FIELD_NAME.field_name)

    def set_SarFieldNameList_field(self, value: Optional[str]):
        """
        Set data field with field name 'SarFieldNameList' on this record model
        """
        self.set_field_value(self.SARFIELDNAMELIST__FIELD_NAME.field_name, value)

    def get_SarFieldNameList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SarFieldNameList' from this record model
        """
        return self.get_field_value(self.SARFIELDNAMELIST__FIELD_NAME.field_name)

    def set_SarScaffold_field(self, value: Optional[str]):
        """
        Set data field with field name 'SarScaffold' on this record model
        """
        self.set_field_value(self.SARSCAFFOLD__FIELD_NAME.field_name, value)

    def get_SarScaffold_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SarScaffold' from this record model
        """
        return self.get_field_value(self.SARSCAFFOLD__FIELD_NAME.field_name)

    def set_SarThreshold_field(self, value: Optional[int]):
        """
        Set data field with field name 'SarThreshold' on this record model
        """
        self.set_field_value(self.SARTHRESHOLD__FIELD_NAME.field_name, value)

    def get_SarThreshold_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SarThreshold' from this record model
        """
        return self.get_field_value(self.SARTHRESHOLD__FIELD_NAME.field_name)

    def set_SearchMe_field(self, value: Optional[str]):
        """
        Set data field with field name 'SearchMe' on this record model
        """
        self.set_field_value(self.SEARCHME__FIELD_NAME.field_name, value)

    def get_SearchMe_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SearchMe' from this record model
        """
        return self.get_field_value(self.SEARCHME__FIELD_NAME.field_name)

    def set_SequencerInstrument_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequencerInstrument' on this record model
        """
        self.set_field_value(self.SEQUENCERINSTRUMENT__FIELD_NAME.field_name, value)

    def get_SequencerInstrument_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequencerInstrument' from this record model
        """
        return self.get_field_value(self.SEQUENCERINSTRUMENT__FIELD_NAME.field_name)

    def set_SequencerRunFolder_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequencerRunFolder' on this record model
        """
        self.set_field_value(self.SEQUENCERRUNFOLDER__FIELD_NAME.field_name, value)

    def get_SequencerRunFolder_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequencerRunFolder' from this record model
        """
        return self.get_field_value(self.SEQUENCERRUNFOLDER__FIELD_NAME.field_name)

    def set_SequencingRunMode_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequencingRunMode' on this record model
        """
        self.set_field_value(self.SEQUENCINGRUNMODE__FIELD_NAME.field_name, value)

    def get_SequencingRunMode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequencingRunMode' from this record model
        """
        return self.get_field_value(self.SEQUENCINGRUNMODE__FIELD_NAME.field_name)

    def set_SequencingRunType_field(self, value: Optional[str]):
        """
        Set data field with field name 'SequencingRunType' on this record model
        """
        self.set_field_value(self.SEQUENCINGRUNTYPE__FIELD_NAME.field_name, value)

    def get_SequencingRunType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SequencingRunType' from this record model
        """
        return self.get_field_value(self.SEQUENCINGRUNTYPE__FIELD_NAME.field_name)

    def set_SerialNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'SerialNumber' on this record model
        """
        self.set_field_value(self.SERIALNUMBER__FIELD_NAME.field_name, value)

    def get_SerialNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SerialNumber' from this record model
        """
        return self.get_field_value(self.SERIALNUMBER__FIELD_NAME.field_name)

    def set_SkipDiscrepancy_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SkipDiscrepancy' on this record model
        """
        self.set_field_value(self.SKIPDISCREPANCY__FIELD_NAME.field_name, value)

    def get_SkipDiscrepancy_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SkipDiscrepancy' from this record model
        """
        return self.get_field_value(self.SKIPDISCREPANCY__FIELD_NAME.field_name)

    def set_StainPartConsumableLot_field(self, value: Optional[str]):
        """
        Set data field with field name 'StainPartConsumableLot' on this record model
        """
        self.set_field_value(self.STAINPARTCONSUMABLELOT__FIELD_NAME.field_name, value)

    def get_StainPartConsumableLot_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StainPartConsumableLot' from this record model
        """
        return self.get_field_value(self.STAINPARTCONSUMABLELOT__FIELD_NAME.field_name)

    def set_StainPartConsumableQty_field(self, value: Optional[float]):
        """
        Set data field with field name 'StainPartConsumableQty' on this record model
        """
        self.set_field_value(self.STAINPARTCONSUMABLEQTY__FIELD_NAME.field_name, value)

    def get_StainPartConsumableQty_field(self) -> Optional[float]:
        """
        Get data field value with field name 'StainPartConsumableQty' from this record model
        """
        return self.get_field_value(self.STAINPARTCONSUMABLEQTY__FIELD_NAME.field_name)

    def set_StainPartConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'StainPartConsumableType' on this record model
        """
        self.set_field_value(self.STAINPARTCONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_StainPartConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StainPartConsumableType' from this record model
        """
        return self.get_field_value(self.STAINPARTCONSUMABLETYPE__FIELD_NAME.field_name)

    def set_StandardError_field(self, value: Optional[float]):
        """
        Set data field with field name 'StandardError' on this record model
        """
        self.set_field_value(self.STANDARDERROR__FIELD_NAME.field_name, value)

    def get_StandardError_field(self) -> Optional[float]:
        """
        Get data field value with field name 'StandardError' from this record model
        """
        return self.get_field_value(self.STANDARDERROR__FIELD_NAME.field_name)

    def set_StandardErrorThreshold_field(self, value: Optional[float]):
        """
        Set data field with field name 'StandardErrorThreshold' on this record model
        """
        self.set_field_value(self.STANDARDERRORTHRESHOLD__FIELD_NAME.field_name, value)

    def get_StandardErrorThreshold_field(self) -> Optional[float]:
        """
        Get data field value with field name 'StandardErrorThreshold' from this record model
        """
        return self.get_field_value(self.STANDARDERRORTHRESHOLD__FIELD_NAME.field_name)

    def set_StorageUnitPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'StorageUnitPath' on this record model
        """
        self.set_field_value(self.STORAGEUNITPATH__FIELD_NAME.field_name, value)

    def get_StorageUnitPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StorageUnitPath' from this record model
        """
        return self.get_field_value(self.STORAGEUNITPATH__FIELD_NAME.field_name)

    def set_StrainName_field(self, value: Optional[str]):
        """
        Set data field with field name 'StrainName' on this record model
        """
        self.set_field_value(self.STRAINNAME__FIELD_NAME.field_name, value)

    def get_StrainName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StrainName' from this record model
        """
        return self.get_field_value(self.STRAINNAME__FIELD_NAME.field_name)

    def set_StrainPartConsumableLot_field(self, value: Optional[str]):
        """
        Set data field with field name 'StrainPartConsumableLot' on this record model
        """
        self.set_field_value(self.STRAINPARTCONSUMABLELOT__FIELD_NAME.field_name, value)

    def get_StrainPartConsumableLot_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StrainPartConsumableLot' from this record model
        """
        return self.get_field_value(self.STRAINPARTCONSUMABLELOT__FIELD_NAME.field_name)

    def set_StrainPartConsumableQty_field(self, value: Optional[float]):
        """
        Set data field with field name 'StrainPartConsumableQty' on this record model
        """
        self.set_field_value(self.STRAINPARTCONSUMABLEQTY__FIELD_NAME.field_name, value)

    def get_StrainPartConsumableQty_field(self) -> Optional[float]:
        """
        Get data field value with field name 'StrainPartConsumableQty' from this record model
        """
        return self.get_field_value(self.STRAINPARTCONSUMABLEQTY__FIELD_NAME.field_name)

    def set_StrainPartConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'StrainPartConsumableType' on this record model
        """
        self.set_field_value(self.STRAINPARTCONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_StrainPartConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StrainPartConsumableType' from this record model
        """
        return self.get_field_value(self.STRAINPARTCONSUMABLETYPE__FIELD_NAME.field_name)

    def set_StudyId_field(self, value: Optional[str]):
        """
        Set data field with field name 'StudyId' on this record model
        """
        self.set_field_value(self.STUDYID__FIELD_NAME.field_name, value)

    def get_StudyId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StudyId' from this record model
        """
        return self.get_field_value(self.STUDYID__FIELD_NAME.field_name)

    def set_Target_field(self, value: Optional[float]):
        """
        Set data field with field name 'Target' on this record model
        """
        self.set_field_value(self.TARGET__FIELD_NAME.field_name, value)

    def get_Target_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Target' from this record model
        """
        return self.get_field_value(self.TARGET__FIELD_NAME.field_name)

    def set_TechAssigned_field(self, value: Optional[str]):
        """
        Set data field with field name 'TechAssigned' on this record model
        """
        self.set_field_value(self.TECHASSIGNED__FIELD_NAME.field_name, value)

    def get_TechAssigned_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TechAssigned' from this record model
        """
        return self.get_field_value(self.TECHASSIGNED__FIELD_NAME.field_name)

    def set_Technician_field(self, value: Optional[str]):
        """
        Set data field with field name 'Technician' on this record model
        """
        self.set_field_value(self.TECHNICIAN__FIELD_NAME.field_name, value)

    def get_Technician_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Technician' from this record model
        """
        return self.get_field_value(self.TECHNICIAN__FIELD_NAME.field_name)

    def set_TechnicianAssigned_field(self, value: Optional[str]):
        """
        Set data field with field name 'TechnicianAssigned' on this record model
        """
        self.set_field_value(self.TECHNICIANASSIGNED__FIELD_NAME.field_name, value)

    def get_TechnicianAssigned_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TechnicianAssigned' from this record model
        """
        return self.get_field_value(self.TECHNICIANASSIGNED__FIELD_NAME.field_name)

    def set_Temperature_field(self, value: Optional[int]):
        """
        Set data field with field name 'Temperature' on this record model
        """
        self.set_field_value(self.TEMPERATURE__FIELD_NAME.field_name, value)

    def get_Temperature_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Temperature' from this record model
        """
        return self.get_field_value(self.TEMPERATURE__FIELD_NAME.field_name)

    def set_TemperatureUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'TemperatureUnits' on this record model
        """
        self.set_field_value(self.TEMPERATUREUNITS__FIELD_NAME.field_name, value)

    def get_TemperatureUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TemperatureUnits' from this record model
        """
        return self.get_field_value(self.TEMPERATUREUNITS__FIELD_NAME.field_name)

    def set_TheoryMoles_field(self, value: Optional[float]):
        """
        Set data field with field name 'TheoryMoles' on this record model
        """
        self.set_field_value(self.THEORYMOLES__FIELD_NAME.field_name, value)

    def get_TheoryMoles_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TheoryMoles' from this record model
        """
        return self.get_field_value(self.THEORYMOLES__FIELD_NAME.field_name)

    def set_TreatmentGroupId_field(self, value: Optional[str]):
        """
        Set data field with field name 'TreatmentGroupId' on this record model
        """
        self.set_field_value(self.TREATMENTGROUPID__FIELD_NAME.field_name, value)

    def get_TreatmentGroupId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TreatmentGroupId' from this record model
        """
        return self.get_field_value(self.TREATMENTGROUPID__FIELD_NAME.field_name)

    def set_Trial_field(self, value: Optional[float]):
        """
        Set data field with field name 'Trial' on this record model
        """
        self.set_field_value(self.TRIAL__FIELD_NAME.field_name, value)

    def get_Trial_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Trial' from this record model
        """
        return self.get_field_value(self.TRIAL__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)

    def set_ViralVectorPartConsumableLot_field(self, value: Optional[str]):
        """
        Set data field with field name 'ViralVectorPartConsumableLot' on this record model
        """
        self.set_field_value(self.VIRALVECTORPARTCONSUMABLELOT__FIELD_NAME.field_name, value)

    def get_ViralVectorPartConsumableLot_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ViralVectorPartConsumableLot' from this record model
        """
        return self.get_field_value(self.VIRALVECTORPARTCONSUMABLELOT__FIELD_NAME.field_name)

    def set_ViralVectorPartConsumableQty_field(self, value: Optional[float]):
        """
        Set data field with field name 'ViralVectorPartConsumableQty' on this record model
        """
        self.set_field_value(self.VIRALVECTORPARTCONSUMABLEQTY__FIELD_NAME.field_name, value)

    def get_ViralVectorPartConsumableQty_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ViralVectorPartConsumableQty' from this record model
        """
        return self.get_field_value(self.VIRALVECTORPARTCONSUMABLEQTY__FIELD_NAME.field_name)

    def set_ViralVectorPartConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ViralVectorPartConsumableType' on this record model
        """
        self.set_field_value(self.VIRALVECTORPARTCONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ViralVectorPartConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ViralVectorPartConsumableType' from this record model
        """
        return self.get_field_value(self.VIRALVECTORPARTCONSUMABLETYPE__FIELD_NAME.field_name)

    def set_ViralVectorPartPartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'ViralVectorPartPartNumber' on this record model
        """
        self.set_field_value(self.VIRALVECTORPARTPARTNUMBER__FIELD_NAME.field_name, value)

    def get_ViralVectorPartPartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ViralVectorPartPartNumber' from this record model
        """
        return self.get_field_value(self.VIRALVECTORPARTPARTNUMBER__FIELD_NAME.field_name)

    def set_Volume_field(self, value: Optional[float]):
        """
        Set data field with field name 'Volume' on this record model
        """
        self.set_field_value(self.VOLUME__FIELD_NAME.field_name, value)

    def get_Volume_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Volume' from this record model
        """
        return self.get_field_value(self.VOLUME__FIELD_NAME.field_name)

    def set_VolumeUnits_field(self, value: Optional[str]):
        """
        Set data field with field name 'VolumeUnits' on this record model
        """
        self.set_field_value(self.VOLUMEUNITS__FIELD_NAME.field_name, value)

    def get_VolumeUnits_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VolumeUnits' from this record model
        """
        return self.get_field_value(self.VOLUMEUNITS__FIELD_NAME.field_name)

    def set_WellId_field(self, value: Optional[str]):
        """
        Set data field with field name 'WellId' on this record model
        """
        self.set_field_value(self.WELLID__FIELD_NAME.field_name, value)

    def get_WellId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'WellId' from this record model
        """
        return self.get_field_value(self.WELLID__FIELD_NAME.field_name)

    def set_WorkstationId_field(self, value: Optional[str]):
        """
        Set data field with field name 'WorkstationId' on this record model
        """
        self.set_field_value(self.WORKSTATIONID__FIELD_NAME.field_name, value)

    def get_WorkstationId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'WorkstationId' from this record model
        """
        return self.get_field_value(self.WORKSTATIONID__FIELD_NAME.field_name)

    def set_Yield_field(self, value: Optional[float]):
        """
        Set data field with field name 'Yield' on this record model
        """
        self.set_field_value(self.YIELD__FIELD_NAME.field_name, value)

    def get_Yield_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Yield' from this record model
        """
        return self.get_field_value(self.YIELD__FIELD_NAME.field_name)

    def set_Yield2_field(self, value: Optional[float]):
        """
        Set data field with field name 'Yield2' on this record model
        """
        self.set_field_value(self.YIELD2__FIELD_NAME.field_name, value)

    def get_Yield2_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Yield2' from this record model
        """
        return self.get_field_value(self.YIELD2__FIELD_NAME.field_name)

    def set_inchi_field(self, value: Optional[str]):
        """
        Set data field with field name 'inchi' on this record model
        """
        self.set_field_value(self.INCHI__FIELD_NAME.field_name, value)

    def get_inchi_field(self) -> Optional[str]:
        """
        Get data field value with field name 'inchi' from this record model
        """
        return self.get_field_value(self.INCHI__FIELD_NAME.field_name)


class ELNSampleDetailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ELNSampleDetail
    Data Type Display Name: Sample Detail (Sample Details)
    Fields: OtherSampleId, CreatedBy, DataRecordName, DataTypeId, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, SampleId
    Data type to represent the base E-Notebook data type to represent the sample level details.
    """
    DATA_TYPE_NAME: Final[str] = 'ELNSampleDetail'
    DISPLAY_NAME: Final[str] = "Sample Detail"
    PLURAL_DISPLAY_NAME: Final[str] = "Sample Details"
    ANALYTE__FIELD_NAME: Final[WrapperField] = WrapperField("Analyte", FieldType.STRING, display_name="Analyte")
    AVERAGEREADING__FIELD_NAME: Final[WrapperField] = WrapperField("AverageReading", FieldType.DOUBLE, display_name="Average Reading")
    CEDEXREADING1__FIELD_NAME: Final[WrapperField] = WrapperField("CEDEXReading1", FieldType.DOUBLE, display_name="Reading 1")
    CEDEXREADING2__FIELD_NAME: Final[WrapperField] = WrapperField("CEDEXReading2", FieldType.DOUBLE, display_name="Reading 2")
    CEDEXREADING3__FIELD_NAME: Final[WrapperField] = WrapperField("CEDEXReading3", FieldType.DOUBLE, display_name="Reading 3")
    CV__FIELD_NAME: Final[WrapperField] = WrapperField("CV", FieldType.DOUBLE, display_name="CV (mL)")
    CI95BOUNDS__FIELD_NAME: Final[WrapperField] = WrapperField("Ci95Bounds", FieldType.DOUBLE, display_name="CI 95% Bounds")
    COLPOSITION__FIELD_NAME: Final[WrapperField] = WrapperField("ColPosition", FieldType.SELECTION, display_name="Column Position")
    COLUMNDESCRIPTION__FIELD_NAME: Final[WrapperField] = WrapperField("ColumnDescription", FieldType.STRING, display_name="Column Description")
    COLUMNVOLUME__FIELD_NAME: Final[WrapperField] = WrapperField("ColumnVolume", FieldType.DOUBLE, display_name="Column Volume (mL)")
    COMPOUND__FIELD_NAME: Final[WrapperField] = WrapperField("Compound", FieldType.STRING, display_name="Compound")
    CONTROLTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ControlType", FieldType.STRING, display_name="Control Type")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DNASEQUENCE__FIELD_NAME: Final[WrapperField] = WrapperField("DNASequence", FieldType.STRING, display_name="DNA Sequence")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATATYPEID__FIELD_NAME: Final[WrapperField] = WrapperField("DataTypeId", FieldType.LONG, display_name="Data Type ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DILUENTTOUSE__FIELD_NAME: Final[WrapperField] = WrapperField("DiluentToUse", FieldType.DOUBLE, display_name="Diluent To Use")
    EDITABLEOTHERSAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("EditableOtherSampleId", FieldType.STRING, display_name="Sample Name")
    EXISTINGPLATERECORDID__FIELD_NAME: Final[WrapperField] = WrapperField("ExistingPlateRecordId", FieldType.LONG, display_name="Existing Plate Record ID")
    FAMCT__FIELD_NAME: Final[WrapperField] = WrapperField("FamCt", FieldType.DOUBLE, display_name="FAM CT")
    HARVESTVOLUME__FIELD_NAME: Final[WrapperField] = WrapperField("HarvestVolume", FieldType.DOUBLE, display_name="Harvest Volume (mL)")
    HASHINGBARCODE__FIELD_NAME: Final[WrapperField] = WrapperField("HashingBarcode", FieldType.PICKLIST, display_name="Hashing Barcode")
    HIT__FIELD_NAME: Final[WrapperField] = WrapperField("Hit", FieldType.BOOLEAN, display_name="Hit")
    INDEXID__FIELD_NAME: Final[WrapperField] = WrapperField("IndexId", FieldType.STRING, display_name="Index ID")
    INDEXTAG__FIELD_NAME: Final[WrapperField] = WrapperField("IndexTag", FieldType.STRING, display_name="Index Tag")
    INPUTASSIGNMENTRECORDID__FIELD_NAME: Final[WrapperField] = WrapperField("InputAssignmentRecordId", FieldType.LONG, display_name="Input Assignment Record ID")
    ISNEWCONTROL__FIELD_NAME: Final[WrapperField] = WrapperField("IsNewControl", FieldType.BOOLEAN, display_name="Is New Control?")
    LOADDENSITY__FIELD_NAME: Final[WrapperField] = WrapperField("LoadDensity", FieldType.DOUBLE, display_name="Load Density (mg/mL)")
    LOWERCI95__FIELD_NAME: Final[WrapperField] = WrapperField("LowerCi95", FieldType.DOUBLE, display_name="Lower CI 95%")
    MULTIPLEXINSTRUCTIONS__FIELD_NAME: Final[WrapperField] = WrapperField("MultiplexInstructions", FieldType.SELECTION, display_name="Multiplex Instructions")
    NANODROP1__FIELD_NAME: Final[WrapperField] = WrapperField("Nanodrop1", FieldType.DOUBLE, display_name="Nanodrop 1")
    NANODROP2__FIELD_NAME: Final[WrapperField] = WrapperField("Nanodrop2", FieldType.DOUBLE, display_name="Nanodrop 2")
    NANODROP3__FIELD_NAME: Final[WrapperField] = WrapperField("Nanodrop3", FieldType.DOUBLE, display_name="Nanodrop 3")
    NUMBEROFREPLICATES__FIELD_NAME: Final[WrapperField] = WrapperField("NumberOfReplicates", FieldType.LONG, display_name="Number Of Replicates")
    NUMBEROFREPLICATESNOTEDITABLE__FIELD_NAME: Final[WrapperField] = WrapperField("NumberOfReplicatesNotEditable", FieldType.LONG, display_name="Number of Replicates")
    OTHERSAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("OtherSampleId", FieldType.STRING, display_name="Sample Name")
    OUTOFRANGE__FIELD_NAME: Final[WrapperField] = WrapperField("OutofRange", FieldType.PICKLIST, display_name="Out of Range")
    PASSFAIL__FIELD_NAME: Final[WrapperField] = WrapperField("PassFail", FieldType.PICKLIST, display_name="Pass Fail")
    PLATEID2__FIELD_NAME: Final[WrapperField] = WrapperField("PlateID2", FieldType.STRING, display_name="Plate ID")
    PLATEID__FIELD_NAME: Final[WrapperField] = WrapperField("PlateId", FieldType.STRING, display_name="Plate ID")
    POSITION__FIELD_NAME: Final[WrapperField] = WrapperField("Position", FieldType.STRING, display_name="Position")
    PROTEINCONCENTRATION__FIELD_NAME: Final[WrapperField] = WrapperField("ProteinConcentration", FieldType.DOUBLE, display_name="Protein Concentration (mg/mL)")
    QCSTATUS__FIELD_NAME: Final[WrapperField] = WrapperField("QCStatus", FieldType.PICKLIST, display_name="QC Status")
    READING1__FIELD_NAME: Final[WrapperField] = WrapperField("Reading1", FieldType.DOUBLE, display_name="Reading 1")
    READING2__FIELD_NAME: Final[WrapperField] = WrapperField("Reading2", FieldType.DOUBLE, display_name="Reading 2")
    REPROCESSSTATUS__FIELD_NAME: Final[WrapperField] = WrapperField("ReprocessStatus", FieldType.PICKLIST, display_name="Status")
    RESIDENCETIME__FIELD_NAME: Final[WrapperField] = WrapperField("ResidenceTime", FieldType.STRING, display_name="Residence Time (minutes)")
    RESINNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ResinName", FieldType.STRING, display_name="Resin Name")
    RESULT__FIELD_NAME: Final[WrapperField] = WrapperField("Result", FieldType.PICKLIST, display_name="Result")
    ROWPOSITION__FIELD_NAME: Final[WrapperField] = WrapperField("RowPosition", FieldType.SELECTION, display_name="Row Position")
    ROXCT__FIELD_NAME: Final[WrapperField] = WrapperField("RoxCt", FieldType.DOUBLE, display_name="ROX CT")
    SAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("SampleId", FieldType.STRING, display_name="Sample ID")
    SAMPLEMEAN__FIELD_NAME: Final[WrapperField] = WrapperField("SampleMean", FieldType.DOUBLE, display_name="Mean")
    SAMPLENAME__FIELD_NAME: Final[WrapperField] = WrapperField("SampleName", FieldType.STRING, display_name="Sample Name")
    SAMPLENORMALIZEDMEAN__FIELD_NAME: Final[WrapperField] = WrapperField("SampleNormalizedMean", FieldType.DOUBLE, display_name="Normalized Mean")
    SAMPLESTD__FIELD_NAME: Final[WrapperField] = WrapperField("SampleStd", FieldType.DOUBLE, display_name="Standard Deviation")
    SAMPLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("SampleType", FieldType.STRING, display_name="Sample Type")
    SOURCECONCENTRATION__FIELD_NAME: Final[WrapperField] = WrapperField("SourceConcentration", FieldType.DOUBLE, display_name="Source Concentration")
    SOURCEMASS__FIELD_NAME: Final[WrapperField] = WrapperField("SourceMass", FieldType.DOUBLE, display_name="Source Mass")
    SOURCEMASSTOUSE__FIELD_NAME: Final[WrapperField] = WrapperField("SourceMassToUse", FieldType.DOUBLE, display_name="Source Mass To Use")
    SOURCEPLATE__FIELD_NAME: Final[WrapperField] = WrapperField("SourcePlate", FieldType.STRING, display_name="Source Plate")
    SOURCEPOSITION__FIELD_NAME: Final[WrapperField] = WrapperField("SourcePosition", FieldType.STRING, display_name="Source Position")
    SOURCEVOLUME__FIELD_NAME: Final[WrapperField] = WrapperField("SourceVolume", FieldType.DOUBLE, display_name="Source Volume")
    SOURCEVOLUMETOUSE__FIELD_NAME: Final[WrapperField] = WrapperField("SourceVolumeToUse", FieldType.DOUBLE, display_name="Source Volume To Use")
    STANDARDERROR__FIELD_NAME: Final[WrapperField] = WrapperField("StandardError", FieldType.DOUBLE, display_name="Standard Error")
    STATUSCODE__FIELD_NAME: Final[WrapperField] = WrapperField("StatusCode", FieldType.STRING, display_name="Status Code")
    TARGETCONCENTRATION__FIELD_NAME: Final[WrapperField] = WrapperField("TargetConcentration", FieldType.DOUBLE, display_name="Target Concentration")
    TARGETCONCENTRATIONREQUIRED__FIELD_NAME: Final[WrapperField] = WrapperField("TargetConcentrationRequired", FieldType.DOUBLE, display_name="Target Concentration")
    TARGETMASS__FIELD_NAME: Final[WrapperField] = WrapperField("TargetMass", FieldType.DOUBLE, display_name="Target Mass")
    TARGETPLATE__FIELD_NAME: Final[WrapperField] = WrapperField("TargetPlate", FieldType.STRING, display_name="Target Plate")
    TARGETPOOL__FIELD_NAME: Final[WrapperField] = WrapperField("TargetPool", FieldType.STRING, display_name="Target Pool")
    TARGETPOSITION__FIELD_NAME: Final[WrapperField] = WrapperField("TargetPosition", FieldType.STRING, display_name="Target Position")
    TARGETTANK__FIELD_NAME: Final[WrapperField] = WrapperField("TargetTank", FieldType.STRING, display_name="Target Tank")
    TARGETVOLUME__FIELD_NAME: Final[WrapperField] = WrapperField("TargetVolume", FieldType.DOUBLE, display_name="Target Volume")
    TARGETVOLUMEREQUIRED__FIELD_NAME: Final[WrapperField] = WrapperField("TargetVolumeRequired", FieldType.DOUBLE, display_name="Target Volume")
    TOTALPROTEINVARIABLE__FIELD_NAME: Final[WrapperField] = WrapperField("TotalProteinVariable", FieldType.DOUBLE, display_name="Variable")
    TRANSFORMATIONREAGENT__FIELD_NAME: Final[WrapperField] = WrapperField("TransformationReagent", FieldType.STRING, display_name="Transformation Reagent")
    TUMOR2__FIELD_NAME: Final[WrapperField] = WrapperField("Tumor2", FieldType.DOUBLE, display_name="Tumor %")
    UPPERCI95__FIELD_NAME: Final[WrapperField] = WrapperField("UpperCi95", FieldType.DOUBLE, display_name="Upper CI 95%")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VICCT__FIELD_NAME: Final[WrapperField] = WrapperField("VicCt", FieldType.DOUBLE, display_name="VIC CT")
    WELLLOCATION__FIELD_NAME: Final[WrapperField] = WrapperField("WellLocation", FieldType.STRING, display_name="Well Location")
    ANALYTE2__FIELD_NAME: Final[WrapperField] = WrapperField("analyte2", FieldType.STRING, display_name="analyte")
    AVGREADINGS__FIELD_NAME: Final[WrapperField] = WrapperField("avgreadings", FieldType.DOUBLE, display_name="avg readings")
    READING__FIELD_NAME: Final[WrapperField] = WrapperField("reading", FieldType.DOUBLE, display_name="reading")
    READING22__FIELD_NAME: Final[WrapperField] = WrapperField("reading22", FieldType.DOUBLE, display_name="reading 2")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Analyte_field(self, value: Optional[str]):
        """
        Set data field with field name 'Analyte' on this record model
        """
        self.set_field_value(self.ANALYTE__FIELD_NAME.field_name, value)

    def get_Analyte_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Analyte' from this record model
        """
        return self.get_field_value(self.ANALYTE__FIELD_NAME.field_name)

    def set_AverageReading_field(self, value: Optional[float]):
        """
        Set data field with field name 'AverageReading' on this record model
        """
        self.set_field_value(self.AVERAGEREADING__FIELD_NAME.field_name, value)

    def get_AverageReading_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AverageReading' from this record model
        """
        return self.get_field_value(self.AVERAGEREADING__FIELD_NAME.field_name)

    def set_CEDEXReading1_field(self, value: Optional[float]):
        """
        Set data field with field name 'CEDEXReading1' on this record model
        """
        self.set_field_value(self.CEDEXREADING1__FIELD_NAME.field_name, value)

    def get_CEDEXReading1_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CEDEXReading1' from this record model
        """
        return self.get_field_value(self.CEDEXREADING1__FIELD_NAME.field_name)

    def set_CEDEXReading2_field(self, value: Optional[float]):
        """
        Set data field with field name 'CEDEXReading2' on this record model
        """
        self.set_field_value(self.CEDEXREADING2__FIELD_NAME.field_name, value)

    def get_CEDEXReading2_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CEDEXReading2' from this record model
        """
        return self.get_field_value(self.CEDEXREADING2__FIELD_NAME.field_name)

    def set_CEDEXReading3_field(self, value: Optional[float]):
        """
        Set data field with field name 'CEDEXReading3' on this record model
        """
        self.set_field_value(self.CEDEXREADING3__FIELD_NAME.field_name, value)

    def get_CEDEXReading3_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CEDEXReading3' from this record model
        """
        return self.get_field_value(self.CEDEXREADING3__FIELD_NAME.field_name)

    def set_CV_field(self, value: Optional[float]):
        """
        Set data field with field name 'CV' on this record model
        """
        self.set_field_value(self.CV__FIELD_NAME.field_name, value)

    def get_CV_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CV' from this record model
        """
        return self.get_field_value(self.CV__FIELD_NAME.field_name)

    def set_Ci95Bounds_field(self, value: Optional[float]):
        """
        Set data field with field name 'Ci95Bounds' on this record model
        """
        self.set_field_value(self.CI95BOUNDS__FIELD_NAME.field_name, value)

    def get_Ci95Bounds_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Ci95Bounds' from this record model
        """
        return self.get_field_value(self.CI95BOUNDS__FIELD_NAME.field_name)

    def set_ColPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColPosition' on this record model
        """
        self.set_field_value(self.COLPOSITION__FIELD_NAME.field_name, value)

    def get_ColPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColPosition' from this record model
        """
        return self.get_field_value(self.COLPOSITION__FIELD_NAME.field_name)

    def set_ColumnDescription_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColumnDescription' on this record model
        """
        self.set_field_value(self.COLUMNDESCRIPTION__FIELD_NAME.field_name, value)

    def get_ColumnDescription_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColumnDescription' from this record model
        """
        return self.get_field_value(self.COLUMNDESCRIPTION__FIELD_NAME.field_name)

    def set_ColumnVolume_field(self, value: Optional[float]):
        """
        Set data field with field name 'ColumnVolume' on this record model
        """
        self.set_field_value(self.COLUMNVOLUME__FIELD_NAME.field_name, value)

    def get_ColumnVolume_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ColumnVolume' from this record model
        """
        return self.get_field_value(self.COLUMNVOLUME__FIELD_NAME.field_name)

    def set_Compound_field(self, value: Optional[str]):
        """
        Set data field with field name 'Compound' on this record model
        """
        self.set_field_value(self.COMPOUND__FIELD_NAME.field_name, value)

    def get_Compound_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Compound' from this record model
        """
        return self.get_field_value(self.COMPOUND__FIELD_NAME.field_name)

    def set_ControlType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ControlType' on this record model
        """
        self.set_field_value(self.CONTROLTYPE__FIELD_NAME.field_name, value)

    def get_ControlType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ControlType' from this record model
        """
        return self.get_field_value(self.CONTROLTYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DNASequence_field(self, value: Optional[str]):
        """
        Set data field with field name 'DNASequence' on this record model
        """
        self.set_field_value(self.DNASEQUENCE__FIELD_NAME.field_name, value)

    def get_DNASequence_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DNASequence' from this record model
        """
        return self.get_field_value(self.DNASEQUENCE__FIELD_NAME.field_name)

    def set_DataTypeId_field(self, value: Optional[int]):
        """
        Set data field with field name 'DataTypeId' on this record model
        """
        self.set_field_value(self.DATATYPEID__FIELD_NAME.field_name, value)

    def get_DataTypeId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DataTypeId' from this record model
        """
        return self.get_field_value(self.DATATYPEID__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DiluentToUse_field(self, value: Optional[float]):
        """
        Set data field with field name 'DiluentToUse' on this record model
        """
        self.set_field_value(self.DILUENTTOUSE__FIELD_NAME.field_name, value)

    def get_DiluentToUse_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DiluentToUse' from this record model
        """
        return self.get_field_value(self.DILUENTTOUSE__FIELD_NAME.field_name)

    def set_EditableOtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'EditableOtherSampleId' on this record model
        """
        self.set_field_value(self.EDITABLEOTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_EditableOtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EditableOtherSampleId' from this record model
        """
        return self.get_field_value(self.EDITABLEOTHERSAMPLEID__FIELD_NAME.field_name)

    def set_ExistingPlateRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExistingPlateRecordId' on this record model
        """
        self.set_field_value(self.EXISTINGPLATERECORDID__FIELD_NAME.field_name, value)

    def get_ExistingPlateRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExistingPlateRecordId' from this record model
        """
        return self.get_field_value(self.EXISTINGPLATERECORDID__FIELD_NAME.field_name)

    def set_FamCt_field(self, value: Optional[float]):
        """
        Set data field with field name 'FamCt' on this record model
        """
        self.set_field_value(self.FAMCT__FIELD_NAME.field_name, value)

    def get_FamCt_field(self) -> Optional[float]:
        """
        Get data field value with field name 'FamCt' from this record model
        """
        return self.get_field_value(self.FAMCT__FIELD_NAME.field_name)

    def set_HarvestVolume_field(self, value: Optional[float]):
        """
        Set data field with field name 'HarvestVolume' on this record model
        """
        self.set_field_value(self.HARVESTVOLUME__FIELD_NAME.field_name, value)

    def get_HarvestVolume_field(self) -> Optional[float]:
        """
        Get data field value with field name 'HarvestVolume' from this record model
        """
        return self.get_field_value(self.HARVESTVOLUME__FIELD_NAME.field_name)

    def set_HashingBarcode_field(self, value: Optional[str]):
        """
        Set data field with field name 'HashingBarcode' on this record model
        """
        self.set_field_value(self.HASHINGBARCODE__FIELD_NAME.field_name, value)

    def get_HashingBarcode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'HashingBarcode' from this record model
        """
        return self.get_field_value(self.HASHINGBARCODE__FIELD_NAME.field_name)

    def set_Hit_field(self, value: Optional[bool]):
        """
        Set data field with field name 'Hit' on this record model
        """
        self.set_field_value(self.HIT__FIELD_NAME.field_name, value)

    def get_Hit_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'Hit' from this record model
        """
        return self.get_field_value(self.HIT__FIELD_NAME.field_name)

    def set_IndexId_field(self, value: Optional[str]):
        """
        Set data field with field name 'IndexId' on this record model
        """
        self.set_field_value(self.INDEXID__FIELD_NAME.field_name, value)

    def get_IndexId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IndexId' from this record model
        """
        return self.get_field_value(self.INDEXID__FIELD_NAME.field_name)

    def set_IndexTag_field(self, value: Optional[str]):
        """
        Set data field with field name 'IndexTag' on this record model
        """
        self.set_field_value(self.INDEXTAG__FIELD_NAME.field_name, value)

    def get_IndexTag_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IndexTag' from this record model
        """
        return self.get_field_value(self.INDEXTAG__FIELD_NAME.field_name)

    def set_InputAssignmentRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'InputAssignmentRecordId' on this record model
        """
        self.set_field_value(self.INPUTASSIGNMENTRECORDID__FIELD_NAME.field_name, value)

    def get_InputAssignmentRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'InputAssignmentRecordId' from this record model
        """
        return self.get_field_value(self.INPUTASSIGNMENTRECORDID__FIELD_NAME.field_name)

    def set_IsNewControl_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsNewControl' on this record model
        """
        self.set_field_value(self.ISNEWCONTROL__FIELD_NAME.field_name, value)

    def get_IsNewControl_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsNewControl' from this record model
        """
        return self.get_field_value(self.ISNEWCONTROL__FIELD_NAME.field_name)

    def set_LoadDensity_field(self, value: Optional[float]):
        """
        Set data field with field name 'LoadDensity' on this record model
        """
        self.set_field_value(self.LOADDENSITY__FIELD_NAME.field_name, value)

    def get_LoadDensity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'LoadDensity' from this record model
        """
        return self.get_field_value(self.LOADDENSITY__FIELD_NAME.field_name)

    def set_LowerCi95_field(self, value: Optional[float]):
        """
        Set data field with field name 'LowerCi95' on this record model
        """
        self.set_field_value(self.LOWERCI95__FIELD_NAME.field_name, value)

    def get_LowerCi95_field(self) -> Optional[float]:
        """
        Get data field value with field name 'LowerCi95' from this record model
        """
        return self.get_field_value(self.LOWERCI95__FIELD_NAME.field_name)

    def set_MultiplexInstructions_field(self, value: Optional[str]):
        """
        Set data field with field name 'MultiplexInstructions' on this record model
        """
        self.set_field_value(self.MULTIPLEXINSTRUCTIONS__FIELD_NAME.field_name, value)

    def get_MultiplexInstructions_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MultiplexInstructions' from this record model
        """
        return self.get_field_value(self.MULTIPLEXINSTRUCTIONS__FIELD_NAME.field_name)

    def set_Nanodrop1_field(self, value: Optional[float]):
        """
        Set data field with field name 'Nanodrop1' on this record model
        """
        self.set_field_value(self.NANODROP1__FIELD_NAME.field_name, value)

    def get_Nanodrop1_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Nanodrop1' from this record model
        """
        return self.get_field_value(self.NANODROP1__FIELD_NAME.field_name)

    def set_Nanodrop2_field(self, value: Optional[float]):
        """
        Set data field with field name 'Nanodrop2' on this record model
        """
        self.set_field_value(self.NANODROP2__FIELD_NAME.field_name, value)

    def get_Nanodrop2_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Nanodrop2' from this record model
        """
        return self.get_field_value(self.NANODROP2__FIELD_NAME.field_name)

    def set_Nanodrop3_field(self, value: Optional[float]):
        """
        Set data field with field name 'Nanodrop3' on this record model
        """
        self.set_field_value(self.NANODROP3__FIELD_NAME.field_name, value)

    def get_Nanodrop3_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Nanodrop3' from this record model
        """
        return self.get_field_value(self.NANODROP3__FIELD_NAME.field_name)

    def set_NumberOfReplicates_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumberOfReplicates' on this record model
        """
        self.set_field_value(self.NUMBEROFREPLICATES__FIELD_NAME.field_name, value)

    def get_NumberOfReplicates_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumberOfReplicates' from this record model
        """
        return self.get_field_value(self.NUMBEROFREPLICATES__FIELD_NAME.field_name)

    def set_NumberOfReplicatesNotEditable_field(self, value: Optional[int]):
        """
        Set data field with field name 'NumberOfReplicatesNotEditable' on this record model
        """
        self.set_field_value(self.NUMBEROFREPLICATESNOTEDITABLE__FIELD_NAME.field_name, value)

    def get_NumberOfReplicatesNotEditable_field(self) -> Optional[int]:
        """
        Get data field value with field name 'NumberOfReplicatesNotEditable' from this record model
        """
        return self.get_field_value(self.NUMBEROFREPLICATESNOTEDITABLE__FIELD_NAME.field_name)

    def set_OtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'OtherSampleId' on this record model
        """
        self.set_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_OtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OtherSampleId' from this record model
        """
        return self.get_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name)

    def set_OutofRange_field(self, value: Optional[str]):
        """
        Set data field with field name 'OutofRange' on this record model
        """
        self.set_field_value(self.OUTOFRANGE__FIELD_NAME.field_name, value)

    def get_OutofRange_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OutofRange' from this record model
        """
        return self.get_field_value(self.OUTOFRANGE__FIELD_NAME.field_name)

    def set_PassFail_field(self, value: Optional[str]):
        """
        Set data field with field name 'PassFail' on this record model
        """
        self.set_field_value(self.PASSFAIL__FIELD_NAME.field_name, value)

    def get_PassFail_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PassFail' from this record model
        """
        return self.get_field_value(self.PASSFAIL__FIELD_NAME.field_name)

    def set_PlateID2_field(self, value: Optional[str]):
        """
        Set data field with field name 'PlateID2' on this record model
        """
        self.set_field_value(self.PLATEID2__FIELD_NAME.field_name, value)

    def get_PlateID2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PlateID2' from this record model
        """
        return self.get_field_value(self.PLATEID2__FIELD_NAME.field_name)

    def set_PlateId_field(self, value: Optional[str]):
        """
        Set data field with field name 'PlateId' on this record model
        """
        self.set_field_value(self.PLATEID__FIELD_NAME.field_name, value)

    def get_PlateId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PlateId' from this record model
        """
        return self.get_field_value(self.PLATEID__FIELD_NAME.field_name)

    def set_Position_field(self, value: Optional[str]):
        """
        Set data field with field name 'Position' on this record model
        """
        self.set_field_value(self.POSITION__FIELD_NAME.field_name, value)

    def get_Position_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Position' from this record model
        """
        return self.get_field_value(self.POSITION__FIELD_NAME.field_name)

    def set_ProteinConcentration_field(self, value: Optional[float]):
        """
        Set data field with field name 'ProteinConcentration' on this record model
        """
        self.set_field_value(self.PROTEINCONCENTRATION__FIELD_NAME.field_name, value)

    def get_ProteinConcentration_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ProteinConcentration' from this record model
        """
        return self.get_field_value(self.PROTEINCONCENTRATION__FIELD_NAME.field_name)

    def set_QCStatus_field(self, value: Optional[str]):
        """
        Set data field with field name 'QCStatus' on this record model
        """
        self.set_field_value(self.QCSTATUS__FIELD_NAME.field_name, value)

    def get_QCStatus_field(self) -> Optional[str]:
        """
        Get data field value with field name 'QCStatus' from this record model
        """
        return self.get_field_value(self.QCSTATUS__FIELD_NAME.field_name)

    def set_Reading1_field(self, value: Optional[float]):
        """
        Set data field with field name 'Reading1' on this record model
        """
        self.set_field_value(self.READING1__FIELD_NAME.field_name, value)

    def get_Reading1_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Reading1' from this record model
        """
        return self.get_field_value(self.READING1__FIELD_NAME.field_name)

    def set_Reading2_field(self, value: Optional[float]):
        """
        Set data field with field name 'Reading2' on this record model
        """
        self.set_field_value(self.READING2__FIELD_NAME.field_name, value)

    def get_Reading2_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Reading2' from this record model
        """
        return self.get_field_value(self.READING2__FIELD_NAME.field_name)

    def set_ReprocessStatus_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReprocessStatus' on this record model
        """
        self.set_field_value(self.REPROCESSSTATUS__FIELD_NAME.field_name, value)

    def get_ReprocessStatus_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReprocessStatus' from this record model
        """
        return self.get_field_value(self.REPROCESSSTATUS__FIELD_NAME.field_name)

    def set_ResidenceTime_field(self, value: Optional[str]):
        """
        Set data field with field name 'ResidenceTime' on this record model
        """
        self.set_field_value(self.RESIDENCETIME__FIELD_NAME.field_name, value)

    def get_ResidenceTime_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ResidenceTime' from this record model
        """
        return self.get_field_value(self.RESIDENCETIME__FIELD_NAME.field_name)

    def set_ResinName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ResinName' on this record model
        """
        self.set_field_value(self.RESINNAME__FIELD_NAME.field_name, value)

    def get_ResinName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ResinName' from this record model
        """
        return self.get_field_value(self.RESINNAME__FIELD_NAME.field_name)

    def set_Result_field(self, value: Optional[str]):
        """
        Set data field with field name 'Result' on this record model
        """
        self.set_field_value(self.RESULT__FIELD_NAME.field_name, value)

    def get_Result_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Result' from this record model
        """
        return self.get_field_value(self.RESULT__FIELD_NAME.field_name)

    def set_RowPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'RowPosition' on this record model
        """
        self.set_field_value(self.ROWPOSITION__FIELD_NAME.field_name, value)

    def get_RowPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RowPosition' from this record model
        """
        return self.get_field_value(self.ROWPOSITION__FIELD_NAME.field_name)

    def set_RoxCt_field(self, value: Optional[float]):
        """
        Set data field with field name 'RoxCt' on this record model
        """
        self.set_field_value(self.ROXCT__FIELD_NAME.field_name, value)

    def get_RoxCt_field(self) -> Optional[float]:
        """
        Get data field value with field name 'RoxCt' from this record model
        """
        return self.get_field_value(self.ROXCT__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def set_SampleMean_field(self, value: Optional[float]):
        """
        Set data field with field name 'SampleMean' on this record model
        """
        self.set_field_value(self.SAMPLEMEAN__FIELD_NAME.field_name, value)

    def get_SampleMean_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SampleMean' from this record model
        """
        return self.get_field_value(self.SAMPLEMEAN__FIELD_NAME.field_name)

    def set_SampleName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleName' on this record model
        """
        self.set_field_value(self.SAMPLENAME__FIELD_NAME.field_name, value)

    def get_SampleName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleName' from this record model
        """
        return self.get_field_value(self.SAMPLENAME__FIELD_NAME.field_name)

    def set_SampleNormalizedMean_field(self, value: Optional[float]):
        """
        Set data field with field name 'SampleNormalizedMean' on this record model
        """
        self.set_field_value(self.SAMPLENORMALIZEDMEAN__FIELD_NAME.field_name, value)

    def get_SampleNormalizedMean_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SampleNormalizedMean' from this record model
        """
        return self.get_field_value(self.SAMPLENORMALIZEDMEAN__FIELD_NAME.field_name)

    def set_SampleStd_field(self, value: Optional[float]):
        """
        Set data field with field name 'SampleStd' on this record model
        """
        self.set_field_value(self.SAMPLESTD__FIELD_NAME.field_name, value)

    def get_SampleStd_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SampleStd' from this record model
        """
        return self.get_field_value(self.SAMPLESTD__FIELD_NAME.field_name)

    def set_SampleType_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleType' on this record model
        """
        self.set_field_value(self.SAMPLETYPE__FIELD_NAME.field_name, value)

    def get_SampleType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleType' from this record model
        """
        return self.get_field_value(self.SAMPLETYPE__FIELD_NAME.field_name)

    def set_SourceConcentration_field(self, value: Optional[float]):
        """
        Set data field with field name 'SourceConcentration' on this record model
        """
        self.set_field_value(self.SOURCECONCENTRATION__FIELD_NAME.field_name, value)

    def get_SourceConcentration_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SourceConcentration' from this record model
        """
        return self.get_field_value(self.SOURCECONCENTRATION__FIELD_NAME.field_name)

    def set_SourceMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'SourceMass' on this record model
        """
        self.set_field_value(self.SOURCEMASS__FIELD_NAME.field_name, value)

    def get_SourceMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SourceMass' from this record model
        """
        return self.get_field_value(self.SOURCEMASS__FIELD_NAME.field_name)

    def set_SourceMassToUse_field(self, value: Optional[float]):
        """
        Set data field with field name 'SourceMassToUse' on this record model
        """
        self.set_field_value(self.SOURCEMASSTOUSE__FIELD_NAME.field_name, value)

    def get_SourceMassToUse_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SourceMassToUse' from this record model
        """
        return self.get_field_value(self.SOURCEMASSTOUSE__FIELD_NAME.field_name)

    def set_SourcePlate_field(self, value: Optional[str]):
        """
        Set data field with field name 'SourcePlate' on this record model
        """
        self.set_field_value(self.SOURCEPLATE__FIELD_NAME.field_name, value)

    def get_SourcePlate_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SourcePlate' from this record model
        """
        return self.get_field_value(self.SOURCEPLATE__FIELD_NAME.field_name)

    def set_SourcePosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'SourcePosition' on this record model
        """
        self.set_field_value(self.SOURCEPOSITION__FIELD_NAME.field_name, value)

    def get_SourcePosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SourcePosition' from this record model
        """
        return self.get_field_value(self.SOURCEPOSITION__FIELD_NAME.field_name)

    def set_SourceVolume_field(self, value: Optional[float]):
        """
        Set data field with field name 'SourceVolume' on this record model
        """
        self.set_field_value(self.SOURCEVOLUME__FIELD_NAME.field_name, value)

    def get_SourceVolume_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SourceVolume' from this record model
        """
        return self.get_field_value(self.SOURCEVOLUME__FIELD_NAME.field_name)

    def set_SourceVolumeToUse_field(self, value: Optional[float]):
        """
        Set data field with field name 'SourceVolumeToUse' on this record model
        """
        self.set_field_value(self.SOURCEVOLUMETOUSE__FIELD_NAME.field_name, value)

    def get_SourceVolumeToUse_field(self) -> Optional[float]:
        """
        Get data field value with field name 'SourceVolumeToUse' from this record model
        """
        return self.get_field_value(self.SOURCEVOLUMETOUSE__FIELD_NAME.field_name)

    def set_StandardError_field(self, value: Optional[float]):
        """
        Set data field with field name 'StandardError' on this record model
        """
        self.set_field_value(self.STANDARDERROR__FIELD_NAME.field_name, value)

    def get_StandardError_field(self) -> Optional[float]:
        """
        Get data field value with field name 'StandardError' from this record model
        """
        return self.get_field_value(self.STANDARDERROR__FIELD_NAME.field_name)

    def set_StatusCode_field(self, value: Optional[str]):
        """
        Set data field with field name 'StatusCode' on this record model
        """
        self.set_field_value(self.STATUSCODE__FIELD_NAME.field_name, value)

    def get_StatusCode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StatusCode' from this record model
        """
        return self.get_field_value(self.STATUSCODE__FIELD_NAME.field_name)

    def set_TargetConcentration_field(self, value: Optional[float]):
        """
        Set data field with field name 'TargetConcentration' on this record model
        """
        self.set_field_value(self.TARGETCONCENTRATION__FIELD_NAME.field_name, value)

    def get_TargetConcentration_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TargetConcentration' from this record model
        """
        return self.get_field_value(self.TARGETCONCENTRATION__FIELD_NAME.field_name)

    def set_TargetConcentrationRequired_field(self, value: Optional[float]):
        """
        Set data field with field name 'TargetConcentrationRequired' on this record model
        """
        self.set_field_value(self.TARGETCONCENTRATIONREQUIRED__FIELD_NAME.field_name, value)

    def get_TargetConcentrationRequired_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TargetConcentrationRequired' from this record model
        """
        return self.get_field_value(self.TARGETCONCENTRATIONREQUIRED__FIELD_NAME.field_name)

    def set_TargetMass_field(self, value: Optional[float]):
        """
        Set data field with field name 'TargetMass' on this record model
        """
        self.set_field_value(self.TARGETMASS__FIELD_NAME.field_name, value)

    def get_TargetMass_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TargetMass' from this record model
        """
        return self.get_field_value(self.TARGETMASS__FIELD_NAME.field_name)

    def set_TargetPlate_field(self, value: Optional[str]):
        """
        Set data field with field name 'TargetPlate' on this record model
        """
        self.set_field_value(self.TARGETPLATE__FIELD_NAME.field_name, value)

    def get_TargetPlate_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TargetPlate' from this record model
        """
        return self.get_field_value(self.TARGETPLATE__FIELD_NAME.field_name)

    def set_TargetPool_field(self, value: Optional[str]):
        """
        Set data field with field name 'TargetPool' on this record model
        """
        self.set_field_value(self.TARGETPOOL__FIELD_NAME.field_name, value)

    def get_TargetPool_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TargetPool' from this record model
        """
        return self.get_field_value(self.TARGETPOOL__FIELD_NAME.field_name)

    def set_TargetPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'TargetPosition' on this record model
        """
        self.set_field_value(self.TARGETPOSITION__FIELD_NAME.field_name, value)

    def get_TargetPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TargetPosition' from this record model
        """
        return self.get_field_value(self.TARGETPOSITION__FIELD_NAME.field_name)

    def set_TargetTank_field(self, value: Optional[str]):
        """
        Set data field with field name 'TargetTank' on this record model
        """
        self.set_field_value(self.TARGETTANK__FIELD_NAME.field_name, value)

    def get_TargetTank_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TargetTank' from this record model
        """
        return self.get_field_value(self.TARGETTANK__FIELD_NAME.field_name)

    def set_TargetVolume_field(self, value: Optional[float]):
        """
        Set data field with field name 'TargetVolume' on this record model
        """
        self.set_field_value(self.TARGETVOLUME__FIELD_NAME.field_name, value)

    def get_TargetVolume_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TargetVolume' from this record model
        """
        return self.get_field_value(self.TARGETVOLUME__FIELD_NAME.field_name)

    def set_TargetVolumeRequired_field(self, value: Optional[float]):
        """
        Set data field with field name 'TargetVolumeRequired' on this record model
        """
        self.set_field_value(self.TARGETVOLUMEREQUIRED__FIELD_NAME.field_name, value)

    def get_TargetVolumeRequired_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TargetVolumeRequired' from this record model
        """
        return self.get_field_value(self.TARGETVOLUMEREQUIRED__FIELD_NAME.field_name)

    def set_TotalProteinVariable_field(self, value: Optional[float]):
        """
        Set data field with field name 'TotalProteinVariable' on this record model
        """
        self.set_field_value(self.TOTALPROTEINVARIABLE__FIELD_NAME.field_name, value)

    def get_TotalProteinVariable_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TotalProteinVariable' from this record model
        """
        return self.get_field_value(self.TOTALPROTEINVARIABLE__FIELD_NAME.field_name)

    def set_TransformationReagent_field(self, value: Optional[str]):
        """
        Set data field with field name 'TransformationReagent' on this record model
        """
        self.set_field_value(self.TRANSFORMATIONREAGENT__FIELD_NAME.field_name, value)

    def get_TransformationReagent_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TransformationReagent' from this record model
        """
        return self.get_field_value(self.TRANSFORMATIONREAGENT__FIELD_NAME.field_name)

    def set_Tumor2_field(self, value: Optional[float]):
        """
        Set data field with field name 'Tumor2' on this record model
        """
        self.set_field_value(self.TUMOR2__FIELD_NAME.field_name, value)

    def get_Tumor2_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Tumor2' from this record model
        """
        return self.get_field_value(self.TUMOR2__FIELD_NAME.field_name)

    def set_UpperCi95_field(self, value: Optional[float]):
        """
        Set data field with field name 'UpperCi95' on this record model
        """
        self.set_field_value(self.UPPERCI95__FIELD_NAME.field_name, value)

    def get_UpperCi95_field(self) -> Optional[float]:
        """
        Get data field value with field name 'UpperCi95' from this record model
        """
        return self.get_field_value(self.UPPERCI95__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_VicCt_field(self, value: Optional[float]):
        """
        Set data field with field name 'VicCt' on this record model
        """
        self.set_field_value(self.VICCT__FIELD_NAME.field_name, value)

    def get_VicCt_field(self) -> Optional[float]:
        """
        Get data field value with field name 'VicCt' from this record model
        """
        return self.get_field_value(self.VICCT__FIELD_NAME.field_name)

    def set_WellLocation_field(self, value: Optional[str]):
        """
        Set data field with field name 'WellLocation' on this record model
        """
        self.set_field_value(self.WELLLOCATION__FIELD_NAME.field_name, value)

    def get_WellLocation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'WellLocation' from this record model
        """
        return self.get_field_value(self.WELLLOCATION__FIELD_NAME.field_name)

    def set_analyte2_field(self, value: Optional[str]):
        """
        Set data field with field name 'analyte2' on this record model
        """
        self.set_field_value(self.ANALYTE2__FIELD_NAME.field_name, value)

    def get_analyte2_field(self) -> Optional[str]:
        """
        Get data field value with field name 'analyte2' from this record model
        """
        return self.get_field_value(self.ANALYTE2__FIELD_NAME.field_name)

    def set_avgreadings_field(self, value: Optional[float]):
        """
        Set data field with field name 'avgreadings' on this record model
        """
        self.set_field_value(self.AVGREADINGS__FIELD_NAME.field_name, value)

    def get_avgreadings_field(self) -> Optional[float]:
        """
        Get data field value with field name 'avgreadings' from this record model
        """
        return self.get_field_value(self.AVGREADINGS__FIELD_NAME.field_name)

    def set_reading_field(self, value: Optional[float]):
        """
        Set data field with field name 'reading' on this record model
        """
        self.set_field_value(self.READING__FIELD_NAME.field_name, value)

    def get_reading_field(self) -> Optional[float]:
        """
        Get data field value with field name 'reading' from this record model
        """
        return self.get_field_value(self.READING__FIELD_NAME.field_name)

    def set_reading22_field(self, value: Optional[float]):
        """
        Set data field with field name 'reading22' on this record model
        """
        self.set_field_value(self.READING22__FIELD_NAME.field_name, value)

    def get_reading22_field(self) -> Optional[float]:
        """
        Get data field value with field name 'reading22' from this record model
        """
        return self.get_field_value(self.READING22__FIELD_NAME.field_name)


class ELNTextEntryDetailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ELNTextEntryDetail
    Data Type Display Name: ELN Text Entry Detail (ELN Text Entry Details)
    Fields: FilePath, CreatedBy, VeloxCurrentVersion, DataRecordName, VeloxLastModifiedDate, TextField, VeloxLastModifiedBy, DateCreated
    This data type is used to store the latest PDF file that has been generated from a given notebook.
    """
    DATA_TYPE_NAME: Final[str] = 'ELNTextEntryDetail'
    DISPLAY_NAME: Final[str] = "ELN Text Entry Detail"
    PLURAL_DISPLAY_NAME: Final[str] = "ELN Text Entry Details"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    TEXTFIELD__FIELD_NAME: Final[WrapperField] = WrapperField("TextField", FieldType.STRING, display_name="Text Field")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_TextField_field(self, value: Optional[str]):
        """
        Set data field with field name 'TextField' on this record model
        """
        self.set_field_value(self.TEXTFIELD__FIELD_NAME.field_name, value)

    def get_TextField_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TextField' from this record model
        """
        return self.get_field_value(self.TEXTFIELD__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class EmailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Email
    Data Type Display Name: Email (Emails)
    Fields: CreatedBy, CarbonCopy, SentDate, DateCreated, MultiParentLink230, Subject, SentFrom, DataRecordName, AddressedTo, VeloxLastModifiedDate, VeloxLastModifiedBy, Body
    """
    DATA_TYPE_NAME: Final[str] = 'Email'
    DISPLAY_NAME: Final[str] = "Email"
    PLURAL_DISPLAY_NAME: Final[str] = "Emails"
    ADDRESSEDTO__FIELD_NAME: Final[WrapperField] = WrapperField("AddressedTo", FieldType.STRING, display_name="To")
    BODY__FIELD_NAME: Final[WrapperField] = WrapperField("Body", FieldType.STRING, display_name="Body")
    CARBONCOPY__FIELD_NAME: Final[WrapperField] = WrapperField("CarbonCopy", FieldType.STRING, display_name="CC")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    MULTIPARENTLINK230__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink230", FieldType.MULTIPARENTLINK, display_name="Linked Study")
    SENTDATE__FIELD_NAME: Final[WrapperField] = WrapperField("SentDate", FieldType.DATE, display_name="Date Sent")
    SENTFROM__FIELD_NAME: Final[WrapperField] = WrapperField("SentFrom", FieldType.STRING, display_name="From")
    SUBJECT__FIELD_NAME: Final[WrapperField] = WrapperField("Subject", FieldType.STRING, display_name="Subject")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AddressedTo_field(self, value: Optional[str]):
        """
        Set data field with field name 'AddressedTo' on this record model
        """
        self.set_field_value(self.ADDRESSEDTO__FIELD_NAME.field_name, value)

    def get_AddressedTo_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AddressedTo' from this record model
        """
        return self.get_field_value(self.ADDRESSEDTO__FIELD_NAME.field_name)

    def set_Body_field(self, value: Optional[str]):
        """
        Set data field with field name 'Body' on this record model
        """
        self.set_field_value(self.BODY__FIELD_NAME.field_name, value)

    def get_Body_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Body' from this record model
        """
        return self.get_field_value(self.BODY__FIELD_NAME.field_name)

    def set_CarbonCopy_field(self, value: Optional[str]):
        """
        Set data field with field name 'CarbonCopy' on this record model
        """
        self.set_field_value(self.CARBONCOPY__FIELD_NAME.field_name, value)

    def get_CarbonCopy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CarbonCopy' from this record model
        """
        return self.get_field_value(self.CARBONCOPY__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_SentDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'SentDate' on this record model
        """
        self.set_field_value(self.SENTDATE__FIELD_NAME.field_name, value)

    def get_SentDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SentDate' from this record model
        """
        return self.get_field_value(self.SENTDATE__FIELD_NAME.field_name)

    def set_SentFrom_field(self, value: Optional[str]):
        """
        Set data field with field name 'SentFrom' on this record model
        """
        self.set_field_value(self.SENTFROM__FIELD_NAME.field_name, value)

    def get_SentFrom_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SentFrom' from this record model
        """
        return self.get_field_value(self.SENTFROM__FIELD_NAME.field_name)

    def set_Subject_field(self, value: Optional[str]):
        """
        Set data field with field name 'Subject' on this record model
        """
        self.set_field_value(self.SUBJECT__FIELD_NAME.field_name, value)

    def get_Subject_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Subject' from this record model
        """
        return self.get_field_value(self.SUBJECT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class EnbAttachmentThumbnailModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type EnbAttachmentThumbnail
    Data Type Display Name: E-Notebook Attachment Thumbnail (E-Notebook Attachment Thumbnails)
    Fields: ResolutionWidth, DateCreated, SinglePage, PageNumber, VeloxLastModifiedBy, FilePath, VeloxCurrentVersion, CreatedBy, ResolutionHeight, DataRecordName, VeloxLastModifiedDate
    An attachment that stores a cached thumbnail of a page from a document attached to an Experiment entry.
    """
    DATA_TYPE_NAME: Final[str] = 'EnbAttachmentThumbnail'
    DISPLAY_NAME: Final[str] = "E-Notebook Attachment Thumbnail"
    PLURAL_DISPLAY_NAME: Final[str] = "E-Notebook Attachment Thumbnails"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    PAGENUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("PageNumber", FieldType.INTEGER, display_name="Page Number")
    RESOLUTIONHEIGHT__FIELD_NAME: Final[WrapperField] = WrapperField("ResolutionHeight", FieldType.INTEGER, display_name="Resolution Height")
    RESOLUTIONWIDTH__FIELD_NAME: Final[WrapperField] = WrapperField("ResolutionWidth", FieldType.INTEGER, display_name="Resolution Width")
    SINGLEPAGE__FIELD_NAME: Final[WrapperField] = WrapperField("SinglePage", FieldType.BOOLEAN, display_name="Single Page")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_PageNumber_field(self, value: Optional[int]):
        """
        Set data field with field name 'PageNumber' on this record model
        """
        self.set_field_value(self.PAGENUMBER__FIELD_NAME.field_name, value)

    def get_PageNumber_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PageNumber' from this record model
        """
        return self.get_field_value(self.PAGENUMBER__FIELD_NAME.field_name)

    def set_ResolutionHeight_field(self, value: Optional[int]):
        """
        Set data field with field name 'ResolutionHeight' on this record model
        """
        self.set_field_value(self.RESOLUTIONHEIGHT__FIELD_NAME.field_name, value)

    def get_ResolutionHeight_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ResolutionHeight' from this record model
        """
        return self.get_field_value(self.RESOLUTIONHEIGHT__FIELD_NAME.field_name)

    def set_ResolutionWidth_field(self, value: Optional[int]):
        """
        Set data field with field name 'ResolutionWidth' on this record model
        """
        self.set_field_value(self.RESOLUTIONWIDTH__FIELD_NAME.field_name, value)

    def get_ResolutionWidth_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ResolutionWidth' from this record model
        """
        return self.get_field_value(self.RESOLUTIONWIDTH__FIELD_NAME.field_name)

    def set_SinglePage_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SinglePage' on this record model
        """
        self.set_field_value(self.SINGLEPAGE__FIELD_NAME.field_name, value)

    def get_SinglePage_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SinglePage' from this record model
        """
        return self.get_field_value(self.SINGLEPAGE__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class EnzymeModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Enzyme
    Data Type Display Name: Enzyme (Enzymes)
    Fields: CreatedBy, PartNumber, ConsumableType, DateCreated, Isoschizomers, Vendor, Neoschizomers, DataRecordName, ExpirationDate, EnzymeType, VeloxLastModifiedDate, VeloxLastModifiedBy, ConsumableName, DateOfPurchase, LotNumber, CuttingPattern
    """
    DATA_TYPE_NAME: Final[str] = 'Enzyme'
    DISPLAY_NAME: Final[str] = "Enzyme"
    PLURAL_DISPLAY_NAME: Final[str] = "Enzymes"
    CONSUMABLENAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableName", FieldType.STRING, display_name="Enzyme ID")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Enzyme Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    CUTTINGPATTERN__FIELD_NAME: Final[WrapperField] = WrapperField("CuttingPattern", FieldType.STRING, display_name="Cutting Pattern")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DATEOFPURCHASE__FIELD_NAME: Final[WrapperField] = WrapperField("DateOfPurchase", FieldType.DATE, display_name="Date Of Purchase")
    ENZYMETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("EnzymeType", FieldType.PICKLIST, display_name="Enzyme Type")
    EXPIRATIONDATE__FIELD_NAME: Final[WrapperField] = WrapperField("ExpirationDate", FieldType.DATE, display_name="Expiration Date")
    ISOSCHIZOMERS__FIELD_NAME: Final[WrapperField] = WrapperField("Isoschizomers", FieldType.STRING, display_name="Isoschizomers")
    LOTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("LotNumber", FieldType.STRING, display_name="Lot Number")
    NEOSCHIZOMERS__FIELD_NAME: Final[WrapperField] = WrapperField("Neoschizomers", FieldType.STRING, display_name="Neoschizomers")
    PARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("PartNumber", FieldType.STRING, display_name="Part Number")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VENDOR__FIELD_NAME: Final[WrapperField] = WrapperField("Vendor", FieldType.SELECTION, display_name="Vendor")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_CuttingPattern_field(self, value: Optional[str]):
        """
        Set data field with field name 'CuttingPattern' on this record model
        """
        self.set_field_value(self.CUTTINGPATTERN__FIELD_NAME.field_name, value)

    def get_CuttingPattern_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CuttingPattern' from this record model
        """
        return self.get_field_value(self.CUTTINGPATTERN__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DateOfPurchase_field(self, value: Optional[int]):
        """
        Set data field with field name 'DateOfPurchase' on this record model
        """
        self.set_field_value(self.DATEOFPURCHASE__FIELD_NAME.field_name, value)

    def get_DateOfPurchase_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateOfPurchase' from this record model
        """
        return self.get_field_value(self.DATEOFPURCHASE__FIELD_NAME.field_name)

    def set_EnzymeType_field(self, value: Optional[str]):
        """
        Set data field with field name 'EnzymeType' on this record model
        """
        self.set_field_value(self.ENZYMETYPE__FIELD_NAME.field_name, value)

    def get_EnzymeType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EnzymeType' from this record model
        """
        return self.get_field_value(self.ENZYMETYPE__FIELD_NAME.field_name)

    def set_ExpirationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpirationDate' on this record model
        """
        self.set_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name, value)

    def get_ExpirationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpirationDate' from this record model
        """
        return self.get_field_value(self.EXPIRATIONDATE__FIELD_NAME.field_name)

    def set_Isoschizomers_field(self, value: Optional[str]):
        """
        Set data field with field name 'Isoschizomers' on this record model
        """
        self.set_field_value(self.ISOSCHIZOMERS__FIELD_NAME.field_name, value)

    def get_Isoschizomers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Isoschizomers' from this record model
        """
        return self.get_field_value(self.ISOSCHIZOMERS__FIELD_NAME.field_name)

    def set_LotNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'LotNumber' on this record model
        """
        self.set_field_value(self.LOTNUMBER__FIELD_NAME.field_name, value)

    def get_LotNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LotNumber' from this record model
        """
        return self.get_field_value(self.LOTNUMBER__FIELD_NAME.field_name)

    def set_Neoschizomers_field(self, value: Optional[str]):
        """
        Set data field with field name 'Neoschizomers' on this record model
        """
        self.set_field_value(self.NEOSCHIZOMERS__FIELD_NAME.field_name, value)

    def get_Neoschizomers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Neoschizomers' from this record model
        """
        return self.get_field_value(self.NEOSCHIZOMERS__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class EnzymePartModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type EnzymePart
    Data Type Display Name: Enzyme Part (Enzyme Parts)
    Fields: RestrictionEnzymePart.DateCreated, RecognitionSequence, PartNumber, ConsumableType, RestrictionEnzymePart.CutPos1s, RestrictionEnzymePart.RecognitionSequence, DateCreated, RestrictionEnzymePart.NonDeg, RestrictionEnzymePart.VeloxLastModifiedDate, QuantityPerItem, ReactionBuffer, Neoschizomers, ReorderLevelQuantity, RestrictionEnzymePart.CutPos2a, RestrictionEnzymePart.DataRecordName, VeloxLastModifiedBy, IsDefault, RestrictionEnzymePart.VeloxLastModifiedBy, RestrictionEnzymePart.Neoschizomers, CreatedBy, RestrictionEnzymePart.CutPos2s, RestrictionEnzymePart.Isoschizomers, Isoschizomers, Vendor, QuantityOnHand, Units, RestrictionEnzymePart.RelatedRecord115, DataRecordName, EnzymeType, RestrictionEnzymePart.CutPos1a, IsGoldenGate, VeloxLastModifiedDate, RestrictionEnzymePart.CreatedBy, ConsumableName, RestrictionEnzymePart.RecordId, RestrictionEnzymePart.SixPlus
    """
    DATA_TYPE_NAME: Final[str] = 'EnzymePart'
    DISPLAY_NAME: Final[str] = "Enzyme Part"
    PLURAL_DISPLAY_NAME: Final[str] = "Enzyme Parts"
    CONSUMABLENAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableName", FieldType.AUTO_ACCESSION, display_name="Enzyme ID")
    CONSUMABLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableType", FieldType.SELECTION, display_name="Enzyme Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    ENZYMETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("EnzymeType", FieldType.PICKLIST, display_name="Enzyme Type")
    ISDEFAULT__FIELD_NAME: Final[WrapperField] = WrapperField("IsDefault", FieldType.BOOLEAN, display_name="Is Default")
    ISGOLDENGATE__FIELD_NAME: Final[WrapperField] = WrapperField("IsGoldenGate", FieldType.BOOLEAN, display_name="Is Golden Gate")
    ISOSCHIZOMERS__FIELD_NAME: Final[WrapperField] = WrapperField("Isoschizomers", FieldType.STRING, display_name="Isoschizomers")
    NEOSCHIZOMERS__FIELD_NAME: Final[WrapperField] = WrapperField("Neoschizomers", FieldType.STRING, display_name="Neoschizomers")
    PARTNUMBER__FIELD_NAME: Final[WrapperField] = WrapperField("PartNumber", FieldType.STRING, display_name="Part Number")
    QUANTITYONHAND__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityOnHand", FieldType.DOUBLE, display_name="Quantity / Volume On Hand")
    QUANTITYPERITEM__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityPerItem", FieldType.DOUBLE, display_name="Quantity / Volume Per Item")
    REACTIONBUFFER__FIELD_NAME: Final[WrapperField] = WrapperField("ReactionBuffer", FieldType.STRING, display_name="Reaction Buffer")
    RECOGNITIONSEQUENCE__FIELD_NAME: Final[WrapperField] = WrapperField("RecognitionSequence", FieldType.STRING, display_name="Recognition Sequence")
    REORDERLEVELQUANTITY__FIELD_NAME: Final[WrapperField] = WrapperField("ReorderLevelQuantity", FieldType.DOUBLE, display_name="Reorder Level Quantity")
    RESTRICTIONENZYMEPART_EXT_CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.CreatedBy", FieldType.STRING, display_name="Created By")
    RESTRICTIONENZYMEPART_EXT_CUTPOS1A__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.CutPos1a", FieldType.INTEGER, display_name="Cut Position 1A")
    RESTRICTIONENZYMEPART_EXT_CUTPOS1S__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.CutPos1s", FieldType.INTEGER, display_name="Cut Position 1S")
    RESTRICTIONENZYMEPART_EXT_CUTPOS2A__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.CutPos2a", FieldType.INTEGER, display_name="Cut Position 2A")
    RESTRICTIONENZYMEPART_EXT_CUTPOS2S__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.CutPos2s", FieldType.INTEGER, display_name="Cut Position 2S")
    RESTRICTIONENZYMEPART_EXT_DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    RESTRICTIONENZYMEPART_EXT_DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.DateCreated", FieldType.DATE, display_name="Date Created")
    RESTRICTIONENZYMEPART_EXT_ISOSCHIZOMERS__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.Isoschizomers", FieldType.STRING, display_name="Isoschizomers")
    RESTRICTIONENZYMEPART_EXT_NEOSCHIZOMERS__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.Neoschizomers", FieldType.STRING, display_name="Neoschizomers")
    RESTRICTIONENZYMEPART_EXT_NONDEG__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.NonDeg", FieldType.BOOLEAN, display_name="Non Deg")
    RESTRICTIONENZYMEPART_EXT_RECOGNITIONSEQUENCE__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.RecognitionSequence", FieldType.STRING, display_name="Recognition Sequence")
    RESTRICTIONENZYMEPART_EXT_RECORDID__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.RecordId", FieldType.LONG, display_name="Record ID")
    RESTRICTIONENZYMEPART_EXT_RELATEDRECORD115__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.RelatedRecord115", FieldType.PARENTLINK, display_name="Linked Enzyme Part")
    RESTRICTIONENZYMEPART_EXT_SIXPLUS__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.SixPlus", FieldType.BOOLEAN, display_name="Six Plus")
    RESTRICTIONENZYMEPART_EXT_VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    RESTRICTIONENZYMEPART_EXT_VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictionEnzymePart.VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    UNITS__FIELD_NAME: Final[WrapperField] = WrapperField("Units", FieldType.PICKLIST, display_name="Units")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VENDOR__FIELD_NAME: Final[WrapperField] = WrapperField("Vendor", FieldType.SELECTION, display_name="Vendor")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ConsumableName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableName' on this record model
        """
        self.set_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name, value)

    def get_ConsumableName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableName' from this record model
        """
        return self.get_field_value(self.CONSUMABLENAME__FIELD_NAME.field_name)

    def set_ConsumableType_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableType' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name, value)

    def get_ConsumableType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableType' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPE__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EnzymeType_field(self, value: Optional[str]):
        """
        Set data field with field name 'EnzymeType' on this record model
        """
        self.set_field_value(self.ENZYMETYPE__FIELD_NAME.field_name, value)

    def get_EnzymeType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EnzymeType' from this record model
        """
        return self.get_field_value(self.ENZYMETYPE__FIELD_NAME.field_name)

    def set_IsDefault_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsDefault' on this record model
        """
        self.set_field_value(self.ISDEFAULT__FIELD_NAME.field_name, value)

    def get_IsDefault_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsDefault' from this record model
        """
        return self.get_field_value(self.ISDEFAULT__FIELD_NAME.field_name)

    def set_IsGoldenGate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsGoldenGate' on this record model
        """
        self.set_field_value(self.ISGOLDENGATE__FIELD_NAME.field_name, value)

    def get_IsGoldenGate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsGoldenGate' from this record model
        """
        return self.get_field_value(self.ISGOLDENGATE__FIELD_NAME.field_name)

    def set_Isoschizomers_field(self, value: Optional[str]):
        """
        Set data field with field name 'Isoschizomers' on this record model
        """
        self.set_field_value(self.ISOSCHIZOMERS__FIELD_NAME.field_name, value)

    def get_Isoschizomers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Isoschizomers' from this record model
        """
        return self.get_field_value(self.ISOSCHIZOMERS__FIELD_NAME.field_name)

    def set_Neoschizomers_field(self, value: Optional[str]):
        """
        Set data field with field name 'Neoschizomers' on this record model
        """
        self.set_field_value(self.NEOSCHIZOMERS__FIELD_NAME.field_name, value)

    def get_Neoschizomers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Neoschizomers' from this record model
        """
        return self.get_field_value(self.NEOSCHIZOMERS__FIELD_NAME.field_name)

    def set_PartNumber_field(self, value: Optional[str]):
        """
        Set data field with field name 'PartNumber' on this record model
        """
        self.set_field_value(self.PARTNUMBER__FIELD_NAME.field_name, value)

    def get_PartNumber_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PartNumber' from this record model
        """
        return self.get_field_value(self.PARTNUMBER__FIELD_NAME.field_name)

    def set_QuantityOnHand_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityOnHand' on this record model
        """
        self.set_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name, value)

    def get_QuantityOnHand_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityOnHand' from this record model
        """
        return self.get_field_value(self.QUANTITYONHAND__FIELD_NAME.field_name)

    def set_QuantityPerItem_field(self, value: Optional[float]):
        """
        Set data field with field name 'QuantityPerItem' on this record model
        """
        self.set_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name, value)

    def get_QuantityPerItem_field(self) -> Optional[float]:
        """
        Get data field value with field name 'QuantityPerItem' from this record model
        """
        return self.get_field_value(self.QUANTITYPERITEM__FIELD_NAME.field_name)

    def set_ReactionBuffer_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReactionBuffer' on this record model
        """
        self.set_field_value(self.REACTIONBUFFER__FIELD_NAME.field_name, value)

    def get_ReactionBuffer_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReactionBuffer' from this record model
        """
        return self.get_field_value(self.REACTIONBUFFER__FIELD_NAME.field_name)

    def set_RecognitionSequence_field(self, value: Optional[str]):
        """
        Set data field with field name 'RecognitionSequence' on this record model
        """
        self.set_field_value(self.RECOGNITIONSEQUENCE__FIELD_NAME.field_name, value)

    def get_RecognitionSequence_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RecognitionSequence' from this record model
        """
        return self.get_field_value(self.RECOGNITIONSEQUENCE__FIELD_NAME.field_name)

    def set_ReorderLevelQuantity_field(self, value: Optional[float]):
        """
        Set data field with field name 'ReorderLevelQuantity' on this record model
        """
        self.set_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name, value)

    def get_ReorderLevelQuantity_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ReorderLevelQuantity' from this record model
        """
        return self.get_field_value(self.REORDERLEVELQUANTITY__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartCreatedBy_field(self, value: Optional[str]):
        """
        Set data field with field name 'RestrictionEnzymePart.CreatedBy' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_CREATEDBY__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartCreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RestrictionEnzymePart.CreatedBy' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_CREATEDBY__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartCutPos1a_field(self, value: Optional[int]):
        """
        Set data field with field name 'RestrictionEnzymePart.CutPos1a' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_CUTPOS1A__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartCutPos1a_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RestrictionEnzymePart.CutPos1a' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_CUTPOS1A__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartCutPos1s_field(self, value: Optional[int]):
        """
        Set data field with field name 'RestrictionEnzymePart.CutPos1s' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_CUTPOS1S__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartCutPos1s_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RestrictionEnzymePart.CutPos1s' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_CUTPOS1S__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartCutPos2a_field(self, value: Optional[int]):
        """
        Set data field with field name 'RestrictionEnzymePart.CutPos2a' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_CUTPOS2A__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartCutPos2a_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RestrictionEnzymePart.CutPos2a' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_CUTPOS2A__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartCutPos2s_field(self, value: Optional[int]):
        """
        Set data field with field name 'RestrictionEnzymePart.CutPos2s' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_CUTPOS2S__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartCutPos2s_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RestrictionEnzymePart.CutPos2s' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_CUTPOS2S__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartDateCreated_field(self, value: Optional[int]):
        """
        Set data field with field name 'RestrictionEnzymePart.DateCreated' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_DATECREATED__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartDateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RestrictionEnzymePart.DateCreated' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_DATECREATED__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartIsoschizomers_field(self, value: Optional[str]):
        """
        Set data field with field name 'RestrictionEnzymePart.Isoschizomers' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_ISOSCHIZOMERS__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartIsoschizomers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RestrictionEnzymePart.Isoschizomers' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_ISOSCHIZOMERS__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartNeoschizomers_field(self, value: Optional[str]):
        """
        Set data field with field name 'RestrictionEnzymePart.Neoschizomers' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_NEOSCHIZOMERS__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartNeoschizomers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RestrictionEnzymePart.Neoschizomers' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_NEOSCHIZOMERS__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartNonDeg_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RestrictionEnzymePart.NonDeg' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_NONDEG__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartNonDeg_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RestrictionEnzymePart.NonDeg' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_NONDEG__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartRecognitionSequence_field(self, value: Optional[str]):
        """
        Set data field with field name 'RestrictionEnzymePart.RecognitionSequence' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_RECOGNITIONSEQUENCE__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartRecognitionSequence_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RestrictionEnzymePart.RecognitionSequence' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_RECOGNITIONSEQUENCE__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'RestrictionEnzymePart.RecordId' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_RECORDID__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RestrictionEnzymePart.RecordId' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_RECORDID__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartSixPlus_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RestrictionEnzymePart.SixPlus' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_SIXPLUS__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartSixPlus_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RestrictionEnzymePart.SixPlus' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_SIXPLUS__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartVeloxLastModifiedBy_field(self, value: Optional[str]):
        """
        Set data field with field name 'RestrictionEnzymePart.VeloxLastModifiedBy' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_VELOXLASTMODIFIEDBY__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartVeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RestrictionEnzymePart.VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def set_RestrictionEnzymePartVeloxLastModifiedDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'RestrictionEnzymePart.VeloxLastModifiedDate' on this record model
        """
        self.set_field_value(self.RESTRICTIONENZYMEPART_EXT_VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name, value)

    def get_RestrictionEnzymePartVeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RestrictionEnzymePart.VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.RESTRICTIONENZYMEPART_EXT_VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Units_field(self, value: Optional[str]):
        """
        Set data field with field name 'Units' on this record model
        """
        self.set_field_value(self.UNITS__FIELD_NAME.field_name, value)

    def get_Units_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Units' from this record model
        """
        return self.get_field_value(self.UNITS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_Vendor_field(self, value: Optional[str]):
        """
        Set data field with field name 'Vendor' on this record model
        """
        self.set_field_value(self.VENDOR__FIELD_NAME.field_name, value)

    def get_Vendor_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Vendor' from this record model
        """
        return self.get_field_value(self.VENDOR__FIELD_NAME.field_name)


class ErrorMetricModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ErrorMetric
    Data Type Display Name: Error Metric (Error Metrics)
    Fields: CreatedBy, LaneCol, Lane, DateCreated, PlusMinus, ColRead, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, ErrorRate
     <!-- DISPLAY IN INSTRUMENT RUN MONITOR -->
    """
    DATA_TYPE_NAME: Final[str] = 'ErrorMetric'
    DISPLAY_NAME: Final[str] = "Error Metric"
    PLURAL_DISPLAY_NAME: Final[str] = "Error Metrics"
    COLREAD__FIELD_NAME: Final[WrapperField] = WrapperField("ColRead", FieldType.STRING, display_name="Read")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    ERRORRATE__FIELD_NAME: Final[WrapperField] = WrapperField("ErrorRate", FieldType.DOUBLE, display_name="Error Rate (%)")
    LANE__FIELD_NAME: Final[WrapperField] = WrapperField("Lane", FieldType.LONG, display_name="Lane (Long Integer)")
    LANECOL__FIELD_NAME: Final[WrapperField] = WrapperField("LaneCol", FieldType.STRING, display_name="Lane")
    PLUSMINUS__FIELD_NAME: Final[WrapperField] = WrapperField("PlusMinus", FieldType.DOUBLE, display_name="+ / -")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ColRead_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColRead' on this record model
        """
        self.set_field_value(self.COLREAD__FIELD_NAME.field_name, value)

    def get_ColRead_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColRead' from this record model
        """
        return self.get_field_value(self.COLREAD__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ErrorRate_field(self, value: Optional[float]):
        """
        Set data field with field name 'ErrorRate' on this record model
        """
        self.set_field_value(self.ERRORRATE__FIELD_NAME.field_name, value)

    def get_ErrorRate_field(self) -> Optional[float]:
        """
        Get data field value with field name 'ErrorRate' from this record model
        """
        return self.get_field_value(self.ERRORRATE__FIELD_NAME.field_name)

    def set_Lane_field(self, value: Optional[int]):
        """
        Set data field with field name 'Lane' on this record model
        """
        self.set_field_value(self.LANE__FIELD_NAME.field_name, value)

    def get_Lane_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Lane' from this record model
        """
        return self.get_field_value(self.LANE__FIELD_NAME.field_name)

    def set_LaneCol_field(self, value: Optional[str]):
        """
        Set data field with field name 'LaneCol' on this record model
        """
        self.set_field_value(self.LANECOL__FIELD_NAME.field_name, value)

    def get_LaneCol_field(self) -> Optional[str]:
        """
        Get data field value with field name 'LaneCol' from this record model
        """
        return self.get_field_value(self.LANECOL__FIELD_NAME.field_name)

    def set_PlusMinus_field(self, value: Optional[float]):
        """
        Set data field with field name 'PlusMinus' on this record model
        """
        self.set_field_value(self.PLUSMINUS__FIELD_NAME.field_name, value)

    def get_PlusMinus_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PlusMinus' from this record model
        """
        return self.get_field_value(self.PLUSMINUS__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class EventModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type Event
    Data Type Display Name: Event (Event)
    Fields: UserName, CreatedBy, ReminderSent, Comments, ReminderDateTime, EventStatus, DateCreated, EventName, StartDateTime, DataRecordName, EndDateTime, VeloxLastModifiedDate, VeloxLastModifiedBy, EventDescription
    """
    DATA_TYPE_NAME: Final[str] = 'Event'
    DISPLAY_NAME: Final[str] = "Event"
    PLURAL_DISPLAY_NAME: Final[str] = "Event"
    COMMENTS__FIELD_NAME: Final[WrapperField] = WrapperField("Comments", FieldType.STRING, display_name="Comments")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    ENDDATETIME__FIELD_NAME: Final[WrapperField] = WrapperField("EndDateTime", FieldType.DATE, display_name="End Date Time")
    EVENTDESCRIPTION__FIELD_NAME: Final[WrapperField] = WrapperField("EventDescription", FieldType.STRING, display_name="Event Description")
    EVENTNAME__FIELD_NAME: Final[WrapperField] = WrapperField("EventName", FieldType.STRING, display_name="Event Name")
    EVENTSTATUS__FIELD_NAME: Final[WrapperField] = WrapperField("EventStatus", FieldType.PICKLIST, display_name="Event Status")
    REMINDERDATETIME__FIELD_NAME: Final[WrapperField] = WrapperField("ReminderDateTime", FieldType.DATE, display_name="Reminder Date Time")
    REMINDERSENT__FIELD_NAME: Final[WrapperField] = WrapperField("ReminderSent", FieldType.BOOLEAN, display_name="Reminder Sent")
    STARTDATETIME__FIELD_NAME: Final[WrapperField] = WrapperField("StartDateTime", FieldType.DATE, display_name="Start Date Time")
    USERNAME__FIELD_NAME: Final[WrapperField] = WrapperField("UserName", FieldType.SELECTION, display_name="User Name")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_Comments_field(self, value: Optional[str]):
        """
        Set data field with field name 'Comments' on this record model
        """
        self.set_field_value(self.COMMENTS__FIELD_NAME.field_name, value)

    def get_Comments_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Comments' from this record model
        """
        return self.get_field_value(self.COMMENTS__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EndDateTime_field(self, value: Optional[int]):
        """
        Set data field with field name 'EndDateTime' on this record model
        """
        self.set_field_value(self.ENDDATETIME__FIELD_NAME.field_name, value)

    def get_EndDateTime_field(self) -> Optional[int]:
        """
        Get data field value with field name 'EndDateTime' from this record model
        """
        return self.get_field_value(self.ENDDATETIME__FIELD_NAME.field_name)

    def set_EventDescription_field(self, value: Optional[str]):
        """
        Set data field with field name 'EventDescription' on this record model
        """
        self.set_field_value(self.EVENTDESCRIPTION__FIELD_NAME.field_name, value)

    def get_EventDescription_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EventDescription' from this record model
        """
        return self.get_field_value(self.EVENTDESCRIPTION__FIELD_NAME.field_name)

    def set_EventName_field(self, value: Optional[str]):
        """
        Set data field with field name 'EventName' on this record model
        """
        self.set_field_value(self.EVENTNAME__FIELD_NAME.field_name, value)

    def get_EventName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EventName' from this record model
        """
        return self.get_field_value(self.EVENTNAME__FIELD_NAME.field_name)

    def set_EventStatus_field(self, value: Optional[str]):
        """
        Set data field with field name 'EventStatus' on this record model
        """
        self.set_field_value(self.EVENTSTATUS__FIELD_NAME.field_name, value)

    def get_EventStatus_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EventStatus' from this record model
        """
        return self.get_field_value(self.EVENTSTATUS__FIELD_NAME.field_name)

    def set_ReminderDateTime_field(self, value: Optional[int]):
        """
        Set data field with field name 'ReminderDateTime' on this record model
        """
        self.set_field_value(self.REMINDERDATETIME__FIELD_NAME.field_name, value)

    def get_ReminderDateTime_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ReminderDateTime' from this record model
        """
        return self.get_field_value(self.REMINDERDATETIME__FIELD_NAME.field_name)

    def set_ReminderSent_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ReminderSent' on this record model
        """
        self.set_field_value(self.REMINDERSENT__FIELD_NAME.field_name, value)

    def get_ReminderSent_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ReminderSent' from this record model
        """
        return self.get_field_value(self.REMINDERSENT__FIELD_NAME.field_name)

    def set_StartDateTime_field(self, value: Optional[int]):
        """
        Set data field with field name 'StartDateTime' on this record model
        """
        self.set_field_value(self.STARTDATETIME__FIELD_NAME.field_name, value)

    def get_StartDateTime_field(self) -> Optional[int]:
        """
        Get data field value with field name 'StartDateTime' from this record model
        """
        return self.get_field_value(self.STARTDATETIME__FIELD_NAME.field_name)

    def set_UserName_field(self, value: Optional[str]):
        """
        Set data field with field name 'UserName' on this record model
        """
        self.set_field_value(self.USERNAME__FIELD_NAME.field_name, value)

    def get_UserName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'UserName' from this record model
        """
        return self.get_field_value(self.USERNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ExemplarConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExemplarConfig
    Data Type Display Name: Sapio Configurations (Sapio Configurations)
    Fields: QCMailingList, SaasMaxNumOfSamplesPerTrans, EnableElnRoleCandidates, WitnessVisibleRoleType, ImportExportSystemConfigsText, ELNImportSamplesOverride, NotifyMaintTechnicians, ConsumableTypeMaxTemp, PlasmidDataType, ReviewerVisibleRoleType, Bowtie2ExecPath, AddConsumablesToExperiments, OverrideGroups, MmSampleFieldsToDisplay, InstrumentForceIdvRegistration, EsigRequireAllAuthor, PrintConsumableBarcode, DefaultELNExperimentGroupRoles, MmForceIdvRegistration, CreatedBy, EnableBaselineSampleRec, AdditionalNotificationEmails, EnforceExpiration, ExportFullConfigButton, AdditionalQCMailingList, EsigRequireAllAuthorHelp, AlwaysLaunchInstMaintWorkflow, EsignEmailOwnerNotebookUnlock, NotificationUsers, AuthenticationRequired, SampleReceivingEmails, ConsumableTrackingAttribute, Bowtie2GRChIndexPrefix, RecordReportDataTypeList, RecordReportAccessGroups, ENotebookSignoffGroupsHelp, SamtoolsExecPath, EnforceSufficientQuantity, RTransExecPath, CreateInWorkflow, TLSEnabled, ExportExemplarConfigButton, ActiveNotebooksInWorkQueue, S3SecretAcessKey, SmtpUsername, GenerateItemBarcode, VeloxLastModifiedBy, EsignSendEmailOnEntryUnlock, AssignRoleNotificationButton, ExportStaticConfigurations, AddAllUserAsCandidateHelp, Delimiter, DefaultELNExperimentRolesHelp, EnforceConsumableDirectory, ELNCreateSmplExtentionMultiSel, BowtieIndexDirectory, EnableMultiTenantDashboards, AssignToProcessUserGroupList, SecureSocketLayer, SDMSRootPath, CanModifyExistingVSMTPItems, NewConsumableDirName, IndexedStorageType, AdditionalInstMaintEmails, RequireESignature, Email, DefineConsumableDirectories, ExportSelectedConfigButton, Port, RecordStorageEvents, NativeRExecPath, ImportExemplarConfigButton, EsignSendEmailOnDecision, SMTPServer, DefaultELNExperimentRoles, MatManEnableFeatureExt, MultiLayerPlatePoolIfSameType, ReqPortalManifestFieldNames, VerificationTypes, WriteQCInputFileToUser, AdHocExperimentsInheritAccess, CoolingStorageUnitTypes, BroadcastMaintAlert, SendTestMail, ImportBackupConfigButton, ApproverVisibleRoleType, RestrictAccessByLocation, BowtieGrCh38RefIndexPrefix, ImportSystemConfigButton, DataRecordName, PlateDesignerPrimaryTypes, PreNotificationInterval, ImportExportExemplarConfigText, StorageUnitViewerFillByConfig, EnableDND, ExperimentBannerExpFields, SampleTypeMaximumTemperature, UseRequestDefaultLayout, QuantityTracking, SampleReceivingUserMenu, DateCreated, SaasMaxSamples, SystemPassword, AddAllUserAsCandidate, EnumerateStorage, ConsumableDirectories, SaasMode, NativePyExecPath, TemperatureEnforcement, S3AccessKeyId, TLSRequired, BroadcastMaintUsers, ImportBaseLineDescription, DefineConsumableDataTypes, ConsumableDataTypes, VeloxLastModifiedDate, EsignSendEmailOnNotebookUnlock, ConfigureInstrumentFileField, ENotebookSignoffGroups, ExperimentBannerParentFields, GRChFASTAPath, EnableAutoLotPopulation
    """
    DATA_TYPE_NAME: Final[str] = 'ExemplarConfig'
    DISPLAY_NAME: Final[str] = "Sapio Configurations"
    PLURAL_DISPLAY_NAME: Final[str] = "Sapio Configurations"
    ACTIVENOTEBOOKSINWORKQUEUE__FIELD_NAME: Final[WrapperField] = WrapperField("ActiveNotebooksInWorkQueue", FieldType.BOOLEAN, display_name="Show Active Notebooks Tab In Work Queue")
    ADHOCEXPERIMENTSINHERITACCESS__FIELD_NAME: Final[WrapperField] = WrapperField("AdHocExperimentsInheritAccess", FieldType.BOOLEAN, display_name="Ad-Hoc Experiments Inherit Access Rights from Parent Record (i.e. Project, Study, etc.)?")
    ADDALLUSERASCANDIDATE__FIELD_NAME: Final[WrapperField] = WrapperField("AddAllUserAsCandidate", FieldType.BOOLEAN, display_name="Auto Assign All Candidate Roles for All Users for Experiment Locations?")
    ADDALLUSERASCANDIDATEHELP__FIELD_NAME: Final[WrapperField] = WrapperField("AddAllUserAsCandidateHelp", FieldType.STRING, display_name="Feature Explanation")
    ADDCONSUMABLESTOEXPERIMENTS__FIELD_NAME: Final[WrapperField] = WrapperField("AddConsumablesToExperiments", FieldType.BOOLEAN, display_name="Add Consumables to Experiments")
    ADDITIONALINSTMAINTEMAILS__FIELD_NAME: Final[WrapperField] = WrapperField("AdditionalInstMaintEmails", FieldType.STRING, display_name="Additional Notification Emails")
    ADDITIONALNOTIFICATIONEMAILS__FIELD_NAME: Final[WrapperField] = WrapperField("AdditionalNotificationEmails", FieldType.STRING, display_name="Additional Notification Emails")
    ADDITIONALQCMAILINGLIST__FIELD_NAME: Final[WrapperField] = WrapperField("AdditionalQCMailingList", FieldType.STRING, display_name="Additional QC Mailing List")
    ALWAYSLAUNCHINSTMAINTWORKFLOW__FIELD_NAME: Final[WrapperField] = WrapperField("AlwaysLaunchInstMaintWorkflow", FieldType.BOOLEAN, display_name="Always Launch Maintenance Workflow")
    APPROVERVISIBLEROLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ApproverVisibleRoleType", FieldType.BOOLEAN, display_name="Approver Role")
    ASSIGNROLENOTIFICATIONBUTTON__FIELD_NAME: Final[WrapperField] = WrapperField("AssignRoleNotificationButton", FieldType.ACTION, display_name="Configure Assign Role Notifications")
    ASSIGNTOPROCESSUSERGROUPLIST__FIELD_NAME: Final[WrapperField] = WrapperField("AssignToProcessUserGroupList", FieldType.SELECTION, display_name="User Groups with access to \"Assign To Process\" button")
    AUTHENTICATIONREQUIRED__FIELD_NAME: Final[WrapperField] = WrapperField("AuthenticationRequired", FieldType.BOOLEAN, display_name="Authentication Required")
    BOWTIE2EXECPATH__FIELD_NAME: Final[WrapperField] = WrapperField("Bowtie2ExecPath", FieldType.STRING, display_name="bowtie2 Exec Path")
    BOWTIE2GRCHINDEXPREFIX__FIELD_NAME: Final[WrapperField] = WrapperField("Bowtie2GRChIndexPrefix", FieldType.STRING, display_name="bowtie2 GRCh Index Path")
    BOWTIEGRCH38REFINDEXPREFIX__FIELD_NAME: Final[WrapperField] = WrapperField("BowtieGrCh38RefIndexPrefix", FieldType.STRING, display_name="Bowtie Gr Ch38 Ref Index Prefix")
    BOWTIEINDEXDIRECTORY__FIELD_NAME: Final[WrapperField] = WrapperField("BowtieIndexDirectory", FieldType.STRING, display_name="Bowtie Index Directory")
    BROADCASTMAINTALERT__FIELD_NAME: Final[WrapperField] = WrapperField("BroadcastMaintAlert", FieldType.BOOLEAN, display_name="Broadcast Maintenance Alerts")
    BROADCASTMAINTUSERS__FIELD_NAME: Final[WrapperField] = WrapperField("BroadcastMaintUsers", FieldType.SELECTION, display_name="Email/Broadcast Users")
    CANMODIFYEXISTINGVSMTPITEMS__FIELD_NAME: Final[WrapperField] = WrapperField("CanModifyExistingVSMTPItems", FieldType.BOOLEAN, display_name="Can Modify Existing Visual Storage Management Task Items")
    CONFIGUREINSTRUMENTFILEFIELD__FIELD_NAME: Final[WrapperField] = WrapperField("ConfigureInstrumentFileField", FieldType.ACTION, display_name="Configure SDMS File Link-out Field")
    CONSUMABLEDATATYPES__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableDataTypes", FieldType.STRING, display_name="Consumable Data Type(s)")
    CONSUMABLEDIRECTORIES__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableDirectories", FieldType.STRING, display_name="Consumable Directory Mappings")
    CONSUMABLETRACKINGATTRIBUTE__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableTrackingAttribute", FieldType.PICKLIST, display_name="Consumable Tracking Attribute")
    CONSUMABLETYPEMAXTEMP__FIELD_NAME: Final[WrapperField] = WrapperField("ConsumableTypeMaxTemp", FieldType.STRING, display_name="Consumable Type Maximum Temperature Restriction")
    COOLINGSTORAGEUNITTYPES__FIELD_NAME: Final[WrapperField] = WrapperField("CoolingStorageUnitTypes", FieldType.SELECTION, display_name="Cooling Storage Unit Types")
    CREATEINWORKFLOW__FIELD_NAME: Final[WrapperField] = WrapperField("CreateInWorkflow", FieldType.BOOLEAN, display_name="New Consumable Creation in Workflow")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DEFAULTELNEXPERIMENTGROUPROLES__FIELD_NAME: Final[WrapperField] = WrapperField("DefaultELNExperimentGroupRoles", FieldType.SELECTION, display_name="Default Experiment Group Roles")
    DEFAULTELNEXPERIMENTROLES__FIELD_NAME: Final[WrapperField] = WrapperField("DefaultELNExperimentRoles", FieldType.SELECTION, display_name="Default Experiment User Roles")
    DEFAULTELNEXPERIMENTROLESHELP__FIELD_NAME: Final[WrapperField] = WrapperField("DefaultELNExperimentRolesHelp", FieldType.STRING, display_name="Feature Explanation")
    DEFINECONSUMABLEDATATYPES__FIELD_NAME: Final[WrapperField] = WrapperField("DefineConsumableDataTypes", FieldType.ACTION, display_name="Define / Edit Material Data Types")
    DEFINECONSUMABLEDIRECTORIES__FIELD_NAME: Final[WrapperField] = WrapperField("DefineConsumableDirectories", FieldType.ACTION, display_name="Define / Edit Material Directories")
    DELIMITER__FIELD_NAME: Final[WrapperField] = WrapperField("Delimiter", FieldType.STRING, display_name="Sample ID Delimiter")
    ELNCREATESMPLEXTENTIONMULTISEL__FIELD_NAME: Final[WrapperField] = WrapperField("ELNCreateSmplExtentionMultiSel", FieldType.BOOLEAN, display_name="Enable Multi-Select Extension Types")
    ELNIMPORTSAMPLESOVERRIDE__FIELD_NAME: Final[WrapperField] = WrapperField("ELNImportSamplesOverride", FieldType.STRING, display_name="ELN Experiment Import Samples Override")
    ENOTEBOOKSIGNOFFGROUPS__FIELD_NAME: Final[WrapperField] = WrapperField("ENotebookSignoffGroups", FieldType.SELECTION, display_name="Required Experiment E-Sign Roles")
    ENOTEBOOKSIGNOFFGROUPSHELP__FIELD_NAME: Final[WrapperField] = WrapperField("ENotebookSignoffGroupsHelp", FieldType.STRING, display_name="Feature Explanation")
    EMAIL__FIELD_NAME: Final[WrapperField] = WrapperField("Email", FieldType.STRING, display_name="System Email")
    ENABLEAUTOLOTPOPULATION__FIELD_NAME: Final[WrapperField] = WrapperField("EnableAutoLotPopulation", FieldType.BOOLEAN, display_name="Enable Automatic Population of Lot Numbers / Barcodes")
    ENABLEBASELINESAMPLEREC__FIELD_NAME: Final[WrapperField] = WrapperField("EnableBaselineSampleRec", FieldType.BOOLEAN, display_name="Enable/Disable Sample Receiving")
    ENABLEDND__FIELD_NAME: Final[WrapperField] = WrapperField("EnableDND", FieldType.BOOLEAN, display_name="Enable Drag And Drop")
    ENABLEELNROLECANDIDATES__FIELD_NAME: Final[WrapperField] = WrapperField("EnableElnRoleCandidates", FieldType.BOOLEAN, display_name="Enable ELN Role Candidates")
    ENABLEMULTITENANTDASHBOARDS__FIELD_NAME: Final[WrapperField] = WrapperField("EnableMultiTenantDashboards", FieldType.BOOLEAN, display_name="Enable Tenant Switching for Sapio Dashboards")
    ENFORCECONSUMABLEDIRECTORY__FIELD_NAME: Final[WrapperField] = WrapperField("EnforceConsumableDirectory", FieldType.BOOLEAN, display_name="Enforce Consumable Directory")
    ENFORCEEXPIRATION__FIELD_NAME: Final[WrapperField] = WrapperField("EnforceExpiration", FieldType.BOOLEAN, display_name="Enforce Expiration Date")
    ENFORCESUFFICIENTQUANTITY__FIELD_NAME: Final[WrapperField] = WrapperField("EnforceSufficientQuantity", FieldType.BOOLEAN, display_name="Enforce Sufficient Quantity")
    ENUMERATESTORAGE__FIELD_NAME: Final[WrapperField] = WrapperField("EnumerateStorage", FieldType.BOOLEAN, display_name="Number Storage Positions")
    ESIGREQUIREALLAUTHOR__FIELD_NAME: Final[WrapperField] = WrapperField("EsigRequireAllAuthor", FieldType.BOOLEAN, display_name="Require Authors to E-Sign?")
    ESIGREQUIREALLAUTHORHELP__FIELD_NAME: Final[WrapperField] = WrapperField("EsigRequireAllAuthorHelp", FieldType.STRING, display_name="Feature Explanation")
    ESIGNEMAILOWNERNOTEBOOKUNLOCK__FIELD_NAME: Final[WrapperField] = WrapperField("EsignEmailOwnerNotebookUnlock", FieldType.BOOLEAN, display_name="Only Email Owner On Experiment Unlock")
    ESIGNSENDEMAILONDECISION__FIELD_NAME: Final[WrapperField] = WrapperField("EsignSendEmailOnDecision", FieldType.BOOLEAN, display_name="Send Email on Approval Process")
    ESIGNSENDEMAILONENTRYUNLOCK__FIELD_NAME: Final[WrapperField] = WrapperField("EsignSendEmailOnEntryUnlock", FieldType.BOOLEAN, display_name="Send Email On Entry Unlock")
    ESIGNSENDEMAILONNOTEBOOKUNLOCK__FIELD_NAME: Final[WrapperField] = WrapperField("EsignSendEmailOnNotebookUnlock", FieldType.BOOLEAN, display_name="Send Email On Experiment Unlock")
    EXPERIMENTBANNEREXPFIELDS__FIELD_NAME: Final[WrapperField] = WrapperField("ExperimentBannerExpFields", FieldType.SELECTION, display_name="Experiment Banner Experiment Default Fields")
    EXPERIMENTBANNERPARENTFIELDS__FIELD_NAME: Final[WrapperField] = WrapperField("ExperimentBannerParentFields", FieldType.SELECTION, display_name="Experiment Banner Parent Default Fields")
    EXPORTEXEMPLARCONFIGBUTTON__FIELD_NAME: Final[WrapperField] = WrapperField("ExportExemplarConfigButton", FieldType.ACTION, display_name="Export Sapio Configs")
    EXPORTFULLCONFIGBUTTON__FIELD_NAME: Final[WrapperField] = WrapperField("ExportFullConfigButton", FieldType.ACTION, display_name="Export Full Configurations")
    EXPORTSELECTEDCONFIGBUTTON__FIELD_NAME: Final[WrapperField] = WrapperField("ExportSelectedConfigButton", FieldType.ACTION, display_name="Export Selected Configurations")
    EXPORTSTATICCONFIGURATIONS__FIELD_NAME: Final[WrapperField] = WrapperField("ExportStaticConfigurations", FieldType.ACTION, display_name="Export Static Configurations")
    GRCHFASTAPATH__FIELD_NAME: Final[WrapperField] = WrapperField("GRChFASTAPath", FieldType.STRING, display_name="GRCh FASTA Path")
    GENERATEITEMBARCODE__FIELD_NAME: Final[WrapperField] = WrapperField("GenerateItemBarcode", FieldType.BOOLEAN, display_name="Generate Consumable Item Barcode")
    IMPORTBACKUPCONFIGBUTTON__FIELD_NAME: Final[WrapperField] = WrapperField("ImportBackupConfigButton", FieldType.ACTION, display_name="Import Backup Configurations")
    IMPORTBASELINEDESCRIPTION__FIELD_NAME: Final[WrapperField] = WrapperField("ImportBaseLineDescription", FieldType.STRING, display_name="Description")
    IMPORTEXEMPLARCONFIGBUTTON__FIELD_NAME: Final[WrapperField] = WrapperField("ImportExemplarConfigButton", FieldType.ACTION, display_name="Import Sapio Configurations")
    IMPORTEXPORTEXEMPLARCONFIGTEXT__FIELD_NAME: Final[WrapperField] = WrapperField("ImportExportExemplarConfigText", FieldType.STRING, display_name="Description")
    IMPORTEXPORTSYSTEMCONFIGSTEXT__FIELD_NAME: Final[WrapperField] = WrapperField("ImportExportSystemConfigsText", FieldType.STRING, display_name="Description")
    IMPORTSYSTEMCONFIGBUTTON__FIELD_NAME: Final[WrapperField] = WrapperField("ImportSystemConfigButton", FieldType.ACTION, display_name="Import System Configurations")
    INDEXEDSTORAGETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("IndexedStorageType", FieldType.SELECTION, display_name="Storage Types Displaying Position Indexes")
    INSTRUMENTFORCEIDVREGISTRATION__FIELD_NAME: Final[WrapperField] = WrapperField("InstrumentForceIdvRegistration", FieldType.BOOLEAN, display_name="Register New Instruments Outside An Experiment?")
    MATMANENABLEFEATUREEXT__FIELD_NAME: Final[WrapperField] = WrapperField("MatManEnableFeatureExt", FieldType.BOOLEAN, display_name="Enable Plugin Extension")
    MMFORCEIDVREGISTRATION__FIELD_NAME: Final[WrapperField] = WrapperField("MmForceIdvRegistration", FieldType.BOOLEAN, display_name="Register New Materials Outside An Experiment?")
    MMSAMPLEFIELDSTODISPLAY__FIELD_NAME: Final[WrapperField] = WrapperField("MmSampleFieldsToDisplay", FieldType.SELECTION, display_name="Material Registration Sample Fields to Display")
    MULTILAYERPLATEPOOLIFSAMETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("MultiLayerPlatePoolIfSameType", FieldType.BOOLEAN, display_name="Pool if Same Type")
    NATIVEPYEXECPATH__FIELD_NAME: Final[WrapperField] = WrapperField("NativePyExecPath", FieldType.STRING, display_name="Native Py Exec Path")
    NATIVEREXECPATH__FIELD_NAME: Final[WrapperField] = WrapperField("NativeRExecPath", FieldType.STRING, display_name="Native R Exec Path")
    NEWCONSUMABLEDIRNAME__FIELD_NAME: Final[WrapperField] = WrapperField("NewConsumableDirName", FieldType.STRING, display_name="New Consumable Directory Name")
    NOTIFICATIONUSERS__FIELD_NAME: Final[WrapperField] = WrapperField("NotificationUsers", FieldType.SELECTION, display_name="Users To Notify")
    NOTIFYMAINTTECHNICIANS__FIELD_NAME: Final[WrapperField] = WrapperField("NotifyMaintTechnicians", FieldType.BOOLEAN, display_name="Notify Maintenance Technicians")
    OVERRIDEGROUPS__FIELD_NAME: Final[WrapperField] = WrapperField("OverrideGroups", FieldType.SELECTION, display_name="Override Groups")
    PLASMIDDATATYPE__FIELD_NAME: Final[WrapperField] = WrapperField("PlasmidDataType", FieldType.SELECTION, display_name="Plasmid Data Type")
    PLATEDESIGNERPRIMARYTYPES__FIELD_NAME: Final[WrapperField] = WrapperField("PlateDesignerPrimaryTypes", FieldType.SELECTION, display_name="3D Plate Assignable Types")
    PORT__FIELD_NAME: Final[WrapperField] = WrapperField("Port", FieldType.INTEGER, display_name="Port")
    PRENOTIFICATIONINTERVAL__FIELD_NAME: Final[WrapperField] = WrapperField("PreNotificationInterval", FieldType.LONG, display_name="Pre-Notification Interval (days)")
    PRINTCONSUMABLEBARCODE__FIELD_NAME: Final[WrapperField] = WrapperField("PrintConsumableBarcode", FieldType.BOOLEAN, display_name="Print Consumable Item Barcodes")
    QCMAILINGLIST__FIELD_NAME: Final[WrapperField] = WrapperField("QCMailingList", FieldType.SELECTION, display_name="QC Mailing List")
    QUANTITYTRACKING__FIELD_NAME: Final[WrapperField] = WrapperField("QuantityTracking", FieldType.BOOLEAN, display_name="Quantity / Volume Tracking")
    RTRANSEXECPATH__FIELD_NAME: Final[WrapperField] = WrapperField("RTransExecPath", FieldType.STRING, display_name="R Trans Exec Path")
    RECORDREPORTACCESSGROUPS__FIELD_NAME: Final[WrapperField] = WrapperField("RecordReportAccessGroups", FieldType.SELECTION, display_name="Record Report Access Groups")
    RECORDREPORTDATATYPELIST__FIELD_NAME: Final[WrapperField] = WrapperField("RecordReportDataTypeList", FieldType.SELECTION, display_name="Record Report Data Type List")
    RECORDSTORAGEEVENTS__FIELD_NAME: Final[WrapperField] = WrapperField("RecordStorageEvents", FieldType.BOOLEAN, display_name="Record Storage Events")
    REQPORTALMANIFESTFIELDNAMES__FIELD_NAME: Final[WrapperField] = WrapperField("ReqPortalManifestFieldNames", FieldType.SELECTION, display_name="Manifest Field Names")
    REQUIREESIGNATURE__FIELD_NAME: Final[WrapperField] = WrapperField("RequireESignature", FieldType.BOOLEAN, display_name="Require E-Signature")
    RESTRICTACCESSBYLOCATION__FIELD_NAME: Final[WrapperField] = WrapperField("RestrictAccessByLocation", FieldType.BOOLEAN, display_name="Restrict Access by Location")
    REVIEWERVISIBLEROLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("ReviewerVisibleRoleType", FieldType.BOOLEAN, display_name="Reviewer Role")
    S3ACCESSKEYID__FIELD_NAME: Final[WrapperField] = WrapperField("S3AccessKeyId", FieldType.STRING, display_name="S3 Access Key ID")
    S3SECRETACESSKEY__FIELD_NAME: Final[WrapperField] = WrapperField("S3SecretAcessKey", FieldType.STRING, display_name="S3 Secret Access Key")
    SDMSROOTPATH__FIELD_NAME: Final[WrapperField] = WrapperField("SDMSRootPath", FieldType.STRING, display_name="SDMS Root Path")
    SMTPSERVER__FIELD_NAME: Final[WrapperField] = WrapperField("SMTPServer", FieldType.STRING, display_name="SMTP Server")
    SAASMAXNUMOFSAMPLESPERTRANS__FIELD_NAME: Final[WrapperField] = WrapperField("SaasMaxNumOfSamplesPerTrans", FieldType.LONG, display_name="SAAS Max Number of Samples Per Workflow")
    SAASMAXSAMPLES__FIELD_NAME: Final[WrapperField] = WrapperField("SaasMaxSamples", FieldType.LONG, display_name="SAAS Max Samples")
    SAASMODE__FIELD_NAME: Final[WrapperField] = WrapperField("SaasMode", FieldType.BOOLEAN, display_name="SAAS Mode")
    SAMPLERECEIVINGEMAILS__FIELD_NAME: Final[WrapperField] = WrapperField("SampleReceivingEmails", FieldType.STRING, display_name="Additional Emails for Samples Received")
    SAMPLERECEIVINGUSERMENU__FIELD_NAME: Final[WrapperField] = WrapperField("SampleReceivingUserMenu", FieldType.SELECTION, display_name="Users to Notify of Samples Received")
    SAMPLETYPEMAXIMUMTEMPERATURE__FIELD_NAME: Final[WrapperField] = WrapperField("SampleTypeMaximumTemperature", FieldType.STRING, display_name="Sample Type Maximum Temperature Restriction")
    SAMTOOLSEXECPATH__FIELD_NAME: Final[WrapperField] = WrapperField("SamtoolsExecPath", FieldType.STRING, display_name="samtools Exec Path")
    SECURESOCKETLAYER__FIELD_NAME: Final[WrapperField] = WrapperField("SecureSocketLayer", FieldType.BOOLEAN, display_name="SSL")
    SENDTESTMAIL__FIELD_NAME: Final[WrapperField] = WrapperField("SendTestMail", FieldType.ACTION, display_name="Send Test Mail")
    SMTPUSERNAME__FIELD_NAME: Final[WrapperField] = WrapperField("SmtpUsername", FieldType.STRING, display_name="SMTP Username")
    STORAGEUNITVIEWERFILLBYCONFIG__FIELD_NAME: Final[WrapperField] = WrapperField("StorageUnitViewerFillByConfig", FieldType.PICKLIST, display_name="Storage Unit Viewer Fill by Configuration")
    SYSTEMPASSWORD__FIELD_NAME: Final[WrapperField] = WrapperField("SystemPassword", FieldType.STRING, display_name="System Password")
    TLSENABLED__FIELD_NAME: Final[WrapperField] = WrapperField("TLSEnabled", FieldType.BOOLEAN, display_name="TLS Enabled")
    TLSREQUIRED__FIELD_NAME: Final[WrapperField] = WrapperField("TLSRequired", FieldType.BOOLEAN, display_name="TLS Required")
    TEMPERATUREENFORCEMENT__FIELD_NAME: Final[WrapperField] = WrapperField("TemperatureEnforcement", FieldType.PICKLIST, display_name="Temperature Enforcement")
    USEREQUESTDEFAULTLAYOUT__FIELD_NAME: Final[WrapperField] = WrapperField("UseRequestDefaultLayout", FieldType.BOOLEAN, display_name="Use Default Layout For Request Creation")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    VERIFICATIONTYPES__FIELD_NAME: Final[WrapperField] = WrapperField("VerificationTypes", FieldType.PICKLIST, display_name="Types of Validation Enforcement")
    WITNESSVISIBLEROLETYPE__FIELD_NAME: Final[WrapperField] = WrapperField("WitnessVisibleRoleType", FieldType.BOOLEAN, display_name="Witness Role")
    WRITEQCINPUTFILETOUSER__FIELD_NAME: Final[WrapperField] = WrapperField("WriteQCInputFileToUser", FieldType.BOOLEAN, display_name="Write QC Input File to User")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ActiveNotebooksInWorkQueue_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ActiveNotebooksInWorkQueue' on this record model
        """
        self.set_field_value(self.ACTIVENOTEBOOKSINWORKQUEUE__FIELD_NAME.field_name, value)

    def get_ActiveNotebooksInWorkQueue_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ActiveNotebooksInWorkQueue' from this record model
        """
        return self.get_field_value(self.ACTIVENOTEBOOKSINWORKQUEUE__FIELD_NAME.field_name)

    def set_AdHocExperimentsInheritAccess_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AdHocExperimentsInheritAccess' on this record model
        """
        self.set_field_value(self.ADHOCEXPERIMENTSINHERITACCESS__FIELD_NAME.field_name, value)

    def get_AdHocExperimentsInheritAccess_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AdHocExperimentsInheritAccess' from this record model
        """
        return self.get_field_value(self.ADHOCEXPERIMENTSINHERITACCESS__FIELD_NAME.field_name)

    def set_AddAllUserAsCandidate_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AddAllUserAsCandidate' on this record model
        """
        self.set_field_value(self.ADDALLUSERASCANDIDATE__FIELD_NAME.field_name, value)

    def get_AddAllUserAsCandidate_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AddAllUserAsCandidate' from this record model
        """
        return self.get_field_value(self.ADDALLUSERASCANDIDATE__FIELD_NAME.field_name)

    def set_AddAllUserAsCandidateHelp_field(self, value: Optional[str]):
        """
        Set data field with field name 'AddAllUserAsCandidateHelp' on this record model
        """
        self.set_field_value(self.ADDALLUSERASCANDIDATEHELP__FIELD_NAME.field_name, value)

    def get_AddAllUserAsCandidateHelp_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AddAllUserAsCandidateHelp' from this record model
        """
        return self.get_field_value(self.ADDALLUSERASCANDIDATEHELP__FIELD_NAME.field_name)

    def set_AddConsumablesToExperiments_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AddConsumablesToExperiments' on this record model
        """
        self.set_field_value(self.ADDCONSUMABLESTOEXPERIMENTS__FIELD_NAME.field_name, value)

    def get_AddConsumablesToExperiments_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AddConsumablesToExperiments' from this record model
        """
        return self.get_field_value(self.ADDCONSUMABLESTOEXPERIMENTS__FIELD_NAME.field_name)

    def set_AdditionalInstMaintEmails_field(self, value: Optional[str]):
        """
        Set data field with field name 'AdditionalInstMaintEmails' on this record model
        """
        self.set_field_value(self.ADDITIONALINSTMAINTEMAILS__FIELD_NAME.field_name, value)

    def get_AdditionalInstMaintEmails_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AdditionalInstMaintEmails' from this record model
        """
        return self.get_field_value(self.ADDITIONALINSTMAINTEMAILS__FIELD_NAME.field_name)

    def set_AdditionalNotificationEmails_field(self, value: Optional[str]):
        """
        Set data field with field name 'AdditionalNotificationEmails' on this record model
        """
        self.set_field_value(self.ADDITIONALNOTIFICATIONEMAILS__FIELD_NAME.field_name, value)

    def get_AdditionalNotificationEmails_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AdditionalNotificationEmails' from this record model
        """
        return self.get_field_value(self.ADDITIONALNOTIFICATIONEMAILS__FIELD_NAME.field_name)

    def set_AdditionalQCMailingList_field(self, value: Optional[str]):
        """
        Set data field with field name 'AdditionalQCMailingList' on this record model
        """
        self.set_field_value(self.ADDITIONALQCMAILINGLIST__FIELD_NAME.field_name, value)

    def get_AdditionalQCMailingList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AdditionalQCMailingList' from this record model
        """
        return self.get_field_value(self.ADDITIONALQCMAILINGLIST__FIELD_NAME.field_name)

    def set_AlwaysLaunchInstMaintWorkflow_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AlwaysLaunchInstMaintWorkflow' on this record model
        """
        self.set_field_value(self.ALWAYSLAUNCHINSTMAINTWORKFLOW__FIELD_NAME.field_name, value)

    def get_AlwaysLaunchInstMaintWorkflow_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AlwaysLaunchInstMaintWorkflow' from this record model
        """
        return self.get_field_value(self.ALWAYSLAUNCHINSTMAINTWORKFLOW__FIELD_NAME.field_name)

    def set_ApproverVisibleRoleType_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ApproverVisibleRoleType' on this record model
        """
        self.set_field_value(self.APPROVERVISIBLEROLETYPE__FIELD_NAME.field_name, value)

    def get_ApproverVisibleRoleType_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ApproverVisibleRoleType' from this record model
        """
        return self.get_field_value(self.APPROVERVISIBLEROLETYPE__FIELD_NAME.field_name)

    def set_AssignToProcessUserGroupList_field(self, value: Optional[str]):
        """
        Set data field with field name 'AssignToProcessUserGroupList' on this record model
        """
        self.set_field_value(self.ASSIGNTOPROCESSUSERGROUPLIST__FIELD_NAME.field_name, value)

    def get_AssignToProcessUserGroupList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AssignToProcessUserGroupList' from this record model
        """
        return self.get_field_value(self.ASSIGNTOPROCESSUSERGROUPLIST__FIELD_NAME.field_name)

    def set_AuthenticationRequired_field(self, value: Optional[bool]):
        """
        Set data field with field name 'AuthenticationRequired' on this record model
        """
        self.set_field_value(self.AUTHENTICATIONREQUIRED__FIELD_NAME.field_name, value)

    def get_AuthenticationRequired_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'AuthenticationRequired' from this record model
        """
        return self.get_field_value(self.AUTHENTICATIONREQUIRED__FIELD_NAME.field_name)

    def set_Bowtie2ExecPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'Bowtie2ExecPath' on this record model
        """
        self.set_field_value(self.BOWTIE2EXECPATH__FIELD_NAME.field_name, value)

    def get_Bowtie2ExecPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Bowtie2ExecPath' from this record model
        """
        return self.get_field_value(self.BOWTIE2EXECPATH__FIELD_NAME.field_name)

    def set_Bowtie2GRChIndexPrefix_field(self, value: Optional[str]):
        """
        Set data field with field name 'Bowtie2GRChIndexPrefix' on this record model
        """
        self.set_field_value(self.BOWTIE2GRCHINDEXPREFIX__FIELD_NAME.field_name, value)

    def get_Bowtie2GRChIndexPrefix_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Bowtie2GRChIndexPrefix' from this record model
        """
        return self.get_field_value(self.BOWTIE2GRCHINDEXPREFIX__FIELD_NAME.field_name)

    def set_BowtieGrCh38RefIndexPrefix_field(self, value: Optional[str]):
        """
        Set data field with field name 'BowtieGrCh38RefIndexPrefix' on this record model
        """
        self.set_field_value(self.BOWTIEGRCH38REFINDEXPREFIX__FIELD_NAME.field_name, value)

    def get_BowtieGrCh38RefIndexPrefix_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BowtieGrCh38RefIndexPrefix' from this record model
        """
        return self.get_field_value(self.BOWTIEGRCH38REFINDEXPREFIX__FIELD_NAME.field_name)

    def set_BowtieIndexDirectory_field(self, value: Optional[str]):
        """
        Set data field with field name 'BowtieIndexDirectory' on this record model
        """
        self.set_field_value(self.BOWTIEINDEXDIRECTORY__FIELD_NAME.field_name, value)

    def get_BowtieIndexDirectory_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BowtieIndexDirectory' from this record model
        """
        return self.get_field_value(self.BOWTIEINDEXDIRECTORY__FIELD_NAME.field_name)

    def set_BroadcastMaintAlert_field(self, value: Optional[bool]):
        """
        Set data field with field name 'BroadcastMaintAlert' on this record model
        """
        self.set_field_value(self.BROADCASTMAINTALERT__FIELD_NAME.field_name, value)

    def get_BroadcastMaintAlert_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'BroadcastMaintAlert' from this record model
        """
        return self.get_field_value(self.BROADCASTMAINTALERT__FIELD_NAME.field_name)

    def set_BroadcastMaintUsers_field(self, value: Optional[str]):
        """
        Set data field with field name 'BroadcastMaintUsers' on this record model
        """
        self.set_field_value(self.BROADCASTMAINTUSERS__FIELD_NAME.field_name, value)

    def get_BroadcastMaintUsers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'BroadcastMaintUsers' from this record model
        """
        return self.get_field_value(self.BROADCASTMAINTUSERS__FIELD_NAME.field_name)

    def set_CanModifyExistingVSMTPItems_field(self, value: Optional[bool]):
        """
        Set data field with field name 'CanModifyExistingVSMTPItems' on this record model
        """
        self.set_field_value(self.CANMODIFYEXISTINGVSMTPITEMS__FIELD_NAME.field_name, value)

    def get_CanModifyExistingVSMTPItems_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'CanModifyExistingVSMTPItems' from this record model
        """
        return self.get_field_value(self.CANMODIFYEXISTINGVSMTPITEMS__FIELD_NAME.field_name)

    def set_ConsumableDataTypes_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableDataTypes' on this record model
        """
        self.set_field_value(self.CONSUMABLEDATATYPES__FIELD_NAME.field_name, value)

    def get_ConsumableDataTypes_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableDataTypes' from this record model
        """
        return self.get_field_value(self.CONSUMABLEDATATYPES__FIELD_NAME.field_name)

    def set_ConsumableDirectories_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableDirectories' on this record model
        """
        self.set_field_value(self.CONSUMABLEDIRECTORIES__FIELD_NAME.field_name, value)

    def get_ConsumableDirectories_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableDirectories' from this record model
        """
        return self.get_field_value(self.CONSUMABLEDIRECTORIES__FIELD_NAME.field_name)

    def set_ConsumableTrackingAttribute_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableTrackingAttribute' on this record model
        """
        self.set_field_value(self.CONSUMABLETRACKINGATTRIBUTE__FIELD_NAME.field_name, value)

    def get_ConsumableTrackingAttribute_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableTrackingAttribute' from this record model
        """
        return self.get_field_value(self.CONSUMABLETRACKINGATTRIBUTE__FIELD_NAME.field_name)

    def set_ConsumableTypeMaxTemp_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConsumableTypeMaxTemp' on this record model
        """
        self.set_field_value(self.CONSUMABLETYPEMAXTEMP__FIELD_NAME.field_name, value)

    def get_ConsumableTypeMaxTemp_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConsumableTypeMaxTemp' from this record model
        """
        return self.get_field_value(self.CONSUMABLETYPEMAXTEMP__FIELD_NAME.field_name)

    def set_CoolingStorageUnitTypes_field(self, value: Optional[str]):
        """
        Set data field with field name 'CoolingStorageUnitTypes' on this record model
        """
        self.set_field_value(self.COOLINGSTORAGEUNITTYPES__FIELD_NAME.field_name, value)

    def get_CoolingStorageUnitTypes_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CoolingStorageUnitTypes' from this record model
        """
        return self.get_field_value(self.COOLINGSTORAGEUNITTYPES__FIELD_NAME.field_name)

    def set_CreateInWorkflow_field(self, value: Optional[bool]):
        """
        Set data field with field name 'CreateInWorkflow' on this record model
        """
        self.set_field_value(self.CREATEINWORKFLOW__FIELD_NAME.field_name, value)

    def get_CreateInWorkflow_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'CreateInWorkflow' from this record model
        """
        return self.get_field_value(self.CREATEINWORKFLOW__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DefaultELNExperimentGroupRoles_field(self, value: Optional[str]):
        """
        Set data field with field name 'DefaultELNExperimentGroupRoles' on this record model
        """
        self.set_field_value(self.DEFAULTELNEXPERIMENTGROUPROLES__FIELD_NAME.field_name, value)

    def get_DefaultELNExperimentGroupRoles_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DefaultELNExperimentGroupRoles' from this record model
        """
        return self.get_field_value(self.DEFAULTELNEXPERIMENTGROUPROLES__FIELD_NAME.field_name)

    def set_DefaultELNExperimentRoles_field(self, value: Optional[str]):
        """
        Set data field with field name 'DefaultELNExperimentRoles' on this record model
        """
        self.set_field_value(self.DEFAULTELNEXPERIMENTROLES__FIELD_NAME.field_name, value)

    def get_DefaultELNExperimentRoles_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DefaultELNExperimentRoles' from this record model
        """
        return self.get_field_value(self.DEFAULTELNEXPERIMENTROLES__FIELD_NAME.field_name)

    def set_DefaultELNExperimentRolesHelp_field(self, value: Optional[str]):
        """
        Set data field with field name 'DefaultELNExperimentRolesHelp' on this record model
        """
        self.set_field_value(self.DEFAULTELNEXPERIMENTROLESHELP__FIELD_NAME.field_name, value)

    def get_DefaultELNExperimentRolesHelp_field(self) -> Optional[str]:
        """
        Get data field value with field name 'DefaultELNExperimentRolesHelp' from this record model
        """
        return self.get_field_value(self.DEFAULTELNEXPERIMENTROLESHELP__FIELD_NAME.field_name)

    def set_Delimiter_field(self, value: Optional[str]):
        """
        Set data field with field name 'Delimiter' on this record model
        """
        self.set_field_value(self.DELIMITER__FIELD_NAME.field_name, value)

    def get_Delimiter_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Delimiter' from this record model
        """
        return self.get_field_value(self.DELIMITER__FIELD_NAME.field_name)

    def set_ELNCreateSmplExtentionMultiSel_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ELNCreateSmplExtentionMultiSel' on this record model
        """
        self.set_field_value(self.ELNCREATESMPLEXTENTIONMULTISEL__FIELD_NAME.field_name, value)

    def get_ELNCreateSmplExtentionMultiSel_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ELNCreateSmplExtentionMultiSel' from this record model
        """
        return self.get_field_value(self.ELNCREATESMPLEXTENTIONMULTISEL__FIELD_NAME.field_name)

    def set_ELNImportSamplesOverride_field(self, value: Optional[str]):
        """
        Set data field with field name 'ELNImportSamplesOverride' on this record model
        """
        self.set_field_value(self.ELNIMPORTSAMPLESOVERRIDE__FIELD_NAME.field_name, value)

    def get_ELNImportSamplesOverride_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ELNImportSamplesOverride' from this record model
        """
        return self.get_field_value(self.ELNIMPORTSAMPLESOVERRIDE__FIELD_NAME.field_name)

    def set_ENotebookSignoffGroups_field(self, value: Optional[str]):
        """
        Set data field with field name 'ENotebookSignoffGroups' on this record model
        """
        self.set_field_value(self.ENOTEBOOKSIGNOFFGROUPS__FIELD_NAME.field_name, value)

    def get_ENotebookSignoffGroups_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ENotebookSignoffGroups' from this record model
        """
        return self.get_field_value(self.ENOTEBOOKSIGNOFFGROUPS__FIELD_NAME.field_name)

    def set_ENotebookSignoffGroupsHelp_field(self, value: Optional[str]):
        """
        Set data field with field name 'ENotebookSignoffGroupsHelp' on this record model
        """
        self.set_field_value(self.ENOTEBOOKSIGNOFFGROUPSHELP__FIELD_NAME.field_name, value)

    def get_ENotebookSignoffGroupsHelp_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ENotebookSignoffGroupsHelp' from this record model
        """
        return self.get_field_value(self.ENOTEBOOKSIGNOFFGROUPSHELP__FIELD_NAME.field_name)

    def set_Email_field(self, value: Optional[str]):
        """
        Set data field with field name 'Email' on this record model
        """
        self.set_field_value(self.EMAIL__FIELD_NAME.field_name, value)

    def get_Email_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Email' from this record model
        """
        return self.get_field_value(self.EMAIL__FIELD_NAME.field_name)

    def set_EnableAutoLotPopulation_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableAutoLotPopulation' on this record model
        """
        self.set_field_value(self.ENABLEAUTOLOTPOPULATION__FIELD_NAME.field_name, value)

    def get_EnableAutoLotPopulation_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableAutoLotPopulation' from this record model
        """
        return self.get_field_value(self.ENABLEAUTOLOTPOPULATION__FIELD_NAME.field_name)

    def set_EnableBaselineSampleRec_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableBaselineSampleRec' on this record model
        """
        self.set_field_value(self.ENABLEBASELINESAMPLEREC__FIELD_NAME.field_name, value)

    def get_EnableBaselineSampleRec_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableBaselineSampleRec' from this record model
        """
        return self.get_field_value(self.ENABLEBASELINESAMPLEREC__FIELD_NAME.field_name)

    def set_EnableDND_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableDND' on this record model
        """
        self.set_field_value(self.ENABLEDND__FIELD_NAME.field_name, value)

    def get_EnableDND_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableDND' from this record model
        """
        return self.get_field_value(self.ENABLEDND__FIELD_NAME.field_name)

    def set_EnableElnRoleCandidates_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableElnRoleCandidates' on this record model
        """
        self.set_field_value(self.ENABLEELNROLECANDIDATES__FIELD_NAME.field_name, value)

    def get_EnableElnRoleCandidates_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableElnRoleCandidates' from this record model
        """
        return self.get_field_value(self.ENABLEELNROLECANDIDATES__FIELD_NAME.field_name)

    def set_EnableMultiTenantDashboards_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnableMultiTenantDashboards' on this record model
        """
        self.set_field_value(self.ENABLEMULTITENANTDASHBOARDS__FIELD_NAME.field_name, value)

    def get_EnableMultiTenantDashboards_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnableMultiTenantDashboards' from this record model
        """
        return self.get_field_value(self.ENABLEMULTITENANTDASHBOARDS__FIELD_NAME.field_name)

    def set_EnforceConsumableDirectory_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnforceConsumableDirectory' on this record model
        """
        self.set_field_value(self.ENFORCECONSUMABLEDIRECTORY__FIELD_NAME.field_name, value)

    def get_EnforceConsumableDirectory_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnforceConsumableDirectory' from this record model
        """
        return self.get_field_value(self.ENFORCECONSUMABLEDIRECTORY__FIELD_NAME.field_name)

    def set_EnforceExpiration_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnforceExpiration' on this record model
        """
        self.set_field_value(self.ENFORCEEXPIRATION__FIELD_NAME.field_name, value)

    def get_EnforceExpiration_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnforceExpiration' from this record model
        """
        return self.get_field_value(self.ENFORCEEXPIRATION__FIELD_NAME.field_name)

    def set_EnforceSufficientQuantity_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnforceSufficientQuantity' on this record model
        """
        self.set_field_value(self.ENFORCESUFFICIENTQUANTITY__FIELD_NAME.field_name, value)

    def get_EnforceSufficientQuantity_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnforceSufficientQuantity' from this record model
        """
        return self.get_field_value(self.ENFORCESUFFICIENTQUANTITY__FIELD_NAME.field_name)

    def set_EnumerateStorage_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EnumerateStorage' on this record model
        """
        self.set_field_value(self.ENUMERATESTORAGE__FIELD_NAME.field_name, value)

    def get_EnumerateStorage_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EnumerateStorage' from this record model
        """
        return self.get_field_value(self.ENUMERATESTORAGE__FIELD_NAME.field_name)

    def set_EsigRequireAllAuthor_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EsigRequireAllAuthor' on this record model
        """
        self.set_field_value(self.ESIGREQUIREALLAUTHOR__FIELD_NAME.field_name, value)

    def get_EsigRequireAllAuthor_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EsigRequireAllAuthor' from this record model
        """
        return self.get_field_value(self.ESIGREQUIREALLAUTHOR__FIELD_NAME.field_name)

    def set_EsigRequireAllAuthorHelp_field(self, value: Optional[str]):
        """
        Set data field with field name 'EsigRequireAllAuthorHelp' on this record model
        """
        self.set_field_value(self.ESIGREQUIREALLAUTHORHELP__FIELD_NAME.field_name, value)

    def get_EsigRequireAllAuthorHelp_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EsigRequireAllAuthorHelp' from this record model
        """
        return self.get_field_value(self.ESIGREQUIREALLAUTHORHELP__FIELD_NAME.field_name)

    def set_EsignEmailOwnerNotebookUnlock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EsignEmailOwnerNotebookUnlock' on this record model
        """
        self.set_field_value(self.ESIGNEMAILOWNERNOTEBOOKUNLOCK__FIELD_NAME.field_name, value)

    def get_EsignEmailOwnerNotebookUnlock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EsignEmailOwnerNotebookUnlock' from this record model
        """
        return self.get_field_value(self.ESIGNEMAILOWNERNOTEBOOKUNLOCK__FIELD_NAME.field_name)

    def set_EsignSendEmailOnDecision_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EsignSendEmailOnDecision' on this record model
        """
        self.set_field_value(self.ESIGNSENDEMAILONDECISION__FIELD_NAME.field_name, value)

    def get_EsignSendEmailOnDecision_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EsignSendEmailOnDecision' from this record model
        """
        return self.get_field_value(self.ESIGNSENDEMAILONDECISION__FIELD_NAME.field_name)

    def set_EsignSendEmailOnEntryUnlock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EsignSendEmailOnEntryUnlock' on this record model
        """
        self.set_field_value(self.ESIGNSENDEMAILONENTRYUNLOCK__FIELD_NAME.field_name, value)

    def get_EsignSendEmailOnEntryUnlock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EsignSendEmailOnEntryUnlock' from this record model
        """
        return self.get_field_value(self.ESIGNSENDEMAILONENTRYUNLOCK__FIELD_NAME.field_name)

    def set_EsignSendEmailOnNotebookUnlock_field(self, value: Optional[bool]):
        """
        Set data field with field name 'EsignSendEmailOnNotebookUnlock' on this record model
        """
        self.set_field_value(self.ESIGNSENDEMAILONNOTEBOOKUNLOCK__FIELD_NAME.field_name, value)

    def get_EsignSendEmailOnNotebookUnlock_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'EsignSendEmailOnNotebookUnlock' from this record model
        """
        return self.get_field_value(self.ESIGNSENDEMAILONNOTEBOOKUNLOCK__FIELD_NAME.field_name)

    def set_ExperimentBannerExpFields_field(self, value: Optional[str]):
        """
        Set data field with field name 'ExperimentBannerExpFields' on this record model
        """
        self.set_field_value(self.EXPERIMENTBANNEREXPFIELDS__FIELD_NAME.field_name, value)

    def get_ExperimentBannerExpFields_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ExperimentBannerExpFields' from this record model
        """
        return self.get_field_value(self.EXPERIMENTBANNEREXPFIELDS__FIELD_NAME.field_name)

    def set_ExperimentBannerParentFields_field(self, value: Optional[str]):
        """
        Set data field with field name 'ExperimentBannerParentFields' on this record model
        """
        self.set_field_value(self.EXPERIMENTBANNERPARENTFIELDS__FIELD_NAME.field_name, value)

    def get_ExperimentBannerParentFields_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ExperimentBannerParentFields' from this record model
        """
        return self.get_field_value(self.EXPERIMENTBANNERPARENTFIELDS__FIELD_NAME.field_name)

    def set_GRChFASTAPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'GRChFASTAPath' on this record model
        """
        self.set_field_value(self.GRCHFASTAPATH__FIELD_NAME.field_name, value)

    def get_GRChFASTAPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GRChFASTAPath' from this record model
        """
        return self.get_field_value(self.GRCHFASTAPATH__FIELD_NAME.field_name)

    def set_GenerateItemBarcode_field(self, value: Optional[bool]):
        """
        Set data field with field name 'GenerateItemBarcode' on this record model
        """
        self.set_field_value(self.GENERATEITEMBARCODE__FIELD_NAME.field_name, value)

    def get_GenerateItemBarcode_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'GenerateItemBarcode' from this record model
        """
        return self.get_field_value(self.GENERATEITEMBARCODE__FIELD_NAME.field_name)

    def set_ImportBaseLineDescription_field(self, value: Optional[str]):
        """
        Set data field with field name 'ImportBaseLineDescription' on this record model
        """
        self.set_field_value(self.IMPORTBASELINEDESCRIPTION__FIELD_NAME.field_name, value)

    def get_ImportBaseLineDescription_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ImportBaseLineDescription' from this record model
        """
        return self.get_field_value(self.IMPORTBASELINEDESCRIPTION__FIELD_NAME.field_name)

    def set_ImportExportExemplarConfigText_field(self, value: Optional[str]):
        """
        Set data field with field name 'ImportExportExemplarConfigText' on this record model
        """
        self.set_field_value(self.IMPORTEXPORTEXEMPLARCONFIGTEXT__FIELD_NAME.field_name, value)

    def get_ImportExportExemplarConfigText_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ImportExportExemplarConfigText' from this record model
        """
        return self.get_field_value(self.IMPORTEXPORTEXEMPLARCONFIGTEXT__FIELD_NAME.field_name)

    def set_ImportExportSystemConfigsText_field(self, value: Optional[str]):
        """
        Set data field with field name 'ImportExportSystemConfigsText' on this record model
        """
        self.set_field_value(self.IMPORTEXPORTSYSTEMCONFIGSTEXT__FIELD_NAME.field_name, value)

    def get_ImportExportSystemConfigsText_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ImportExportSystemConfigsText' from this record model
        """
        return self.get_field_value(self.IMPORTEXPORTSYSTEMCONFIGSTEXT__FIELD_NAME.field_name)

    def set_IndexedStorageType_field(self, value: Optional[str]):
        """
        Set data field with field name 'IndexedStorageType' on this record model
        """
        self.set_field_value(self.INDEXEDSTORAGETYPE__FIELD_NAME.field_name, value)

    def get_IndexedStorageType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'IndexedStorageType' from this record model
        """
        return self.get_field_value(self.INDEXEDSTORAGETYPE__FIELD_NAME.field_name)

    def set_InstrumentForceIdvRegistration_field(self, value: Optional[bool]):
        """
        Set data field with field name 'InstrumentForceIdvRegistration' on this record model
        """
        self.set_field_value(self.INSTRUMENTFORCEIDVREGISTRATION__FIELD_NAME.field_name, value)

    def get_InstrumentForceIdvRegistration_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'InstrumentForceIdvRegistration' from this record model
        """
        return self.get_field_value(self.INSTRUMENTFORCEIDVREGISTRATION__FIELD_NAME.field_name)

    def set_MatManEnableFeatureExt_field(self, value: Optional[bool]):
        """
        Set data field with field name 'MatManEnableFeatureExt' on this record model
        """
        self.set_field_value(self.MATMANENABLEFEATUREEXT__FIELD_NAME.field_name, value)

    def get_MatManEnableFeatureExt_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'MatManEnableFeatureExt' from this record model
        """
        return self.get_field_value(self.MATMANENABLEFEATUREEXT__FIELD_NAME.field_name)

    def set_MmForceIdvRegistration_field(self, value: Optional[bool]):
        """
        Set data field with field name 'MmForceIdvRegistration' on this record model
        """
        self.set_field_value(self.MMFORCEIDVREGISTRATION__FIELD_NAME.field_name, value)

    def get_MmForceIdvRegistration_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'MmForceIdvRegistration' from this record model
        """
        return self.get_field_value(self.MMFORCEIDVREGISTRATION__FIELD_NAME.field_name)

    def set_MmSampleFieldsToDisplay_field(self, value: Optional[str]):
        """
        Set data field with field name 'MmSampleFieldsToDisplay' on this record model
        """
        self.set_field_value(self.MMSAMPLEFIELDSTODISPLAY__FIELD_NAME.field_name, value)

    def get_MmSampleFieldsToDisplay_field(self) -> Optional[str]:
        """
        Get data field value with field name 'MmSampleFieldsToDisplay' from this record model
        """
        return self.get_field_value(self.MMSAMPLEFIELDSTODISPLAY__FIELD_NAME.field_name)

    def set_MultiLayerPlatePoolIfSameType_field(self, value: Optional[bool]):
        """
        Set data field with field name 'MultiLayerPlatePoolIfSameType' on this record model
        """
        self.set_field_value(self.MULTILAYERPLATEPOOLIFSAMETYPE__FIELD_NAME.field_name, value)

    def get_MultiLayerPlatePoolIfSameType_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'MultiLayerPlatePoolIfSameType' from this record model
        """
        return self.get_field_value(self.MULTILAYERPLATEPOOLIFSAMETYPE__FIELD_NAME.field_name)

    def set_NativePyExecPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'NativePyExecPath' on this record model
        """
        self.set_field_value(self.NATIVEPYEXECPATH__FIELD_NAME.field_name, value)

    def get_NativePyExecPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NativePyExecPath' from this record model
        """
        return self.get_field_value(self.NATIVEPYEXECPATH__FIELD_NAME.field_name)

    def set_NativeRExecPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'NativeRExecPath' on this record model
        """
        self.set_field_value(self.NATIVEREXECPATH__FIELD_NAME.field_name, value)

    def get_NativeRExecPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NativeRExecPath' from this record model
        """
        return self.get_field_value(self.NATIVEREXECPATH__FIELD_NAME.field_name)

    def set_NewConsumableDirName_field(self, value: Optional[str]):
        """
        Set data field with field name 'NewConsumableDirName' on this record model
        """
        self.set_field_value(self.NEWCONSUMABLEDIRNAME__FIELD_NAME.field_name, value)

    def get_NewConsumableDirName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NewConsumableDirName' from this record model
        """
        return self.get_field_value(self.NEWCONSUMABLEDIRNAME__FIELD_NAME.field_name)

    def set_NotificationUsers_field(self, value: Optional[str]):
        """
        Set data field with field name 'NotificationUsers' on this record model
        """
        self.set_field_value(self.NOTIFICATIONUSERS__FIELD_NAME.field_name, value)

    def get_NotificationUsers_field(self) -> Optional[str]:
        """
        Get data field value with field name 'NotificationUsers' from this record model
        """
        return self.get_field_value(self.NOTIFICATIONUSERS__FIELD_NAME.field_name)

    def set_NotifyMaintTechnicians_field(self, value: Optional[bool]):
        """
        Set data field with field name 'NotifyMaintTechnicians' on this record model
        """
        self.set_field_value(self.NOTIFYMAINTTECHNICIANS__FIELD_NAME.field_name, value)

    def get_NotifyMaintTechnicians_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'NotifyMaintTechnicians' from this record model
        """
        return self.get_field_value(self.NOTIFYMAINTTECHNICIANS__FIELD_NAME.field_name)

    def set_OverrideGroups_field(self, value: Optional[str]):
        """
        Set data field with field name 'OverrideGroups' on this record model
        """
        self.set_field_value(self.OVERRIDEGROUPS__FIELD_NAME.field_name, value)

    def get_OverrideGroups_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OverrideGroups' from this record model
        """
        return self.get_field_value(self.OVERRIDEGROUPS__FIELD_NAME.field_name)

    def set_PlasmidDataType_field(self, value: Optional[str]):
        """
        Set data field with field name 'PlasmidDataType' on this record model
        """
        self.set_field_value(self.PLASMIDDATATYPE__FIELD_NAME.field_name, value)

    def get_PlasmidDataType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PlasmidDataType' from this record model
        """
        return self.get_field_value(self.PLASMIDDATATYPE__FIELD_NAME.field_name)

    def set_PlateDesignerPrimaryTypes_field(self, value: Optional[str]):
        """
        Set data field with field name 'PlateDesignerPrimaryTypes' on this record model
        """
        self.set_field_value(self.PLATEDESIGNERPRIMARYTYPES__FIELD_NAME.field_name, value)

    def get_PlateDesignerPrimaryTypes_field(self) -> Optional[str]:
        """
        Get data field value with field name 'PlateDesignerPrimaryTypes' from this record model
        """
        return self.get_field_value(self.PLATEDESIGNERPRIMARYTYPES__FIELD_NAME.field_name)

    def set_Port_field(self, value: Optional[int]):
        """
        Set data field with field name 'Port' on this record model
        """
        self.set_field_value(self.PORT__FIELD_NAME.field_name, value)

    def get_Port_field(self) -> Optional[int]:
        """
        Get data field value with field name 'Port' from this record model
        """
        return self.get_field_value(self.PORT__FIELD_NAME.field_name)

    def set_PreNotificationInterval_field(self, value: Optional[int]):
        """
        Set data field with field name 'PreNotificationInterval' on this record model
        """
        self.set_field_value(self.PRENOTIFICATIONINTERVAL__FIELD_NAME.field_name, value)

    def get_PreNotificationInterval_field(self) -> Optional[int]:
        """
        Get data field value with field name 'PreNotificationInterval' from this record model
        """
        return self.get_field_value(self.PRENOTIFICATIONINTERVAL__FIELD_NAME.field_name)

    def set_PrintConsumableBarcode_field(self, value: Optional[bool]):
        """
        Set data field with field name 'PrintConsumableBarcode' on this record model
        """
        self.set_field_value(self.PRINTCONSUMABLEBARCODE__FIELD_NAME.field_name, value)

    def get_PrintConsumableBarcode_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'PrintConsumableBarcode' from this record model
        """
        return self.get_field_value(self.PRINTCONSUMABLEBARCODE__FIELD_NAME.field_name)

    def set_QCMailingList_field(self, value: Optional[str]):
        """
        Set data field with field name 'QCMailingList' on this record model
        """
        self.set_field_value(self.QCMAILINGLIST__FIELD_NAME.field_name, value)

    def get_QCMailingList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'QCMailingList' from this record model
        """
        return self.get_field_value(self.QCMAILINGLIST__FIELD_NAME.field_name)

    def set_QuantityTracking_field(self, value: Optional[bool]):
        """
        Set data field with field name 'QuantityTracking' on this record model
        """
        self.set_field_value(self.QUANTITYTRACKING__FIELD_NAME.field_name, value)

    def get_QuantityTracking_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'QuantityTracking' from this record model
        """
        return self.get_field_value(self.QUANTITYTRACKING__FIELD_NAME.field_name)

    def set_RTransExecPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'RTransExecPath' on this record model
        """
        self.set_field_value(self.RTRANSEXECPATH__FIELD_NAME.field_name, value)

    def get_RTransExecPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RTransExecPath' from this record model
        """
        return self.get_field_value(self.RTRANSEXECPATH__FIELD_NAME.field_name)

    def set_RecordReportAccessGroups_field(self, value: Optional[str]):
        """
        Set data field with field name 'RecordReportAccessGroups' on this record model
        """
        self.set_field_value(self.RECORDREPORTACCESSGROUPS__FIELD_NAME.field_name, value)

    def get_RecordReportAccessGroups_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RecordReportAccessGroups' from this record model
        """
        return self.get_field_value(self.RECORDREPORTACCESSGROUPS__FIELD_NAME.field_name)

    def set_RecordReportDataTypeList_field(self, value: Optional[str]):
        """
        Set data field with field name 'RecordReportDataTypeList' on this record model
        """
        self.set_field_value(self.RECORDREPORTDATATYPELIST__FIELD_NAME.field_name, value)

    def get_RecordReportDataTypeList_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RecordReportDataTypeList' from this record model
        """
        return self.get_field_value(self.RECORDREPORTDATATYPELIST__FIELD_NAME.field_name)

    def set_RecordStorageEvents_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RecordStorageEvents' on this record model
        """
        self.set_field_value(self.RECORDSTORAGEEVENTS__FIELD_NAME.field_name, value)

    def get_RecordStorageEvents_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RecordStorageEvents' from this record model
        """
        return self.get_field_value(self.RECORDSTORAGEEVENTS__FIELD_NAME.field_name)

    def set_ReqPortalManifestFieldNames_field(self, value: Optional[str]):
        """
        Set data field with field name 'ReqPortalManifestFieldNames' on this record model
        """
        self.set_field_value(self.REQPORTALMANIFESTFIELDNAMES__FIELD_NAME.field_name, value)

    def get_ReqPortalManifestFieldNames_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ReqPortalManifestFieldNames' from this record model
        """
        return self.get_field_value(self.REQPORTALMANIFESTFIELDNAMES__FIELD_NAME.field_name)

    def set_RequireESignature_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RequireESignature' on this record model
        """
        self.set_field_value(self.REQUIREESIGNATURE__FIELD_NAME.field_name, value)

    def get_RequireESignature_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RequireESignature' from this record model
        """
        return self.get_field_value(self.REQUIREESIGNATURE__FIELD_NAME.field_name)

    def set_RestrictAccessByLocation_field(self, value: Optional[bool]):
        """
        Set data field with field name 'RestrictAccessByLocation' on this record model
        """
        self.set_field_value(self.RESTRICTACCESSBYLOCATION__FIELD_NAME.field_name, value)

    def get_RestrictAccessByLocation_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'RestrictAccessByLocation' from this record model
        """
        return self.get_field_value(self.RESTRICTACCESSBYLOCATION__FIELD_NAME.field_name)

    def set_ReviewerVisibleRoleType_field(self, value: Optional[bool]):
        """
        Set data field with field name 'ReviewerVisibleRoleType' on this record model
        """
        self.set_field_value(self.REVIEWERVISIBLEROLETYPE__FIELD_NAME.field_name, value)

    def get_ReviewerVisibleRoleType_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'ReviewerVisibleRoleType' from this record model
        """
        return self.get_field_value(self.REVIEWERVISIBLEROLETYPE__FIELD_NAME.field_name)

    def set_S3AccessKeyId_field(self, value: Optional[str]):
        """
        Set data field with field name 'S3AccessKeyId' on this record model
        """
        self.set_field_value(self.S3ACCESSKEYID__FIELD_NAME.field_name, value)

    def get_S3AccessKeyId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'S3AccessKeyId' from this record model
        """
        return self.get_field_value(self.S3ACCESSKEYID__FIELD_NAME.field_name)

    def set_S3SecretAcessKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'S3SecretAcessKey' on this record model
        """
        self.set_field_value(self.S3SECRETACESSKEY__FIELD_NAME.field_name, value)

    def get_S3SecretAcessKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'S3SecretAcessKey' from this record model
        """
        return self.get_field_value(self.S3SECRETACESSKEY__FIELD_NAME.field_name)

    def set_SDMSRootPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'SDMSRootPath' on this record model
        """
        self.set_field_value(self.SDMSROOTPATH__FIELD_NAME.field_name, value)

    def get_SDMSRootPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SDMSRootPath' from this record model
        """
        return self.get_field_value(self.SDMSROOTPATH__FIELD_NAME.field_name)

    def set_SMTPServer_field(self, value: Optional[str]):
        """
        Set data field with field name 'SMTPServer' on this record model
        """
        self.set_field_value(self.SMTPSERVER__FIELD_NAME.field_name, value)

    def get_SMTPServer_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SMTPServer' from this record model
        """
        return self.get_field_value(self.SMTPSERVER__FIELD_NAME.field_name)

    def set_SaasMaxNumOfSamplesPerTrans_field(self, value: Optional[int]):
        """
        Set data field with field name 'SaasMaxNumOfSamplesPerTrans' on this record model
        """
        self.set_field_value(self.SAASMAXNUMOFSAMPLESPERTRANS__FIELD_NAME.field_name, value)

    def get_SaasMaxNumOfSamplesPerTrans_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SaasMaxNumOfSamplesPerTrans' from this record model
        """
        return self.get_field_value(self.SAASMAXNUMOFSAMPLESPERTRANS__FIELD_NAME.field_name)

    def set_SaasMaxSamples_field(self, value: Optional[int]):
        """
        Set data field with field name 'SaasMaxSamples' on this record model
        """
        self.set_field_value(self.SAASMAXSAMPLES__FIELD_NAME.field_name, value)

    def get_SaasMaxSamples_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SaasMaxSamples' from this record model
        """
        return self.get_field_value(self.SAASMAXSAMPLES__FIELD_NAME.field_name)

    def set_SaasMode_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SaasMode' on this record model
        """
        self.set_field_value(self.SAASMODE__FIELD_NAME.field_name, value)

    def get_SaasMode_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SaasMode' from this record model
        """
        return self.get_field_value(self.SAASMODE__FIELD_NAME.field_name)

    def set_SampleReceivingEmails_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleReceivingEmails' on this record model
        """
        self.set_field_value(self.SAMPLERECEIVINGEMAILS__FIELD_NAME.field_name, value)

    def get_SampleReceivingEmails_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleReceivingEmails' from this record model
        """
        return self.get_field_value(self.SAMPLERECEIVINGEMAILS__FIELD_NAME.field_name)

    def set_SampleReceivingUserMenu_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleReceivingUserMenu' on this record model
        """
        self.set_field_value(self.SAMPLERECEIVINGUSERMENU__FIELD_NAME.field_name, value)

    def get_SampleReceivingUserMenu_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleReceivingUserMenu' from this record model
        """
        return self.get_field_value(self.SAMPLERECEIVINGUSERMENU__FIELD_NAME.field_name)

    def set_SampleTypeMaximumTemperature_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleTypeMaximumTemperature' on this record model
        """
        self.set_field_value(self.SAMPLETYPEMAXIMUMTEMPERATURE__FIELD_NAME.field_name, value)

    def get_SampleTypeMaximumTemperature_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleTypeMaximumTemperature' from this record model
        """
        return self.get_field_value(self.SAMPLETYPEMAXIMUMTEMPERATURE__FIELD_NAME.field_name)

    def set_SamtoolsExecPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'SamtoolsExecPath' on this record model
        """
        self.set_field_value(self.SAMTOOLSEXECPATH__FIELD_NAME.field_name, value)

    def get_SamtoolsExecPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SamtoolsExecPath' from this record model
        """
        return self.get_field_value(self.SAMTOOLSEXECPATH__FIELD_NAME.field_name)

    def set_SecureSocketLayer_field(self, value: Optional[bool]):
        """
        Set data field with field name 'SecureSocketLayer' on this record model
        """
        self.set_field_value(self.SECURESOCKETLAYER__FIELD_NAME.field_name, value)

    def get_SecureSocketLayer_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'SecureSocketLayer' from this record model
        """
        return self.get_field_value(self.SECURESOCKETLAYER__FIELD_NAME.field_name)

    def set_SmtpUsername_field(self, value: Optional[str]):
        """
        Set data field with field name 'SmtpUsername' on this record model
        """
        self.set_field_value(self.SMTPUSERNAME__FIELD_NAME.field_name, value)

    def get_SmtpUsername_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SmtpUsername' from this record model
        """
        return self.get_field_value(self.SMTPUSERNAME__FIELD_NAME.field_name)

    def set_StorageUnitViewerFillByConfig_field(self, value: Optional[str]):
        """
        Set data field with field name 'StorageUnitViewerFillByConfig' on this record model
        """
        self.set_field_value(self.STORAGEUNITVIEWERFILLBYCONFIG__FIELD_NAME.field_name, value)

    def get_StorageUnitViewerFillByConfig_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StorageUnitViewerFillByConfig' from this record model
        """
        return self.get_field_value(self.STORAGEUNITVIEWERFILLBYCONFIG__FIELD_NAME.field_name)

    def set_SystemPassword_field(self, value: Optional[str]):
        """
        Set data field with field name 'SystemPassword' on this record model
        """
        self.set_field_value(self.SYSTEMPASSWORD__FIELD_NAME.field_name, value)

    def get_SystemPassword_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SystemPassword' from this record model
        """
        return self.get_field_value(self.SYSTEMPASSWORD__FIELD_NAME.field_name)

    def set_TLSEnabled_field(self, value: Optional[bool]):
        """
        Set data field with field name 'TLSEnabled' on this record model
        """
        self.set_field_value(self.TLSENABLED__FIELD_NAME.field_name, value)

    def get_TLSEnabled_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'TLSEnabled' from this record model
        """
        return self.get_field_value(self.TLSENABLED__FIELD_NAME.field_name)

    def set_TLSRequired_field(self, value: Optional[bool]):
        """
        Set data field with field name 'TLSRequired' on this record model
        """
        self.set_field_value(self.TLSREQUIRED__FIELD_NAME.field_name, value)

    def get_TLSRequired_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'TLSRequired' from this record model
        """
        return self.get_field_value(self.TLSREQUIRED__FIELD_NAME.field_name)

    def set_TemperatureEnforcement_field(self, value: Optional[str]):
        """
        Set data field with field name 'TemperatureEnforcement' on this record model
        """
        self.set_field_value(self.TEMPERATUREENFORCEMENT__FIELD_NAME.field_name, value)

    def get_TemperatureEnforcement_field(self) -> Optional[str]:
        """
        Get data field value with field name 'TemperatureEnforcement' from this record model
        """
        return self.get_field_value(self.TEMPERATUREENFORCEMENT__FIELD_NAME.field_name)

    def set_UseRequestDefaultLayout_field(self, value: Optional[bool]):
        """
        Set data field with field name 'UseRequestDefaultLayout' on this record model
        """
        self.set_field_value(self.USEREQUESTDEFAULTLAYOUT__FIELD_NAME.field_name, value)

    def get_UseRequestDefaultLayout_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'UseRequestDefaultLayout' from this record model
        """
        return self.get_field_value(self.USEREQUESTDEFAULTLAYOUT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_VerificationTypes_field(self, value: Optional[str]):
        """
        Set data field with field name 'VerificationTypes' on this record model
        """
        self.set_field_value(self.VERIFICATIONTYPES__FIELD_NAME.field_name, value)

    def get_VerificationTypes_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VerificationTypes' from this record model
        """
        return self.get_field_value(self.VERIFICATIONTYPES__FIELD_NAME.field_name)

    def set_WitnessVisibleRoleType_field(self, value: Optional[bool]):
        """
        Set data field with field name 'WitnessVisibleRoleType' on this record model
        """
        self.set_field_value(self.WITNESSVISIBLEROLETYPE__FIELD_NAME.field_name, value)

    def get_WitnessVisibleRoleType_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'WitnessVisibleRoleType' from this record model
        """
        return self.get_field_value(self.WITNESSVISIBLEROLETYPE__FIELD_NAME.field_name)

    def set_WriteQCInputFileToUser_field(self, value: Optional[bool]):
        """
        Set data field with field name 'WriteQCInputFileToUser' on this record model
        """
        self.set_field_value(self.WRITEQCINPUTFILETOUSER__FIELD_NAME.field_name, value)

    def get_WriteQCInputFileToUser_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'WriteQCInputFileToUser' from this record model
        """
        return self.get_field_value(self.WRITEQCINPUTFILETOUSER__FIELD_NAME.field_name)


class ExemplarLabNotebookPDFModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExemplarLabNotebookPDF
    Data Type Display Name: Sapio Lab Notebook PDF (Sapio Lab Notebook PDFs)
    Fields: FilePath, VeloxCurrentVersion, CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated
    This data type is used to store the latest PDF file that has been generated from a given notebook.
    """
    DATA_TYPE_NAME: Final[str] = 'ExemplarLabNotebookPDF'
    DISPLAY_NAME: Final[str] = "Sapio Lab Notebook PDF"
    PLURAL_DISPLAY_NAME: Final[str] = "Sapio Lab Notebook PDFs"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ExemplarSDMSFileModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExemplarSDMSFile
    Data Type Display Name: SDMS File (SDMS Files)
    Fields: FilePath, FileSourcePath, VeloxCurrentVersion, CreatedBy, InstrumentType, DateCreated, IsLoaded, DataRecordName, FileLastModifiedDate, FileHash, VeloxLastModifiedDate, FileCreationDate, VeloxLastModifiedBy, FileSize
    These are potentially very large files that will be stored as SDMS file. They will be retrieved through streamed download.
    """
    DATA_TYPE_NAME: Final[str] = 'ExemplarSDMSFile'
    DISPLAY_NAME: Final[str] = "SDMS File"
    PLURAL_DISPLAY_NAME: Final[str] = "SDMS Files"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILECREATIONDATE__FIELD_NAME: Final[WrapperField] = WrapperField("FileCreationDate", FieldType.DATE, display_name="File Creation Date")
    FILEHASH__FIELD_NAME: Final[WrapperField] = WrapperField("FileHash", FieldType.STRING, display_name="File Hash")
    FILELASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("FileLastModifiedDate", FieldType.DATE, display_name="File Last Modified Date")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    FILESIZE__FIELD_NAME: Final[WrapperField] = WrapperField("FileSize", FieldType.LONG, display_name="File Size (Bytes)")
    FILESOURCEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FileSourcePath", FieldType.STRING, display_name="File Source Path")
    INSTRUMENTTYPE__FIELD_NAME: Final[WrapperField] = WrapperField("InstrumentType", FieldType.STRING, display_name="Instrument Type")
    ISLOADED__FIELD_NAME: Final[WrapperField] = WrapperField("IsLoaded", FieldType.BOOLEAN, display_name="Is Loaded")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FileCreationDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'FileCreationDate' on this record model
        """
        self.set_field_value(self.FILECREATIONDATE__FIELD_NAME.field_name, value)

    def get_FileCreationDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'FileCreationDate' from this record model
        """
        return self.get_field_value(self.FILECREATIONDATE__FIELD_NAME.field_name)

    def set_FileHash_field(self, value: Optional[str]):
        """
        Set data field with field name 'FileHash' on this record model
        """
        self.set_field_value(self.FILEHASH__FIELD_NAME.field_name, value)

    def get_FileHash_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FileHash' from this record model
        """
        return self.get_field_value(self.FILEHASH__FIELD_NAME.field_name)

    def set_FileLastModifiedDate_field(self, value: Optional[int]):
        """
        Set data field with field name 'FileLastModifiedDate' on this record model
        """
        self.set_field_value(self.FILELASTMODIFIEDDATE__FIELD_NAME.field_name, value)

    def get_FileLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'FileLastModifiedDate' from this record model
        """
        return self.get_field_value(self.FILELASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_FileSize_field(self, value: Optional[int]):
        """
        Set data field with field name 'FileSize' on this record model
        """
        self.set_field_value(self.FILESIZE__FIELD_NAME.field_name, value)

    def get_FileSize_field(self) -> Optional[int]:
        """
        Get data field value with field name 'FileSize' from this record model
        """
        return self.get_field_value(self.FILESIZE__FIELD_NAME.field_name)

    def set_FileSourcePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FileSourcePath' on this record model
        """
        self.set_field_value(self.FILESOURCEPATH__FIELD_NAME.field_name, value)

    def get_FileSourcePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FileSourcePath' from this record model
        """
        return self.get_field_value(self.FILESOURCEPATH__FIELD_NAME.field_name)

    def set_InstrumentType_field(self, value: Optional[str]):
        """
        Set data field with field name 'InstrumentType' on this record model
        """
        self.set_field_value(self.INSTRUMENTTYPE__FIELD_NAME.field_name, value)

    def get_InstrumentType_field(self) -> Optional[str]:
        """
        Get data field value with field name 'InstrumentType' from this record model
        """
        return self.get_field_value(self.INSTRUMENTTYPE__FIELD_NAME.field_name)

    def set_IsLoaded_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsLoaded' on this record model
        """
        self.set_field_value(self.ISLOADED__FIELD_NAME.field_name, value)

    def get_IsLoaded_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsLoaded' from this record model
        """
        return self.get_field_value(self.ISLOADED__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ExperimentGroupModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExperimentGroup
    Data Type Display Name: Experiment Group (Experiment Groups)
    Fields: GroupMonth, GroupYear, CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated
    """
    DATA_TYPE_NAME: Final[str] = 'ExperimentGroup'
    DISPLAY_NAME: Final[str] = "Experiment Group"
    PLURAL_DISPLAY_NAME: Final[str] = "Experiment Groups"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    GROUPMONTH__FIELD_NAME: Final[WrapperField] = WrapperField("GroupMonth", FieldType.PICKLIST, display_name="Group Month")
    GROUPYEAR__FIELD_NAME: Final[WrapperField] = WrapperField("GroupYear", FieldType.SHORT, display_name="Group Year")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_GroupMonth_field(self, value: Optional[str]):
        """
        Set data field with field name 'GroupMonth' on this record model
        """
        self.set_field_value(self.GROUPMONTH__FIELD_NAME.field_name, value)

    def get_GroupMonth_field(self) -> Optional[str]:
        """
        Get data field value with field name 'GroupMonth' from this record model
        """
        return self.get_field_value(self.GROUPMONTH__FIELD_NAME.field_name)

    def set_GroupYear_field(self, value: Optional[int]):
        """
        Set data field with field name 'GroupYear' on this record model
        """
        self.set_field_value(self.GROUPYEAR__FIELD_NAME.field_name, value)

    def get_GroupYear_field(self) -> Optional[int]:
        """
        Get data field value with field name 'GroupYear' from this record model
        """
        return self.get_field_value(self.GROUPYEAR__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class ExpoentialDecayModelModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExpoentialDecayModel
    Data Type Display Name: Exponential Decay Model (Exponential Decay Models)
    Fields: MultiParentLink215, EntryName, RSquared, c, CreatedBy, d, e, RSE, RSEDOF, DateCreated, Formula, DataRecordName, SeriesName, SourceEntryId, VeloxLastModifiedDate, VeloxLastModifiedBy
    Exponential Decay follows this formula:

Y = c + (d-c) exp(-x/e)
    """
    DATA_TYPE_NAME: Final[str] = 'ExpoentialDecayModel'
    DISPLAY_NAME: Final[str] = "Exponential Decay Model"
    PLURAL_DISPLAY_NAME: Final[str] = "Exponential Decay Models"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    ENTRYNAME__FIELD_NAME: Final[WrapperField] = WrapperField("EntryName", FieldType.STRING, display_name="Entry Name")
    FORMULA__FIELD_NAME: Final[WrapperField] = WrapperField("Formula", FieldType.STRING, display_name="Formula")
    MULTIPARENTLINK215__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK, display_name="Linked Sample")
    RSE__FIELD_NAME: Final[WrapperField] = WrapperField("RSE", FieldType.DOUBLE, display_name="Residual Standard Error")
    RSEDOF__FIELD_NAME: Final[WrapperField] = WrapperField("RSEDOF", FieldType.DOUBLE, display_name="RSE Degree of Freedom")
    RSQUARED__FIELD_NAME: Final[WrapperField] = WrapperField("RSquared", FieldType.DOUBLE, display_name="R Squared")
    SERIESNAME__FIELD_NAME: Final[WrapperField] = WrapperField("SeriesName", FieldType.STRING, display_name="Series Name")
    SOURCEENTRYID__FIELD_NAME: Final[WrapperField] = WrapperField("SourceEntryId", FieldType.LONG, display_name="Source Entry ID")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    C__FIELD_NAME: Final[WrapperField] = WrapperField("c", FieldType.DOUBLE, display_name="c")
    D__FIELD_NAME: Final[WrapperField] = WrapperField("d", FieldType.DOUBLE, display_name="d")
    E__FIELD_NAME: Final[WrapperField] = WrapperField("e", FieldType.DOUBLE, display_name="e")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_EntryName_field(self, value: Optional[str]):
        """
        Set data field with field name 'EntryName' on this record model
        """
        self.set_field_value(self.ENTRYNAME__FIELD_NAME.field_name, value)

    def get_EntryName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'EntryName' from this record model
        """
        return self.get_field_value(self.ENTRYNAME__FIELD_NAME.field_name)

    def set_Formula_field(self, value: Optional[str]):
        """
        Set data field with field name 'Formula' on this record model
        """
        self.set_field_value(self.FORMULA__FIELD_NAME.field_name, value)

    def get_Formula_field(self) -> Optional[str]:
        """
        Get data field value with field name 'Formula' from this record model
        """
        return self.get_field_value(self.FORMULA__FIELD_NAME.field_name)

    def set_RSE_field(self, value: Optional[float]):
        """
        Set data field with field name 'RSE' on this record model
        """
        self.set_field_value(self.RSE__FIELD_NAME.field_name, value)

    def get_RSE_field(self) -> Optional[float]:
        """
        Get data field value with field name 'RSE' from this record model
        """
        return self.get_field_value(self.RSE__FIELD_NAME.field_name)

    def set_RSEDOF_field(self, value: Optional[float]):
        """
        Set data field with field name 'RSEDOF' on this record model
        """
        self.set_field_value(self.RSEDOF__FIELD_NAME.field_name, value)

    def get_RSEDOF_field(self) -> Optional[float]:
        """
        Get data field value with field name 'RSEDOF' from this record model
        """
        return self.get_field_value(self.RSEDOF__FIELD_NAME.field_name)

    def set_RSquared_field(self, value: Optional[float]):
        """
        Set data field with field name 'RSquared' on this record model
        """
        self.set_field_value(self.RSQUARED__FIELD_NAME.field_name, value)

    def get_RSquared_field(self) -> Optional[float]:
        """
        Get data field value with field name 'RSquared' from this record model
        """
        return self.get_field_value(self.RSQUARED__FIELD_NAME.field_name)

    def set_SeriesName_field(self, value: Optional[str]):
        """
        Set data field with field name 'SeriesName' on this record model
        """
        self.set_field_value(self.SERIESNAME__FIELD_NAME.field_name, value)

    def get_SeriesName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SeriesName' from this record model
        """
        return self.get_field_value(self.SERIESNAME__FIELD_NAME.field_name)

    def set_SourceEntryId_field(self, value: Optional[int]):
        """
        Set data field with field name 'SourceEntryId' on this record model
        """
        self.set_field_value(self.SOURCEENTRYID__FIELD_NAME.field_name, value)

    def get_SourceEntryId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'SourceEntryId' from this record model
        """
        return self.get_field_value(self.SOURCEENTRYID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_c_field(self, value: Optional[float]):
        """
        Set data field with field name 'c' on this record model
        """
        self.set_field_value(self.C__FIELD_NAME.field_name, value)

    def get_c_field(self) -> Optional[float]:
        """
        Get data field value with field name 'c' from this record model
        """
        return self.get_field_value(self.C__FIELD_NAME.field_name)

    def set_d_field(self, value: Optional[float]):
        """
        Set data field with field name 'd' on this record model
        """
        self.set_field_value(self.D__FIELD_NAME.field_name, value)

    def get_d_field(self) -> Optional[float]:
        """
        Get data field value with field name 'd' from this record model
        """
        return self.get_field_value(self.D__FIELD_NAME.field_name)

    def set_e_field(self, value: Optional[float]):
        """
        Set data field with field name 'e' on this record model
        """
        self.set_field_value(self.E__FIELD_NAME.field_name, value)

    def get_e_field(self) -> Optional[float]:
        """
        Get data field value with field name 'e' from this record model
        """
        return self.get_field_value(self.E__FIELD_NAME.field_name)


class ExponentialDecayRegParameterModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type ExponentialDecayRegParameter
    Data Type Display Name: Exponential Decay Regression Parameters (Exponential Decay Regression Parameters)
    Fields: CreatedBy, DataRecordName, Intercept, VeloxLastModifiedDate, VeloxLastModifiedBy, DecayRate, DateCreated, OriginalAmount
    """
    DATA_TYPE_NAME: Final[str] = 'ExponentialDecayRegParameter'
    DISPLAY_NAME: Final[str] = "Exponential Decay Regression Parameters"
    PLURAL_DISPLAY_NAME: Final[str] = "Exponential Decay Regression Parameters"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    DECAYRATE__FIELD_NAME: Final[WrapperField] = WrapperField("DecayRate", FieldType.DOUBLE, display_name="Decay Rate")
    INTERCEPT__FIELD_NAME: Final[WrapperField] = WrapperField("Intercept", FieldType.DOUBLE, display_name="Intercept")
    ORIGINALAMOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("OriginalAmount", FieldType.DOUBLE, display_name="Original Amount")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_DecayRate_field(self, value: Optional[float]):
        """
        Set data field with field name 'DecayRate' on this record model
        """
        self.set_field_value(self.DECAYRATE__FIELD_NAME.field_name, value)

    def get_DecayRate_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DecayRate' from this record model
        """
        return self.get_field_value(self.DECAYRATE__FIELD_NAME.field_name)

    def set_Intercept_field(self, value: Optional[float]):
        """
        Set data field with field name 'Intercept' on this record model
        """
        self.set_field_value(self.INTERCEPT__FIELD_NAME.field_name, value)

    def get_Intercept_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Intercept' from this record model
        """
        return self.get_field_value(self.INTERCEPT__FIELD_NAME.field_name)

    def set_OriginalAmount_field(self, value: Optional[float]):
        """
        Set data field with field name 'OriginalAmount' on this record model
        """
        self.set_field_value(self.ORIGINALAMOUNT__FIELD_NAME.field_name, value)

    def get_OriginalAmount_field(self) -> Optional[float]:
        """
        Get data field value with field name 'OriginalAmount' from this record model
        """
        return self.get_field_value(self.ORIGINALAMOUNT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FailedSampleDetailsModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FailedSampleDetails
    Data Type Display Name: Failure Details (Failure Details)
    Fields: CreatedBy, DateCreated, ActiveTaskName, OtherSampleId, DataRecordName, FailureComment, VeloxLastModifiedDate, VeloxLastModifiedBy, ActiveWorkflowName, FailureStatus, SampleId
    """
    DATA_TYPE_NAME: Final[str] = 'FailedSampleDetails'
    DISPLAY_NAME: Final[str] = "Failure Details"
    PLURAL_DISPLAY_NAME: Final[str] = "Failure Details"
    ACTIVETASKNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ActiveTaskName", FieldType.STRING, display_name="Task / Entry Name")
    ACTIVEWORKFLOWNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ActiveWorkflowName", FieldType.STRING, display_name="Workflow / Experiment Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FAILURECOMMENT__FIELD_NAME: Final[WrapperField] = WrapperField("FailureComment", FieldType.STRING, display_name="Failure Comment")
    FAILURESTATUS__FIELD_NAME: Final[WrapperField] = WrapperField("FailureStatus", FieldType.PICKLIST, display_name="Status")
    OTHERSAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("OtherSampleId", FieldType.STRING, display_name="Name")
    SAMPLEID__FIELD_NAME: Final[WrapperField] = WrapperField("SampleId", FieldType.STRING, display_name="ID")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ActiveTaskName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ActiveTaskName' on this record model
        """
        self.set_field_value(self.ACTIVETASKNAME__FIELD_NAME.field_name, value)

    def get_ActiveTaskName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ActiveTaskName' from this record model
        """
        return self.get_field_value(self.ACTIVETASKNAME__FIELD_NAME.field_name)

    def set_ActiveWorkflowName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ActiveWorkflowName' on this record model
        """
        self.set_field_value(self.ACTIVEWORKFLOWNAME__FIELD_NAME.field_name, value)

    def get_ActiveWorkflowName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ActiveWorkflowName' from this record model
        """
        return self.get_field_value(self.ACTIVEWORKFLOWNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FailureComment_field(self, value: Optional[str]):
        """
        Set data field with field name 'FailureComment' on this record model
        """
        self.set_field_value(self.FAILURECOMMENT__FIELD_NAME.field_name, value)

    def get_FailureComment_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FailureComment' from this record model
        """
        return self.get_field_value(self.FAILURECOMMENT__FIELD_NAME.field_name)

    def set_FailureStatus_field(self, value: Optional[str]):
        """
        Set data field with field name 'FailureStatus' on this record model
        """
        self.set_field_value(self.FAILURESTATUS__FIELD_NAME.field_name, value)

    def get_FailureStatus_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FailureStatus' from this record model
        """
        return self.get_field_value(self.FAILURESTATUS__FIELD_NAME.field_name)

    def set_OtherSampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'OtherSampleId' on this record model
        """
        self.set_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name, value)

    def get_OtherSampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'OtherSampleId' from this record model
        """
        return self.get_field_value(self.OTHERSAMPLEID__FIELD_NAME.field_name)

    def set_SampleId_field(self, value: Optional[str]):
        """
        Set data field with field name 'SampleId' on this record model
        """
        self.set_field_value(self.SAMPLEID__FIELD_NAME.field_name, value)

    def get_SampleId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'SampleId' from this record model
        """
        return self.get_field_value(self.SAMPLEID__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FCSFileModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FCSFile
    Data Type Display Name: Flow Cytometry Standard File (Flow Cytometry Standard Files)
    Fields: FilePath, PercentCellsToTopLevel, TotalNumberOfCells, VeloxCurrentVersion, CreatedBy, RootFCSRecordId, DateCreated, IsMetadataLoaded, IsDataComplete, DataRecordName, PercentCellsToParentLevel, VeloxLastModifiedDate, VeloxLastModifiedBy, IsTopLevel
    """
    DATA_TYPE_NAME: Final[str] = 'FCSFile'
    DISPLAY_NAME: Final[str] = "Flow Cytometry Standard File"
    PLURAL_DISPLAY_NAME: Final[str] = "Flow Cytometry Standard Files"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    ISDATACOMPLETE__FIELD_NAME: Final[WrapperField] = WrapperField("IsDataComplete", FieldType.BOOLEAN, display_name="Is Data Complete")
    ISMETADATALOADED__FIELD_NAME: Final[WrapperField] = WrapperField("IsMetadataLoaded", FieldType.BOOLEAN, display_name="Is Metadata Loaded")
    ISTOPLEVEL__FIELD_NAME: Final[WrapperField] = WrapperField("IsTopLevel", FieldType.BOOLEAN, display_name="Is Top Level")
    PERCENTCELLSTOPARENTLEVEL__FIELD_NAME: Final[WrapperField] = WrapperField("PercentCellsToParentLevel", FieldType.DOUBLE, display_name="Percent Cells To Parent Level")
    PERCENTCELLSTOTOPLEVEL__FIELD_NAME: Final[WrapperField] = WrapperField("PercentCellsToTopLevel", FieldType.DOUBLE, display_name="Percent Cells To Top Level")
    ROOTFCSRECORDID__FIELD_NAME: Final[WrapperField] = WrapperField("RootFCSRecordId", FieldType.LONG, display_name="Root FCS Record Id")
    TOTALNUMBEROFCELLS__FIELD_NAME: Final[WrapperField] = WrapperField("TotalNumberOfCells", FieldType.LONG, display_name="Total Number Of Cells")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_IsDataComplete_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsDataComplete' on this record model
        """
        self.set_field_value(self.ISDATACOMPLETE__FIELD_NAME.field_name, value)

    def get_IsDataComplete_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsDataComplete' from this record model
        """
        return self.get_field_value(self.ISDATACOMPLETE__FIELD_NAME.field_name)

    def set_IsMetadataLoaded_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsMetadataLoaded' on this record model
        """
        self.set_field_value(self.ISMETADATALOADED__FIELD_NAME.field_name, value)

    def get_IsMetadataLoaded_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsMetadataLoaded' from this record model
        """
        return self.get_field_value(self.ISMETADATALOADED__FIELD_NAME.field_name)

    def set_IsTopLevel_field(self, value: Optional[bool]):
        """
        Set data field with field name 'IsTopLevel' on this record model
        """
        self.set_field_value(self.ISTOPLEVEL__FIELD_NAME.field_name, value)

    def get_IsTopLevel_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'IsTopLevel' from this record model
        """
        return self.get_field_value(self.ISTOPLEVEL__FIELD_NAME.field_name)

    def set_PercentCellsToParentLevel_field(self, value: Optional[float]):
        """
        Set data field with field name 'PercentCellsToParentLevel' on this record model
        """
        self.set_field_value(self.PERCENTCELLSTOPARENTLEVEL__FIELD_NAME.field_name, value)

    def get_PercentCellsToParentLevel_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PercentCellsToParentLevel' from this record model
        """
        return self.get_field_value(self.PERCENTCELLSTOPARENTLEVEL__FIELD_NAME.field_name)

    def set_PercentCellsToTopLevel_field(self, value: Optional[float]):
        """
        Set data field with field name 'PercentCellsToTopLevel' on this record model
        """
        self.set_field_value(self.PERCENTCELLSTOTOPLEVEL__FIELD_NAME.field_name, value)

    def get_PercentCellsToTopLevel_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PercentCellsToTopLevel' from this record model
        """
        return self.get_field_value(self.PERCENTCELLSTOTOPLEVEL__FIELD_NAME.field_name)

    def set_RootFCSRecordId_field(self, value: Optional[int]):
        """
        Set data field with field name 'RootFCSRecordId' on this record model
        """
        self.set_field_value(self.ROOTFCSRECORDID__FIELD_NAME.field_name, value)

    def get_RootFCSRecordId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RootFCSRecordId' from this record model
        """
        return self.get_field_value(self.ROOTFCSRECORDID__FIELD_NAME.field_name)

    def set_TotalNumberOfCells_field(self, value: Optional[int]):
        """
        Set data field with field name 'TotalNumberOfCells' on this record model
        """
        self.set_field_value(self.TOTALNUMBEROFCELLS__FIELD_NAME.field_name, value)

    def get_TotalNumberOfCells_field(self) -> Optional[int]:
        """
        Get data field value with field name 'TotalNumberOfCells' from this record model
        """
        return self.get_field_value(self.TOTALNUMBEROFCELLS__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FCSStatisticModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FCSStatistic
    Data Type Display Name: Flow Cytometry Statistic (Flow Cytometry Statistic)
    Fields: ChannelName, CreatedBy, DataRecordName, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, NumericValue, StatName
    A statistic record for FCS file, usually for a specific channel so they are not suited directly added to the FCSFile record.
    """
    DATA_TYPE_NAME: Final[str] = 'FCSStatistic'
    DISPLAY_NAME: Final[str] = "Flow Cytometry Statistic"
    PLURAL_DISPLAY_NAME: Final[str] = "Flow Cytometry Statistic"
    CHANNELNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ChannelName", FieldType.STRING, display_name="Channel")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    NUMERICVALUE__FIELD_NAME: Final[WrapperField] = WrapperField("NumericValue", FieldType.DOUBLE, display_name="Numeric Value")
    STATNAME__FIELD_NAME: Final[WrapperField] = WrapperField("StatName", FieldType.STRING, display_name="Name")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ChannelName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ChannelName' on this record model
        """
        self.set_field_value(self.CHANNELNAME__FIELD_NAME.field_name, value)

    def get_ChannelName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ChannelName' from this record model
        """
        return self.get_field_value(self.CHANNELNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_NumericValue_field(self, value: Optional[float]):
        """
        Set data field with field name 'NumericValue' on this record model
        """
        self.set_field_value(self.NUMERICVALUE__FIELD_NAME.field_name, value)

    def get_NumericValue_field(self) -> Optional[float]:
        """
        Get data field value with field name 'NumericValue' from this record model
        """
        return self.get_field_value(self.NUMERICVALUE__FIELD_NAME.field_name)

    def set_StatName_field(self, value: Optional[str]):
        """
        Set data field with field name 'StatName' on this record model
        """
        self.set_field_value(self.STATNAME__FIELD_NAME.field_name, value)

    def get_StatName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StatName' from this record model
        """
        return self.get_field_value(self.STATNAME__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FermentationResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FermentationResult
    Data Type Display Name: Fermentation Result (Fermentation Results)
    Fields: Temperature, O2, CreatedBy, DO1, DateCreated, AIR, OUR, AGIT, CER, DataRecordName, VeloxLastModifiedDate, PH, VeloxLastModifiedBy, LH, TOTFLOW
    """
    DATA_TYPE_NAME: Final[str] = 'FermentationResult'
    DISPLAY_NAME: Final[str] = "Fermentation Result"
    PLURAL_DISPLAY_NAME: Final[str] = "Fermentation Results"
    AGIT__FIELD_NAME: Final[WrapperField] = WrapperField("AGIT", FieldType.DOUBLE, display_name="Agitation (rpm)")
    AIR__FIELD_NAME: Final[WrapperField] = WrapperField("AIR", FieldType.DOUBLE, display_name="AIR (lpm)")
    CER__FIELD_NAME: Final[WrapperField] = WrapperField("CER", FieldType.DOUBLE, display_name="Carbon Dioxide Evolution Rate (mmol/L-hr)")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DO1__FIELD_NAME: Final[WrapperField] = WrapperField("DO1", FieldType.DOUBLE, display_name="Dissolved Oxygen (%)")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    LH__FIELD_NAME: Final[WrapperField] = WrapperField("LH", FieldType.DOUBLE, display_name="Log Hour")
    O2__FIELD_NAME: Final[WrapperField] = WrapperField("O2", FieldType.DOUBLE, display_name="Oxygen (lpm)")
    OUR__FIELD_NAME: Final[WrapperField] = WrapperField("OUR", FieldType.DOUBLE, display_name="Oxygen Uptake Rate (mmol/L-hr)")
    PH__FIELD_NAME: Final[WrapperField] = WrapperField("PH", FieldType.DOUBLE, display_name="PH")
    TOTFLOW__FIELD_NAME: Final[WrapperField] = WrapperField("TOTFLOW", FieldType.DOUBLE, display_name="Total Flow (lpm)")
    TEMPERATURE__FIELD_NAME: Final[WrapperField] = WrapperField("Temperature", FieldType.DOUBLE, display_name="Temperature (C)")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AGIT_field(self, value: Optional[float]):
        """
        Set data field with field name 'AGIT' on this record model
        """
        self.set_field_value(self.AGIT__FIELD_NAME.field_name, value)

    def get_AGIT_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AGIT' from this record model
        """
        return self.get_field_value(self.AGIT__FIELD_NAME.field_name)

    def set_AIR_field(self, value: Optional[float]):
        """
        Set data field with field name 'AIR' on this record model
        """
        self.set_field_value(self.AIR__FIELD_NAME.field_name, value)

    def get_AIR_field(self) -> Optional[float]:
        """
        Get data field value with field name 'AIR' from this record model
        """
        return self.get_field_value(self.AIR__FIELD_NAME.field_name)

    def set_CER_field(self, value: Optional[float]):
        """
        Set data field with field name 'CER' on this record model
        """
        self.set_field_value(self.CER__FIELD_NAME.field_name, value)

    def get_CER_field(self) -> Optional[float]:
        """
        Get data field value with field name 'CER' from this record model
        """
        return self.get_field_value(self.CER__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def set_DO1_field(self, value: Optional[float]):
        """
        Set data field with field name 'DO1' on this record model
        """
        self.set_field_value(self.DO1__FIELD_NAME.field_name, value)

    def get_DO1_field(self) -> Optional[float]:
        """
        Get data field value with field name 'DO1' from this record model
        """
        return self.get_field_value(self.DO1__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_LH_field(self, value: Optional[float]):
        """
        Set data field with field name 'LH' on this record model
        """
        self.set_field_value(self.LH__FIELD_NAME.field_name, value)

    def get_LH_field(self) -> Optional[float]:
        """
        Get data field value with field name 'LH' from this record model
        """
        return self.get_field_value(self.LH__FIELD_NAME.field_name)

    def set_O2_field(self, value: Optional[float]):
        """
        Set data field with field name 'O2' on this record model
        """
        self.set_field_value(self.O2__FIELD_NAME.field_name, value)

    def get_O2_field(self) -> Optional[float]:
        """
        Get data field value with field name 'O2' from this record model
        """
        return self.get_field_value(self.O2__FIELD_NAME.field_name)

    def set_OUR_field(self, value: Optional[float]):
        """
        Set data field with field name 'OUR' on this record model
        """
        self.set_field_value(self.OUR__FIELD_NAME.field_name, value)

    def get_OUR_field(self) -> Optional[float]:
        """
        Get data field value with field name 'OUR' from this record model
        """
        return self.get_field_value(self.OUR__FIELD_NAME.field_name)

    def set_PH_field(self, value: Optional[float]):
        """
        Set data field with field name 'PH' on this record model
        """
        self.set_field_value(self.PH__FIELD_NAME.field_name, value)

    def get_PH_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PH' from this record model
        """
        return self.get_field_value(self.PH__FIELD_NAME.field_name)

    def set_TOTFLOW_field(self, value: Optional[float]):
        """
        Set data field with field name 'TOTFLOW' on this record model
        """
        self.set_field_value(self.TOTFLOW__FIELD_NAME.field_name, value)

    def get_TOTFLOW_field(self) -> Optional[float]:
        """
        Get data field value with field name 'TOTFLOW' from this record model
        """
        return self.get_field_value(self.TOTFLOW__FIELD_NAME.field_name)

    def set_Temperature_field(self, value: Optional[float]):
        """
        Set data field with field name 'Temperature' on this record model
        """
        self.set_field_value(self.TEMPERATURE__FIELD_NAME.field_name, value)

    def get_Temperature_field(self) -> Optional[float]:
        """
        Get data field value with field name 'Temperature' from this record model
        """
        return self.get_field_value(self.TEMPERATURE__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FileBridgeConnectionModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FileBridgeConnection
    Data Type Display Name: File Bridge Connection (File Bridge Connections)
    Fields: ConnectionName, CreatedBy, DataRecordName, VeloxLastModifiedDate, AuthToken, VeloxLastModifiedBy, DateCreated, AgentRoot, ProxyHost, ProxyPort, AesKey
    This data type describes the configuration of a File Bridge Connection to be used by Exemplar.
    """
    DATA_TYPE_NAME: Final[str] = 'FileBridgeConnection'
    DISPLAY_NAME: Final[str] = "File Bridge Connection"
    PLURAL_DISPLAY_NAME: Final[str] = "File Bridge Connections"
    AESKEY__FIELD_NAME: Final[WrapperField] = WrapperField("AesKey", FieldType.STRING, display_name="AES Key")
    AGENTROOT__FIELD_NAME: Final[WrapperField] = WrapperField("AgentRoot", FieldType.STRING, display_name="Agent Root")
    AUTHTOKEN__FIELD_NAME: Final[WrapperField] = WrapperField("AuthToken", FieldType.STRING, display_name="Auth Token")
    CONNECTIONNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ConnectionName", FieldType.STRING, display_name="Connection Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    PROXYHOST__FIELD_NAME: Final[WrapperField] = WrapperField("ProxyHost", FieldType.STRING, display_name="Proxy Host")
    PROXYPORT__FIELD_NAME: Final[WrapperField] = WrapperField("ProxyPort", FieldType.INTEGER, display_name="Proxy Port")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_AesKey_field(self, value: Optional[str]):
        """
        Set data field with field name 'AesKey' on this record model
        """
        self.set_field_value(self.AESKEY__FIELD_NAME.field_name, value)

    def get_AesKey_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AesKey' from this record model
        """
        return self.get_field_value(self.AESKEY__FIELD_NAME.field_name)

    def set_AgentRoot_field(self, value: Optional[str]):
        """
        Set data field with field name 'AgentRoot' on this record model
        """
        self.set_field_value(self.AGENTROOT__FIELD_NAME.field_name, value)

    def get_AgentRoot_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AgentRoot' from this record model
        """
        return self.get_field_value(self.AGENTROOT__FIELD_NAME.field_name)

    def set_AuthToken_field(self, value: Optional[str]):
        """
        Set data field with field name 'AuthToken' on this record model
        """
        self.set_field_value(self.AUTHTOKEN__FIELD_NAME.field_name, value)

    def get_AuthToken_field(self) -> Optional[str]:
        """
        Get data field value with field name 'AuthToken' from this record model
        """
        return self.get_field_value(self.AUTHTOKEN__FIELD_NAME.field_name)

    def set_ConnectionName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ConnectionName' on this record model
        """
        self.set_field_value(self.CONNECTIONNAME__FIELD_NAME.field_name, value)

    def get_ConnectionName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ConnectionName' from this record model
        """
        return self.get_field_value(self.CONNECTIONNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ProxyHost_field(self, value: Optional[str]):
        """
        Set data field with field name 'ProxyHost' on this record model
        """
        self.set_field_value(self.PROXYHOST__FIELD_NAME.field_name, value)

    def get_ProxyHost_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ProxyHost' from this record model
        """
        return self.get_field_value(self.PROXYHOST__FIELD_NAME.field_name)

    def set_ProxyPort_field(self, value: Optional[int]):
        """
        Set data field with field name 'ProxyPort' on this record model
        """
        self.set_field_value(self.PROXYPORT__FIELD_NAME.field_name, value)

    def get_ProxyPort_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ProxyPort' from this record model
        """
        return self.get_field_value(self.PROXYPORT__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowAIRunResultModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowAIRunResult
    Data Type Display Name: FlowAI Run result (FlowAI Run Results)
    Fields: FilePath, VeloxCurrentVersion, CreatedBy, alphaFR, DateCreated, second_fractionFR, sideFM, outlier_binsFS, DataRecordName, pen_valueFS, decompFR, VeloxLastModifiedDate, VeloxLastModifiedBy, max_cptFS
    """
    DATA_TYPE_NAME: Final[str] = 'FlowAIRunResult'
    DISPLAY_NAME: Final[str] = "FlowAI Run result"
    PLURAL_DISPLAY_NAME: Final[str] = "FlowAI Run Results"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FILEPATH__FIELD_NAME: Final[WrapperField] = WrapperField("FilePath", FieldType.STRING, display_name="File Name")
    VELOXCURRENTVERSION__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxCurrentVersion", FieldType.INTEGER, display_name="Current Version")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    ALPHAFR__FIELD_NAME: Final[WrapperField] = WrapperField("alphaFR", FieldType.DOUBLE, display_name="Alpha (Significance)")
    DECOMPFR__FIELD_NAME: Final[WrapperField] = WrapperField("decompFR", FieldType.BOOLEAN, display_name="Decompose Flow Rate")
    MAX_CPTFS__FIELD_NAME: Final[WrapperField] = WrapperField("max_cptFS", FieldType.INTEGER, display_name="Max # Changepoints / Channel")
    OUTLIER_BINSFS__FIELD_NAME: Final[WrapperField] = WrapperField("outlier_binsFS", FieldType.BOOLEAN, display_name="Remove Outlier Bins for SA")
    PEN_VALUEFS__FIELD_NAME: Final[WrapperField] = WrapperField("pen_valueFS", FieldType.STRING, display_name="Changepoint Detection Penalty")
    SECOND_FRACTIONFR__FIELD_NAME: Final[WrapperField] = WrapperField("second_fractionFR", FieldType.DOUBLE, display_name="Time Channel Split (Fraction of Second)")
    SIDEFM__FIELD_NAME: Final[WrapperField] = WrapperField("sideFM", FieldType.PICKLIST, display_name="Dynamic Range Limits")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FilePath_field(self, value: Optional[str]):
        """
        Set data field with field name 'FilePath' on this record model
        """
        self.set_field_value(self.FILEPATH__FIELD_NAME.field_name, value)

    def get_FilePath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FilePath' from this record model
        """
        return self.get_field_value(self.FILEPATH__FIELD_NAME.field_name)

    def set_VeloxCurrentVersion_field(self, value: Optional[int]):
        """
        Set data field with field name 'VeloxCurrentVersion' on this record model
        """
        self.set_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name, value)

    def get_VeloxCurrentVersion_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxCurrentVersion' from this record model
        """
        return self.get_field_value(self.VELOXCURRENTVERSION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_alphaFR_field(self, value: Optional[float]):
        """
        Set data field with field name 'alphaFR' on this record model
        """
        self.set_field_value(self.ALPHAFR__FIELD_NAME.field_name, value)

    def get_alphaFR_field(self) -> Optional[float]:
        """
        Get data field value with field name 'alphaFR' from this record model
        """
        return self.get_field_value(self.ALPHAFR__FIELD_NAME.field_name)

    def set_decompFR_field(self, value: Optional[bool]):
        """
        Set data field with field name 'decompFR' on this record model
        """
        self.set_field_value(self.DECOMPFR__FIELD_NAME.field_name, value)

    def get_decompFR_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'decompFR' from this record model
        """
        return self.get_field_value(self.DECOMPFR__FIELD_NAME.field_name)

    def set_max_cptFS_field(self, value: Optional[int]):
        """
        Set data field with field name 'max_cptFS' on this record model
        """
        self.set_field_value(self.MAX_CPTFS__FIELD_NAME.field_name, value)

    def get_max_cptFS_field(self) -> Optional[int]:
        """
        Get data field value with field name 'max_cptFS' from this record model
        """
        return self.get_field_value(self.MAX_CPTFS__FIELD_NAME.field_name)

    def set_outlier_binsFS_field(self, value: Optional[bool]):
        """
        Set data field with field name 'outlier_binsFS' on this record model
        """
        self.set_field_value(self.OUTLIER_BINSFS__FIELD_NAME.field_name, value)

    def get_outlier_binsFS_field(self) -> Optional[bool]:
        """
        Get data field value with field name 'outlier_binsFS' from this record model
        """
        return self.get_field_value(self.OUTLIER_BINSFS__FIELD_NAME.field_name)

    def set_pen_valueFS_field(self, value: Optional[str]):
        """
        Set data field with field name 'pen_valueFS' on this record model
        """
        self.set_field_value(self.PEN_VALUEFS__FIELD_NAME.field_name, value)

    def get_pen_valueFS_field(self) -> Optional[str]:
        """
        Get data field value with field name 'pen_valueFS' from this record model
        """
        return self.get_field_value(self.PEN_VALUEFS__FIELD_NAME.field_name)

    def set_second_fractionFR_field(self, value: Optional[float]):
        """
        Set data field with field name 'second_fractionFR' on this record model
        """
        self.set_field_value(self.SECOND_FRACTIONFR__FIELD_NAME.field_name, value)

    def get_second_fractionFR_field(self) -> Optional[float]:
        """
        Get data field value with field name 'second_fractionFR' from this record model
        """
        return self.get_field_value(self.SECOND_FRACTIONFR__FIELD_NAME.field_name)

    def set_sideFM_field(self, value: Optional[str]):
        """
        Set data field with field name 'sideFM' on this record model
        """
        self.set_field_value(self.SIDEFM__FIELD_NAME.field_name, value)

    def get_sideFM_field(self) -> Optional[str]:
        """
        Get data field value with field name 'sideFM' from this record model
        """
        return self.get_field_value(self.SIDEFM__FIELD_NAME.field_name)


class FlowCellModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowCell
    Data Type Display Name: Flow Cell (Flow Cells)
    Fields: PercentOccupied, OccupiedClusterCount, CreatedBy, pfClusterCount, FlowcellId, DateCreated, StorageUnitPath, RawClusterCount, DataRecordName, RowPosition, OccupancyProxyClusterCount, ColPosition, VeloxLastModifiedDate, VeloxLastModifiedBy, StorageLocationBarcode
    """
    DATA_TYPE_NAME: Final[str] = 'FlowCell'
    DISPLAY_NAME: Final[str] = "Flow Cell"
    PLURAL_DISPLAY_NAME: Final[str] = "Flow Cells"
    COLPOSITION__FIELD_NAME: Final[WrapperField] = WrapperField("ColPosition", FieldType.SELECTION, display_name="Col Position")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    FLOWCELLID__FIELD_NAME: Final[WrapperField] = WrapperField("FlowcellId", FieldType.STRING, display_name="Flowcell ID")
    OCCUPANCYPROXYCLUSTERCOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("OccupancyProxyClusterCount", FieldType.LONG, display_name="Occupancy Proxy Cluster Count")
    OCCUPIEDCLUSTERCOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("OccupiedClusterCount", FieldType.LONG, display_name="Occupied Cluster Count")
    PERCENTOCCUPIED__FIELD_NAME: Final[WrapperField] = WrapperField("PercentOccupied", FieldType.DOUBLE, display_name="Percent Occupied")
    RAWCLUSTERCOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("RawClusterCount", FieldType.LONG, display_name="Raw Cluster Count")
    ROWPOSITION__FIELD_NAME: Final[WrapperField] = WrapperField("RowPosition", FieldType.SELECTION, display_name="Row Position")
    STORAGELOCATIONBARCODE__FIELD_NAME: Final[WrapperField] = WrapperField("StorageLocationBarcode", FieldType.SELECTION, display_name="Storage Location Barcode")
    STORAGEUNITPATH__FIELD_NAME: Final[WrapperField] = WrapperField("StorageUnitPath", FieldType.STRING, display_name="Storage Location Path")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")
    PFCLUSTERCOUNT__FIELD_NAME: Final[WrapperField] = WrapperField("pfClusterCount", FieldType.LONG, display_name="PF Cluster Count")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ColPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColPosition' on this record model
        """
        self.set_field_value(self.COLPOSITION__FIELD_NAME.field_name, value)

    def get_ColPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColPosition' from this record model
        """
        return self.get_field_value(self.COLPOSITION__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_FlowcellId_field(self, value: Optional[str]):
        """
        Set data field with field name 'FlowcellId' on this record model
        """
        self.set_field_value(self.FLOWCELLID__FIELD_NAME.field_name, value)

    def get_FlowcellId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FlowcellId' from this record model
        """
        return self.get_field_value(self.FLOWCELLID__FIELD_NAME.field_name)

    def set_OccupancyProxyClusterCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'OccupancyProxyClusterCount' on this record model
        """
        self.set_field_value(self.OCCUPANCYPROXYCLUSTERCOUNT__FIELD_NAME.field_name, value)

    def get_OccupancyProxyClusterCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'OccupancyProxyClusterCount' from this record model
        """
        return self.get_field_value(self.OCCUPANCYPROXYCLUSTERCOUNT__FIELD_NAME.field_name)

    def set_OccupiedClusterCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'OccupiedClusterCount' on this record model
        """
        self.set_field_value(self.OCCUPIEDCLUSTERCOUNT__FIELD_NAME.field_name, value)

    def get_OccupiedClusterCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'OccupiedClusterCount' from this record model
        """
        return self.get_field_value(self.OCCUPIEDCLUSTERCOUNT__FIELD_NAME.field_name)

    def set_PercentOccupied_field(self, value: Optional[float]):
        """
        Set data field with field name 'PercentOccupied' on this record model
        """
        self.set_field_value(self.PERCENTOCCUPIED__FIELD_NAME.field_name, value)

    def get_PercentOccupied_field(self) -> Optional[float]:
        """
        Get data field value with field name 'PercentOccupied' from this record model
        """
        return self.get_field_value(self.PERCENTOCCUPIED__FIELD_NAME.field_name)

    def set_RawClusterCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'RawClusterCount' on this record model
        """
        self.set_field_value(self.RAWCLUSTERCOUNT__FIELD_NAME.field_name, value)

    def get_RawClusterCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'RawClusterCount' from this record model
        """
        return self.get_field_value(self.RAWCLUSTERCOUNT__FIELD_NAME.field_name)

    def set_RowPosition_field(self, value: Optional[str]):
        """
        Set data field with field name 'RowPosition' on this record model
        """
        self.set_field_value(self.ROWPOSITION__FIELD_NAME.field_name, value)

    def get_RowPosition_field(self) -> Optional[str]:
        """
        Get data field value with field name 'RowPosition' from this record model
        """
        return self.get_field_value(self.ROWPOSITION__FIELD_NAME.field_name)

    def set_StorageLocationBarcode_field(self, value: Optional[str]):
        """
        Set data field with field name 'StorageLocationBarcode' on this record model
        """
        self.set_field_value(self.STORAGELOCATIONBARCODE__FIELD_NAME.field_name, value)

    def get_StorageLocationBarcode_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StorageLocationBarcode' from this record model
        """
        return self.get_field_value(self.STORAGELOCATIONBARCODE__FIELD_NAME.field_name)

    def set_StorageUnitPath_field(self, value: Optional[str]):
        """
        Set data field with field name 'StorageUnitPath' on this record model
        """
        self.set_field_value(self.STORAGEUNITPATH__FIELD_NAME.field_name, value)

    def get_StorageUnitPath_field(self) -> Optional[str]:
        """
        Get data field value with field name 'StorageUnitPath' from this record model
        """
        return self.get_field_value(self.STORAGEUNITPATH__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)

    def set_pfClusterCount_field(self, value: Optional[int]):
        """
        Set data field with field name 'pfClusterCount' on this record model
        """
        self.set_field_value(self.PFCLUSTERCOUNT__FIELD_NAME.field_name, value)

    def get_pfClusterCount_field(self) -> Optional[int]:
        """
        Get data field value with field name 'pfClusterCount' from this record model
        """
        return self.get_field_value(self.PFCLUSTERCOUNT__FIELD_NAME.field_name)


class FlowCellLaneModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowCellLane
    Data Type Display Name: Flow Cell Lane (Flow Cell Lanes)
    Fields: ExpRecId, MultiParentLink215, CreatedBy, DataRecordName, LaneNum, FlowcellId, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated
    """
    DATA_TYPE_NAME: Final[str] = 'FlowCellLane'
    DISPLAY_NAME: Final[str] = "Flow Cell Lane"
    PLURAL_DISPLAY_NAME: Final[str] = "Flow Cell Lanes"
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    EXPRECID__FIELD_NAME: Final[WrapperField] = WrapperField("ExpRecId", FieldType.LONG, display_name="Experiment Record ID")
    FLOWCELLID__FIELD_NAME: Final[WrapperField] = WrapperField("FlowcellId", FieldType.STRING, display_name="Flowcell ID")
    LANENUM__FIELD_NAME: Final[WrapperField] = WrapperField("LaneNum", FieldType.LONG, display_name="Lane Number")
    MULTIPARENTLINK215__FIELD_NAME: Final[WrapperField] = WrapperField("MultiParentLink215", FieldType.MULTIPARENTLINK, display_name="Linked Sample")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_ExpRecId_field(self, value: Optional[int]):
        """
        Set data field with field name 'ExpRecId' on this record model
        """
        self.set_field_value(self.EXPRECID__FIELD_NAME.field_name, value)

    def get_ExpRecId_field(self) -> Optional[int]:
        """
        Get data field value with field name 'ExpRecId' from this record model
        """
        return self.get_field_value(self.EXPRECID__FIELD_NAME.field_name)

    def set_FlowcellId_field(self, value: Optional[str]):
        """
        Set data field with field name 'FlowcellId' on this record model
        """
        self.set_field_value(self.FLOWCELLID__FIELD_NAME.field_name, value)

    def get_FlowcellId_field(self) -> Optional[str]:
        """
        Get data field value with field name 'FlowcellId' from this record model
        """
        return self.get_field_value(self.FLOWCELLID__FIELD_NAME.field_name)

    def set_LaneNum_field(self, value: Optional[int]):
        """
        Set data field with field name 'LaneNum' on this record model
        """
        self.set_field_value(self.LANENUM__FIELD_NAME.field_name, value)

    def get_LaneNum_field(self) -> Optional[int]:
        """
        Get data field value with field name 'LaneNum' from this record model
        """
        return self.get_field_value(self.LANENUM__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowClustClusterModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowClustCluster
    Data Type Display Name: FlowClust Cluster (FlowClust Clusters)
    Fields: ColorHTML, CreatedBy, DataRecordName, UserAnnotation, ClusterNum, VeloxLastModifiedDate, VeloxLastModifiedBy, DateCreated, ColorName
    """
    DATA_TYPE_NAME: Final[str] = 'FlowClustCluster'
    DISPLAY_NAME: Final[str] = "FlowClust Cluster"
    PLURAL_DISPLAY_NAME: Final[str] = "FlowClust Clusters"
    CLUSTERNUM__FIELD_NAME: Final[WrapperField] = WrapperField("ClusterNum", FieldType.STRING, display_name="Cluster Number")
    COLORHTML__FIELD_NAME: Final[WrapperField] = WrapperField("ColorHTML", FieldType.STRING, display_name="Color HTML")
    COLORNAME__FIELD_NAME: Final[WrapperField] = WrapperField("ColorName", FieldType.STRING, display_name="Color Name")
    CREATEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("CreatedBy", FieldType.STRING, display_name="Created By")
    DATARECORDNAME__FIELD_NAME: Final[WrapperField] = WrapperField("DataRecordName", FieldType.IDENTIFIER, display_name="ID")
    DATECREATED__FIELD_NAME: Final[WrapperField] = WrapperField("DateCreated", FieldType.DATE, display_name="Date Created")
    USERANNOTATION__FIELD_NAME: Final[WrapperField] = WrapperField("UserAnnotation", FieldType.STRING, display_name="User Annotation")
    VELOXLASTMODIFIEDBY__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedBy", FieldType.STRING, display_name="Last Modified By")
    VELOXLASTMODIFIEDDATE__FIELD_NAME: Final[WrapperField] = WrapperField("VeloxLastModifiedDate", FieldType.DATE, display_name="Last Modified Date")

    @classmethod
    def get_wrapper_data_type_name(cls):
        return cls.DATA_TYPE_NAME

    def set_ClusterNum_field(self, value: Optional[str]):
        """
        Set data field with field name 'ClusterNum' on this record model
        """
        self.set_field_value(self.CLUSTERNUM__FIELD_NAME.field_name, value)

    def get_ClusterNum_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ClusterNum' from this record model
        """
        return self.get_field_value(self.CLUSTERNUM__FIELD_NAME.field_name)

    def set_ColorHTML_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColorHTML' on this record model
        """
        self.set_field_value(self.COLORHTML__FIELD_NAME.field_name, value)

    def get_ColorHTML_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColorHTML' from this record model
        """
        return self.get_field_value(self.COLORHTML__FIELD_NAME.field_name)

    def set_ColorName_field(self, value: Optional[str]):
        """
        Set data field with field name 'ColorName' on this record model
        """
        self.set_field_value(self.COLORNAME__FIELD_NAME.field_name, value)

    def get_ColorName_field(self) -> Optional[str]:
        """
        Get data field value with field name 'ColorName' from this record model
        """
        return self.get_field_value(self.COLORNAME__FIELD_NAME.field_name)

    def get_CreatedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'CreatedBy' from this record model
        """
        return self.get_field_value(self.CREATEDBY__FIELD_NAME.field_name)

    def get_DateCreated_field(self) -> Optional[int]:
        """
        Get data field value with field name 'DateCreated' from this record model
        """
        return self.get_field_value(self.DATECREATED__FIELD_NAME.field_name)

    def set_UserAnnotation_field(self, value: Optional[str]):
        """
        Set data field with field name 'UserAnnotation' on this record model
        """
        self.set_field_value(self.USERANNOTATION__FIELD_NAME.field_name, value)

    def get_UserAnnotation_field(self) -> Optional[str]:
        """
        Get data field value with field name 'UserAnnotation' from this record model
        """
        return self.get_field_value(self.USERANNOTATION__FIELD_NAME.field_name)

    def get_VeloxLastModifiedBy_field(self) -> Optional[str]:
        """
        Get data field value with field name 'VeloxLastModifiedBy' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDBY__FIELD_NAME.field_name)

    def get_VeloxLastModifiedDate_field(self) -> Optional[int]:
        """
        Get data field value with field name 'VeloxLastModifiedDate' from this record model
        """
        return self.get_field_value(self.VELOXLASTMODIFIEDDATE__FIELD_NAME.field_name)


class FlowClustConfigModel(WrappedRecordModel):
    """
    Auto-Generated Record Model Wrapper for data type FlowClustConfig
    Data Type Display Name: FlowClust Config (FlowClust Configs)
    Fields: criterion, seed, nu, DateCreated, MaxEMIterations, ChannelConfigJSON, tolInit, tol, LLevel, NumberOfClusters, mincount, VeloxLastModifiedBy, lam, nuest, ClusterGroupName, FilePath, maxcount, VeloxCurrentVersion, CreatedBy, zcutoff, IsDataComplete, DataRecordName, BInit, VeloxLastModifiedDate, randomStart, trans
    Sets up a FlowClust clustering package configurations.
    """
    DATA_TYPE_NAME: Final[str] = 'FlowClustConfig'
    DISPLAY_NAME: Final[str] = "FlowClust Config"
    PLURAL_DISPLAY_NAME: Final[str] = "FlowClust Configs"
    BINIT__FIELD_NAME: Final[WrapperField] = WrapperField("BInit", FieldType.INTEGER, display_name="(B.init) - Initial EM Itereations")
    CHANNELCONFIGJSON__FIELD_NAME