from .base import BaseCloudProvider


class Azure(BaseCloudProvider):
    # pulled from https://learn.microsoft.com/en-us/azure/azure-government/compare-azure-government-global-azure
    # and https://github.com/v2fly/domain-list-community/blob/master/data/azure
    domains = [
        "21vbc.com",
        "21vbluecloud.com",
        "21vbluecloud.net",
        "aadrm.cn",
        "aggresmart.com",
        "apihub-internal.cn",
        "appserviceenvironment.cn",
        "azconfig.io",
        "azcrmc-test.cn",
        "azcrmc.cn",
        "azk8s.cn",
        "azmk8s.io",
        "aznbcontent.cn",
        "aztask.cn",
        "azure-api.cn",
        "azure-api.net",
        "azure-api.us",
        "azure-apihub.cn",
        "azure-automation.cn",
        "azure-automation.net",
        "azure-automation.us",
        "azure-connectedvehicles-stage.cn",
        "azure-connectedvehicles.cn",
        "azure-devices-int.net",
        "azure-devices-provisioning.cn",
        "azure-devices.cn",
        "azure-devices.net",
        "azure-devices.us",
        "azure-dns.cn",
        "azure-dns.com",
        "azure-dns.info",
        "azure-dns.net",
        "azure-dns.org",
        "azure-mobile.net",
        "azure-sphere.com",
        "azure-test.net",
        "azure.cn",
        "azure.com",
        "azure.net",
        "azure.us",
        "azure",
        "azurecomcdn.net",
        "azurecomm.net",
        "azurecontainer.io",
        "azurecosmos.net",
        "azurecosmosdb.com",
        "azurecosmosdb.info",
        "azurecosmosdb.net",
        "azurecr-test.cn",
        "azurecr.cn",
        "azurecr.io",
        "azurecr.us",
        "azuredatabricks.net",
        "azuredatalakestore.net",
        "azuredevopslaunch.com",
        "azuredigitaltwin.com",
        "azuredigitaltwins.com",
        "azuredigitaltwins.net",
        "azuredns-prd.info",
        "azuredns-prd.org",
        "azureedge-test.net",
        "azureedge.net",
        "azurefd.net",
        "azurehdinsight.cn",
        "azurehdinsight.net",
        "azurehdinsight.us",
        "azureiotcentral.com",
        "azureiotsolutions.com",
        "azureiotsuite.cn",
        "azureiotsuite.com",
        "azuremresolver.cn",
        "azureplanetscale.info",
        "azureplanetscale.net",
        "azureprivatedns.cn",
        "azurerms.cn",
        "azuresandbox.cn",
        "azureserviceprofiler.com",
        "azuresmartspaces.net",
        "azurestackvalidation.com",
        "azurewebsites.net",
        "b2clogin.cn",
        "b3itech.cn",
        "blueaggrestore.com",
        "bluecloudprod.com",
        "botframework.com",
        "cegid-cloud.cn",
        "chinacloud-mobile.cn",
        "chinacloudapi.cn",
        "chinacloudapp.cn",
        "chinacloudsites.cn",
        "cloudapp.net",
        "cosmosdb.info",
        "cosmosdb.net",
        "devopsms.com",
        "gotcosmos.com",
        "hdinsightservices.cn",
        "loganalytics.io",
        "loganalytics.us",
        "management-azure-devices-int.net",
        "management-azure-devices-provisioning.cn",
        "management-azure-devices.cn",
        "management-azure-devices.net",
        "mcchcdn.com",
        "mgmt-azure-api.cn",
        "microsoft.us",
        "microsoftazuresponsorships.com",
        "microsoftazurestatus.cn",
        "microsofteca.com",
        "microsoftiotcentral.com",
        "microsoftmetrics.cn",
        "microsoftonline.com",
        "microsoftonline.us",
        "mncmsidlab1.cn",
        "msappproxy.cn",
        "mschcdn.com",
        "msftcloudes.cn",
        "msidentity.cn",
        "msidlabpbmc.cn",
        "msn.net",
        "onmicrosoft.com",
        "powerbi.com",
        "powerbigov.us",
        "serverlesslibrary.net",
        "trafficmanager.cn",
        "trafficmanager.net",
        "trustcenter.cn",
        "tryfunctions.com",
        "unity3dcloud.cn",
        "usgovcloudapi.net",
        "usgovtrafficmanager.net",
        "visualstudio.com",
        "vo.msecnd.net",
        "windows.net",
        "windowsazure.cn",
        "windowsazure.com",
        "windowsazure.us",
        "windowsazurestatus.cn",
    ]
    bucket_name_regex = r"[a-z0-9][a-z0-9-_\.]{1,61}[a-z0-9]"
    regexes = {
        "STORAGE_BUCKET": [r"(" + bucket_name_regex + r")\.(blob\.core\.windows\.net)"]
    }

    ips_url = "https://download.microsoft.com/download/0/1/8/018E208D-54F8-44CD-AA26-CD7BC9524A8C/PublicIPs_20200824.xml"

    def parse_response(self, response):
        ranges = set()
        for line in response.text.splitlines():
            if "IpRange Subnet" in line:
                ip_range = line.split('"')[1]
                ranges.add(ip_range)
        return ranges
