# Generated by Django 2.2.28 on 2022-07-18 09:17

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('djangoldp_community', '0011_auto_20220711_0837'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldTerritoriesKind',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Territory Kind',
                'verbose_name_plural': 'TZCLD Territories Kind',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:TzcldTerritoriesKind',
                'container_path': 'tzcld-kinds/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('description', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('region', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('postal_code', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('address', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('phone', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('position', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('membership', models.BooleanField(default=False)),
                ('last_contribution_year', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='tzcld_profile', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'TZCLD Profile',
                'verbose_name_plural': 'TZCLD Profiles',
                'ordering': ['user'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'lookup_field': 'slug',
                'rdf_type': 'sib:CommunityTzcldProfile',
                'auto_author': 'user',
                'container_path': '/tzcldprofiles/',
                'serializer_fields': ['@id', 'contact_first_name', 'contact_last_name', 'kind', 'features', 'region', 'contact_mail_1', 'contact_mail_2', 'contact_mail_3', 'membership', 'last_contribution_year'],
                'depth': 1,
                                                            },
        ),
        migrations.CreateModel(
            name='TzcldProfileOrganisation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('tzcldprofile', models.ManyToManyField(blank=True, related_name='orgs', to='djangoldp_tzcld.TzcldProfile')),
            ],
            options={
                'verbose_name': 'TZCLD Organisation or Territory',
                'verbose_name_plural': 'TZCLD Organisations or Territories',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:TzcldOrgs',
                'container_path': 'tzcld-orgs/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldProfileEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('tzcldprofile', models.ManyToManyField(blank=True, related_name='events', to='djangoldp_tzcld.TzcldProfile')),
            ],
            options={
                'verbose_name': 'TZCLD Event',
                'verbose_name_plural': 'TZCLD Events',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:TzcldEvent',
                'container_path': 'tzcld-events/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldCommunity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('contact_first_name', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('contact_last_name', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('features', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('region', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('contact_mail_1', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('contact_mail_2', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('contact_mail_3', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('membership', models.BooleanField(default=False)),
                ('last_contribution_year', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('community', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='tzcld_profile', to='djangoldp_community.Community')),
                ('kind', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='kind', to='djangoldp_tzcld.TzcldTerritoriesKind')),
            ],
            options={
                'verbose_name': 'TZCLD Community Profile',
                'verbose_name_plural': 'TZCLD Communities Profiles',
                'ordering': ['community'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:CommunityTzcldProfile',
                'container_path': '/tzcldprofiles/',
                
                'serializer_fields': ['@id', 'contact_first_name', 'contact_last_name', 'kind', 'features', 'region', 'contact_mail_1', 'contact_mail_2', 'contact_mail_3', 'membership', 'last_contribution_year'],
                'depth': 1,
                                                            },
        ),
    ]
