# Generated by Django 2.2.28 on 2023-03-23 19:26

from django.db import migrations, models
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_tzcld', '0003_auto_20220720_1242'),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldProfileJob',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('position', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('organistion', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('address', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('postal_code', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('city', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('departement', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('address_public', models.BooleanField(default=False)),
                ('tzcldprofile', models.ManyToManyField(blank=True, related_name='tzcld_profile_job', to='djangoldp_tzcld.TzcldProfile')),
            ],
            options={
                'verbose_name': 'TZCLD profile job',
                'verbose_name_plural': 'TZCLD profuile jobs',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:profileJob',
                'container_path': 'tzcld-profile-job/',
                'serializer_fields': ['@id', 'position', 'organistion', 'address', 'postal_code', 'city', 'departement', 'address_public'],
                'nested_fields': [],
                'depth': 0,
                                                            },
        ),
        migrations.CreateModel(
            name='TzcldProfileJobPhone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('phone', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('phone_type', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('phone_public', models.BooleanField(default=False)),
                ('tzcldprofilejob', models.ManyToManyField(blank=True, related_name='tzcld_profile_job_phone', to='djangoldp_tzcld.TzcldProfileJob')),
            ],
            options={
                'verbose_name': 'TZCLD profile job phone',
                'verbose_name_plural': 'TZCLD profile job phones',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:profileJobPhone',
                'container_path': 'tzcld-profile-job-phone/',
                'serializer_fields': ['@id', 'phone', 'phone_type', 'phone_public'],
                'nested_fields': [],
                'depth': 0,
                                                            },
        ),
        migrations.CreateModel(
            name='TzcldProfileJobEmail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('email', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('email_type', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('email_public', models.BooleanField(default=False)),
                ('tzcldprofilejob', models.ManyToManyField(blank=True, related_name='tzcld_profile_job_email', to='djangoldp_tzcld.TzcldProfileJob')),
            ],
            options={
                'verbose_name': 'TZCLD profile job email',
                'verbose_name_plural': 'TZCLD profile job emails',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:profileJobEmail',
                'container_path': 'tzcld-profile-job-email/',
                'serializer_fields': ['@id', 'email', 'email_type', 'email_public'],
                'nested_fields': [],
                'depth': 0,
                                                            },
        ),
    ]
