# Generated by Django 2.2.28 on 2023-03-27 12:49

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_tzcld', '0005_auto_20230325_1335'),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldContactEmail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('email', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('email_type', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('email_public', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name': 'TZCLD contact email',
                'verbose_name_plural': 'TZCLD contact emails',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:contactEmail',
                'container_path': 'tzcld-contact-email/',
                'serializer_fields': ['@id', 'email', 'email_type', 'email_public'],
                'nested_fields': [],
                'depth': 0,
                                                            },
        ),
        migrations.CreateModel(
            name='TzcldContactPhone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('phone', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('phone_type', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('phone_public', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name': 'TZCLD contact phone',
                'verbose_name_plural': 'TZCLD contact phones',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:contactPhone',
                'container_path': 'tzcld-contact-phone/',
                'serializer_fields': ['@id', 'phone', 'phone_type', 'phone_public'],
                'nested_fields': [],
                'depth': 0,
                                                            },
        ),
        migrations.CreateModel(
            name='TzcldJobsEmails',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldContactEmail')),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldProfileJob')),
            ],
        ),
        migrations.CreateModel(
            name='TzcldJobsPhones',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldProfileJob')),
                ('phone', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldContactPhone')),
            ],
        ),
        migrations.CreateModel(
            name='TzcldProfilesJobs',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldProfileJob')),
            ],
        ),
        migrations.CreateModel(
            name='TzcldProfilesMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(default='', max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD profile job phone',
                'verbose_name_plural': 'TZCLD profile job phones',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:profileMembership',
                'container_path': 'tzcld-profile-membership/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                                                            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoriesEmails',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldContactEmail')),
            ],
        ),
        migrations.CreateModel(
            name='TzcldTerritoriesLocations',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='TzcldTerritoriesPhones',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='TzcldTerritoriesStepState',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Territory step state',
                'verbose_name_plural': 'TZCLD Territories step states',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryStepState',
                'container_path': 'tzcld--territories-step-states/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoryLocation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('address', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('postal_code', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('city', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('departement', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('link', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('twitter_link', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('linkedin_link', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('emails', models.ManyToManyField(blank=True, max_length=50, through='djangoldp_tzcld.TzcldTerritoriesEmails', to='djangoldp_tzcld.TzcldContactEmail', verbose_name='TZCLD Contacts Emails')),
                ('phones', models.ManyToManyField(blank=True, max_length=50, through='djangoldp_tzcld.TzcldTerritoriesPhones', to='djangoldp_tzcld.TzcldContactPhone', verbose_name='TZCLD Contacts Phones')),
            ],
            options={
                'verbose_name': 'TZCLD Territory location',
                'verbose_name_plural': 'TZCLD Territories location',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryLocation',
                'container_path': 'tzcld-territories-location/',
                'serializer_fields': ['@id', 'name', 'address', 'postal_code', 'city', 'departement', 'link', 'twitter_link', 'linkedin_link', 'phones', 'emails'],
                'nested_fields': [],
                'depth': 0
            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoryRegion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Region or departement',
                'verbose_name_plural': 'TZCLD Regions or departements',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:regions',
                'container_path': 'tzcld-regions/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.RemoveField(
            model_name='tzcldprofilejobemail',
            name='tzcldprofilejob',
        ),
        migrations.RemoveField(
            model_name='tzcldprofilejobphone',
            name='tzcldprofilejob',
        ),
        migrations.RemoveField(
            model_name='tzcldprofileorganisation',
            name='tzcldprofile',
        ),
        migrations.RemoveField(
            model_name='tzcldprofileregion',
            name='tzcldprofile',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunity',
            name='contact_first_name',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunity',
            name='contact_job',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunity',
            name='contact_last_name',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunity',
            name='contact_mail_1',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunity',
            name='contact_mail_2',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunity',
            name='contact_mail_3',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunity',
            name='features',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunity',
            name='last_contribution_year',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunity',
            name='membership',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunity',
            name='region',
        ),
        migrations.RemoveField(
            model_name='tzcldprofile',
            name='address',
        ),
        migrations.RemoveField(
            model_name='tzcldprofile',
            name='description',
        ),
        migrations.RemoveField(
            model_name='tzcldprofile',
            name='membership',
        ),
        migrations.RemoveField(
            model_name='tzcldprofile',
            name='phone',
        ),
        migrations.RemoveField(
            model_name='tzcldprofile',
            name='position',
        ),
        migrations.RemoveField(
            model_name='tzcldprofile',
            name='postal_code',
        ),
        migrations.RemoveField(
            model_name='tzcldprofile',
            name='tzcld_profile_job',
        ),
        migrations.DeleteModel(
            name='TzcldProfileEvent',
        ),
        migrations.DeleteModel(
            name='TzcldProfileJobEmail',
        ),
        migrations.DeleteModel(
            name='TzcldProfileJobPhone',
        ),
        migrations.DeleteModel(
            name='TzcldProfileOrganisation',
        ),
        migrations.DeleteModel(
            name='TzcldProfileRegion',
        ),
        migrations.AddField(
            model_name='tzcldterritoriesphones',
            name='job',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldTerritoryLocation'),
        ),
        migrations.AddField(
            model_name='tzcldterritoriesphones',
            name='phone',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldContactPhone'),
        ),
        migrations.AddField(
            model_name='tzcldterritorieslocations',
            name='location',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldTerritoryLocation'),
        ),
        migrations.AddField(
            model_name='tzcldterritorieslocations',
            name='tzcld_community',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldCommunity'),
        ),
        migrations.AddField(
            model_name='tzcldterritoriesemails',
            name='job',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldTerritoryLocation'),
        ),
        migrations.AddField(
            model_name='tzcldprofilesjobs',
            name='tzcld_profile',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_tzcld.TzcldProfile'),
        ),
        migrations.AddField(
            model_name='tzcldcommunity',
            name='locations',
            field=models.ManyToManyField(blank=True, max_length=50, through='djangoldp_tzcld.TzcldTerritoriesLocations', to='djangoldp_tzcld.TzcldTerritoryLocation', verbose_name='TZCLD Territories location'),
        ),
        migrations.AddField(
            model_name='tzcldcommunity',
            name='step_state',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='step_state', to='djangoldp_tzcld.TzcldTerritoriesStepState'),
        ),
        migrations.AddField(
            model_name='tzcldprofile',
            name='jobs',
            field=models.ManyToManyField(blank=True, max_length=50, through='djangoldp_tzcld.TzcldProfilesJobs', to='djangoldp_tzcld.TzcldProfileJob', verbose_name='TZCLD Postes'),
        ),
        migrations.AddField(
            model_name='tzcldprofilejob',
            name='emails',
            field=models.ManyToManyField(blank=True, max_length=50, through='djangoldp_tzcld.TzcldJobsEmails', to='djangoldp_tzcld.TzcldContactEmail', verbose_name='TZCLD Contact Emaills'),
        ),
        migrations.AddField(
            model_name='tzcldprofilejob',
            name='phones',
            field=models.ManyToManyField(blank=True, max_length=50, through='djangoldp_tzcld.TzcldJobsPhones', to='djangoldp_tzcld.TzcldContactPhone', verbose_name='TZCLD Contact Téléphones'),
        ),
    ]
