# Generated by Django 2.2.28 on 2023-05-24 12:56

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_community', '0011_auto_20220711_0837'),
        ('djangoldp_tzcld', '0022_tzcldcommunity_membership_organisation_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldCommunityDeliberation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Community deliberation',
                'verbose_name_plural': 'TZCLD Community deliberations',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:communityDeliberation',
                'container_path': 'tzcld-communities-deliberations/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldCommunityEvaluationPoint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=1024, null=True)),
                ('order', models.IntegerField(blank=True, default=1, max_length=2, null=True)),
                ('points', models.IntegerField(blank=True, default=0, max_length=2, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Community Evaluation Point',
                'verbose_name_plural': 'TZCLD Communities Evaluation Points',
                'ordering': ['order'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:communityEvaluationPoint',
                'container_path': '/tzcld-communities-evaluation-points/',
                
                'serializer_fields': ['@id', 'name', 'order', 'part', 'points'],
                'depth': 1,
                                                            },
        ),
        migrations.CreateModel(
            name='TzcldCommunityEvaluationPointPart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('title', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('subtitle', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('order', models.IntegerField(blank=True, default=1, max_length=2, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Evaluation Point Part',
                'verbose_name_plural': 'TZCLD Evaluation Point Parts',
                'ordering': ['order'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:evaluationPointPart',
                'container_path': 'tzcld-evaluation-point-parts/',
                'serializer_fields': ['@id', 'name', 'title', 'subtitle', 'order'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldCouncilDepartmentDeliberation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD council department deliberation',
                'verbose_name_plural': 'TZCLD council department deliberations',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:councilDepartmentDeliberation',
                'container_path': 'tzcld-councils-departments-deliberations/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldOtherCommunityDeliberation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Other Community deliberation',
                'verbose_name_plural': 'TZCLD Other Community deliberations',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:otherCommunityDeliberation',
                'container_path': 'tzcld-others-communities-deliberations/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.RemoveField(
            model_name='tzcldterritorylocation',
            name='department',
        ),
        migrations.RemoveField(
            model_name='tzcldterritorylocation',
            name='link',
        ),
        migrations.RemoveField(
            model_name='tzcldterritorylocation',
            name='linkedin_link',
        ),
        migrations.RemoveField(
            model_name='tzcldterritorylocation',
            name='twitter_link',
        ),
        migrations.CreateModel(
            name='TzcldCommunityEvaluationPointAnswer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('answer', models.BooleanField(default=False)),
                ('comment', models.TextField(blank=True, null=True)),
                ('community', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='community_answer', to='djangoldp_community.Community')),
                ('evaluation_point', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='evaluation_point_answer', to='djangoldp_tzcld.TzcldCommunityEvaluationPoint')),
            ],
            options={
                'verbose_name': 'TZCLD Community Evaluation Point Answer',
                'verbose_name_plural': 'TZCLD Communities Evaluation Point answers',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:communityEvaluationPointAnswer',
                'container_path': '/tzcld-communities-evaluation-point-answers/',
                
                'serializer_fields': ['@id', 'answer', 'comment', 'evaluation_point', 'community'],
                'depth': 1,
                                                            },
        ),
        migrations.AddField(
            model_name='tzcldcommunityevaluationpoint',
            name='part',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='part_point', to='djangoldp_tzcld.TzcldCommunityEvaluationPointPart'),
        ),
    ]
