# Generated by Django 2.2.28 on 2023-07-03 14:56

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_tzcld', '0027_tzcldcommunityevaluationpointanswer_answer_option'),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldSharedNote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('longdesc', models.TextField(blank=True, null=True)),
                ('tzcldCommunity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='tzcld_community_shared_notes', to='djangoldp_tzcld.TzcldCommunity')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'TZCLD Shared Note',
                'verbose_name_plural': 'TZCLD Shared Notes',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:sharedNote',
                'container_path': 'tzcld-shared-note/',
                'serializer_fields': ['@id', 'user', 'longdesc', 'tzcldCommunity'],
                'nested_fields': [],
                'depth': 0,
                                                            },
        ),
        migrations.CreateModel(
            name='TzcldSharedNoteComment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('comment', models.TextField(blank=True, null=True)),
                ('tzcldSharedNote', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='tzcld_shared_note_comments', to='djangoldp_tzcld.TzcldSharedNote')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'TZCLD Shared Note Comment',
                'verbose_name_plural': 'TZCLD Shared Notes Comments',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:sharedNoteComment',
                'container_path': 'tzcld-shared-note-comment/',
                'serializer_fields': ['@id', 'user', 'comment', 'tzcldSharedNote'],
                'nested_fields': [],
                'depth': 0,
                                                            },
        ),
    ]
