# Generated by Django 2.2.28 on 2023-07-03 15:40

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_community', '0011_auto_20220711_0837'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_tzcld', '0028_tzcldsharednote_tzcldsharednotecomment'),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldTerritoryRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('date', models.DateField(verbose_name='Date')),
                ('contactType', models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Type of contact')),
                ('subject', models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Sujet/Demande')),
                ('comment', models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Comments')),
                ('community', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='community_requests', to='djangoldp_community.Community')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='Interlocuteur')),
            ],
            options={
                'verbose_name': 'TZCLD Territory Request',
                'verbose_name_plural': 'TZCLD Territory Requests',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryRequest',
                'container_path': 'tzcld-territory-request/',
                'serializer_fields': ['@id', 'user', 'date', 'contactType', 'subject', 'comment', 'community'],
                'nested_fields': [],
                'depth': 0,
                                                            },
        ),
    ]
