# Generated by Django 2.2.28 on 2023-07-06 08:24

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_community', '0011_auto_20220711_0837'),
        ('djangoldp_tzcld', '0029_tzcldterritoryrequest'),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldFollowedTrainingB',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Followed Training B',
                'verbose_name_plural': 'TZCLD Followed Trainings B',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:followed-training-b',
                'container_path': 'tzcld-followed-training-b/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldFollowedTrainingD',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Followed Training D',
                'verbose_name_plural': 'TZCLD Followed Trainings D',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:followed-training-d',
                'container_path': 'tzcld-followed-training-d/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldTerritorySynthesisFollowed',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('context', models.TextField(blank=True, null=True, verbose_name='Context')),
                ('strongPoints', models.TextField(blank=True, null=True, verbose_name='Strong Points')),
                ('questions', models.TextField(blank=True, null=True, verbose_name='Questions')),
                ('needs', models.TextField(blank=True, null=True, verbose_name='Needs, Actions')),
                ('targetdate', models.DateField(verbose_name='Target date')),
                ('followedTrainingBNumber', models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Type of contact')),
                ('followedTrainingDNumber', models.CharField(blank=True, default='', max_length=1024, null=True, verbose_name='Type of contact')),
                ('community', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='community_synthesis_followed', to='djangoldp_community.Community')),
                ('followedTrainingB', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='territory_followed_training_b', to='djangoldp_tzcld.TzcldFollowedTrainingB')),
                ('followedTrainingD', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='territory_followed_training_b', to='djangoldp_tzcld.TzcldFollowedTrainingD')),
            ],
            options={
                'verbose_name': 'TZCLD Territory Synthesis Followed',
                'verbose_name_plural': 'TZCLD Territory Synthesis Followed',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territorySynthesisFollowed',
                'container_path': 'tzcld-territory-synthesis followed/',
                'serializer_fields': ['@id', 'context', 'strongPoints', 'questions', 'needs', 'targetdate', 'followedTrainingB', 'followedTrainingBNumber', 'followedTrainingD', 'followedTrainingDNumber', 'community'],
                'nested_fields': [],
                'depth': 0,
                                                            },
        ),
    ]
