# Generated by Django 2.2.28 on 2023-07-06 09:24

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_community', '0011_auto_20220711_0837'),
        ('djangoldp_tzcld', '0030_tzcldfollowedtrainingb_tzcldfollowedtrainingd_tzcldterritorysynthesisfollowed'),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldCommunityFollowedPoint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=1024, null=True)),
                ('order', models.IntegerField(blank=True, default=1, null=True)),
                ('fieldType', models.CharField(choices=[('text', 'Text'), ('textarea', 'Textearea')], default='textarea', max_length=25)),
                ('helpComment', models.TextField(blank=True, null=True, verbose_name='Questions to ask')),
            ],
            options={
                'verbose_name': 'TZCLD Community Followed Point',
                'verbose_name_plural': 'TZCLD Communities Followed Points',
                'ordering': ['order'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:communityFollowedPoint',
                'container_path': 'tzcld-communities-followed-points/',
                'serializer_fields': ['@id', 'name', 'order', 'part', 'fieldType', 'helpComment'],
                'depth': 0,
                                                            },
        ),
        migrations.CreateModel(
            name='TzcldCommunityFollowedPointPart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('title', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('order', models.IntegerField(blank=True, default=1, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Community Followed Point Part',
                'verbose_name_plural': 'TZCLD Communities Followed Point Parts',
                'ordering': ['order'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:followedPointPart',
                'container_path': 'tzcld-followed-point-parts/',
                'serializer_fields': ['@id', 'name', 'title', 'order', 'followed_part_points'],
                'nested_fields': [],
                'depth': 0,
                                                            },
        ),
        migrations.CreateModel(
            name='TzcldCommunityFollowedPointAnswer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('answer', models.BooleanField(default=False)),
                ('community', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='community_followed_answer', to='djangoldp_community.Community')),
                ('followed_point', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='followed_point_answer', to='djangoldp_tzcld.TzcldCommunityFollowedPoint')),
            ],
            options={
                'verbose_name': 'TZCLD Community Evaluation Point Answer',
                'verbose_name_plural': 'TZCLD Communities Evaluation Point answers',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:communityEvaluationPointAnswer',
                'container_path': 'tzcld-communities-evaluation-point-answers/',
                'serializer_fields': ['@id', 'answer', 'answer_option', 'comment', 'evaluation_point', 'community'],
                'depth': 0,
                                                            },
        ),
        migrations.AddField(
            model_name='tzcldcommunityfollowedpoint',
            name='part',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='followed_part_points', to='djangoldp_tzcld.TzcldCommunityFollowedPointPart'),
        ),
    ]
