# Generated by Django 2.2.28 on 2023-07-10 10:23

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_community', '0011_auto_20220711_0837'),
        ('djangoldp_tzcld', '0032_auto_20230706_1509'),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldCommunityIdentity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('deputy', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('circonscription', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('application_date', models.DateField(verbose_name='Estimated application date')),
                ('signatory_structure', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('birth_date', models.DateField(verbose_name='Project birth date')),
                ('last_contribution_date', models.DateField(verbose_name='Last contribution date')),
                ('community', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='tzcld_profile_identity', to='djangoldp_community.Community')),
            ],
            options={
                'verbose_name': 'TZCLD Territory Identity',
                'verbose_name_plural': 'TZCLD Territories Identities',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:communityIdentity',
                'container_path': 'tzcld-communities-identity/',
                'serializer_fields': ['@id', 'community', 'deputy', 'circonscription', 'origin_mobilization', 'application_date', 'signatory_structure', 'birth_date', 'last_contribution_date'],
                'depth': 0,
                                                            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoriesOriginMobilization',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Origin Mobilization',
                'verbose_name_plural': 'TZCLD Origins Mobilization',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryOriginMobilization',
                'container_path': 'tzcld-origins-mobilization/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoriesTeamTrainingCourse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Team Training Course',
                'verbose_name_plural': 'TZCLD Team Training Courses',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryTeamTrainingCourse',
                'container_path': 'tzcld-team-training-courses/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoriesTeamTrainingPromotoion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Team Training Promotoion',
                'verbose_name_plural': 'TZCLD Team Training Promotoions',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryTeamTrainingPromotoion',
                'container_path': 'tzcld-team-training-promotoions/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoriesTrainingCourse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Training Course',
                'verbose_name_plural': 'TZCLD Training Courses',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryTrainingCourse',
                'container_path': 'tzcld-training-courses/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoriesTrainingProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Training Profile',
                'verbose_name_plural': 'TZCLD Training Profiles',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryTrainingProfile',
                'container_path': 'tzcld-training-profiles/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoriesTrainingPromotoion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Training Promotoion',
                'verbose_name_plural': 'TZCLD Training Promotoions',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryTrainingPromotoion',
                'container_path': 'tzcld-training-promotoions/',
                'serializer_fields': ['@id', 'name'],
                'nested_fields': [],
                'depth': 0,
                            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoryTraining',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('training_person', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('community_identity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='territories_trainings', to='djangoldp_tzcld.TzcldCommunityIdentity')),
                ('training_course', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='territory_training_course', to='djangoldp_tzcld.TzcldTerritoriesTrainingCourse')),
                ('training_profile', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='territory_training_profile', to='djangoldp_tzcld.TzcldTerritoriesTrainingProfile')),
                ('training_promotoion', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='territory_training_promotion', to='djangoldp_tzcld.TzcldTerritoriesTrainingPromotoion')),
            ],
            options={
                'verbose_name': 'TZCLD Territory Training',
                'verbose_name_plural': 'TZCLD Territories Trainings',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryTraining',
                'container_path': 'tzcld-territories-training/',
                'serializer_fields': ['@id', 'training_course', 'training_promotoion', 'training_person', 'training_profile', 'community_identity'],
                'nested_fields': ['community_identity'],
                'depth': 0
            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoryTeamTraining',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('training_person', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('community_identity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='territories_team_trainings', to='djangoldp_tzcld.TzcldCommunityIdentity')),
                ('training_course', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='territory_team_training_course', to='djangoldp_tzcld.TzcldTerritoriesTrainingCourse')),
                ('training_promotoion', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='territory_team_training_promotion', to='djangoldp_tzcld.TzcldTerritoriesTrainingPromotoion')),
            ],
            options={
                'verbose_name': 'TZCLD Territory Team Training',
                'verbose_name_plural': 'TZCLD Territories Team Trainings',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryTeamTraining',
                'container_path': 'tzcld-territories-team-training/',
                'serializer_fields': ['@id', 'training_course', 'training_promotoion', 'training_person', 'training_profile', 'community_identity'],
                'nested_fields': ['community_identity'],
                'depth': 0
            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoryProjectTeamMemeber',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('firstname', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('name', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('etp', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('position_funding', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('community_identity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='territories_project_team_memebers', to='djangoldp_tzcld.TzcldCommunityIdentity')),
            ],
            options={
                'verbose_name': 'TZCLD Territory Project Team Memeber',
                'verbose_name_plural': 'TZCLD Territories Project Team Memebers',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryProjectTeamMemeber',
                'container_path': 'tzcld-territories-project-team-memeber/',
                'serializer_fields': ['@id', 'firstname', 'name', 'etp', 'position_funding', 'community_identity'],
                'nested_fields': ['community_identity'],
                'depth': 0
            },
        ),
        migrations.AddField(
            model_name='tzcldcommunityidentity',
            name='origin_mobilization',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='territory_origin_mobilization', to='djangoldp_tzcld.TzcldTerritoriesOriginMobilization'),
        ),
    ]
