# Generated by Django 2.2.28 on 2023-07-11 13:02

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_conversation', '0007_auto_20200926_0911'),
        ('djangoldp_community', '0011_auto_20220711_0837'),
        ('djangoldp_tzcld', '0038_tzcldterritoryregion_referers'),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldTerritorySharedFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=1024, null=True)),
                ('date', models.DateField(verbose_name='Date')),
                ('document', models.URLField(blank=True, null=True, verbose_name='Document')),
                ('visible', models.CharField(choices=[('admins', 'Territory administrators'), ('referents', 'Referents')], default='referents', max_length=25)),
                ('author', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='Interlocuteur')),
                ('community', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='tzcld_community_shared_files', to='djangoldp_community.Community')),
            ],
            options={
                'verbose_name': 'TZCLD Territory Shared File',
                'verbose_name_plural': 'TZCLD Territories Shared Files',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territorySharedFile',
                'container_path': 'tzcld-territory-shared-files/',
                'serializer_fields': ['@id', 'author', 'name', 'date', 'document', 'community', 'visible'],
                'nested_fields': ['author', 'community'],
                'depth': 0,
                                                            },
        ),
        migrations.AddField(
            model_name='tzcldprofile',
            name='is_national_referent',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='tzcldsharednote',
            name='conversations',
            field=models.ManyToManyField(blank=True, related_name='tzcld_shared_notes', to='djangoldp_conversation.Conversation'),
        ),
        migrations.AddField(
            model_name='tzcldsharednote',
            name='visible',
            field=models.CharField(choices=[('admins', 'Territory administrators'), ('referents', 'Referents')], default='referents', max_length=25),
        ),
        migrations.AlterField(
            model_name='tzcldcommunityfollowedpointanswer',
            name='community',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='tzcld_community_followed_answer', to='djangoldp_community.Community'),
        ),
        migrations.AlterField(
            model_name='tzcldterritoryrequest',
            name='community',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='tzcld_community_requests', to='djangoldp_community.Community'),
        ),
        migrations.AlterField(
            model_name='tzcldterritorysynthesisfollowed',
            name='community',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='tzcld_community_synthesis_followed', to='djangoldp_community.Community'),
        ),
        migrations.DeleteModel(
            name='TzcldSharedNoteComment',
        ),
    ]
