# Generated by Django 2.2.28 on 2023-10-06 11:00

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_conversation', '0007_auto_20200926_0911'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_tzcld', '0052_auto_20231006_1250'),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldTerritorySharedNote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('longdesc', models.TextField(blank=True, null=True)),
                ('date', models.DateField(auto_now=True, verbose_name='Date')),
                ('author', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('communityAdmins', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='tzcld_admins_community_shared_notes', to='djangoldp_tzcld.TzcldCommunityIdentity')),
                ('communityReferents', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='tzcld_referents_community_shared_notes', to='djangoldp_tzcld.TzcldTerritorySynthesisFollowed')),
                ('conversations', models.ManyToManyField(blank=True, related_name='tzcld_shared_notes', to='djangoldp_conversation.Conversation')),
            ],
            options={
                'verbose_name': 'TZCLD Territory Shared Note',
                'verbose_name_plural': 'TZCLD Territories Shared Notes',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territorySharedNote',
                'auto_author': 'author',
                'container_path': 'tzcld-territory-shared-notes/',
                'serializer_fields': ['@id', 'author', 'longdesc', 'communityAdmins', 'communityReferents', 'conversations', 'date'],
                'nested_fields': ['author', 'communityAdmins', 'communityReferents', 'conversations'],
                'depth': 0
            },
        ),
        migrations.DeleteModel(
            name='TzcldSharedNote',
        ),
    ]
