# Generated by Django 4.2.6 on 2023-11-07 07:33

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_tzcld', '0058_rename_communityadmins_tzcldterritorysharedfile_community_admins_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='TzcldTerritoriesTeamUserState',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('order', models.IntegerField(blank=True, default=1, null=True)),
            ],
            options={
                'verbose_name': 'TZCLD Team User State',
                'verbose_name_plural': 'TZCLD Options Team User States',
                'ordering': ['order'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryTeamUserState',
                'container_path': 'tzcld-team-user-states/',
                'serializer_fields': ['@id', 'name', 'order'],
                'nested_fields': [],
                'depth': 0
            },
        ),
        migrations.RenameField(
            model_name='tzcldterritoryprojectteammember',
            old_name='firstname',
            new_name='attachment_structure',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunityidentity',
            name='circonscription',
        ),
        migrations.RemoveField(
            model_name='tzcldcommunityidentity',
            name='deputy',
        ),
        migrations.RemoveField(
            model_name='tzcldterritoryprojectteammember',
            name='name',
        ),
        migrations.RemoveField(
            model_name='tzcldterritoryprojectteammember',
            name='position_funding',
        ),
        migrations.AddField(
            model_name='tzcldcommunityidentity',
            name='emergeance_date',
            field=models.DateField(blank=True, null=True, verbose_name='Date of recognition of project emergence'),
        ),
        migrations.AddField(
            model_name='tzcldcommunityidentity',
            name='habilitation_date',
            field=models.DateField(blank=True, null=True, verbose_name='Date of habilitation'),
        ),
        migrations.AddField(
            model_name='tzcldterritoryprojectteammember',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='TzcldTerritoryPoliticalLandscapeSenator',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('senator', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('circonscription', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('community_identity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='territories_political_landscape_senators', to='djangoldp_tzcld.tzcldcommunityidentity')),
            ],
            options={
                'verbose_name': 'TZCLD Territory Political Landscape Senator',
                'verbose_name_plural': 'TZCLD Territories Political Landscape Senators',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryPoliticalLandscapeSenator',
                'container_path': 'tzcld-territories-political-landscape-senator/',
                'serializer_fields': ['@id', 'senator', 'circonscription', 'community_identity'],
                'nested_fields': ['community_identity'],
                'depth': 0
            },
        ),
        migrations.CreateModel(
            name='TzcldTerritoryPoliticalLandscapeDeputy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('deputy', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('circonscription', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('community_identity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='territories_political_landscape_deputies', to='djangoldp_tzcld.tzcldcommunityidentity')),
            ],
            options={
                'verbose_name': 'TZCLD Territory Political Landscape Deputy',
                'verbose_name_plural': 'TZCLD Territories Political Landscape Deputies',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'tzcld:territoryPoliticalLandscapeDeputy',
                'container_path': 'tzcld-territories-political-landscape-deputy/',
                'serializer_fields': ['@id', 'deputy', 'circonscription', 'community_identity'],
                'nested_fields': ['community_identity'],
                'depth': 0
            },
        ),
        migrations.AddField(
            model_name='tzcldterritoryprojectteammember',
            name='user_state',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='team_member_state', to='djangoldp_tzcld.tzcldterritoriesteamuserstate'),
        ),
    ]
