# -*- coding: cp1252 -*-
''' OpenType Language system tags
source: http://www.microsoft.com/typography/otspec/languagetags.htm
'''

languageTagToNameMap = {'dflt' : 'Default Language',
												'ABA ' : 'Abaza',
												'ABK ' : 'Abkhazian',
												'ADY ' : 'Adyghe',
												'AFK ' : 'Afrikaans',
												'AFR ' : 'Afar',
												'AGW ' : 'Agaw',
												'ALS ' : 'Alsatian',
												'ALT ' : 'Altai',
												'AMH ' : 'Amharic',
												'APPH' : 'Phonetic transcription�Americanist conventions',
												'ARA ' : 'Arabic',
												'ARI ' : 'Aari',
												'ARK ' : 'Arakanese',
												'ASM ' : 'Assamese',
												'ATH ' : 'Athapaskan',
												'AVR ' : 'Avar',
												'AWA ' : 'Awadhi',
												'AYM ' : 'Aymara',
												'AZE ' : 'Azeri',
												'BAD ' : 'Badaga',
												'BAG ' : 'Baghelkhandi',
												'BAL ' : 'Balkar',
												'BAU ' : 'Baule',
												'BBR ' : 'Berber',
												'BCH ' : 'Bench',
												'BCR ' : 'Bible Cree',
												'BEL ' : 'Belarussian',
												'BEM ' : 'Bemba',
												'BEN ' : 'Bengali',
												'BGR ' : 'Bulgarian',
												'BHI ' : 'Bhili',
												'BHO ' : 'Bhojpuri',
												'BIK ' : 'Bikol',
												'BIL ' : 'Bilen',
												'BKF ' : 'Blackfoot',
												'BLI ' : 'Balochi',
												'BLN ' : 'Balante',
												'BLT ' : 'Balti',
												'BMB ' : 'Bambara',
												'BML ' : 'Bamileke',
												'BOS ' : 'Bosnian',
												'BRE ' : 'Breton',
												'BRH ' : 'Brahui',
												'BRI ' : 'Braj Bhasha',
												'BRM ' : 'Burmese',
												'BSH ' : 'Bashkir',
												'BTI ' : 'Beti',
												'CAT ' : 'Catalan',
												'CEB ' : 'Cebuano',
												'CHE ' : 'Chechen',
												'CHG ' : 'Chaha Gurage',
												'CHH ' : 'Chattisgarhi',
												'CHI ' : 'Chichewa',
												'CHK ' : 'Chukchi',
												'CHP ' : 'Chipewyan',
												'CHR ' : 'Cherokee',
												'CHU ' : 'Chuvash',
												'CMR ' : 'Comorian',
												'COP ' : 'Coptic',
												'COS ' : 'Corsican',
												'CRE ' : 'Cree',
												'CRR ' : 'Carrier',
												'CRT ' : 'Crimean Tatar',
												'CSL ' : 'Church Slavonic',
												'CSY ' : 'Czech',
												'DAN ' : 'Danish',
												'DAR ' : 'Dargwa',
												'DCR ' : 'Woods Cree',
												'DEU ' : 'German',
												'DGR ' : 'Dogri',
#												'DHV  (deprecated)' : 'Dhivehi',
												'DIV ' : 'Dhivehi',
												'DJR ' : 'Djerma',
												'DNG ' : 'Dangme',
												'DNK ' : 'Dinka',
												'DRI ' : 'Dari',
												'DUN ' : 'Dungan',
												'DZN ' : 'Dzongkha',
												'EBI ' : 'Ebira',
												'ECR ' : 'Eastern Cree',
												'EDO ' : 'Edo',
												'EFI ' : 'Efik',
												'ELL ' : 'Greek',
												'ENG ' : 'English',
												'ERZ ' : 'Erzya',
												'ESP ' : 'Spanish',
												'ETI ' : 'Estonian',
												'EUQ ' : 'Basque',
												'EVK ' : 'Evenki',
												'EVN ' : 'Even',
												'EWE ' : 'Ewe',
												'FAN ' : 'French Antillean',
												'FAR ' : 'Farsi',
												'FIN ' : 'Finnish',
												'FJI ' : 'Fijian',
												'FLE ' : 'Flemish',
												'FNE ' : 'Forest Nenets',
												'FON ' : 'Fon',
												'FOS ' : 'Faroese',
												'FRA ' : 'French',
												'FRI ' : 'Frisian',
												'FRL ' : 'Friulian',
												'FTA ' : 'Futa',
												'FUL ' : 'Fulani',
												'GAD ' : 'Ga',
												'GAE ' : 'Gaelic',
												'GAG ' : 'Gagauz',
												'GAL ' : 'Galician',
												'GAR ' : 'Garshuni',
												'GAW ' : 'Garhwali',
												'GEZ ' : "Ge'ez",
												'GIL ' : 'Gilyak',
												'GMZ ' : 'Gumuz',
												'GON ' : 'Gondi',
												'GRN ' : 'Greenlandic',
												'GRO ' : 'Garo',
												'GUA ' : 'Guarani',
												'GUJ ' : 'Gujarati',
												'HAI ' : 'Haitian',
												'HAL ' : 'Halam',
												'HAR ' : 'Harauti',
												'HAU ' : 'Hausa',
												'HAW ' : 'Hawaiin',
												'HBN ' : 'Hammer-Banna',
												'HIL ' : 'Hiligaynon',
												'HIN ' : 'Hindi',
												'HMA ' : 'High Mari',
												'HND ' : 'Hindko',
												'HO  ' : 'Ho',
												'HRI ' : 'Harari',
												'HRV ' : 'Croatian',
												'HUN ' : 'Hungarian',
												'HYE ' : 'Armenian',
												'IBO ' : 'Igbo',
												'IJO ' : 'Ijo',
												'ILO ' : 'Ilokano',
												'IND ' : 'Indonesian',
												'ING ' : 'Ingush',
												'INU ' : 'Inuktitut',
												'IPPH' : 'Phonetic transcription�IPA conventions',
												'IRI ' : 'Irish',
												'IRT ' : 'Irish Traditional',
												'ISL ' : 'Icelandic',
												'ISM ' : 'Inari Sami',
												'ITA ' : 'Italian',
												'IWR ' : 'Hebrew',
												'JAV ' : 'Javanese',
												'JII ' : 'Yiddish',
												'JAN ' : 'Japanese',
												'JUD ' : 'Judezmo',
												'JUL ' : 'Jula',
												'KAB ' : 'Kabardian',
												'KAC ' : 'Kachchi',
												'KAL ' : 'Kalenjin',
												'KAN ' : 'Kannada',
												'KAR ' : 'Karachay',
												'KAT ' : 'Georgian',
												'KAZ ' : 'Kazakh',
												'KEB ' : 'Kebena',
												'KGE ' : 'Khutsuri Georgian',
												'KHA ' : 'Khakass',
												'KHK ' : 'Khanty-Kazim',
												'KHM ' : 'Khmer',
												'KHS ' : 'Khanty-Shurishkar',
												'KHV ' : 'Khanty-Vakhi',
												'KHW ' : 'Khowar',
												'KIK ' : 'Kikuyu',
												'KIR ' : 'Kirghiz',
												'KIS ' : 'Kisii',
												'KKN ' : 'Kokni',
												'KLM ' : 'Kalmyk',
												'KMB ' : 'Kamba',
												'KMN ' : 'Kumaoni',
												'KMO ' : 'Komo',
												'KMS ' : 'Komso',
												'KNR ' : 'Kanuri',
												'KOD ' : 'Kodagu',
												'KOH ' : 'Korean Old Hangul',
												'KOK ' : 'Konkani',
												'KON ' : 'Kikongo',
												'KOP ' : 'Komi-Permyak',
												'KOR ' : 'Korean',
												'KOZ ' : 'Komi-Zyrian',
												'KPL ' : 'Kpelle',
												'KRI ' : 'Krio',
												'KRK ' : 'Karakalpak',
												'KRL ' : 'Karelian',
												'KRM ' : 'Karaim',
												'KRN ' : 'Karen',
												'KRT ' : 'Koorete',
												'KSH ' : 'Kashmiri',
												'KSI ' : 'Khasi',
												'KSM ' : 'Kildin Sami',
												'KUI ' : 'Kui',
												'KUL ' : 'Kulvi',
												'KUM ' : 'Kumyk',
												'KUR ' : 'Kurdish',
												'KUU ' : 'Kurukh',
												'KUY ' : 'Kuy',
												'KYK ' : 'Koryak',
												'LAD ' : 'Ladin',
												'LAH ' : 'Lahuli',
												'LAK ' : 'Lak',
												'LAM ' : 'Lambani',
												'LAO ' : 'Lao',
												'LAT ' : 'Latin',
												'LAZ ' : 'Laz',
												'LCR ' : 'L-Cree',
												'LDK ' : 'Ladakhi',
												'LEZ ' : 'Lezgi',
												'LIN ' : 'Lingala',
												'LMA ' : 'Low Mari',
												'LMB ' : 'Limbu',
												'LMW ' : 'Lomwe',
												'LSB ' : 'Lower Sorbian',
												'LSM ' : 'Lule Sami',
												'LTH ' : 'Lithuanian',
												'LTZ ' : 'Luxembourgish',
												'LUB ' : 'Luba',
												'LUG ' : 'Luganda',
												'LUH ' : 'Luhya',
												'LUO ' : 'Luo',
												'LVI ' : 'Latvian',
												'MAJ ' : 'Majang',
												'MAK ' : 'Makua',
												'MAL ' : 'Malayalam Traditional',
												'MAN ' : 'Mansi',
												'MAP ' : 'Mapudungun',
												'MAR ' : 'Marathi',
												'MAW ' : 'Marwari',
												'MBN ' : 'Mbundu',
												'MCH ' : 'Manchu',
												'MCR ' : 'Moose Cree',
												'MDE ' : 'Mende',
												'MEN ' : "Me'en",
												'MIZ ' : 'Mizo',
												'MKD ' : 'Macedonian',
												'MLE ' : 'Male',
												'MLG ' : 'Malagasy',
												'MLN ' : 'Malinke',
												'MLR ' : 'Malayalam Reformed',
												'MLY ' : 'Malay',
												'MND ' : 'Mandinka',
												'MNG ' : 'Mongolian',
												'MNI ' : 'Manipuri',
												'MNK ' : 'Maninka',
												'MNX ' : 'Manx Gaelic',
												'MOH ' : 'Mohawk',
												'MOK ' : 'Moksha',
												'MOL ' : 'Moldavian',
												'MON ' : 'Mon',
												'MOR ' : 'Moroccan',
												'MRI ' : 'Maori',
												'MTH ' : 'Maithili',
												'MTS ' : 'Maltese',
												'MUN ' : 'Mundari',
												'NAG ' : 'Naga-Assamese',
												'NAN ' : 'Nanai',
												'NAS ' : 'Naskapi',
												'NCR ' : 'N-Cree',
												'NDB ' : 'Ndebele',
												'NDG ' : 'Ndonga',
												'NEP ' : 'Nepali',
												'NEW ' : 'Newari',
												'NGR ' : 'Nagari',
												'NHC ' : 'Norway House Cree',
												'NIS ' : 'Nisi',
												'NIU ' : 'Niuean',
												'NKL ' : 'Nkole',
												'NKO ' : "N'Ko",
												'NLD ' : 'Dutch',
												'NOG ' : 'Nogai',
												'NOR ' : 'Norwegian',
												'NSM ' : 'Northern Sami',
												'NTA ' : 'Northern Tai',
												'NTO ' : 'Esperanto',
												'NYN ' : 'Nynorsk',
												'OCI ' : 'Occitan',
												'OCR ' : 'Oji-Cree',
												'OJB ' : 'Ojibway',
												'ORI ' : 'Odia (formerly Oriya)',
												'ORO ' : 'Oromo',
												'OSS ' : 'Ossetian',
												'PAA ' : 'Palestinian Aramaic',
												'PAL ' : 'Pali',
												'PAN ' : 'Punjabi',
												'PAP ' : 'Palpa',
												'PAS ' : 'Pashto',
												'PGR ' : 'Polytonic Greek',
												'PIL ' : 'Filipino',
												'PLG ' : 'Palaung',
												'PLK ' : 'Polish',
												'PRO ' : 'Provencal',
												'PTG ' : 'Portuguese',
												'QIN ' : 'Chin',
												'RAJ ' : 'Rajasthani',
												'RCR ' : 'R-Cree',
												'RBU ' : 'Russian Buriat',
												'RIA ' : 'Riang',
												'RMS ' : 'Rhaeto-Romanic',
												'ROM ' : 'Romanian',
												'ROY ' : 'Romany',
												'RSY ' : 'Rusyn',
												'RUA ' : 'Ruanda',
												'RUS ' : 'Russian',
												'SAD ' : 'Sadri',
												'SAN ' : 'Sanskrit',
												'SAT ' : 'Santali',
												'SAY ' : 'Sayisi',
												'SEK ' : 'Sekota',
												'SEL ' : 'Selkup',
												'SGO ' : 'Sango',
												'SHN ' : 'Shan',
												'SIB ' : 'Sibe',
												'SID ' : 'Sidamo',
												'SIG ' : 'Silte Gurage',
												'SKS ' : 'Skolt Sami',
												'SKY ' : 'Slovak',
												'SLA ' : 'Slavey',
												'SLV ' : 'Slovenian',
												'SML ' : 'Somali',
												'SMO ' : 'Samoan',
												'SNA ' : 'Sena',
												'SND ' : 'Sindhi',
												'SNH ' : 'Sinhalese',
												'SNK ' : 'Soninke',
												'SOG ' : 'Sodo Gurage',
												'SOT ' : 'Sotho',
												'SQI ' : 'Albanian',
												'SRB ' : 'Serbian',
												'SRK ' : 'Saraiki',
												'SRR ' : 'Serer',
												'SSL ' : 'South Slavey',
												'SSM ' : 'Southern Sami',
												'SUR ' : 'Suri',
												'SVA ' : 'Svan',
												'SVE ' : 'Swedish',
												'SWA ' : 'Swadaya Aramaic',
												'SWK ' : 'Swahili',
												'SWZ ' : 'Swazi',
												'SXT ' : 'Sutu',
												'SYR ' : 'Syriac',
												'TAB ' : 'Tabasaran',
												'TAJ ' : 'Tajiki',
												'TAM ' : 'Tamil',
												'TAT ' : 'Tatar',
												'TCR ' : 'TH-Cree',
												'TEL ' : 'Telugu',
												'TGN ' : 'Tongan',
												'TGR ' : 'Tigre',
												'TGY ' : 'Tigrinya',
												'THA ' : 'Thai',
												'THT ' : 'Tahitian',
												'TIB ' : 'Tibetan',
												'TKM ' : 'Turkmen',
												'TMN ' : 'Temne',
												'TNA ' : 'Tswana',
												'TNE ' : 'Tundra Nenets',
												'TNG ' : 'Tonga',
												'TOD ' : 'Todo',
												'TRK ' : 'Turkish',
												'TSG ' : 'Tsonga',
												'TUA ' : 'Turoyo Aramaic',
												'TUL ' : 'Tulu',
												'TUV ' : 'Tuvin',
												'TWI ' : 'Twi',
												'UDM ' : 'Udmurt',
												'UKR ' : 'Ukrainian',
												'URD ' : 'Urdu',
												'USB ' : 'Upper Sorbian',
												'UYG ' : 'Uyghur',
												'UZB ' : 'Uzbek',
												'VEN ' : 'Venda',
												'VIT ' : 'Vietnamese',
												'WA  ' : 'Wa',
												'WAG ' : 'Wagdi',
												'WCR ' : 'West-Cree',
												'WEL ' : 'Welsh',
												'WLF ' : 'Wolof',
												'XBD ' : 'Tai Lue',
												'XHS ' : 'Xhosa',
												'YAK ' : 'Sakha',
												'YBA ' : 'Yoruba',
												'YCR ' : 'Y-Cree',
												'YIC ' : 'Yi Classic',
												'YIM ' : 'Yi Modern',
												'ZHH ' : 'Chinese, Hong Kong SAR',
												'ZHP ' : 'Chinese Phonetic',
												'ZHS ' : 'Chinese Simplified',
												'ZHT ' : 'Chinese Traditional',
												'ZND ' : 'Zande',
												'ZUL ' : 'Zulu'}

languageTags = sorted(languageTagToNameMap.keys())

def isValidLanguageTag(tag:str) -> bool:
	'''Returns True if tag is in languageTagToNameMap'''
	return tag in languageTags
	
def getLanguageName(tag:str, default:str='Unregistered language') -> str:
	'''Returns friendly language name for the given tag'''
	return languageTagToNameMap.get(tag, default)
