/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.format.datetime;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.com.google.common.base.Optional;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.ImmutableMap;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hive.org.apache.commons.lang3.tuple.Pair;

public class HiveSqlDateTimeFormatter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int LONGEST_TOKEN_LENGTH = 5;
    private static final int LONGEST_ACCEPTED_PATTERN = 100;
    private static final int NANOS_MAX_LENGTH = 9;
    private static final DateTimeFormatter MONTH_FORMATTER = DateTimeFormatter.ofPattern("MMM");
    public static final int AM = 0;
    public static final int PM = 1;
    public static final DateTimeFormatter DAY_OF_WEEK_FORMATTER = DateTimeFormatter.ofPattern("EEE");
    private final String pattern;
    private final List<Token> tokens;
    private final Optional<LocalDateTime> now;
    private boolean formatExact = false;
    private static final Map<String, TemporalField> NUMERIC_TEMPORAL_TOKENS = ImmutableMap.builder().put("yyyy", ChronoField.YEAR).put("yyy", ChronoField.YEAR).put("yy", ChronoField.YEAR).put("y", ChronoField.YEAR).put("rrrr", ChronoField.YEAR).put("rr", ChronoField.YEAR).put("mm", ChronoField.MONTH_OF_YEAR).put("d", (ChronoField)WeekFields.SUNDAY_START.dayOfWeek()).put("dd", ChronoField.DAY_OF_MONTH).put("ddd", ChronoField.DAY_OF_YEAR).put("hh", ChronoField.HOUR_OF_AMPM).put("hh12", ChronoField.HOUR_OF_AMPM).put("hh24", ChronoField.HOUR_OF_DAY).put("mi", ChronoField.MINUTE_OF_HOUR).put("ss", ChronoField.SECOND_OF_MINUTE).put("sssss", ChronoField.SECOND_OF_DAY).put("ff1", ChronoField.NANO_OF_SECOND).put("ff2", ChronoField.NANO_OF_SECOND).put("ff3", ChronoField.NANO_OF_SECOND).put("ff4", ChronoField.NANO_OF_SECOND).put("ff5", ChronoField.NANO_OF_SECOND).put("ff6", ChronoField.NANO_OF_SECOND).put("ff7", ChronoField.NANO_OF_SECOND).put("ff8", ChronoField.NANO_OF_SECOND).put("ff9", ChronoField.NANO_OF_SECOND).put("ff", ChronoField.NANO_OF_SECOND).put("a.m.", ChronoField.AMPM_OF_DAY).put("am", ChronoField.AMPM_OF_DAY).put("p.m.", ChronoField.AMPM_OF_DAY).put("pm", ChronoField.AMPM_OF_DAY).put("ww", ChronoField.ALIGNED_WEEK_OF_YEAR).put("w", ChronoField.ALIGNED_WEEK_OF_MONTH).put("q", (ChronoField)IsoFields.QUARTER_OF_YEAR).put("iyyy", (ChronoField)IsoFields.WEEK_BASED_YEAR).put("iyy", (ChronoField)IsoFields.WEEK_BASED_YEAR).put("iy", (ChronoField)IsoFields.WEEK_BASED_YEAR).put("i", (ChronoField)IsoFields.WEEK_BASED_YEAR).put("iw", (ChronoField)IsoFields.WEEK_OF_WEEK_BASED_YEAR).put("id", ChronoField.DAY_OF_WEEK).build();
    private static final Map<String, TemporalField> CHARACTER_TEMPORAL_TOKENS = ImmutableMap.builder().put("mon", ChronoField.MONTH_OF_YEAR).put("month", ChronoField.MONTH_OF_YEAR).put("day", ChronoField.DAY_OF_WEEK).put("dy", ChronoField.DAY_OF_WEEK).build();
    private static final Map<String, TemporalUnit> TIME_ZONE_TOKENS = ImmutableMap.builder().put("tzh", ChronoUnit.HOURS).put("tzm", ChronoUnit.MINUTES).build();
    private static final List<String> VALID_ISO_8601_DELIMITERS = ImmutableList.of("t", "z");
    private static final List<String> VALID_SEPARATORS = ImmutableList.of("-", ":", " ", ".", "/", ";", "'", ",");
    private static final List<String> VALID_FORMAT_MODIFIERS = ImmutableList.of("fm", "fx");
    private static final Map<String, Integer> SPECIAL_LENGTHS = ImmutableMap.builder().put("hh12", 2).put("hh24", 2).put("tzm", 2).put("am", 4).put("pm", 4).put("ff1", 1).put("ff2", 2).put("ff3", 3).put("ff4", 4).put("ff5", 5).put("ff6", 6).put("ff7", 7).put("ff8", 8).put("ff9", 9).put("ff", 9).put("month", 9).put("day", 9).put("dy", 3).build();
    private static final List<TemporalField> ISO_8601_TEMPORAL_FIELDS = ImmutableList.of(ChronoField.DAY_OF_WEEK, IsoFields.WEEK_OF_WEEK_BASED_YEAR, IsoFields.WEEK_BASED_YEAR);
    private static final String MONTH_REGEX;
    private static final String DAY_OF_WEEK_REGEX;

    public HiveSqlDateTimeFormatter(String pattern, boolean forParsing) {
        this(pattern, forParsing, Optional.absent());
    }

    @VisibleForTesting
    HiveSqlDateTimeFormatter(String pattern, boolean forParsing, Optional<LocalDateTime> now) {
        this.pattern = Objects.requireNonNull(pattern, "Pattern cannot be null");
        this.now = Objects.requireNonNull(now);
        this.tokens = new ArrayList<Token>();
        Preconditions.checkArgument(pattern.length() < 100, "The input format is too long");
        this.parsePatternToTokens(pattern);
        if (forParsing) {
            this.verifyForParse();
        } else {
            this.verifyForFormat();
        }
    }

    private void parsePatternToTokens(String pattern) {
        this.tokens.clear();
        String originalPattern = pattern;
        pattern = pattern.toLowerCase();
        int begin = 0;
        int end = 0;
        Token lastAddedToken = null;
        boolean fillMode = false;
        block0: while (begin < pattern.length()) {
            if (begin != end) {
                this.tokens.clear();
                throw new IllegalArgumentException("Bad date/time conversion pattern: " + pattern);
            }
            for (int i = 5; i > 0; --i) {
                end = begin + i;
                if (end > pattern.length()) continue;
                String candidate = pattern.substring(begin, end);
                if (this.isSeparator(candidate)) {
                    lastAddedToken = this.parseSeparatorToken(candidate, lastAddedToken, fillMode, begin);
                    begin = end;
                    continue block0;
                }
                if (this.isIso8601Delimiter(candidate)) {
                    lastAddedToken = this.parseIso8601DelimiterToken(candidate, fillMode, begin);
                    begin = end;
                    continue block0;
                }
                if (this.isNumericTemporalToken(candidate)) {
                    lastAddedToken = this.parseTemporalToken(originalPattern, candidate, fillMode, begin);
                    fillMode = false;
                    begin = end;
                    continue block0;
                }
                if (this.isCharacterTemporalToken(candidate)) {
                    lastAddedToken = this.parseCharacterTemporalToken(originalPattern, candidate, fillMode, begin);
                    fillMode = false;
                    begin = end;
                    continue block0;
                }
                if (this.isTimeZoneToken(candidate)) {
                    lastAddedToken = this.parseTimeZoneToken(candidate, fillMode, begin);
                    begin = end;
                    continue block0;
                }
                if (this.isTextToken(candidate)) {
                    lastAddedToken = this.parseTextToken(originalPattern, fillMode, begin);
                    end = begin + lastAddedToken.length + 2;
                    lastAddedToken.removeBackslashes();
                    begin = end;
                    continue block0;
                }
                if (!this.isFormatModifierToken(candidate)) continue;
                this.checkFillModeOff(fillMode, begin);
                fillMode = this.isFm(candidate);
                if (!fillMode) {
                    this.formatExact = true;
                }
                begin = end;
                continue block0;
            }
        }
    }

    private boolean isSeparator(String candidate) {
        return candidate.length() == 1 && VALID_SEPARATORS.contains(candidate);
    }

    private boolean isIso8601Delimiter(String candidate) {
        return candidate.length() == 1 && VALID_ISO_8601_DELIMITERS.contains(candidate);
    }

    private boolean isNumericTemporalToken(String candidate) {
        return NUMERIC_TEMPORAL_TOKENS.containsKey(candidate);
    }

    private boolean isCharacterTemporalToken(String candidate) {
        return CHARACTER_TEMPORAL_TOKENS.containsKey(candidate);
    }

    private boolean isTimeZoneToken(String pattern) {
        return TIME_ZONE_TOKENS.containsKey(pattern);
    }

    private boolean isTextToken(String candidate) {
        return candidate.startsWith("\"");
    }

    private boolean isFormatModifierToken(String candidate) {
        return candidate.length() == 2 && VALID_FORMAT_MODIFIERS.contains(candidate);
    }

    private boolean isFm(String candidate) {
        return "fm".equals(candidate);
    }

    private Token parseSeparatorToken(String candidate, Token lastAddedToken, boolean fillMode, int begin) {
        this.checkFillModeOff(fillMode, begin);
        if (lastAddedToken != null && lastAddedToken.type == TokenType.SEPARATOR) {
            lastAddedToken.string = lastAddedToken.string + candidate;
            ++lastAddedToken.length;
        } else {
            lastAddedToken = new Token(TokenType.SEPARATOR, candidate);
            this.tokens.add(lastAddedToken);
        }
        return lastAddedToken;
    }

    private Token parseIso8601DelimiterToken(String candidate, boolean fillMode, int begin) {
        this.checkFillModeOff(fillMode, begin);
        Token lastAddedToken = new Token(TokenType.ISO_8601_DELIMITER, candidate.toUpperCase());
        this.tokens.add(lastAddedToken);
        return lastAddedToken;
    }

    private Token parseTemporalToken(String originalPattern, String candidate, boolean fillMode, int begin) {
        if (NUMERIC_TEMPORAL_TOKENS.get(candidate) == ChronoField.AMPM_OF_DAY) {
            int subStringEnd = begin + candidate.length();
            candidate = originalPattern.substring(begin, subStringEnd);
        }
        Token lastAddedToken = new Token(TokenType.NUMERIC_TEMPORAL, NUMERIC_TEMPORAL_TOKENS.get(candidate.toLowerCase()), candidate, this.getTokenStringLength(candidate), fillMode);
        this.tokens.add(lastAddedToken);
        return lastAddedToken;
    }

    private Token parseCharacterTemporalToken(String originalPattern, String candidate, boolean fillMode, int begin) {
        candidate = originalPattern.substring(begin, begin + candidate.length());
        Token lastAddedToken = new Token(TokenType.CHARACTER_TEMPORAL, CHARACTER_TEMPORAL_TOKENS.get(candidate.toLowerCase()), candidate, this.getTokenStringLength(candidate), fillMode);
        this.tokens.add(lastAddedToken);
        return lastAddedToken;
    }

    private Token parseTimeZoneToken(String candidate, boolean fillMode, int begin) {
        this.checkFillModeOff(fillMode, begin);
        Token lastAddedToken = new Token(TIME_ZONE_TOKENS.get(candidate), candidate, this.getTokenStringLength(candidate), false);
        this.tokens.add(lastAddedToken);
        return lastAddedToken;
    }

    private Token parseTextToken(String fullPattern, boolean fillMode, int begin) {
        this.checkFillModeOff(fillMode, begin);
        int end = begin;
        do {
            if ((end = fullPattern.indexOf(34, end + 1)) != -1) continue;
            throw new IllegalArgumentException("Missing closing double quote (\") opened at index " + begin);
        } while ("\\".equals(fullPattern.substring(end - 1, end)));
        Token lastAddedToken = new Token(TokenType.TEXT, fullPattern.substring(begin + 1, end));
        this.tokens.add(lastAddedToken);
        return lastAddedToken;
    }

    private void checkFillModeOff(boolean fillMode, int index) {
        if (fillMode) {
            throw new IllegalArgumentException("Bad date/time conversion pattern: " + this.pattern + ". Error at index " + index + ": Fill mode modifier (FM) must be followed by a temporal token.");
        }
    }

    private int getTokenStringLength(String candidate) {
        Integer length = SPECIAL_LENGTHS.get(candidate.toLowerCase());
        if (length != null) {
            return length;
        }
        return candidate.length();
    }

    private void verifyForParse() {
        ArrayList<TemporalField> temporalFields = new ArrayList<TemporalField>();
        ArrayList<TemporalUnit> timeZoneTemporalUnits = new ArrayList<TemporalUnit>();
        int roundYearCount = 0;
        int yearCount = 0;
        boolean containsIsoFields = false;
        boolean containsGregorianFields = false;
        for (Token token : this.tokens) {
            if (token.temporalField != null) {
                temporalFields.add(token.temporalField);
                if (token.temporalField == ChronoField.YEAR) {
                    if (token.string.startsWith("r")) {
                        ++roundYearCount;
                    } else {
                        ++yearCount;
                    }
                }
                if (!token.temporalField.isDateBased() || token.temporalField == ChronoField.DAY_OF_WEEK) continue;
                if (ISO_8601_TEMPORAL_FIELDS.contains(token.temporalField)) {
                    containsIsoFields = true;
                    continue;
                }
                containsGregorianFields = true;
                continue;
            }
            if (token.temporalUnit == null) continue;
            timeZoneTemporalUnits.add(token.temporalUnit);
        }
        if (temporalFields.contains(IsoFields.QUARTER_OF_YEAR)) {
            throw new IllegalArgumentException("Illegal field: q (" + IsoFields.QUARTER_OF_YEAR + ")");
        }
        if (temporalFields.contains(WeekFields.SUNDAY_START.dayOfWeek())) {
            throw new IllegalArgumentException("Illegal field: d (" + WeekFields.SUNDAY_START.dayOfWeek() + ")");
        }
        if (temporalFields.contains(ChronoField.DAY_OF_WEEK) && containsGregorianFields) {
            throw new IllegalArgumentException("Illegal field: dy/day (" + ChronoField.DAY_OF_WEEK + ")");
        }
        if (temporalFields.contains(ChronoField.ALIGNED_WEEK_OF_MONTH)) {
            throw new IllegalArgumentException("Illegal field: w (" + ChronoField.ALIGNED_WEEK_OF_MONTH + ")");
        }
        if (temporalFields.contains(ChronoField.ALIGNED_WEEK_OF_YEAR)) {
            throw new IllegalArgumentException("Illegal field: ww (" + ChronoField.ALIGNED_WEEK_OF_YEAR + ")");
        }
        if (containsGregorianFields && containsIsoFields) {
            throw new IllegalArgumentException("Pattern cannot contain both ISO and Gregorian tokens");
        }
        if (!temporalFields.contains(ChronoField.YEAR) && !temporalFields.contains(IsoFields.WEEK_BASED_YEAR)) {
            throw new IllegalArgumentException("Missing year token.");
        }
        if (!(!containsGregorianFields || temporalFields.contains(ChronoField.MONTH_OF_YEAR) && temporalFields.contains(ChronoField.DAY_OF_MONTH) || temporalFields.contains(ChronoField.DAY_OF_YEAR))) {
            throw new IllegalArgumentException("Missing day of year or (month of year + day of month) tokens.");
        }
        if (!(!containsIsoFields || temporalFields.contains(IsoFields.WEEK_OF_WEEK_BASED_YEAR) && temporalFields.contains(ChronoField.DAY_OF_WEEK))) {
            throw new IllegalArgumentException("Missing week of year (iw) or day of week (id) tokens.");
        }
        if (roundYearCount > 0 && yearCount > 0) {
            throw new IllegalArgumentException("Invalid duplication of format element: Both year andround year are provided");
        }
        for (TemporalField tokenType : temporalFields) {
            if (Collections.frequency(temporalFields, tokenType) <= 1) continue;
            throw new IllegalArgumentException("Invalid duplication of format element: multiple " + tokenType + " tokens provided.");
        }
        if (temporalFields.contains(ChronoField.AMPM_OF_DAY) && !temporalFields.contains(ChronoField.HOUR_OF_DAY) && !temporalFields.contains(ChronoField.HOUR_OF_AMPM)) {
            throw new IllegalArgumentException("AM/PM provided but missing hour token.");
        }
        if (temporalFields.contains(ChronoField.AMPM_OF_DAY) && temporalFields.contains(ChronoField.HOUR_OF_DAY)) {
            throw new IllegalArgumentException("Conflict between median indicator and hour token.");
        }
        if (temporalFields.contains(ChronoField.HOUR_OF_AMPM) && temporalFields.contains(ChronoField.HOUR_OF_DAY)) {
            throw new IllegalArgumentException("Conflict between hour of day and hour of am/pm token.");
        }
        if (temporalFields.contains(ChronoField.DAY_OF_YEAR) && (temporalFields.contains(ChronoField.DAY_OF_MONTH) || temporalFields.contains(ChronoField.MONTH_OF_YEAR))) {
            throw new IllegalArgumentException("Day of year provided with day or month token.");
        }
        if (temporalFields.contains(ChronoField.SECOND_OF_DAY) && (temporalFields.contains(ChronoField.HOUR_OF_DAY) || temporalFields.contains(ChronoField.HOUR_OF_AMPM) || temporalFields.contains(ChronoField.MINUTE_OF_HOUR) || temporalFields.contains(ChronoField.SECOND_OF_MINUTE))) {
            throw new IllegalArgumentException("Second of day token conflicts with other token(s).");
        }
        if (timeZoneTemporalUnits.contains(ChronoUnit.MINUTES) && !timeZoneTemporalUnits.contains(ChronoUnit.HOURS)) {
            throw new IllegalArgumentException("Time zone minute token provided without time zone hour token.");
        }
    }

    private void verifyForFormat() {
        for (Token token : this.tokens) {
            if (token.type != TokenType.TIMEZONE) continue;
            throw new IllegalArgumentException(token.string.toUpperCase() + " not a valid format for timestamp or date.");
        }
    }

    public String format(Timestamp ts) {
        StringBuilder fullOutputSb = new StringBuilder();
        String outputString = null;
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(ts.toEpochSecond(), ts.getNanos(), ZoneOffset.UTC);
        for (Token token : this.tokens) {
            switch (token.type) {
                case NUMERIC_TEMPORAL: 
                case CHARACTER_TEMPORAL: {
                    try {
                        int value = localDateTime.get(token.temporalField);
                        if (token.type == TokenType.NUMERIC_TEMPORAL) {
                            outputString = this.formatNumericTemporal(value, token);
                            break;
                        }
                        outputString = this.formatCharacterTemporal(value, token);
                        break;
                    }
                    catch (DateTimeException e) {
                        throw new IllegalArgumentException(token.temporalField + " couldn't be obtained from LocalDateTime " + localDateTime, e);
                    }
                }
                case TIMEZONE: {
                    throw new IllegalArgumentException(token.string.toUpperCase() + " not a valid format for timestamp or date.");
                }
                case SEPARATOR: 
                case TEXT: {
                    outputString = token.string;
                    break;
                }
                case ISO_8601_DELIMITER: {
                    outputString = token.string.toUpperCase();
                    break;
                }
            }
            fullOutputSb.append(outputString);
        }
        return fullOutputSb.toString();
    }

    public String format(Date date) {
        return this.format(Timestamp.ofEpochSecond(date.toEpochSecond()));
    }

    private String formatNumericTemporal(int value, Token token) {
        String output;
        if (token.temporalField == ChronoField.AMPM_OF_DAY) {
            output = value == 0 ? "a" : "p";
            output = output + (token.string.length() == 2 ? "m" : ".m.");
            if (token.string.startsWith("A") || token.string.startsWith("P")) {
                output = output.toUpperCase();
            }
        } else {
            if (token.temporalField == ChronoField.HOUR_OF_AMPM && value == 0) {
                value = 12;
            }
            try {
                output = Integer.toString(value);
                output = this.padOrTruncateNumericTemporal(token, output);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value: " + value + " could not be cast to string.", e);
            }
        }
        return output;
    }

    private String formatCharacterTemporal(int value, Token token) {
        String output = null;
        if (token.temporalField == ChronoField.MONTH_OF_YEAR) {
            output = Month.of(value).getDisplayName(TextStyle.FULL, Locale.US);
        } else if (token.temporalField == ChronoField.DAY_OF_WEEK) {
            output = DayOfWeek.of(value).getDisplayName(TextStyle.FULL, Locale.US);
        }
        if (output == null) {
            throw new IllegalStateException("TemporalField: " + token.temporalField + " not valid for character formatting.");
        }
        if (output.length() > token.length) {
            output = output.substring(0, token.length);
        } else if (!token.fillMode && output.length() < token.length) {
            output = StringUtils.rightPad(output, token.length);
        }
        output = Character.isLowerCase(token.string.charAt(0)) ? output.toLowerCase() : (Character.isUpperCase(token.string.charAt(1)) ? output.toUpperCase() : HiveSqlDateTimeFormatter.capitalize(output));
        return output;
    }

    private String padOrTruncateNumericTemporal(Token token, String output) {
        if (token.temporalField == ChronoField.NANO_OF_SECOND) {
            if ((output = StringUtils.leftPad(output, 9, '0')).length() > token.length) {
                output = output.substring(0, token.length);
            }
            if (token.string.equalsIgnoreCase("ff")) {
                output = output.replaceAll("0*$", "");
            }
        } else {
            if (output.length() < token.length && !token.fillMode) {
                output = StringUtils.leftPad(output, token.length, '0');
            } else if (output.length() > token.length) {
                output = output.substring(output.length() - token.length);
            }
            if (token.fillMode) {
                output = output.replaceAll("^0*", "");
            }
        }
        if (output.isEmpty()) {
            output = "0";
        }
        return output;
    }

    public Timestamp parseTimestamp(String fullInput) {
        int index = 0;
        int timeZoneHours = 0;
        int timeZoneMinutes = 0;
        int iyyy = 0;
        int iw = 0;
        ArrayList<Integer> temporalValues = new ArrayList<Integer>();
        for (Token token : this.tokens) {
            switch (token.type) {
                case NUMERIC_TEMPORAL: 
                case CHARACTER_TEMPORAL: {
                    int value;
                    String substring;
                    if (token.type == TokenType.NUMERIC_TEMPORAL) {
                        substring = this.getNextNumericSubstring(fullInput, index, token);
                        value = this.parseNumericTemporal(substring, token);
                    } else {
                        substring = this.getNextCharacterSubstring(fullInput, index, token);
                        value = this.parseCharacterTemporal(substring, token);
                    }
                    temporalValues.add(value);
                    if (token.temporalField == IsoFields.WEEK_BASED_YEAR) {
                        iyyy = value;
                    }
                    if (token.temporalField == IsoFields.WEEK_OF_WEEK_BASED_YEAR) {
                        iw = value;
                    }
                    index += substring.length();
                    break;
                }
                case TIMEZONE: {
                    String substring;
                    if (token.temporalUnit == ChronoUnit.HOURS) {
                        String nextCharacter = fullInput.substring(index, index + 1);
                        if ("-".equals(nextCharacter) || "+".equals(nextCharacter)) {
                            ++index;
                        }
                        substring = this.getNextNumericSubstring(fullInput, index, index + 2, token);
                        try {
                            timeZoneHours = Integer.parseInt(substring);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Couldn't parse substring \"" + substring + "\" with token " + token + " to int. Pattern is " + this.pattern, e);
                        }
                        if (timeZoneHours < -15 || timeZoneHours > 15) {
                            throw new IllegalArgumentException("Couldn't parse substring \"" + substring + "\" to TZH because TZH range is -15 to +15. Pattern is " + this.pattern);
                        }
                    } else {
                        substring = this.getNextNumericSubstring(fullInput, index, token);
                        try {
                            timeZoneMinutes = Integer.parseInt(substring);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Couldn't parse substring \"" + substring + "\" with token " + token + " to int. Pattern is " + this.pattern, e);
                        }
                        if (timeZoneMinutes < 0 || timeZoneMinutes > 59) {
                            throw new IllegalArgumentException("Couldn't parse substring \"" + substring + "\" to TZM because TZM range is 0 to 59. Pattern is " + this.pattern);
                        }
                    }
                    index += substring.length();
                    break;
                }
                case SEPARATOR: {
                    index = this.parseSeparator(fullInput, index, token);
                    break;
                }
                case TEXT: 
                case ISO_8601_DELIMITER: {
                    index = this.parseText(fullInput, index, token);
                }
            }
        }
        this.checkForLeftoverInput(fullInput, index);
        this.checkForInvalidIsoWeek(iyyy, iw);
        return this.getTimestampFromValues(this.tokens, temporalValues);
    }

    private void checkForLeftoverInput(String fullInput, int index) {
        if (!fullInput.substring(index).isEmpty()) {
            throw new IllegalArgumentException("Leftover input after parsing: " + fullInput.substring(index) + " in string " + fullInput);
        }
    }

    private void checkForInvalidIsoWeek(int iyyy, int iw) {
        if (iyyy == 0) {
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
        try {
            ldt = ldt.with(IsoFields.WEEK_BASED_YEAR, iyyy);
            ldt = ldt.with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, iw);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e);
        }
        if (ldt.getYear() != iyyy) {
            throw new IllegalArgumentException("ISO year " + iyyy + " does not have " + iw + " weeks.");
        }
    }

    private Timestamp getTimestampFromValues(List<Token> tokens, List<Integer> temporalValues) {
        List temporalTokens = tokens.stream().filter(token -> token.type == TokenType.NUMERIC_TEMPORAL || token.type == TokenType.CHARACTER_TEMPORAL).collect(Collectors.toList());
        Preconditions.checkState(temporalTokens.size() == temporalValues.size(), "temporalTokens list length (" + temporalTokens.size() + ") differs from that of temporalValues (length: " + temporalValues.size() + ")");
        ArrayList<ImmutablePair<Object, Integer>> tokenValueList = new ArrayList<ImmutablePair<Object, Integer>>(temporalTokens.size());
        for (int i = 0; i < temporalTokens.size(); ++i) {
            ImmutablePair pair = new ImmutablePair(temporalTokens.get(i), temporalValues.get(i));
            tokenValueList.add(pair);
        }
        tokenValueList.sort(((Comparator)(o1, o2) -> {
            Token token1 = (Token)o1.left;
            Token token2 = (Token)o2.left;
            return token1.temporalField.getBaseUnit().getDuration().compareTo(token2.temporalField.getBaseUnit().getDuration());
        }).reversed());
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
        for (Pair pair : tokenValueList) {
            TemporalField temporalField = ((Token)pair.getLeft()).temporalField;
            int value = (Integer)pair.getRight();
            try {
                ldt = ldt.with(temporalField, value);
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException("Value " + value + " not valid for token " + temporalField);
            }
        }
        return Timestamp.ofEpochSecond(ldt.toEpochSecond(ZoneOffset.UTC), ldt.getNano());
    }

    public Date parseDate(String input) {
        return Date.ofEpochMilli(this.parseTimestamp(input).toEpochMilli());
    }

    private String getNextNumericSubstring(String s2, int begin, Token token) {
        return this.getNextNumericSubstring(s2, begin, begin + token.length, token);
    }

    private String getNextNumericSubstring(String s2, int begin, int end, Token token) {
        if (end > s2.length()) {
            end = s2.length();
        }
        s2 = s2.substring(begin, end);
        if (token.temporalField == ChronoField.AMPM_OF_DAY) {
            if (s2.charAt(1) == 'm' || s2.charAt(1) == 'M') {
                return s2.substring(0, 2);
            }
            return s2;
        }
        if (token.type == TokenType.CHARACTER_TEMPORAL && s2.matches(".*[^A-Za-z].*")) {
            s2 = s2.split("[^A-Za-z]", 2)[0];
        } else if ((token.type == TokenType.NUMERIC_TEMPORAL || token.type == TokenType.TIMEZONE) && s2.matches(".*\\D.*")) {
            s2 = s2.split("\\D", 2)[0];
        }
        return s2;
    }

    private int parseNumericTemporal(String substring, Token token) {
        this.checkFormatExact(substring, token);
        if (token.temporalField == ChronoField.AMPM_OF_DAY) {
            return substring.toLowerCase().startsWith("a") ? 0 : 1;
        }
        if (token.temporalField == ChronoField.HOUR_OF_AMPM) {
            if ("12".equals(substring)) {
                return 0;
            }
            if ("0".equals(substring)) {
                throw new IllegalArgumentException("Value of hour of day (hh/hh12) in input is 0. The value should be between 1 and 12.");
            }
        }
        if (token.temporalField == ChronoField.YEAR || token.temporalField == IsoFields.WEEK_BASED_YEAR) {
            String currentYearString = token.temporalField == ChronoField.YEAR ? Integer.toString(this.now.or(LocalDateTime.now()).getYear()) : Integer.toString(this.now.or(LocalDateTime.now()).get(IsoFields.WEEK_BASED_YEAR));
            if (token.string.startsWith("r") && substring.length() == 2) {
                int currFirst2Digits = Integer.parseInt(currentYearString.substring(0, 2));
                int currLast2Digits = Integer.parseInt(currentYearString.substring(2));
                int valLast2Digits = Integer.parseInt(substring);
                if (valLast2Digits < 50 && currLast2Digits >= 50) {
                    ++currFirst2Digits;
                } else if (valLast2Digits >= 50 && currLast2Digits < 50) {
                    --currFirst2Digits;
                }
                substring = Integer.toString(currFirst2Digits) + substring;
            } else {
                substring = currentYearString.substring(0, 4 - substring.length()) + substring;
            }
        } else if (token.temporalField == ChronoField.NANO_OF_SECOND) {
            int i = Integer.min(token.length, substring.length());
            substring = substring + StringUtils.repeat("0", 9 - i);
        }
        try {
            return Integer.parseInt(substring);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Couldn't parse substring \"" + substring + "\" with token " + token + " to integer. Pattern is " + this.pattern, e);
        }
    }

    private String getNextCharacterSubstring(String fullInput, int index, Token token) {
        String regex;
        int end = index + token.length;
        if (end > fullInput.length()) {
            end = fullInput.length();
        }
        String substring = fullInput.substring(index, end);
        if (token.length == 3) {
            return substring;
        }
        if (token.temporalField == ChronoField.MONTH_OF_YEAR) {
            regex = MONTH_REGEX;
        } else if (token.temporalField == ChronoField.DAY_OF_WEEK) {
            regex = DAY_OF_WEEK_REGEX;
        } else {
            throw new IllegalArgumentException("Error at index " + index + ": " + token + " not a character temporal with length not 3");
        }
        Matcher matcher = Pattern.compile(regex, 2).matcher(substring);
        if (matcher.find()) {
            return substring.substring(0, matcher.end());
        }
        throw new IllegalArgumentException("Couldn't find " + token.string + " in substring " + substring + " at index " + index);
    }

    private int parseCharacterTemporal(String substring, Token token) {
        try {
            if (token.temporalField == ChronoField.MONTH_OF_YEAR) {
                if (token.length == 3) {
                    return Month.from(MONTH_FORMATTER.parse(HiveSqlDateTimeFormatter.capitalize(substring))).getValue();
                }
                return Month.valueOf(substring.toUpperCase()).getValue();
            }
            if (token.temporalField == ChronoField.DAY_OF_WEEK) {
                if (token.length == 3) {
                    return DayOfWeek.from(DAY_OF_WEEK_FORMATTER.parse(HiveSqlDateTimeFormatter.capitalize(substring))).getValue();
                }
                return DayOfWeek.valueOf(substring.toUpperCase()).getValue();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't parse substring \"" + substring + "\" with token " + token + " to integer.Pattern is " + this.pattern, e);
        }
        throw new IllegalArgumentException("token: (" + token + ") isn't a valid character temporal. Pattern is " + this.pattern);
    }

    private void checkFormatExact(String substring, Token token) {
        if (this.formatExact && token.temporalField == ChronoField.AMPM_OF_DAY) {
            token.length = token.string.length();
        }
        if (this.formatExact && !token.fillMode && token.temporalField != ChronoField.NANO_OF_SECOND && token.length != substring.length()) {
            throw new IllegalArgumentException("FX on and expected token length " + token.length + " for token " + token + " does not match substring (" + substring + ") length " + substring.length());
        }
    }

    private int parseSeparator(String fullInput, int index, Token token) {
        int begin = index;
        StringBuilder separatorsFound = new StringBuilder();
        while (index < fullInput.length() && VALID_SEPARATORS.contains(fullInput.substring(index, index + 1))) {
            String s2 = fullInput.substring(index, index + 1);
            if (!(this.isLastCharacterOfSeparator(index, fullInput) && "-".equals(s2) && this.nextTokenIs("tzh", token) && separatorsFound.length() != 0)) {
                separatorsFound.append(s2);
            }
            ++index;
        }
        if (separatorsFound.length() == 0) {
            throw new IllegalArgumentException("Missing separator at index " + index);
        }
        if (this.formatExact && !token.string.equals(separatorsFound.toString())) {
            throw new IllegalArgumentException("FX on and separator found: " + separatorsFound + " does not match expected separator: " + token.string);
        }
        return begin + separatorsFound.length();
    }

    private int parseText(String fullInput, int index, Token token) {
        String substring = fullInput.substring(index, index + token.length);
        if (!token.string.equalsIgnoreCase(substring)) {
            throw new IllegalArgumentException("Wrong input at index " + index + ": Expected: \"" + token.string + "\" but got: \"" + substring + "\" for token: " + token);
        }
        return index + token.length;
    }

    private boolean isLastCharacterOfSeparator(int index, String string) {
        if (index == string.length() - 1) {
            return true;
        }
        return !VALID_SEPARATORS.contains(string.substring(index + 1, index + 2));
    }

    private boolean nextTokenIs(String pattern, Token currentToken) {
        int idx = this.tokens.indexOf(currentToken);
        if (idx == this.tokens.size() - 1) {
            return false;
        }
        Token nextToken = this.tokens.get(idx + 1);
        return this.isTimeZoneToken(pattern = pattern.toLowerCase()) && TIME_ZONE_TOKENS.get(pattern) == nextToken.temporalUnit || this.isNumericTemporalToken(pattern) && NUMERIC_TEMPORAL_TOKENS.get(pattern) == nextToken.temporalField || this.isCharacterTemporalToken(pattern) && CHARACTER_TEMPORAL_TOKENS.get(pattern) == nextToken.temporalField;
    }

    public String getPattern() {
        return this.pattern;
    }

    protected List<Token> getTokens() {
        return new ArrayList<Token>(this.tokens);
    }

    private static String capitalize(String substring) {
        return StringUtils.capitalize(substring.toLowerCase());
    }

    static {
        StringBuilder sb = new StringBuilder();
        String or = "";
        for (Month month : Month.values()) {
            sb.append(or).append(month);
            or = "|";
        }
        MONTH_REGEX = sb.toString();
        sb = new StringBuilder();
        or = "";
        for (Enum enum_ : DayOfWeek.values()) {
            sb.append(or).append(enum_);
            or = "|";
        }
        DAY_OF_WEEK_REGEX = sb.toString();
    }

    public static class Token
    implements Serializable {
        private static final long serialVersionUID = 1L;
        TokenType type;
        TemporalField temporalField;
        TemporalUnit temporalUnit;
        String string;
        int length;
        boolean fillMode;

        public Token(TokenType tokenType, TemporalField temporalField, String string, int length, boolean fillMode) {
            this(tokenType, temporalField, null, string, length, fillMode);
        }

        public Token(TemporalUnit temporalUnit, String string, int length, boolean fillMode) {
            this(TokenType.TIMEZONE, null, temporalUnit, string, length, fillMode);
        }

        public Token(TokenType tokenType, String string) {
            this(tokenType, null, null, string, string.length(), false);
        }

        public Token(TokenType tokenType, TemporalField temporalField, TemporalUnit temporalUnit, String string, int length, boolean fillMode) {
            this.type = tokenType;
            this.temporalField = temporalField;
            this.temporalUnit = temporalUnit;
            this.string = string;
            this.length = length;
            this.fillMode = fillMode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.string);
            sb.append(" type: ");
            sb.append((Object)this.type);
            if (this.temporalField != null) {
                sb.append(" temporalField: ");
                sb.append(this.temporalField);
            } else if (this.temporalUnit != null) {
                sb.append(" temporalUnit: ");
                sb.append(this.temporalUnit);
            }
            return sb.toString();
        }

        public void removeBackslashes() {
            this.string = this.string.replaceAll("\\\\", "");
            this.length = this.string.length();
        }
    }

    public static enum TokenType {
        NUMERIC_TEMPORAL,
        CHARACTER_TEMPORAL,
        SEPARATOR,
        TIMEZONE,
        ISO_8601_DELIMITER,
        TEXT;

    }
}

