/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.ObjectDictionary;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hive.org.apache.thrift.TBase;
import org.apache.hive.org.apache.thrift.TBaseHelper;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.TFieldIdEnum;
import org.apache.hive.org.apache.thrift.annotation.Nullable;
import org.apache.hive.org.apache.thrift.meta_data.FieldMetaData;
import org.apache.hive.org.apache.thrift.meta_data.ListMetaData;
import org.apache.hive.org.apache.thrift.meta_data.StructMetaData;
import org.apache.hive.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hive.org.apache.thrift.protocol.TField;
import org.apache.hive.org.apache.thrift.protocol.TList;
import org.apache.hive.org.apache.thrift.protocol.TProtocol;
import org.apache.hive.org.apache.thrift.protocol.TProtocolException;
import org.apache.hive.org.apache.thrift.protocol.TProtocolUtil;
import org.apache.hive.org.apache.thrift.protocol.TStruct;
import org.apache.hive.org.apache.thrift.protocol.TTupleProtocol;
import org.apache.hive.org.apache.thrift.scheme.IScheme;
import org.apache.hive.org.apache.thrift.scheme.SchemeFactory;
import org.apache.hive.org.apache.thrift.scheme.StandardScheme;
import org.apache.hive.org.apache.thrift.scheme.TupleScheme;
import org.apache.hive.org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class GetPartitionsByNamesResult
implements TBase<GetPartitionsByNamesResult, _Fields>,
Serializable,
Cloneable,
Comparable<GetPartitionsByNamesResult> {
    private static final TStruct STRUCT_DESC = new TStruct("GetPartitionsByNamesResult");
    private static final TField PARTITIONS_FIELD_DESC = new TField("partitions", 15, 1);
    private static final TField DICTIONARY_FIELD_DESC = new TField("dictionary", 12, 2);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new GetPartitionsByNamesResultStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new GetPartitionsByNamesResultTupleSchemeFactory();
    @Nullable
    private List<Partition> partitions;
    @Nullable
    private ObjectDictionary dictionary;
    private static final _Fields[] optionals = new _Fields[]{_Fields.DICTIONARY};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public GetPartitionsByNamesResult() {
    }

    public GetPartitionsByNamesResult(List<Partition> partitions) {
        this();
        this.partitions = partitions;
    }

    public GetPartitionsByNamesResult(GetPartitionsByNamesResult other) {
        if (other.isSetPartitions()) {
            ArrayList<Partition> __this__partitions = new ArrayList<Partition>(other.partitions.size());
            for (Partition other_element : other.partitions) {
                __this__partitions.add(new Partition(other_element));
            }
            this.partitions = __this__partitions;
        }
        if (other.isSetDictionary()) {
            this.dictionary = new ObjectDictionary(other.dictionary);
        }
    }

    @Override
    public GetPartitionsByNamesResult deepCopy() {
        return new GetPartitionsByNamesResult(this);
    }

    @Override
    public void clear() {
        this.partitions = null;
        this.dictionary = null;
    }

    public int getPartitionsSize() {
        return this.partitions == null ? 0 : this.partitions.size();
    }

    @Nullable
    public Iterator<Partition> getPartitionsIterator() {
        return this.partitions == null ? null : this.partitions.iterator();
    }

    public void addToPartitions(Partition elem) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<Partition>();
        }
        this.partitions.add(elem);
    }

    @Nullable
    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(@Nullable List<Partition> partitions) {
        this.partitions = partitions;
    }

    public void unsetPartitions() {
        this.partitions = null;
    }

    public boolean isSetPartitions() {
        return this.partitions != null;
    }

    public void setPartitionsIsSet(boolean value) {
        if (!value) {
            this.partitions = null;
        }
    }

    @Nullable
    public ObjectDictionary getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(@Nullable ObjectDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public void unsetDictionary() {
        this.dictionary = null;
    }

    public boolean isSetDictionary() {
        return this.dictionary != null;
    }

    public void setDictionaryIsSet(boolean value) {
        if (!value) {
            this.dictionary = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case PARTITIONS: {
                if (value == null) {
                    this.unsetPartitions();
                    break;
                }
                this.setPartitions((List)value);
                break;
            }
            case DICTIONARY: {
                if (value == null) {
                    this.unsetDictionary();
                    break;
                }
                this.setDictionary((ObjectDictionary)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PARTITIONS: {
                return this.getPartitions();
            }
            case DICTIONARY: {
                return this.getDictionary();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PARTITIONS: {
                return this.isSetPartitions();
            }
            case DICTIONARY: {
                return this.isSetDictionary();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof GetPartitionsByNamesResult) {
            return this.equals((GetPartitionsByNamesResult)that);
        }
        return false;
    }

    public boolean equals(GetPartitionsByNamesResult that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_partitions = this.isSetPartitions();
        boolean that_present_partitions = that.isSetPartitions();
        if (this_present_partitions || that_present_partitions) {
            if (!this_present_partitions || !that_present_partitions) {
                return false;
            }
            if (!this.partitions.equals(that.partitions)) {
                return false;
            }
        }
        boolean this_present_dictionary = this.isSetDictionary();
        boolean that_present_dictionary = that.isSetDictionary();
        if (this_present_dictionary || that_present_dictionary) {
            if (!this_present_dictionary || !that_present_dictionary) {
                return false;
            }
            if (!this.dictionary.equals(that.dictionary)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetPartitions() ? 131071 : 524287);
        if (this.isSetPartitions()) {
            hashCode = hashCode * 8191 + this.partitions.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDictionary() ? 131071 : 524287);
        if (this.isSetDictionary()) {
            hashCode = hashCode * 8191 + this.dictionary.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(GetPartitionsByNamesResult other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetPartitions(), other.isSetPartitions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitions() && (lastComparison = TBaseHelper.compareTo(this.partitions, other.partitions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDictionary(), other.isSetDictionary());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDictionary() && (lastComparison = TBaseHelper.compareTo(this.dictionary, other.dictionary)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        GetPartitionsByNamesResult.scheme(iprot).read(iprot, (GetPartitionsByNamesResult)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        GetPartitionsByNamesResult.scheme(oprot).write(oprot, (GetPartitionsByNamesResult)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GetPartitionsByNamesResult(");
        boolean first = true;
        sb.append("partitions:");
        if (this.partitions == null) {
            sb.append("null");
        } else {
            sb.append(this.partitions);
        }
        first = false;
        if (this.isSetDictionary()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("dictionary:");
            if (this.dictionary == null) {
                sb.append("null");
            } else {
                sb.append(this.dictionary);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetPartitions()) {
            throw new TProtocolException("Required field 'partitions' is unset! Struct:" + this.toString());
        }
        if (this.dictionary != null) {
            this.dictionary.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PARTITIONS, new FieldMetaData("partitions", 1, new ListMetaData(15, new StructMetaData(12, Partition.class))));
        tmpMap.put(_Fields.DICTIONARY, new FieldMetaData("dictionary", 2, new StructMetaData(12, ObjectDictionary.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(GetPartitionsByNamesResult.class, metaDataMap);
    }

    private static class GetPartitionsByNamesResultTupleScheme
    extends TupleScheme<GetPartitionsByNamesResult> {
        private GetPartitionsByNamesResultTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, GetPartitionsByNamesResult struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.partitions.size());
            for (Partition _iter750 : struct.partitions) {
                _iter750.write(oprot);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetDictionary()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetDictionary()) {
                struct.dictionary.write(oprot);
            }
        }

        @Override
        public void read(TProtocol prot, GetPartitionsByNamesResult struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TList _list751 = iprot.readListBegin((byte)12);
            struct.partitions = new ArrayList(_list751.size);
            for (int _i753 = 0; _i753 < _list751.size; ++_i753) {
                Partition _elem752 = new Partition();
                _elem752.read(iprot);
                struct.partitions.add(_elem752);
            }
            struct.setPartitionsIsSet(true);
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                struct.dictionary = new ObjectDictionary();
                struct.dictionary.read(iprot);
                struct.setDictionaryIsSet(true);
            }
        }
    }

    private static class GetPartitionsByNamesResultTupleSchemeFactory
    implements SchemeFactory {
        private GetPartitionsByNamesResultTupleSchemeFactory() {
        }

        public GetPartitionsByNamesResultTupleScheme getScheme() {
            return new GetPartitionsByNamesResultTupleScheme();
        }
    }

    private static class GetPartitionsByNamesResultStandardScheme
    extends StandardScheme<GetPartitionsByNamesResult> {
        private GetPartitionsByNamesResultStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, GetPartitionsByNamesResult struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list746 = iprot.readListBegin();
                            struct.partitions = new ArrayList(_list746.size);
                            for (int _i748 = 0; _i748 < _list746.size; ++_i748) {
                                Partition _elem747 = new Partition();
                                _elem747.read(iprot);
                                struct.partitions.add(_elem747);
                            }
                            iprot.readListEnd();
                            struct.setPartitionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.dictionary = new ObjectDictionary();
                            struct.dictionary.read(iprot);
                            struct.setDictionaryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, GetPartitionsByNamesResult struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.partitions != null) {
                oprot.writeFieldBegin(PARTITIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.partitions.size()));
                for (Partition _iter749 : struct.partitions) {
                    _iter749.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.dictionary != null && struct.isSetDictionary()) {
                oprot.writeFieldBegin(DICTIONARY_FIELD_DESC);
                struct.dictionary.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class GetPartitionsByNamesResultStandardSchemeFactory
    implements SchemeFactory {
        private GetPartitionsByNamesResultStandardSchemeFactory() {
        }

        public GetPartitionsByNamesResultStandardScheme getScheme() {
            return new GetPartitionsByNamesResultStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PARTITIONS(1, "partitions"),
        DICTIONARY(2, "dictionary");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PARTITIONS;
                }
                case 2: {
                    return DICTIONARY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

