/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hive.org.apache.thrift.TBase;
import org.apache.hive.org.apache.thrift.TBaseHelper;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.TFieldIdEnum;
import org.apache.hive.org.apache.thrift.annotation.Nullable;
import org.apache.hive.org.apache.thrift.meta_data.FieldMetaData;
import org.apache.hive.org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.hive.org.apache.thrift.meta_data.ListMetaData;
import org.apache.hive.org.apache.thrift.meta_data.MapMetaData;
import org.apache.hive.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hive.org.apache.thrift.protocol.TField;
import org.apache.hive.org.apache.thrift.protocol.TList;
import org.apache.hive.org.apache.thrift.protocol.TMap;
import org.apache.hive.org.apache.thrift.protocol.TProtocol;
import org.apache.hive.org.apache.thrift.protocol.TProtocolException;
import org.apache.hive.org.apache.thrift.protocol.TProtocolUtil;
import org.apache.hive.org.apache.thrift.protocol.TStruct;
import org.apache.hive.org.apache.thrift.protocol.TTupleProtocol;
import org.apache.hive.org.apache.thrift.scheme.IScheme;
import org.apache.hive.org.apache.thrift.scheme.SchemeFactory;
import org.apache.hive.org.apache.thrift.scheme.StandardScheme;
import org.apache.hive.org.apache.thrift.scheme.TupleScheme;
import org.apache.hive.org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ObjectDictionary
implements TBase<ObjectDictionary, _Fields>,
Serializable,
Cloneable,
Comparable<ObjectDictionary> {
    private static final TStruct STRUCT_DESC = new TStruct("ObjectDictionary");
    private static final TField VALUES_FIELD_DESC = new TField("values", 13, 1);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new ObjectDictionaryStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new ObjectDictionaryTupleSchemeFactory();
    @Nullable
    private Map<String, List<ByteBuffer>> values;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ObjectDictionary() {
    }

    public ObjectDictionary(Map<String, List<ByteBuffer>> values) {
        this();
        this.values = values;
    }

    public ObjectDictionary(ObjectDictionary other) {
        if (other.isSetValues()) {
            HashMap<String, List<ByteBuffer>> __this__values = new HashMap<String, List<ByteBuffer>>(other.values.size());
            for (Map.Entry<String, List<ByteBuffer>> other_element : other.values.entrySet()) {
                String other_element_key = other_element.getKey();
                List<ByteBuffer> other_element_value = other_element.getValue();
                String __this__values_copy_key = other_element_key;
                ArrayList<ByteBuffer> __this__values_copy_value = new ArrayList<ByteBuffer>(other_element_value);
                __this__values.put(__this__values_copy_key, __this__values_copy_value);
            }
            this.values = __this__values;
        }
    }

    @Override
    public ObjectDictionary deepCopy() {
        return new ObjectDictionary(this);
    }

    @Override
    public void clear() {
        this.values = null;
    }

    public int getValuesSize() {
        return this.values == null ? 0 : this.values.size();
    }

    public void putToValues(String key, List<ByteBuffer> val) {
        if (this.values == null) {
            this.values = new HashMap<String, List<ByteBuffer>>();
        }
        this.values.put(key, val);
    }

    @Nullable
    public Map<String, List<ByteBuffer>> getValues() {
        return this.values;
    }

    public void setValues(@Nullable Map<String, List<ByteBuffer>> values) {
        this.values = values;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public void setValuesIsSet(boolean value) {
        if (!value) {
            this.values = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case VALUES: {
                if (value == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((Map)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case VALUES: {
                return this.getValues();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case VALUES: {
                return this.isSetValues();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof ObjectDictionary) {
            return this.equals((ObjectDictionary)that);
        }
        return false;
    }

    public boolean equals(ObjectDictionary that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_values = this.isSetValues();
        boolean that_present_values = that.isSetValues();
        if (this_present_values || that_present_values) {
            if (!this_present_values || !that_present_values) {
                return false;
            }
            if (!this.values.equals(that.values)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetValues() ? 131071 : 524287);
        if (this.isSetValues()) {
            hashCode = hashCode * 8191 + this.values.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(ObjectDictionary other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetValues(), other.isSetValues());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValues() && (lastComparison = TBaseHelper.compareTo(this.values, other.values)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        ObjectDictionary.scheme(iprot).read(iprot, (ObjectDictionary)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        ObjectDictionary.scheme(oprot).write(oprot, (ObjectDictionary)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ObjectDictionary(");
        boolean first = true;
        sb.append("values:");
        if (this.values == null) {
            sb.append("null");
        } else {
            sb.append(this.values);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetValues()) {
            throw new TProtocolException("Required field 'values' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.VALUES, new FieldMetaData("values", 1, new MapMetaData(13, new FieldValueMetaData(11), new ListMetaData(15, new FieldValueMetaData(11, true)))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ObjectDictionary.class, metaDataMap);
    }

    private static class ObjectDictionaryTupleScheme
    extends TupleScheme<ObjectDictionary> {
        private ObjectDictionaryTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, ObjectDictionary struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.values.size());
            for (Map.Entry _iter343 : struct.values.entrySet()) {
                oprot.writeString((String)_iter343.getKey());
                oprot.writeI32(((List)_iter343.getValue()).size());
                for (ByteBuffer _iter344 : (List)_iter343.getValue()) {
                    oprot.writeBinary(_iter344);
                }
            }
        }

        @Override
        public void read(TProtocol prot, ObjectDictionary struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TMap _map345 = iprot.readMapBegin((byte)11, (byte)15);
            struct.values = new HashMap(2 * _map345.size);
            for (int _i348 = 0; _i348 < _map345.size; ++_i348) {
                String _key346 = iprot.readString();
                TList _list349 = iprot.readListBegin((byte)11);
                ArrayList<ByteBuffer> _val347 = new ArrayList<ByteBuffer>(_list349.size);
                for (int _i351 = 0; _i351 < _list349.size; ++_i351) {
                    ByteBuffer _elem350 = iprot.readBinary();
                    _val347.add(_elem350);
                }
                struct.values.put(_key346, _val347);
            }
            struct.setValuesIsSet(true);
        }
    }

    private static class ObjectDictionaryTupleSchemeFactory
    implements SchemeFactory {
        private ObjectDictionaryTupleSchemeFactory() {
        }

        public ObjectDictionaryTupleScheme getScheme() {
            return new ObjectDictionaryTupleScheme();
        }
    }

    private static class ObjectDictionaryStandardScheme
    extends StandardScheme<ObjectDictionary> {
        private ObjectDictionaryStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, ObjectDictionary struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 13) {
                            TMap _map334 = iprot.readMapBegin();
                            struct.values = new HashMap(2 * _map334.size);
                            for (int _i337 = 0; _i337 < _map334.size; ++_i337) {
                                String _key335 = iprot.readString();
                                TList _list338 = iprot.readListBegin();
                                ArrayList<ByteBuffer> _val336 = new ArrayList<ByteBuffer>(_list338.size);
                                for (int _i340 = 0; _i340 < _list338.size; ++_i340) {
                                    ByteBuffer _elem339 = iprot.readBinary();
                                    _val336.add(_elem339);
                                }
                                iprot.readListEnd();
                                struct.values.put(_key335, _val336);
                            }
                            iprot.readMapEnd();
                            struct.setValuesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, ObjectDictionary struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.values != null) {
                oprot.writeFieldBegin(VALUES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 15, struct.values.size()));
                for (Map.Entry _iter341 : struct.values.entrySet()) {
                    oprot.writeString((String)_iter341.getKey());
                    oprot.writeListBegin(new TList(11, ((List)_iter341.getValue()).size()));
                    for (ByteBuffer _iter342 : (List)_iter341.getValue()) {
                        oprot.writeBinary(_iter342);
                    }
                    oprot.writeListEnd();
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ObjectDictionaryStandardSchemeFactory
    implements SchemeFactory {
        private ObjectDictionaryStandardSchemeFactory() {
        }

        public ObjectDictionaryStandardScheme getScheme() {
            return new ObjectDictionaryStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VALUES(1, "values");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return VALUES;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

