/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.ISchemaName;
import org.apache.hive.org.apache.thrift.EncodingUtils;
import org.apache.hive.org.apache.thrift.TBase;
import org.apache.hive.org.apache.thrift.TBaseHelper;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.TFieldIdEnum;
import org.apache.hive.org.apache.thrift.annotation.Nullable;
import org.apache.hive.org.apache.thrift.meta_data.FieldMetaData;
import org.apache.hive.org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.hive.org.apache.thrift.meta_data.StructMetaData;
import org.apache.hive.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hive.org.apache.thrift.protocol.TField;
import org.apache.hive.org.apache.thrift.protocol.TProtocol;
import org.apache.hive.org.apache.thrift.protocol.TProtocolUtil;
import org.apache.hive.org.apache.thrift.protocol.TStruct;
import org.apache.hive.org.apache.thrift.protocol.TTupleProtocol;
import org.apache.hive.org.apache.thrift.scheme.IScheme;
import org.apache.hive.org.apache.thrift.scheme.SchemeFactory;
import org.apache.hive.org.apache.thrift.scheme.StandardScheme;
import org.apache.hive.org.apache.thrift.scheme.TupleScheme;
import org.apache.hive.org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SchemaVersionDescriptor
implements TBase<SchemaVersionDescriptor, _Fields>,
Serializable,
Cloneable,
Comparable<SchemaVersionDescriptor> {
    private static final TStruct STRUCT_DESC = new TStruct("SchemaVersionDescriptor");
    private static final TField SCHEMA_FIELD_DESC = new TField("schema", 12, 1);
    private static final TField VERSION_FIELD_DESC = new TField("version", 8, 2);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new SchemaVersionDescriptorStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new SchemaVersionDescriptorTupleSchemeFactory();
    @Nullable
    private ISchemaName schema;
    private int version;
    private static final int __VERSION_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public SchemaVersionDescriptor() {
    }

    public SchemaVersionDescriptor(ISchemaName schema, int version) {
        this();
        this.schema = schema;
        this.version = version;
        this.setVersionIsSet(true);
    }

    public SchemaVersionDescriptor(SchemaVersionDescriptor other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetSchema()) {
            this.schema = new ISchemaName(other.schema);
        }
        this.version = other.version;
    }

    @Override
    public SchemaVersionDescriptor deepCopy() {
        return new SchemaVersionDescriptor(this);
    }

    @Override
    public void clear() {
        this.schema = null;
        this.setVersionIsSet(false);
        this.version = 0;
    }

    @Nullable
    public ISchemaName getSchema() {
        return this.schema;
    }

    public void setSchema(@Nullable ISchemaName schema) {
        this.schema = schema;
    }

    public void unsetSchema() {
        this.schema = null;
    }

    public boolean isSetSchema() {
        return this.schema != null;
    }

    public void setSchemaIsSet(boolean value) {
        if (!value) {
            this.schema = null;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
        this.setVersionIsSet(true);
    }

    public void unsetVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetVersion() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case SCHEMA: {
                if (value == null) {
                    this.unsetSchema();
                    break;
                }
                this.setSchema((ISchemaName)value);
                break;
            }
            case VERSION: {
                if (value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((Integer)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case SCHEMA: {
                return this.getSchema();
            }
            case VERSION: {
                return this.getVersion();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case SCHEMA: {
                return this.isSetSchema();
            }
            case VERSION: {
                return this.isSetVersion();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof SchemaVersionDescriptor) {
            return this.equals((SchemaVersionDescriptor)that);
        }
        return false;
    }

    public boolean equals(SchemaVersionDescriptor that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_schema = this.isSetSchema();
        boolean that_present_schema = that.isSetSchema();
        if (this_present_schema || that_present_schema) {
            if (!this_present_schema || !that_present_schema) {
                return false;
            }
            if (!this.schema.equals(that.schema)) {
                return false;
            }
        }
        boolean this_present_version = true;
        boolean that_present_version = true;
        if (this_present_version || that_present_version) {
            if (!this_present_version || !that_present_version) {
                return false;
            }
            if (this.version != that.version) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetSchema() ? 131071 : 524287);
        if (this.isSetSchema()) {
            hashCode = hashCode * 8191 + this.schema.hashCode();
        }
        hashCode = hashCode * 8191 + this.version;
        return hashCode;
    }

    @Override
    public int compareTo(SchemaVersionDescriptor other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetSchema(), other.isSetSchema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchema() && (lastComparison = TBaseHelper.compareTo(this.schema, other.schema)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetVersion(), other.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVersion() && (lastComparison = TBaseHelper.compareTo(this.version, other.version)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        SchemaVersionDescriptor.scheme(iprot).read(iprot, (SchemaVersionDescriptor)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        SchemaVersionDescriptor.scheme(oprot).write(oprot, (SchemaVersionDescriptor)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SchemaVersionDescriptor(");
        boolean first = true;
        sb.append("schema:");
        if (this.schema == null) {
            sb.append("null");
        } else {
            sb.append(this.schema);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("version:");
        sb.append(this.version);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.schema != null) {
            this.schema.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.SCHEMA, new FieldMetaData("schema", 3, new StructMetaData(12, ISchemaName.class)));
        tmpMap.put(_Fields.VERSION, new FieldMetaData("version", 3, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(SchemaVersionDescriptor.class, metaDataMap);
    }

    private static class SchemaVersionDescriptorTupleScheme
    extends TupleScheme<SchemaVersionDescriptor> {
        private SchemaVersionDescriptorTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, SchemaVersionDescriptor struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetSchema()) {
                optionals.set(0);
            }
            if (struct.isSetVersion()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetSchema()) {
                struct.schema.write(oprot);
            }
            if (struct.isSetVersion()) {
                oprot.writeI32(struct.version);
            }
        }

        @Override
        public void read(TProtocol prot, SchemaVersionDescriptor struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.schema = new ISchemaName();
                struct.schema.read(iprot);
                struct.setSchemaIsSet(true);
            }
            if (incoming.get(1)) {
                struct.version = iprot.readI32();
                struct.setVersionIsSet(true);
            }
        }
    }

    private static class SchemaVersionDescriptorTupleSchemeFactory
    implements SchemeFactory {
        private SchemaVersionDescriptorTupleSchemeFactory() {
        }

        public SchemaVersionDescriptorTupleScheme getScheme() {
            return new SchemaVersionDescriptorTupleScheme();
        }
    }

    private static class SchemaVersionDescriptorStandardScheme
    extends StandardScheme<SchemaVersionDescriptor> {
        private SchemaVersionDescriptorStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, SchemaVersionDescriptor struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.schema = new ISchemaName();
                            struct.schema.read(iprot);
                            struct.setSchemaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.version = iprot.readI32();
                            struct.setVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, SchemaVersionDescriptor struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.schema != null) {
                oprot.writeFieldBegin(SCHEMA_FIELD_DESC);
                struct.schema.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(VERSION_FIELD_DESC);
            oprot.writeI32(struct.version);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class SchemaVersionDescriptorStandardSchemeFactory
    implements SchemeFactory {
        private SchemaVersionDescriptorStandardSchemeFactory() {
        }

        public SchemaVersionDescriptorStandardScheme getScheme() {
            return new SchemaVersionDescriptorStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        SCHEMA(1, "schema"),
        VERSION(2, "version");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return SCHEMA;
                }
                case 2: {
                    return VERSION;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

