/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hive.com.google.common.base.Preconditions;

public class TimestampLocalTZWritable
implements WritableComparable<TimestampLocalTZWritable> {
    public static final byte[] nullBytes = new byte[]{0, 0, 0, 0};
    private static final int DECIMAL_OR_SECOND_VINT_FLAG = Integer.MIN_VALUE;
    private static final long SEVEN_BYTE_LONG_SIGN_FLIP = -36028797018963968L;
    public static final int MAX_BYTES = 13;
    public static final int BINARY_SORTABLE_LENGTH = 11;
    private TimestampTZ timestampTZ = new TimestampTZ();
    private ZoneId timeZone;
    private boolean bytesEmpty = true;
    private boolean timestampTZEmpty = true;
    private byte[] currentBytes;
    private final byte[] internalBytes = new byte[13];
    private byte[] externalBytes;
    private int offset;

    public TimestampLocalTZWritable() {
        this.bytesEmpty = false;
        this.currentBytes = this.internalBytes;
        this.offset = 0;
    }

    public TimestampLocalTZWritable(byte[] bytes, int offset, ZoneId timeZone) {
        this.set(bytes, offset, timeZone);
    }

    public TimestampLocalTZWritable(TimestampLocalTZWritable other) {
        this(other.getBytes(), 0, other.getTimestampTZ().getZonedDateTime().getZone());
    }

    public TimestampLocalTZWritable(TimestampTZ tstz) {
        this.set(tstz);
    }

    public void set(byte[] bytes, int offset, ZoneId timeZone) {
        this.externalBytes = bytes;
        this.offset = offset;
        this.timeZone = timeZone;
        this.bytesEmpty = false;
        this.timestampTZEmpty = true;
        this.currentBytes = this.externalBytes;
    }

    public void set(TimestampTZ tstz) {
        if (tstz == null) {
            this.timestampTZ.setZonedDateTime(null);
            return;
        }
        this.timestampTZ.setZonedDateTime(tstz.getZonedDateTime());
        this.timeZone = this.timestampTZ.getZonedDateTime().getZone();
        this.bytesEmpty = true;
        this.timestampTZEmpty = false;
    }

    public void set(TimestampLocalTZWritable t) {
        if (t.bytesEmpty) {
            this.set(t.getTimestampTZ());
        } else if (t.currentBytes == t.externalBytes) {
            this.set(t.currentBytes, t.offset, t.timeZone);
        } else {
            this.set(t.currentBytes, 0, t.timeZone);
        }
    }

    public void setTimeZone(ZoneId timeZone) {
        if (this.timestampTZ != null) {
            this.timestampTZ.setZonedDateTime(this.timestampTZ.getZonedDateTime().withZoneSameInstant(timeZone));
        }
        this.timeZone = timeZone;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public TimestampTZ getTimestampTZ() {
        this.populateTimestampTZ();
        return new TimestampTZ(this.timestampTZ.getZonedDateTime());
    }

    public byte[] getBytes() {
        this.checkBytes();
        int len = this.getTotalLength();
        byte[] b = new byte[len];
        System.arraycopy(this.currentBytes, this.offset, b, 0, len);
        return b;
    }

    private int getTotalLength() {
        this.checkBytes();
        return TimestampLocalTZWritable.getTotalLength(this.currentBytes, this.offset);
    }

    private void checkBytes() {
        if (this.bytesEmpty) {
            this.populateBytes();
            this.offset = 0;
            this.currentBytes = this.internalBytes;
            this.bytesEmpty = false;
        }
    }

    private void populateBytes() {
        Arrays.fill(this.internalBytes, (byte)0);
        long seconds = this.timestampTZ.getEpochSecond();
        int nanos = this.timestampTZ.getNanos();
        boolean hasSecondVInt = seconds < 0L || seconds > Integer.MAX_VALUE;
        boolean hasDecimal = TimestampLocalTZWritable.setNanosBytes(nanos, this.internalBytes, this.offset + 4, hasSecondVInt);
        int firstInt = (int)seconds;
        if (hasDecimal || hasSecondVInt) {
            firstInt |= Integer.MIN_VALUE;
        }
        TimestampLocalTZWritable.intToBytes(firstInt, this.internalBytes, this.offset);
        if (hasSecondVInt) {
            LazyBinaryUtils.writeVLongToByteArray(this.internalBytes, this.offset + 4 + WritableUtils.decodeVIntSize(this.internalBytes[this.offset + 4]), seconds >> 31);
        }
    }

    private void populateTimestampTZ() {
        if (this.timestampTZEmpty) {
            if (this.bytesEmpty) {
                throw new IllegalStateException("Bytes are empty");
            }
            long seconds = TimestampLocalTZWritable.getSeconds(this.currentBytes, this.offset);
            int nanos = TimestampLocalTZWritable.hasDecimalOrSecondVInt(this.currentBytes[this.offset]) ? TimestampLocalTZWritable.getNanos(this.currentBytes, this.offset + 4) : 0;
            this.timestampTZ.set(seconds, nanos, this.timeZone);
            this.timestampTZEmpty = false;
        }
    }

    public long getSeconds() {
        if (!this.timestampTZEmpty) {
            return this.timestampTZ.getEpochSecond();
        }
        if (!this.bytesEmpty) {
            return TimestampLocalTZWritable.getSeconds(this.currentBytes, this.offset);
        }
        throw new IllegalStateException("Both timestamp and bytes are empty");
    }

    public double getMicros() {
        double nanos;
        double seconds;
        if (this.bytesEmpty) {
            seconds = this.timestampTZ.getEpochSecond();
            nanos = this.timestampTZ.getNanos();
        } else {
            seconds = this.getSeconds();
            nanos = this.getNanos();
        }
        return seconds * 1000000.0 + nanos / 1000.0;
    }

    public int getNanos() {
        if (!this.timestampTZEmpty) {
            return this.timestampTZ.getNanos();
        }
        if (!this.bytesEmpty) {
            return TimestampLocalTZWritable.hasDecimalOrSecondVInt(this.currentBytes[this.offset]) ? TimestampLocalTZWritable.getNanos(this.currentBytes, this.offset + 4) : 0;
        }
        throw new IllegalStateException("Both timestamp and bytes are empty");
    }

    @Override
    public int compareTo(TimestampLocalTZWritable o) {
        return this.getTimestampTZ().compareTo(o.getTimestampTZ());
    }

    public boolean equals(Object o) {
        if (o instanceof TimestampLocalTZWritable) {
            return this.compareTo((TimestampLocalTZWritable)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getTimestampTZ().hashCode();
    }

    public String toString() {
        this.populateTimestampTZ();
        return this.timestampTZ.toString();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        this.checkBytes();
        dataOutput.write(this.currentBytes, this.offset, this.getTotalLength());
    }

    @Override
    public void readFields(DataInput dataInput) throws IOException {
        dataInput.readFully(this.internalBytes, 0, 4);
        if (TimestampLocalTZWritable.hasDecimalOrSecondVInt(this.internalBytes[0])) {
            long vlong;
            dataInput.readFully(this.internalBytes, 4, 1);
            byte len = (byte)WritableUtils.decodeVIntSize(this.internalBytes[4]);
            if (len > 1) {
                dataInput.readFully(this.internalBytes, 5, len - 1);
            }
            Preconditions.checkState((vlong = LazyBinaryUtils.readVLongFromByteArray(this.internalBytes, 4)) >= -1000000000L && vlong <= 999999999L, "Invalid nanos value for a TimestampTZWritable: " + vlong + ", expected to be between -1000000000 and 999999999.");
            if (vlong < 0L) {
                dataInput.readFully(this.internalBytes, 4 + len, 1);
                byte secondVIntLen = (byte)WritableUtils.decodeVIntSize(this.internalBytes[4 + len]);
                if (secondVIntLen > 1) {
                    dataInput.readFully(this.internalBytes, 5 + len, secondVIntLen - 1);
                }
            }
        }
        this.currentBytes = this.internalBytes;
        this.offset = 0;
        this.timestampTZEmpty = true;
        this.bytesEmpty = false;
    }

    public byte[] toBinarySortable() {
        byte[] b = new byte[11];
        int nanos = this.getNanos();
        long seconds = this.getSeconds() ^ 0xFF80000000000000L;
        TimestampLocalTZWritable.sevenByteLongToBytes(seconds, b, 0);
        TimestampLocalTZWritable.intToBytes(nanos, b, 7);
        return b;
    }

    public void fromBinarySortable(byte[] bytes, int binSortOffset, ZoneId timeZone) {
        long seconds = TimestampLocalTZWritable.readSevenByteLong(bytes, binSortOffset) ^ 0xFF80000000000000L;
        int nanos = TimestampLocalTZWritable.bytesToInt(bytes, binSortOffset + 7);
        this.timestampTZ.set(seconds, nanos, timeZone);
        this.timestampTZEmpty = false;
        this.bytesEmpty = true;
    }

    public void writeToByteStream(ByteStream.RandomAccessOutput byteStream) {
        this.checkBytes();
        byteStream.write(this.currentBytes, this.offset, this.getTotalLength());
    }

    private static boolean setNanosBytes(int nanos, byte[] b, int offset, boolean hasSecondVInt) {
        int decimal = 0;
        if (nanos != 0) {
            for (int counter = 0; counter < 9; ++counter) {
                decimal *= 10;
                decimal += nanos % 10;
                nanos /= 10;
            }
        }
        if (hasSecondVInt || decimal != 0) {
            LazyBinaryUtils.writeVLongToByteArray(b, offset, hasSecondVInt ? (long)(-decimal - 1) : (long)decimal);
        }
        return decimal != 0;
    }

    public static void setTimestampTZ(TimestampTZ t, byte[] bytes, int offset, ZoneId timeZone) {
        long seconds = TimestampLocalTZWritable.getSeconds(bytes, offset);
        int nanos = TimestampLocalTZWritable.hasDecimalOrSecondVInt(bytes[offset]) ? TimestampLocalTZWritable.getNanos(bytes, offset + 4) : 0;
        t.set(seconds, nanos, timeZone);
    }

    public static int getTotalLength(byte[] bytes, int offset) {
        int len = 4;
        if (TimestampLocalTZWritable.hasDecimalOrSecondVInt(bytes[offset])) {
            int firstVIntLen = WritableUtils.decodeVIntSize(bytes[offset + 4]);
            len += firstVIntLen;
            if (TimestampLocalTZWritable.hasSecondVInt(bytes[offset + 4])) {
                len += WritableUtils.decodeVIntSize(bytes[offset + 4 + firstVIntLen]);
            }
        }
        return len;
    }

    public static long getSeconds(byte[] bytes, int offset) {
        int firstVInt = TimestampLocalTZWritable.bytesToInt(bytes, offset);
        if (firstVInt >= 0 || !TimestampLocalTZWritable.hasSecondVInt(bytes[offset + 4])) {
            return firstVInt & Integer.MAX_VALUE;
        }
        return (long)(firstVInt & Integer.MAX_VALUE) | LazyBinaryUtils.readVLongFromByteArray(bytes, offset + 4 + WritableUtils.decodeVIntSize(bytes[offset + 4])) << 31;
    }

    public static int getNanos(byte[] bytes, int offset) {
        int val = (int)LazyBinaryUtils.readVLongFromByteArray(bytes, offset);
        if (val < 0) {
            val = -val - 1;
        }
        int len = (int)Math.floor(Math.log10(val)) + 1;
        int tmp = 0;
        while (val != 0) {
            tmp *= 10;
            tmp += val % 10;
            val /= 10;
        }
        val = tmp;
        if (len < 9) {
            val = (int)((double)val * Math.pow(10.0, 9 - len));
        }
        return val;
    }

    private static boolean hasDecimalOrSecondVInt(byte b) {
        return b < 0;
    }

    private static boolean hasSecondVInt(byte b) {
        return WritableUtils.isNegativeVInt(b);
    }

    private static void intToBytes(int value, byte[] dest, int offset) {
        dest[offset] = (byte)(value >> 24 & 0xFF);
        dest[offset + 1] = (byte)(value >> 16 & 0xFF);
        dest[offset + 2] = (byte)(value >> 8 & 0xFF);
        dest[offset + 3] = (byte)(value & 0xFF);
    }

    private static void sevenByteLongToBytes(long value, byte[] dest, int offset) {
        dest[offset] = (byte)(value >> 48 & 0xFFL);
        dest[offset + 1] = (byte)(value >> 40 & 0xFFL);
        dest[offset + 2] = (byte)(value >> 32 & 0xFFL);
        dest[offset + 3] = (byte)(value >> 24 & 0xFFL);
        dest[offset + 4] = (byte)(value >> 16 & 0xFFL);
        dest[offset + 5] = (byte)(value >> 8 & 0xFFL);
        dest[offset + 6] = (byte)(value & 0xFFL);
    }

    private static int bytesToInt(byte[] bytes, int offset) {
        return (0xFF & bytes[offset]) << 24 | (0xFF & bytes[offset + 1]) << 16 | (0xFF & bytes[offset + 2]) << 8 | 0xFF & bytes[offset + 3];
    }

    private static long readSevenByteLong(byte[] bytes, int offset) {
        return ((0xFFL & (long)bytes[offset]) << 56 | (0xFFL & (long)bytes[offset + 1]) << 48 | (0xFFL & (long)bytes[offset + 2]) << 40 | (0xFFL & (long)bytes[offset + 3]) << 32 | (0xFFL & (long)bytes[offset + 4]) << 24 | (0xFFL & (long)bytes[offset + 5]) << 16 | (0xFFL & (long)bytes[offset + 6]) << 8) >> 8;
    }
}

