/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.thrift;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.thrift.TReflectionUtils;
import org.apache.hadoop.hive.serde2.thrift.ThriftByteStreamTypedSerDe;
import org.apache.hadoop.io.Writable;
import org.apache.hive.org.apache.thrift.protocol.TProtocolFactory;

public class ThriftDeserializer
extends AbstractSerDe {
    private ThriftByteStreamTypedSerDe tsd;

    @Override
    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        try {
            String className = this.properties.getProperty("serialization.class");
            Class<?> recordClass = configuration.getClassByName(className);
            String protoName = this.properties.getProperty("serialization.format");
            if (protoName == null) {
                protoName = "TBinaryProtocol";
            }
            protoName = protoName.replace("org.apache.hive.com.facebook.thrift.protocol", "org.apache.hive.org.apache.thrift.protocol");
            TProtocolFactory tp = TReflectionUtils.getProtocolFactoryByName(protoName);
            this.tsd = new ThriftByteStreamTypedSerDe(recordClass, tp, tp);
        }
        catch (Exception e) {
            throw new SerDeException(e);
        }
    }

    @Override
    public Object deserialize(Writable field) throws SerDeException {
        return this.tsd.deserialize(field);
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.tsd.getObjectInspector();
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return null;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new UnsupportedOperationException();
    }
}

